/*----------------------------------------------------------------------
| pair.h
|
| This file contains forward declarations for pair.cpp
| 
|  Copyright 2021 Mersenne Research, Inc.
|  All Rights Reserved.
+---------------------------------------------------------------------*/

#ifndef _PAIR_H
#define _PAIR_H

void estimate_pairing (
	int	second_missing_prime,
	uint64_t B1,
	uint64_t B2,
	int	totrels,
	int	numrels,
	float	*pair_pct,
	float	*timing);

uint64_t estimate_max_pairmap_Dsections (
	double	max_pairmap_size,	/* Maximum size of the pairing map */
	uint64_t numDsections,		/* Number of Dsections */
	double	est_numpairs);		/* Estimated number of prime pairs plus singles */

int fill_pairmap (			/* Generate a pairing map */
	int	thread_num,		/* For outputting informative messages */
	void	**sieve_info,		/* Prime number sieve to use / initialize */
	int	D,			/* Calculated by best_stage2_impl, best D value ("big step") */
	int	WINDOW_SIZE,		/* Size (in number of D values) of the prime window.  Use zero for non-windowed pairing (slower but optimal). */
	int	ALT_D,			/* Calculated by best_stage2_impl, best additional D value (if any) */
	int	ALT_D_OFFSET,		/* Calculated by best_stage2_impl, best additional D value "offset" (if any) */
	int	ALT_MORE_RELPS,		/* Calculated by best_stage2_impl, include relative primes divisible by this value in support of additional D value */
	int	totrels,		/* Calculated by best_stage2_impl, number of relative primes to use for pairing */
	int16_t	*relp_sets,		/* Which non-contiguous sets of relative primes to use */		
	uint64_t first_relocatable,	/* First relocatable prime (same as B1 unless pairmap must be split or mem change caused a replan) */
	uint64_t last_relocatable,	/* End of relocatable primes (same as B2_start unless a change in available memory caused a new stage 2 plan) */
	uint64_t B2_start,		/* First D section to place in the pairmap (set to B2_start for first pairmap) */
	uint64_t B2,			/* Bound #2, end sieving for primes here */
	uint64_t max_pairmap_Dsections,	/* Number of D sections that can fit in a pairing map */
	uint8_t	**pairmap,		/* Returned pointer to a pairing map that is allocated here */
	uint64_t *pairmap_size);	/* Returned size of the pairing map */

uint32_t next_pair (			/* Returns distance to next prime pairing (or single) */
	uint8_t	**pairmap_ptr);		/* Current pointer into the pairing map generated by fill_pairmap -- this will be modified */

#endif
