/*
This file is part of mfaktc.
Copyright (C) 2013, 2015  Oliver Weihe (o.weihe@t-online.de)
                          Bertram Franz (bertramf@gmx.net)

mfaktc is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mfaktc is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY },   without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                
You should have received a copy of the GNU General Public License
along with mfaktc.  If not, see <http://www.gnu.org/licenses/>.
*/

typedef struct _test_set {
    unsigned int exp;
    unsigned int bit_min;
    unsigned long long int k;
} test_set;

// generated out of the previous header file by
// sed -e s'/^exp\[[ 0-9]*\]=/  { /' -e s'/; bit_min\[[ 0-9]*\]=/, /'  -e s'/; k\[[ 0-9]*\]=/, /' -e s'/;/ },  /' [...]
static test_set st_data[] = {
    { 6100483, 25,                       3 }, // W6100483 has a factor: 36602899
    { 6100483, 29,                      63 }, // W6100483 has a factor: 768660859
    { 6050381, 23,                       1 }, // W6050381 has a factor: 12100763
    { 6050381, 48,                31886385 }, // W6050381 has a factor: 385849555925371
    { 6050381, 53,              1339768561 }, // W6050381 has a factor: 16212220491743483
    { 9100381, 68,       16336676371449ULL }, // M9100381 has a factor: 297339958507766844139
    { 9100547, 74,     1112910544310047ULL }, // M9100547 has a factor: 20256189430578330591419
    { 9100859, 85,  2620053195900737751ULL }, // M9100859 has a factor: 47689469416783984535656219
    { 9101471, 62,         359619885799ULL }, // M9101471 has a factor: 6546139923245820659
    { 9101797, 78,    26898879820266489ULL }, // M9101797 has a factor: 489656287302924137561467
    { 9101819, 63,        1007045561584ULL }, // M9101819 has a factor: 18331892852581842593
    { 9101839, 66,        6336192753296ULL }, // M9101839 has a factor: 115342012626933822689
    { 9102047, 79,    58066818653417760ULL }, // M9102047 has a factor: 1057053825047770324309441
    { 9102193, 64,        1715718001637ULL }, // M9102193 has a factor: 31233592768948579883
    { 9103657, 65,        3327589758768ULL }, // M9103657 has a factor: 60586471601073229153
    { 9103981, 75,     3924194124766509ULL }, // M9103981 has a factor: 71451577504371854744659
    { 9104327, 81,   225091607383815183ULL }, // M9104327 has a factor: 4098615197155735867193683
    { 9104507, 70,      127334260340160ULL }, // M9104507 has a factor: 2318631329213618202241
    { 9104791, 63,         771886918428ULL }, // M9104791 has a factor: 14055738135841977097
    { 9105203, 85,  2917291910461617987ULL }, // M9105203 has a factor: 53125070110021710960172723
    { 9105281, 72,      427100840238825ULL }, // M9105281 has a factor: 7777746331421217469651
    { 9105301, 69,       39784750418484ULL }, // M9105301 has a factor: 724504255540345567369
    { 9105491, 86,  4632667367139777880ULL }, // M9105491 has a factor: 84365422034969886456678161
    { 9105553, 72,      455671407709592ULL }, // M9105553 has a factor: 8298280306968597128753
    { 9106189, 64,        1234409613165ULL }, // M9106189 has a factor: 22481534481794756371
    { 9106607, 63,         600247113600ULL }, // M9106607 has a factor: 10932429132879110401
    { 9119023, 61,         127432480740ULL }, // M9119023 has a factor: 2324119445630234041
    { 8791493, 61,         132317206857ULL }, // M8791493 has a factor: 2326531595725735003
    { 8785009, 61,         133028177892ULL }, // M8785009 has a factor: 2337307480069642057
    { 8773903, 61,         134233649420ULL }, // M8773903 has a factor: 2355506038694172521
    { 9025241, 61,         131385231100ULL }, // M9025241 has a factor: 2371566749036390201
    { 8759557, 61,         135808862760ULL }, // M8759557 has a factor: 2379250948902794641
    { 8076011, 61,         147487281579ULL }, // M8076011 has a factor: 2382217816784202739
    { 8829617, 61,         135917763253ULL }, // M8829617 has a factor: 2400203586041328203
    { 9043919, 61,         133106066727ULL }, // M9043919 has a factor: 2407600971775166227
    { 8816837, 61,         136617057717ULL }, // M8816837 has a factor: 2409060658620762259
    { 8087351, 61,         149177944228ULL }, // M8087351 has a factor: 2412908792860520057
    { 8335549, 61,         144905731100ULL }, // M8335549 has a factor: 2415737643929747801
    { 9030121, 61,         134277986429ULL }, // M9030121 has a factor: 2425092930180455819
    { 8024437, 61,         151365521328ULL }, // M8024437 has a factor: 2429246179737384673
    { 8806843, 61,         138245287275ULL }, // M8806843 has a factor: 2435009081041645651
    { 9045229, 61,         135418683272ULL }, // M9045229 has a factor: 2449786002147418577
    { 8923921, 61,         137284426376ULL }, // M8923921 has a factor: 2450230751019480593
    { 9094703, 61,         134964524160ULL }, // M9094703 has a factor: 2454924525543048961
    { 8087281, 61,         152661506549ULL }, // M8087281 has a factor: 2469233002690206539
    { 9015137, 61,         137398959277ULL }, // M9015137 has a factor: 2477340883079151899
    { 8106523, 61,         153481918568ULL }, // M8106523 has a factor: 2488409405911238129
    { 8866003, 61,         140900682252ULL }, // M8866003 has a factor: 2498451743096557513
    { 8104337, 61,         154177375477ULL }, // M8104337 has a factor: 2499010817282287499
    { 8881589, 61,         140785017477ULL }, // M8881589 has a factor: 2500789325177061907
    { 9110429, 61,         139130685952ULL }, // M9110429 has a factor: 2535080472173986817
    { 8773759, 61,         146625608051ULL }, // M8773759 has a factor: 2572915496535867419
    { 8980931, 61,         144393493843ULL }, // M8980931 has a factor: 2593576010105815667
    { 9084469, 61,         143205249384ULL }, // M9084469 has a factor: 2601887297332434193
    { 9113719, 61,         143227544339ULL }, // M9113719 has a factor: 2610671184331373483
    { 8139959, 61,         160797557635ULL }, // M8139959 has a factor: 2617771052898073931
    { 8801083, 61,         149502976028ULL }, // M8801083 has a factor: 2631576201538876649
    { 8013263, 61,         164313292695ULL }, // M8013263 has a factor: 2633371257522027571
    { 8783191, 61,         150608706119ULL }, // M8783191 has a factor: 2645650064212091459
    { 9020633, 61,         146712087457ULL }, // M9020633 has a factor: 2646871795227000563
    { 8857003, 61,         149556196655ULL }, // M8857003 has a factor: 2649239364883849931
    { 9133681, 61,         146183193948ULL }, // M9133681 has a factor: 2670381322164325177
    { 8327521, 61,         160454433536ULL }, // M8327521 has a factor: 2672375329628288513
    { 9138523, 61,         146960494320ULL }, // M9138523 has a factor: 2686003714869378721
    { 8242337, 61,         163013279580ULL }, // M8242337 has a factor: 2687220771547156921
    { 8970421, 61,         150161585540ULL }, // M8970421 has a factor: 2694025280642624681
    { 9126197, 61,         147984277969ULL }, // M9126197 has a factor: 2701067347295707787
    { 8949167, 61,         151495592395ULL }, // M8949167 has a factor: 2711518712213569931
    { 9081203, 61,         149988791928ULL }, // M9081203 has a factor: 2724157334445858769
    { 8772947, 61,         156327829195ULL }, // M8772947 has a factor: 2742911520305575331
    { 8330779, 61,         164952750231ULL }, // M8330779 has a factor: 2748369815233319899
    { 8283397, 61,         166022202024ULL }, // M8283397 has a factor: 2750455620357991057
    { 9114337, 61,         150952329765ULL }, // M9114337 has a factor: 2751660808826681611
    { 8737693, 61,         157659919233ULL }, // M8737693 has a factor: 2755167945325498939
    { 9125951, 61,         151340015620ULL }, // M9125951 has a factor: 2762243133774709241
    { 8252219, 61,         167580417616ULL }, // M8252219 has a factor: 2765820612557379809
    { 9058111, 61,         153006409215ULL }, // M9058111 has a factor: 2771898076761785731
    { 8018221, 61,         173018065985ULL }, // M8018221 has a factor: 2774594180120625371
    { 8765797, 61,         158289497108ULL }, // M8765797 has a factor: 2775067197761630153
    { 8823751, 61,         157589483220ULL }, // M8823751 has a factor: 2781060720303916441
    { 8229619, 61,         169430751524ULL }, // M8229619 has a factor: 2788701063852378713
    { 8016133, 61,         174671646896ULL }, // M8016133 has a factor: 2800382305694746337
    { 8074123, 61,         174785705600ULL }, // M8074123 has a factor: 2822482571312377601
    { 8907917, 61,         158658996325ULL }, // M8907917 has a factor: 2826642341132810051
    { 8080847, 61,         174949963615ULL }, // M8080847 has a factor: 2827487777256763811
    { 8838199, 61,         160208980172ULL }, // M8838199 has a factor: 2831917696694380457
    { 8943719, 61,         158679851464ULL }, // M8943719 has a factor: 2838376004911509233
    { 8348629, 61,         171177883932ULL }, // M8348629 has a factor: 2858201291906658457
    { 9197791, 61,         155922908439ULL }, // M9197791 has a factor: 2868292647868116499
    { 8733059, 61,         164239527132ULL }, // M8733059 has a factor: 2868626961151713577
    { 8065129, 61,         178204576385ULL }, // M8065129 has a factor: 2874485793870757331
    { 8969993, 61,         160816600116ULL }, // M8969993 has a factor: 2885047554648638377
    { 8749813, 61,         165541941812ULL }, // M8749813 has a factor: 2896922069023762313
    { 8151113, 61,         179105153553ULL }, // M8151113 has a factor: 2919812690985708979
    { 8238817, 61,         177315981333ULL }, // M8238817 has a factor: 2921747842756006123
    { 8707537, 61,         168548958945ULL }, // M8707537 has a factor: 2935292592650136931
    { 8108293, 61,         181395019956ULL }, // M8108293 has a factor: 2941607941088190217
    { 8847659, 61,         166309172835ULL }, // M8847659 has a factor: 2942893699632286531
    { 8030567, 61,         184971700879ULL }, // M8030567 has a factor: 2970855274025536787
    { 8925023, 61,         168713267631ULL }, // M8925023 has a factor: 3011539588023661027
    { 8806879, 61,         171168361595ULL }, // M8806879 has a factor: 3014918098390824011
    { 9065839, 61,         166786436787ULL }, // M9065839 has a factor: 3024117966589238587
    { 8996903, 61,         168348893308ULL }, // M8996903 has a factor: 3029237326498850249
    { 8097521, 61,         187198634853ULL }, // M8097521 has a factor: 3031689753786998827
    { 8153191, 61,         186288807764ULL }, // M8153191 has a factor: 3037696461724349849
    { 8356597, 61,         183567148557ULL }, // M8356597 has a factor: 3067993365859961059
    { 8879807, 61,         173072720560ULL }, // M8879807 has a factor: 3073704711075463841
    { 8208359, 61,         187835633532ULL }, // M8208359 has a factor: 3083644626046187977
    { 8817821, 61,         175115450641ULL }, // M8817821 has a factor: 3088273396173346523
    { 8065081, 61,         191654721276ULL }, // M8065081 has a factor: 3091421702246726713
    { 8853079, 61,         174982103175ULL }, // M8853079 has a factor: 3098260765988851651
    { 8108297, 61,         191721151000ULL }, // M8108297 has a factor: 3109064066979694001
    { 8719801, 61,         178439016440ULL }, // M8719801 has a factor: 3111905427985056881
    { 8734079, 61,         178822094664ULL }, // M8734079 has a factor: 3123692603481708913
    { 9075851, 61,         172228282396ULL }, // M9075851 has a factor: 3126236458024037993
    { 8285461, 61,         189145874148ULL }, // M8285461 has a factor: 3134321527128324457
    { 8826809, 61,         177762367737ULL }, // M8826809 has a factor: 3138148934804522467
    { 8123897, 61,         193363105089ULL }, // M8123897 has a factor: 3141723898686423667
    { 9024299, 61,         175051037320ULL }, // M9024299 has a factor: 3159425802071677361
    { 8248069, 61,         191528751869ULL }, // M8248069 has a factor: 3159484721798781923
    { 8916539, 61,         177778447476ULL }, // M8916539 has a factor: 3170336920558411129
    { 8040257, 61,         200635867068ULL }, // M8040257 has a factor: 3226327869289112953
    { 9134717, 61,         178267238188ULL }, // M9134717 has a factor: 3256841542437945593
    { 9190157, 61,         177699261412ULL }, // M9190157 has a factor: 3266168222320643369
    { 8042659, 61,         203367144036ULL }, // M8042659 has a factor: 3271225182570863449
    { 8195543, 61,         200014545291ULL }, // M8195543 has a factor: 3278455613115676027
    { 8704433, 61,         190625414280ULL }, // M8704433 has a factor: 3318572293395006481
    { 8817163, 61,         188568687311ULL }, // M8817163 has a factor: 3325281705434237387
    { 8738881, 61,         190371749349ULL }, // M8738881 has a factor: 3327272126645476939
    { 9032489, 61,         185022094401ULL }, // M9032489 has a factor: 3342420064867988179
    { 8134099, 61,         206924460512ULL }, // M8134099 has a factor: 3366288094652397377
    { 9014059, 61,         188379616152ULL }, // M9014059 has a factor: 3396129948782961937
    { 8973067, 61,         189401223887ULL }, // M8973067 has a factor: 3399019743640102859
    { 8950553, 61,         190830845785ULL }, // M8950553 has a factor: 3416083198466938211
    { 8093429, 61,         211291485657ULL }, // M8093429 has a factor: 3420145274938895707
    { 8147351, 61,         210011218728ULL }, // M8147351 has a factor: 3422070225829579057
    { 9132131, 61,         189384006216ULL }, // M9132131 has a factor: 3458959108138652593
    { 8718779, 61,         198438031191ULL }, // M8718779 has a factor: 3460274678298871579
    { 9012967, 61,         193741710167ULL }, // M9012967 has a factor: 3492375280517470979
    { 8310551, 61,         210632714608ULL }, // M8310551 has a factor: 3500947834036458017
    { 8889833, 61,         198943371396ULL }, // M8889833 has a factor: 3537146696334833737
    { 8814797, 61,         201241169968ULL }, // M8814797 has a factor: 3547800122620832993
    { 9023111, 61,         198094501860ULL }, // M9023111 has a factor: 3574857357544972921
    { 8772937, 61,         203820227325ULL }, // M8772937 has a factor: 3576204027295807051
    { 8709007, 61,         208718995779ULL }, // M8709007 has a factor: 3635470390544562907
    { 9009163, 61,         201790471835ULL }, // M9009163 has a factor: 3635926505216848211
    { 8231413, 61,         221068004217ULL }, // M8231413 has a factor: 3639404087591737243
    { 8106377, 61,         225294333313ULL }, // M8106377 has a factor: 3652641603597674003
    { 8948969, 61,         206576898516ULL }, // M8948969 has a factor: 3697300521871660009
    { 8951779, 61,         207148860971ULL }, // M8951779 has a factor: 3708701647028234819
    { 8340679, 61,         223311218684ULL }, // M8340679 has a factor: 3725134384284092873
    { 8804867, 61,         211656601624ULL }, // M8804867 has a factor: 3727216453942608017
    { 8967199, 61,         210152706635ULL }, // M8967199 has a factor: 3768962281569330731
    { 8170223, 61,         230847711367ULL }, // M8170223 has a factor: 3772154561816049683
    { 8949637, 61,         211071433820ULL }, // M8949637 has a factor: 3778025427517046681
    { 8740951, 61,         216857295435ULL }, // M8740951 has a factor: 3791077986779717371
    { 8238877, 61,         231161602905ULL }, // M8238877 has a factor: 3809024026914275371
    { 8813383, 61,         216140284808ULL }, // M8813383 has a factor: 3809854223483970929
    { 8274659, 61,         231048318864ULL }, // M8274659 has a factor: 3823692102245734753
    { 8082631, 61,         238494735231ULL }, // M8082631 has a factor: 3855329880629745523
    { 8998189, 61,         216217689716ULL }, // M8998189 has a factor: 3891135274415848649
    { 8277359, 61,         235905364236ULL }, // M8277359 has a factor: 3905346779614265449
    { 8929933, 61,         220928092460ULL }, // M8929933 has a factor: 3945746126971210361
    { 8101019, 61,         243767688964ULL }, // M8101019 has a factor: 3949533359766908633
    { 8846027, 61,         223446416944ULL }, // M8846027 has a factor: 3953226074679762977
    { 8022041, 61,         246533711160ULL }, // M8022041 has a factor: 3955407077615355121
    { 9024413, 61,         220667528973ULL }, // M9024413 has a factor: 3982789834283635699
    { 8772233, 61,         227618764053ULL }, // M8772233 has a factor: 3993449666889880699
    { 8704123, 61,         231475786560ULL }, // M8704123 has a factor: 4029587435479973761
    { 8307361, 61,         242749056305ULL }, // M8307361 has a factor: 4033208086269922211
    { 8320063, 61,         244152885548ULL }, // M8320063 has a factor: 4062734778782299049
    { 8780389, 61,         233996997345ULL }, // M8780389 has a factor: 4109169323042134411
    { 8836859, 61,         232588181160ULL }, // M8836859 has a factor: 4110697923954752881
    { 9022001, 61,         228604943200ULL }, // M9022001 has a factor: 4124948052310686401
    { 8238809, 61,         252012765169ULL }, // M8238809 has a factor: 4152570075578487443
    { 9094979, 61,         229922804095ULL }, // M9094979 has a factor: 4182286149730278011
    { 8757719, 61,         238888302184ULL }, // M8757719 has a factor: 4184233245829116593
    { 8065627, 61,         259784059884ULL }, // M8065627 has a factor: 4190642655140014537
    { 8117899, 61,         258455036679ULL }, // M8117899 has a factor: 4196223767602834843
    { 8276207, 61,         253523529160ULL }, // M8276207 has a factor: 4196426413397392241
    { 8977439, 61,         239978610400ULL }, // M8977439 has a factor: 4308786672341531201
    { 8266411, 61,         261260041743ULL }, // M8266411 has a factor: 4319365765849588747
    { 8037781, 61,         268758321144ULL }, // M8037781 has a factor: 4320441054566282929
    { 8775941, 61,         246469262424ULL }, // M8775941 has a factor: 4325999410693081969
    { 9041083, 61,         239985051636ULL }, // M9041083 has a factor: 4339449541200723577
    { 9082049, 61,         240098524572ULL }, // M9082049 has a factor: 4361173129981216057
    { 8790841, 61,         250134967569ULL }, // M8790841 has a factor: 4397793456878471059
    { 9031853, 61,         243668247556ULL }, // M9031853 has a factor: 4401551585386802537
    { 8009399, 61,         275277585799ULL }, // M8009399 has a factor: 4409616040841849603
    { 8863801, 61,         249461667573ULL }, // M8863801 has a factor: 4422357156990449947
    { 9178591, 61,         244718402660ULL }, // M9178591 has a factor: 4492340256378904121
    { 8036993, 61,         280019696488ULL }, // M8036993 has a factor: 4501032681072361169
    { 9003719, 61,         250007240527ULL }, // M9003719 has a factor: 4501989883341039827
    { 8850167, 61,         256173808432ULL }, // M8850167 has a factor: 4534361971298416289
    { 8944361, 61,         254411316409ULL }, // M8944361 has a factor: 4551093312894639299
    { 8963429, 61,         254515251076ULL }, // M8963429 has a factor: 4562658764873799209
    { 8123747, 61,         281001980892ULL }, // M8123747 has a factor: 4565577998530884649
    { 8226089, 61,         278568246840ULL }, // M8226089 has a factor: 4583054382159617521
    { 8138657, 62,         284544989397ULL }, // M8138657 has a factor: 4631628139541639659
    { 8956643, 62,         259375704627ULL }, // M8956643 has a factor: 4646271178434974323
    { 9079099, 62,         256304923947ULL }, // M9079099 has a factor: 4654035557404567507
    { 8791733, 62,         267740387068ULL }, // M8791733 has a factor: 4707803992837017689
    { 9023363, 62,         262830594780ULL }, // M9023363 has a factor: 4743231728411690281
    { 8889977, 62,         269442884725ULL }, // M8889977 has a factor: 4790682096037802651
    { 8194063, 62,         292681883100ULL }, // M8194063 has a factor: 4796507578160070601
    { 8113477, 62,         295754140752ULL }, // M8113477 has a factor: 4799188837292229409
    { 9195083, 62,         262563849256ULL }, // M9195083 has a factor: 4828592773416816497
    { 9146509, 62,         264238855860ULL }, // M9146509 has a factor: 4833726146546385481
    { 8890601, 62,         273916032216ULL }, // M8890601 has a factor: 4870556299871203633
    { 8231147, 62,         296103805887ULL }, // M8231147 has a factor: 4874547907030724779
    { 9172211, 62,         266578846155ULL }, // M9172211 has a factor: 4890234850140397411
    { 9091259, 62,         269062093251ULL }, // M9091259 has a factor: 4892226353653986019
    { 8902483, 62,         275556181607ULL }, // M8902483 has a factor: 4906268444602460363
    { 9131939, 62,         274611946735ULL }, // M9131939 has a factor: 5015479092510538331
    { 8917841, 62,         281290347256ULL }, // M8917841 has a factor: 5017005183327588593
    { 8109251, 62,         310685552791ULL }, // M8109251 has a factor: 5038854259311939083
    { 8894777, 62,         289825064568ULL }, // M8894777 has a factor: 5155858636685922673
    { 8290133, 62,         313365720972ULL }, // M8290133 has a factor: 5195687008997538553
    { 8826547, 62,         295668920964ULL }, // M8826547 has a factor: 5219471254656062617
    { 8107111, 62,         322478777643ULL }, // M8107111 has a factor: 5228742490992238747
    { 8272483, 62,         317224890567ULL }, // M8272483 has a factor: 5248475028784735723
    { 9123559, 62,         288462410015ULL }, // M9123559 has a factor: 5263607634108086771
    { 8338669, 62,         316001074329ULL }, // M8338669 has a factor: 5270056724947856203
    { 8891293, 62,         297257179716ULL }, // M8891293 has a factor: 5286001362417225577
    { 8755499, 62,         302119375831ULL }, // M8755499 has a factor: 5290411785937889339
    { 8287507, 62,         319891411019ULL }, // M8287507 has a factor: 5302204616119679267
    { 8104331, 62,         328832069296ULL }, // M8104331 has a factor: 5329927865979441953
    { 9108227, 62,         294734076739ULL }, // M9108227 has a factor: 5369009751148463507
    { 8848613, 62,         303624811533ULL }, // M8848613 has a factor: 5373316908906907459
    { 8987579, 62,         300439218751ULL }, // M8987579 has a factor: 5400442426445787659
    { 8159971, 62,         332573659955ULL }, // M8159971 has a factor: 5427582841193322611
    { 8966219, 62,         302895063436ULL }, // M8966219 has a factor: 5431646945572136969
    { 9044177, 62,         301833393292ULL }, // M9044177 has a factor: 5459669266886921369
    { 8990497, 62,         304027329473ULL }, // M8990497 has a factor: 5466713587090036163
    { 8977699, 62,         306156930404ULL }, // M8977699 has a factor: 5497169535862120793
    { 8003669, 62,         343486149036ULL }, // M8003669 has a factor: 5498298885937626169
    { 8269559, 62,         333962244864ULL }, // M8269559 has a factor: 5523440975350589953
    { 8901091, 62,         310352038548ULL }, // M8901091 has a factor: 5524943474302511737
    { 8205983, 62,         338925561303ULL }, // M8205983 has a factor: 5562434788635751699
    { 8758597, 62,         319284749700ULL }, // M8758597 has a factor: 5592972901736341801
    { 8144833, 62,         345358429125ULL }, // M8144833 has a factor: 5625773460730922251
    { 8799403, 62,         320538611055ULL }, // M8799403 has a factor: 5641096831466400331
    { 8220551, 62,         343640757640ULL }, // M8220551 has a factor: 5649832747716519281
    { 8851439, 62,         319380096312ULL }, // M8851439 has a factor: 5653946880639585937
    { 9063701, 62,         312187897768ULL }, // M9063701 has a factor: 5659155522375438737
    { 9001229, 62,         316693362460ULL }, // M9001229 has a factor: 5701258956564926681
    { 9092177, 62,         315898420828ULL }, // M9092177 has a factor: 5744408712377325113
    { 8737153, 62,         329416485320ULL }, // M8737153 has a factor: 5756324465926187921
    { 9039607, 62,         319413341508ULL }, // M9039607 has a factor: 5774742155578214713
    { 8160773, 62,         354612578157ULL }, // M8160773 has a factor: 5787825506568070723
    { 8825071, 62,         330424591476ULL }, // M8825071 has a factor: 5832040959843389593
    { 8192143, 62,         356354900651ULL }, // M8192143 has a factor: 5838620609767570187
    { 9176389, 62,         319177538324ULL }, // M9176389 has a factor: 5857794503446864073
    { 9059737, 62,         324959134437ULL }, // M9059737 has a factor: 5888088587493726139
    { 8846083, 62,         333942228548ULL }, // M8846083 has a factor: 5908161341881154969
    { 9136657, 62,         324808994789ULL }, // M9136657 has a factor: 5935336751803760747
    { 8344799, 62,         355779530472ULL }, // M8344799 has a factor: 5937817340206430257
    { 9089737, 62,         327948803520ULL }, // M9089737 has a factor: 5961936746922948481
    { 8277943, 62,         364488218600ULL }, // M8277943 has a factor: 6034425395484679601
    { 8269229, 62,         365342942109ULL }, // M8269229 has a factor: 6042208903666127923
    { 8871607, 62,         341172765252ULL }, // M8871607 has a factor: 6053501384837999929
    { 8159399, 62,         371303833116ULL }, // M8159399 has a factor: 6059232249245714569
    { 9161161, 62,         336902391561ULL }, // M9161161 has a factor: 6172834100750724643
    { 9005947, 62,         350884366364ULL }, // M9005947 has a factor: 6320092013205533417
    { 8856317, 62,         356849788353ULL }, // M8856317 has a factor: 6320749694074151803
    { 8850419, 62,         360925168464ULL }, // M8850419 has a factor: 6388677937103972833
    { 8992519, 62,         358715416500ULL }, // M8992519 has a factor: 6451510396938327001
    { 9181187, 62,         353708421820ULL }, // M9181187 has a factor: 6494926328408600681
    { 9163937, 62,         355576605028ULL }, // M9163937 has a factor: 6516963214300950473
    { 8315221, 62,         393789673961ULL }, // M8315221 has a factor: 6548896333007320763
    { 8073763, 62,         406112368515ULL }, // M8073763 has a factor: 6557710029517543891
    { 8071457, 62,         408871725132ULL }, // M8071457 has a factor: 6600381095837514649
    { 8125639, 62,         408952140732ULL }, // M8125639 has a factor: 6645994927730855497
    { 9189221, 62,         374957281060ULL }, // M9189221 has a factor: 6891130642438908521
    { 8260711, 62,         417645750516ULL }, // M8260711 has a factor: 6900101690781553753
    { 8807219, 62,         394059025656ULL }, // M8807219 has a factor: 6941128275758021329
    { 9188119, 62,         378418361292ULL }, // M9188119 has a factor: 6953905870671779497
    { 8716187, 62,         399752108095ULL }, // M8716187 has a factor: 6968628255600467531
    { 8257003, 62,         430031745675ULL }, // M8257003 has a factor: 7101546828267424051
    { 8826551, 62,         403179607999ULL }, // M8826551 has a factor: 7117370744326362899
    { 8252303, 62,         431446155487ULL }, // M8252303 has a factor: 7120848806527673123
    { 8874499, 62,         402534301316ULL }, // M8874499 has a factor: 7144580508989081369
    { 8269297, 62,         432062629452ULL }, // M8269297 has a factor: 7145708411079070489
    { 8976707, 62,         398120642343ULL }, // M8976707 has a factor: 7147624713929809003
    { 8843141, 62,         404158564209ULL }, // M8843141 has a factor: 7148062339315480939
    { 8044529, 62,         444441254569ULL }, // M8044529 has a factor: 7150641122353406003
    { 8300683, 62,         431046872868ULL }, // M8300683 has a factor: 7155966899637137689
    { 8171927, 62,         444123551940ULL }, // M8171927 has a factor: 7258690490868776761
    { 8251357, 62,         441022131909ULL }, // M8251357 has a factor: 7278062110564501027
    { 8811949, 62,         413752198845ULL }, // M8811949 has a factor: 7291926549719997811
    { 8278073, 62,         446649460560ULL }, // M8278073 has a factor: 7394793679852601761
    { 8303839, 62,         445285972040ULL }, // M8303839 has a factor: 7395166041557323121
    { 8775629, 62,         422040618997ULL }, // M8775629 has a factor: 7407343790496048227
    { 8164099, 62,         454712970804ULL }, // M8164099 has a factor: 7424643420455931193
    { 8081009, 62,         460482984300ULL }, // M8081009 has a factor: 7442334280950317401
    { 8721079, 62,         426782903619ULL }, // M8721079 has a factor: 7444014836621369803
    { 8900459, 62,         419352802891ULL }, // M8900459 has a factor: 7464864857332853939
    { 8832493, 62,         424928959200ULL }, // M8832493 has a factor: 7506364115262571201
    { 8885497, 62,         426178215005ULL }, // M8885497 has a factor: 7573610501784564971
    { 8852273, 62,         428956406373ULL }, // M8852273 has a factor: 7594478428625471659
    { 9009379, 62,         427320703056ULL }, // M9009379 has a factor: 7699788336755924449
    { 8141689, 62,         474063143985ULL }, // M8141689 has a factor: 7719349369376181331
    { 8743597, 62,         443531085329ULL }, // M8743597 has a factor: 7756114134178776827
    { 8156147, 62,         476333832808ULL }, // M8156147 has a factor: 7770097522910941553
    { 9160649, 62,         425084458881ULL }, // M9160649 has a factor: 7788099046327547539
    { 8939323, 62,         437093657100ULL }, // M8939323 has a factor: 7814642764136286601
    { 8784731, 62,         449680245435ULL }, // M8784731 has a factor: 7900639984320905971
    { 8840201, 62,         447508021905ULL }, // M8840201 has a factor: 7912121725505205811
    { 8194399, 62,         485262363215ULL }, // M8194399 has a factor: 7952866847733265571
    { 8321861, 62,         478854245508ULL }, // M8321861 has a factor: 7969916940754900777
    { 8902337, 62,         452872314220ULL }, // M8902337 has a factor: 8063243918312664281
    { 8328659, 62,         484175813716ULL }, // M8328659 has a factor: 8065070496976173689
    { 9124151, 62,         442381691548ULL }, // M9124151 has a factor: 8072714706638751497
    { 9159067, 62,         442970465300ULL }, // M9159067 has a factor: 8114392341407750201
    { 8928671, 62,         457594947948ULL }, // M8928671 has a factor: 8171429482979634217
    { 8947021, 62,         459687034700ULL }, // M8947021 has a factor: 8225659105777257401
    { 9185689, 62,         448534056336ULL }, // M9185689 has a factor: 8240188694821951009
    { 8883379, 62,         464644273004ULL }, // M8883379 has a factor: 8255222354548001033
    { 8791051, 62,         470335922091ULL }, // M8791051 has a factor: 8269494156468015283
    { 8773799, 62,         472069452631ULL }, // M8773799 has a factor: 8283684982848830339
    { 8203703, 62,         506993168095ULL }, // M8203703 has a factor: 8318442748160911571
    { 8259389, 62,         507257793601ULL }, // M8259389 has a factor: 8379278881264739579
    { 9011117, 62,         468432273220ULL }, // M9011117 has a factor: 8442196041122773481
    { 8815283, 62,         480926792763ULL }, // M8815283 has a factor: 8479011560976393859
    { 8705527, 62,         488558764100ULL }, // M8705527 has a factor: 8506323023918361401
    { 8288459, 62,         514007397432ULL }, // M8288459 has a factor: 8520658478623674577
    { 8794157, 62,         490733375629ULL }, // M8794157 has a factor: 8631172700842799507
    { 9189871, 62,         472980169376ULL }, // M9189871 has a factor: 8693253484247180993
    { 8812249, 62,         496306359420ULL }, // M8812249 has a factor: 8747150438985071161
    { 8351113, 62,         524200969193ULL }, // M8351113 has a factor: 8755323056880523619
    { 8176093, 62,         537919262996ULL }, // M8176093 has a factor: 8796155841493509257
    { 9024959, 62,         487506206836ULL }, // M9024959 has a factor: 8799447057880839449
    { 8745449, 62,         504112982677ULL }, // M8745449 has a factor: 8817388760479173947
    { 8029739, 62,         551254798071ULL }, // M8029739 has a factor: 8852864302015666939
    { 8173903, 62,         542228174987ULL }, // M8173903 has a factor: 8864241012421528523
    { 8115181, 62,         554116575716ULL }, // M8115181 has a factor: 8993512614071089193
    { 8930951, 62,         503933798295ULL }, // M8930951 has a factor: 9001216119633057091
    { 8732123, 62,         516026353416ULL }, // M8732123 has a factor: 9012011178539964337
    { 8876099, 62,         510406303051ULL }, // M8876099 has a factor: 9060833752209356099
    { 8881273, 62,         510788684225ULL }, // M8881273 has a factor: 9072907499826036851
    { 8035343, 62,         568482175731ULL }, // M8035343 has a factor: 9135898542769721467
    { 8928091, 62,         513372374039ULL }, // M8928091 has a factor: 9166870544612459099
    { 8058569, 62,         569828254585ULL }, // M8058569 has a factor: 9184000615445577731
    { 9154879, 63,         504421350455ULL }, // M9154879 has a factor: 9235832856864239891
    { 8870881, 63,         521181124649ULL }, // M8870881 has a factor: 9246671472414891539
    { 8215043, 63,         565670566060ULL }, // M8215043 has a factor: 9294016048034481161
    { 8154383, 63,         571330689600ULL }, // M8154383 has a factor: 9317698525305033601
    { 9166609, 63,         509441213612ULL }, // M9166609 has a factor: 9339696827333363417
    { 8818297, 63,         530603104128ULL }, // M8818297 has a factor: 9358031522645260033
    { 8913733, 63,         528780409037ULL }, // M8913733 has a factor: 9426814763573210243
    { 8741353, 63,         540288751752ULL }, // M8741353 has a factor: 9445709401987200913
    { 8991371, 63,         531552470919ULL }, // M8991371 has a factor: 9558770943998879899
    { 8909473, 63,         537060909180ULL }, // M8909473 has a factor: 9569859339389324281
    { 8972129, 63,         536577457561ULL }, // M8972129 has a factor: 9628484335458634739
    { 8979149, 63,         537537746581ULL }, // M8979149 has a factor: 9653263039350079139
    { 8867191, 63,         545016303444ULL }, // M8867191 has a factor: 9665527321503811609
    { 9044677, 63,         534412663884ULL }, // M9044677 has a factor: 9667179859080690937
    { 8287481, 63,         592053313665ULL }, // M8287481 has a factor: 9813261175971455731
    { 8827967, 63,         563024721100ULL }, // M8827967 has a factor: 9940727316110007401
    { 8711359, 63,         574645394255ULL }, // M8711359 has a factor: 10011884654103685091
    { 8943553, 63,         560155866416ULL }, // M8943553 has a factor: 10019567359104832097
    { 8721443, 63,         575998769656ULL }, // M8721443 has a factor: 10047080875249867217
    { 8292671, 63,         606008408980ULL }, // M8292671 has a factor: 10050856717809171161
    { 8719771, 63,         592799861375ULL }, // M8719771 has a factor: 10338158080043490251
    { 8887399, 63,         582416005832ULL }, // M8887399 has a factor: 10352326855630621937
    { 9171983, 63,         570801712792ULL }, // M9171983 has a factor: 10470767212198213073
    { 9190373, 63,         573228189813ULL }, // M9190373 has a factor: 10536361756992540499
    { 8950181, 63,         593332215981ULL }, // M8950181 has a factor: 10620861452322085123
    { 9025139, 63,         598134160516ULL }, // M9025139 has a factor: 10796487878610423449
    { 8887547, 63,         608022713487ULL }, // M8887547 has a factor: 10807660886366492779
    { 8154427, 63,         671499361364ULL }, // M8154427 has a factor: 10951385045578716857
    { 8727349, 63,         629692255085ULL }, // M8727349 has a factor: 10991088145447639331
    { 8270063, 63,         665273536768ULL }, // M8270063 has a factor: 11003708122608352769
    { 8835881, 63,         627785423100ULL }, // M8835881 has a factor: 11094074584092502201
    { 9143843, 63,         608923321527ULL }, // M9143843 has a factor: 11135798502162816523
    { 9134947, 63,         612097440815ULL }, // M9134947 has a factor: 11182955361361323611
    { 8772079, 63,         637543165100ULL }, // M8772079 has a factor: 11185158020334485801
    { 9193033, 63,         610090263305ULL }, // M9193033 has a factor: 11217159847083108131
    { 8136889, 63,         695778690977ULL }, // M8136889 has a factor: 11322947954090301107
    { 9044719, 63,         628683045452ULL }, // M9044719 has a factor: 11372522972355135977
    { 9158813, 63,         621584698380ULL }, // M9158813 has a factor: 11385956032247645881
    { 8240543, 63,         692520633991ULL }, // M8240543 has a factor: 11413492125580194227
    { 8872393, 63,         644981445377ULL }, // M8872393 has a factor: 11445057722185554323
    { 9151301, 63,         626726265304ULL }, // M9151301 has a factor: 11470721396805521009
    { 8073577, 63,         715567682129ULL }, // M8073577 has a factor: 11554381560760010867
    { 9025397, 63,         660257423280ULL }, // M9025397 has a factor: 11918170734598084321
    { 8265973, 63,         733590239237ULL }, // M8265973 has a factor: 12127674221193165203
    { 8784449, 63,         693385337425ULL }, // M8784449 has a factor: 12182016267915407651
    { 8060387, 63,         756085913835ULL }, // M8060387 has a factor: 12188690141517508291
    { 8170469, 63,         754454297140ULL }, // M8170469 has a factor: 12328490893398317321
    { 9008177, 63,         701451592425ULL }, // M9008177 has a factor: 12637600202992518451
    { 8064127, 63,         788433281367ULL }, // M8064127 has a factor: 12716052223940443219
    { 8172469, 63,         779621310185ULL }, // M8172469 has a factor: 12742861978452593531
    { 8141059, 63,         783061007432ULL }, // M8141059 has a factor: 12749891724206700977
    { 8336299, 63,         787769919252ULL }, // M8336299 has a factor: 13134171180181056697
    { 8894887, 63,         739565410232ULL }, // M8894887 has a factor: 13156701506244567569
    { 8994481, 63,         734911819776ULL }, // M8994481 has a factor: 13220300799301312513
    { 8743019, 63,         761599917460ULL }, // M8743019 has a factor: 13317365097502423481
    { 8898671, 63,         751242914028ULL }, // M8898671 has a factor: 13370127066032913577
    { 9183331, 63,         728572564064ULL }, // M9183331 has a factor: 13381446026636834369
    { 9126499, 63,         735665344344ULL }, // M9126499 has a factor: 13428098058980343313
    { 8042779, 63,         840169867040ULL }, // M8042779 has a factor: 13514601126124208321
    { 8765377, 63,         773304150528ULL }, // M8765377 has a factor: 13556604830085338113
    { 8326609, 63,         818390334665ULL }, // M8326609 has a factor: 13628832652269201971
    { 9099353, 63,         749809605153ULL }, // M9099353 has a factor: 13645564560155532019
    { 8953729, 63,         762773435697ULL }, // M8953729 has a factor: 13659333263259728227
    { 9026203, 63,         762127865220ULL }, // M9026203 has a factor: 13758241646864719321
    { 8877331, 63,         783951501540ULL }, // M8877331 has a factor: 13918793934235179481
    { 8952233, 63,         782997992425ULL }, // M8952233 has a factor: 14019160933441670051
    { 9063889, 63,         779025212340ULL }, // M9063889 has a factor: 14121996105702380521
    { 8169617, 63,         872589005988ULL }, // M8169617 has a factor: 14257435954665333193
    { 8004413, 63,         899517671425ULL }, // M8004413 has a factor: 14400221885767997051
    { 9091657, 63,         793393267160ULL }, // M9091657 has a factor: 14426518902256168241
    { 8298373, 63,         870782002973ULL }, // M8298373 has a factor: 14452147724714125859
    { 8836819, 63,         818518629444ULL }, // M8836819 has a factor: 14466201953049397273
    { 8293993, 63,         875729120753ULL }, // M8293993 has a factor: 14526582394843073459
    { 9169739, 63,         799675160631ULL }, // M9169739 has a factor: 14665625015538690619
    { 8835823, 63,         830980734387ULL }, // M8835823 has a factor: 14684797370907091003
    { 8238683, 63,         897401819068ULL }, // M8238683 has a factor: 14786818221849214889
    { 8777819, 63,         846041250684ULL }, // M8777819 has a factor: 14852793930075556393
    { 9109717, 63,         825541509240ULL }, // M9109717 has a factor: 15040899041858570161
    { 9091021, 63,         827409881925ULL }, // M9091021 has a factor: 15044001224375390851
    { 8311543, 63,         912297333636ULL }, // M8311543 has a factor: 15165197034601920697
    { 8217271, 63,         928199079440ULL }, // M8217271 has a factor: 15254526755418016481
    { 8047729, 63,         948302675504ULL }, // M8047729 has a factor: 15263365884862260833
    { 8138947, 63,         939145476492ULL }, // M8138947 has a factor: 15287310516916267849
    { 8300183, 63,         921254365891ULL }, // M8300183 has a factor: 15293159652888516107
    { 8892451, 63,         865130533976ULL }, // M8892451 has a factor: 15386261763970830353
    { 9091051, 63,         847578795999ULL }, // M9091051 has a factor: 15410764121891009899
    { 8982473, 63,         858519453376ULL }, // M8982473 has a factor: 15423255619849357697
    { 8048197, 63,         965016904752ULL }, // M8048197 has a factor: 15533292315548664289
    { 8251219, 63,         944537676075ULL }, // M8251219 has a factor: 15587174438091770851
    { 8757107, 63,         890675525187ULL }, // M8757107 has a factor: 15599481752687508019
    { 8796187, 63,         892957645403ULL }, // M8796187 has a factor: 15709244864088956723
    { 8340443, 63,         944428591591ULL }, // M8340443 has a factor: 15753905671470029627
    { 8018327, 63,         983303922304ULL }, // M8018327 has a factor: 15768904778832130817
    { 8063227, 63,         982272131372ULL }, // M8063227 has a factor: 15840566342052514889
    { 8963299, 63,         886585704087ULL }, // M8963299 has a factor: 15893465509714606027
    { 8307007, 63,         960190804748ULL }, // M8307007 has a factor: 15952623472754538473
    { 8902961, 63,         901466951376ULL }, // M8902961 has a factor: 16051450221778848673
    { 8091803, 63,         991902512632ULL }, // M8091803 has a factor: 16052559454846310993
    { 8756117, 63,         922050122112ULL }, // M8756117 has a factor: 16147157498153918209
    { 8897839, 63,         919412559984ULL }, // M8897839 has a factor: 16361569866630949153
    { 8757659, 63,         937906459216ULL }, // M8757659 has a factor: 16427729887422270689
    { 9089021, 63,         904896623029ULL }, // M9089021 has a factor: 16449248819079329219
    { 8244013, 63,         998992554168ULL }, // M8244013 has a factor: 16471415206928392369
    { 9184027, 63,         897983552744ULL }, // M9184027 has a factor: 16494210387913640177
    { 8845231, 63,         940194868928ULL }, // M8845231 has a factor: 16632481601365764737
    { 8269187, 63,        1006185593080ULL }, // M8269187 has a factor: 16640673651768851921
    { 8106079, 63,        1034216637075ULL }, // M8106079 has a factor: 16766883526488557851
    { 8177921, 63,        1029735823389ULL }, // M8177921 has a factor: 16842196429090388539
    { 8921741, 63,         947004298425ULL }, // M8921741 has a factor: 16897854152869115851
    { 9007499, 63,         953689954956ULL }, // M9007499 has a factor: 17180722631152430089
    { 8865487, 63,         971767763495ULL }, // M8865487 has a factor: 17230388948567994131
    { 8775953, 63,         983297439072ULL }, // M8775953 has a factor: 17258744220632471233
    { 9159317, 63,         959164201032ULL }, // M9159317 has a factor: 17570577944607630289
    { 8132389, 63,        1085587911389ULL }, // M8132389 has a factor: 17656846378225756643
    { 8086597, 63,        1093291496597ULL }, // M8086597 has a factor: 17682015473013620819
    { 8965661, 63,         996778507716ULL }, // M8965661 has a factor: 17873556384535080553
    { 9123469, 63,         992335292525ULL }, // M9123469 has a factor: 18107080557915538451
    { 8349311, 64,        1110856769980ULL }, // M8349311 has a factor: 18549777298036967561
    { 8758117, 64,        1063848177320ULL }, // M8758117 has a factor: 18634613614410612881
    { 8353699, 64,        1122308063135ULL }, // M8353699 has a factor: 18750847489405572731
    { 8993737, 64,        1055939168729ULL }, // M8993737 has a factor: 18993678343094500547
    { 8925971, 64,        1069886915028ULL }, // M8925971 has a factor: 19099559153638784377
    { 9070057, 64,        1054197537077ULL }, // M9070057 has a factor: 19123263501096006779
    { 9175421, 64,        1054637289184ULL }, // M9175421 has a factor: 19353482261123892929
    { 9013441, 64,        1075092769205ULL }, // M9013441 has a factor: 19380570489511768811
    { 8800459, 64,        1101563474127ULL }, // M8800459 has a factor: 19388528379904448587
    { 8046239, 64,        1210349227455ULL }, // M8046239 has a factor: 19477518315136583491
    { 8816573, 64,        1105861233112ULL }, // M8816573 has a factor: 19499812579203930353
    { 8101699, 64,        1210755490340ULL }, // M8101699 has a factor: 19618353090664175321
    { 8266939, 64,        1190532317759ULL }, // M8266939 has a factor: 19684116096884539403
    { 8255707, 64,        1199557875587ULL }, // M8255707 has a factor: 19806396700777450019
    { 8853391, 64,        1124354950863ULL }, // M8853391 has a factor: 19908708005551852867
    { 8799701, 64,        1151275119100ULL }, // M8799701 has a factor: 20261753633638778201
    { 8030437, 64,        1266181575624ULL }, // M8030437 has a factor: 20335982747218535377
    { 8336467, 64,        1229926746987ULL }, // M8336467 has a factor: 20506487477348949859
    { 8830477, 64,        1173067026597ULL }, // M8830477 has a factor: 20717482795646393539
    { 9053483, 64,        1147158967500ULL }, // M9053483 has a factor: 20771568421117605001
    { 8187857, 64,        1278105090829ULL }, // M8187857 has a factor: 20929883429359726907
    { 8783851, 64,        1191418161591ULL }, // M8783851 has a factor: 20930479220218533883
    { 8069377, 64,        1299774041780ULL }, // M8069377 has a factor: 20976733515873142121
    { 8062253, 64,        1301281156320ULL }, // M8062253 has a factor: 20982515812768777921
    { 8774047, 64,        1204720109168ULL }, // M8774047 has a factor: 21140541719370325793
    { 8990441, 64,        1180680962796ULL }, // M8990441 has a factor: 21229685071681266073
    { 9110467, 64,        1165651112079ULL }, // M9110467 has a factor: 21239251980218061787
    { 9124981, 64,        1163808705524ULL }, // M9124981 has a factor: 21239464651082190089
    { 8143637, 64,        1305584364180ULL }, // M8143637 has a factor: 21264410269515445321
    { 8949427, 64,        1196434320432ULL }, // M8949427 has a factor: 21414803222001584929
    { 8166097, 64,        1319392283040ULL }, // M8166097 has a factor: 21548570728712189761
    { 8903833, 64,        1224773708648ULL }, // M8903833 has a factor: 21810361129184895569
    { 9096223, 64,        1202618305016ULL }, // M9096223 has a factor: 21878568572615109137
    { 9057337, 64,        1212154107588ULL }, // M9057337 has a factor: 21957776496717546313
    { 8881681, 64,        1249902285828ULL }, // M8881681 has a factor: 22202466767790233737
    { 8068457, 64,        1376955214908ULL }, // M8068457 has a factor: 22219807884821913913
    { 8241781, 64,        1348010283620ULL }, // M8241781 has a factor: 22220011086687854441
    { 8784337, 64,        1266901835433ULL }, // M8784337 has a factor: 22257785336724025843
    { 8229293, 64,        1357492997401ULL }, // M8229293 has a factor: 22342415242122134987
    { 9075769, 64,        1237848050201ULL }, // M9075769 has a factor: 22468845921449359139
    { 8030353, 64,        1399624865165ULL }, // M8030353 has a factor: 22478963469704706491
    { 9189893, 64,        1224208492641ULL }, // M9189893 has a factor: 22500690114124154827
    { 8851133, 64,        1274312655697ULL }, // M8851133 has a factor: 22558221598314709403
    { 8285059, 64,        1383264283952ULL }, // M8285059 has a factor: 22920852410270146337
    { 8998489, 64,        1279299941792ULL }, // M8998489 has a factor: 23023532907831904577
    { 9046967, 64,        1273457136000ULL }, // M9046967 has a factor: 23041849370613024001
    { 8945611, 64,        1288290236783ULL }, // M8945611 has a factor: 23049086626717218827
    { 8949839, 64,        1291865250819ULL }, // M8949839 has a factor: 23123972009049336283
    { 9037817, 64,        1287523801144ULL }, // M9037817 has a factor: 23272808995767725297
    { 9190861, 64,        1278085156865ULL }, // M9190861 has a factor: 23493406045818821531
    { 8877137, 64,        1336003031184ULL }, // M8877137 has a factor: 23719763880471280417
    { 8865179, 64,        1363030675656ULL }, // M8865179 has a factor: 24167021844362764849
    { 8017439, 64,        1511930751112ULL }, // M8017439 has a factor: 24243625138529284337
    { 8124703, 64,        1492149634136ULL }, // M8124703 has a factor: 24246545217827323217
    { 8984827, 64,        1375379455547ULL }, // M8984827 has a factor: 24715092934887970739
    { 8288023, 64,        1492421722848ULL }, // M8288023 has a factor: 24738451129327699009
    { 9095477, 64,        1361738784177ULL }, // M9095477 has a factor: 24771327582979734859
    { 9143819, 64,        1357224954804ULL }, // M9143819 has a factor: 24820438658021912953
    { 8322383, 64,        1495846275540ULL }, // M8322383 has a factor: 24898011228334823641
    { 8986687, 64,        1398010056588ULL }, // M8986687 has a factor: 25126957602817287913
    { 9111457, 64,        1391438471813ULL }, // M9111457 has a factor: 25356063608139723083
    { 8009039, 64,        1622653080516ULL }, // M8009039 has a factor: 25991783610645568249
    { 8840581, 64,        1473951555384ULL }, // M8840581 has a factor: 26061176230896476209
    { 8846527, 64,        1488700654592ULL }, // M8846527 has a factor: 26339661071531603969
    { 8915681, 64,        1510706361184ULL }, // M8915681 has a factor: 26937952001974652609
    { 8873897, 64,        1529969485005ULL }, // M8873897 has a factor: 27153583246154828971
    { 8082257, 64,        1690140703729ULL }, // M8082257 has a factor: 27320303067397272707
    { 8203511, 64,        1680125610448ULL }, // M8203511 has a factor: 27565857853383765857
    { 8877109, 64,        1569462490760ULL }, // M8877109 has a factor: 27864579203776025681
    { 8229857, 64,        1694269963668ULL }, // M8229857 has a factor: 27887199040765670953
    { 8229163, 64,        1696396119368ULL }, // M8229163 has a factor: 27919840357693457969
    { 9008423, 64,        1550602125675ULL }, // M9008423 has a factor: 27936959705559121051
    { 8266963, 64,        1690842192120ULL }, // M8266963 has a factor: 27956259682189863121
    { 9098113, 64,        1548045236772ULL }, // M9098113 has a factor: 28168580986526822473
    { 8132027, 64,        1750913630563ULL }, // M8132027 has a factor: 28476953836812682403
    { 9195491, 64,        1549183976160ULL }, // M9195491 has a factor: 28491014620246989121
    { 8213591, 64,        1757440346164ULL }, // M8213591 has a factor: 28869792420579029849
    { 8212493, 64,        1764228154560ULL }, // M8212493 has a factor: 28977422739453836161
    { 8886469, 64,        1630923293732ULL }, // M8886469 has a factor: 28986298582254624617
    { 9131477, 64,        1594641998268ULL }, // M9131477 has a factor: 29122873460836563673
    { 8284699, 64,        1760718989687ULL }, // M8284699 has a factor: 29174053706281798427
    { 8291407, 64,        1765917988884ULL }, // M8291407 has a factor: 29283889548917439577
    { 8310271, 64,        1770888512300ULL }, // M8310271 has a factor: 29433126895999666601
    { 8840341, 64,        1671735509064ULL }, // M8840341 has a factor: 29557423923868701649
    { 9129277, 64,        1619890765625ULL }, // M9129277 has a factor: 29576863018265406251
    { 9014953, 64,        1654384918532ULL }, // M9014953 has a factor: 29828404568949617993
    { 9007333, 64,        1667087406816ULL }, // M9007333 has a factor: 30032022826596363457
    { 8207477, 64,        1859964674700ULL }, // M8207477 has a factor: 30531234576825463801
    { 8282969, 64,        1872997303200ULL }, // M8282969 has a factor: 31027957198978401601
    { 9182627, 64,        1710422496592ULL }, // M9182627 has a factor: 31412343597226214369
    { 8053091, 64,        1951958978116ULL }, // M8053091 has a factor: 31438606558070313113
    { 8850601, 64,        1779544389456ULL }, // M8850601 has a factor: 31500074705727326113
    { 8930351, 64,        1779658925688ULL }, // M8930351 has a factor: 31785957733353512977
    { 8939023, 64,        1790616092883ULL }, // M8939023 has a factor: 32012716876902546619
    { 9199937, 64,        1772338394037ULL }, // M9199937 has a factor: 32610803135643151339
    { 9021739, 64,        1831222543367ULL }, // M9021739 has a factor: 33041623674346510427
    { 9051859, 64,        1829021410920ULL }, // M9051859 has a factor: 33112087839257800561
    { 8190997, 64,        2045890472220ULL }, // M8190997 has a factor: 33515765440565206681
    { 9030653, 64,        1867130496648ULL }, // M9030653 has a factor: 33722815241891502289
    { 9061669, 64,        1875330790856ULL }, // M9061669 has a factor: 33987253784490597329
    { 8290421, 64,        2065567793925ULL }, // M8290421 has a factor: 34248853231358984851
    { 8838013, 64,        1958498172740ULL }, // M8838013 has a factor: 34618464622304731241
    { 8300441, 64,        2099073784516ULL }, // M8300441 has a factor: 34846476206043543113
    { 9040631, 64,        1942841293239ULL }, // M9040631 has a factor: 35129022447473187619
    { 9086327, 64,        1933946986488ULL }, // M9086327 has a factor: 35144949439789099153
    { 8983529, 64,        1970210750140ULL }, // M8983529 has a factor: 35398890819988888121
    { 8263961, 64,        2141999905953ULL }, // M8263961 has a factor: 35402807369598519667
    { 9078253, 64,        2017365750428ULL }, // M9078253 has a factor: 36628313351840484569
    { 8889877, 64,        2061369090420ULL }, // M8889877 has a factor: 36650635330871356681
    { 9120563, 64,        2014055497455ULL }, // M9120563 has a factor: 36738640100069334331
    { 8800921, 64,        2094924458648ULL }, // M8800921 has a factor: 36874529323057629617
    { 8131757, 65,        2269618284852ULL }, // M8131757 has a factor: 36911968750346489929
    { 9191773, 65,        2036844004292ULL }, // M9191773 has a factor: 37444415447726179433
    { 9132049, 65,        2062745389521ULL }, // M9132049 has a factor: 37674183943259717059
    { 8844659, 65,        2132227170336ULL }, // M8844659 has a factor: 37717644464313670849
    { 8777243, 65,        2187062913220ULL }, // M8777243 has a factor: 38392765291239704921
    { 9136591, 65,        2106048167036ULL }, // M9136591 has a factor: 38484201457015228553
    { 8102221, 65,        2411706488724ULL }, // M8102221 has a factor: 39080357917551712009
    { 8726141, 65,        2254697515309ULL }, // M8726141 has a factor: 39349616861871985139
    { 9093313, 65,        2166406956357ULL }, // M9093313 has a factor: 39399633079063081483
    { 8994781, 65,        2198824672544ULL }, // M8994781 has a factor: 39555892773859985729
    { 8850577, 65,        2266485267969ULL }, // M8850577 has a factor: 40119404767050536227
    { 8005717, 65,        2516661705705ULL }, // M8005717 has a factor: 40295362801223030971
    { 8969087, 65,        2255214946212ULL }, // M8969087 has a factor: 40454438112551496889
    { 8866903, 65,        2317487059740ULL }, // M8866903 has a factor: 41097865924939570441
    { 8716429, 65,        2367087942804ULL }, // M8716429 has a factor: 41265107980414253833
    { 8204389, 65,        2580493586084ULL }, // M8204389 has a factor: 42342746384476245353
    { 8879681, 65,        2397007305880ULL }, // M8879681 has a factor: 42569320461767648561
    { 8026813, 65,        2665505586641ULL }, // M8026813 has a factor: 42791029788845210267
    { 8791369, 65,        2443915520256ULL }, // M8791369 has a factor: 42970726286794940929
    { 8805869, 65,        2442257341177ULL }, // M8805869 has a factor: 43012396421385935627
    { 8954899, 65,        2417088414147ULL }, // M8954899 has a factor: 43289565245513112307
    { 9018587, 65,        2425387424824ULL }, // M9018587 has a factor: 43747134998962407377
    { 9003901, 65,        2445272129160ULL }, // M9003901 has a factor: 44033976338031706321
    { 9188947, 65,        2435089857980ULL }, // M9188947 has a factor: 44751823290431494121
    { 8941021, 65,        2509781970221ULL }, // M8941021 has a factor: 44880026602334671283
    { 8288633, 65,        2709803101192ULL }, // M8288633 has a factor: 44921126816084701073
    { 8215397, 65,        2740888320133ULL }, // M8215397 has a factor: 45034971365111375603
    { 9136213, 65,        2480266054185ULL }, // M9136213 has a factor: 45320477935407402811
    { 9170621, 65,        2503932531880ULL }, // M9170621 has a factor: 45925232518883794961
    { 8864399, 65,        2603766871191ULL }, // M8864399 has a factor: 46161656898437258419
    { 8803481, 65,        2628188004453ULL }, // M8803481 has a factor: 46274406323259801787
    { 8995027, 65,        2579374787183ULL }, // M8995027 has a factor: 46403091707660677883
    { 8015783, 65,        2903370505015ULL }, // M8015783 has a factor: 46545575873601303491
    { 8769581, 65,        2681685039468ULL }, // M8769581 has a factor: 47034508340205645817
    { 8183221, 65,        2895820582425ULL }, // M8183221 has a factor: 47394279604664981851
    { 8086223, 65,        2952435612531ULL }, // M8086223 has a factor: 47748105512134520827
    { 8203903, 65,        2929001304768ULL }, // M8203903 has a factor: 48058485182380219009
    { 8352803, 65,        2902642048071ULL }, // M8352803 has a factor: 48490394414107186027
    { 8802539, 65,        2760989573275ULL }, // M8802539 has a factor: 48607436794693090451
    { 8262193, 65,        2942909860008ULL }, // M8262193 has a factor: 48629778489978155089
    { 9044807, 65,        2691133873263ULL }, // M9044807 has a factor: 48681572989652590483
    { 8136383, 65,        3025172667375ULL }, // M8136383 has a factor: 49227926925789209251
    { 8919931, 65,        2785006364456ULL }, // M8919931 has a factor: 49684129211016745073
    { 9080563, 65,        2739893662527ULL }, // M9080563 has a factor: 49759554031754325403
    { 8914567, 65,        2821003791279ULL }, // M8914567 has a factor: 50296054609221322387
    { 8841529, 65,        2845362627984ULL }, // M8841529 has a factor: 50314712381673495073
    { 8779909, 65,        2888126390945ULL }, // M8779909 has a factor: 50714973785991048011
    { 9050653, 65,        2808861997797ULL }, // M9050653 has a factor: 50844070533894822883
    { 9182863, 65,        2781924536367ULL }, // M9182863 has a factor: 51092063787593357443
    { 8055101, 65,        3186093120544ULL }, // M8055101 has a factor: 51328603762774189889
    { 8807917, 65,        2945591093208ULL }, // M8807917 has a factor: 51889043729830655473
    { 8096783, 65,        3212131534695ULL }, // M8096783 has a factor: 52015864007764772371
    { 8870503, 65,        2942164049208ULL }, // M8870503 has a factor: 52196950049983423249
    { 8865391, 65,        2974480900103ULL }, // M8865391 has a factor: 52739872402890070547
    { 9082457, 65,        2924197981813ULL }, // M9082457 has a factor: 53117804858606709083
    { 8836759, 65,        3012617374299ULL }, // M8836759 has a factor: 53243547391786113883
    { 8343431, 65,        3248271388624ULL }, // M8343431 has a factor: 54203456400517057889
    { 8296219, 65,        3348947224440ULL }, // M8296219 has a factor: 55567199186792784721
    { 9115121, 65,        3062580210501ULL }, // M9115121 has a factor: 55831578381844171243
    { 8201821, 65,        3427535667953ULL }, // M8201821 has a factor: 56224068039331884827
    { 9078281, 65,        3100289188789ULL }, // M9078281 has a factor: 56290592874177183419
    { 8796371, 65,        3217244645751ULL }, // M8796371 has a factor: 56600155003578739243
    { 9068029, 65,        3203116332660ULL }, // M9068029 has a factor: 58091903589869054281
    { 8722859, 65,        3385872954244ULL }, // M8722859 has a factor: 59068984743567727193
    { 8197327, 65,        3605952922200ULL }, // M8197327 has a factor: 59118350499757918801
    { 8712793, 65,        3440527353185ULL }, // M8712793 has a factor: 59953205278277591411
    { 9072643, 65,        3357531162711ULL }, // M9072643 has a factor: 60923363201303630347
    { 8781551, 65,        3482961531304ULL }, // M8781551 has a factor: 61171608636368345009
    { 8129273, 65,        3769563811641ULL }, // M8129273 has a factor: 61287626631500533987
    { 8784847, 65,        3495705312335ULL }, // M8784847 has a factor: 61418472651900375491
    { 8183899, 65,        3756654426975ULL }, // M8183899 has a factor: 61488160816532551051
    { 9172279, 65,        3358420619744ULL }, // M9172279 has a factor: 61608741847289753153
    { 8818273, 65,        3554923819800ULL }, // M8818273 has a factor: 62696577474398410801
    { 9168209, 65,        3433786855800ULL }, // M9168209 has a factor: 62963351110854524401
    { 8840659, 65,        3564201283055ULL }, // M8840659 has a factor: 63019776301703466491
    { 9133837, 65,        3455017967105ULL }, // M9133837 has a factor: 63115141887216863771
    { 8981447, 65,        3528541057035ULL }, // M8981447 has a factor: 63382808982167659291
    { 8795089, 65,        3609951828125ULL }, // M8795089 has a factor: 63499695228144156251
    { 8342827, 65,        3829022229503ULL }, // M8342827 has a factor: 63889740079795649963
    { 8103439, 65,        4046992411091ULL }, // M8103439 has a factor: 65589112273477683899
    { 8017927, 65,        4140420312300ULL }, // M8017927 has a factor: 66395175626677204201
    { 8170711, 65,        4122427466036ULL }, // M8170711 has a factor: 67366326886884943193
    { 9125959, 65,        3700018453107ULL }, // M9125959 has a factor: 67532433404595809227
    { 8296699, 65,        4071077433780ULL }, // M8296699 has a factor: 67553008147530184441
    { 8849371, 65,        3827550453260ULL }, // M8849371 has a factor: 67742827964231798921
    { 8758187, 65,        3932412539848ULL }, // M8758187 has a factor: 68881608770267471153
    { 8207989, 65,        4200866748536ULL }, // M8207989 has a factor: 68961336124898508209
    { 8202127, 65,        4260971977500ULL }, // M8202127 has a factor: 69898066605792285001
    { 8353649, 65,        4216501402024ULL }, // M8353649 has a factor: 70446345441032771153
    { 8736683, 65,        4050440133288ULL }, // M8736683 has a factor: 70774822910030007409
    { 8868533, 65,        3994295466141ULL }, // M8868533 has a factor: 70847082306443682307
    { 8910137, 65,        4018481829384ULL }, // M8910137 has a factor: 71610447263644131217
    { 8965097, 65,        4044733892380ULL }, // M8965097 has a factor: 72522863368748521721
    { 9098293, 65,        3993356766252ULL }, // M9098293 has a factor: 72665459825786415673
    { 9133361, 65,        3986259009049ULL }, // M9133361 has a factor: 72815885138293567379
    { 9054277, 65,        4053602880713ULL }, // M9054277 has a factor: 73404886659946919003
    { 9069989, 65,        4061833208025ULL }, // M9069989 has a factor: 73681565033242923451
    { 8999317, 66,        4120555995413ULL }, // M8999317 has a factor: 74164379237944265843
    { 8158211, 66,        4551862033408ULL }, // M8158211 has a factor: 74270101822863026177
    { 8952899, 66,        4149185927712ULL }, // M8952899 has a factor: 74294485086053674177
    { 9196093, 66,        4147235281301ULL }, // M9196093 has a factor: 76276722679450313987
    { 9057287, 66,        4215712767627ULL }, // M9057287 has a factor: 76365840891924095899
    { 9125797, 66,        4189681655060ULL }, // M9125797 has a factor: 76468368557403165641
    { 8720713, 66,        4417530365576ULL }, // M8720713 has a factor: 77048028973946751377
    { 9032479, 66,        4272686311847ULL }, // M9032479 has a factor: 77185898770690957427
    { 8788057, 66,        4423812829152ULL }, // M8788057 has a factor: 77753438599838075329
    { 8936663, 66,        4351808773248ULL }, // M8936663 has a factor: 77781296893921582849
    { 9005041, 66,        4318979063181ULL }, // M9005041 has a factor: 77785167084172990843
    { 8236933, 66,        4755799302272ULL }, // M8236933 has a factor: 78346400428522423553
    { 8832001, 66,        4454620882424ULL }, // M8832001 has a factor: 78686432176379300849
    { 9152999, 66,        4308830266435ULL }, // M9152999 has a factor: 78877438239698577131
    { 8018107, 66,        4922955976935ULL }, // M8018107 has a factor: 78945575558708724091
    { 9043927, 66,        4379375787735ULL }, // M9043927 has a factor: 79213509859685670691
    { 9197257, 66,        4380839011764ULL }, // M9197257 has a factor: 80583404533639062697
    { 8845517, 66,        4588125218128ULL }, // M8845517 has a factor: 81168679230159864353
    { 8750309, 66,        4649224015560ULL }, // M8750309 has a factor: 81364293492741616081
    { 8950037, 66,        4557828391765ULL }, // M8950037 has a factor: 81585465491894490611
    { 8710043, 66,        4698547342936ULL }, // M8710043 has a factor: 81849098789016612497
    { 9023999, 66,        4535966825940ULL }, // M9023999 has a factor: 81865120202631468121
    { 9123949, 66,        4492656369081ULL }, // M9123949 has a factor: 81981535172040441739
    { 8094017, 66,        5070363033972ULL }, // M8094017 has a factor: 82079209186281891049
    { 8306677, 66,        4989275921105ULL }, // M8306677 has a factor: 82888607080993436171
    { 8780743, 66,        4720880505956ULL }, // M8780743 has a factor: 82905676913019210617
    { 9073777, 66,        4664826829332ULL }, // M9073777 has a factor: 84655196785951253929
    { 8278247, 66,        5134009190383ULL }, // M8278247 has a factor: 85001192356520997203
    { 8751557, 66,        4871786091912ULL }, // M8751557 has a factor: 85271427350350213969
    { 9149099, 66,        4818572455107ULL }, // M9149099 has a factor: 88171192860893997187
    { 9109613, 66,        4887875276160ULL }, // M9109613 has a factor: 89053304316171452161
    { 8768987, 66,        5214474352048ULL }, // M8768987 has a factor: 91451315609884670753
    { 9074929, 66,        5040549078264ULL }, // M9074929 has a factor: 91485250012522486513
    { 8206139, 66,        5575498904040ULL }, // M8206139 has a factor: 91506638001799803121
    { 8972669, 66,        5134359735025ULL }, // M8972669 has a factor: 92137820858614063451
    { 8909393, 66,        5254574640888ULL }, // M8909393 has a factor: 93630141047010121969
    { 8813153, 66,        5417571534900ULL }, // M8813153 has a factor: 95491773651037079401
    { 8703971, 66,        5503205267755ULL }, // M8703971 has a factor: 95799478115173510211
    { 9159533, 66,        5269772682160ULL }, // M9159533 has a factor: 96537313569486062561
    { 8158187, 66,        5974642950900ULL }, // M8158187 has a factor: 97484508903348036601
    { 9099017, 66,        5374932044692ULL }, // M9099017 has a factor: 97813196096994535529
    { 8247251, 66,        5995384477435ULL }, // M8247251 has a factor: 98890881253820562371
    { 9142711, 66,        5430756159075ULL }, // M9142711 has a factor: 99303668147785504651
    { 8710397, 66,        5748558494584ULL }, // M8710397 has a factor: 100144453331097979697
    { 9167797, 66,        5468677263137ULL }, // M9167797 has a factor: 100271446013911198379
    { 8951867, 66,        5608576264708ULL }, // M8951867 has a factor: 100414457562045619673
    { 8147653, 66,        6180018574797ULL }, // M8147653 has a factor: 100705293762001002883
    { 8323163, 66,        6060548521656ULL }, // M8323163 has a factor: 100885866430303835857
    { 8845601, 66,        5764656820524ULL }, // M8845601 has a factor: 101983708272567829849
    { 8160577, 66,        6310720850840ULL }, // M8160577 has a factor: 102998246857570669361
    { 8305459, 66,        6215601985619ULL }, // M8305459 has a factor: 103246854903754388243
    { 8729593, 66,        5957191333740ULL }, // M8729593 has a factor: 104007711533354735641
    { 8737237, 66,        6030524067789ULL }, // M8737237 has a factor: 105380236028953117987
    { 8124421, 66,        6505538161040ULL }, // M8124421 has a factor: 105707461703709515681
    { 8034833, 66,        6646775544045ULL }, // M8034833 has a factor: 106811462969771438971
    { 8171873, 66,        6541544355000ULL }, // M8171873 has a factor: 106913339385853830001
    { 8841449, 66,        6079795201620ULL }, // M8841449 has a factor: 107508398411135894761
    { 9033769, 66,        5992135739720ULL }, // M9033769 has a factor: 108263140178549209361
    { 8262347, 66,        6645161598387ULL }, // M8262347 has a factor: 109809261993896068579
    { 8863013, 66,        6257666832772ULL }, // M8863013 has a factor: 110923564977054124073
    { 8974913, 66,        6306787066477ULL }, // M8974913 has a factor: 113205730462312583003
    { 8895989, 66,        6412859607784ULL }, // M8895989 has a factor: 114097457058781556753
    { 9085399, 66,        6348247840079ULL }, // M9085399 has a factor: 115352729156011813043
    { 8726101, 66,        6610033607373ULL }, // M8726101 has a factor: 115359641742662285347
    { 9030733, 66,        6478900526028ULL }, // M9030733 has a factor: 117018441568236837049
    { 8722093, 66,        6725233324352ULL }, // M8722093 has a factor: 117316221003394617473
    { 9099439, 66,        6683915396795ULL }, // M9099439 has a factor: 121639760868593796011
    { 8894243, 66,        6862307028255ULL }, // M8894243 has a factor: 122070052499815671931
    { 8944189, 66,        6835475812844ULL }, // M8944189 has a factor: 122275575150010727033
    { 8942651, 66,        6849070873275ULL }, // M8942651 has a factor: 122497700987927104051
    { 8884339, 66,        6901202381031ULL }, // M8884339 has a factor: 122625242921373147019
    { 8764207, 66,        6996042210164ULL }, // M8764207 has a factor: 122629524221229599897
    { 8940977, 66,        6877639063605ULL }, // M8940977 has a factor: 122985625363987684171
    { 8111599, 66,        7690205807387ULL }, // M8111599 has a factor: 124759731473989163627
    { 8289053, 66,        7546763032197ULL }, // M8289053 has a factor: 125111037504643278883
    { 8948581, 66,        6993914779061ULL }, // M8948581 has a factor: 125171225815048924883
    { 8971139, 66,        6989693831760ULL }, // M8971139 has a factor: 125411029864323149281
    { 8028443, 66,        7958489006575ULL }, // M8028443 has a factor: 127788550710828025451
    { 9068597, 66,        7053506856385ULL }, // M9068597 has a factor: 127930822234584883691
    { 8828723, 66,        7262685193488ULL }, // M8828723 has a factor: 128240471619013911649
    { 8115431, 66,        7933450647544ULL }, // M8115431 has a factor: 128766742644097302929
    { 9037099, 66,        7149748201775ULL }, // M9037099 has a factor: 129225964649025301451
    { 8302967, 66,        7847327542627ULL }, // M8302967 has a factor: 130312203249246148619
    { 8841493, 66,        7392844049400ULL }, // M8841493 has a factor: 130727557825723508401
    { 8059391, 66,        8236018105600ULL }, // M8059391 has a factor: 132754580392219379201
    { 8074379, 66,        8226945810660ULL }, // M8074379 has a factor: 132854956975462160281
    { 9147601, 66,        7300920520584ULL }, // M9147601 has a factor: 133571815710029437969
    { 8907937, 66,        7636552266728ULL }, // M8907937 has a factor: 136051852978440440273
    { 8758583, 66,        7878787092132ULL }, // M8758583 has a factor: 138014021371533537913
    { 8884067, 66,        7801047161647ULL }, // M8884067 has a factor: 138610051308463556699
    { 8726257, 66,        7950254268044ULL }, // M8726257 has a factor: 138751923916597662617
    { 8227987, 66,        8501129359224ULL }, // M8227987 has a factor: 139894363706026804177
    { 8878627, 66,        7935304476768ULL }, // M8878627 has a factor: 140909217161306475073
    { 9075197, 66,        7890016110045ULL }, // M9075197 has a factor: 143206901063664107731
    { 8268889, 66,        8689537168476ULL }, // M8268889 has a factor: 143705636615004686329
    { 8838343, 66,        8184406463256ULL }, // M8838343 has a factor: 144673183147346849617
    { 8079917, 66,        8980030642444ULL }, // M8079917 has a factor: 145115804496808394297
    { 8970979, 66,        8105560287459ULL }, // M8970979 has a factor: 145429622244057304723
    { 9134087, 66,        7996068966883ULL }, // M9134087 has a factor: 146073579203018881643
    { 9198569, 67,        8033010950637ULL }, // M9198569 has a factor: 147784411014380076907
    { 8270209, 67,        8944436021769ULL }, // M8270209 has a factor: 147944710574316359443
    { 8168579, 67,        9212018743915ULL }, // M8168579 has a factor: 150498205718300893571
    { 8861779, 67,        8528499861744ULL }, // M8861779 has a factor: 151155361952611765153
    { 8228461, 67,        9194521625364ULL }, // M8228461 has a factor: 151313525215928569609
    { 8217691, 67,        9236197693868ULL }, // M8217691 has a factor: 151800437326239637577
    { 8716237, 67,        8769847794168ULL }, // M8716237 has a factor: 152880143655791011633
    { 9018019, 67,        8483000395391ULL }, // M9018019 has a factor: 152999717485287100859
    { 9091223, 67,        8461967811943ULL }, // M9091223 has a factor: 153859272794391752579
    { 8290619, 67,        9482237605764ULL }, // M8290619 has a factor: 157227238513723055833
    { 8238751, 67,        9553125671360ULL }, // M8238751 has a factor: 157411647356085742721
    { 8056291, 67,        9843277407440ULL }, // M8056291 has a factor: 158600614376124410081
    { 8782783, 67,        9061266304811ULL }, // M8782783 has a factor: 159166271320733738027
    { 8919541, 67,        9001059401640ULL }, // M8919541 has a factor: 160570636752726894481
    { 9143023, 67,        8791992689991ULL }, // M9143023 has a factor: 160770782760839165587
    { 8336639, 67,        9716595734295ULL }, // M8336639 has a factor: 162007501891514669011
    { 8835481, 67,        9230584157300ULL }, // M8835481 has a factor: 163113301881450322601
    { 8291081, 67,        9918792107793ULL }, // M8291081 has a factor: 164475017575744988467
    { 8090581, 67,       10233736915388ULL }, // M8090581 has a factor: 165593754893273520857
    { 8044109, 67,       10305707293200ULL }, // M8044109 has a factor: 165800465577191517601
    { 8971337, 67,        9456181720000ULL }, // M8971337 has a factor: 169669185886719280001
    { 8983391, 67,        9527560636675ULL }, // M8983391 has a factor: 171179604950920929851
    { 8973001, 67,        9582725303636ULL }, // M8973001 has a factor: 171971607464502263273
    { 8853233, 67,        9786485623488ULL }, // M8853233 has a factor: 173284074951779073409
    { 8793571, 67,        9860936311811ULL }, // M8793571 has a factor: 173425687168776334163
    { 9059353, 67,        9574985381976ULL }, // M9059353 has a factor: 173486345090320843057
    { 8982751, 67,        9914645773988ULL }, // M8982751 has a factor: 178121588481872961977
    { 8338553, 67,       10718580886533ULL }, // M8338553 has a factor: 178754909614284813499
    { 8920463, 67,       10066511640988ULL }, // M8920463 has a factor: 179595889265005474889
    { 8248091, 67,       11038393386220ULL }, // M8248091 has a factor: 182091346286681412041
    { 8902189, 67,       10256669745920ULL }, // M8902189 has a factor: 182613625177523637761
    { 8813267, 67,       10361746014547ULL }, // M8813267 has a factor: 182641668424777190099
    { 9179281, 67,       10131095477088ULL }, // M9179281 has a factor: 185992344444039627457
    { 8336173, 67,       11214525671012ULL }, // M8336173 has a factor: 186972452212994234153
    { 9160973, 67,       10217053012273ULL }, // M9160973 has a factor: 187196293570003243259
    { 9062843, 67,       10366622375220ULL }, // M9062843 has a factor: 187902142053811900921
    { 9059207, 67,       10378032353400ULL }, // M9059207 has a factor: 188033486684295507601
    { 8720339, 67,       10799119876731ULL }, // M8720339 has a factor: 188343972453465063619
    { 8026727, 67,       11755121339884ULL }, // M8026727 has a factor: 188710299694246159337
    { 8766337, 67,       10783340479457ULL }, // M8766337 has a factor: 189060793257323278019
    { 8092291, 67,       11701695146708ULL }, // M8092291 has a factor: 189387044640897656057
    { 8947487, 67,       10606176389475ULL }, // M8947487 has a factor: 189797250729068998651
    { 8794811, 67,       10815249196180ULL }, // M8794811 has a factor: 190236145196610043961
    { 8129129, 67,       11962981254169ULL }, // M8129129 has a factor: 194497235679443177603
    { 8804833, 67,       11080568185893ULL }, // M8804833 has a factor: 195125104843801641739
    { 8009977, 67,       12231239765885ULL }, // M8009977 has a factor: 195943898412448469291
    { 9194083, 67,       10666678080260ULL }, // M9194083 has a factor: 196140647208382203161
    { 8988877, 67,       11090287193000ULL }, // M8988877 has a factor: 199378454945104522001
    { 8798201, 67,       11399271911625ULL }, // M8798201 has a factor: 200586171064261973251
    { 8248187, 67,       12192445886740ULL }, // M8248187 has a factor: 201131147322424680761
    { 8233369, 67,       12378521082620ULL }, // M8233369 has a factor: 203833863494979893561
    { 8950951, 67,       11397100227888ULL }, // M8950951 has a factor: 204029771363828642977
    { 8797487, 67,       11708334591840ULL }, // M8797487 has a factor: 206007842726725412161
    { 9012319, 67,       11508647463140ULL }, // M9012319 has a factor: 207439204392716843321
    { 8291509, 67,       12889386935040ULL }, // M8291509 has a factor: 213744935552733150721
    { 8821979, 67,       12117131423376ULL }, // M8821979 has a factor: 213794157914526362209
    { 9153139, 67,       11792367835119ULL }, // M9153139 has a factor: 215874363867946577083
    { 8728597, 67,       12618171642069ULL }, // M8728597 has a factor: 220277870280897094387
    { 8733311, 67,       12702187424316ULL }, // M8733311 has a factor: 221864306313681180553
    { 8162501, 67,       13686748053760ULL }, // M8162501 has a factor: 223436189351128107521
    { 8035693, 67,       14222222264312ULL }, // M8035693 has a factor: 228570823787552176433
    { 9008803, 67,       12852519658091ULL }, // M9008803 has a factor: 231571635306738350147
    { 8715349, 67,       13444582850649ULL }, // M8715349 has a factor: 234348463405641823003
    { 8792467, 67,       13404273010863ULL }, // M8792467 has a factor: 235713256214007138043
    { 8212397, 67,       14443786388805ULL }, // M8212397 has a factor: 237236216016126031171
    { 8955493, 67,       13341424401488ULL }, // M8955493 has a factor: 238958065675109947169
    { 8320541, 67,       14361806722941ULL }, // M8320541 has a factor: 238996003344612462163
    { 8330411, 67,       14391814829031ULL }, // M8330411 has a factor: 239779465123445923483
    { 9005099, 67,       13323267249424ULL }, // M9005099 has a factor: 239954681169041625953
    { 8884849, 67,       13599463304685ULL }, // M8884849 has a factor: 241658355886334435131
    { 8768377, 67,       13894267953140ULL }, // M8768377 has a factor: 243660359104299707561
    { 8906489, 67,       13715325531577ULL }, // M8906489 has a factor: 244310791956819406307
    { 8822377, 67,       13992609363624ULL }, // M8822377 has a factor: 246896150039242028497
    { 9099401, 67,       13620431422936ULL }, // M9099401 has a factor: 247875534620590522673
    { 8787733, 67,       14251209774336ULL }, // M8787733 has a factor: 250471652847710040577
    { 8342183, 67,       15035162419956ULL }, // M8342183 has a factor: 250852152683991607897
    { 8761517, 67,       14333482135485ULL }, // M8761517 has a factor: 251166094798496261491
    { 8281391, 67,       15240939238248ULL }, // M8281391 has a factor: 252432354078347685937
    { 8776931, 67,       14473609487575ULL }, // M8776931 has a factor: 254067743586782264651
    { 8137043, 67,       15677318030031ULL }, // M8137043 has a factor: 255134021870075076667
    { 8144933, 67,       15685297148125ULL }, // M8144933 has a factor: 255511388713138401251
    { 9066047, 67,       14224759678363ULL }, // M9066047 has a factor: 257924679615487682123
    { 9015229, 67,       14424288449865ULL }, // M9015229 has a factor: 260076527075175988171
    { 8793221, 67,       14862731863816ULL }, // M8793221 has a factor: 261382571884551982673
    { 8055787, 67,       16401098940072ULL }, // M8055787 has a factor: 264247519254291593329
    { 8706337, 67,       15226487781965ULL }, // M8706337 has a factor: 265133867912339624411
    { 8756401, 67,       15236308794153ULL }, // M8756401 has a factor: 266830459122860246707
    { 8275037, 67,       16136526876372ULL }, // M8275037 has a factor: 267060713906945451529
    { 8852323, 67,       15156449903016ULL }, // M8852323 has a factor: 268339580149632612337
    { 8831957, 67,       15351822105625ULL }, // M8831957 has a factor: 271173265417058916251
    { 8806781, 67,       15527131839636ULL }, // M8806781 has a factor: 273488099339602743433
    { 8190407, 67,       16707254523892ULL }, // M8190407 has a factor: 273678428806533408089
    { 8858329, 67,       15591834687525ULL }, // M8858329 has a factor: 276235202751417291451
    { 8137211, 67,       16988550990403ULL }, // M8137211 has a factor: 276478847986336372067
    { 8897687, 67,       15660847513360ULL }, // M8897687 has a factor: 278690638657211196641
    { 9062917, 67,       15413312438709ULL }, // M9062917 has a factor: 279379142654174508307
    { 8206447, 67,       17410203214595ULL }, // M8206447 has a factor: 285751819879606987931
    { 8014807, 67,       17902243339040ULL }, // M8014807 has a factor: 286966050458882330561
    { 8844347, 67,       16379469035343ULL }, // M8844347 has a factor: 289731415648657512043
    { 8001269, 67,       18179054243172ULL }, // M8001269 has a factor: 290911006330421170537
    { 8978353, 67,       16307616202457ULL }, // M8978353 has a factor: 292831069708356826643
    { 8313913, 68,       17832277346352ULL }, // M8313913 has a factor: 296512004898882790753
    { 9004019, 68,       16586517767200ULL }, // M9004019 has a factor: 298690642239412753601
    { 8764489, 68,       17316861193229ULL }, // M8764489 has a factor: 303546878885164889963
    { 8989609, 68,       17000954394144ULL }, // M8989609 has a factor: 305663865260372899393
    { 8253061, 68,       18688430978048ULL }, // M8253061 has a factor: 308473521712239609857
    { 8801473, 68,       17866086929340ULL }, // M8801473 has a factor: 314495763448477835641
    { 8249071, 68,       19208236246296ULL }, // M8249071 has a factor: 316900209160938382033
    { 8951851, 68,       17768020089683ULL }, // M8951851 has a factor: 318113336815697706467
    { 8878603, 68,       18414476907272ULL }, // M8878603 has a factor: 326989659824671802033
    { 9139517, 68,       17908219067017ULL }, // M9139517 has a factor: 327344945205452021579
    { 9138247, 68,       17973816001232ULL }, // M9138247 has a factor: 328498340303620640609
    { 8701177, 68,       18915796469640ULL }, // M8701177 has a factor: 329179386356625532561
    { 9160087, 68,       18194991470075ULL }, // M9160087 has a factor: 333335409660289793051
    { 8993417, 68,       18545083207668ULL }, // M8993417 has a factor: 333567333172511843113
    { 9028519, 68,       18692837640867ULL }, // M9028519 has a factor: 337537279608965771947
    { 9173777, 68,       18514280992804ULL }, // M9173777 has a factor: 339691770286645001417
    { 8340623, 68,       20990160264220ULL }, // M8340623 has a factor: 350142026946878818121
    { 8241593, 68,       21796419210321ULL }, // M8241593 has a factor: 359274431977694162707
    { 8919623, 68,       20150320349872ULL }, // M8919623 has a factor: 359466521700172676513
    { 9009851, 68,       20508604923835ULL }, // M9009851 has a factor: 369558949163239397171
    { 8933801, 68,       20800752352585ULL }, // M8933801 has a factor: 371659564336552451171
    { 8813897, 68,       21911449170888ULL }, // M8813897 has a factor: 386250512225884461073
    { 8914853, 68,       21837639832377ULL }, // M8914853 has a factor: 389358697945171191163
    { 8287813, 68,       23711028959708ULL }, // M8287813 has a factor: 393025148111288877209
    { 9087223, 68,       21788548209935ULL }, // M9087223 has a factor: 395994792859860321011
    { 8328377, 68,       24123570059292ULL }, // M8328377 has a factor: 401820372079392258169
    { 8734367, 68,       23027637567204ULL }, // M8734367 has a factor: 402263675309893799737
    { 8247583, 68,       24453118413240ULL }, // M8247583 has a factor: 403358247444050397841
    { 8235697, 68,       24523146622344ULL }, // M8235697 has a factor: 403930410136397227537
    { 8707093, 68,       23238904139441ULL }, // M8707093 has a factor: 404686599120395510027
    { 8132549, 68,       25417245770097ULL }, // M8132549 has a factor: 413413993340713174507
    { 9194179, 68,       22531016969424ULL }, // M9194179 has a factor: 414308406137843565793
    { 8936777, 68,       23193861928192ULL }, // M8936777 has a factor: 414556743642083834369
    { 9054631, 68,       22919709716475ULL }, // M9054631 has a factor: 415059028219591491451
    { 9040529, 68,       22995849064860ULL }, // M9040529 has a factor: 415789280700979421881
    { 9120889, 68,       23101545528252ULL }, // M9120889 has a factor: 421413264983265712057
    { 8838953, 68,       24124106547408ULL }, // M8838953 has a factor: 426463687879063167649
    { 8790169, 68,       24417438447696ULL }, // M8790169 has a factor: 429266821004691001249
    { 8268187, 68,       26499637870928ULL }, // M8268187 has a factor: 438207922698229135073
    { 8257237, 68,       26826268366857ULL }, // M8257237 has a factor: 443021711461482388219
    { 8713603, 68,       25431991428116ULL }, // M8713603 has a factor: 443208553608011723897
    { 8760209, 68,       25679303061400ULL }, // M8760209 has a factor: 449912123584407665201
    { 8822977, 68,       25981702601064ULL }, // M8822977 has a factor: 458471928940055695057
    { 9147161, 68,       25355826390205ULL }, // M9147161 has a factor: 463867652558507916011
    { 9036151, 68,       25696317532259ULL }, // M9036151 has a factor: 464391610730879390219
    { 8986283, 68,       25918089471616ULL }, // M8986283 has a factor: 465814573622523686657
    { 8319257, 68,       28410422864193ULL }, // M8319257 has a factor: 472707218571795329203
    { 8933257, 68,       26563392545508ULL }, // M8933257 has a factor: 474595224801814319113
    { 8907697, 68,       27106621187865ULL }, // M8907697 has a factor: 482915136470562993811
    { 9132427, 68,       26539235799528ULL }, // M9132427 has a factor: 484735267149952188913
    { 9000499, 68,       27440884071819ULL }, // M9000499 has a factor: 493963299295045675363
    { 9046547, 68,       27829192113768ULL }, // M9046547 has a factor: 503516188858463118193
    { 8904737, 68,       28274982476917ULL }, // M8904737 has a factor: 503562565273108911659
    { 8818357, 68,       28669475694513ULL }, // M8818357 has a factor: 505635343354077150283
    { 8847731, 68,       29135241168280ULL }, // M8847731 has a factor: 515561552954134345361
    { 9045733, 68,       28867684264025ULL }, // M9045733 has a factor: 522258728361343310651
    { 8327269, 68,       31928919838629ULL }, // M8327269 has a factor: 531761408751400548403
    { 8109917, 68,       32832380377909ULL }, // M8109917 has a factor: 532535759554541247107
    { 8252977, 68,       32738423792600ULL }, // M8252977 has a factor: 540378917153161140401
    { 8232439, 68,       33044160157244ULL }, // M8232439 has a factor: 544068065601483276233
    { 8824999, 68,       31257725528079ULL }, // M8824999 has a factor: 551698793055143293843
    { 8246827, 68,       33465583325768ULL }, // M8246827 has a factor: 551969752283386676273
    { 9142373, 68,       30261044114112ULL }, // M9142373 has a factor: 553315505321332935553
    { 8911141, 68,       31329299983385ULL }, // M8911141 has a factor: 558359619166482784571
    { 8825779, 68,       31970359650464ULL }, // M8825779 has a factor: 564326657651025022913
    { 8768423, 68,       32524287327631ULL }, // M8768423 has a factor: 570373418124416391827
    { 8118853, 68,       35337117241440ULL }, // M8118853 has a factor: 573793720654033736641
    { 8270699, 68,       34907573021307ULL }, // M8270699 has a factor: 577420058559501567187
    { 9005021, 68,       32254749037800ULL }, // M9005021 has a factor: 580909384870237587601
    { 9171947, 68,       31811488351764ULL }, // M9171947 has a factor: 583546570306993529017
    { 8911069, 68,       32801697776745ULL }, // M8911069 has a factor: 584596384411442580811
    { 9083401, 69,       32669815530513ULL }, // M9083401 has a factor: 593506070119354629427
    { 8955841, 69,       33318067728056ULL }, // M8955841 has a factor: 596782633999401550193
    { 8726203, 69,       34415454317031ULL }, // M8726203 has a factor: 600632481415277726587
    { 9032753, 69,       33326703753960ULL }, // M9032753 has a factor: 602063766627386903761
    { 8190359, 69,       37352145766144ULL }, // M8190359 has a factor: 611854966490098811393
    { 8871337, 69,       34704171471837ULL }, // M8871337 has a factor: 615744800864904072139
    { 8068493, 69,       38262769523340ULL }, // M8068493 has a factor: 617445776119364253241
    { 8068579, 69,       38540662499924ULL }, // M8068579 has a factor: 621936760185948575993
    { 8946727, 69,       35077338754724ULL }, // M8946727 has a factor: 627654747450071176697
    { 8225579, 69,       38220173249500ULL }, // M8225579 has a factor: 628766108914897921001
    { 8171731, 69,       38746076746595ULL }, // M8171731 has a factor: 633245032957059011891
    { 8820803, 69,       35990759638008ULL }, // M8820803 has a factor: 634934801174439760849
    { 8998063, 69,       35390330738735ULL }, // M8998063 has a factor: 636888851155948140611
    { 8006797, 69,       40962738660153ULL }, // M8006797 has a factor: 655960666031794119883
    { 8320813, 69,       39654802316948ULL }, // M8320813 has a factor: 659920389262582077449
    { 9177307, 69,       36151253653235ULL }, // M9177307 has a factor: 663542306421218276291
    { 9121627, 69,       37526855724132ULL }, // M9121627 has a factor: 684611960796694005529
    { 8059427, 69,       42656292175195ULL }, // M8059427 has a factor: 687570545753310626531
    { 8810741, 69,       39219007081149ULL }, // M8810741 has a factor: 691097027338339642819
    { 8980061, 69,       39492672976780ULL }, // M8980061 has a factor: 709293224769071967161
    { 9046459, 69,       39629075140187ULL }, // M9046459 has a factor: 717005606927241895667
    { 9190789, 69,       39803229235220ULL }, // M9190789 has a factor: 731646162839076777161
    { 8103497, 69,       45171739643289ULL }, // M8103497 has a factor: 732098113368346963267
    { 8066039, 69,       45465092347719ULL }, // M8066039 has a factor: 733446416030606030083
    { 8837659, 69,       41909609939039ULL }, // M8837659 has a factor: 740765682928474939403
    { 8021017, 69,       46207298505288ULL }, // M8021017 has a factor: 741259053669979275793
    { 8839459, 69,       42025989890040ULL }, // M8839459 has a factor: 742974029134846176721
    { 9093727, 69,       41399434495488ULL }, // M9093727 has a factor: 752950310512701207553
    { 8795797, 69,       42821385484484ULL }, // M8795797 has a factor: 753296427960535827497
    { 8043977, 69,       47160679496985ULL }, // M8043977 has a factor: 758718842356237818691
    { 8928389, 69,       42650380946844ULL }, // M8928389 has a factor: 761598384183223108633
    { 9167167, 69,       41551266533084ULL }, // M9167167 has a factor: 761814798740584106057
    { 8994613, 69,       42409963981428ULL }, // M8994613 has a factor: 762922426713768094729
    { 9054407, 69,       42443964040443ULL }, // M9054407 has a factor: 768609850231070764603
    { 8222183, 69,       47195160495627ULL }, // M8222183 has a factor: 776094492618831787483
    { 8934139, 69,       43913943758891ULL }, // M8934139 has a factor: 784666555160229359699
    { 8706547, 69,       45397518300392ULL }, // M8706547 has a factor: 790511253531446132849
    { 8093671, 69,       49015607339000ULL }, // M8093671 has a factor: 793432399334102938001
    { 8321813, 69,       48024633983956ULL }, // M8321813 has a factor: 799304046815853664457
    { 8005241, 69,       51483683587185ULL }, // M8005241 has a factor: 824278589366320873171
    { 8031187, 69,       51799318340040ULL }, // M8031187 has a factor: 832020024122781654961
    { 8901587, 69,       46787780364444ULL }, // M8901587 has a factor: 832970994901979945257
    { 8934283, 69,       46679450782643ULL }, // M8934283 has a factor: 834094847153408099939
    { 8282837, 69,       50608639347357ULL }, // M8282837 has a factor: 838366221011888823619
    { 9169861, 69,       45741673322700ULL }, // M9169861 has a factor: 838889572553134289401
    { 8986739, 69,       47320430259564ULL }, // M8986739 has a factor: 850512712220807843593
    { 9175093, 69,       46515887411205ULL }, // M9175093 has a factor: 853575185950670234131
    { 8265419, 69,       53081233200220ULL }, // M8265419 has a factor: 877477266873058384361
    { 8724559, 69,       50426352068475ULL }, // M8724559 has a factor: 879895367552364355051
    { 8335183, 69,       53241290214368ULL }, // M8335183 has a factor: 887551794185733018689
    { 8772859, 69,       50677319645891ULL }, // M8772859 has a factor: 889169959502663344739
    { 8740129, 69,       50903923825277ULL }, // M8740129 has a factor: 889813721678188881467
    { 8790137, 69,       51637462083328ULL }, // M8790137 has a factor: 907800732089517071873
    { 9161723, 69,       49965868162375ULL }, // M9161723 has a factor: 915546887116397544251
    { 9158251, 69,       51098022865563ULL }, // M9158251 has a factor: 935937038013130420627
    { 8761993, 69,       53741104461192ULL }, // M8761993 has a factor: 941758362202466151313
    { 9045697, 69,       52649259412640ULL }, // M9045697 has a factor: 952498495842278820161
    { 8295971, 69,       57511756383588ULL }, // M8295971 has a factor: 954231726234621847897
    { 8136077, 69,       59065490799117ULL }, // M8136077 has a factor: 961122762368814888019
    { 8957093, 69,       53667770756100ULL }, // M8957093 has a factor: 961414427530136034601
    { 9086417, 69,       52907118260733ULL }, // M9086417 has a factor: 961472277570669527323
    { 8838391, 69,       54532772882024ULL }, // M8838391 has a factor: 963963938091049966769
    { 8176237, 69,       59966893738704ULL }, // M8176237 has a factor: 980607070722919953697
    { 8925599, 69,       55004690220559ULL }, // M8925599 has a factor: 981899616055862379683
    { 8206069, 69,       60753009556772ULL }, // M8206069 has a factor: 997086776761060898537
    { 8938469, 69,       56439406423996ULL }, // M8938469 has a factor: 1008963769398578204249
    { 8092433, 69,       62416556639172ULL }, // M8092433 has a factor: 1010203605386409170953
    { 8732833, 69,       59194830764445ULL }, // M8732833 has a factor: 1033877143058321045371
    { 9129767, 69,       56784759476388ULL }, // M9129767 has a factor: 1036863246340928883193
    { 8700871, 69,       60047300918264ULL }, // M8700871 has a factor: 1044927638375993215889
    { 8096219, 69,       65468679093804ULL }, // M8096219 has a factor: 1060097527168317454153
    { 8304209, 69,       65518273335252ULL }, // M8304209 has a factor: 1088154870190119351337
    { 8057089, 69,       67575869700564ULL }, // M8057089 has a factor: 1088929592859694996393
    { 8774659, 69,       63226232401344ULL }, // M8774659 has a factor: 1109577258353089483393
    { 8252149, 69,       68088752527077ULL }, // M8252149 has a factor: 1123757062155131876947
    { 8008337, 69,       70594022543473ULL }, // M8008337 has a factor: 1130681445427457868803
    { 9015359, 69,       64333865720392ULL }, // M9015359 has a factor: 1159985790654255001457
    { 9185749, 69,       63261336618000ULL }, // M9185749 has a factor: 1162205519154913764001
    { 8164297, 69,       71385260632317ULL }, // M8164297 has a factor: 1165620938449287572299
    { 8966357, 69,       65129273067772ULL }, // M8966357 has a factor: 1167944626952257893209
    { 9079727, 70,       65077471661184ULL }, // M9079727 has a factor: 1181771353067574433537
    { 9000487, 70,       66739433786403ULL }, // M9000487 has a factor: 1201374812363761956523
    { 8782369, 70,       68600022640365ULL }, // M8782369 has a factor: 1204941424472079449371
    { 8274713, 70,       73323681628465ULL }, // M8274713 has a factor: 1213464843157841011091
    { 8899783, 70,       69998178413388ULL }, // M8899783 has a factor: 1245937196548874989609
    { 8061679, 70,       79389810517031ULL }, // M8061679 has a factor: 1280030336518255910099
    { 9056633, 70,       71587596036736ULL }, // M9056633 has a factor: 1296685169313944939777
    { 8955587, 70,       72526339524363ULL }, // M8955587 has a factor: 1299031886803942932163
    { 8835751, 70,       74750034594755ULL }, // M8835751 has a factor: 1320945385841282172011
    { 8796083, 70,       75392694951895ULL }, // M8796083 has a factor: 1326320804781098854571
    { 9191989, 70,       72779062042305ULL }, // M9191989 has a factor: 1337968675446370189291
    { 8207041, 70,       81622435016408ULL }, // M8207041 has a factor: 1339757341398992257457
    { 9144689, 70,       73298326402281ULL }, // M9144689 has a factor: 1340580798338697271219
    { 9065377, 70,       73980646921428ULL }, // M9065377 has a factor: 1341324910093268396713
    { 8822647, 70,       76245238226808ULL }, // M8822647 has a factor: 1345369644612065841553
    { 8926609, 70,       77384207932997ULL }, // M8926609 has a factor: 1381557133985124834347
    { 8783587, 70,       78654411599580ULL }, // M8783587 has a factor: 1381735734437440186921
    { 8796659, 70,       78735165161311ULL }, // M8796659 has a factor: 1385212798465465719899
    { 9071779, 70,       77577161851184ULL }, // M9071779 has a factor: 1407525735522344272673
    { 8912723, 70,       79705819053960ULL }, // M8912723 has a factor: 1420791773432135066161
    { 8712931, 70,       82888139707539ULL }, // M8712931 has a factor: 1444397283980294973619
    { 8747539, 70,       83717487973455ULL }, // M8747539 has a factor: 1464643982059657154491
    { 8237701, 70,       91752409458720ULL }, // M8237701 has a factor: 1511657830301014405441
    { 9064817, 70,       85745791591132ULL }, // M9064817 has a factor: 1554539818587500805689
    { 9185317, 70,       84718105906313ULL }, // M9185317 has a factor: 1556325316778114412443
    { 8964947, 70,       86997064106644ULL }, // M8964947 has a factor: 1559848137743331615737
    { 9058957, 70,       86221575866993ULL }, // M9058957 has a factor: 1562155096502654612603
    { 9165883, 70,       86398449539640ULL }, // M9165883 has a factor: 1583836159723488204241
    { 8201989, 70,       96770262904445ULL }, // M8201989 has a factor: 1587417263738731882211
    { 8904451, 70,       89424517412555ULL }, // M8904451 has a factor: 1592552466997485564611
    { 8840113, 70,       90758973554265ULL }, // M8840113 has a factor: 1604639163967428463891
    { 8979263, 70,       89406944434996ULL }, // M8979263 has a factor: 1605616936216430975897
    { 8820257, 70,       91050544057737ULL }, // M8820257 has a factor: 1606178397158126356819
    { 8107531, 70,       99854118557799ULL }, // M8107531 has a factor: 1619140723370061368539
    { 8987149, 70,       91298887615485ULL }, // M8987149 has a factor: 1641033413069236804531
    { 9133991, 70,       92955947431968ULL }, // M9133991 has a factor: 1698117574480137648577
    { 8086693, 70,      105140383247072ULL }, // M8086693 has a factor: 1700476002442828825793
    { 8967659, 70,       95186726471100ULL }, // M8967659 has a factor: 1707204208638196309801
    { 9167423, 70,       94598331342060ULL }, // M9167423 has a factor: 1734445837013643422761
    { 8039797, 70,      108641349130905ULL }, // M8039797 has a factor: 1746908785637205252571
    { 8189009, 70,      107729778862272ULL }, // M8189009 has a factor: 1764400257342310336897
    { 8276831, 70,      106704191083023ULL }, // M8276831 has a factor: 1766345113171776680227
    { 8817253, 70,      102406316839757ULL }, // M8817253 has a factor: 1805884808748595855043
    { 9028337, 70,      102006282896332ULL }, // M9028337 has a factor: 1841894196210842719769
    { 8727611, 70,      107120471304000ULL }, // M8727611 has a factor: 1869811607355949488001
    { 8762261, 70,      107337786702804ULL }, // M8762261 has a factor: 1881043404504596159689
    { 8983699, 70,      104920276458599ULL }, // M8983699 has a factor: 1885144365401678755403
    { 8924887, 70,      108412100370755ULL }, // M8924887 has a factor: 1935131490483292959371
    { 9054707, 70,      108601314994047ULL }, // M9054707 has a factor: 1966706174171604658459
    { 8701703, 70,      113031981369796ULL }, // M8701703 has a factor: 1967141462762995925177
    { 8152021, 70,      122266956401309ULL }, // M8152021 has a factor: 1993445592379110790979
    { 9085163, 70,      109908676356027ULL }, // M9085163 has a factor: 1997076479617502654803
    { 8737481, 70,      115305315322716ULL }, // M8737481 has a factor: 2014956003662479836793
    { 8131741, 70,      124345492812468ULL }, // M8131741 has a factor: 2022290684136702693577
    { 8794193, 70,      118392818992440ULL }, // M8794193 has a factor: 2082338600067165801841
    { 9196639, 70,      115934107499859ULL }, // M9196639 has a factor: 2132408268926791547803
    { 9005401, 70,      120006609390069ULL }, // M9005401 has a factor: 2161415280415873525339
    { 9124249, 70,      123805913221701ULL }, // M9124249 has a factor: 2259271959814384255099
    { 8005519, 70,      145968315868511ULL }, // M8005519 has a factor: 2337104252166732624419
    { 8986573, 70,      130794482529660ULL }, // M8986573 has a factor: 2350788330500028510361
    { 8187887, 70,      143889549170968ULL }, // M8187887 has a factor: 2356302738185659329233
    { 9163813, 71,      129942064140200ULL }, // M9163813 has a factor: 2381529553229597165201
    { 8803097, 71,      135902336459929ULL }, // M8803097 has a factor: 2392722900766783200227
    { 9016291, 71,      137409248518595ULL }, // M9016291 has a factor: 2477843541469942862291
    { 9141673, 71,      135623215547061ULL }, // M9141673 has a factor: 2479646175479495546107
    { 9165811, 71,      137351251164759ULL }, // M9165811 has a factor: 2517871217579421709099
    { 8751733, 71,      144059429467212ULL }, // M8751733 has a factor: 2521539325658743356793
    { 8268067, 71,      153054408929480ULL }, // M8268067 has a factor: 2530928215348677830321
    { 8303249, 71,      154561808087136ULL }, // M8303249 has a factor: 2566730356875407809729
    { 8921573, 71,      143943357762648ULL }, // M8921573 has a factor: 2568402348289161610609
    { 8797777, 71,      146188235639460ULL }, // M8797777 has a factor: 2572262994358842960841
    { 8032223, 71,      160813112061472ULL }, // M8032223 has a factor: 2583373554803465624513
    { 8812361, 71,      146684585095825ULL }, // M8812361 has a factor: 2585275033999258985651
    { 8092871, 71,      160773085248444ULL }, // M8092871 has a factor: 2602231678375320485449
    { 9042503, 71,      145145613950527ULL }, // M9042503 has a factor: 2624959299168964498163
    { 8968651, 71,      147398472386135ULL }, // M8968651 has a factor: 2643930913528764107771
    { 8715193, 71,      152168060862485ULL }, // M8715193 has a factor: 2652348037704606469211
    { 9062129, 71,      146776487644876ULL }, // M9062129 has a factor: 2660214930409545002009
    { 8809337, 71,      153315508961593ULL }, // M8809337 has a factor: 2701215971538385587683
    { 8032889, 71,      175213683310897ULL }, // M8032889 has a factor: 2814944138635176182867
    { 8757691, 71,      163377358455848ULL }, // M8757691 has a factor: 2861616843505107853937
    { 8972147, 71,      160110293077224ULL }, // M8972147 has a factor: 2873066171403872159857
    { 8120599, 71,      180940320893615ULL }, // M8120599 has a factor: 2938687577816738150771
    { 8159419, 71,      181277089104251ULL }, // M8159419 has a factor: 2958231450203837180339
    { 8896843, 71,      167733988647776ULL }, // M8896843 has a factor: 2984605925526090742337
    { 8324791, 71,      179712526635284ULL }, // M8324791 has a factor: 2992138448641345051289
    { 8824301, 71,      170001169149265ULL }, // M8824301 has a factor: 3000282973850056577531
    { 8705549, 71,      174837826302300ULL }, // M8705549 has a factor: 3044118527856322925401
    { 8995843, 71,      169518724646535ULL }, // M8995843 has a factor: 3049927664960918708011
    { 8017741, 71,      190537152487773ULL }, // M8017741 has a factor: 3055355079048939161587
    { 8239261, 71,      186605567519916ULL }, // M8239261 has a factor: 3074983949699421244153
    { 9176339, 71,      172170088288296ULL }, // M9176339 has a factor: 3159782191586667656689
    { 9128909, 71,      174283268586240ULL }, // M9128909 has a factor: 3182032198292687224321
    { 9016757, 71,      176622414335157ULL }, // M9016757 has a factor: 3185122781626854451699
    { 8810729, 71,      181630850031417ULL }, // M8810729 has a factor: 3200600395332913345987
    { 9136051, 71,      175875267704508ULL }, // M9136051 has a factor: 3213610830774076035817
    { 9070097, 71,      177514337845669ULL }, // M9070097 has a factor: 3220144526301977719787
    { 8007431, 71,      203440040597895ULL }, // M8007431 has a factor: 3258064175449685915491
    { 8964379, 71,      182602567934015ULL }, // M8964379 has a factor: 3273837250667514903371
    { 9090247, 71,      181174959945599ULL }, // M9090247 has a factor: 3293850272241202945907
    { 9170807, 71,      180709300289739ULL }, // M9170807 has a factor: 3314500232124480898747
    { 8055379, 71,      208408553676455ULL }, // M8055379 has a factor: 3357619773411376802891
    { 8212877, 71,      206685468028200ULL }, // M8212877 has a factor: 3394964653206078262801
    { 9164591, 71,      185863112808283ULL }, // M9164591 has a factor: 3406718821749550214507
    { 8351771, 71,      208413645225036ULL }, // M8351771 has a factor: 3481246076389488277513
    { 9199559, 71,      193039464513595ULL }, // M9199559 has a factor: 3551755886242447009211
    { 8244191, 71,      215774476001880ULL }, // M8244191 has a factor: 3557771986168830158161
    { 9128297, 71,      199627585756000ULL }, // M9128297 has a factor: 3644519784347475064001
    { 9120011, 71,      201016104600675ULL }, // M9120011 has a factor: 3666538170270613214851
    { 9149053, 71,      201081183524405ULL }, // M9149053 has a factor: 3679404810735016276931
    { 9051257, 71,      205749341858320ULL }, // M9051257 has a factor: 3724580341481023816481
    { 8866159, 71,      217075923883212ULL }, // M8866159 has a factor: 3849259312440910045417
    { 8939731, 71,      228275382339396ULL }, // M8939731 has a factor: 4081441024072701884953
    { 8355583, 71,      245972771421648ULL }, // M8355583 has a factor: 4110491814707215721569
    { 8919389, 71,      232569797836344ULL }, // M8919389 has a factor: 4148760993107420947633
    { 8821139, 71,      240285823784895ULL }, // M8821139 has a factor: 4239189302672129790811
    { 9154909, 71,      235513506846000ULL }, // M9154909 has a factor: 4312209446892014028001
    { 9152491, 71,      238468370207588ULL }, // M9152491 has a factor: 4365159224219234603417
    { 8890411, 71,      246048888307815ULL }, // M8890411 has a factor: 4374951486299139723931
    { 8176957, 71,      269246868888680ULL }, // M8176957 has a factor: 4403240138574748293521
    { 8958641, 71,      248272462102449ULL }, // M8958641 has a factor: 4448367716323891623619
    { 8229737, 71,      272896534135965ULL }, // M8229737 has a factor: 4491733408301028382411
    { 9193543, 71,      244984532393675ULL }, // M9193543 has a factor: 4504551665792288081051
    { 8326273, 71,      276157586963001ULL }, // M8326273 has a factor: 4598726920150374450547
    { 8200559, 71,      281292060255327ULL }, // M8200559 has a factor: 4613504272710728255587
    { 8280583, 71,      280831867911380ULL }, // M8280583 has a factor: 4650903182570437469081
    { 8328031, 71,      282164793103604ULL }, // M8328031 has a factor: 4699754288150800647449
    { 9141397, 72,      259635875223980ULL }, // M9141397 has a factor: 4746869221729730200121
    { 8146937, 72,      295218142533832ULL }, // M8146937 has a factor: 4810247216960299345169
    { 8953757, 72,      269397782143732ULL }, // M8953757 has a factor: 4824244555307830802249
    { 8935439, 72,      276232781394516ULL }, // M8935439 has a factor: 4936522335902065305049
    { 8905447, 72,      279080036446880ULL }, // M8905447 has a factor: 4970664946671516310721
    { 9005011, 72,      281520458059784ULL }, // M9005011 has a factor: 5070189643106787155249
    { 8903131, 72,      286009869485495ULL }, // M8903131 has a factor: 5092766670644529169691
    { 8774141, 72,      292001300959060ULL }, // M8774141 has a factor: 5124121173596455334921
    { 9163313, 72,      281047369260393ULL }, // M9163313 has a factor: 5150650024719119124019
    { 8236867, 72,      325031171045139ULL }, // M8236867 has a factor: 5354477053506121879027
    { 8217227, 72,      328362565918803ULL }, // M8217227 has a factor: 5396459484914535638563
    { 8896211, 72,      303400072260016ULL }, // M8896211 has a factor: 5398222120480698398753
    { 8955929, 72,      306533348378464ULL }, // M8955929 has a factor: 5490581808419577426113
    { 8839361, 72,      316177161844776ULL }, // M8839361 has a factor: 5589608147002802056273
    { 8870369, 72,      316412502866976ULL }, // M8870369 has a factor: 5613391313287270068289
    { 8974607, 72,      313602801827679ULL }, // M8974607 has a factor: 5628923801004601494307
    { 8291401, 72,      340219601735853ULL }, // M8291401 has a factor: 5641794292104506600107
    { 9060593, 72,      318943310576613ULL }, // M9060593 has a factor: 5779631054414571423019
    { 8735897, 72,      335108263880785ULL }, // M8735897 has a factor: 5854942554222716078291
    { 9175171, 72,      320849337824796ULL }, // M9175171 has a factor: 5887695079558542680233
    { 8819611, 72,      334639513452608ULL }, // M8819611 has a factor: 5902780667762538990977
    { 8890447, 72,      333615634086075ULL }, // M8890447 has a factor: 5931984226427286451051
    { 8897929, 72,      340711294613612ULL }, // M8897929 has a factor: 6063249817940004019097
    { 9164011, 72,      332510426021199ULL }, // M9164011 has a factor: 6094258403345907738379
    { 9177097, 72,      342711473688552ULL }, // M9177097 has a factor: 6290192874105578987089
    { 8877527, 72,      354650902912504ULL }, // M8877527 has a factor: 6296845932360265795217
    { 9019039, 72,      355907346967419ULL }, // M9019039 has a factor: 6419884485371367380683
    { 9149857, 72,      352129694574548ULL }, // M9149857 has a factor: 6443872701621580079273
    { 8945117, 72,      360542671168353ULL }, // M8945117 has a factor: 6450192754186888564603
    { 9018257, 72,      381485856919605ULL }, // M9018257 has a factor: 6880674999132452456971
    { 8045419, 72,      438945482760480ULL }, // M8045419 has a factor: 7063000653930676482241
    { 8347021, 72,      426976645277604ULL }, // M8347021 has a factor: 7127966049283422835369
    { 8921833, 72,      403106819990336ULL }, // M8921833 has a factor: 7192903458229678811777
    { 8751773, 72,      419911154193612ULL }, // M8751773 has a factor: 7349934203340980548153
    { 8917127, 72,      412856951602515ULL }, // M8917127 has a factor: 7362995740544959548811
    { 8729923, 72,      428650232592500ULL }, // M8729923 has a factor: 7484167048929230755001
    { 8793691, 72,      429377514537960ULL }, // M8793691 has a factor: 7551626370389656020721
    { 8987213, 72,      424350062146461ULL }, // M8987213 has a factor: 7627448790146964406387
    { 8927959, 72,      456409313576580ULL }, // M8927959 has a factor: 8149607277659699200441
    { 8844229, 72,      469978896261549ULL }, // M8844229 has a factor: 8313201967408766501443
    { 8973343, 72,      468481777911980ULL }, // M8973343 has a factor: 8407695364908040698281
    { 9193027, 72,      461641633960364ULL }, // M9193027 has a factor: 8487768010643486363657
    { 9128029, 72,      468235712293136ULL }, // M9128029 has a factor: 8548138321294803817889
    { 9087629, 72,      479257694729364ULL }, // M9087629 has a factor: 8710632250191430875913
    { 8349587, 72,      529835245461628ULL }, // M8349587 has a factor: 8847810955296436295273
    { 9045587, 72,      503009663675608ULL }, // M9045587 has a factor: 9100035349236903883793
    { 8052089, 72,      567722814894792ULL }, // M8052089 has a factor: 9142709265726781640977
    { 9199163, 72,      498649891500220ULL }, // M9199163 has a factor: 9174323263685676631721
    { 8103419, 72,      572158493806812ULL }, // M8103419 has a factor: 9272880019451005380457
    { 8730529, 72,      532524937742240ULL }, // M8730529 has a factor: 9298448824363641689921
    { 9129959, 72,      515152473737215ULL }, // M9129959 has a factor: 9406641927938699448371
    { 8069093, 72,      583228204541805ULL }, // M8069093 has a factor: 9412245245341693865731
    { 9078227, 73,      533621344870183ULL }, // M9078227 has a factor: 9688671401553613611083
    { 8005183, 73,      608902231535052ULL }, // M8005183 has a factor: 9748747585092924349033
    { 8810401, 73,      559077390446544ULL }, // M8810401 has a factor: 9851391999735243408289
    { 8741933, 73,      565276825772748ULL }, // M8741933 has a factor: 9883224274716072483769
    { 9119147, 73,      545895317170692ULL }, // M9119147 has a factor: 9956199287782328879449
    { 8019251, 73,      627022517877259ULL }, // M8019251 has a factor: 10056501907019454226019
    { 9056093, 73,      555775368007441ULL }, // M9056093 has a factor: 10066306839569220776027
    { 9049811, 73,      560725410021600ULL }, // M9049811 has a factor: 10148917967185971835201
    { 8794477, 73,      589136350316625ULL }, // M8794477 has a factor: 10362292165447002560251
    { 8763817, 73,      599870240953037ULL }, // M8763817 has a factor: 10514306030916643724459
    { 8882683, 73,      614061632634455ULL }, // M8882683 has a factor: 10909029650308637285531
    { 9052649, 73,      610906214876665ULL }, // M9052649 has a factor: 11060639070394053071171
    { 8818651, 73,      628936007891064ULL }, // M8818651 has a factor: 11092734309849078869329
    { 8177651, 73,      681313240546648ULL }, // M8177651 has a factor: 11143083805739073127697
    { 9166441, 73,      615052146972956ULL }, // M9166441 has a factor: 11275678434301859539193
    { 9014309, 73,      648821342679529ULL }, // M9014309 has a factor: 11697352137416324760923
    { 8069683, 73,      728990827645400ULL }, // M8069683 has a factor: 11765449778012028816401
    { 8943653, 73,      664979627349757ULL }, // M8943653 has a factor: 11894694078171072484643
    { 9113999, 73,      655516042435275ULL }, // M9113999 has a factor: 11948745110478107829451
    { 8913563, 73,      702470584963336ULL }, // M8913563 has a factor: 12523031629435096252337
    { 8879659, 73,      716951279805300ULL }, // M8879659 has a factor: 12732565768569300785401
    { 8068451, 73,      793693431867600ULL }, // M8068451 has a factor: 12807753128091138175201
    { 8279837, 73,      787611660561664ULL }, // M8279837 has a factor: 13042592337499812737537
    { 9077221, 73,      721782521232081ULL }, // M9077221 has a factor: 13103558918321583053803
    { 8052893, 73,      823783368503712ULL }, // M8052893 has a factor: 13267678643479925677633
    { 8932631, 73,      743493618663100ULL }, // M8932631 has a factor: 13282708292744371232201
    { 8818471, 73,      763644149888775ULL }, // M8818471 has a factor: 13468347580227631126051
    { 8830663, 73,      781775728963856ULL }, // M8830663 has a factor: 13807196008118303033057
    { 8742977, 73,      791804230120693ULL }, // M8742977 has a factor: 13845452344895852246123
    { 8812913, 73,      787575351763021ULL }, // M8812913 has a factor: 13881666112063801380347
    { 8356559, 73,      862047175966200ULL }, // M8356559 has a factor: 14407496173489864611601
    { 8283193, 73,      879883069141512ULL }, // M8283193 has a factor: 14576482558262976415633
    { 8221859, 73,      887310955152696ULL }, // M8221859 has a factor: 14590691124841579963729
    { 8904143, 73,      831802331749095ULL }, // M8904143 has a factor: 14812973819254764001171
    { 8805661, 73,      845272696613840ULL }, // M8805661 has a factor: 14886369637874645896481
    { 8079707, 73,      935791817339700ULL }, // M8079707 has a factor: 15121847394204590935801
    { 9085847, 73,      845231109811143ULL }, // M9085847 has a factor: 15359281086768488386243
    { 8301947, 73,      944772787833639ULL }, // M8301947 has a factor: 15686907223274231590267
    { 8746009, 73,      923770322111444ULL }, // M8746009 has a factor: 16158607102239176453993
    { 9052937, 73,      923626130305092ULL }, // M9052937 has a factor: 16723058338411577310409
    { 8876081, 73,      950429575548856ULL }, // M8876081 has a factor: 16872179794734530626673
    { 8706829, 73,      986455058461584ULL }, // M8706829 has a factor: 17177791020420029914273
    { 9177527, 73,      952668720937060ULL }, // M9177527 has a factor: 17486285816910666901241
    { 8965153, 73,      989049093631296ULL }, // M8965153 has a factor: 17733952897831788456577
    { 8111659, 73,     1105715227842372ULL }, // M8111659 has a factor: 17938369758729254830297
    { 8985989, 73,     1004492226558432ULL }, // M8985989 has a factor: 18052712196879155618497
    { 8753579, 73,     1043185095431712ULL }, // M8753579 has a factor: 18263206288968060194497
    { 8809687, 73,     1050666434936355ULL }, // M8809687 has a factor: 18512084866390304941771
    { 8012549, 73,     1157531714810476ULL }, // M8012549 has a factor: 18549559167945929326649
    { 9129877, 73,     1018096374428688ULL }, // M9129877 has a factor: 18590189345359733422753
    { 9194407, 73,     1023541592714100ULL }, // M9194407 has a factor: 18821715969683340077401
    { 8265637, 74,     1143498884548913ULL }, // M8265637 has a factor: 18903493379172447205163
    { 9154681, 74,     1056863089803504ULL }, // M9154681 has a factor: 19350488895650863604449
    { 8988611, 74,     1078040488364580ULL }, // M8988611 has a factor: 19380173184318471596761
    { 8275343, 74,     1190415456067707ULL }, // M8275343 has a factor: 19702192422923413297003
    { 8868463, 74,     1127699949923936ULL }, // M8868463 has a factor: 20001930562004558460737
    { 8017609, 74,     1262793544868537ULL }, // M8017609 has a factor: 20249169780959772136067
    { 8859223, 74,     1170219764979495ULL }, // M8859223 has a factor: 20734475713921873264771
    { 8102357, 74,     1279610282153032ULL }, // M8102357 has a factor: 20735718653749187792849
    { 9155011, 74,     1133137464297168ULL }, // M9155011 has a factor: 20747771900305360617697
    { 8165093, 74,     1288521120425352ULL }, // M8165093 has a factor: 21041789561474397275473
    { 8853457, 74,     1223026089814589ULL }, // M8853457 has a factor: 21656017792103203368347
    { 8961487, 74,     1208318497097567ULL }, // M8961487 has a factor: 21656661007198768804259
    { 9072337, 74,     1203379440468360ULL }, // M9072337 has a factor: 21834927645600799514641
    { 9126349, 74,     1204326799489661ULL }, // M9126349 has a factor: 21982213364391336355379
    { 9119801, 74,     1206220677012000ULL }, // M9119801 has a factor: 22000985072869429224001
    { 8722423, 74,     1271796602981723ULL }, // M8722423 has a factor: 22186295882339298549659
    { 8175551, 74,     1366273574841868ULL }, // M8175551 has a factor: 22340078582144017538537
    { 9020243, 74,     1280523335636931ULL }, // M9020243 has a factor: 23101263309231354788467
    { 8786719, 74,     1320516432098532ULL }, // M8786719 has a factor: 23206013647464761993017
    { 8207161, 74,     1454845449850248ULL }, // M8207161 has a factor: 23880301674076822451857
    { 8926111, 74,     1377583287217116ULL }, // M8926111 has a factor: 24592922666889717031753
    { 8760503, 74,     1403858062643512ULL }, // M8760503 has a factor: 24597005538725349613073
    { 8202263, 74,     1565718475904100ULL }, // M8202263 has a factor: 25684869446649181956601
    { 8195489, 74,     1572426606393157ULL }, // M8195489 has a factor: 25773609912004895737547
    { 9084077, 74,     1456041256092700ULL }, // M9084077 has a factor: 26453581771045611875801
    { 8739209, 74,     1533983114539785ULL }, // M8739209 has a factor: 26811598080868239860131
    { 8863969, 74,     1519672798464816ULL }, // M8863969 has a factor: 26940665151470753229409
    { 8935811, 74,     1523514598167540ULL }, // M8935811 has a factor: 27227677009932167549881
    { 8773133, 74,     1593646367664817ULL }, // M8773133 has a factor: 27962543076980677923323
    { 8796647, 74,     1610270418253380ULL }, // M8796647 has a factor: 28329960887834680833721
    { 9149447, 74,     1582856162993295ULL }, // M9149447 has a factor: 28964517143861027915731
    { 8765597, 74,     1666400498276712ULL }, // M8765597 has a factor: 29213990416985703754129
    { 8987351, 74,     1633246573575996ULL }, // M8987351 has a factor: 29357120452549602453193
    { 8868943, 74,     1662880887436452ULL }, // M8868943 has a factor: 29495991612926617820473
    { 8847457, 74,     1693457538768200ULL }, // M8847457 has a factor: 29965585511154964934801
    { 8237513, 74,     1825572845504817ULL }, // M8237513 has a factor: 30076360094585843200243
    { 8862041, 74,     1751871807678208ULL }, // M8862041 has a factor: 31050319572776788205057
    { 8797939, 74,     1787310632633855ULL }, // M8797939 has a factor: 31449299839928131249691
    { 8037377, 74,     1972180258690285ULL }, // M8037377 has a factor: 31702312502102693564891
    { 8279983, 74,     1914761070557280ULL }, // M8279983 has a factor: 31708378226552157852481
    { 9062203, 74,     1761442081430075ULL }, // M9062203 has a factor: 31925091429323739910451
    { 8291839, 74,     2007968985640827ULL }, // M8291839 has a factor: 33299511091854098621707
    { 8334617, 74,     2031542075750565ULL }, // M8334617 has a factor: 33864250241531893617211
    { 9189623, 74,     1852203981465060ULL }, // M9189623 has a factor: 34042112617525778144761
    { 8271161, 74,     2061327933492256ULL }, // M8271161 has a factor: 34099150423423483258433
    { 8943917, 74,     1928066086296184ULL }, // M8943917 has a factor: 34488926092695814225457
    { 8748419, 74,     2039257525156020ULL }, // M8748419 has a factor: 35680558557935806664761
    { 8790953, 74,     2045052681842533ULL }, // M8790953 has a factor: 35955924017203322007899
    { 9137503, 74,     1975215346860591ULL }, // M9137503 has a factor: 36097072315169381688547
    { 9007001, 74,     2087148323817408ULL }, // M9007001 has a factor: 37597894079543435346817
    { 9109813, 75,     2078797831584021ULL }, // M9109813 has a factor: 37874919021071850196147
    { 9187517, 75,     2095086260905393ULL }, // M9187517 has a factor: 38497281277069467158363
    { 8847607, 75,     2179721601895248ULL }, // M8847607 has a factor: 38570640205959218943073
    { 8766143, 75,     2235835852049316ULL }, // M8766143 has a factor: 39199313607182294216377
    { 8103401, 75,     2422736483147704ULL }, // M8103401 has a factor: 39264810480551175482609
    { 8131499, 75,     2477520579115819ULL }, // M8131499 has a factor: 40291912223119406165363
    { 9046951, 75,     2278391948263376ULL }, // M9046951 has a factor: 41225000629466595533153
    { 8836507, 75,     2347483177030839ULL }, // M8836507 has a factor: 41487103052430496078747
    { 8250191, 75,     2557819043647875ULL }, // M8250191 has a factor: 42204991307064610988251
    { 8226653, 75,     2568264149816985ULL }, // M8226653 has a factor: 42256435945768698202411
    { 8719379, 75,     2429083367310156ULL }, // M8719379 has a factor: 42360197004346921426249
    { 8166469, 75,     2612796023952960ULL }, // M8166469 has a factor: 42674635465870210596481
    { 8102291, 75,     2673454346581719ULL }, // M8102291 has a factor: 43322210182439885236459
    { 8820601, 75,     2496403473328088ULL }, // M8820601 has a factor: 44039557946482412681777
    { 9161149, 75,     2422602751204520ULL }, // M9161149 has a factor: 44387649543189074386961
    { 9192779, 75,     2461318293152607ULL }, // M9192779 has a factor: 45252710235218258849707
    { 9020477, 75,     2508386040157840ULL }, // M9020477 has a factor: 45253677164729744179361
    { 9144257, 75,     2474606005164157ULL }, // M9144257 has a factor: 45256866569928757592699
    { 8025449, 75,     2884353391930669ULL }, // M8025449 has a factor: 46296462089833191190763
    { 9153491, 75,     2533379869458240ULL }, // M9153491 has a factor: 46378539669334349431681
    { 8997601, 75,     2666401100070720ULL }, // M8997601 has a factor: 47982426408794820685441
    { 8130853, 75,     3020808799518276ULL }, // M8130853 has a factor: 49123504579979145938857
    { 8832337, 75,     2797397902181285ULL }, // M8832337 has a factor: 49415121990316288426091
    { 8702387, 75,     2944944894802143ULL }, // M8702387 has a factor: 51256100336485073630683
    { 9182687, 75,     2804735515320307ULL }, // M9182687 has a factor: 51510016709940167849819
    { 8727529, 75,     3029820231947861ULL }, // M8727529 has a factor: 52885687878223366730939
    { 9181621, 75,     2884600215613629ULL }, // M9181621 has a factor: 52970611832565247825219
    { 8743309, 75,     3035652574634112ULL }, // M8743309 has a factor: 53083296953343206313217
    { 8935603, 75,     3108144283251228ULL }, // M8935603 has a factor: 55546286763705045340969
    { 8837347, 75,     3167825262021803ULL }, // M8837347 has a factor: 55990342151705189353283
    { 8898047, 75,     3204090298845268ULL }, // M8898047 has a factor: 57020292142738480783193
    { 9025333, 75,     3366970375038741ULL }, // M9025333 has a factor: 60776057671719050851507
    { 8964419, 75,     3403696693952800ULL }, // M8964419 has a factor: 61024326627015330846401
    { 8845861, 75,     3547709294135844ULL }, // M8845861 has a factor: 62765086568667582283369
    { 8944123, 75,     3524984527403940ULL }, // M8944123 has a factor: 63055790372395420089241
    { 8738087, 75,     3674757674798172ULL }, // M8738087 has a factor: 64220704532608268753929
    { 8735359, 75,     3767690854991840ULL }, // M8735359 has a factor: 65824264438741328941121
    { 8265343, 75,     4200259258589828ULL }, // M8265343 has a factor: 69433166922341249462009
    { 8149129, 75,     4266697351815941ULL }, // M8149129 has a factor: 69539734247812974930779
    { 9029107, 75,     3924473841407460ULL }, // M9029107 has a factor: 70868988465537973876441
    { 9096181, 75,     3957632160864000ULL }, // M9096181 has a factor: 71998676933280120768001
    { 8746939, 75,     4222709512130652ULL }, // M8746939 has a factor: 73871565034653146148457
    { 8067263, 76,     4683082540274263ULL }, // M8067263 has a factor: 75559317006201143504339
    { 9130657, 76,     4297560632284332ULL }, // M9130657 has a factor: 78479104140182723932249
    { 8979811, 76,     4566627516919671ULL }, // M8979811 has a factor: 82014904018675895524363
    { 8135801, 76,     5100428712942436ULL }, // M8135801 has a factor: 82992146046371567502473
    { 8727109, 76,     4870546135396332ULL }, // M8727109 has a factor: 85011574026265095128377
    { 8016599, 76,     5543461064778831ULL }, // M8016599 has a factor: 88879408856889823631539
    { 8092657, 76,     5512658597317872ULL }, // M8092657 has a factor: 89224110372389316131809
    { 8854667, 76,     5242283825509072ULL }, // M8854667 has a factor: 92837355188737876078049
    { 8974169, 76,     5238012045936580ULL }, // M8974169 has a factor: 94013610648541264404041
    { 9020881, 76,     5213498087554416ULL }, // M9020881 has a factor: 94060691683111935520993
    { 8916839, 76,     5479587838103895ULL }, // M8916839 has a factor: 97721205077460993975811
    { 9051407, 76,     5646646562455479ULL }, // M9051407 has a factor: 102220192443870919617907
    { 9068639, 76,     5958488431503840ULL }, // M9068639 has a factor: 108070761141969104147521
    { 8873903, 76,     6098489146844811ULL }, // M8873903 has a factor: 108234802271307217734667
    { 8213311, 76,     6661642162163120ULL }, // M8213311 has a factor: 109428277697116274580641
    { 8200303, 76,     6792809148260235ULL }, // M8200303 has a factor: 111406186473811699702411
    { 8820923, 76,     6419113833232431ULL }, // M8820923 has a factor: 113245017702356229907627
    { 8264593, 76,     6882008070697176ULL }, // M8264593 has a factor: 113753991454054771778737
    { 8915677, 76,     6396626193991868ULL }, // M8915677 has a factor: 114060506070741671429273
    { 8966137, 76,     6531369612336653ULL }, // M8966137 has a factor: 117122309483694641838923
    { 9070337, 76,     6603185248105324ULL }, // M9070337 has a factor: 119786230947487800348377
    { 8983631, 76,     6888095522634480ULL }, // M8983631 has a factor: 123760216936200632393761
    { 9064877, 76,     6967500325702609ULL }, // M9064877 has a factor: 126319066899908178328187
    { 8958839, 76,     7058705394437431ULL }, // M8958839 has a factor: 126475610354392879805219
    { 8125933, 76,     7824122994293420ULL }, // M8125933 has a factor: 127156598470775426521721
    { 9030079, 76,     7114312425387479ULL }, // M9030079 has a factor: 128485606463861081961683
    { 8225999, 76,     8046116226176736ULL }, // M8225999 has a factor: 132374688060827208318529
    { 8037059, 76,     8404478928926311ULL }, // M8037059 has a factor: 135094586032075136318699
    { 8783459, 77,     8612705793149991ULL }, // M8783459 has a factor: 151298696426390853597739
    { 8158727, 77,     9327707778726144ULL }, // M8158727 has a factor: 152204442604806033317377
    { 9140321, 77,     8541291077087748ULL }, // M9140321 has a factor: 156140284398035523774217
    { 9009929, 77,     8721989391380125ULL }, // M9009929 has a factor: 157169010310176276522251
    { 8906189, 77,     8856720973033605ULL }, // M8906189 has a factor: 157759261812202378962691
    { 9151957, 77,     8797722211890468ULL }, // M9151957 has a factor: 161032750762332903691753
    { 9063553, 77,     8915418691057200ULL }, // M9063553 has a factor: 161610739647175116463201
    { 8733133, 77,     9269990416095261ULL }, // M8733133 has a factor: 161912118424970509965427
    { 8949911, 77,     9056102034074575ULL }, // M8949911 has a factor: 162102614423772827225651
    { 8178427, 77,     9951505891261320ULL }, // M8178427 has a factor: 162775328943501287087281
    { 8204741, 77,     9966705243716104ULL }, // M8204741 has a factor: 163548470296065021698129
    { 8172539, 77,    10675127211417735ULL }, // M8172539 has a factor: 174485786930545369158331
    { 8832389, 77,     9916694137715724ULL }, // M8832389 has a factor: 175176200436649691569273
    { 9007507, 77,     9794142960389799ULL }, // M9007507 has a factor: 176441622549423674442187
    { 8986073, 77,     9962146729904368ULL }, // M8986073 has a factor: 179041155503263867733729
    { 8163251, 77,    11172596552782680ULL }, // M8163251 has a factor: 182409419964199530585361
    { 8825207, 77,    11023043469404112ULL }, // M8825207 has a factor: 194561280774978910102369
    { 8810189, 77,    11131865042959869ULL }, // M8810189 has a factor: 196147669901939130610483
    { 8956139, 77,    11225608689981399ULL }, // M8956139 has a factor: 201076223574162633716923
    { 8229031, 77,    12380218739256191ULL }, // M8229031 has a factor: 203754407584240225361843
    { 8051167, 77,    12890929828204532ULL }, // M8051167 has a factor: 207574057664311994577689
    { 9148099, 77,    11376942357309512ULL }, // M9148099 has a factor: 208154790003921578835377
    { 8817323, 77,    12369226024827196ULL }, // M8817323 has a factor: 218126922241814812632617
    { 9180497, 77,    12167728576561588ULL }, // M9180497 has a factor: 223411591387875857898473
    { 8852159, 77,    12798637778204220ULL }, // M8852159 has a factor: 226591153192140979821961
    { 8336479, 77,    13863021884849160ULL }, // M8336479 has a factor: 231137581639170881015281
    { 9113843, 77,    12686242094552911ULL }, // M9113843 has a factor: 231240837419492772093947
    { 9036947, 77,    12945172736751208ULL }, // M9036947 has a factor: 233969679855731237763953
    { 8976713, 77,    13403396664403200ULL }, // M8976713 has a factor: 240636890163009685363201
    { 8932117, 77,    13602403303956173ULL }, // M8932117 has a factor: 242996515584246200216483
    { 8257859, 77,    14774970740915791ULL }, // M8257859 has a factor: 244019250215216265902939
    { 9053273, 77,    13882118685333417ULL }, // M9053273 has a factor: 251357220553449040247683
    { 9014279, 77,    14350814305006407ULL }, // M9014279 has a factor: 258724488045037698971107
    { 9144173, 77,    14555503918423633ULL }, // M9144173 has a factor: 266196091864487174881019
    { 9146041, 77,    15122017750155708ULL }, // M9146041 has a factor: 276613188691303723504057
    { 8725733, 77,    16542819115453768ULL }, // M8725733 has a factor: 288696445337491506823889
    { 8769379, 77,    16616680031558724ULL }, // M8769379 has a factor: 291435929836940823024793
    { 8252371, 77,    17703087190455099ULL }, // M8252371 has a factor: 292184886681966271579459
    { 9158521, 77,    16358406569317665ULL }, // M9158521 has a factor: 299637620183267581146931
    { 8962633, 77,    16744689008690216ULL }, // M8962633 has a factor: 300153004568048433397457
    { 9122543, 78,    16671182194442020ULL }, // M9122543 has a factor: 304167152859263376913721
    { 8887621, 78,    17267967213161529ULL }, // M8887621 has a factor: 306942296062011763065019
    { 8219881, 78,    18779851049811621ULL }, // M8219881 has a factor: 308736281654353194074203
    { 8883997, 78,    17387313507040052ULL }, // M8883997 has a factor: 308937682069206601695689
    { 8729983, 78,    17851312247594600ULL }, // M8729983 has a factor: 311683304898385297783601
    { 9182981, 78,    16999653973455648ULL }, // M9182981 has a factor: 312214998889635439853377
    { 8840173, 78,    17836531101290376ULL }, // M8840173 has a factor: 315356041310574894150097
    { 8344793, 78,    19735326267471580ULL }, // M8344793 has a factor: 329374424979025936965881
    { 8094353, 78,    20382043826902788ULL }, // M8094353 has a factor: 329958915192844125512329
    { 9152909, 78,    18269994673839501ULL }, // M9152909 has a factor: 334447197360275266516819
    { 8834117, 78,    18967249252101448ULL }, // M8834117 has a factor: 335117798122453375002833
    { 8784107, 78,    20285802842347359ULL }, // M8784107 has a factor: 356385325496166665246827
    { 8800483, 78,    20535753716100675ULL }, // M8800483 has a factor: 361449102941461633252051
    { 9135127, 78,    20006366329269195ULL }, // M9135127 has a factor: 365521394452795827025531
    { 8162183, 78,    22486308700349520ULL }, // M8162183 has a factor: 367074733213489892404321
    { 8243329, 78,    22346384140115004ULL }, // M8243329 has a factor: 368417192854700151616633
    { 8297761, 78,    22850849111671548ULL }, // M8297761 has a factor: 379221769151425631608057
    { 8206633, 78,    23325262255590728ULL }, // M8206633 has a factor: 382843733920770605797649
    { 8849119, 78,    21998439425469699ULL }, // M8849119 has a factor: 389333616580545994690363
    { 9195889, 78,    21276316953525452ULL }, // M9195889 has a factor: 391309298066876430533657
    { 8900669, 78,    24684657587965416ULL }, // M8900669 has a factor: 439419933137637102526609
    { 9085397, 78,    25408775440819417ULL }, // M9085397 has a factor: 461697624327388817507099
    { 8935921, 78,    26919223911611948ULL }, // M8935921 has a factor: 481096116510950699968217
    { 8111339, 78,    30595944317270980ULL }, // M8111339 has a factor: 496348152765016947284441
    { 9158999, 78,    27362145771364876ULL }, // M9158999 has a factor: 501219731515570255838249
    { 8996089, 78,    28286489346148241ULL }, // M8996089 has a factor: 508935551311002766458899
    { 8057629, 78,    32033344371266520ULL }, // M8057629 has a factor: 516225609145807756562161
    { 8723497, 78,    29887216265612657ULL }, // M8723497 has a factor: 521442082862846433003059
    { 8317843, 78,    31739989019682608ULL }, // M8317843 has a factor: 528016490974887686349089
    { 8891261, 78,    29728094393217673ULL }, // M8891261 has a factor: 528640492565469920911307
    { 8789279, 78,    30168027036968955ULL }, // M8789279 has a factor: 530310413014926919666891
    { 8747579, 78,    31536697064541079ULL }, // M8747579 has a factor: 551739497942282374595483
    { 8944597, 78,    31539169071237720ULL }, // M8944597 has a factor: 564210314114171393197681
    { 8893051, 78,    32108607621954776ULL }, // M8893051 has a factor: 571086970242065085323153
    { 8327857, 79,    36347995687059549ULL }, // M8327857 has a factor: 605401820636897349112987
    { 8034787, 79,    37867332330947484ULL }, // M8034787 has a factor: 608511899074753084251817
    { 8076737, 79,    38593158552608748ULL }, // M8076737 has a factor: 623413583257443042990553
    { 9143623, 79,    35570425964449752ULL }, // M9143623 has a factor: 650485129936679869462993
    { 9060323, 79,    37343107323282043ULL }, // M9060323 has a factor: 676681228345201459359779
    { 8063701, 79,    43056713078824089ULL }, // M8063701 has a factor: 694392920620853770586779
    { 8953943, 79,    38841543779587032ULL }, // M8953943 has a factor: 695569938068853696134353
    { 8988263, 79,    41530032364894515ULL }, // M8988263 has a factor: 746565706588367736154891
    { 8858951, 79,    42453395412216583ULL }, // M8858951 has a factor: 752185099480903020368867
    { 9146983, 79,    42994182883325375ULL }, // M9146983 has a factor: 786534119865336377187251
    { 8123407, 79,    51580203102009824ULL }, // M8123407 has a factor: 838013965880576636700737
    { 9137827, 79,    46204582450350564ULL }, // M9137827 has a factor: 844418962077079086368857
    { 9163837, 79,    46210889685532040ULL }, // M9163837 has a factor: 846938121406393745674961
    { 8750453, 79,    48936005313918933ULL }, // M8750453 has a factor: 856424429014395738053299
    { 9144347, 79,    47138983513428928ULL }, // M9144347 has a factor: 862110444948146554940033
    { 8732027, 79,    50999980783416312ULL }, // M8732027 has a factor: 890666418400544777248849
    { 8710271, 79,    51683016229793728ULL }, // M8710271 has a factor: 900346154917803289960577
    { 8357389, 79,    57086993414233800ULL }, // M8357389 has a factor: 954196421606380007096401
    { 9174761, 79,    53934595260739780ULL }, // M9174761 has a factor: 989674042298040329385161
    { 8984149, 79,    55704443491021257ULL }, // M8984149 has a factor: 1000914040570830270110587
    { 9049829, 79,    58197732507797352ULL }, // M9049829 has a factor: 1053359054766614404505617
    { 8811199, 79,    59951415606904220ULL }, // M8811199 has a factor: 1056487706488277712719561
    { 8987047, 79,    62480065458283755ULL }, // M8987047 has a factor: 1123022569673345291042971
    { 8911031, 79,    67368845330664855ULL }, // M8911031 has a factor: 1200651738351519547031011
    { 8945477, 80,    69812721351116788ULL }, // M8945477 has a factor: 1249016186307648302735753
    { 8166773, 80,    83870041838721621ULL }, // M8166773 has a factor: 1369895186394684177798067
    { 8086681, 80,    85450362189327260ULL }, // M8086681 has a factor: 1382019640719102312448121
    { 9002347, 80,    77202102234712208ULL }, // M9002347 has a factor: 1390000226892709483104353
    { 9182609, 80,    78407485233788272ULL }, // M9182609 has a factor: 1439970559150302581123297
    { 8730863, 80,    89201462509036060ULL }, // M8730863 has a factor: 1557611497132060203839561
    { 8856761, 80,    90774977951894236ULL }, // M8856761 has a factor: 1607944569000393491059193
    { 8826803, 80,    91308226102228500ULL }, // M8826803 has a factor: 1611919448167657660971001
    { 8094181, 80,   101044426710754056ULL }, // M8094181 has a factor: 1635743757676155951496273
    { 8957413, 80,    98086408205241372ULL }, // M8957413 has a factor: 1757200935961871467381273
    { 9091769, 80,   100037365573409556ULL }, // M9091769 has a factor: 1819033238323984451089129
    { 8253577, 80,   111937935329078448ULL }, // M8253577 has a factor: 1847776736919138619216993
    { 9020917, 80,   105265576811983488ULL }, // M9020917 has a factor: 1899184062756055301236993
    { 8921359, 80,   113900682534127544ULL }, // M8921359 has a factor: 2032297758463963143624593
    { 9097691, 80,   116764366577808259ULL }, // M9097691 has a factor: 2124572253871253995259939
    { 8947721, 80,   124485837800010720ULL }, // M8947721 has a factor: 2227729090171499439138241
    { 8866591, 80,   125671346108213960ULL }, // M8866591 has a factor: 2228552852721949847620721
    { 8107313, 80,   145793299844965680ULL }, // M8107313 has a factor: 2363983830291976484035681
    { 8826157, 80,   135732247278097989ULL }, // M8826157 has a factor: 2395988248878631024596547
    { 9164231, 81,   136852769795273940ULL }, // M9164231 has a factor: 2508300790787426188880281
    { 9091807, 81,   144356167084641935ULL }, // M9091807 has a factor: 2624916820786634274253091
    { 8755027, 81,   158142334687681568ULL }, // M8755027 has a factor: 2769080820067377390484673
    { 8722517, 81,   166564557144279924ULL }, // M8722517 has a factor: 2905724362576906179697417
    { 8920981, 81,   171936083624387204ULL }, // M8920981 has a factor: 3067677070455138767054249
    { 8731141, 81,   179448036077683836ULL }, // M8731141 has a factor: 3133572210334689051073753
    { 8862079, 81,   178826616705829512ULL }, // M8862079 has a factor: 3169551209099561791750897
    { 9131809, 81,   176695037989470252ULL }, // M9131809 has a factor: 3227090676335172704891737
    { 8908589, 81,   181141461743137080ULL }, // M8908589 has a factor: 3227429667057663632760241
    { 9051881, 81,   178743142150826545ULL }, // M9051881 has a factor: 3235923304630731873962291
    { 8198467, 81,   208150004203685264ULL }, // M8198467 has a factor: 3413021881027549830580577
    { 9135859, 81,   203215425701609891ULL }, // M9135859 has a factor: 3713094951669768074362739
    { 8962321, 81,   207814768088069760ULL }, // M8962321 has a factor: 3725005320291674919025921
    { 9058999, 81,   228390700246298951ULL }, // M9058999 has a factor: 4137982250281043901620099
    { 8982359, 81,   247076817271408152ULL }, // M8982359 has a factor: 4438665346618376913581137
    { 9064571, 81,   245276023394490528ULL }, // M9064571 has a factor: 4446643857314040799766977
    { 8151097, 81,   276395333650425297ULL }, // M8151097 has a factor: 4505850349863961374201619
    { 8187041, 82,   296753772563397904ULL }, // M8187041 has a factor: 4859070605762427478724129
    { 8912269, 82,   276637212558531264ULL }, // M8912269 has a factor: 4930930507463617739356033
    { 8747617, 82,   294822575437380168ULL }, // M8747617 has a factor: 5157989945759618386119313
    { 8914027, 82,   290760422627333844ULL }, // M8914027 has a factor: 5183692515662929646859577
    { 8739023, 82,   328201832455841851ULL }, // M8739023 has a factor: 5736326724947496840503147
    { 9144001, 82,   351109701671093300ULL }, // M9144001 has a factor: 6421094926380357612586601
    { 9164843, 82,   353986499408151220ULL }, // M9164843 has a factor: 6488461382390597703116921
    { 8199767, 82,   396215107623048979ULL }, // M8199767 has a factor: 6497743128777850914775787
    { 8164159, 82,   434604742477288956ULL }, // M8164159 has a factor: 7096364439477281851456009
    { 8730929, 82,   408122675117091165ULL }, // M8730929 has a factor: 7126580199474779296284571
    { 8115763, 82,   440531649042839180ULL }, // M8115763 has a factor: 7150500915261719263988681
    { 9061249, 82,   419529381045854856ULL }, // M9061249 has a factor: 7602920368944742536150289
    { 9161899, 82,   428932900920638499ULL }, // M9161899 has a factor: 7859679832023793886699203
    { 9118049, 82,   434005411970656516ULL }, // M9118049 has a factor: 7914565225227265350114569
    { 8058847, 82,   507844795142700392ULL }, // M8058847 has a factor: 8185287007602731251936049
    { 9069883, 82,   482544143645777123ULL }, // M9069883 has a factor: 8753237850404783899373219
    { 8806801, 82,   502693713649400268ULL }, // M8806801 has a factor: 8854247000122503859245337
    { 8710727, 82,   524782197003541039ULL }, // M8710727 has a factor: 9142468905116128048050707
    { 8205077, 82,   570140667435921417ULL }, // M8205077 has a factor: 9356096154286255584868219
    { 8759423, 82,   549660457454053560ULL }, // M8759423 has a factor: 9629416906427116393391761
    { 8283043, 83,   587413789786637792ULL }, // M8283043 has a factor: 9731147359191363313122113
    { 8793163, 83,   554716169400029532ULL }, // M8793163 has a factor: 9755419392540143759379433
    { 8138239, 83,   622902331426030656ULL }, // M8138239 has a factor: 10138656093604496599709569
    { 8000953, 83,   638665205245516368ULL }, // M8000953 has a factor: 10219860579809459842197409
    { 8941921, 83,   590974661605728764ULL }, // M8941921 has a factor: 10568897474160319510231289
    { 8342561, 83,   699751350285551233ULL }, // M8342561 has a factor: 11675436649179157159855427
    { 8980339, 83,   654138221468718915ULL }, // M8980339 has a factor: 11748765963292347504824371
    { 9055003, 83,   652458766115806152ULL }, // M9055003 has a factor: 11816032169109846107556913
    { 8865019, 83,   709688811525756644ULL }, // M8865019 has a factor: 12582809596526503276872473
    { 8062799, 83,   784999831246543192ULL }, // M8062799 has a factor: 12658591708749594403828817
    { 8093483, 83,   822627521319073143ULL }, // M8093483 has a factor: 13315843718256112117254139
    { 8927687, 83,   781927063969447368ULL }, // M8927687 has a factor: 13961600167896407328955633
    { 8131603, 83,   887065394787394056ULL }, // M8131603 has a factor: 14426527250898715735903537
    { 8785297, 83,   905165937417530565ULL }, // M8785297 has a factor: 15904303188992838040205611
    { 9142963, 83,   927203950070542760ULL }, // M9142963 has a factor: 16954782817897639689195761
    { 8890243, 83,   955507521365016512ULL }, // M8890243 has a factor: 16989388106525376981384833
    { 8303509, 84,  1164839086886625504ULL }, // M8303509 has a factor: 19344503683029753704187073
    { 8967311, 84,  1173742240090748548ULL }, // M8967311 has a factor: 21050623401460820905428857
    { 8332283, 84,  1338450743589351271ULL }, // M8332283 has a factor: 22304700754293821152763387
    { 9082681, 84,  1277370313491531369ULL }, // M9082681 has a factor: 23203894152627151252240579
    { 8268229, 84,  1553704599665112036ULL }, // M8268229 has a factor: 25692770856768939248608489
    { 8995297, 84,  1485995753065204173ULL }, // M8995297 has a factor: 26733946279120343803548763
    { 9115297, 84,  1507274010255496457ULL }, // M9115297 has a factor: 27478500527719792176005459
    { 9132313, 84,  1512300579193735800ULL }, // M9132313 has a factor: 27621604478556965929810801
    { 8967811, 84,  1632477815753238335ULL }, // M8967811 has a factor: 29279505026735728052469371
    { 9161297, 84,  1663164209951917833ULL }, // M9161297 has a factor: 30473482574279749975418803
    { 8227451, 84,  2175280799654856051ULL }, // M8227451 has a factor: 35794032380802290143312003
    { 8845171, 85,  2187054681464707983ULL }, // M8845171 has a factor: 38689745287811745149400187
    { 9196001, 85,  2108682049295085856ULL }, // M9196001 has a factor: 38782884467999317653723713
    { 8948869, 85,  2249785293244171056ULL }, // M8948869 has a factor: 40266067734737343587471329
    { 8951989, 85,  2370516294549983685ULL }, // M8951989 has a factor: 42441671586264427796598931
    { 8929307, 85,  2435352183233665060ULL }, // M8929307 has a factor: 43492014594427296111826841
    { 9082429, 85,  2470119471800689617ULL }, // M9082429 has a factor: 44869369448294531194879387
    { 8888641, 85,  2530559321518388273ULL }, // M8888641 has a factor: 44986466676361056514613987
    { 9035107, 85,  2847001873978282608ULL }, // M9035107 has a factor: 51445933121188598079038113
    { 9080531, 85,  2899628001285728424ULL }, // M9080531 has a factor: 52660323908286193623426289
    { 9086179, 85,  3155802615190708659ULL }, // M9086179 has a factor: 57348374900581796025047923
    { 8288167, 85,  3520683254134128195ULL }, // M8288167 has a factor: 58360021528734189759137131
    { 8876503, 85,  3366240069638334887ULL }, // M8876503 has a factor: 59760880153729777078920323
    { 8965961, 85,  3371487253375059480ULL }, // M8965961 has a factor: 60457246451515803340720561
    { 8700817, 85,  3604560718172616144ULL }, // M8700817 has a factor: 62725246348417014960379297
    { 8726761, 85,  3793845983159531340ULL }, // M8726761 has a factor: 66215974331686509752379481
    { 8845637, 85,  3864216208938728752ULL }, // M8845637 has a factor: 68362907747576299563310049
    { 8115403, 85,  4456920670191405432ULL }, // M8115403 has a factor: 72339414755266684434138193
    { 8713051, 85,  4237854693341093955ULL }, // M8713051 has a factor: 73849288147340624051413411
    { 9157549, 85,  4123443570779567609ULL }, // M9157549 has a factor: 75521273096297717156460683
    { 8766533, 86,  4491420312489116880ULL }, // M8766533 has a factor: 78748368772612310538754081
    { 9038891, 86,  4386272546478468304ULL }, // M9038891 has a factor: 79294078887822617693621729
    { 9006671, 86,  4483519221888473760ULL }, // M9006671 has a factor: 80763165107450963696905921
    { 9127709, 86,  4472218932958325136ULL }, // M9127709 has a factor: 81642226008668201937586849
    { 8886799, 86,  4928602536414242120ULL }, // M8886799 has a factor: 87599000184007100915547761
    { 8933963, 86,  5237097279873322668ULL }, // M8933963 has a factor: 93576066651577818805946569
    { 8802323, 86,  6302236343610144463ULL }, // M8802323 has a factor: 110948639837590955279975099
    { 8987959, 86,  6640742651518520175ULL }, // M8987959 has a factor: 119373445362799494147145651
    { 9003227, 86,  6728051548627937700ULL }, // M9003227 has a factor: 121148350719997723309915801
    { 8968759, 86,  7121548510661691884ULL }, // M8968759 has a factor: 127742904597867290079703913
    { 8831107, 86,  7496601915247739148ULL }, // M8831107 has a factor: 132406587299915431848153673
    { 8193197, 86,  8322437100308687200ULL }, // M8193197 has a factor: 136374733365875670081956801
    { 9007541, 86,  7966885944611932488ULL }, // M9007541 has a factor: 143524103576831421949784017
    { 8982889, 86,  8017663652292174305ULL }, // M8982889 has a factor: 144043565255750394700934291
    { 8146657, 87,  9852379920940363469ULL }, // M8146657 has a factor: 160527919699176517274546267
    { 8876419, 87, 10046383642944043800ULL }, // M8876419 has a factor: 178351821299035452646304401
    { 8893979, 87, 14931984354228552747ULL }, // M8893979 has a factor: 265609510549674618664420627
    { 9111449, 87, 14949550746477393201ULL }, // M9111449 has a factor: 272424138398881395607716499
    { 8111759, 87, 16907949315317640544ULL }, // M8111759 has a factor: 274306420060143417083113793
    { 8955971, 87, 16041187235098685160ULL }, // M8955971 has a factor: 287328815366228012862180721
    { 8945683, 87, 16449421626814307271ULL }, // M8945683 has a factor: 294302622813650185421922187
    { 9151523, 87, 16089953733123135060ULL }  // M9151523 has a factor: 294495163315224464667392761
};
