/*
This file is part of mfaktc.
Copyright (C) 2009, 2010, 2015  Oliver Weihe (o.weihe@t-online.de)
                                Bertram Franz (bertramf@gmx.net)

mfaktc is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mfaktc is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY },   without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                
You should have received a copy of the GNU General Public License
along with mfaktc.  If not, see <http://www.gnu.org/licenses/>.
*/

typedef struct _test_set {
    unsigned int exp;
    unsigned int bit_min;
    unsigned long long int k;
} test_set;

// generated out of the previous header file by
// sed -e s'/^exp\[[ 0-9]*\]=/  { /' -e s'/; bit_min\[[ 0-9]*\]=/, /'  -e s'/; k\[[ 0-9]*\]=/, /' -e s'/;/ },  /' [...]
static test_set st_data[] = {
    /* some factors I found with P-1 factoring */
    {   50804297, 67,        1777608657747ULL }, // M50804297 has a factor: 180620316395899877719 (67.29 Bits)
    {   50725243, 67,        2270235299916ULL }, // M50725243 has a factor: 230316474510833959177 (67.64 Bits)
    {   49635893, 67,        2822192209735ULL }, // M49635893 has a factor: 280164061095680036711 (67.92 Bits)
    {   51332417, 68,        2901602967304ULL }, // M51332417 has a factor: 297892586972172587537 (68.01 Bits)
    {   51413951, 68,        3084924765984ULL }, // M51413951 has a factor: 317216341513975685569 (68.10 Bits)
    {   53134687, 68,        3171882111900ULL }, // M53134687 has a factor: 337073926433410950601 (68.19 Bits)
    {   51265327, 68,        3399493885248ULL }, // M51265327 has a factor: 348552331323478392193 (68.23 Bits)
    {   53146649, 68,        3397856891695ULL }, // M53146649 has a factor: 361169415150290360111 (68.29 Bits)
    {   53068331, 68,        3747918509325ULL }, // M53068331 has a factor: 397791560027771373151 (68.43 Bits)
    {   50787953, 68,        4022261889255ULL }, // M50787953 has a factor: 408564895570348290031 (68.46 Bits)
    {   51737573, 68,        3987309195583ULL }, // M51737573 has a factor: 412587401160093480119 (68.48 Bits)
    {   51161503, 68,        4060374149840ULL }, // M51161503 has a factor: 415469688496323219041 (68.49 Bits)
    {   51061601, 68,        4190037673596ULL }, // M51061601 has a factor: 427900063728254374393 (68.53 Bits)
    {   51082547, 68,        4560615285580ULL }, // M51082547 has a factor: 465935689349117544521 (68.65 Bits)
    {   51437311, 68,        4897791053193ULL }, // M51437311 has a factor: 503858403232211768047 (68.77 Bits)
    {   51486859, 68,        4955487665772ULL }, // M51486859 has a factor: 510284989447684180297 (68.78 Bits)
    {   51408359, 68,        5079314752137ULL }, // M51408359 has a factor: 522238472503709826367 (68.82 Bits)
    {   51532279, 68,        5256827119472ULL }, // M51532279 has a factor: 541792563550794873377 (68.87 Bits)
    {   50751637, 68,        5420726350868ULL }, // M50751637 has a factor: 550221472071174741833 (68.89 Bits)
    {   51629843, 68,        5410622486860ULL }, // M51629843 has a factor: 558699179057702725961 (68.92 Bits)
    {   51302663, 69,        5883290728777ULL }, // M51302663 has a factor: 603656963178941666303 (69.03 Bits)
    {   51960509, 69,        6240631719180ULL }, // M51960509 has a factor: 648532801220275725241 (69.13 Bits)
    {   51683747, 69,        6539840634253ULL }, // M51683747 has a factor: 676006937522103171983 (69.19 Bits)
    {   51163433, 69,        6686338931736ULL }, // M51163433 has a factor: 684192107898332819377 (69.21 Bits)
    {   50896831, 69,        6932063326709ULL }, // M50896831 has a factor: 705640111241611518359 (69.25 Bits)
    {   51375383, 69,        6940180143997ULL }, // M51375383 has a factor: 713108825973682051703 (69.27 Bits)
    {   51133343, 69,        7791765251988ULL }, // M51133343 has a factor: 796838010410767671769 (69.43 Bits)
    {   52548403, 69,        7700004611768ULL }, // M52548403 has a factor: 809245890882086813009 (69.45 Bits)
    {   51023447, 69,        9127164820560ULL }, // M51023447 has a factor: 931398820964215340641 (69.65 Bits)
    {   53057161, 69,        8788978937844ULL }, // M53057161 has a factor: 932636541061596201769 (69.65 Bits)
    {   50863909, 69,        9428548724480ULL }, // M50863909 has a factor: 959145688648033584641 (69.70 Bits)
    {   51683719, 69,        9349316766029ULL }, // M51683719 has a factor: 966414921154863163703 (69.71 Bits)
    {   51785093, 69,       10061750158576ULL }, // M51785093 has a factor: 1042097335409245815137 (69.81 Bits)
    {   51445357, 69,       10810403816960ULL }, // M51445357 has a factor: 1112290167355339709441 (69.91 Bits)
    {   53136437, 70,       11182837510428ULL }, // M53136437 has a factor: 1188432281708188530073 (70.00 Bits)
    {   50920721, 70,       12311227247460ULL }, // M50920721 has a factor: 1253793135671017237321 (70.08 Bits)
    {   52188473, 70,       12244536814095ULL }, // M52188473 has a factor: 1278047357839805853871 (70.11 Bits)
    {   48630643, 70,       14360013843000ULL }, // M48630643 has a factor: 1396673413347982098001 (70.24 Bits)
    {   51250613, 70,       13784248858471ULL }, // M51250613 has a factor: 1412902407482377985447 (70.25 Bits)
    {   51406301, 70,       13876172279503ULL }, // M51406301 has a factor: 1426645377855974696807 (70.27 Bits)
    {   50893061, 70,       14165527205908ULL }, // M50893061 has a factor: 1441854080374870808777 (70.28 Bits)
    {   50979079, 70,       14154674984616ULL }, // M50979079 has a factor: 1443184588520125697329 (70.28 Bits)
    {   51064417, 70,       14335850580495ULL }, // M51064417 has a factor: 1464103704184177492831 (70.31 Bits)
    {   51293899, 70,       15549106121072ULL }, // M51293899 has a factor: 1595148557829097879457 (70.43 Bits)
    {   51132959, 70,       15736957340044ULL }, // M51132959 has a factor: 1609354388906437820393 (70.44 Bits)
    {   51125413, 70,       17159859494700ULL }, // M51125413 has a factor: 1754609807377017622201 (70.57 Bits)
    {   52249541, 70,       16836000669924ULL }, // M52249541 has a factor: 1759346614558443009769 (70.57 Bits)
    {   50781589, 70,       17443383452799ULL }, // M50781589 has a factor: 1771605458538879435223 (70.58 Bits)
    {   51321659, 70,       17370566757769ULL }, // M51321659 has a factor: 1782972607557912437543 (70.59 Bits)
    {   51745849, 70,       19378619790720ULL }, // M51745849 has a factor: 2005526267038017442561 (70.76 Bits)
    {   49715873, 70,       20406300460375ULL }, // M49715873 has a factor: 2029034084175690064751 (70.78 Bits)
    {   53110691, 70,       19255777679248ULL }, // M53110691 has a factor: 2045375316574475280737 (70.79 Bits)
    {   49915309, 70,       20895019231944ULL }, // M49915309 has a factor: 2085962683046854861393 (70.82 Bits)
    {   51152869, 70,       20582854459640ULL }, // M51152869 has a factor: 2105744115640061414321 (70.83 Bits)
    {   50909147, 70,       21785705793504ULL }, // M50909147 has a factor: 2218183397480493562177 (70.90 Bits)
    {   51651337, 70,       21996976083347ULL }, // M51651337 has a factor: 2272346449323791969879 (70.94 Bits)
    {   51340871, 70,       22243376181213ULL }, // M51340871 has a factor: 2283988614248258513047 (70.95 Bits)
    {   47644171, 70,       24735972078953ULL }, // M47644171 has a factor: 2357049767161724465927 (70.99 Bits)
    {   48103381, 71,       24689718456956ULL }, // M48103381 has a factor: 2375317867435373136473 (71.00 Bits)
    {   51175363, 71,       23413141155273ULL }, // M51175363 has a factor: 2396351995182670278199 (71.02 Bits)
    {   51705649, 71,       24393803641236ULL }, // M51705649 has a factor: 2522594897697341084329 (71.09 Bits)
    {   51512189, 71,       29154877583320ULL }, // M51512189 has a factor: 3003663128687686174961 (71.34 Bits)
    {   51772243, 71,       33454813100780ULL }, // M51772243 has a factor: 3464061426746331299081 (71.55 Bits)
    {   51232133, 71,       34623350060728ULL }, // M51232133 has a factor: 3547656150433549945649 (71.58 Bits)
    {   50830523, 71,       35147782395693ULL }, // M50830523 has a factor: 3573160322926536274879 (71.59 Bits)
    {   51657589, 71,       34811323791024ULL }, // M51657589 has a factor: 3596538113885279362273 (71.60 Bits)
    {   53093213, 71,       35465933017840ULL }, // M53093213 has a factor: 3766000671919823839841 (71.67 Bits)
    {   50734577, 71,       40168065930832ULL }, // M50734577 has a factor: 4075819667817745556129 (71.78 Bits)
    {   50337173, 71,       40611552822547ULL }, // M50337173 has a factor: 4088541520454373279263 (71.79 Bits)
    {   53050093, 71,       38928727165488ULL }, // M53050093 has a factor: 4130345193001529580769 (71.80 Bits)
    {   51038681, 71,       40470748619263ULL }, // M51038681 has a factor: 4131147257219509424207 (71.80 Bits)
    {   51203717, 71,       41028152424784ULL }, // M51203717 has a factor: 4201587811583007444257 (71.83 Bits)
    {   49717271, 71,       44611668558205ULL }, // M49717271 has a factor: 4435940830940914517111 (71.90 Bits)
    {   50752613, 72,       48930580734708ULL }, // M50752613 has a factor: 4966709655787781584009 (72.07 Bits)
    {   50804063, 72,       50136644425165ULL }, // M50804063 has a factor: 5094290483969362890791 (72.10 Bits)
    {   50944769, 72,       50328898134240ULL }, // M50944769 has a factor: 5127988178946775581121 (72.11 Bits)
    {   48096799, 72,       53645214716660ULL }, // M48096799 has a factor: 5160326219078075942681 (72.12 Bits)
    {   51532177, 72,       50343307097223ULL }, // M51532177 has a factor: 5188600424198903688943 (72.13 Bits)
    {   50755769, 72,       51731986277692ULL }, // M50755769 has a factor: 5251393490843410010297 (72.15 Bits)
    {   51507913, 72,       53272356477048ULL }, // M51507913 has a factor: 5487895805449549761649 (72.21 Bits)
    {   51149009, 72,       60713154710736ULL }, // M51149009 has a factor: 6210835393435656121249 (72.39 Bits)
    {   53022301, 72,       60937455648860ULL }, // M53022301 has a factor: 6462088231176010453721 (72.45 Bits)
    {   50908933, 72,       65755731907307ULL }, // M50908933 has a factor: 6695108300070108546863 (72.50 Bits)
    {   51573077, 72,       78064255115328ULL }, // M51573077 has a factor: 8052027680020909648513 (72.76 Bits)
    {   51291299, 72,       82468544838405ULL }, // M51291299 has a factor: 8459837582803075076191 (72.84 Bits)
    {   46510507, 72,       91053161264120ULL }, // M46510507 has a factor: 8469857388693964217681 (72.84 Bits)
    {   47963869, 73,      102880777724327ULL }, // M47963869 has a factor: 9869120290775476682327 (73.06 Bits)
    {   50739071, 73,      103222393285365ULL }, // M50739071 has a factor: 10474816683392115991831 (73.14 Bits)
    {   53076719, 73,      120985819416700ULL }, // M53076719 has a factor: 12843060680329859614601 (73.44 Bits)
    {   51844393, 73,      124630146569448ULL }, // M51844393 has a factor: 12922748596788127810129 (73.45 Bits)
    {   51916901, 73,      143378013809076ULL }, // M51916901 has a factor: 14887484297004863186953 (73.65 Bits)
    {   51426913, 73,      164984955585372ULL }, // M51426913 has a factor: 16969333914395579833273 (73.84 Bits)
    {   49870277, 74,      190291970650119ULL }, // M49870277 has a factor: 18979826574394609225927 (74.00 Bits)
    {   48996149, 74,      205866337947124ULL }, // M48996149 has a factor: 20173315536283283250953 (74.09 Bits)
    {   49671203, 74,      226516545825768ULL }, // M49671203 has a factor: 22502698661141049917809 (74.25 Bits)
    {   50956709, 74,      233279129629399ULL }, // M50956709 has a factor: 23774273448597125375783 (74.33 Bits)
    {   50758453, 74,      234355374782232ULL }, // M50758453 has a factor: 23791032552362616414193 (74.33 Bits)
    {   51157933, 74,      240326919436856ULL }, // M51157933 has a factor: 24589256885294153957297 (74.38 Bits)
    {   50719327, 74,      247749185591957ULL }, // M50719327 has a factor: 25131343916044311305879 (74.41 Bits)
    {   51611033, 74,      255365528058471ULL }, // M51611033 has a factor: 26359357391376345421087 (74.48 Bits)
    {   49990951, 74,      270230842152824ULL }, // M49990951 has a factor: 27018193577501118191249 (74.51 Bits)
    {   51287959, 74,      305774524088597ULL }, // M51287959 has a factor: 31365102509400950607047 (74.73 Bits)
    {   50122463, 74,      329640317831160ULL }, // M50122463 has a factor: 33044769267601114694161 (74.80 Bits)
    {   51567589, 74,      320838875139612ULL }, // M51567589 has a factor: 33089774496843658470937 (74.80 Bits)
    {   53067527, 74,      323356685174709ULL }, // M53067527 has a factor: 34319479242278739149287 (74.86 Bits)
    {   51604321, 74,      349923559412700ULL }, // M51604321 has a factor: 36115135370791084553401 (74.93 Bits)
    {   53123843, 74,      341136139967028ULL }, // M53123843 has a factor: 36244925482468841297209 (74.94 Bits)
    {   49891693, 75,      398606803340948ULL }, // M49891693 has a factor: 39774336519995903889929 (75.07 Bits)
    {   51308501, 75,      391985259732660ULL }, // M51308501 has a factor: 40224352181956890685321 (75.09 Bits)
    {   51412421, 75,      435756142663416ULL }, // M51412421 has a factor: 44806556519895209380273 (75.24 Bits)
    {   51082211, 75,      491122141966716ULL }, // M51082211 has a factor: 50175209765431483378153 (75.40 Bits)
    {   53066743, 75,      485301756769808ULL }, // M53066743 has a factor: 51506767207903822590689 (75.44 Bits)
    {   51421577, 75,      503084197984504ULL }, // M51421577 has a factor: 51738765648286834485617 (75.45 Bits)
    {   51351359, 75,      506102808316921ULL }, // M51351359 has a factor: 51978134001580792091279 (75.46 Bits)
    {   50923703, 75,      518593175553825ULL }, // M50923703 has a factor: 52817369699459689627951 (75.48 Bits)
    {   48234931, 75,      559683122468976ULL }, // M48234931 has a factor: 53992553588311214001313 (75.51 Bits)
    {   50831093, 75,      575906549567376ULL }, // M50831093 has a factor: 58547918760736798443937 (75.63 Bits)
    {   51784223, 75,      567404368721140ULL }, // M51784223 has a factor: 58765188722059477148441 (75.63 Bits)
    {   51065437, 75,      627334896409280ULL }, // M51065437 has a factor: 64070261260979228110721 (75.76 Bits)
    {   53127847, 75,      655094257057457ULL }, // M53127847 has a factor: 69607494919054491410159 (75.88 Bits)
    {   51671491, 75,      684920466832080ULL }, // M51671491 has a factor: 70781723475259240462561 (75.90 Bits)
    {   49395389, 75,      760048958043384ULL }, // M49395389 has a factor: 75085827883195263112753 (75.99 Bits)
    {   51027377, 76,      762832516479103ULL }, // M51027377 has a factor: 77850684812475802805663 (76.04 Bits)
    {   50292533, 76,      852593845105383ULL }, // M50292533 has a factor: 85758208181118726010279 (76.18 Bits)
    {   51084851, 76,      842953375628356ULL }, // M51084851 has a factor: 86124295187843195269913 (76.18 Bits)
    {   51703507, 76,      891760399003244ULL }, // M51703507 has a factor: 92214280064374038353417 (76.28 Bits)
    {   53143919, 76,      950870091161484ULL }, // M53143919 has a factor: 101065926208417043231593 (76.41 Bits)
    {   53120449, 76,      972220249593336ULL }, // M53120449 has a factor: 103289552370580151455729 (76.45 Bits)
    {   53028841, 76,      978905090236568ULL }, // M53028841 has a factor: 103820404768491233715377 (76.45 Bits)
    {   53113309, 76,     1360920819506039ULL }, // M53113309 has a factor: 144566016021914953546103 (76.93 Bits)
    {   50825813, 77,     1555903361140608ULL }, // M50825813 has a factor: 158160106558808017828609 (77.06 Bits)
    {   50805581, 77,     1629725732542368ULL }, // M50805581 has a factor: 165598325424931226711617 (77.13 Bits)
    {   51465133, 77,     1614486667474043ULL }, // M51465133 has a factor: 166179542136556794085439 (77.13 Bits)
    {   51274621, 77,     1773083455092731ULL }, // M51274621 has a factor: 181828364322500603759903 (77.26 Bits)
    {   51739937, 77,     1893321717865743ULL }, // M51739937 has a factor: 195920692806210634556383 (77.37 Bits)
    {   53034889, 77,     1901446186305996ULL }, // M53034889 has a factor: 201685974860423635788889 (77.41 Bits)
    {   51251191, 77,     2264364163381373ULL }, // M51251191 has a factor: 232102720462027906930487 (77.61 Bits)
    {   50969377, 77,     2326754711370384ULL }, // M50969377 has a factor: 237186476140726577461537 (77.65 Bits)
    {   51798647, 77,     2371082863020228ULL }, // M51798647 has a factor: 245637768458668288063033 (77.70 Bits)
    {   51219499, 77,     2425900736757245ULL }, // M51219499 has a factor: 248506840720873947040511 (77.71 Bits)
    {   51587957, 77,     2526550153000120ULL }, // M51587957 has a factor: 260679121302627223109681 (77.78 Bits)
    {   51364549, 77,     2806848277852392ULL }, // M51364549 has a factor: 288344991806629607302417 (77.93 Bits)
    {   51517409, 77,     2837794280980659ULL }, // M51517409 has a factor: 292391617262283061585063 (77.95 Bits)
    {   51047807, 78,     3212463592350172ULL }, // M51047807 has a factor: 327978442913636513345609 (78.11 Bits)
    {   53011421, 78,     3111062249431024ULL }, // M53011421 has a factor: 329843661323590047450209 (78.12 Bits)
    {   51157429, 78,     3231084979105664ULL }, // M51157429 has a factor: 330588000823128979155713 (78.12 Bits)
    {   51089657, 78,     3908828422014967ULL }, // M51089657 has a factor: 399401406705191825792639 (78.40 Bits)
    {   50981263, 78,     4145553624833393ULL }, // M50981263 has a factor: 422691119256469079430719 (78.48 Bits)
    {   50751083, 78,     4175492695040121ULL }, // M50751083 has a factor: 423821552663749738402087 (78.48 Bits)
    {   51406151, 78,     4374586798481625ULL }, // M51406151 has a factor: 449761339050705970950751 (78.57 Bits)
    {   51679921, 78,     4364056812997860ULL }, // M51679921 has a factor: 451068222670482355938121 (78.57 Bits)
    {   53077207, 78,     4348685045428169ULL }, // M53077207 has a factor: 461632112667990659287967 (78.61 Bits)
    {   50939887, 78,     4860179336195424ULL }, // M50939887 has a factor: 495153972371059816954177 (78.71 Bits)
    {   50846503, 78,     4933354746515741ULL }, // M50846503 has a factor: 501687673837553728607447 (78.73 Bits)
    {   53081201, 78,     4782428627939931ULL }, // M53081201 has a factor: 507714110535667386674263 (78.74 Bits)
    {   51478381, 79,     6209661314961368ULL }, // M51478381 has a factor: 639326622105084604370417 (79.08 Bits)
    {   51590083, 79,     6250074060114660ULL }, // M51590083 has a factor: 644883679034924597833561 (79.09 Bits)
    {   51363101, 79,     6406752166300024ULL }, // M51363101 has a factor: 658141317199273858028849 (79.12 Bits)
    {   53111563, 79,     7195836194712837ULL }, // M53111563 has a factor: 764364214786342218468463 (79.33 Bits)
    {   51124373, 80,    13270114151094636ULL }, // M51124373 has a factor: 1356852531226281058326457 (80.16 Bits)
    {   50884469, 80,    13549853162862207ULL }, // M50884469 has a factor: 1378954166440427846726167 (80.18 Bits)
    {   50425469, 80,    13675643212263651ULL }, // M50425469 has a factor: 1379201445710122306654639 (80.19 Bits)
    {   51231259, 80,    13464357885526221ULL }, // M51231259 has a factor: 1379592012204172358684479 (80.19 Bits)
    {   51592423, 80,    13762495546987160ULL }, // M51592423 has a factor: 1420080983591555868577361 (80.23 Bits)
    {   51378827, 80,    15089985884385288ULL }, // M51378827 has a factor: 1550611548372547426994353 (80.35 Bits)
    {   50599849, 80,    19278173834439036ULL }, // M50599849 has a factor: 1950945370036732442611129 (80.69 Bits)
    {   51350527, 80,    19129858966989825ULL }, // M51350527 has a factor: 1964656678781206234775551 (80.70 Bits)
    {   51640507, 80,    19158377957052480ULL }, // M51640507 has a factor: 1978696701999628585614721 (80.71 Bits)
    {   53061139, 80,    19379098034090852ULL }, // M53061139 has a factor: 2056554028963042873200857 (80.76 Bits)
    {   51599917, 80,    20989621071714804ULL }, // M51599917 has a factor: 2166125410323869868142537 (80.84 Bits)
    {   51414301, 80,    22088670725501184ULL }, // M51414301 has a factor: 2271347130741612500064769 (80.90 Bits)
    {   51793993, 81,    24596847011914395ULL }, // M51793993 has a factor: 2547937843914330182458471 (81.07 Bits)
    {   51116959, 81,    28754123428372545ULL }, // M51116959 has a factor: 2939646696738117638981311 (81.28 Bits)
    {   50561177, 81,    34090469752046095ULL }, // M50561177 has a factor: 3447308550292697442907631 (81.51 Bits)
    {   48629519, 81,    36429370074739780ULL }, // M48629519 has a factor: 3543085488415179103131641 (81.55 Bits)
    {   50842793, 81,    39248615511665503ULL }, // M50842793 has a factor: 3991018467992396508539759 (81.72 Bits)
    {   53013923, 82,    59944886981546908ULL }, // M53013923 has a factor: 6355827245366860403200169 (82.39 Bits)
    {   51029593, 82,    65712746453662971ULL }, // M51029593 has a factor: 6706589412885229538601607 (82.47 Bits)
    {   50811659, 82,    72126762754163920ULL }, // M50811659 has a factor: 7329760947676955866286561 (82.60 Bits)
    {   53065907, 83,   102023340917861625ULL }, // M53065907 has a factor: 10827922241953079262237751 (83.16 Bits)
    {   51550007, 83,   109181510683870365ULL }, // M51550007 has a factor: 11256615280048184205685111 (83.21 Bits)
    {   51752893, 83,   117022821796058360ULL }, // M51752893 has a factor: 12112539149938952253670961 (83.32 Bits)
    {   51814799, 83,   124544575186532481ULL }, // M51814799 has a factor: 12906504259661136019972639 (83.41 Bits)
    {   51713567, 83,   128825998254635412ULL }, // M51713567 has a factor: 13324103784165942878069209 (83.46 Bits)
    {   50792059, 83,   133234554406787292ULL }, // M50792059 has a factor: 13534514696536500271428457 (83.48 Bits)
    {   51760133, 83,   133322806690603780ULL }, // M51760133 has a factor: 13801612412477883006205481 (83.51 Bits)
    {   51573157, 83,   138752195749747512ULL }, // M51573157 has a factor: 14311777550992922293470769 (83.56 Bits)
    {   50771599, 83,   189101755334162741ULL }, // M50771599 has a factor: 19201996984044443373585719 (83.98 Bits)
    {   43996961, 84,   225542457114451048ULL }, // M43996961 has a factor: 19846365379017350590530257 (84.03 Bits)
    {   51090757, 84,   277992681646859627ULL }, // M51090757 has a factor: 28405713091596130032335279 (84.55 Bits)
    {   51050171, 84,   284784486351473784ULL }, // M51050171 has a factor: 29076593452779805550434129 (84.58 Bits)
    {   50131129, 85,   401356818837779156ULL }, // M50131129 has a factor: 40240940920372673885894249 (85.05 Bits)
    {   50193919, 85,   518598741131214869ULL }, // M50193919 has a factor: 52061006411684335012363223 (85.42 Bits)
    {   50251387, 85,   578228338376308653ULL }, // M50251387 has a factor: 58113552012229675506703423 (85.58 Bits)
    {   50903353, 85,   595405644154249931ULL }, // M50903353 has a factor: 60616287365152341375837287 (85.64 Bits)
    {   50989481, 86,   837867019459207431ULL }, // M50989481 has a factor: 85444808938483775156066623 (86.14 Bits)
    {   51308849, 86,   948804681506263635ULL }, // M51308849 has a factor: 97364152267795946804812231 (86.33 Bits)
    {   51124973, 86,  1239510621560436148ULL }, // M51124973 has a factor: 126739894120981031869448009 (86.71 Bits)
    {   50856937, 86,  1266848678358044360ULL }, // M50856937 has a factor: 128856086847576650919450641 (86.73 Bits)
    {   50864773, 87,  1683302908372660140ULL }, // M50864773 has a factor: 171241640649230314854496441 (87.14 Bits)
    {   51254911, 88,  3371505488794878653ULL }, // M51254911 has a factor: 345612427528386005230629767 (88.15 Bits)
    {   53065231, 88,  3810932634544041924ULL }, // M53065231 has a factor: 404456041155036328741488889 (88.38 Bits)
    {   51007903, 88,  4081456202747311440ULL }, // M51007903 has a factor: 416373044176966390884620641 (88.42 Bits)
    {   51113333, 88,  4260667320623951875ULL }, // M51113333 has a factor: 435553815122539639925698751 (88.49 Bits)
    {   51248731, 88,  4367104879757564436ULL }, // M51248731 has a factor: 447617166462965529991461433 (88.53 Bits)
    {   51094921, 89,  6068461944418778075ULL }, // M51094921 has a factor: 620135167283167713317314151 (89.00 Bits)
    {   51076919, 89,  7852756657332703936ULL }, // M51076919 has a factor: 802189231426586549980106369 (89.37 Bits)
    {   49954973, 89, 11564613340167814576ULL }, // M49954973 has a factor: 1155419894327045985226172897 (89.90 Bits)
    {   51202493, 89, 11597949758246665147ULL }, // M51202493 has a factor: 1187687882621953128925222943 (89.94 Bits)
    {   53091919, 90, 15788962197790786464ULL }, // M53091919 has a factor: 1676532604198340827785968833 (90.43 Bits)
    {   51612269, 90, 17856408109488433059ULL }, // M51612269 has a factor: 1843219477441396918859201743 (90.57 Bits)

    /* some (all) known factors from the primenet server (2010-02-14) http://www.mersenne.org/
for exponents from 60000000 to 60010000 */
    {   60000359, 26,                    1ULL }, // M60000359 has a factor: 120000719
    {   60000851, 26,                    1ULL }, // M60000851 has a factor: 120001703
    {   60001451, 26,                    1ULL }, // M60001451 has a factor: 120002903
    {   60001811, 26,                    1ULL }, // M60001811 has a factor: 120003623
    {   60003143, 26,                    1ULL }, // M60003143 has a factor: 120006287
    {   60003431, 26,                    1ULL }, // M60003431 has a factor: 120006863
    {   60004319, 26,                    1ULL }, // M60004319 has a factor: 120008639
    {   60004991, 26,                    1ULL }, // M60004991 has a factor: 120009983
    {   60005483, 26,                    1ULL }, // M60005483 has a factor: 120010967
    {   60006623, 26,                    1ULL }, // M60006623 has a factor: 120013247
    {   60006671, 26,                    1ULL }, // M60006671 has a factor: 120013343
    {   60007523, 26,                    1ULL }, // M60007523 has a factor: 120015047
    {   60007763, 26,                    1ULL }, // M60007763 has a factor: 120015527
    {   60008159, 26,                    1ULL }, // M60008159 has a factor: 120016319
    {   60008183, 26,                    1ULL }, // M60008183 has a factor: 120016367
    {   60008303, 26,                    1ULL }, // M60008303 has a factor: 120016607
    {   60009203, 26,                    1ULL }, // M60009203 has a factor: 120018407
    {   60009479, 26,                    1ULL }, // M60009479 has a factor: 120018959
    {   60009611, 26,                    1ULL }, // M60009611 has a factor: 120019223
    {   60009791, 26,                    1ULL }, // M60009791 has a factor: 120019583
    {   60009959, 26,                    1ULL }, // M60009959 has a factor: 120019919
    {   60000713, 28,                    3ULL }, // M60000713 has a factor: 360004279
    {   60001133, 28,                    3ULL }, // M60001133 has a factor: 360006799
    {   60001477, 28,                    3ULL }, // M60001477 has a factor: 360008863
    {   60001553, 28,                    3ULL }, // M60001553 has a factor: 360009319
    {   60001741, 28,                    3ULL }, // M60001741 has a factor: 360010447
    {   60003277, 28,                    3ULL }, // M60003277 has a factor: 360019663
    {   60004177, 28,                    3ULL }, // M60004177 has a factor: 360025063
    {   60004733, 28,                    3ULL }, // M60004733 has a factor: 360028399
    {   60005357, 28,                    3ULL }, // M60005357 has a factor: 360032143
    {   60005833, 28,                    3ULL }, // M60005833 has a factor: 360034999
    {   60006893, 28,                    3ULL }, // M60006893 has a factor: 360041359
    {   60007793, 28,                    3ULL }, // M60007793 has a factor: 360046759
    {   60009533, 28,                    3ULL }, // M60009533 has a factor: 360057199
    {   60000257, 28,                    4ULL }, // M60000257 has a factor: 480002057
    {   60001811, 28,                    4ULL }, // M60001811 has a factor: 480014489
    {   60002141, 28,                    4ULL }, // M60002141 has a factor: 480017129
    {   60002339, 28,                    4ULL }, // M60002339 has a factor: 480018713
    {   60003857, 28,                    4ULL }, // M60003857 has a factor: 480030857
    {   60005207, 28,                    4ULL }, // M60005207 has a factor: 480041657
    {   60006647, 28,                    4ULL }, // M60006647 has a factor: 480053177
    {   60006677, 28,                    4ULL }, // M60006677 has a factor: 480053417
    {   60001567, 29,                    5ULL }, // M60001567 has a factor: 600015671
    {   60002671, 29,                    5ULL }, // M60002671 has a factor: 600026711
    {   60003847, 29,                    5ULL }, // M60003847 has a factor: 600038471
    {   60007951, 29,                    5ULL }, // M60007951 has a factor: 600079511
    {   60009919, 29,                    5ULL }, // M60009919 has a factor: 600099191
    {   60001433, 29,                    7ULL }, // M60001433 has a factor: 840020063
    {   60000553, 29,                    8ULL }, // M60000553 has a factor: 960008849
    {   60008671, 29,                    8ULL }, // M60008671 has a factor: 960138737
    {   60000679, 30,                    9ULL }, // M60000679 has a factor: 1080012223
    {   60002359, 30,                    9ULL }, // M60002359 has a factor: 1080042463
    {   60003499, 30,                    9ULL }, // M60003499 has a factor: 1080062983
    {   60005107, 30,                    9ULL }, // M60005107 has a factor: 1080091927
    {   60005719, 30,                    9ULL }, // M60005719 has a factor: 1080102943
    {   60001453, 30,                   11ULL }, // M60001453 has a factor: 1320031967
    {   60003143, 30,                   12ULL }, // M60003143 has a factor: 1440075433
    {   60005293, 30,                   12ULL }, // M60005293 has a factor: 1440127033
    {   60005377, 30,                   12ULL }, // M60005377 has a factor: 1440129049
    {   60005483, 30,                   12ULL }, // M60005483 has a factor: 1440131593
    {   60007169, 30,                   12ULL }, // M60007169 has a factor: 1440172057
    {   60008407, 30,                   12ULL }, // M60008407 has a factor: 1440201769
    {   60009109, 30,                   12ULL }, // M60009109 has a factor: 1440218617
    {   60005303, 30,                   13ULL }, // M60005303 has a factor: 1560137879
    {   60009491, 30,                   13ULL }, // M60009491 has a factor: 1560246767
    {   60000553, 30,                   15ULL }, // M60000553 has a factor: 1800016591
    {   60003341, 30,                   15ULL }, // M60003341 has a factor: 1800100231
    {   60001703, 30,                   16ULL }, // M60001703 has a factor: 1920054497
    {   60001063, 31,                   20ULL }, // M60001063 has a factor: 2400042521
    {   60002113, 31,                   20ULL }, // M60002113 has a factor: 2400084521
    {   60002491, 31,                   20ULL }, // M60002491 has a factor: 2400099641
    {   60005227, 31,                   20ULL }, // M60005227 has a factor: 2400209081
    {   60008527, 31,                   20ULL }, // M60008527 has a factor: 2400341081
    {   60008551, 31,                   20ULL }, // M60008551 has a factor: 2400342041
    {   60003037, 31,                   24ULL }, // M60003037 has a factor: 2880145777
    {   60004621, 31,                   24ULL }, // M60004621 has a factor: 2880221809
    {   60007811, 31,                   24ULL }, // M60007811 has a factor: 2880374929
    {   60000011, 31,                   25ULL }, // M60000011 has a factor: 3000000551
    {   60003037, 31,                   27ULL }, // M60003037 has a factor: 3240163999
    {   60009997, 31,                   27ULL }, // M60009997 has a factor: 3240539839
    {   60006377, 31,                   28ULL }, // M60006377 has a factor: 3360357113
    {   60008231, 31,                   28ULL }, // M60008231 has a factor: 3360460937
    {   60003967, 31,                   29ULL }, // M60003967 has a factor: 3480230087
    {   60001589, 31,                   31ULL }, // M60001589 has a factor: 3720098519
    {   60000337, 31,                   32ULL }, // M60000337 has a factor: 3840021569
    {   60006217, 31,                   32ULL }, // M60006217 has a factor: 3840397889
    {   60009349, 31,                   32ULL }, // M60009349 has a factor: 3840598337
    {   60002251, 31,                   33ULL }, // M60002251 has a factor: 3960148567
    {   60003347, 31,                   33ULL }, // M60003347 has a factor: 3960220903
    {   60005047, 31,                   33ULL }, // M60005047 has a factor: 3960333103
    {   60007777, 31,                   35ULL }, // M60007777 has a factor: 4200544391
    {   60005171, 32,                   36ULL }, // M60005171 has a factor: 4320372313
    {   60003949, 32,                   39ULL }, // M60003949 has a factor: 4680308023
    {   60005399, 32,                   40ULL }, // M60005399 has a factor: 4800431921
    {   60006299, 32,                   40ULL }, // M60006299 has a factor: 4800503921
    {   60006533, 32,                   43ULL }, // M60006533 has a factor: 5160561839
    {   60004387, 32,                   44ULL }, // M60004387 has a factor: 5280386057
    {   60008491, 32,                   44ULL }, // M60008491 has a factor: 5280747209
    {   60005447, 32,                   45ULL }, // M60005447 has a factor: 5400490231
    {   60001453, 32,                   47ULL }, // M60001453 has a factor: 5640136583
    {   60002951, 32,                   48ULL }, // M60002951 has a factor: 5760283297
    {   60004093, 32,                   48ULL }, // M60004093 has a factor: 5760392929
    {   60004111, 32,                   48ULL }, // M60004111 has a factor: 5760394657
    {   60006131, 32,                   48ULL }, // M60006131 has a factor: 5760588577
    {   60007561, 32,                   48ULL }, // M60007561 has a factor: 5760725857
    {   60008699, 32,                   49ULL }, // M60008699 has a factor: 5880852503
    {   60002693, 32,                   51ULL }, // M60002693 has a factor: 6120274687
    {   60006601, 32,                   51ULL }, // M60006601 has a factor: 6120673303
    {   60005587, 32,                   53ULL }, // M60005587 has a factor: 6360592223
    {   60008269, 32,                   56ULL }, // M60008269 has a factor: 6720926129
    {   60006721, 32,                   59ULL }, // M60006721 has a factor: 7080793079
    {   60002693, 32,                   60ULL }, // M60002693 has a factor: 7200323161
    {   60005503, 32,                   60ULL }, // M60005503 has a factor: 7200660361
    {   60006763, 32,                   60ULL }, // M60006763 has a factor: 7200811561
    {   60007811, 32,                   61ULL }, // M60007811 has a factor: 7320952943
    {   60001919, 32,                   64ULL }, // M60001919 has a factor: 7680245633
    {   60003227, 32,                   64ULL }, // M60003227 has a factor: 7680413057
    {   60005549, 32,                   67ULL }, // M60005549 has a factor: 8040743567
    {   60002573, 33,                   75ULL }, // M60002573 has a factor: 9000385951
    {   60006851, 33,                   76ULL }, // M60006851 has a factor: 9121041353
    {   60008239, 33,                   77ULL }, // M60008239 has a factor: 9241268807
    {   60008647, 33,                   77ULL }, // M60008647 has a factor: 9241331639
    {   60008159, 33,                   81ULL }, // M60008159 has a factor: 9721321759
    {   60006217, 33,                   83ULL }, // M60006217 has a factor: 9961032023
    {   60005531, 33,                   85ULL }, // M60005531 has a factor: 10200940271
    {   60004817, 33,                   88ULL }, // M60004817 has a factor: 10560847793
    {   60002359, 33,                   89ULL }, // M60002359 has a factor: 10680419903
    {   60001481, 33,                   91ULL }, // M60001481 has a factor: 10920269543
    {   60007333, 33,                   92ULL }, // M60007333 has a factor: 11041349273
    {   60005303, 33,                   96ULL }, // M60005303 has a factor: 11521018177
    {   60005531, 33,                   96ULL }, // M60005531 has a factor: 11521061953
    {   60006139, 33,                   96ULL }, // M60006139 has a factor: 11521178689
    {   60003287, 33,                  109ULL }, // M60003287 has a factor: 13080716567
    {   60000653, 33,                  111ULL }, // M60000653 has a factor: 13320144967
    {   60008573, 33,                  112ULL }, // M60008573 has a factor: 13441920353
    {   60008159, 33,                  120ULL }, // M60008159 has a factor: 14401958161
    {   60005741, 33,                  123ULL }, // M60005741 has a factor: 14761412287
    {   60002507, 33,                  124ULL }, // M60002507 has a factor: 14880621737
    {   60008671, 33,                  125ULL }, // M60008671 has a factor: 15002167751
    {   60006347, 33,                  129ULL }, // M60006347 has a factor: 15481637527
    {   60007693, 34,                  147ULL }, // M60007693 has a factor: 17642261743
    {   60005711, 34,                  153ULL }, // M60005711 has a factor: 18361747567
    {   60007261, 34,                  156ULL }, // M60007261 has a factor: 18722265433
    {   60008021, 34,                  168ULL }, // M60008021 has a factor: 20162695057
    {   60009109, 34,                  171ULL }, // M60009109 has a factor: 20523115279
    {   60003469, 34,                  180ULL }, // M60003469 has a factor: 21601248841
    {   60007361, 34,                  184ULL }, // M60007361 has a factor: 22082708849
    {   60002273, 34,                  211ULL }, // M60002273 has a factor: 25320959207
    {   60004621, 34,                  216ULL }, // M60004621 has a factor: 25921996273
    {   60005311, 34,                  221ULL }, // M60005311 has a factor: 26522347463
    {   60003703, 34,                  233ULL }, // M60003703 has a factor: 27961725599
    {   60000349, 34,                  236ULL }, // M60000349 has a factor: 28320164729
    {   60009109, 34,                  239ULL }, // M60009109 has a factor: 28684354103
    {   60003469, 34,                  240ULL }, // M60003469 has a factor: 28801665121
    {   60003193, 34,                  251ULL }, // M60003193 has a factor: 30121602887
    {   60002473, 34,                  275ULL }, // M60002473 has a factor: 33001360151
    {   60007499, 34,                  276ULL }, // M60007499 has a factor: 33124139449
    {   60008681, 34,                  280ULL }, // M60008681 has a factor: 33604861361
    {   60009791, 34,                  280ULL }, // M60009791 has a factor: 33605482961
    {   60007261, 35,                  311ULL }, // M60007261 has a factor: 37324516343
    {   60002003, 35,                  333ULL }, // M60002003 has a factor: 39961333999
    {   60004181, 35,                  348ULL }, // M60004181 has a factor: 41762909977
    {   60009629, 35,                  364ULL }, // M60009629 has a factor: 43687009913
    {   60002141, 35,                  375ULL }, // M60002141 has a factor: 45001605751
    {   60001477, 35,                  383ULL }, // M60001477 has a factor: 45961131383
    {   60008573, 35,                  391ULL }, // M60008573 has a factor: 46926704087
    {   60008239, 35,                  417ULL }, // M60008239 has a factor: 50046871327
    {   60006649, 35,                  431ULL }, // M60006649 has a factor: 51725731439
    {   60005093, 35,                  436ULL }, // M60005093 has a factor: 52324441097
    {   60002179, 35,                  441ULL }, // M60002179 has a factor: 52921921879
    {   60005723, 35,                  460ULL }, // M60005723 has a factor: 55205265161
    {   60008407, 35,                  473ULL }, // M60008407 has a factor: 56767953023
    {   60009487, 35,                  504ULL }, // M60009487 has a factor: 60489562897
    {   60004151, 35,                  508ULL }, // M60004151 has a factor: 60964217417
    {   60002573, 35,                  523ULL }, // M60002573 has a factor: 62762691359
    {   60000793, 35,                  551ULL }, // M60000793 has a factor: 66120873887
    {   60007261, 36,                  576ULL }, // M60007261 has a factor: 69128364673
    {   60007267, 36,                  585ULL }, // M60007267 has a factor: 70208502391
    {   60009137, 36,                  628ULL }, // M60009137 has a factor: 75371476073
    {   60009997, 36,                  699ULL }, // M60009997 has a factor: 83893975807
    {   60002237, 36,                  700ULL }, // M60002237 has a factor: 84003131801
    {   60005999, 36,                  705ULL }, // M60005999 has a factor: 84608458591
    {   60003431, 36,                  720ULL }, // M60003431 has a factor: 86404940641
    {   60000439, 36,                  732ULL }, // M60000439 has a factor: 87840642697
    {   60007523, 36,                  745ULL }, // M60007523 has a factor: 89411209271
    {   60006721, 36,                  755ULL }, // M60006721 has a factor: 90610148711
    {   60009437, 36,                  759ULL }, // M60009437 has a factor: 91094325367
    {   60005719, 36,                  765ULL }, // M60005719 has a factor: 91808750071
    {   60008503, 36,                  812ULL }, // M60008503 has a factor: 97453808873
    {   60008719, 36,                  812ULL }, // M60008719 has a factor: 97454159657
    {   60008269, 36,                  819ULL }, // M60008269 has a factor: 98293544623
    {   60000431, 36,                  840ULL }, // M60000431 has a factor: 100800724081
    {   60006407, 36,                  892ULL }, // M60006407 has a factor: 107051430089
    {   60006053, 36,                  928ULL }, // M60006053 has a factor: 111371234369
    {   60000761, 36,                  988ULL }, // M60000761 has a factor: 118561503737
    {   60001267, 36,                 1044ULL }, // M60001267 has a factor: 125282645497
    {   60008687, 36,                 1048ULL }, // M60008687 has a factor: 125778207953
    {   60006773, 36,                 1120ULL }, // M60006773 has a factor: 134415171521
    {   60007219, 37,                 1161ULL }, // M60007219 has a factor: 139336762519
    {   60008471, 37,                 1173ULL }, // M60008471 has a factor: 140779872967
    {   60003509, 37,                 1192ULL }, // M60003509 has a factor: 143048365457
    {   60006929, 37,                 1227ULL }, // M60006929 has a factor: 147257003767
    {   60006077, 37,                 1239ULL }, // M60006077 has a factor: 148695058807
    {   60000991, 37,                 1353ULL }, // M60000991 has a factor: 162362681647
    {   60005531, 37,                 1456ULL }, // M60005531 has a factor: 174736106273
    {   60000991, 37,                 1469ULL }, // M60000991 has a factor: 176282911559
    {   60003971, 37,                 1521ULL }, // M60003971 has a factor: 182532079783
    {   60008159, 37,                 1600ULL }, // M60008159 has a factor: 192026108801
    {   60003287, 37,                 1608ULL }, // M60003287 has a factor: 192970570993
    {   60001307, 37,                 1645ULL }, // M60001307 has a factor: 197404300031
    {   60007499, 37,                 1797ULL }, // M60007499 has a factor: 215666951407
    {   60004001, 37,                 1980ULL }, // M60004001 has a factor: 237615843961
    {   60006677, 37,                 2064ULL }, // M60006677 has a factor: 247707562657
    {   60004027, 37,                 2184ULL }, // M60004027 has a factor: 262097589937
    {   60001367, 38,                 2457ULL }, // M60001367 has a factor: 294846717439
    {   60002251, 38,                 2493ULL }, // M60002251 has a factor: 299171223487
    {   60003247, 38,                 2525ULL }, // M60003247 has a factor: 303016397351
    {   60003551, 38,                 2553ULL }, // M60003551 has a factor: 306378131407
    {   60008621, 38,                 2704ULL }, // M60008621 has a factor: 324526622369
    {   60006773, 38,                 2728ULL }, // M60006773 has a factor: 327396953489
    {   60008687, 38,                 2808ULL }, // M60008687 has a factor: 337008786193
    {   60001793, 38,                 2811ULL }, // M60001793 has a factor: 337330080247
    {   60008209, 38,                 2811ULL }, // M60008209 has a factor: 337366150999
    {   60006053, 38,                 2887ULL }, // M60006053 has a factor: 346474950023
    {   60006259, 38,                 2889ULL }, // M60006259 has a factor: 346716164503
    {   60006601, 38,                 3039ULL }, // M60006601 has a factor: 364720120879
    {   60004547, 38,                 3133ULL }, // M60004547 has a factor: 375988491503
    {   60005159, 38,                 3489ULL }, // M60005159 has a factor: 418715999503
    {   60002819, 38,                 3741ULL }, // M60002819 has a factor: 448941091759
    {   60000673, 38,                 3795ULL }, // M60000673 has a factor: 455405108071
    {   60004387, 38,                 3944ULL }, // M60004387 has a factor: 473314604657
    {   60005963, 38,                 4492ULL }, // M60005963 has a factor: 539093571593
    {   60003743, 38,                 4557ULL }, // M60003743 has a factor: 546874113703
    {   60009991, 39,                 4928ULL }, // M60009991 has a factor: 591458471297
    {   60003469, 39,                 5384ULL }, // M60003469 has a factor: 646117354193
    {   60002023, 39,                 5477ULL }, // M60002023 has a factor: 657262159943
    {   60007049, 39,                 5596ULL }, // M60007049 has a factor: 671598892409
    {   60006259, 39,                 5612ULL }, // M60006259 has a factor: 673510251017
    {   60006647, 39,                 5665ULL }, // M60006647 has a factor: 679875310511
    {   60002869, 39,                 5747ULL }, // M60002869 has a factor: 689672976287
    {   60008089, 39,                 6047ULL }, // M60008089 has a factor: 725737828367
    {   60006337, 39,                 7163ULL }, // M60006337 has a factor: 859650783863
    {   60003721, 39,                 8163ULL }, // M60003721 has a factor: 979620749047
    {   60003091, 39,                 8708ULL }, // M60003091 has a factor: 1045013832857
    {   60005977, 39,                 8783ULL }, // M60005977 has a factor: 1054064991983
    {   60000209, 39,                 9135ULL }, // M60000209 has a factor: 1096203818431
    {   60005513, 40,                 9351ULL }, // M60005513 has a factor: 1122223104127
    {   60004811, 40,                 9816ULL }, // M60004811 has a factor: 1178014449553
    {   60007147, 40,                11009ULL }, // M60007147 has a factor: 1321237362647
    {   60001199, 40,                11101ULL }, // M60001199 has a factor: 1332146620199
    {   60003997, 40,                11639ULL }, // M60003997 has a factor: 1396773042167
    {   60008303, 40,                12513ULL }, // M60008303 has a factor: 1501767790879
    {   60008239, 40,                12621ULL }, // M60008239 has a factor: 1514727968839
    {   60000439, 40,                13889ULL }, // M60000439 has a factor: 1666692194543
    {   60009379, 40,                14637ULL }, // M60009379 has a factor: 1756714560847
    {   60005047, 40,                17645ULL }, // M60005047 has a factor: 2117578108631
    {   60000679, 41,                20112ULL }, // M60000679 has a factor: 2413467312097
    {   60006893, 41,                20152ULL }, // M60006893 has a factor: 2418517815473
    {   60008999, 41,                21924ULL }, // M60008999 has a factor: 2631274588153
    {   60008471, 41,                23829ULL }, // M60008471 has a factor: 2859883710919
    {   60001477, 41,                24164ULL }, // M60001477 has a factor: 2899751380457
    {   60002389, 41,                28836ULL }, // M60002389 has a factor: 3460457778409
    {   60005893, 41,                33120ULL }, // M60005893 has a factor: 3974790352321
    {   60000653, 41,                34795ULL }, // M60000653 has a factor: 4175445442271
    {   60002713, 41,                35651ULL }, // M60002713 has a factor: 4278313442327
    {   60000253, 41,                36195ULL }, // M60000253 has a factor: 4343418314671
    {   60002981, 41,                36244ULL }, // M60002981 has a factor: 4349496086729
    {   60001433, 41,                36460ULL }, // M60001433 has a factor: 4375304494361
    {   60000653, 42,                38080ULL }, // M60000653 has a factor: 4569649732481
    {   60006671, 42,                43648ULL }, // M60006671 has a factor: 5238342351617
    {   60009491, 42,                44013ULL }, // M60009491 has a factor: 5282395454767
    {   60001699, 42,                56672ULL }, // M60001699 has a factor: 6800832571457
    {   60002771, 42,                57316ULL }, // M60002771 has a factor: 6878237645273
    {   60004517, 42,                59932ULL }, // M60004517 has a factor: 7192381425689
    {   60004913, 42,                62668ULL }, // M60004913 has a factor: 7520775775769
    {   60008183, 42,                67072ULL }, // M60008183 has a factor: 8049737700353
    {   60000047, 43,                73332ULL }, // M60000047 has a factor: 8799846893209
    {   60004913, 43,                77928ULL }, // M60004913 has a factor: 9352125720529
    {   60003061, 43,                79820ULL }, // M60003061 has a factor: 9578888658041
    {   60008573, 43,                84955ULL }, // M60008573 has a factor: 10196056638431
    {   60007427, 43,                93669ULL }, // M60007427 has a factor: 11241671359327
    {   60008737, 43,               105788ULL }, // M60008737 has a factor: 12696408539513
    {   60007951, 43,               110673ULL }, // M60007951 has a factor: 13282519922047
    {   60000047, 43,               130824ULL }, // M60000047 has a factor: 15698892297457
    {   60000337, 43,               132168ULL }, // M60000337 has a factor: 15860249081233
    {   60008129, 43,               132600ULL }, // M60008129 has a factor: 15914155810801
    {   60000641, 43,               141975ULL }, // M60000641 has a factor: 17037182011951
    {   60003997, 44,               155687ULL }, // M60003997 has a factor: 18683684561879
    {   60001307, 44,               161637ULL }, // M60001307 has a factor: 19396862519119
    {   60005203, 44,               175476ULL }, // M60005203 has a factor: 21058946003257
    {   60009979, 44,               181845ULL }, // M60009979 has a factor: 21825029262511
    {   60007547, 44,               185913ULL }, // M60007547 has a factor: 22312366170823
    {   60005983, 44,               186992ULL }, // M60005983 has a factor: 22441277546273
    {   60000209, 44,               194100ULL }, // M60000209 has a factor: 23292081133801
    {   60005399, 44,               197760ULL }, // M60005399 has a factor: 23733335412481
    {   60001283, 44,               205257ULL }, // M60001283 has a factor: 24631366689463
    {   60003833, 44,               224200ULL }, // M60003833 has a factor: 26905718717201
    {   60009143, 44,               227976ULL }, // M60009143 has a factor: 27361288769137
    {   60000013, 44,               232836ULL }, // M60000013 has a factor: 27940326053737
    {   60002797, 44,               234779ULL }, // M60002797 has a factor: 28174793353727
    {   60004327, 44,               251324ULL }, // M60004327 has a factor: 30161054957897
    {   60008101, 44,               284795ULL }, // M60008101 has a factor: 34180014248591
    {   60006409, 44,               286371ULL }, // M60006409 has a factor: 34368190703479
    {   60006901, 45,               311015ULL }, // M60006901 has a factor: 37326092629031
    {   60005747, 45,               333540ULL }, // M60005747 has a factor: 40028633708761
    {   60009181, 45,               335720ULL }, // M60009181 has a factor: 40292564490641
    {   60007267, 45,               382848ULL }, // M60007267 has a factor: 45947324312833
    {   60001811, 45,               412773ULL }, // M60001811 has a factor: 49534255063807
    {   60006623, 45,               477105ULL }, // M60006623 has a factor: 57258919732831
    {   60009437, 45,               484320ULL }, // M60009437 has a factor: 58127541055681
    {   60000431, 45,               488793ULL }, // M60000431 has a factor: 58655581339567
    {   60006773, 45,               491652ULL }, // M60006773 has a factor: 59004899917993
    {   60001393, 45,               496415ULL }, // M60001393 has a factor: 59571183012191
    {   60001811, 45,               503388ULL }, // M60001811 has a factor: 60408383271337
    {   60000653, 45,               518292ULL }, // M60000653 has a factor: 62195716889353
    {   60002689, 45,               534824ULL }, // M60002689 has a factor: 64181756283473
    {   60002491, 45,               578465ULL }, // M60002491 has a factor: 69418681912631
    {   60005329, 46,               607119ULL }, // M60005329 has a factor: 72860750674303
    {   60005303, 46,               617545ULL }, // M60005303 has a factor: 74111949682271
    {   60003661, 46,               625539ULL }, // M60003661 has a factor: 75069260196559
    {   60003269, 46,               658056ULL }, // M60003269 has a factor: 78971022370129
    {   60009487, 46,               704660ULL }, // M60009487 has a factor: 84572570218841
    {   60004073, 46,               706827ULL }, // M60004073 has a factor: 84824997812743
    {   60008629, 46,               774812ULL }, // M60008629 has a factor: 92990811705497
    {   60007147, 46,               811325ULL }, // M60007147 has a factor: 97370597079551
    {   60001423, 46,               829157ULL }, // M60001423 has a factor: 99501199780823
    {   60007939, 46,               911517ULL }, // M60007939 has a factor: 109396513066927
    {   60004753, 46,               912963ULL }, // M60004753 has a factor: 109564238626279
    {   60004733, 46,               939415ULL }, // M60004733 has a factor: 112738692502391
    {   60006671, 46,               963460ULL }, // M60006671 has a factor: 115628054483321
    {   60006211, 46,              1013813ULL }, // M60006211 has a factor: 121670153585087
    {   60001199, 46,              1148341ULL }, // M60001199 has a factor: 137803673721719
    {   60003499, 47,              1242572ULL }, // M60003499 has a factor: 149117335518857
    {   60006913, 47,              1251488ULL }, // M60006913 has a factor: 150195863073089
    {   60003019, 47,              1257177ULL }, // M60003019 has a factor: 150868830834727
    {   60007267, 47,              1493493ULL }, // M60007267 has a factor: 179240866427263
    {   60002953, 47,              1494407ULL }, // M60002953 has a factor: 179337665967743
    {   60005549, 47,              1501560ULL }, // M60005549 has a factor: 180203864312881
    {   60002491, 47,              1510913ULL }, // M60002491 has a factor: 181317087368567
    {   60004331, 47,              1583845ULL }, // M60004331 has a factor: 190075119265391
    {   60003689, 47,              1918959ULL }, // M60003689 has a factor: 230289238079503
    {   60001873, 47,              1953728ULL }, // M60001873 has a factor: 234454678665089
    {   60003403, 47,              2060352ULL }, // M60003403 has a factor: 247256262755713
    {   60006433, 47,              2131335ULL }, // M60006433 has a factor: 255787621756111
    {   60005237, 47,              2176704ULL }, // M60005237 has a factor: 261227278797697
    {   60009013, 48,              2358308ULL }, // M60009013 has a factor: 283039470860009
    {   60005531, 48,              2452773ULL }, // M60005531 has a factor: 294359892574927
    {   60006521, 48,              2811748ULL }, // M60006521 has a factor: 337446430817417
    {   60005389, 48,              3212579ULL }, // M60005389 has a factor: 385544105176463
    {   60006151, 48,              3235500ULL }, // M60006151 has a factor: 388299803121001
    {   60009791, 48,              3459525ULL }, // M60009791 has a factor: 415210744418551
    {   60003271, 48,              3577196ULL }, // M60003271 has a factor: 429286922016233
    {   60002273, 48,              3685231ULL }, // M60002273 has a factor: 442244473060127
    {   60006467, 48,              3691732ULL }, // M60006467 has a factor: 443055588861689
    {   60009569, 48,              3802447ULL }, // M60009569 has a factor: 456366411230687
    {   60000251, 48,              4109209ULL }, // M60000251 has a factor: 493107142822919
    {   60004073, 48,              4344223ULL }, // M60004073 has a factor: 521342148040559
    {   60008503, 49,              4788896ULL }, // M60008503 has a factor: 574748959965377
    {   60007811, 49,              4850076ULL }, // M60007811 has a factor: 582084887887273
    {   60007907, 49,              4866880ULL }, // M60007907 has a factor: 584102564840321
    {   60002693, 49,              5258028ULL }, // M60002693 has a factor: 630991679738809
    {   60008903, 49,              5521236ULL }, // M60008903 has a factor: 662646631128217
    {   60001021, 49,              5578691ULL }, // M60001021 has a factor: 669454311687023
    {   60001463, 49,              5759332ULL }, // M60001463 has a factor: 691136691805433
    {   60001471, 49,              6211041ULL }, // M60001471 has a factor: 745343192882623
    {   60008647, 49,              6623912ULL }, // M60008647 has a factor: 794983993934129
    {   60000683, 49,              7202880ULL }, // M60000683 has a factor: 864355439134081
    {   60005317, 49,              7293908ULL }, // M60005317 has a factor: 875346523417673
    {   60000683, 49,              8270868ULL }, // M60000683 has a factor: 992515458005689
    {   60002617, 49,              9235895ULL }, // M60002617 has a factor: 1108355740674431
    {   60005447, 50,              9468217ULL }, // M60005447 has a factor: 1136289186755999
    {   60006299, 50,             10527664ULL }, // M60006299 has a factor: 1263452307511073
    {   60005441, 50,             10739248ULL }, // M60005441 has a factor: 1288826624496737
    {   60002477, 50,             11227512ULL }, // M60002477 has a factor: 1347357061094449
    {   60001223, 50,             12298345ULL }, // M60001223 has a factor: 1475831481751871
    {   60005713, 50,             13409007ULL }, // M60005713 has a factor: 1609234051313983
    {   60000253, 50,             15297875ULL }, // M60000253 has a factor: 1835752740724751
    {   60009487, 50,             15462177ULL }, // M60009487 has a factor: 1855754619346399
    {   60009569, 50,             15536895ULL }, // M60009569 has a factor: 1864724745096511
    {   60008503, 50,             15664736ULL }, // M60008503 has a factor: 1880034714500417
    {   60002869, 50,             15721632ULL }, // M60002869 has a factor: 1886686050724417
    {   60003721, 50,             17623755ULL }, // M60003721 has a factor: 2114981755984711
    {   60005531, 50,             18715393ULL }, // M60005531 has a factor: 2246054189677367
    {   60009179, 51,             19256181ULL }, // M60009179 has a factor: 2311095224970799
    {   60000403, 51,             20264145ULL }, // M60000403 has a factor: 2431713732900871
    {   60005587, 51,             21930213ULL }, // M60005587 has a factor: 2631870608200063
    {   60006403, 51,             22692701ULL }, // M60006403 has a factor: 2723414722729007
    {   60008089, 51,             23933727ULL }, // M60008089 has a factor: 2872434439835407
    {   60002489, 51,             24720219ULL }, // M60002489 has a factor: 2966549337250183
    {   60009419, 51,             25052740ULL }, // M60009419 has a factor: 3006800743516121
    {   60001849, 51,             25555715ULL }, // M60001849 has a factor: 3066780305034071
    {   60007327, 51,             27397152ULL }, // M60007327 has a factor: 3288059717865409
    {   60005713, 51,             27864827ULL }, // M60005713 has a factor: 3344097623513303
    {   60000023, 51,             28797676ULL }, // M60000023 has a factor: 3455722444693097
    {   60002489, 51,             31303392ULL }, // M60002489 has a factor: 3756562868285377
    {   60004411, 51,             34300224ULL }, // M60004411 has a factor: 4116329476576129
    {   60008293, 51,             36505983ULL }, // M60008293 has a factor: 4381323448234039
    {   60000103, 51,             37027253ULL }, // M60000103 has a factor: 4443277987614119
    {   60006449, 52,             38356311ULL }, // M60006449 has a factor: 4603252039699279
    {   60005159, 52,             42133549ULL }, // M60005159 has a factor: 5056460613958583
    {   60004129, 52,             46678092ULL }, // M60004129 has a factor: 5601756507683737
    {   60002489, 52,             53058292ULL }, // M60002489 has a factor: 6367259164177577
    {   60002993, 52,             53406735ULL }, // M60002993 has a factor: 6409127892715711
    {   60000211, 52,             56242233ULL }, // M60000211 has a factor: 6749091694222327
    {   60005159, 52,             58424404ULL }, // M60005159 has a factor: 7011531303000473
    {   60001021, 52,             60635696ULL }, // M60001021 has a factor: 7276407338091233
    {   60003043, 52,             62615528ULL }, // M60003043 has a factor: 7514244438103409
    {   60000541, 53,             85045008ULL }, // M60000541 has a factor: 10205492978698657
    {   60008887, 53,             91757225ULL }, // M60008887 has a factor: 11012497892917151
    {   60008651, 53,            112756068ULL }, // M60008651 has a factor: 13532679065488537
    {   60005899, 53,            124981101ULL }, // M60005899 has a factor: 14999206647029599
    {   60001147, 53,            130073828ULL }, // M60001147 has a factor: 15609157749361433
    {   60000071, 53,            138302805ULL }, // M60000071 has a factor: 16596356238998311
    {   60000067, 53,            140778128ULL }, // M60000067 has a factor: 16893394224269153
    {   60009889, 54,            166825091ULL }, // M60009889 has a factor: 20022310386649799
    {   60005123, 54,            241583121ULL }, // M60005123 has a factor: 28992449780657767
    {   60006833, 54,            242900323ULL }, // M60006833 has a factor: 29151358235814119
    {   60005233, 54,            276043331ULL }, // M60005233 has a factor: 33128088789502247
    {   60008539, 55,            329890104ULL }, // M60008539 has a factor: 39592446343196113
    {   60002153, 55,            366232428ULL }, // M60002153 has a factor: 43949468356834969
    {   60009709, 55,            543998019ULL }, // M60009709 has a factor: 65290325633532943
    {   60001351, 55,            579696120ULL }, // M60001351 has a factor: 69565100738916241
    {   60002021, 56,            605059011ULL }, // M60002021 has a factor: 72609526968522463
    {   60007979, 56,            629414497ULL }, // M60007979 has a factor: 75539783836543127
    {   60001637, 56,            686239767ULL }, // M60001637 has a factor: 82351018788997159
    {   60007151, 56,            848475108ULL }, // M60007151 has a factor: 101829147850994617
    {   60008833, 56,            878064260ULL }, // M60008833 has a factor: 105383223083217161
    {   60004979, 56,            951843181ULL }, // M60004979 has a factor: 114230660174396399
    {   60008677, 56,           1165182087ULL }, // M60008677 has a factor: 139842071009937799
    {   60002353, 57,           1721641491ULL }, // M60002353 has a factor: 206605080964856647
    {   60001349, 57,           1726131087ULL }, // M60001349 has a factor: 207140387541672727
    {   60007687, 57,           1847732669ULL }, // M60007687 has a factor: 221756327322053207
    {   60003089, 57,           2181993532ULL }, // M60003089 has a factor: 261852704196040697
    {   60001237, 58,           2563304064ULL }, // M60001237 has a factor: 307602829294254337
    {   60006761, 58,           2663587080ULL }, // M60006761 has a factor: 319666466624495761
    {   60003157, 58,           3404512407ULL }, // M60003157 has a factor: 408562984931337799
    {   60008017, 58,           3676868648ULL }, // M60008017 has a factor: 441283192671902033
    {   60009827, 58,           4080970285ULL }, // M60009827 has a factor: 489796641589981391
    {   60009931, 59,           6042649461ULL }, // M60009931 has a factor: 725237954423594383
    {   60006181, 59,           6894845084ULL }, // M60006181 has a factor: 827466644154928409
    {   60007631, 59,           9291987076ULL }, // M60007631 has a factor: 1115180263426753913
    {   60003479, 60,          13275545949ULL }, // M60003479 has a factor: 1593157885128713143
    {   60001913, 60,          16252351135ULL }, // M60001913 has a factor: 1950344317695442511
    {   60002531, 61,          32036845168ULL }, // M60002531 has a factor: 3844583590670240417
    {   60002549, 61,          36055891015ULL }, // M60002549 has a factor: 4326890734732394471
    {   60005371, 62,          43027949420ULL }, // M60005371 has a factor: 5163816136632669641
    {   60008387, 62,          49583739672ULL }, // M60008387 has a factor: 5950880478289258129
    {   60005497, 62,          50865211319ULL }, // M60005497 has a factor: 6104384570413241087
    {   60008309, 62,          55459932147ULL }, // M60008309 has a factor: 6656113490792418847
    {   60009701, 62,          56315888143ULL }, // M60009701 has a factor: 6758999218021750487
    {   60009121, 62,          57333577508ULL }, // M60009121 has a factor: 6881075180080900937
    {   60004193, 62,          72020648952ULL }, // M60004193 has a factor: 8643081839402111473
    {   60003511, 63,          91880828649ULL }, // M60003511 has a factor: 11026344625058773279
    {   60002603, 63,         104075237440ULL }, // M60002603 has a factor: 12489570308486112641
    {   60007393, 63,         124699351796ULL }, // M60007393 has a factor: 14965766020135655657
    {   60004333, 63,         136606426127ULL }, // M60004333 has a factor: 16393954966528816583
    {   60008791, 64,         244596059409ULL }, // M60008791 has a factor: 29355827616996529039
    {   60008807, 64,         259574105937ULL }, // M60008807 has a factor: 31153464850741974319
    {   60003173, 65,         542202503032ULL }, // M60003173 has a factor: 65067741180924241073
    {   60002017, 66,         645764071988ULL }, // M60002017 has a factor: 77494293650826399593
    {   60000277, 66,         900078885083ULL }, // M60000277 has a factor: 108009964853662335983
    {   60008659, 66,         919681270124ULL }, // M60008659 has a factor: 110377679455116007433
    {   60007669, 67,        2212783918767ULL }, // M60007669 has a factor: 265568009931786048247
    {   60001507, 68,        2460213165605ULL }, // M60001507 has a factor: 295232994955081133471
    {   60004253, 68,        3118352232028ULL }, // M60004253 has a factor: 374228792547445630169
    {   60000049, 69,        5250034612427ULL }, // M60000049 has a factor: 630004667994632017847
    {   60000799, 69,        5779765242152ULL }, // M60000799 has a factor: 693581065123096958897
    {   60000587, 82,    55947442240407240ULL }, // M60000587 has a factor: 6713758751146059038099761

    /* some (all) known factors from the primenet server (2010-02-14) http://www.mersenne.org/
for exponents from 332192857 to 332200000 (aka 100M digit range) */
    {  332192879, 29,                    1ULL }, // M332192879 has a factor: 664385759
    {  332192891, 29,                    1ULL }, // M332192891 has a factor: 664385783
    {  332192963, 29,                    1ULL }, // M332192963 has a factor: 664385927
    {  332193299, 29,                    1ULL }, // M332193299 has a factor: 664386599
    {  332194283, 29,                    1ULL }, // M332194283 has a factor: 664388567
    {  332194559, 29,                    1ULL }, // M332194559 has a factor: 664389119
    {  332194799, 29,                    1ULL }, // M332194799 has a factor: 664389599
    {  332195219, 29,                    1ULL }, // M332195219 has a factor: 664390439
    {  332195471, 29,                    1ULL }, // M332195471 has a factor: 664390943
    {  332195663, 29,                    1ULL }, // M332195663 has a factor: 664391327
    {  332196071, 29,                    1ULL }, // M332196071 has a factor: 664392143
    {  332196443, 29,                    1ULL }, // M332196443 has a factor: 664392887
    {  332196863, 29,                    1ULL }, // M332196863 has a factor: 664393727
    {  332197031, 29,                    1ULL }, // M332197031 has a factor: 664394063
    {  332197223, 29,                    1ULL }, // M332197223 has a factor: 664394447
    {  332199083, 29,                    1ULL }, // M332199083 has a factor: 664398167
    {  332199863, 29,                    1ULL }, // M332199863 has a factor: 664399727
    {  332192857, 30,                    3ULL }, // M332192857 has a factor: 1993157143
    {  332192977, 30,                    3ULL }, // M332192977 has a factor: 1993157863
    {  332193137, 30,                    3ULL }, // M332193137 has a factor: 1993158823
    {  332193217, 30,                    3ULL }, // M332193217 has a factor: 1993159303
    {  332194061, 30,                    3ULL }, // M332194061 has a factor: 1993164367
    {  332194097, 30,                    3ULL }, // M332194097 has a factor: 1993164583
    {  332194601, 30,                    3ULL }, // M332194601 has a factor: 1993167607
    {  332195173, 30,                    3ULL }, // M332195173 has a factor: 1993171039
    {  332195393, 30,                    3ULL }, // M332195393 has a factor: 1993172359
    {  332195681, 30,                    3ULL }, // M332195681 has a factor: 1993174087
    {  332197093, 30,                    3ULL }, // M332197093 has a factor: 1993182559
    {  332194679, 31,                    4ULL }, // M332194679 has a factor: 2657557433
    {  332197241, 31,                    4ULL }, // M332197241 has a factor: 2657577929
    {  332197259, 31,                    4ULL }, // M332197259 has a factor: 2657578073
    {  332197637, 31,                    4ULL }, // M332197637 has a factor: 2657581097
    {  332198351, 31,                    4ULL }, // M332198351 has a factor: 2657586809
    {  332198597, 31,                    4ULL }, // M332198597 has a factor: 2657588777
    {  332194097, 32,                    7ULL }, // M332194097 has a factor: 4650717359
    {  332196317, 32,                    7ULL }, // M332196317 has a factor: 4650748439
    {  332198777, 32,                    7ULL }, // M332198777 has a factor: 4650782879
    {  332198827, 32,                    8ULL }, // M332198827 has a factor: 5315181233
    {  332194207, 32,                    9ULL }, // M332194207 has a factor: 5979495727
    {  332195047, 32,                    9ULL }, // M332195047 has a factor: 5979510847
    {  332195159, 32,                    9ULL }, // M332195159 has a factor: 5979512863
    {  332195587, 32,                    9ULL }, // M332195587 has a factor: 5979520567
    {  332196349, 32,                   11ULL }, // M332196349 has a factor: 7308319679
    {  332193943, 32,                   12ULL }, // M332193943 has a factor: 7972654633
    {  332197597, 32,                   12ULL }, // M332197597 has a factor: 7972742329
    {  332197699, 32,                   12ULL }, // M332197699 has a factor: 7972744777
    {  332197963, 32,                   12ULL }, // M332197963 has a factor: 7972751113
    {  332199757, 32,                   12ULL }, // M332199757 has a factor: 7972794169
    {  332197933, 33,                   15ULL }, // M332197933 has a factor: 9965937991
    {  332198129, 33,                   16ULL }, // M332198129 has a factor: 10630340129
    {  332197087, 33,                   17ULL }, // M332197087 has a factor: 11294700959
    {  332199247, 33,                   17ULL }, // M332199247 has a factor: 11294774399
    {  332195441, 33,                   19ULL }, // M332195441 has a factor: 12623426759
    {  332196017, 33,                   19ULL }, // M332196017 has a factor: 12623448647
    {  332198533, 33,                   20ULL }, // M332198533 has a factor: 13287941321
    {  332199793, 33,                   20ULL }, // M332199793 has a factor: 13287991721
    {  332195821, 33,                   23ULL }, // M332195821 has a factor: 15281007767
    {  332194931, 33,                   24ULL }, // M332194931 has a factor: 15945356689
    {  332194139, 33,                   25ULL }, // M332194139 has a factor: 16609706951
    {  332194931, 33,                   25ULL }, // M332194931 has a factor: 16609746551
    {  332197169, 34,                   27ULL }, // M332197169 has a factor: 17938647127
    {  332197633, 34,                   27ULL }, // M332197633 has a factor: 17938672183
    {  332199167, 34,                   28ULL }, // M332199167 has a factor: 18603153353
    {  332194193, 34,                   31ULL }, // M332194193 has a factor: 20596039967
    {  332194847, 34,                   33ULL }, // M332194847 has a factor: 21924859903
    {  332196947, 34,                   33ULL }, // M332196947 has a factor: 21924998503
    {  332197031, 34,                   33ULL }, // M332197031 has a factor: 21925004047
    {  332194193, 34,                   36ULL }, // M332194193 has a factor: 23917981897
    {  332196169, 34,                   39ULL }, // M332196169 has a factor: 25911301183
    {  332197169, 34,                   39ULL }, // M332197169 has a factor: 25911379183
    {  332197681, 34,                   44ULL }, // M332197681 has a factor: 29233395929
    {  332196223, 34,                   45ULL }, // M332196223 has a factor: 29897660071
    {  332199851, 34,                   49ULL }, // M332199851 has a factor: 32555585399
    {  332194207, 35,                   57ULL }, // M332194207 has a factor: 37870139599
    {  332193601, 35,                   63ULL }, // M332193601 has a factor: 41856393727
    {  332196317, 35,                   67ULL }, // M332196317 has a factor: 44514306479
    {  332197637, 35,                   72ULL }, // M332197637 has a factor: 47836459729
    {  332195293, 35,                   75ULL }, // M332195293 has a factor: 49829293951
    {  332195527, 35,                   77ULL }, // M332195527 has a factor: 51158111159
    {  332194703, 35,                   88ULL }, // M332194703 has a factor: 58466267729
    {  332198437, 35,                   95ULL }, // M332198437 has a factor: 63117703031
    {  332194361, 36,                  108ULL }, // M332194361 has a factor: 71753981977
    {  332197169, 36,                  115ULL }, // M332197169 has a factor: 76405348871
    {  332193707, 36,                  129ULL }, // M332193707 has a factor: 85705976407
    {  332193689, 36,                  132ULL }, // M332193689 has a factor: 87699133897
    {  332199779, 36,                  132ULL }, // M332199779 has a factor: 87700741657
    {  332193221, 36,                  136ULL }, // M332193221 has a factor: 90356556113
    {  332194273, 36,                  140ULL }, // M332194273 has a factor: 93014396441
    {  332193769, 36,                  155ULL }, // M332193769 has a factor: 102980068391
    {  332198777, 36,                  184ULL }, // M332198777 has a factor: 122249149937
    {  332198281, 36,                  203ULL }, // M332198281 has a factor: 134872502087
    {  332197909, 37,                  207ULL }, // M332197909 has a factor: 137529934327
    {  332194147, 37,                  213ULL }, // M332194147 has a factor: 141514706623
    {  332197223, 37,                  240ULL }, // M332197223 has a factor: 159454667041
    {  332199799, 37,                  249ULL }, // M332199799 has a factor: 165435499903
    {  332198267, 37,                  273ULL }, // M332198267 has a factor: 181380253783
    {  332193203, 37,                  285ULL }, // M332193203 has a factor: 189350125711
    {  332198221, 37,                  291ULL }, // M332198221 has a factor: 193339364623
    {  332195579, 37,                  300ULL }, // M332195579 has a factor: 199317347401
    {  332194561, 37,                  308ULL }, // M332194561 has a factor: 204631849577
    {  332198623, 37,                  317ULL }, // M332198623 has a factor: 210613926983
    {  332197111, 37,                  348ULL }, // M332197111 has a factor: 231209189257
    {  332197637, 37,                  372ULL }, // M332197637 has a factor: 247155041929
    {  332194067, 38,                  444ULL }, // M332194067 has a factor: 294988331497
    {  332194519, 38,                  444ULL }, // M332194519 has a factor: 294988732873
    {  332192921, 38,                  456ULL }, // M332192921 has a factor: 302959943953
    {  332195063, 38,                  456ULL }, // M332195063 has a factor: 302961897457
    {  332194091, 38,                  496ULL }, // M332194091 has a factor: 329536538273
    {  332199953, 38,                  496ULL }, // M332199953 has a factor: 329542353377
    {  332193871, 38,                  545ULL }, // M332193871 has a factor: 362091319391
    {  332193089, 38,                  555ULL }, // M332193089 has a factor: 368734328791
    {  332195471, 38,                  588ULL }, // M332195471 has a factor: 390661873897
    {  332197543, 38,                  617ULL }, // M332197543 has a factor: 409931768063
    {  332198777, 38,                  648ULL }, // M332198777 has a factor: 430529614993
    {  332197367, 38,                  724ULL }, // M332197367 has a factor: 481021787417
    {  332198057, 38,                  820ULL }, // M332198057 has a factor: 544804813481
    {  332195557, 39,                  840ULL }, // M332195557 has a factor: 558088535761
    {  332199799, 39,                  881ULL }, // M332199799 has a factor: 585336045839
    {  332193203, 39,                  925ULL }, // M332193203 has a factor: 614557425551
    {  332196863, 39,                 1053ULL }, // M332196863 has a factor: 699606593479
    {  332194679, 39,                 1056ULL }, // M332194679 has a factor: 701595162049
    {  332196283, 39,                 1073ULL }, // M332196283 has a factor: 712893223319
    {  332192873, 39,                 1132ULL }, // M332192873 has a factor: 752084664473
    {  332197933, 39,                 1172ULL }, // M332197933 has a factor: 778671954953
    {  332193383, 39,                 1341ULL }, // M332193383 has a factor: 890942653207
    {  332198159, 39,                 1540ULL }, // M332198159 has a factor: 1023170329721
    {  332192909, 39,                 1575ULL }, // M332192909 has a factor: 1046407663351
    {  332193803, 39,                 1593ULL }, // M332193803 has a factor: 1058369456359
    {  332199863, 40,                 1840ULL }, // M332199863 has a factor: 1222495495841
    {  332197373, 40,                 1960ULL }, // M332197373 has a factor: 1302213702161
    {  332196523, 40,                 2105ULL }, // M332196523 has a factor: 1398547361831
    {  332196311, 40,                 2413ULL }, // M332196311 has a factor: 1603179396887
    {  332193947, 40,                 2493ULL }, // M332193947 has a factor: 1656319019743
    {  332193383, 40,                 2917ULL }, // M332193383 has a factor: 1938016196423
    {  332193119, 40,                 3001ULL }, // M332193119 has a factor: 1993823100239
    {  332199577, 40,                 3195ULL }, // M332199577 has a factor: 2122755297031
    {  332193299, 40,                 3276ULL }, // M332193299 has a factor: 2176530495049
    {  332196077, 41,                 3435ULL }, // M332196077 has a factor: 2282187048991
    {  332198501, 41,                 3895ULL }, // M332198501 has a factor: 2587826322791
    {  332195327, 41,                 4168ULL }, // M332195327 has a factor: 2769180245873
    {  332197603, 41,                 4253ULL }, // M332197603 has a factor: 2825672811119
    {  332197909, 41,                 4299ULL }, // M332197909 has a factor: 2856237621583
    {  332194679, 41,                 4416ULL }, // M332194679 has a factor: 2933943404929
    {  332196863, 41,                 6048ULL }, // M332196863 has a factor: 4018253254849
    {  332194519, 41,                 6284ULL }, // M332194519 has a factor: 4175020714793
    {  332198437, 41,                 6599ULL }, // M332198437 has a factor: 4384354971527
    {  332194703, 42,                 8701ULL }, // M332194703 has a factor: 5780852221607
    {  332199757, 42,                 8843ULL }, // M332199757 has a factor: 5875284902303
    {  332197967, 42,                 9109ULL }, // M332197967 has a factor: 6051982562807
    {  332199121, 42,                 9116ULL }, // M332199121 has a factor: 6056654374073
    {  332195401, 42,                 9519ULL }, // M332195401 has a factor: 6324336044239
    {  332198149, 42,                10040ULL }, // M332198149 has a factor: 6670538831921
    {  332197109, 43,                13279ULL }, // M332197109 has a factor: 8822490820823
    {  332194321, 43,                15111ULL }, // M332194321 has a factor: 10039576769263
    {  332195293, 43,                17051ULL }, // M332195293 has a factor: 11328523881887
    {  332198743, 43,                18953ULL }, // M332198743 has a factor: 12592325552159
    {  332199247, 43,                20024ULL }, // M332199247 has a factor: 13303915443857
    {  332198849, 43,                23776ULL }, // M332198849 has a factor: 15796719667649
    {  332199643, 44,                28232ULL }, // M332199643 has a factor: 18757320642353
    {  332196283, 44,                37241ULL }, // M332196283 has a factor: 24742643550407
    {  332197603, 44,                38741ULL }, // M332197603 has a factor: 25739334675647
    {  332196409, 44,                44807ULL }, // M332196409 has a factor: 29769448996127
    {  332194199, 44,                47829ULL }, // M332194199 has a factor: 31777032687943
    {  332192929, 44,                48860ULL }, // M332192929 has a factor: 32461893021881
    {  332195557, 45,                57467ULL }, // M332195557 has a factor: 38180564148239
    {  332198807, 45,                61840ULL }, // M332198807 has a factor: 41086348449761
    {  332196127, 45,                67505ULL }, // M332196127 has a factor: 44849799106271
    {  332198561, 45,                71659ULL }, // M332198561 has a factor: 47610033365399
    {  332196649, 45,                73479ULL }, // M332196649 has a factor: 48818955143743
    {  332197111, 45,                73809ULL }, // M332197111 has a factor: 49038273131599
    {  332193161, 45,                74464ULL }, // M332193161 has a factor: 49472863081409
    {  332198623, 45,                78777ULL }, // M332198623 has a factor: 52339221848143
    {  332195063, 45,                89461ULL }, // M332195063 has a factor: 59437005062087
    {  332195443, 45,               101988ULL }, // M332195443 has a factor: 67759897681369
    {  332194847, 45,               104005ULL }, // M332194847 has a factor: 69099850124471
    {  332193137, 46,               110367ULL }, // M332193137 has a factor: 73326319902559
    {  332197933, 46,               118428ULL }, // M332197933 has a factor: 78683073618649
    {  332193569, 46,               124551ULL }, // M332193569 has a factor: 82750082425039
    {  332194969, 46,               126687ULL }, // M332194969 has a factor: 84169568075407
    {  332198123, 46,               134268ULL }, // M332198123 has a factor: 89207155157929
    {  332195207, 46,               141988ULL }, // M332195207 has a factor: 94335466103033
    {  332195531, 46,               157965ULL }, // M332195531 has a factor: 104950534108831
    {  332198707, 46,               173817ULL }, // M332198707 has a factor: 115483565309239
    {  332196649, 46,               185427ULL }, // M332196649 has a factor: 123196456068247
    {  332198351, 46,               205729ULL }, // M332198351 has a factor: 136685669105759
    {  332193709, 47,               226784ULL }, // M332193709 has a factor: 150672436203713
    {  332194699, 47,               232661ULL }, // M332194699 has a factor: 154577501728079
    {  332193013, 47,               288728ULL }, // M332193013 has a factor: 191826848514929
    {  332199563, 47,               308220ULL }, // M332199563 has a factor: 204781098615721
    {  332196023, 47,               320617ULL }, // M332196023 has a factor: 213015384612383
    {  332196307, 48,               583473ULL }, // M332196307 has a factor: 387655151668423
    {  332197319, 48,               672621ULL }, // M332197319 has a factor: 446885785806199
    {  332194969, 48,               696992ULL }, // M332194969 has a factor: 463074471666497
    {  332193601, 48,               775068ULL }, // M332193601 has a factor: 514945259879737
    {  332195989, 49,               939407ULL }, // M332195989 has a factor: 624134474877047
    {  332196287, 49,               988449ULL }, // M332196287 has a factor: 656718175377727
    {  332193709, 49,               994187ULL }, // M332193709 has a factor: 660525333939167
    {  332194657, 49,              1137923ULL }, // M332194657 has a factor: 756023881354823
    {  332193467, 49,              1148208ULL }, // M332193467 has a factor: 762854392714273
    {  332198827, 49,              1187624ULL }, // M332198827 has a factor: 789054599434097
    {  332196311, 49,              1460100ULL }, // M332196311 has a factor: 970079667382201
    {  332199691, 49,              1516593ULL }, // M332199691 has a factor: 1007623451945527
    {  332197237, 50,              1741923ULL }, // M332197237 has a factor: 1157324015333503
    {  332196071, 50,              2051029ULL }, // M332196071 has a factor: 1362687550614119
    {  332195951, 50,              2262700ULL }, // M332195951 has a factor: 1503319556655401
    {  332194141, 50,              2364588ULL }, // M332194141 has a factor: 1571004558957817
    {  332196283, 50,              2843216ULL }, // M332196283 has a factor: 1889011573932257
    {  332193269, 50,              2973376ULL }, // M332193269 has a factor: 1975470986812289
    {  332192863, 50,              3232965ULL }, // M332192863 has a factor: 2147935798657591
    {  332194283, 50,              3312936ULL }, // M332194283 has a factor: 2201076798289777
    {  332192989, 51,              3716927ULL }, // M332192989 has a factor: 2469474180049607
    {  332199181, 51,              3920195ULL }, // M332199181 has a factor: 2604571136720591
    {  332192863, 51,              4674852ULL }, // M332192863 has a factor: 3105904939962553
    {  332195587, 51,              4968177ULL }, // M332195587 has a factor: 3300812949669799
    {  332198707, 52,              9097380ULL }, // M332198707 has a factor: 6044275746175321
    {  332193803, 52,              9211141ULL }, // M332193803 has a factor: 6119767917518447
    {  332193989, 52,             10951264ULL }, // M332193989 has a factor: 7275888145504193
    {  332198213, 52,             10980660ULL }, // M332198213 has a factor: 7295511259121161
    {  332198437, 52,             11820872ULL }, // M332198437 has a factor: 7853750404754129
    {  332192863, 53,             14703681ULL }, // M332192863 has a factor: 9768915776057407
    {  332198917, 53,             16168824ULL }, // M332198917 has a factor: 10742531643927217
    {  332195009, 53,             17704164ULL }, // M332195009 has a factor: 11762469838634953
    {  332196013, 53,             18351015ULL }, // M332196013 has a factor: 12192268035006391
    {  332198267, 53,             19184817ULL }, // M332198267 has a factor: 12746325920224279
    {  332192929, 53,             20278335ULL }, // M332192929 has a factor: 13472638997786431
    {  332195173, 53,             21480200ULL }, // M332195173 has a factor: 14271237510149201
    {  332193299, 54,             27839625ULL }, // M332193299 has a factor: 18496273743345751
    {  332193661, 54,             31864191ULL }, // M332193661 has a factor: 21170164526186503
    {  332196041, 54,             46222743ULL }, // M332196041 has a factor: 30710024457520927
    {  332197301, 54,             47209728ULL }, // M332197301 has a factor: 31365888445088257
    {  332195707, 54,             48037545ULL }, // M332195707 has a factor: 31915732447638631
    {  332199451, 54,             48649845ULL }, // M332199451 has a factor: 32322903600470191
    {  332195191, 54,             48878061ULL }, // M332195191 has a factor: 32474113619209303
    {  332199457, 54,             52048535ULL }, // M332199457 has a factor: 34580990129290991
    {  332193769, 55,             55060776ULL }, // M332193769 has a factor: 36581693407009489
    {  332199631, 55,             56072228ULL }, // M332199631 has a factor: 37254346901895737
    {  332199103, 55,             76363008ULL }, // M332199103 has a factor: 50735445519963649
    {  332199377, 55,             85701660ULL }, // M332199377 has a factor: 56940076119731641
    {  332197321, 55,             88619456ULL }, // M332197321 has a factor: 58878291743354753
    {  332199697, 55,            104503304ULL }, // M332199697 has a factor: 69431931848597777
    {  332194211, 56,            126741880ULL }, // M332194211 has a factor: 84205837654513361
    {  332195719, 56,            131855196ULL }, // M332195719 has a factor: 87603463278211849
    {  332195863, 56,            169624532ULL }, // M332195863 has a factor: 112697135587422233
    {  332193139, 56,            194051225ULL }, // M332193139 has a factor: 128924971119090551
    {  332195687, 56,            203529613ULL }, // M332195687 has a factor: 135223319230758263
    {  332199001, 56,            203629080ULL }, // M332199001 has a factor: 135290753901098161
    {  332193259, 57,            224734097ULL }, // M332193259 has a factor: 149310304181704247
    {  332198747, 57,            260974464ULL }, // M332198747 has a factor: 173390779879593217
    {  332194147, 57,            274469024ULL }, // M332194147 has a factor: 182354006611205057
    {  332193137, 57,            274988919ULL }, // M332193137 has a factor: 182698863285697807
    {  332193947, 57,            362103133ULL }, // M332193947 has a factor: 240576937944671903
    {  332194327, 57,            387013637ULL }, // M332194327 has a factor: 257127469366074599
    {  332193053, 57,            421997196ULL }, // M332193053 has a factor: 280369073793358777
    {  332192953, 58,            527503223ULL }, // M332192953 has a factor: 350465706730775039
    {  332192977, 58,            594222332ULL }, // M332192977 has a factor: 394792970933924729
    {  332197361, 58,            718216063ULL }, // M332197361 has a factor: 477178961512819487
    {  332195987, 58,            724454172ULL }, // M332195987 has a factor: 481321537407615529
    {  332195881, 59,           1253531559ULL }, // M332195881 has a factor: 832836041206616959
    {  332198803, 59,           1398886428ULL }, // M332198803 has a factor: 929416793829091369
    {  332193871, 59,           1403187144ULL }, // M332193871 has a factor: 932260338205588849
    {  332194663, 60,           2038665116ULL }, // M332194663 has a factor: 1354467342358951817
    {  332195933, 60,           2178277515ULL }, // M332195933 has a factor: 1447229862856692991
    {  332194981, 60,           3042225840ULL }, // M332194981 has a factor: 2021224310233018081
    {  332193047, 61,           4404911320ULL }, // M332193047 has a factor: 2926561826311184081
    {  332193569, 61,           4829527656ULL }, // M332193569 has a factor: 3208676057261688529
    {  332197069, 61,           4903793127ULL }, // M332197069 has a factor: 3258051407543489527
    {  332193203, 61,           5332673013ULL }, // M332193203 has a factor: 3542955457480261279
    {  332196757, 61,           6016146459ULL }, // M332196757 has a factor: 3997088686633666927
    {  332198467, 62,          12951433629ULL }, // M332198467 has a factor: 8604892794012093487
    {  332193629, 63,          14884578940ULL }, // M332193629 has a factor: 9889124588431146521
    {  332193013, 63,          23023051611ULL }, // M332193013 has a factor: 15296193766225187887
    {  332195503, 64,          34768671201ULL }, // M332195503 has a factor: 23099992436515618207
    {  332196197, 64,          41957877547ULL }, // M332196197 has a factor: 27876494710610177519
    {  332196463, 64,          49202125128ULL }, // M332196463 has a factor: 32689543879210044529
    {  332195111, 64,          52245394801ULL }, // M332195111 has a factor: 34711329450314035823
    {  332195729, 65,          92860536415ULL }, // M332195729 has a factor: 61695747179423943071
    {  332193469, 65,          93931219527ULL }, // M332193469 has a factor: 62406675324149338327
    {  332196379, 66,         115850972244ULL }, // M332196379 has a factor: 76970546966172608953
    {  332194567, 66,         152641497369ULL }, // M332194567 has a factor: 101413352249453188447
    {  332197897, 66,         175933372535ULL }, // M332197897 has a factor: 116889392736489117791
    {  332193817, 67,         232499484395ULL }, // M332193817 has a factor: 154469782343413971431
    {  332193019, 67,         369585210272ULL }, // M332193019 has a factor: 245547253556010982337
    {  332197979, 67,         431926706817ULL }, // M332197979 has a factor: 286970358161465845687
    {  332196673, 68,         493107936632ULL }, // M332196673 has a factor: 327617631958090450673
    {  332193149, 68,         568114683852ULL }, // M332193149 has a factor: 377447611643870659897
    {  332199163, 68,         594630384225ULL }, // M332199163 has a factor: 395071431867826807351
    {  332193721, 68,         806411594595ULL }, // M332193721 has a factor: 535769736532113075991
    {  332195893, 68,         834838090263ULL }, // M332195893 has a factor: 554659569810663779719
    {  332195359, 69,        1080379460985ULL }, // M332195359 has a factor: 717794085796277137231
    {  332193529, 69,        1508698848680ULL }, // M332193529 has a factor: 1002359989482492383441
    {  332194279, 69,        1527449764500ULL }, // M332194279 has a factor: 1014820146453594591001
    {  332194901, 69,        1578160474915ULL }, // M332194901 has a factor: 1048513725453002816831
    {  332194417, 69,        1755489119552ULL }, // M332194417 has a factor: 1166327369238839882369
    {  332193149, 70,        1850786672832ULL }, // M332193149 has a factor: 1229637305950589655937
    {  332197631, 70,        2508416914828ULL }, // M332197631 has a factor: 1666580313332380744937
    {  332194033, 70,        2603852997095ULL }, // M332194033 has a factor: 1729968856888250668271
    {  332197219, 71,        5417520283061ULL }, // M332197219 has a factor: 3599370343817914014719
    {  332196937, 72,        8345291320155ULL }, // M332196937 has a factor: 5544560429856354730471
    {  332194351, 72,       10810045498316ULL }, // M332194351 has a factor: 7182072097187110425833
    {  332199223, 72,       12316666745133ULL }, // M332199223 has a factor: 8183174245366243263319
    {  332196173, 73,       15086682666063ULL }, // M332196173 has a factor: 10023476489863131153799
    {  332195561, 84,    50419803040370676ULL }, // M332195561 has a factor: 33498469513010884723538473

    /* some (all) known factors from the primenet server (2010-02-14) http://www.mersenne.org/
for exponents from 800000000 to 800010000 */
    {  800000171, 30,                    1ULL }, // M800000171 has a factor: 1600000343
    {  800000711, 30,                    1ULL }, // M800000711 has a factor: 1600001423
    {  800000759, 30,                    1ULL }, // M800000759 has a factor: 1600001519
    {  800002319, 30,                    1ULL }, // M800002319 has a factor: 1600004639
    {  800002331, 30,                    1ULL }, // M800002331 has a factor: 1600004663
    {  800002811, 30,                    1ULL }, // M800002811 has a factor: 1600005623
    {  800002919, 30,                    1ULL }, // M800002919 has a factor: 1600005839
    {  800003339, 30,                    1ULL }, // M800003339 has a factor: 1600006679
    {  800004311, 30,                    1ULL }, // M800004311 has a factor: 1600008623
    {  800004743, 30,                    1ULL }, // M800004743 has a factor: 1600009487
    {  800005931, 30,                    1ULL }, // M800005931 has a factor: 1600011863
    {  800006639, 30,                    1ULL }, // M800006639 has a factor: 1600013279
    {  800007251, 30,                    1ULL }, // M800007251 has a factor: 1600014503
    {  800007563, 30,                    1ULL }, // M800007563 has a factor: 1600015127
    {  800008463, 30,                    1ULL }, // M800008463 has a factor: 1600016927
    {  800008823, 30,                    1ULL }, // M800008823 has a factor: 1600017647
    {  800009351, 30,                    1ULL }, // M800009351 has a factor: 1600018703
    {  800009531, 30,                    1ULL }, // M800009531 has a factor: 1600019063
    {  800000557, 32,                    3ULL }, // M800000557 has a factor: 4800003343
    {  800003957, 32,                    3ULL }, // M800003957 has a factor: 4800023743
    {  800004113, 32,                    3ULL }, // M800004113 has a factor: 4800024679
    {  800004553, 32,                    3ULL }, // M800004553 has a factor: 4800027319
    {  800004593, 32,                    3ULL }, // M800004593 has a factor: 4800027559
    {  800005901, 32,                    3ULL }, // M800005901 has a factor: 4800035407
    {  800007577, 32,                    3ULL }, // M800007577 has a factor: 4800045463
    {  800007773, 32,                    3ULL }, // M800007773 has a factor: 4800046639
    {  800008481, 32,                    3ULL }, // M800008481 has a factor: 4800050887
    {  800000321, 32,                    4ULL }, // M800000321 has a factor: 6400002569
    {  800000759, 32,                    4ULL }, // M800000759 has a factor: 6400006073
    {  800001989, 32,                    4ULL }, // M800001989 has a factor: 6400015913
    {  800003999, 32,                    4ULL }, // M800003999 has a factor: 6400031993
    {  800004287, 32,                    4ULL }, // M800004287 has a factor: 6400034297
    {  800005967, 32,                    4ULL }, // M800005967 has a factor: 6400047737
    {  800007191, 32,                    4ULL }, // M800007191 has a factor: 6400057529
    {  800008067, 32,                    4ULL }, // M800008067 has a factor: 6400064537
    {  800008757, 32,                    4ULL }, // M800008757 has a factor: 6400070057
    {  800009429, 32,                    4ULL }, // M800009429 has a factor: 6400075433
    {  800009831, 32,                    4ULL }, // M800009831 has a factor: 6400078649
    {  800009849, 32,                    4ULL }, // M800009849 has a factor: 6400078793
    {  800002267, 32,                    5ULL }, // M800002267 has a factor: 8000022671
    {  800002531, 32,                    5ULL }, // M800002531 has a factor: 8000025311
    {  800004847, 32,                    5ULL }, // M800004847 has a factor: 8000048471
    {  800000521, 33,                    8ULL }, // M800000521 has a factor: 12800008337
    {  800001211, 33,                    8ULL }, // M800001211 has a factor: 12800019377
    {  800003401, 33,                    8ULL }, // M800003401 has a factor: 12800054417
    {  800005627, 33,                    8ULL }, // M800005627 has a factor: 12800090033
    {  800007997, 33,                    8ULL }, // M800007997 has a factor: 12800127953
    {  800009473, 33,                    8ULL }, // M800009473 has a factor: 12800151569
    {  800000659, 33,                    9ULL }, // M800000659 has a factor: 14400011863
    {  800002139, 33,                    9ULL }, // M800002139 has a factor: 14400038503
    {  800002699, 33,                    9ULL }, // M800002699 has a factor: 14400048583
    {  800004871, 33,                    9ULL }, // M800004871 has a factor: 14400087679
    {  800007067, 33,                    9ULL }, // M800007067 has a factor: 14400127207
    {  800008051, 33,                    9ULL }, // M800008051 has a factor: 14400144919
    {  800007409, 34,                   11ULL }, // M800007409 has a factor: 17600162999
    {  800003723, 34,                   12ULL }, // M800003723 has a factor: 19200089353
    {  800007617, 34,                   12ULL }, // M800007617 has a factor: 19200182809
    {  800004347, 34,                   13ULL }, // M800004347 has a factor: 20800113023
    {  800002249, 34,                   15ULL }, // M800002249 has a factor: 24000067471
    {  800002649, 34,                   15ULL }, // M800002649 has a factor: 24000079471
    {  800006869, 34,                   15ULL }, // M800006869 has a factor: 24000206071
    {  800007937, 34,                   15ULL }, // M800007937 has a factor: 24000238111
    {  800002649, 34,                   19ULL }, // M800002649 has a factor: 30400100663
    {  800007869, 34,                   19ULL }, // M800007869 has a factor: 30400299023
    {  800000041, 34,                   20ULL }, // M800000041 has a factor: 32000001641
    {  800001211, 34,                   20ULL }, // M800001211 has a factor: 32000048441
    {  800003107, 34,                   20ULL }, // M800003107 has a factor: 32000124281
    {  800004973, 34,                   20ULL }, // M800004973 has a factor: 32000198921
    {  800002639, 34,                   21ULL }, // M800002639 has a factor: 33600110839
    {  800005403, 34,                   21ULL }, // M800005403 has a factor: 33600226927
    {  800009099, 34,                   21ULL }, // M800009099 has a factor: 33600382159
    {  800002909, 35,                   24ULL }, // M800002909 has a factor: 38400139633
    {  800005439, 35,                   24ULL }, // M800005439 has a factor: 38400261073
    {  800000573, 35,                   27ULL }, // M800000573 has a factor: 43200030943
    {  800006573, 35,                   28ULL }, // M800006573 has a factor: 44800368089
    {  800006741, 35,                   28ULL }, // M800006741 has a factor: 44800377497
    {  800002453, 35,                   32ULL }, // M800002453 has a factor: 51200156993
    {  800004097, 35,                   32ULL }, // M800004097 has a factor: 51200262209
    {  800009557, 35,                   35ULL }, // M800009557 has a factor: 56000668991
    {  800001463, 35,                   36ULL }, // M800001463 has a factor: 57600105337
    {  800002781, 35,                   39ULL }, // M800002781 has a factor: 62400216919
    {  800001269, 35,                   40ULL }, // M800001269 has a factor: 64000101521
    {  800003903, 35,                   40ULL }, // M800003903 has a factor: 64000312241
    {  800006261, 35,                   40ULL }, // M800006261 has a factor: 64000500881
    {  800004769, 36,                   44ULL }, // M800004769 has a factor: 70400419673
    {  800007067, 36,                   45ULL }, // M800007067 has a factor: 72000636031
    {  800006741, 36,                   51ULL }, // M800006741 has a factor: 81600687583
    {  800005139, 36,                   52ULL }, // M800005139 has a factor: 83200534457
    {  800004511, 36,                   56ULL }, // M800004511 has a factor: 89600505233
    {  800006663, 36,                   61ULL }, // M800006663 has a factor: 97600812887
    {  800000473, 36,                   80ULL }, // M800000473 has a factor: 128000075681
    {  800003129, 36,                   84ULL }, // M800003129 has a factor: 134400525673
    {  800007937, 37,                   92ULL }, // M800007937 has a factor: 147201460409
    {  800009351, 37,                   93ULL }, // M800009351 has a factor: 148801739287
    {  800007881, 37,                   99ULL }, // M800007881 has a factor: 158401560439
    {  800006393, 37,                  115ULL }, // M800006393 has a factor: 184001470391
    {  800007433, 37,                  132ULL }, // M800007433 has a factor: 211201962313
    {  800006351, 37,                  133ULL }, // M800006351 has a factor: 212801689367
    {  800008141, 37,                  140ULL }, // M800008141 has a factor: 224002279481
    {  800000933, 37,                  156ULL }, // M800000933 has a factor: 249600291097
    {  800006981, 37,                  163ULL }, // M800006981 has a factor: 260802275807
    {  800002403, 37,                  168ULL }, // M800002403 has a factor: 268800807409
    {  800000609, 37,                  171ULL }, // M800000609 has a factor: 273600208279
    {  800002157, 38,                  180ULL }, // M800002157 has a factor: 288000776521
    {  800009473, 38,                  183ULL }, // M800009473 has a factor: 292803467119
    {  800002639, 38,                  197ULL }, // M800002639 has a factor: 315201039767
    {  800006029, 38,                  200ULL }, // M800006029 has a factor: 320002411601
    {  800006947, 38,                  248ULL }, // M800006947 has a factor: 396803445713
    {  800007841, 38,                  248ULL }, // M800007841 has a factor: 396803889137
    {  800000359, 38,                  261ULL }, // M800000359 has a factor: 417600187399
    {  800001211, 38,                  276ULL }, // M800001211 has a factor: 441600668473
    {  800007983, 38,                  280ULL }, // M800007983 has a factor: 448004470481
    {  800007721, 38,                  291ULL }, // M800007721 has a factor: 465604493623
    {  800000209, 38,                  296ULL }, // M800000209 has a factor: 473600123729
    {  800000741, 38,                  303ULL }, // M800000741 has a factor: 484800449047
    {  800000063, 38,                  336ULL }, // M800000063 has a factor: 537600042337
    {  800007589, 38,                  339ULL }, // M800007589 has a factor: 542405145343
    {  800006453, 38,                  340ULL }, // M800006453 has a factor: 544004388041
    {  800002603, 39,                  348ULL }, // M800002603 has a factor: 556801811689
    {  800009563, 39,                  356ULL }, // M800009563 has a factor: 569606808857
    {  800002003, 39,                  360ULL }, // M800002003 has a factor: 576001442161
    {  800009503, 39,                  365ULL }, // M800009503 has a factor: 584006937191
    {  800009101, 39,                  375ULL }, // M800009101 has a factor: 600006825751
    {  800004731, 39,                  396ULL }, // M800004731 has a factor: 633603746953
    {  800005483, 39,                  432ULL }, // M800005483 has a factor: 691204737313
    {  800006503, 39,                  456ULL }, // M800006503 has a factor: 729605930737
    {  800001649, 39,                  471ULL }, // M800001649 has a factor: 753601553359
    {  800009333, 39,                  480ULL }, // M800009333 has a factor: 768008959681
    {  800008969, 39,                  492ULL }, // M800008969 has a factor: 787208825497
    {  800005901, 39,                  519ULL }, // M800005901 has a factor: 830406125239
    {  800000953, 39,                  563ULL }, // M800000953 has a factor: 900801073079
    {  800000561, 39,                  600ULL }, // M800000561 has a factor: 960000673201
    {  800002297, 39,                  620ULL }, // M800002297 has a factor: 992002848281
    {  800002457, 40,                  699ULL }, // M800002457 has a factor: 1118403434887
    {  800009333, 40,                  711ULL }, // M800009333 has a factor: 1137613271527
    {  800004757, 40,                  764ULL }, // M800004757 has a factor: 1222407268697
    {  800002669, 40,                  771ULL }, // M800002669 has a factor: 1233604115599
    {  800009369, 40,                  787ULL }, // M800009369 has a factor: 1259214746807
    {  800004167, 40,                  829ULL }, // M800004167 has a factor: 1326406908887
    {  800007707, 40,                  988ULL }, // M800007707 has a factor: 1580815229033
    {  800008463, 40,                  988ULL }, // M800008463 has a factor: 1580816722889
    {  800009933, 40,                 1087ULL }, // M800009933 has a factor: 1739221594343
    {  800008513, 40,                 1092ULL }, // M800008513 has a factor: 1747218592393
    {  800005139, 40,                 1137ULL }, // M800005139 has a factor: 1819211686087
    {  800007997, 40,                 1163ULL }, // M800007997 has a factor: 1860818601023
    {  800003627, 40,                 1165ULL }, // M800003627 has a factor: 1864008450911
    {  800001547, 40,                 1253ULL }, // M800001547 has a factor: 2004803876783
    {  800006869, 41,                 1380ULL }, // M800006869 has a factor: 2208018958441
    {  800000561, 41,                 1384ULL }, // M800000561 has a factor: 2214401552849
    {  800006981, 41,                 1528ULL }, // M800006981 has a factor: 2444821333937
    {  800006173, 41,                 1580ULL }, // M800006173 has a factor: 2528019506681
    {  800008691, 41,                 1636ULL }, // M800008691 has a factor: 2617628436953
    {  800002603, 41,                 1881ULL }, // M800002603 has a factor: 3009609792487
    {  800002781, 41,                 1936ULL }, // M800002781 has a factor: 3097610768033
    {  800002667, 41,                 1984ULL }, // M800002667 has a factor: 3174410582657
    {  800005853, 41,                 2056ULL }, // M800005853 has a factor: 3289624067537
    {  800004679, 41,                 2364ULL }, // M800004679 has a factor: 3782422122313
    {  800002741, 41,                 2576ULL }, // M800002741 has a factor: 4121614121633
    {  800004769, 41,                 2604ULL }, // M800004769 has a factor: 4166424836953
    {  800001247, 41,                 2685ULL }, // M800001247 has a factor: 4296006696391
    {  800001677, 42,                 3135ULL }, // M800001677 has a factor: 5016010514791
    {  800008633, 42,                 3855ULL }, // M800008633 has a factor: 6168066560431
    {  800007401, 42,                 3879ULL }, // M800007401 has a factor: 6206457416959
    {  800001271, 42,                 4308ULL }, // M800001271 has a factor: 6892810950937
    {  800004167, 42,                 4317ULL }, // M800004167 has a factor: 6907235977879
    {  800002909, 42,                 4460ULL }, // M800002909 has a factor: 7136025948281
    {  800005741, 42,                 4676ULL }, // M800005741 has a factor: 7481653689833
    {  800001767, 42,                 5205ULL }, // M800001767 has a factor: 8328018394471
    {  800008393, 43,                 6471ULL }, // M800008393 has a factor: 10353708622207
    {  800007869, 43,                 6684ULL }, // M800007869 has a factor: 10694505192793
    {  800000749, 43,                 7052ULL }, // M800000749 has a factor: 11283210563897
    {  800006827, 43,                 7764ULL }, // M800006827 has a factor: 12422506009657
    {  800003389, 43,                 7856ULL }, // M800003389 has a factor: 12569653247969
    {  800004109, 43,                 8879ULL }, // M800004109 has a factor: 14206472967623
    {  800007653, 43,                 9495ULL }, // M800007653 has a factor: 15192145330471
    {  800005511, 43,                 9501ULL }, // M800005511 has a factor: 15201704720023
    {  800001121, 43,                 9515ULL }, // M800001121 has a factor: 15224021332631
    {  800000711, 43,                 9676ULL }, // M800000711 has a factor: 15481613759273
    {  800000449, 43,                10356ULL }, // M800000449 has a factor: 16569609299689
    {  800009129, 43,                10591ULL }, // M800009129 has a factor: 16945793370479
    {  800006947, 44,                13052ULL }, // M800006947 has a factor: 20883381344489
    {  800005859, 44,                14505ULL }, // M800005859 has a factor: 23208169969591
    {  800002967, 44,                15453ULL }, // M800002967 has a factor: 24724891698103
    {  800006351, 44,                16521ULL }, // M800006351 has a factor: 26433809849743
    {  800000287, 44,                17165ULL }, // M800000287 has a factor: 27464009852711
    {  800004743, 44,                18117ULL }, // M800004743 has a factor: 28987371857863
    {  800000209, 44,                18435ULL }, // M800000209 has a factor: 29496007705831
    {  800002781, 44,                20224ULL }, // M800002781 has a factor: 32358512485889
    {  800002667, 44,                21505ULL }, // M800002667 has a factor: 34408114707671
    {  800002387, 44,                21657ULL }, // M800002387 has a factor: 34651303390519
    {  800007433, 45,                22311ULL }, // M800007433 has a factor: 35697931675327
    {  800003903, 45,                22497ULL }, // M800003903 has a factor: 35995375611583
    {  800006387, 45,                24384ULL }, // M800006387 has a factor: 39014711481217
    {  800000359, 45,                25385ULL }, // M800000359 has a factor: 40616018226431
    {  800002039, 45,                27137ULL }, // M800002039 has a factor: 43419310664687
    {  800008213, 45,                28431ULL }, // M800008213 has a factor: 45490067007607
    {  800005879, 45,                28460ULL }, // M800005879 has a factor: 45536334632681
    {  800001071, 45,                28560ULL }, // M800001071 has a factor: 45696061175521
    {  800007757, 45,                28692ULL }, // M800007757 has a factor: 45907645127689
    {  800007779, 45,                29289ULL }, // M800007779 has a factor: 46862855678263
    {  800007751, 45,                29340ULL }, // M800007751 has a factor: 46944454828681
    {  800005541, 45,                29520ULL }, // M800005541 has a factor: 47232327140641
    {  800006293, 45,                29576ULL }, // M800006293 has a factor: 47321972243537
    {  800006323, 45,                30317ULL }, // M800006323 has a factor: 48507583388783
    {  800004131, 45,                35724ULL }, // M800004131 has a factor: 57158695151689
    {  800006059, 45,                40449ULL }, // M800006059 has a factor: 64718890160983
    {  800008481, 45,                40780ULL }, // M800008481 has a factor: 65248691710361
    {  800009303, 45,                40873ULL }, // M800009303 has a factor: 65397560483039
    {  800000857, 45,                42504ULL }, // M800000857 has a factor: 68006472851857
    {  800008751, 46,                45525ULL }, // M800008751 has a factor: 72840796778551
    {  800007449, 46,                47116ULL }, // M800007449 has a factor: 75386301934169
    {  800002267, 46,                56337ULL }, // M800002267 has a factor: 90139455431959
    {  800002387, 46,                62649ULL }, // M800002387 has a factor: 100238699086327
    {  800003929, 46,                64755ULL }, // M800003929 has a factor: 103608508844791
    {  800005627, 46,                74360ULL }, // M800005627 has a factor: 118976836847441
    {  800009593, 46,                77276ULL }, // M800009593 has a factor: 123643082617337
    {  800008691, 46,                79045ULL }, // M800008691 has a factor: 126473373960191
    {  800008733, 46,                81915ULL }, // M800008733 has a factor: 131065430727391
    {  800006113, 46,                86583ULL }, // M800006113 has a factor: 138533858563759
    {  800004503, 47,                98581ULL }, // M800004503 has a factor: 157730487820487
    {  800001949, 47,                99275ULL }, // M800001949 has a factor: 158840386973951
    {  800005891, 47,               102461ULL }, // M800005891 has a factor: 163938807195503
    {  800003317, 47,               104724ULL }, // M800003317 has a factor: 167559094739017
    {  800002501, 47,               113883ULL }, // M800002501 has a factor: 182213369642767
    {  800004349, 47,               114551ULL }, // M800004349 has a factor: 183282596364599
    {  800003753, 47,               130192ULL }, // M800003753 has a factor: 208308177221153
    {  800005439, 47,               138420ULL }, // M800005439 has a factor: 221473505732761
    {  800002453, 47,               143963ULL }, // M800002453 has a factor: 230341506282479
    {  800007583, 47,               154560ULL }, // M800007583 has a factor: 247298344056961
    {  800002249, 47,               160860ULL }, // M800002249 has a factor: 257376723548281
    {  800009333, 47,               161203ULL }, // M800009333 has a factor: 257927809015199
    {  800009593, 47,               167160ULL }, // M800009593 has a factor: 267459207131761
    {  800007557, 47,               174480ULL }, // M800007557 has a factor: 279170637090721
    {  800001151, 48,               177825ULL }, // M800001151 has a factor: 284520409353151
    {  800002241, 48,               188863ULL }, // M800002241 has a factor: 302181646483967
    {  800004319, 48,               190140ULL }, // M800004319 has a factor: 304225642429321
    {  800006833, 48,               213552ULL }, // M800006833 has a factor: 341686118401633
    {  800009741, 48,               217075ULL }, // M800009741 has a factor: 347324229055151
    {  800008067, 48,               220077ULL }, // M800008067 has a factor: 352126750722319
    {  800006551, 48,               249660ULL }, // M800006551 has a factor: 399459271045321
    {  800002097, 48,               273195ULL }, // M800002097 has a factor: 437113145779831
    {  800003693, 49,               385923ULL }, // M800003693 has a factor: 617479650427279
    {  800003563, 49,               393672ULL }, // M800003563 has a factor: 629878005306673
    {  800009857, 49,               399867ULL }, // M800009857 has a factor: 639795082978039
    {  800006173, 49,               400715ULL }, // M800006173 has a factor: 641148947227391
    {  800005121, 49,               446376ULL }, // M800005121 has a factor: 714206171782993
    {  800005541, 49,               477988ULL }, // M800005541 has a factor: 764786097063017
    {  800004827, 49,               518965ULL }, // M800004827 has a factor: 830349010088111
    {  800006257, 49,               529547ULL }, // M800006257 has a factor: 847281826751159
    {  800009131, 49,               540368ULL }, // M800009131 has a factor: 864598668200417
    {  800008943, 49,               572985ULL }, // M800008943 has a factor: 916786248409711
    {  800009887, 49,               597665ULL }, // M800009887 has a factor: 956275818227711
    {  800009213, 49,               656595ULL }, // M800009213 has a factor: 1050564098419471
    {  800007499, 50,               807536ULL }, // M800007499 has a factor: 1292069711424929
    {  800000527, 50,               919968ULL }, // M800000527 has a factor: 1471949769646273
    {  800004287, 50,               926409ULL }, // M800004287 has a factor: 1482262343030767
    {  800006113, 50,               947171ULL }, // M800006113 has a factor: 1515485180112647
    {  800007463, 50,               950201ULL }, // M800007463 has a factor: 1520335782700127
    {  800006941, 50,              1035624ULL }, // M800006941 has a factor: 1657012776532369
    {  800007409, 50,              1086912ULL }, // M800007409 has a factor: 1739075305862017
    {  800004217, 50,              1206707ULL }, // M800004217 has a factor: 1930741377366839
    {  800008213, 50,              1307336ULL }, // M800008213 has a factor: 2091759074301137
    {  800003539, 50,              1337105ULL }, // M800003539 has a factor: 2139377464029191
    {  800007193, 51,              1408083ULL }, // M800007193 has a factor: 2252953056682039
    {  800008367, 51,              1647613ULL }, // M800008367 has a factor: 2636208371155943
    {  800002919, 51,              1715385ULL }, // M800002919 has a factor: 2744626014417631
    {  800002451, 51,              1806256ULL }, // M800002451 has a factor: 2890018454266913
    {  800003713, 51,              1869348ULL }, // M800003713 has a factor: 2990970681778249
    {  800004973, 51,              2352236ULL }, // M800004973 has a factor: 3763600995339257
    {  800005663, 51,              2409633ULL }, // M800005663 has a factor: 3855440091503359
    {  800004761, 51,              2735019ULL }, // M800004761 has a factor: 4376056442850919
    {  800001131, 52,              2951641ULL }, // M800001131 has a factor: 4722632276611943
    {  800002741, 52,              3733656ULL }, // M800002741 has a factor: 5973870067902193
    {  800009339, 52,              3765996ULL }, // M800009339 has a factor: 6025663941273289
    {  800001179, 52,              4101864ULL }, // M800001179 has a factor: 6562992072195313
    {  800008189, 52,              4312799ULL }, // M800008189 has a factor: 6900549035022023
    {  800009531, 52,              4620048ULL }, // M800009531 has a factor: 7392164867354977
    {  800009779, 52,              4783124ULL }, // M800009779 has a factor: 7653091948339193
    {  800009491, 52,              4997784ULL }, // M800009491 has a factor: 7996549267935889
    {  800008367, 52,              5009868ULL }, // M800008367 has a factor: 8015872635131113
    {  800000557, 52,              5163332ULL }, // M800000557 has a factor: 8261336951951849
    {  800005769, 52,              5182335ULL }, // M800005769 has a factor: 8291795793781231
    {  800000429, 52,              5246847ULL }, // M800000429 has a factor: 8394959701794727
    {  800006189, 53,              5741076ULL }, // M800006189 has a factor: 9185792663038729
    {  800002199, 53,              5779212ULL }, // M800002199 has a factor: 9246764616974377
    {  800007499, 53,              6213420ULL }, // M800007499 has a factor: 9941565188873161
    {  800003317, 53,              6270195ULL }, // M800003317 has a factor: 10032353596473631
    {  800006413, 53,              6298511ULL }, // M800006413 has a factor: 10077698384702087
    {  800006509, 53,              7464464ULL }, // M800006509 has a factor: 11943239572392353
    {  800009027, 53,              7933284ULL }, // M800009027 has a factor: 12693397627509337
    {  800008603, 53,              8367873ULL }, // M800008603 has a factor: 13388740777622839
    {  800005597, 53,              8823359ULL }, // M800005597 has a factor: 14117473168680647
    {  800002279, 53,              9238685ULL }, // M800002279 has a factor: 14781938109926231
    {  800007973, 53,             10141803ULL }, // M800007973 has a factor: 16227046521190639
    {  800000657, 53,             10934988ULL }, // M800000657 has a factor: 17495995168574233
    {  800007379, 54,             12101981ULL }, // M800007379 has a factor: 19363348201035599
    {  800004599, 54,             14239936ULL }, // M800004599 has a factor: 22784028578931329
    {  800000809, 54,             15228215ULL }, // M800000809 has a factor: 24365168639251871
    {  800009569, 54,             16423572ULL }, // M800009569 has a factor: 26278029514320937
    {  800008939, 54,             18387485ULL }, // M800008939 has a factor: 29420304731456831
    {  800007181, 55,             25074908ULL }, // M800007181 has a factor: 40120212925828697
    {  800009359, 55,             31664265ULL }, // M800009359 has a factor: 50663416691712271
    {  800007023, 55,             35006401ULL }, // M800007023 has a factor: 56010733299908447
    {  800009417, 55,             37005564ULL }, // M800009417 has a factor: 59209599362792377
    {  800009417, 55,             42601420ULL }, // M800009417 has a factor: 68163074355144281
    {  800005163, 56,             52916928ULL }, // M800005163 has a factor: 84667631220198529
    {  800001281, 56,             76731144ULL }, // M800001281 has a factor: 122770026985190929
    {  800003311, 56,             78822249ULL }, // M800003311 has a factor: 126116120360932879
    {  800008177, 57,            115262312ULL }, // M800008177 has a factor: 184421584199850449
    {  800005447, 57,            148096644ULL }, // M800005447 has a factor: 236956243764839737
    {  800009293, 58,            195263607ULL }, // M800009293 has a factor: 312425400369399703
    {  800003843, 58,            233053653ULL }, // M800003843 has a factor: 372887636050376959
    {  800009107, 58,            236086613ULL }, // M800009107 has a factor: 377742880881569183
    {  800007517, 58,            248028783ULL }, // M800007517 has a factor: 396849781664723623
    {  800003101, 58,            291024176ULL }, // M800003101 has a factor: 465640486531939553
    {  800009297, 58,            339261055ULL }, // M800009297 has a factor: 542823996220056671
    {  800001967, 59,            501349929ULL }, // M800001967 has a factor: 802161858710620687
    {  800004577, 59,            569501048ULL }, // M800004577 has a factor: 911206890012593393
    {  800003431, 59,            581642729ULL }, // M800003431 has a factor: 930632357632406399
    {  800004433, 59,            604273820ULL }, // M800004433 has a factor: 966843469491688121
    {  800007823, 60,            803048981ULL }, // M800007823 has a factor: 1284890934104356727
    {  800004749, 60,           1063703659ULL }, // M800004749 has a factor: 1701935957457353183
    {  800003387, 60,           1170513328ULL }, // M800003387 has a factor: 1872829253857283873
    {  800005699, 60,           1346019692ULL }, // M800005699 has a factor: 2153646849132449417
    {  800008973, 61,           1757044083ULL }, // M800008973 has a factor: 2811302064713113519
    {  800003137, 61,           1776234659ULL }, // M800003137 has a factor: 2841986598496250567
    {  800007349, 61,           1861755344ULL }, // M800007349 has a factor: 2978835914480046113
    {  800005783, 61,           2181749568ULL }, // M800005783 has a factor: 3490824542915503489
    {  800000963, 62,           2910763116ULL }, // M800000963 has a factor: 4657226591729761417
    {  800002757, 62,           2942318043ULL }, // M800002757 has a factor: 4707725092741689103
    {  800008613, 62,           3268743663ULL }, // M800008613 has a factor: 5230046168178338839
    {  800007443, 62,           3494835405ULL }, // M800007443 has a factor: 5591788672119838831
    {  800002799, 62,           3911585109ULL }, // M800002799 has a factor: 6258558071453440183
    {  800009599, 62,           4204663845ULL }, // M800009599 has a factor: 6727542873136496311
    {  800006183, 63,           6694759488ULL }, // M800006183 has a factor: 10711697968195828609
    {  800009843, 63,          10501731576ULL }, // M800009843 has a factor: 16802977258687805137
    {  800000233, 69,         700130179352ULL }, // M800000233 has a factor: 1120208613223863578033
    {  800000011, 70,         955047115584ULL }, // M800000011 has a factor: 1528075405945436542849
    {  800000479, 72,        3089082494924ULL }, // M800000479 has a factor: 4942534951219430137193

    /* some (all) known factors from ElevenSmooth "Operation Billion Digits"
2010-02-07 http://www.moregimps.it/billion/expo_f.php */
    { 3321929603, 32,                    1ULL }, // M3321929603 has a factor: 6643859207
    { 3321929843, 32,                    1ULL }, // M3321929843 has a factor: 6643859687
    { 3321930431, 32,                    1ULL }, // M3321930431 has a factor: 6643860863
    { 3321931199, 32,                    1ULL }, // M3321931199 has a factor: 6643862399
    { 3321931559, 32,                    1ULL }, // M3321931559 has a factor: 6643863119
    { 3321931859, 32,                    1ULL }, // M3321931859 has a factor: 6643863719
    { 3321932891, 32,                    1ULL }, // M3321932891 has a factor: 6643865783
    { 3321933071, 32,                    1ULL }, // M3321933071 has a factor: 6643866143
    { 3321933971, 32,                    1ULL }, // M3321933971 has a factor: 6643867943
    { 3321928661, 34,                    3ULL }, // M3321928661 has a factor: 19931571967
    { 3321930301, 34,                    3ULL }, // M3321930301 has a factor: 19931581807
    { 3321930793, 34,                    3ULL }, // M3321930793 has a factor: 19931584759
    { 3321931213, 34,                    3ULL }, // M3321931213 has a factor: 19931587279
    { 3321931337, 34,                    3ULL }, // M3321931337 has a factor: 19931588023
    { 3321932701, 34,                    3ULL }, // M3321932701 has a factor: 19931596207
    { 3321929357, 34,                    4ULL }, // M3321929357 has a factor: 26575434857
    { 3321929969, 34,                    4ULL }, // M3321929969 has a factor: 26575439753
    { 3321932897, 34,                    4ULL }, // M3321932897 has a factor: 26575463177
    { 3321932851, 34,                    5ULL }, // M3321932851 has a factor: 33219328511
    { 3321931133, 35,                    7ULL }, // M3321931133 has a factor: 46507035863
    { 3321931973, 35,                    7ULL }, // M3321931973 has a factor: 46507047623
    { 3321929683, 35,                    8ULL }, // M3321929683 has a factor: 53150874929
    { 3321931927, 35,                    8ULL }, // M3321931927 has a factor: 53150910833
    { 3321933211, 35,                    8ULL }, // M3321933211 has a factor: 53150931377
    { 3321928607, 35,                    9ULL }, // M3321928607 has a factor: 59794714927
    { 3321930587, 35,                    9ULL }, // M3321930587 has a factor: 59794750567
    { 3321931957, 36,                   12ULL }, // M3321931957 has a factor: 79726366969
    { 3321932473, 36,                   12ULL }, // M3321932473 has a factor: 79726379353
    { 3321933053, 36,                   12ULL }, // M3321933053 has a factor: 79726393273
    { 3321933709, 36,                   12ULL }, // M3321933709 has a factor: 79726409017
    { 3321930757, 36,                   15ULL }, // M3321930757 has a factor: 99657922711
    { 3321931313, 36,                   15ULL }, // M3321931313 has a factor: 99657939391
    { 3321932479, 36,                   20ULL }, // M3321932479 has a factor: 132877299161
    { 3321933721, 36,                   20ULL }, // M3321933721 has a factor: 132877348841
    { 3321930583, 37,                   33ULL }, // M3321930583 has a factor: 219247418479
    { 3321933917, 38,                   43ULL }, // M3321933917 has a factor: 285686316863
    { 3321930769, 38,                   44ULL }, // M3321930769 has a factor: 292329907673
    { 3321928189, 38,                   47ULL }, // M3321928189 has a factor: 312261249767
    { 3321930431, 38,                   48ULL }, // M3321930431 has a factor: 318905321377
    { 3321928679, 38,                   49ULL }, // M3321928679 has a factor: 325549010543
    { 3321932353, 38,                   56ULL }, // M3321932353 has a factor: 372056423537
    { 3321928501, 38,                   59ULL }, // M3321928501 has a factor: 391987563119
    { 3321930839, 38,                   61ULL }, // M3321930839 has a factor: 405275562359
    { 3321933697, 38,                   63ULL }, // M3321933697 has a factor: 418563645823
    { 3321929777, 38,                   64ULL }, // M3321929777 has a factor: 425207011457
    { 3321929749, 38,                   71ULL }, // M3321929749 has a factor: 471714024359
    { 3321930529, 38,                   71ULL }, // M3321930529 has a factor: 471714135119
    { 3321932189, 39,                   84ULL }, // M3321932189 has a factor: 558084607753
    { 3321933397, 39,                   84ULL }, // M3321933397 has a factor: 558084810697
    { 3321929879, 39,                   85ULL }, // M3321929879 has a factor: 564728079431
    { 3321930769, 39,                   96ULL }, // M3321930769 has a factor: 637810707649
    { 3321928121, 39,                  103ULL }, // M3321928121 has a factor: 684317192927
    { 3321931051, 39,                  113ULL }, // M3321931051 has a factor: 750756417527
    { 3321929867, 39,                  117ULL }, // M3321929867 has a factor: 777331588879
    { 3321928619, 39,                  120ULL }, // M3321928619 has a factor: 797262868561
    { 3321932377, 39,                  123ULL }, // M3321932377 has a factor: 817195364743
    { 3321931517, 39,                  135ULL }, // M3321931517 has a factor: 896921509591
    { 3321929129, 39,                  160ULL }, // M3321929129 has a factor: 1063017321281
    { 3321931973, 39,                  160ULL }, // M3321931973 has a factor: 1063018231361
    { 3321931313, 40,                  172ULL }, // M3321931313 has a factor: 1142744371673
    { 3321932063, 40,                  177ULL }, // M3321932063 has a factor: 1175963950303
    { 3321928949, 40,                  207ULL }, // M3321928949 has a factor: 1375278584887
    { 3321929509, 40,                  219ULL }, // M3321929509 has a factor: 1455005124943
    { 3321930841, 40,                  255ULL }, // M3321930841 has a factor: 1694184728911
    { 3321930827, 40,                  265ULL }, // M3321930827 has a factor: 1760623338311
    { 3321933781, 40,                  288ULL }, // M3321933781 has a factor: 1913433857857
    { 3321930793, 41,                  380ULL }, // M3321930793 has a factor: 2524667402681
    { 3321928703, 41,                  388ULL }, // M3321928703 has a factor: 2577816673529
    { 3321929843, 41,                  481ULL }, // M3321929843 has a factor: 3195696508967
    { 3321933691, 41,                  489ULL }, // M3321933691 has a factor: 3248851149799
    { 3321933023, 41,                  565ULL }, // M3321933023 has a factor: 3753784315991
    { 3321932423, 41,                  616ULL }, // M3321932423 has a factor: 4092620745137
    { 3321933271, 42,                  785ULL }, // M3321933271 has a factor: 5215435235471
    { 3321928097, 42,                  927ULL }, // M3321928097 has a factor: 6158854691839
    { 3321932479, 42,                 1032ULL }, // M3321932479 has a factor: 6856468636657
    { 3321930587, 42,                 1104ULL }, // M3321930587 has a factor: 7334822736097
    { 3321933379, 42,                 1124ULL }, // M3321933379 has a factor: 7467706235993
    { 3321932897, 42,                 1288ULL }, // M3321932897 has a factor: 8557299142673
    { 3321933287, 42,                 1300ULL }, // M3321933287 has a factor: 8637026546201
    { 3321931849, 43,                 1404ULL }, // M3321931849 has a factor: 9327984631993
    { 3321930377, 43,                 1692ULL }, // M3321930377 has a factor: 11241412395769
    { 3321932407, 43,                 1692ULL }, // M3321932407 has a factor: 11241419265289
    { 3321931213, 43,                 1751ULL }, // M3321931213 has a factor: 11633403107927
    { 3321929599, 43,                 1764ULL }, // M3321929599 has a factor: 11719767625273
    { 3321928513, 43,                 2220ULL }, // M3321928513 has a factor: 14749362597721
    { 3321933397, 43,                 2424ULL }, // M3321933397 has a factor: 16104733108657
    { 3321931763, 44,                 3261ULL }, // M3321931763 has a factor: 21665638958287
    { 3321929867, 44,                 3865ULL }, // M3321929867 has a factor: 25678517871911
    { 3321931813, 44,                 5043ULL }, // M3321931813 has a factor: 33505004265919
    { 3321931541, 45,                 5715ULL }, // M3321931541 has a factor: 37969677513631
    { 3321928097, 45,                 6240ULL }, // M3321928097 has a factor: 41457662650561
    { 3321929029, 45,                 6347ULL }, // M3321929029 has a factor: 42168567094127
    { 3321928189, 45,                 6515ULL }, // M3321928189 has a factor: 43284724302671
    { 3321933607, 45,                 9857ULL }, // M3321933607 has a factor: 65488599128399
    { 3321931661, 46,                12183ULL }, // M3321931661 has a factor: 80942186851927
    { 3321931973, 46,                13327ULL }, // M3321931973 has a factor: 88542774808343
    { 3321930841, 46,                14208ULL }, // M3321930841 has a factor: 94395986777857
    { 3321931897, 46,                15468ULL }, // M3321931897 has a factor: 102767285165593
    { 3321931117, 46,                15612ULL }, // M3321931117 has a factor: 103723977197209
    { 3321929959, 46,                16029ULL }, // M3321929959 has a factor: 106494430625623
    { 3321932249, 46,                19504ULL }, // M3321932249 has a factor: 129581933168993
    { 3321932759, 47,                22629ULL }, // M3321932759 has a factor: 150344032806823
    { 3321929993, 47,                37000ULL }, // M3321929993 has a factor: 245822819482001
    { 3321928391, 47,                39148ULL }, // M3321928391 has a factor: 260093705301737
    { 3321929129, 48,                61192ULL }, // M3321929129 has a factor: 406550974523537
    { 3321928109, 48,                61512ULL }, // M3321928109 has a factor: 408676883681617
    { 3321930769, 48,                65775ULL }, // M3321930769 has a factor: 436999992661951
    { 3321928531, 48,                65861ULL }, // M3321928531 has a factor: 437571069960383
    { 3321930421, 48,                75051ULL }, // M3321930421 has a factor: 498628400052943
    { 3321928121, 48,                75703ULL }, // M3321928121 has a factor: 502959849088127
    { 3321928703, 48,                84108ULL }, // M3321928703 has a factor: 558801558703849
    { 3321928391, 49,                87000ULL }, // M3321928391 has a factor: 578015540034001
    { 3321928919, 49,               119989ULL }, // M3321928919 has a factor: 797189858123783
    { 3321932423, 49,               125037ULL }, // M3321932423 has a factor: 830728928749303
    { 3321931729, 49,               134304ULL }, // M3321931729 has a factor: 892297437863233
    { 3321928217, 50,               175579ULL }, // M3321928217 has a factor: 1166521668825287
    { 3321929257, 50,               191972ULL }, // M3321929257 has a factor: 1275434806649609
    { 3321932149, 50,               268707ULL }, // M3321932149 has a factor: 1785252843922687
    { 3321929957, 50,               289252ULL }, // M3321929957 has a factor: 1921749767844329
    { 3321930893, 50,               295567ULL }, // M3321930893 has a factor: 1963706296502663
    { 3321929531, 50,               312313ULL }, // M3321929531 has a factor: 2074963555230407
    { 3321933709, 51,               380004ULL }, // M3321933709 has a factor: 2524696194309673
    { 3321932063, 51,               412860ULL }, // M3321932063 has a factor: 2742985743060361
    { 3321929587, 51,               429489ULL }, // M3321929587 has a factor: 2853464432782087
    { 3321931579, 51,               475257ULL }, // M3321931579 has a factor: 3157542472881607
    { 3321930817, 51,               481875ULL }, // M3321930817 has a factor: 3201510824883751
    { 3321933221, 51,               553300ULL }, // M3321933221 has a factor: 3676051302358601
    { 3321932597, 51,               563439ULL }, // M3321932597 has a factor: 3743412761042167
    { 3321931703, 51,               621136ULL }, // M3321931703 has a factor: 4126742740549217
    { 3321930893, 51,               671763ULL }, // M3321930893 has a factor: 4463100524948719
    { 3321929531, 52,               690093ULL }, // M3321929531 has a factor: 4584880631672767
    { 3321931007, 52,               733309ULL }, // M3321931007 has a factor: 4872003809624327
    { 3321929339, 52,               768556ULL }, // M3321929339 has a factor: 5106177450128969
    { 3321930317, 52,               814875ULL }, // M3321930317 has a factor: 5413915934130751
    { 3321929393, 52,               891276ULL }, // M3321929393 has a factor: 5921511883350937
    { 3321928567, 52,               960060ULL }, // M3321928567 has a factor: 6378501480068041
    { 3321933341, 52,              1035460ULL }, // M3321933341 has a factor: 6879458194543721
    { 3321931183, 52,              1107561ULL }, // M3321931183 has a factor: 7358482845949327
    { 3321931973, 52,              1166400ULL }, // M3321931973 has a factor: 7749402906614401
    { 3321929551, 52,              1230345ULL }, // M3321929551 has a factor: 8174238826850191
    { 3321928849, 53,              1417172ULL }, // M3321928849 has a factor: 9415489101590057
    { 3321931729, 53,              1629944ULL }, // M3321931729 has a factor: 10829125380186353
    { 3321929861, 53,              1868391ULL }, // M3321929861 has a factor: 12413327709847303
    { 3321933829, 53,              2148996ULL }, // M3321933829 has a factor: 14277645021571369
    { 3321931579, 53,              2420121ULL }, // M3321931579 has a factor: 16078952749802119
    { 3321931463, 53,              2497317ULL }, // M3321931463 has a factor: 16591831830769543
    { 3321928993, 54,              2828376ULL }, // M3321928993 has a factor: 18791328475010737
    { 3321932839, 54,              2863832ULL }, // M3321932839 has a factor: 19026915132358097
    { 3321931313, 54,              2958568ULL }, // M3321931313 has a factor: 19656319361679569
    { 3321932893, 54,              3553683ULL }, // M3321932893 has a factor: 23610192897989839
    { 3321933697, 54,              3893123ULL }, // M3321933697 has a factor: 25865392960531463
    { 3321931213, 54,              4223991ULL }, // M3321931213 has a factor: 28063615092662167
    { 3321929867, 54,              5239684ULL }, // M3321929867 has a factor: 34811725546484057
    { 3321929393, 54,              5270835ULL }, // M3321929393 has a factor: 35018683424306311
    { 3321932839, 55,              6570617ULL }, // M3321932839 has a factor: 43654296769583327
    { 3321928619, 55,              7327797ULL }, // M3321928619 has a factor: 48684837137044687
    { 3321933931, 55,              8389628ULL }, // M3321933931 has a factor: 55739579843335337
    { 3321928619, 55,              8892025ULL }, // M3321928619 has a factor: 59077344656726951
    { 3321933781, 56,             14692191ULL }, // M3321933781 has a factor: 97612971199608343
    { 3321931727, 56,             16491100ULL }, // M3321931727 has a factor: 109564616606259401
    { 3321931927, 57,             23164788ULL }, // M3321931927 has a factor: 153903697678772953
    { 3321930769, 57,             31528151ULL }, // M3321930769 has a factor: 209468669793156239
    { 3321933281, 57,             37202620ULL }, // M3321933281 has a factor: 247169243036792441
    { 3321933073, 58,             56160011ULL }, // M3321933073 has a factor: 373119595841887607
    { 3321932591, 58,             66850224ULL }, // M3321932591 has a factor: 444143875642500769
    { 3321929129, 58,             67245844ULL }, // M3321929129 has a factor: 446771855975579753
    { 3321932099, 58,             72817924ULL }, // M3321932099 has a factor: 483792398236284953
    { 3321933473, 58,             73307343ULL }, // M3321933473 has a factor: 487044233056784479
    { 3321933473, 58,             75500260ULL }, // M3321933473 has a factor: 501613681828405961
    { 3321929843, 58,             78901228ULL }, // M3321929843 has a factor: 524208687885094409
    { 3321929477, 59,             89605180ULL }, // M3321929477 has a factor: 595324177467781721
    { 3321931981, 59,             93805959ULL }, // M3321931981 has a factor: 623234030420949559
    { 3321930047, 59,            120998172ULL }, // M3321930047 has a factor: 803894926397748169
    { 3321928991, 59,            142300185ULL }, // M3321928991 has a factor: 945422219952326671
    { 3321933397, 59,            146715695ULL }, // M3321933397 has a factor: 974759534169131831
    { 3321930839, 59,            158992936ULL }, // M3321930839 has a factor: 1056327074563106609
    { 3321933073, 61,            400769348ULL }, // M3321933073 has a factor: 2662657903531692809
    { 3321932953, 61,            532598700ULL }, // M3321932953 has a factor: 3538514344509922201
    { 3321928567, 61,            549413525ULL }, // M3321928567 has a factor: 3650224967587337351
    { 3321930817, 61,            689350739ULL }, // M3321930817 has a factor: 4579950927211647527
    { 3321930317, 62,            801027507ULL }, // M3321930317 has a factor: 5321915120508459439
    { 3321931957, 62,            984938652ULL }, // M3321931957 has a factor: 6543798367526603929
    { 3321931729, 62,           1186851432ULL }, // M3321931729 has a factor: 7885278859139771857
    { 3321932179, 63,           1460024880ULL }, // M3321932179 has a factor: 9700207262025227041
    { 3321931213, 63,           1963101651ULL }, // M3321931213 has a factor: 13042577297497465327
    { 3321929777, 63,           1989692928ULL }, // M3321929777 has a factor: 13219240369219034113
    { 3321930701, 63,           2035742611ULL }, // M3321930701 has a factor: 13525191757629600623
    { 3321930817, 63,           2080613835ULL }, // M3321930817 has a factor: 13823310433526106391
    { 3321930841, 63,           2530561248ULL }, // M3321930841 has a factor: 16812698909541299137
    { 3321931973, 64,           4016423448ULL }, // M3321931973 has a factor: 26684570938036205809
    { 3321933469, 64,           4667161176ULL }, // M3321933469 has a factor: 31007997831543599089
    { 3321929477, 65,           6108537892ULL }, // M3321929477 has a factor: 40584264169612484969
    { 3321933689, 65,           6661541896ULL }, // M3321933689 has a factor: 44258400890014668689
    { 3321932099, 65,           7682803957ULL }, // M3321932099 has a factor: 51043506150165031487
    { 3321931831, 65,          10267537485ULL }, // M3321931831 has a factor: 68216119194814370071
    { 3321931517, 65,          10611759067ULL }, // M3321931517 has a factor: 70503073790955629279
    { 3321931013, 65,          10788755307ULL }, // M3321931013 has a factor: 71679001691983271983
    { 3321928567, 66,          11167520232ULL }, // M3321928567 has a factor: 74195408962462535089
    { 3321931793, 66,          11678917503ULL }, // M3321931793 has a factor: 77593134722079745759
    { 3321928703, 66,          12050934813ULL }, // M3321928703 has a factor: 80064692506573275079
    { 3321930221, 66,          12199903263ULL }, // M3321930221 has a factor: 81054454685272422247
    { 3321928787, 66,          16384425312ULL }, // M3321928787 has a factor: 108855788204768513089
    { 3321933169, 66,          19116490796ULL }, // M3321933169 has a factor: 127007409700231225049
    { 3321929843, 66,          19972897321ULL }, // M3321929843 has a factor: 132697127323609301207
    { 3321930671, 66,          21510654421ULL }, // M3321930671 has a factor: 142913805348803292983
    { 3321931463, 67,          22464313428ULL }, // M3321931463 has a factor: 149249819142333170329
    { 3321929461, 67,          28646296443ULL }, // M3321929461 has a factor: 190321952205082414447
    { 3321928949, 67,          32943049887ULL }, // M3321928949 has a factor: 218868942175952957527
    { 3321930769, 67,          36766980680ULL }, // M3321930769 has a factor: 244274728808241085841
    { 3321928513, 67,          38682105743ULL }, // M3321928513 has a factor: 256998380021105500319
    { 3321930289, 68,          59194382247ULL }, // M3321930289 has a factor: 393279222649906358767
    { 3321928439, 68,          70524128169ULL }, // M3321928439 has a factor: 468552214000564196383
    { 3321931337, 68,          76145382348ULL }, // M3321931337 has a factor: 505899463579335678553
    { 3321928243, 69,          93229904040ULL }, // M3321928243 has a factor: 619406102645311603441
    { 3321931969, 69,          99810006639ULL }, // M3321931969 has a factor: 663124103760392684383
    { 3321932947, 69,         150253371513ULL }, // M3321932947 has a factor: 998263250453731877623
    { 3321932819, 69,         151702088425ULL }, // M3321932819 has a factor: 1007888292499695040151
    { 3321929579, 69,         158875882444ULL }, // M3321929579 has a factor: 1055548986560900822153
    { 3321931267, 69,         162390773433ULL }, // M3321931267 has a factor: 1078901975478791259223
    { 3321931111, 70,         256205911040ULL }, // M3321931111 has a factor: 1702196773411748730881
    { 3321931037, 70,         296232932380ULL }, // M3321931037 has a factor: 1968130744509288556121
    { 3321928921, 70,         320088740619ULL }, // M3321928921 has a factor: 2126624089497447084199
    { 3321929759, 71,         617575716316ULL }, // M3321929759 has a factor: 4103086300931724495689
    { 3321931637, 74,        4285913815420ULL }, // M3321931637 has a factor: 28475025393798152885081
    { 3321931061, 74,        4490333754576ULL }, // M3321931061 has a factor: 29833158347165530570273
    { 3321933893, 74,        5461440407140ULL }, // M3321933893 has a factor: 36285087986156170392041
    { 3321929827, 75,       11095452686288ULL }, // M3321929827 has a factor: 73716630445294762224353

    /* some COMPOSITE factors build, each one build from two factors above (Operation Billion Digits) */
    { 3321928703, 90,   216815004777177520ULL }, // M3321928703 has a factor: 1440487975220776246028713121
    { 3321932063, 91,   485508476522096757ULL }, // M3321932063 has a factor: 3225652350034071890133239383
    { 3321932423, 91,   511729020109695685ULL }, // M3321932423 has a factor: 3399858447384834225329389511
    { 3321929843, 91,   524208687963995637ULL }, // M3321929843 has a factor: 3482768969014944032144189983
    { 3321931927, 92,  1231229581453348412ULL }, // M3321931927 has a factor: 8180121712193450301755099849
    { 3321931973, 92,  1239904465059470560ULL }, // M3321931973 has a factor: 8237756571893033199432429761
    { 3321933697, 93,  1629519756517375292ULL }, // M3321933697 has a factor: 10826313178204608696980029049
    { 3321931313, 94,  3380886930211844436ULL }, // M3321931313 has a factor: 22462148318366343510866448937
    { 3321929867, 94,  4072971888943874353ULL }, // M3321929867 has a factor: 27060253930668126599852002103
    { 3321928619, 94,  5842180456452690237ULL }, // M3321928619 has a factor: 38814612911305349835664385407

    /* all known factors from primenet (2011-07-16) with at least 20 digits and a k <= 2^63.9
for M5x.000.000 to M5x.100.000 with x = 3, 5, 7 and 9
except those which were already in this file before */
    {   53054873, 63,          94448564136ULL }, // M53054873 has a factor: 10021913150535669457
    {   55085521, 63,          91109099676ULL }, // M55085521 has a factor: 10037584446986782393
    {   53026187, 63,          95608729528ULL }, // M53026187 has a factor: 10139532741568299473
    {   53007413, 63,          96180756151ULL }, // M53007413 has a factor: 10196586127896694727
    {   57078799, 63,          89531446640ULL }, // M57078799 has a factor: 10220694893887570721
    {   55038257, 63,          93441513192ULL }, // M55038257 has a factor: 10285716035060372689
    {   55020013, 63,          94543419423ULL }, // M55020013 has a factor: 10403560331435824999
    {   53062883, 63,          98485354285ULL }, // M53062883 has a factor: 10451833663277007311
    {   59001361, 63,          88887700491ULL }, // M59001361 has a factor: 10488990610258736503
    {   59037061, 63,          89165515115ULL }, // M59037061 has a factor: 10528139909881354031
    {   53050799, 63,          99672114220ULL }, // M53050799 has a factor: 10575370594780523561
    {   55030981, 63,          96270806400ULL }, // M55030981 has a factor: 10595753835706156801
    {   53020711, 63,         100675222101ULL }, // M53020711 has a factor: 10675743711755867623
    {   55098163, 63,          97447628853ULL }, // M55098163 has a factor: 10738370677012194079
    {   53005223, 63,         102012279388ULL }, // M53005223 has a factor: 10814367235398487049
    {   57069851, 63,          94878477561ULL }, // M57069851 has a factor: 10829401155026226823
    {   53062393, 63,         102123560463ULL }, // M53062393 has a factor: 10837840999693935919
    {   59036773, 63,          92213074251ULL }, // M59036773 has a factor: 10887924664376864047
    {   55052887, 63,          99552074453ULL }, // M55052887 has a factor: 10961258210953191623
    {   53040961, 63,         103466588771ULL }, // M53040961 has a factor: 10975934599611297863
    {   59067311, 63,          93232182213ULL }, // M59067311 has a factor: 11013948603967878487
    {   55032083, 63,         100131132901ULL }, // M55032083 has a factor: 11020849633383725567
    {   55035257, 63,         100339158952ULL }, // M55035257 has a factor: 11044382800174341329
    {   59047129, 63,          93523468751ULL }, // M59047129 has a factor: 11044584647735531759
    {   59012617, 63,          93936289763ULL }, // M59012617 has a factor: 11086852580369879543
    {   55059877, 63,         101701731788ULL }, // M55059877 has a factor: 11199369685868540153
    {   55077619, 63,         102198884825ULL }, // M55077619 has a factor: 11257742481232463351
    {   59060107, 63,          95559427445ULL }, // M59060107 has a factor: 11287500019520873231
    {   53009701, 63,         106517787408ULL }, // M53009701 has a factor: 11292952123359290017
    {   53078863, 63,         106401170337ULL }, // M53078863 has a factor: 11295306286714573663
    {   55035163, 63,         103705095797ULL }, // M55035163 has a factor: 11414853702237019823
    {   59046577, 63,          98127703799ULL }, // M59046577 has a factor: 11588210036401692047
    {   57069143, 63,         101879976313ULL }, // M57069143 has a factor: 11628405874086419519
    {   53065427, 63,         109646543952ULL }, // M53065427 has a factor: 11636881347774295009
    {   53040641, 63,         109858134028ULL }, // M53040641 has a factor: 11653891695818063897
    {   53079757, 63,         110066473764ULL }, // M53079757 has a factor: 11684603362479990697
    {   59045171, 63,         101042885269ULL }, // M59045171 has a factor: 11932188878082971999
    {   59041783, 63,         102706772357ULL }, // M59041783 has a factor: 12127981932264785063
    {   53037623, 63,         114651076513ULL }, // M53037623 has a factor: 12161641145281297199
    {   57046321, 63,         106912144863ULL }, // M57046321 has a factor: 12197889069306398047
    {   59054509, 63,         103624915499ULL }, // M59054509 has a factor: 12239037009919869983
    {   55049573, 63,         111716435928ULL }, // M55049573 has a factor: 12299884189836517489
    {   59015161, 63,         104219544144ULL }, // M59015161 has a factor: 12301066354009534369
    {   59038913, 63,         104680620187ULL }, // M59038913 has a factor: 12360460056012673463
    {   59056889, 63,         104910345771ULL }, // M59056889 has a factor: 12391357290299132839
    {   57085289, 63,         108563967691ULL }, // M57085289 has a factor: 12394810941254795399
    {   57029551, 63,         109551401928ULL }, // M57029551 has a factor: 12495334526748748657
    {   57062347, 63,         110286072897ULL }, // M57062347 has a factor: 12586364321831818519
    {   55072519, 63,         114622684641ULL }, // M55072519 has a factor: 12625119955444961359
    {   55056571, 63,         116710344084ULL }, // M55056571 has a factor: 12851342690990351929
    {   53031269, 63,         121352559391ULL }, // M53031269 has a factor: 12870960441805194359
    {   57004543, 63,         116536379273ULL }, // M57004543 has a factor: 13286206086664074479
    {   55065797, 63,         121319834779ULL }, // M55065797 has a factor: 13361146788027907727
    {   53099791, 63,         126153492948ULL }, // M53099791 has a factor: 13397448218917547737
    {   55000709, 63,         121800357964ULL }, // M55000709 has a factor: 13398212088947592953
    {   53000183, 63,         126401296096ULL }, // M53000183 has a factor: 13398583649050371137
    {   53035963, 63,         127239979340ULL }, // M53035963 has a factor: 13496589672794008841
    {   55063303, 63,         122872463681ULL }, // M55063303 has a factor: 13531527396046796687
    {   59019473, 63,         114683356675ULL }, // M59019473 has a factor: 13537102545659064551
    {   53044847, 63,         128681173777ULL }, // M53044847 has a factor: 13651746349562754239
    {   55062737, 63,         124007097615ULL }, // M55062737 has a factor: 13656340404216144511
    {   55098151, 63,         124640168564ULL }, // M55098151 has a factor: 13734885656409450329
    {   57055259, 63,         123289705489ULL }, // M57055259 has a factor: 14068652157417233303
    {   59068661, 63,         120367116304ULL }, // M59068661 has a factor: 14219848777017097889
    {   53049839, 63,         134096604777ULL }, // M53049839 has a factor: 14227606587732961807
    {   55037849, 63,         129654294367ULL }, // M55037849 has a factor: 14271786951144993167
    {   59013763, 63,         122465357177ULL }, // M59013763 has a factor: 14454283128307654103
    {   57065123, 63,         127071568248ULL }, // M57065123 has a factor: 14502709343750029009
    {   55056653, 63,         132573530788ULL }, // M55056653 has a factor: 14598109763159465129
    {   57097331, 63,         128404448641ULL }, // M57097331 has a factor: 14663102611855354343
    {   55092671, 63,         134036593708ULL }, // M55092671 has a factor: 14768867918231028137
    {   55081861, 63,         135042351236ULL }, // M55081861 has a factor: 14876768039789060393
    {   57016027, 63,         130531550453ULL }, // M57016027 has a factor: 14884780809960220463
    {   57061819, 63,         130465953165ULL }, // M57061819 has a factor: 14889249210327414271
    {   53048287, 63,         141146910489ULL }, // M53048287 has a factor: 14975203633567564687
    {   53077249, 63,         142712498340ULL }, // M53077249 has a factor: 15149573619608533321
    {   53059063, 63,         142921431252ULL }, // M53059063 has a factor: 15166554449700073753
    {   57071029, 63,         133603554492ULL }, // M57071029 has a factor: 15249784665832024537
    {   55031917, 63,         139604760347ULL }, // M55031917 has a factor: 15365435168441990399
    {   55028821, 63,         139778080608ULL }, // M55028821 has a factor: 15383645955002406337
    {   55079483, 63,         139738038445ULL }, // M55079483 has a factor: 15393397825969447871
    {   59096087, 63,         130384658004ULL }, // M59096087 has a factor: 15410446185739260697
    {   57006139, 63,         135998925641ULL }, // M57006139 has a factor: 15505547317883020199
    {   57044573, 63,         136347506200ULL }, // M57044573 has a factor: 15555770541587705201
    {   59074123, 63,         135936489113ULL }, // M59074123 has a factor: 16060657756099045799
    {   53076629, 63,         151352879035ULL }, // M53076629 has a factor: 16066601217245146031
    {   55034851, 63,         146197107809ULL }, // M55034851 has a factor: 16091872089798502919
    {   59030129, 63,         136415158980ULL }, // M59030129 has a factor: 16105208864289816841
    {   59046991, 63,         136856648324ULL }, // M59046991 has a factor: 16161946563754786169
    {   57016459, 63,         141859551992ULL }, // M57016459 has a factor: 16176658659820472657
    {   55099523, 63,         147286632913ULL }, // M55099523 has a factor: 16230846435564800999
    {   57079807, 63,         142687939232ULL }, // M57079807 has a factor: 16289200065180576449
    {   57062737, 63,         143266639604ULL }, // M57062737 has a factor: 16350373153193672297
    {   55043869, 63,         149530064784ULL }, // M55043869 has a factor: 16461426595064018593
    {   55080611, 63,         150890397960ULL }, // M55080611 has a factor: 16622270627339907121
    {   53073899, 63,         156836763732ULL }, // M53073899 has a factor: 16647877115598062137
    {   55096747, 63,         151127464580ULL }, // M55096747 has a factor: 16653263361431442521
    {   55026757, 63,         151837260159ULL }, // M55026757 has a factor: 16710224036630148727
    {   59002969, 63,         143087295191ULL }, // M59002969 has a factor: 16885150484896844159
    {   59068993, 63,         143162022420ULL }, // M59068993 has a factor: 16912873000385646121
    {   55012819, 63,         153989677652ULL }, // M55012819 has a factor: 16942812529075641977
    {   55073311, 63,         155481222461ULL }, // M55073311 has a factor: 17125731438509676743
    {   53021753, 63,         161688218175ULL }, // M53021753 has a factor: 17145985534169921551
    {   55091297, 63,         155664391428ULL }, // M55091297 has a factor: 17151506440968404233
    {   59079733, 63,         145797691256ULL }, // M59079733 has a factor: 17227377342841829297
    {   57048247, 63,         151100541540ULL }, // M57048247 has a factor: 17240042031215360761
    {   57093079, 63,         151830338000ULL }, // M57093079 has a factor: 17336922964061404001
    {   55024033, 63,         157679352503ULL }, // M55024033 has a factor: 17352307791087409199
    {   57079733, 63,         152136302788ULL }, // M57079733 has a factor: 17367799085492391209
    {   55081489, 63,         159371320415ULL }, // M55081489 has a factor: 17556819264708595871
    {   55003129, 63,         160638687327ULL }, // M55003129 has a factor: 17671260882875292367
    {   57087557, 63,         156602266732ULL }, // M57087557 has a factor: 17880081656784507449
    {   55089787, 63,         163401858173ULL }, // M55089787 has a factor: 18003547124309558303
    {   59098271, 64,         156889373088ULL }, // M59098271 has a factor: 18543781375549461697
    {   59043371, 64,         159554544129ULL }, // M59043371 has a factor: 18841276287488837719
    {   59037943, 64,         160117003121ULL }, // M59037943 has a factor: 18905957007176840207
    {   53055577, 64,         178393432319ULL }, // M53055577 has a factor: 18929532969389986127
    {   59006071, 64,         160727752113ULL }, // M59006071 has a factor: 18967826305700156047
    {   57051343, 64,         168715023428ULL }, // M57051343 has a factor: 19250837341687727609
    {   55046977, 64,         175347089027ULL }, // M55046977 has a factor: 19304654353372442759
    {   55071829, 64,         175567827132ULL }, // M55071829 has a factor: 19337682707430128857
    {   59081389, 64,         163842910952ULL }, // M59081389 has a factor: 19360133513694944657
    {   55016623, 64,         176222945036ULL }, // M55016623 has a factor: 19390382661990666857
    {   57015719, 64,         170746285524ULL }, // M57015719 has a factor: 19470444471460303513
    {   55000027, 64,         177145614744ULL }, // M55000027 has a factor: 19486027187703196177
    {   57065677, 64,         171337620680ULL }, // M57065677 has a factor: 19554994639346800721
    {   59027953, 64,         166739622792ULL }, // M59027953 has a factor: 19684597234807809553
    {   55031813, 64,         178994992156ULL }, // M55031813 has a factor: 19700837872530917657
    {   55099537, 64,         179333098872ULL }, // M55099537 has a factor: 19762341433244844529
    {   57093019, 64,         173437509669ULL }, // M57093019 has a factor: 19804142069689801423
    {   59092309, 64,         169028641964ULL }, // M59092309 has a factor: 19976585481574109753
    {   57022181, 64,         176950447276ULL }, // M57022181 has a factor: 20180200865206057913
    {   59008459, 64,         171765821036ULL }, // M59008459 has a factor: 20271272816408287049
    {   57094001, 64,         178949169156ULL }, // M57094001 has a factor: 20433848085483666313
    {   57079181, 64,         180294349416ULL }, // M57079181 has a factor: 20582107607186216593
    {   57003679, 64,         181606883612ULL }, // M57003679 has a factor: 20704520995217617097
    {   59050279, 64,         175470245157ULL }, // M59050279 has a factor: 20723133865438497607
    {   57058739, 64,         181836379552ULL }, // M57058739 has a factor: 20750709043125009857
    {   57014873, 64,         183181376160ULL }, // M57014873 has a factor: 20888125795455255361
    {   55055999, 64,         189704906737ULL }, // M55055999 has a factor: 20888786311214730527
    {   55094279, 64,         189603136597ULL }, // M55094279 has a factor: 20892096213900457127
    {   57078331, 64,         184387558593ULL }, // M57078331 has a factor: 21049068203306296567
    {   59073439, 64,         179970665637ULL }, // M59073439 has a factor: 21262972276593431287
    {   57040411, 64,         186634298625ULL }, // M57040411 has a factor: 21291394200533469751
    {   53013679, 64,         202136993069ULL }, // M53013679 has a factor: 21432051329170381703
    {   59054057, 64,         182779979919ULL }, // M59054057 has a factor: 21587798705190962767
    {   59079877, 64,         183306541143ULL }, // M59079877 has a factor: 21659455808047758823
    {   57069613, 64,         191621127192ULL }, // M57069613 has a factor: 21871487142942433393
    {   57047609, 64,         192829108716ULL }, // M57047609 has a factor: 22000879195697720089
    {   57098681, 64,         193065539868ULL }, // M57098681 has a factor: 22047575346031428217
    {   53092931, 64,         207878910424ULL }, // M53092931 has a factor: 22073801294993225489
    {   55012079, 64,         202388833216ULL }, // M55012079 has a factor: 22267660963192832129
    {   57063389, 64,         195358565764ULL }, // M57063389 has a factor: 22295643665346428393
    {   59019143, 64,         190399255180ULL }, // M59019143 has a factor: 22474401737123821481
    {   53023177, 64,         212743433352ULL }, // M53023177 has a factor: 22560665444421598609
    {   57013237, 64,         198831583788ULL }, // M57013237 has a factor: 22672064419181203513
    {   53039599, 64,         215174188460ULL }, // M53039599 has a factor: 22825505342137655081
    {   59064589, 64,         193515173100ULL }, // M59064589 has a factor: 22859788328830711801
    {   55080127, 64,         208410722357ULL }, // M55080127 has a factor: 22958578111170598679
    {   55071251, 64,         209795602501ULL }, // M55071251 has a factor: 23107412568057597503
    {   53082059, 64,         219184506324ULL }, // M53082059 has a factor: 23269529793152882233
    {   55004629, 64,         214677471551ULL }, // M55004629 has a factor: 23616509354641619159
    {   55021921, 64,         214743151583ULL }, // M55021921 has a factor: 23631161443381701887
    {   59087687, 64,         201199405057ULL }, // M59087687 has a factor: 23776814941188466319
    {   59014679, 64,         201771139792ULL }, // M59014679 has a factor: 23814918092578013537
    {   55087699, 64,         217753927377ULL }, // M55087699 has a factor: 23991125614824071047
    {   59000287, 64,         203683389929ULL }, // M59000287 has a factor: 24034756925887819247
    {   55008689, 64,         219210784032ULL }, // M55008689 has a factor: 24116995688524908097
    {   57000011, 64,         211943701341ULL }, // M57000011 has a factor: 24161586615635429503
    {   55026241, 64,         219781831155ULL }, // M55026241 has a factor: 24187536017112676711
    {   53013967, 64,         233382038897ULL }, // M53013967 has a factor: 24745015416956548799
    {   59045783, 64,         210593348820ULL }, // M59045783 has a factor: 24869298351338052121
    {   55054183, 64,         226216051845ULL }, // M55054183 has a factor: 24908279831624235271
    {   53029267, 64,         234895217928ULL }, // M53029267 has a factor: 24912642457054197553
    {   53027911, 64,         236388283581ULL }, // M53027911 has a factor: 25070353726352058583
    {   55052567, 64,         227766110848ULL }, // M55052567 has a factor: 25078218155577893633
    {   57082639, 64,         220951985952ULL }, // M57082639 has a factor: 25225044900862174657
    {   55030489, 64,         229774385460ULL }, // M55030489 has a factor: 25289193583076579881
    {   53040223, 64,         239627013056ULL }, // M53040223 has a factor: 25419740418628302977
    {   57018383, 64,         223704774292ULL }, // M57018383 has a factor: 25510568999019619673
    {   53005817, 64,         242114829343ULL }, // M53005817 has a factor: 25666988674282576463
    {   59038219, 64,         220654643264ULL }, // M59038219 has a factor: 26054114304773813633
    {   55088357, 64,         238015561875ULL }, // M55088357 has a factor: 26223772488251178751
    {   53096833, 64,         249225625668ULL }, // M53096833 has a factor: 26466182850828618889
    {   55089871, 64,         241217266700ULL }, // M55089871 has a factor: 26577256210951191401
    {   59028527, 64,         225723349492ULL }, // M59028527 has a factor: 26648233660037916569
    {   53044841, 64,         251590962168ULL }, // M53044841 has a factor: 26691205170477150577
    {   57092621, 64,         235122068251ULL }, // M57092621 has a factor: 26847470262780951743
    {   59068901, 64,         229413607416ULL }, // M59068901 has a factor: 27102419329017139633
    {   53091191, 64,         255591124684ULL }, // M53091191 has a factor: 27139274437006117289
    {   57017731, 64,         238365156348ULL }, // M57017731 has a factor: 27182080728846412777
    {   55039147, 64,         250698985544ULL }, // M55039147 has a factor: 27596516636214181937
    {   55076027, 64,         251192054589ULL }, // M55076027 has a factor: 27669320761458475807
    {   53050423, 64,         261869371805ULL }, // M53050423 has a factor: 27784561889999047031
    {   59016557, 64,         236755204375ULL }, // M59016557 has a factor: 27944954028087673751
    {   57063791, 64,         244858927024ULL }, // M57063791 has a factor: 27945157272363575969
    {   57032279, 64,         245081809836ULL }, // M57032279 has a factor: 27955148312783392489
    {   55079237, 64,         253891166107ULL }, // M55079237 has a factor: 27968263420427640719
    {   57015997, 64,         246210954755ULL }, // M57015997 has a factor: 28075926115356431471
    {   57044837, 64,         246196932603ULL }, // M57044837 has a factor: 28088527780476241423
    {   57077333, 64,         247593104983ULL }, // M57077333 has a factor: 28263908203237300679
    {   57023683, 64,         248081853977ULL }, // M57023683 has a factor: 28293081998473474583
    {   59058203, 64,         240599435560ULL }, // M59058203 has a factor: 28418740613975797361
    {   53048503, 64,         270201983076ULL }, // M53048503 has a factor: 28667621419626270457
    {   55051369, 64,         263205737355ULL }, // M55051369 has a factor: 28979672340094377991
    {   59000609, 64,         245639179399ULL }, // M59000609 has a factor: 28985722357602507983
    {   53066173, 64,         275199853427ULL }, // M53066173 has a factor: 29207606063063649743
    {   53014531, 64,         275549971344ULL }, // M53014531 has a factor: 29216304995731199329
    {   57031357, 64,         257046188112ULL }, // M57031357 has a factor: 29319385839409255969
    {   55014979, 64,         270147907896ULL }, // M55014979 has a factor: 29724362959584748369
    {   57082409, 64,         263277922596ULL }, // M57082409 has a factor: 30057076116590427529
    {   53019931, 64,         284488019556ULL }, // M53019931 has a factor: 30167070334371541273
    {   57055351, 64,         265316137260ULL }, // M57055351 has a factor: 30275410674666956521
    {   53039809, 64,         285918502776ULL }, // M53039809 has a factor: 30330125553610019569
    {   53040821, 64,         286643016895ULL }, // M53040821 has a factor: 30407561900055341591
    {   55077527, 64,         276519022593ULL }, // M55077527 has a factor: 30459967865759135023
    {   55023049, 64,         276986628591ULL }, // M55023049 has a factor: 30481297674614787919
    {   55048129, 64,         277393395611ULL }, // M55048129 has a factor: 30539974850684723639
    {   59006483, 64,         259426269168ULL }, // M59006483 has a factor: 30615663482830032289
    {   59003731, 64,         260242961709ULL }, // M59003731 has a factor: 30710611414642272559
    {   53043253, 64,         290887007603ULL }, // M53043253 has a factor: 30859186277397705119
    {   59096833, 64,         261373294503ULL }, // M59096833 has a factor: 30892667871807217999
    {   55026269, 64,         280755690271ULL }, // M55026269 has a factor: 30897876272265457799
    {   53029073, 64,         292204553223ULL }, // M53029073 has a factor: 30990673167589704559
    {   59094127, 64,         264316933337ULL }, // M59094127 has a factor: 31239156853734423599
    {   55066343, 64,         284460980937ULL }, // M55066343 has a factor: 31328451892786606783
    {   55086077, 64,         286657949943ULL }, // M55086077 has a factor: 31581723806444487223
    {   59013821, 64,         267814543240ULL }, // M59013821 has a factor: 31609519031924240081
    {   59000363, 64,         268782264261ULL }, // M59000363 has a factor: 31716502318721853487
    {   53006479, 64,         301690567320ULL }, // M53006479 has a factor: 31983109442291332561
    {   55020919, 64,         291997739300ULL }, // M55020919 has a factor: 32131967924416833401
    {   57085909, 64,         281616386612ULL }, // M57085909 has a factor: 32152654838082900617
    {   59082433, 64,         272152341300ULL }, // M59082433 has a factor: 32158844941300765801
    {   59036273, 64,         272543768575ULL }, // M59036273 has a factor: 32179936652085041951
    {   53096669, 64,         303516555195ULL }, // M53096669 has a factor: 32231436134418290911
    {   55032337, 64,         293853447695ULL }, // M55032337 has a factor: 32342883924326226431
    {   59039831, 64,         276205558441ULL }, // M59039831 has a factor: 32614258983234526943
    {   55084433, 64,         296093522235ULL }, // M55084433 has a factor: 32620287574575735511
    {   59051813, 64,         276202964263ULL }, // M59051813 has a factor: 32620571591408717639
    {   59097683, 64,         277137476868ULL }, // M59097683 has a factor: 32756365510729793689
    {   53078213, 64,         308916238596ULL }, // M53078213 has a factor: 32793443822714617897
    {   57042779, 64,         287612000745ULL }, // M57042779 has a factor: 32812375592489740711
    {   57011131, 64,         289765638953ULL }, // M57011131 has a factor: 33039733603296371687
    {   57068057, 64,         293186155060ULL }, // M57068057 has a factor: 33463128417149836841
    {   59000629, 64,         283784529920ULL }, // M59000629 has a factor: 33486931531498639361
    {   57015883, 64,         296961876276ULL }, // M57015883 has a factor: 33863087186425783417
    {   53090627, 64,         319331138857ULL }, // M53090627 has a factor: 33906980765084386679
    {   57095917, 64,         298011885900ULL }, // M57095917 has a factor: 34030523804719740601
    {   55021157, 64,         311752536487ULL }, // M55021157 has a factor: 34305970510398910919
    {   55020871, 64,         311811371589ULL }, // M55020871 has a factor: 34312266505062868039
    {   57058411, 64,         301118625356ULL }, // M57058411 has a factor: 34362700570635338633
    {   57080867, 64,         301172274432ULL }, // M57080867 has a factor: 34382349081880985089
    {   57066091, 64,         302988235380ULL }, // M57066091 has a factor: 34580708424248999161
    {   59024347, 64,         294837224045ULL }, // M59024347 has a factor: 34805149241097647231
    {   59001889, 64,         295004209331ULL }, // M59001889 has a factor: 34811611226960852519
    {   55091119, 64,         316186914612ULL }, // M55091119 has a factor: 34838181878265061657
    {   53057071, 64,         328743149120ULL }, // M53057071 has a factor: 34884297207246855041
    {   53036153, 64,         330358347360ULL }, // M53036153 has a factor: 35041871710824212161
    {   55069117, 64,         321024557904ULL }, // M55069117 has a factor: 35357077878177301537
    {   59010641, 64,         301212321355ULL }, // M59010641 has a factor: 35549464320513077111
    {   57032413, 64,         311810649000ULL }, // M57032413 has a factor: 35566627423132074001
    {   55060283, 64,         328272230572ULL }, // M55060283 has a factor: 36149523832671143753
    {   55026407, 64,         328670034592ULL }, // M55026407 has a factor: 36171062184326941889
    {   53057923, 64,         343483457048ULL }, // M53057923 has a factor: 36449037631653182609
    {   59050219, 64,         310051380056ULL }, // M59050219 has a factor: 36617203787118064529
    {   53046139, 64,         345536552460ULL }, // M53046139 has a factor: 36658759982747903881
    {   55059091, 64,         333670840044ULL }, // M55059091 has a factor: 36743226292058080009
    {   53034599, 64,         346879445284ULL }, // M53034599 has a factor: 36793224563958762233
    {   57079643, 64,         322580313468ULL }, // M57079643 has a factor: 36825538263163063849
    {   57076367, 65,         324643858669ULL }, // M57076367 has a factor: 37058984043375951047
    {   59058211, 65,         314304207228ULL }, // M59058211 has a factor: 37124488377317898217
    {   59049047, 65,         316660689405ULL }, // M59049047 has a factor: 37397023863456494071
    {   53005891, 65,         353436803024ULL }, // M53005891 has a factor: 37468465312957228769
    {   57041483, 65,         328891138600ULL }, // M57041483 has a factor: 37520876582605087601
    {   53048351, 65,         355182230193ULL }, // M53048351 has a factor: 37683663232482123487
    {   59021363, 65,         319356626452ULL }, // M59021363 has a factor: 37697726752557788153
    {   53064377, 65,         356809182120ULL }, // M53064377 has a factor: 37867713914154678481
    {   57050867, 65,         332881021465ULL }, // M57050867 has a factor: 37982301764847720311
    {   57043579, 65,         333887165060ULL }, // M57043579 has a factor: 38092237754372299481
    {   53002009, 65,         359412672539ULL }, // M53002009 has a factor: 38099187409252261703
    {   55025437, 65,         347566741268ULL }, // M55025437 has a factor: 38250023649875268233
    {   55034437, 65,         350201211728ULL }, // M55034437 has a factor: 38546253048336554273
    {   55043293, 65,         350412731075ULL }, // M55043293 has a factor: 38575741254982859951
    {   59078447, 65,         333522527353ULL }, // M59078447 has a factor: 39407985911060521583
    {   59043679, 65,         335082852272ULL }, // M59043679 has a factor: 39569048735904777377
    {   59098453, 65,         336141551468ULL }, // M59098453 has a factor: 39730891361557358009
    {   57024367, 65,         349349545749ULL }, // M57024367 has a factor: 39842873416148531767
    {   59056483, 65,         337843925060ULL }, // M59056483 has a factor: 39903748033918327961
    {   57005381, 65,         352608002143ULL }, // M57005381 has a factor: 40201107011621062967
    {   59053471, 65,         340439354588ULL }, // M59053471 has a factor: 40208251106842349897
    {   55025293, 65,         366142405188ULL }, // M55025293 has a factor: 40294186250388840169
    {   59086999, 65,         343222849940ULL }, // M59086999 has a factor: 40560016382363860121
    {   59007211, 65,         346187603241ULL }, // M59007211 has a factor: 40855129900051941703
    {   53045029, 65,         386065384344ULL }, // M53045029 has a factor: 40957699016847251953
    {   53076869, 65,         386015885676ULL }, // M53076869 has a factor: 40977029191888056889
    {   57003631, 65,         359804871144ULL }, // M57003631 has a factor: 41020368213390247729
    {   57055849, 65,         360565614032ULL }, // M57055849 has a factor: 41144754457604146337
    {   53078071, 65,         392859186669ULL }, // M53078071 has a factor: 41704415606038870999
    {   57062983, 65,         365497305893ULL }, // M57062983 has a factor: 41712733105436117639
    {   53026249, 65,         395212081364ULL }, // M53026249 has a factor: 41913228468431447273
    {   55038749, 65,         380860876800ULL }, // M55038749 has a factor: 41924212404230246401
    {   59084533, 65,         354984764132ULL }, // M59084533 has a factor: 41948218021708740713
    {   57094403, 65,         367817252905ULL }, // M57094403 has a factor: 42000612935421981431
    {   55050547, 65,         382102629992ULL }, // M55050547 has a factor: 42069917582396411249
    {   55011499, 65,         382805417552ULL }, // M55011499 has a factor: 42117399689712860897
    {   59004133, 65,         357640501067ULL }, // M59004133 has a factor: 42204535382287819823
    {   55085911, 65,         384548965536ULL }, // M55085911 has a factor: 42366460181316326593
    {   53039873, 65,         404497889932ULL }, // M53039873 has a factor: 42909033421522517273
    {   55044841, 65,         390060258948ULL }, // M55044841 has a factor: 42941609868422974537
    {   57020573, 65,         378605932083ULL }, // M57020573 has a factor: 43176654377143487119
    {   59007203, 65,         365910827613ULL }, // M59007203 has a factor: 43182748969716592879
    {   57062237, 65,         379067801800ULL }, // M57062237 has a factor: 43260913490761253201
    {   55037111, 65,         394999877713ULL }, // M55037111 has a factor: 43479304229353614287
    {   59010011, 65,         372013994445ULL }, // M59010011 has a factor: 43905099808706777791
    {   53067389, 65,         413825486155ULL }, // M53067389 has a factor: 43921276103802998591
    {   53022187, 65,         414656088068ULL }, // M53022187 has a factor: 43971945284459929433
    {   57038609, 65,         388929425832ULL }, // M57038609 has a factor: 44367986897251895377
    {   53018629, 65,         422711728371ULL }, // M53018629 has a factor: 44823192600901646719
    {   55009481, 65,         410598686628ULL }, // M55009481 has a factor: 45173641301375840137
    {   53071301, 65,         427005365763ULL }, // M53071301 has a factor: 45323460590046535327
    {   55050601, 65,         421647274283ULL }, // M55050601 has a factor: 46423871718581988167
    {   57027931, 65,         410323472181ULL }, // M57027931 has a factor: 46799797318436975023
    {   53016221, 65,         446696785788ULL }, // M53016221 has a factor: 47364351030652534297
    {   57075517, 65,         416477915948ULL }, // M57075517 has a factor: 47541384743629290233
    {   53098781, 65,         448572800416ULL }, // M53098781 has a factor: 47637337783691785793
    {   57098519, 65,         417372157701ULL }, // M57098519 has a factor: 47662664153123089639
    {   53050649, 65,         450084317544ULL }, // M53050649 has a factor: 47754530300862572113
    {   53067881, 65,         451295446024ULL }, // M53067881 has a factor: 47898586050887110289
    {   57049313, 65,         420696729411ULL }, // M57049313 has a factor: 48000918788488889287
    {   55063849, 65,         436192952871ULL }, // M55063849 has a factor: 48036925783505720959
    {   53072399, 65,         459834010761ULL }, // M53072399 has a factor: 48808988185756171279
    {   53040137, 65,         460156027632ULL }, // M53040137 has a factor: 48813477493954131169
    {   53013167, 65,         463139078488ULL }, // M53013167 has a factor: 49104938624220902993
    {   57043247, 65,         430516228449ULL }, // M57043247 has a factor: 49116087113849467807
    {   57069911, 65,         432582836121ULL }, // M57069911 has a factor: 49374927915106110463
    {   53098169, 65,         466488893916ULL }, // M53098169 has a factor: 49539412251549679609
    {   53015737, 65,         469240963064ULL }, // M53015737 has a factor: 49754310974855476337
    {   59055511, 65,         425006285321ULL }, // M59055511 has a factor: 50197926715686908063
    {   53091067, 65,         472969320005ULL }, // M53091067 has a factor: 50220891714659790671
    {   59095297, 65,         425721109688ULL }, // M59095297 has a factor: 50316230832363874673
    {   57050347, 65,         443821333385ULL }, // M57050347 has a factor: 50640322151233869191
    {   57007297, 65,         447002425800ULL }, // M57007297 has a factor: 50964800094602125201
    {   59094097, 65,         431237483972ULL }, // M59094097 has a factor: 50967179415754626569
    {   59060129, 65,         435527939991ULL }, // M59060129 has a factor: 51444672637945437679
    {   59022893, 65,         441697892320ULL }, // M59022893 has a factor: 52140574873457763521
    {   53095501, 65,         492587012184ULL }, // M53095501 has a factor: 52308308396005168369
    {   53075537, 65,         494920498695ULL }, // M53075537 has a factor: 52536342481089848431
    {   53071021, 65,         495766962560ULL }, // M53071021 has a factor: 52621717762255947521
    {   59052289, 65,         445563288927ULL }, // M59052289 has a factor: 52623064211015407807
    {   59065999, 65,         446895560669ULL }, // M59065999 has a factor: 52792665479159186663
    {   55045867, 65,         484124774829ULL }, // M55045867 has a factor: 53298135933284163487
    {   59084573, 65,         453390340251ULL }, // M59084573 has a factor: 53576749312110095647
    {   57073069, 65,         471924182600ULL }, // M57073069 has a factor: 53868322872596798801
    {   59074207, 65,         458654146305ULL }, // M59074207 has a factor: 54189259960459710271
    {   59060933, 65,         459823174332ULL }, // M59060933 has a factor: 54315171382139143513
    {   57085003, 65,         482411768673ULL }, // M57085003 has a factor: 55076954523867022039
    {   59043419, 65,         467456148285ULL }, // M59043419 has a factor: 55200418454634772831
    {   57071743, 65,         484202260845ULL }, // M57071743 has a factor: 55268533981929605671
    {   57010927, 65,         485572073937ULL }, // M57010927 has a factor: 55365828120921819199
    {   57001517, 65,         492314997015ULL }, // M57001517 has a factor: 56125403343410943511
    {   55043477, 65,         510197229900ULL }, // M55043477 has a factor: 56166058978928724601
    {   57073411, 65,         497544403524ULL }, // M57073411 has a factor: 56793112466150200729
    {   53096867, 65,         540837718789ULL }, // M53096867 has a factor: 57433576846245868127
    {   57080171, 65,         504894681988ULL }, // M57080171 has a factor: 57638949569731319897
    {   55039297, 65,         527429916147ULL }, // M55039297 has a factor: 58058743602999657319
    {   55062911, 65,         527490284844ULL }, // M55062911 has a factor: 58090301215459641769
    {   55029497, 65,         531291321520ULL }, // M55029497 has a factor: 58473388367421750881
    {   53001703, 65,         556381475501ULL }, // M53001703 has a factor: 58978331438411556407
    {   57054031, 65,         518700505476ULL }, // M57054031 has a factor: 59187909438286747513
    {   55043333, 65,         545961722896ULL }, // M55043333 has a factor: 60103105837236504737
    {   53057911, 65,         571881757209ULL }, // M53057911 has a factor: 60685702753037460799
    {   55005359, 65,         556633800316ULL }, // M55005359 has a factor: 61235684035831786889
    {   59046139, 65,         523454544164ULL }, // M59046139 has a factor: 61815939549778365593
    {   57057601, 65,         544467244884ULL }, // M57057601 has a factor: 62131989632321126569
    {   57039181, 65,         545092115519ULL }, // M57039181 has a factor: 62183215677522299879
    {   59080673, 65,         526911234303ULL }, // M59080673 has a factor: 62260540667763851839
    {   53026411, 65,         592290674321ULL }, // M53026411 has a factor: 62814097456024983863
    {   59060579, 65,         532556122180ULL }, // M59060579 has a factor: 62906145851891084441
    {   57014977, 65,         552114059364ULL }, // M57014977 has a factor: 62957540792030189257
    {   59082479, 65,         536961536404ULL }, // M59082479 has a factor: 63450037396794131033
    {   53046317, 65,         605327413279ULL }, // M53046317 has a factor: 64220779707175686887
    {   55072987, 65,         583409178977ULL }, // M55072987 has a factor: 64260172258961988599
    {   57087733, 65,         563591448500ULL }, // M57087733 has a factor: 64348316266102501001
    {   59043827, 65,         545125452753ULL }, // M59043827 has a factor: 64372585851289611463
    {   57063211, 65,         565584101013ULL }, // M57063211 has a factor: 64548089788700265487
    {   59021951, 65,         547758575965ULL }, // M59021951 has a factor: 64659559660872015431
    {   59012167, 65,         549707046893ULL }, // M59012167 has a factor: 64878808104653094263
    {   57065443, 65,         568987655177ULL }, // M57065443 has a factor: 64939065208413496823
    {   57094603, 65,         570091742285ULL }, // M57094603 has a factor: 65098323398680775711
    {   57079223, 65,         580729620481ULL }, // M57079223 has a factor: 66295191020280732527
    {   53029709, 65,         627271467772ULL }, // M53029709 has a factor: 66528046799904076697
    {   59089493, 65,         566278194931ULL }, // M59089493 has a factor: 66922182870855919967
    {   57078349, 65,         587375351355ULL }, // M57078349 has a factor: 67052830597276625791
    {   59055307, 65,         568935211725ULL }, // M59055307 has a factor: 67197287183059749151
    {   55067261, 65,         610951725828ULL }, // M55067261 has a factor: 67286876289141834217
    {   57059773, 65,         590744592555ULL }, // M57059773 has a factor: 67415504704331580031
    {   59026273, 65,         573075567152ULL }, // M59026273 has a factor: 67653029752687568993
    {   55091083, 65,         616051776057ULL }, // M55091083 has a factor: 67877919054107199463
    {   55016293, 65,         617781544560ULL }, // M55016293 has a factor: 67976100931011032161
    {   59023799, 65,         576454678992ULL }, // M59023799 has a factor: 68049090210866661217
    {   57000353, 65,         604825689231ULL }, // M57000353 has a factor: 68950555579270597087
    {   59002873, 65,         585431087948ULL }, // M59002873 has a factor: 69084232264895349209
    {   57045959, 65,         607103748637ULL }, // M57045959 has a factor: 69265631106985215767
    {   59015581, 65,         591948471600ULL }, // M59015581 has a factor: 69868365947071999201
    {   59012539, 65,         593961962100ULL }, // M59012539 has a factor: 70102406905885543801
    {   55097989, 65,         646562198912ULL }, // M55097989 has a factor: 71248553846938375937
    {   57018463, 65,         625172255201ULL }, // M57018463 has a factor: 71292722203609552127
    {   59009579, 65,         608499357084ULL }, // M59009579 has a factor: 71814581766595015273
    {   59032733, 65,         609131688667ULL }, // M59032733 has a factor: 71917416677836273823
    {   55066129, 66,         670452484416ULL }, // M55066129 has a factor: 73838445990443891329
    {   53054879, 66,         698717691201ULL }, // M53054879 has a factor: 74140765123656839359
    {   55008671, 66,         675499455201ULL }, // M55008671 has a factor: 74316654583662095743
    {   55080299, 66,         674783424784ULL }, // M55080299 has a factor: 74334545594693460833
    {   57036829, 66,         652112349152ULL }, // M57036829 has a factor: 74388841094741838017
    {   53046827, 66,         707439966933ULL }, // M53046827 has a factor: 75054891077561143183
    {   57028511, 66,         660083040696ULL }, // M57028511 has a factor: 75287105894490567313
    {   57048197, 66,         663927630835ULL }, // M57048197 has a factor: 75751748555236708991
    {   59025289, 66,         644788100604ULL }, // M59025289 has a factor: 76117607963824349113
    {   55095541, 66,         701602867208ULL }, // M55095541 has a factor: 77310379071951839057
    {   55009453, 66,         704202782055ULL }, // M55009453 has a factor: 77475619683847531831
    {   57092741, 66,         679111913256ULL }, // M57092741 has a factor: 77544721147078549393
    {   57083669, 66,         682343521944ULL }, // M57083669 has a factor: 77901343501891065073
    {   59037169, 66,         660899147976ULL }, // M59037169 has a factor: 78035229382030239889
    {   57076249, 66,         689043861596ULL }, // M57076249 has a factor: 78656078032749666809
    {   57088729, 66,         689998351280ULL }, // M57088729 has a factor: 78782257773341446241
    {   53040367, 66,         744940440729ULL }, // M53040367 has a factor: 79023828738815815087
    {   59088739, 66,         671019490517ULL }, // M59088739 has a factor: 79299391078143976127
    {   55062977, 66,         730145554120ULL }, // M55062977 has a factor: 80407975706323630481
    {   59016257, 66,         690132744955ULL }, // M59016257 has a factor: 81458102880759466871
    {   53065927, 66,         767682868517ULL }, // M53065927 has a factor: 81475606119747440519
    {   57081709, 66,         730187226719ULL }, // M57081709 has a factor: 83360669582181965543
    {   53067943, 66,         786101043788ULL }, // M53067943 has a factor: 83433530767964176169
    {   59043143, 66,         708185466628ULL }, // M59043143 has a factor: 83626991553277463609
    {   57003259, 66,         735946519092ULL }, // M57003259 has a factor: 83902700075899441657
    {   55062859, 66,         764513686616ULL }, // M55062859 has a factor: 84192618659413990289
    {   55056887, 66,         771519135600ULL }, // M55056887 has a factor: 84954883734133754401
    {   59048593, 66,         720990391416ULL }, // M59048593 has a factor: 85146936359268155377
    {   59041813, 66,         723185116931ULL }, // M59041813 has a factor: 85396320876446471807
    {   59042531, 66,         723319012753ULL }, // M59042531 has a factor: 85413170466716795687
    {   59006921, 66,         724757068636ULL }, // M59006921 has a factor: 85531366186392059513
    {   55020583, 66,         779241225080ULL }, // M55020583 has a factor: 85748613003071643281
    {   59077663, 66,         731537439108ULL }, // M59077663 has a factor: 86435044599010889209
    {   55068283, 66,         786075869621ULL }, // M55068283 has a factor: 86575696895520661487
    {   53064593, 66,         819037415295ULL }, // M53064593 has a factor: 86923774188802299871
    {   53080151, 66,         820165829601ULL }, // M53080151 has a factor: 87069052160522699503
    {   59061071, 66,         738796990093ULL }, // M59061071 has a factor: 87268282972937939207
    {   59061811, 66,         738969169809ULL }, // M59061811 has a factor: 87289714884172128199
    {   57040127, 66,         766520306508ULL }, // M57040127 has a factor: 87444831262590493033
    {   57097531, 66,         767957805981ULL }, // M57097531 has a factor: 87696989267384265823
    {   55095067, 66,         801461933708ULL }, // M55095067 has a factor: 88313197871183636873
    {   57066797, 66,         775628826759ULL }, // M57066797 has a factor: 88525305608008041847
    {   55080761, 66,         805956949740ULL }, // M55080761 has a factor: 88785444249835904281
    {   55075373, 66,         808794854307ULL }, // M55075373 has a factor: 89089356562877363023
    {   53017463, 66,         850206981372ULL }, // M53017463 has a factor: 90151634354463398473
    {   57063607, 66,         803066313600ULL }, // M57063607 has a factor: 91651721028418310401
    {   53022049, 66,         865609389719ULL }, // M53022049 has a factor: 91792766953081828463
    {   59071561, 66,         778542052715ULL }, // M59071561 has a factor: 91979388716038676231
    {   59063549, 66,         787598916667ULL }, // M59063549 has a factor: 93036774413816542367
    {   57020603, 66,         816719001888ULL }, // M57020603 has a factor: 93139619938423796929
    {   59051227, 66,         789231868800ULL }, // M59051227 has a factor: 93210220480286035201
    {   53043031, 66,         882918058260ULL }, // M53043031 has a factor: 93665299869489972121
    {   57055787, 66,         829242196513ULL }, // M57055787 has a factor: 94626132271315741463
    {   59031067, 66,         803415268845ULL }, // M59031067 has a factor: 94852921128024415231
    {   55023587, 66,         865414203873ULL }, // M55023587 has a factor: 95236387475683504903
    {   57052729, 66,         834678256716ULL }, // M57052729 has a factor: 95241344765220755929
    {   59096899, 66,         807974725997ULL }, // M59096899 has a factor: 95497601553594766607
    {   53095039, 66,         900798691920ULL }, // M53095039 has a factor: 95655883357282769761
    {   57077201, 66,         842450960511ULL }, // M57077201 has a factor: 96169485611458819423
    {   55038901, 66,         876545950175ULL }, // M55038901 has a factor: 96488251547265515351
    {   53093063, 66,         913679425737ULL }, // M53093063 has a factor: 97020078624916724863
    {   59082349, 66,         824971268252ULL }, // M59082349 has a factor: 97482480771674567897
    {   53095019, 66,         924392028832ULL }, // M53095019 has a factor: 98161224668567175617
    {   59012029, 66,         836278671944ULL }, // M59012029 has a factor: 98701002481681628753
    {   55056257, 66,         898685569827ULL }, // M55056257 has a factor: 98956527389173515079
    {   57035107, 66,         870243798317ULL }, // M57035107 has a factor: 99268896306193029839
    {   59039579, 66,         841854118780ULL }, // M59039579 has a factor: 99405425504374387241
    {   59028533, 66,         847026655216ULL }, // M59028533 has a factor: 99997481738594556257
    {   53028523, 66,         949772515385ULL }, // M53028523 has a factor: 100730067353722652711
    {   55082891, 66,         915558438568ULL }, // M55082891 has a factor: 100863211351542680177
    {   59088721, 66,         855434752091ULL }, // M59088721 has a factor: 101093090800018531223
    {   53073359, 66,         958455933721ULL }, // M53073359 has a factor: 101736951712109677679
    {   59008549, 66,         863961270407ULL }, // M59008549 has a factor: 101962201917827418887
    {   59043799, 66,         878862642809ULL }, // M59043799 has a factor: 103782778461246782783
    {   53069161, 66,         988433142135ULL }, // M53069161 has a factor: 104910635115396397471
    {   59002213, 66,         892334601051ULL }, // M59002213 has a factor: 105299432396962251727
    {   53049023, 66,         995370240348ULL }, // M53049023 has a factor: 105606837547473160009
    {   57025081, 66,         933926318568ULL }, // M57025081 has a factor: 106514447928744008017
    {   53077771, 66,        1006453764021ULL }, // M53077771 has a factor: 106840644817589354383
    {   57015349, 66,         937779232964ULL }, // M57015349 has a factor: 106935620504789528873
    {   59078897, 66,         905813217468ULL }, // M59078897 has a factor: 107028891552061145593
    {   57022697, 66,         946770302140ULL }, // M57022697 has a factor: 107974792135055343161
    {   55067953, 66,         999627926840ULL }, // M55067953 has a factor: 110094927385425117041
    {   59065309, 66,         936635600672ULL }, // M59065309 has a factor: 110645342348184575297
    {   59082943, 66,         941162028348ULL }, // M59082943 has a factor: 111213244949298536329
    {   55051291, 66,        1013218454168ULL }, // M55051291 has a factor: 111557967933945461777
    {   57083701, 66,         979476358976ULL }, // M57083701 has a factor: 111824271224709300353
    {   55024213, 66,        1018405521960ULL }, // M55024213 has a factor: 112073924721406434961
    {   57098879, 66,         981520813125ULL }, // M57098879 has a factor: 112087476289211973751
    {   59011409, 66,         958010600016ULL }, // M59011409 has a factor: 113067110687759165089
    {   53061499, 66,        1072343514272ULL }, // M53061499 has a factor: 113800308620400427457
    {   53053487, 66,        1076884936057ULL }, // M53053487 has a factor: 114265001911191761519
    {   59072291, 66,         967294223389ULL }, // M59072291 has a factor: 114280571693308028399
    {   59094767, 66,         973106604009ULL }, // M59094767 has a factor: 115011016060146241807
    {   57063007, 66,        1008179165228ULL }, // M57063007 has a factor: 115059469525319041193
    {   55009901, 66,        1056411157384ULL }, // M55009901 has a factor: 116226146365978517969
    {   55092923, 66,        1066689551137ULL }, // M55092923 has a factor: 117534090611390606903
    {   59001797, 66,        1002513655252ULL }, // M59001797 has a factor: 118300214353812975689
    {   59009297, 66,        1006763702164ULL }, // M59009297 has a factor: 118816836619630037417
    {   55041073, 66,        1084522586931ULL }, // M55041073 has a factor: 119386573754836033927
    {   59064911, 66,        1010813539216ULL }, // M59064911 has a factor: 119407223462776099553
    {   57043697, 66,        1051993423687ULL }, // M57043697 has a factor: 120019188213587701679
    {   55084669, 66,        1095808016411ULL }, // M55084669 has a factor: 120724443743093005919
    {   57016733, 66,        1062121437156ULL }, // M57016733 has a factor: 121117388791799862697
    {   59002217, 66,        1029738831343ULL }, // M59002217 has a factor: 121513747960452174863
    {   53067299, 66,        1153517174185ULL }, // M53067299 has a factor: 122428081568220952631
    {   53005019, 66,        1155251404689ULL }, // M53005019 has a factor: 122468245310634268183
    {   59059549, 66,        1037489024712ULL }, // M59059549 has a factor: 122547267783881149777
    {   57046537, 66,        1091622611835ULL }, // M57046537 has a factor: 124546579432163930791
    {   55050089, 66,        1137516261172ULL }, // M55050089 has a factor: 125240742832931688617
    {   55094107, 66,        1139342206877ULL }, // M55094107 has a factor: 125542082910595147679
    {   59052871, 66,        1066568623104ULL }, // M59052871 has a factor: 125967878625616263169
    {   53002321, 66,        1192590549204ULL }, // M53002321 has a factor: 126420134220953404969
    {   57000193, 66,        1112492966072ULL }, // M57000193 has a factor: 126824627554492903793
    {   59015519, 66,        1074573237349ULL }, // M59015519 has a factor: 126832994611322838263
    {   59034439, 66,        1076845639725ULL }, // M59034439 has a factor: 127141956461522978551
    {   59093963, 66,        1082853068637ULL }, // M59093963 has a factor: 127980158344942676863
    {   55067921, 66,        1162115151520ULL }, // M55067921 has a factor: 127990530713612779841
    {   59050139, 66,        1089889159876ULL }, // M59050139 has a factor: 128716212770542045529
    {   59079421, 66,        1090966922931ULL }, // M59079421 has a factor: 128907388273830205903
    {   59009311, 66,        1094509523585ULL }, // M59009311 has a factor: 129172505739378199871
    {   59061683, 66,        1104399184137ULL }, // M59061683 has a factor: 130455349037916245143
    {   53074111, 66,        1249094956049ULL }, // M53074111 has a factor: 132589208693769494879
    {   57088613, 66,        1162831727443ULL }, // M57088613 has a factor: 132768900944229813119
    {   57090031, 66,        1171596536381ULL }, // M57090031 has a factor: 133772965162967835623
    {   55046197, 66,        1242407349183ULL }, // M55046197 has a factor: 136779599394750414103
    {   57085393, 66,        1198141900692ULL }, // M57085393 has a factor: 136792802541539583913
    {   53001043, 66,        1297977951173ULL }, // M53001043 has a factor: 137588370406344146879
    {   59058347, 66,        1165021565824ULL }, // M59058347 has a factor: 137608495793834265857
    {   57007453, 66,        1207101967136ULL }, // M57007453 has a factor: 137627617315426129217
    {   59079169, 66,        1170741803840ULL }, // M59079169 has a factor: 138332905768856417921
    {   55008467, 66,        1260077669280ULL }, // M55008467 has a factor: 138629881776051587521
    {   55046623, 66,        1259289445973ULL }, // M55046623 has a factor: 138639262760709198359
    {   59006803, 66,        1185003907037ULL }, // M59006803 has a factor: 139846584193525145423
    {   53079317, 66,        1319172291804ULL }, // M53079317 has a factor: 140041528508562035737
    {   55091609, 66,        1286220126624ULL }, // M55091609 has a factor: 141719872607799796033
    {   55091873, 66,        1286342699451ULL }, // M55091873 has a factor: 141734057265263323447
    {   55087433, 66,        1289969137603ULL }, // M55087433 has a factor: 142122176879546086199
    {   53056957, 66,        1342277432924ULL }, // M53056957 has a factor: 142434312081438104537
    {   57024043, 66,        1256983495976ULL }, // M57024043 has a factor: 143356561849651501937
    {   55048751, 66,        1310718428536ULL }, // M55048751 has a factor: 144306824807179117073
    {   59006687, 66,        1225540844788ULL }, // M59006687 has a factor: 144630210068242194713
    {   59012843, 66,        1230152134785ULL }, // M59012843 has a factor: 145189549592364087511
    {   57008929, 66,        1276588744640ULL }, // M57008929 has a factor: 145553914210761781121
    {   55090031, 66,        1325627240388ULL }, // M55090031 has a factor: 146057691534838744057
    {   57061663, 66,        1281780359172ULL }, // M57061663 has a factor: 146281037790183246073
    {   57072629, 66,        1284580800459ULL }, // M57072629 has a factor: 146628806890239073423
    {   53091043, 66,        1388613901301ULL }, // M53091043 has a factor: 147445920688738293887
    {   53081527, 66,        1389759159404ULL }, // M53081527 has a factor: 147541076686801459817
    {   57064607, 67,        1299154528720ULL }, // M57064607 has a factor: 148271485227354026081
    {   59041769, 67,        1262313931567ULL }, // M59041769 has a factor: 149058495106121244047
    {   55066399, 67,        1369804815117ULL }, // M55066399 has a factor: 150860437002707907367
    {   53013887, 67,        1425975591613ULL }, // M53013887 has a factor: 151193017757059459463
    {   53091667, 67,        1426167185697ULL }, // M53091667 has a factor: 151435186618704573799
    {   55061987, 67,        1380710036937ULL }, // M55061987 has a factor: 152049276209189227639
    {   53060869, 67,        1455795834899ULL }, // M53060869 has a factor: 154491584172642934463
    {   53006537, 67,        1459161615915ULL }, // M53006537 has a factor: 154690208365956472711
    {   59000639, 67,        1335623710729ULL }, // M59000639 has a factor: 157605304793124311663
    {   55008979, 67,        1444348516716ULL }, // M55008979 has a factor: 158904274449423185929
    {   55070863, 67,        1449442813817ULL }, // M55070863 has a factor: 159644133252101028143
    {   55047677, 67,        1467079889479ULL }, // M55047677 has a factor: 161518679778471380567
    {   59006053, 67,        1369960382847ULL }, // M59006053 has a factor: 161671909916340745783
    {   59003327, 67,        1375543874877ULL }, // M59003327 has a factor: 162323330104429431559
    {   57099989, 67,        1426245441387ULL }, // M57099989 has a factor: 162877198028995689487
    {   53020067, 67,        1547199933828ULL }, // M53020067 has a factor: 164065288307912252953
    {   55027733, 67,        1500935190835ULL }, // M55027733 has a factor: 165186121863144854111
    {   53017183, 67,        1565922404708ULL }, // M53017183 has a factor: 166041589388408195129
    {   55047457, 67,        1518329781348ULL }, // M55047457 has a factor: 167160386701146864073
    {   59095261, 67,        1414956733580ULL }, // M59095261 has a factor: 167234474949235128761
    {   53038969, 67,        1587672660156ULL }, // M53038969 has a factor: 168417042008323238329
    {   59076179, 67,        1427156074441ULL }, // M59076179 has a factor: 168621855429227681879
    {   57000137, 67,        1485674742424ULL }, // M57000137 has a factor: 169367327711215424177
    {   53081969, 67,        1597083915207ULL }, // M53081969 has a factor: 169552717754833205167
    {   53032379, 67,        1599392627340ULL }, // M53032379 has a factor: 169639191965801283721
    {   53000461, 67,        1602653229455ULL }, // M53000461 has a factor: 169882719968507557511
    {   57069427, 67,        1491210800552ULL }, // M57069427 has a factor: 170205091847427847409
    {   59054389, 67,        1448901616400ULL }, // M59054389 has a factor: 171127999355228759201
    {   53078611, 67,        1615789422140ULL }, // M53078611 has a factor: 171527716391367695081
    {   57060067, 67,        1537223211192ULL }, // M57060067 has a factor: 175428118849141339729
    {   57005297, 67,        1539221972808ULL }, // M57005297 has a factor: 175487611417691927953
    {   55036367, 67,        1611330714025ULL }, // M55036367 has a factor: 177363577070903894351
    {   55036789, 67,        1615574869755ULL }, // M55036789 has a factor: 177832106440816833391
    {   57069869, 67,        1562004266659ULL }, // M57069869 has a factor: 178286757751340395343
    {   55080131, 67,        1620643696048ULL }, // M55080131 has a factor: 178530534165296044577
    {   57074629, 67,        1568178313496ULL }, // M57074629 has a factor: 179006390897259785969
    {   59018087, 67,        1517931833364ULL }, // M59018087 has a factor: 179170866003092109337
    {   53031751, 67,        1695143055609ULL }, // M53031751 has a factor: 179792808868871282719
    {   57043001, 67,        1580996675056ULL }, // M57043001 has a factor: 180369589832432166113
    {   53051147, 67,        1707427438333ULL }, // M53051147 has a factor: 181161968045674835903
    {   55048687, 67,        1659586200725ULL }, // M55048687 has a factor: 182716082626459396151
    {   53065981, 67,        1733307534404ULL }, // M53065981 has a factor: 183959329375679020649
    {   57050129, 67,        1617560655987ULL }, // M57050129 has a factor: 184564088178765944647
    {   55031803, 67,        1677140933580ULL }, // M55031803 has a factor: 184592178920021289481
    {   55002889, 67,        1695952707032ULL }, // M55002889 has a factor: 186564596988261230897
    {   59024747, 67,        1586047377313ULL }, // M59024747 has a factor: 187232090351826729623
    {   53067307, 67,        1776151408149ULL }, // M53067307 has a factor: 188511144109450569487
    {   55015547, 67,        1715526844725ULL }, // M55015547 has a factor: 188761295511459879151
    {   55046279, 67,        1721189385081ULL }, // M55046279 has a factor: 189490142206014327199
    {   59052283, 67,        1620097277337ULL }, // M59052283 has a factor: 191340885817668020743
    {   53070869, 67,        1817290161844ULL }, // M53070869 has a factor: 192890336228423444873
    {   57030073, 67,        1693316983647ULL }, // M57030073 has a factor: 193139982379056432463
    {   55026661, 67,        1764035655504ULL }, // M55026661 has a factor: 194137984014662784289
    {   59063453, 67,        1667310376836ULL }, // M59063453 has a factor: 196954216157330749417
    {   57050359, 67,        1726568450729ULL }, // M57050359 has a factor: 197002699904326523423
    {   55044389, 67,        1820464298539ULL }, // M55044389 has a factor: 200412690018785695343
    {   55096091, 67,        1829575214881ULL }, // M55096091 has a factor: 201604885060856260343
    {   59029519, 67,        1717727651276ULL }, // M59029519 has a factor: 202793274055644032489
    {   59068201, 67,        1744449099431ULL }, // M59068201 has a factor: 206082940078918587263
    {   55004051, 67,        1880539098421ULL }, // M55004051 has a factor: 206874536954085406943
    {   57079961, 67,        1818644796435ULL }, // M57079961 has a factor: 207616348106725478071
    {   55075021, 67,        1889085201584ULL }, // M55075021 has a factor: 208082814296056066529
    {   55084637, 67,        1918464523780ULL }, // M55084637 has a factor: 211355843779598335721
    {   57080213, 67,        1853354362588ULL }, // M57080213 has a factor: 211579723562004542489
    {   55045943, 67,        1922280451821ULL }, // M55045943 has a factor: 211627480361906024407
    {   57040583, 67,        1867796250145ULL }, // M57040583 has a factor: 213080374066969269071
    {   55035179, 67,        1936194876685ULL }, // M55035179 has a factor: 213117663234483803231
    {   59037677, 67,        1804938420468ULL }, // M59037677 has a factor: 213118742944959945673
    {   57031801, 67,        1870097676599ULL }, // M57031801 has a factor: 213310077084713049599
    {   53055839, 67,        2014477664781ULL }, // M53055839 has a factor: 213759605303433412519
    {   57073829, 67,        1874251634716ULL }, // M57073829 has a factor: 213941434605502895129
    {   57079441, 67,        1894638074535ULL }, // M57079441 has a factor: 216289764383548269871
    {   59028127, 67,        1842892707020ULL }, // M59028127 has a factor: 217565009514700703081
    {   57058129, 67,        1931593697327ULL }, // M57058129 has a factor: 220426244715341842367
    {   57040877, 67,        1939352446407ULL }, // M57040877 has a factor: 221244728710301557879
    {   53028541, 67,        2087251328675ULL }, // M53028541 has a factor: 221367785319893426351
    {   53059351, 67,        2089112346744ULL }, // M53059351 has a factor: 221693890568647206289
    {   55081387, 67,        2017187651684ULL }, // M55081387 has a factor: 222218987388055211417
    {   55099903, 67,        2026736818613ULL }, // M55099903 has a factor: 223346004224209789079
    {   55003027, 67,        2039647673853ULL }, // M55003027 has a factor: 224373592150847506063
    {   59084407, 67,        1899195045444ULL }, // M59084407 has a factor: 224425626074793583417
    {   53056537, 67,        2124928149579ULL }, // M53056537 has a factor: 225482657980959495847
    {   53082853, 67,        2126612335791ULL }, // M53082853 has a factor: 225773300017560583447
    {   59068187, 67,        1923285505668ULL }, // M59068187 has a factor: 227209975806373967833
    {   53085947, 67,        2150089827408ULL }, // M53085947 has a factor: 228279109246040470753
    {   59078801, 67,        1956560690280ULL }, // M59078801 has a factor: 231182519330949508561
    {   53034463, 67,        2204193298317ULL }, // M53034463 has a factor: 233796415848881797543
    {   57072187, 67,        2083846378524ULL }, // M57072187 has a factor: 237859340388789023977
    {   55054829, 67,        2165631725451ULL }, // M55054829 has a factor: 238456968643359505759
    {   59099087, 67,        2017471156384ULL }, // M59099087 has a factor: 238461406782257242817
    {   57038411, 67,        2094682151265ULL }, // M57038411 has a factor: 238954682916434479831
    {   59050837, 67,        2023316932427ULL }, // M59050837 has a factor: 238957116752173582799
    {   53036383, 67,        2256186241661ULL }, // M53036383 has a factor: 239319915264126704327
    {   59027411, 67,        2043832539216ULL }, // M59027411 has a factor: 241284286614952899553
    {   53078581, 67,        2303940958559ULL }, // M53078581 has a factor: 244579833576183049559
    {   59032361, 67,        2071902632811ULL }, // M59032361 has a factor: 244618608353898793543
    {   55067393, 67,        2243774321788ULL }, // M55067393 has a factor: 247117604762416517369
    {   59093291, 67,        2091140866948ULL }, // M59093291 has a factor: 247144791545100891737
    {   57032021, 67,        2208398753076ULL }, // M57032021 has a factor: 251898888123608493193
    {   53096447, 67,        2373532279908ULL }, // M53096447 has a factor: 252052261805848573753
    {   53014613, 67,        2388135374268ULL }, // M53014613 has a factor: 253212145316856356569
    {   57077509, 67,        2254504330727ULL }, // M57077509 has a factor: 257362982455218638087
    {   55001567, 67,        2343019925865ULL }, // M55001567 has a factor: 257739534869597660911
    {   59039683, 67,        2221958549732ULL }, // M59039683 has a factor: 262367456830634029913
    {   55071871, 67,        2390442082496ULL }, // M55071871 has a factor: 263292236000382140033
    {   59067557, 67,        2246581859248ULL }, // M59067557 has a factor: 265400204052594434273
    {   55019849, 67,        2413489868727ULL }, // M55019849 has a factor: 265579696280778724447
    {   59061241, 67,        2251102231560ULL }, // M59061241 has a factor: 265905782827605931921
    {   53097743, 67,        2515557847080ULL }, // M53097743 has a factor: 267140888131774280881
    {   53066219, 67,        2520627275200ULL }, // M53066219 has a factor: 267520318006272937601
    {   57046229, 67,        2346967122031ULL }, // M57046229 has a factor: 267771247797702742199
    {   59042261, 67,        2271360283108ULL }, // M59042261 has a factor: 268212493320592854377
    {   53030447, 67,        2602928759485ULL }, // M53030447 has a factor: 276068951249290079591
    {   59047889, 67,        2344135982611ULL }, // M59047889 has a factor: 276832562604240516359
    {   53003527, 67,        2657202098325ULL }, // M53003527 has a factor: 281682166326051584551
    {   55098647, 67,        2559256176820ULL }, // M55098647 has a factor: 282023105338349525081
    {   55098149, 67,        2566170201207ULL }, // M55098149 has a factor: 282782456210926531687
    {   55053953, 67,        2581691632315ULL }, // M55053953 has a factor: 284264659571926582391
    {   59057071, 67,        2441114587884ULL }, // M59057071 has a factor: 288330155071602255529
    {   57001573, 67,        2532281485928ULL }, // M57001573 has a factor: 288688055953346729489
    {   59035751, 67,        2446672014496ULL }, // M59035751 has a factor: 288882239652908492993
    {   53085559, 67,        2765310741084ULL }, // M53085559 has a factor: 293596132998296811913
    {   53074279, 67,        2777686385792ULL }, // M53074279 has a factor: 294847404428052487937
    {   57040693, 68,        2609662118972ULL }, // M57040693 has a factor: 297713871524022655193
    {   59052193, 68,        2523493909056ULL }, // M59052193 has a factor: 298035698703798719617
    {   57024587, 68,        2616279566980ULL }, // M57024587 has a factor: 298384523567146674521
    {   55068203, 68,        2709618578961ULL }, // M55068203 has a factor: 298427651917591754167
    {   57067561, 68,        2628007623611ULL }, // M57067561 has a factor: 299947970737771565543
    {   53030099, 68,        2835137388381ULL }, // M53030099 has a factor: 300695232768891759439
    {   57056347, 68,        2678555125032ULL }, // M57056347 has a factor: 305657141344908356209
    {   53042987, 68,        2898552201429ULL }, // M53042987 has a factor: 307495733478439656847
    {   57076979, 68,        2716769223196ULL }, // M57076979 has a factor: 310129959800408809769
    {   55091093, 68,        2844246932440ULL }, // M55091093 has a factor: 313385344540033513841
    {   59041369, 68,        2657399617392ULL }, // M59041369 has a factor: 313793022781799779297
    {   55029893, 68,        2905046310252ULL }, // M55029893 has a factor: 319728775226424726073
    {   59013961, 68,        2714717152923ULL }, // M59013961 has a factor: 320412424377257916007
    {   57082433, 68,        2816254988136ULL }, // M57082433 has a factor: 321517373342378029777
    {   53006483, 68,        3036453963900ULL }, // M53006483 has a factor: 321903490835495927401
    {   55071167, 68,        2959045933732ULL }, // M55071167 has a factor: 325916225554451810489
    {   55070473, 68,        2972652291608ULL }, // M55070473 has a factor: 327410735526772981169
    {   55049053, 68,        2982699370296ULL }, // M55049053 has a factor: 328389551436982259377
    {   55005991, 68,        3000835073285ULL }, // M55005991 has a factor: 330127814067198100871
    {   59016383, 68,        2799008951661ULL }, // M59016383 has a factor: 330374768623308124327
    {   53041847, 68,        3121605233229ULL }, // M53041847 has a factor: 331151414350663867927
    {   55075367, 68,        3032689163845ULL }, // M55075367 has a factor: 334052937391373012231
    {   59064701, 68,        2829799263288ULL }, // M59064701 has a factor: 334282494752251993777
    {   57053993, 68,        2937048869832ULL }, // M57053993 has a factor: 335140731320105678353
    {   55094173, 68,        3048960418716ULL }, // M55094173 has a factor: 335959905557783483737
    {   57038291, 68,        2951525213661ULL }, // M57038291 has a factor: 336699908061266586703
    {   57050471, 68,        2972171204304ULL }, // M57050471 has a factor: 339127534196360854369
    {   57074371, 68,        2976698063453ULL }, // M57074371 has a factor: 339786339256996126127
    {   55066061, 68,        3093727785408ULL }, // M55066061 has a factor: 340718805897343675777
    {   59088833, 68,        2896403756367ULL }, // M59088833 has a factor: 342290235721084699423
    {   55056137, 68,        3118789629360ULL }, // M55056137 has a factor: 343417018216446764641
    {   55012381, 68,        3145477594424ULL }, // M55012381 has a factor: 346080423702833127089
    {   59076593, 68,        2931701183611ULL }, // M59076593 has a factor: 346389835243610634647
    {   53097127, 68,        3299532798060ULL }, // M53097127 has a factor: 350391424038514347241
    {   59063843, 68,        2971392152476ULL }, // M59063843 has a factor: 351003679170549050537
    {   57065537, 68,        3090559300179ULL }, // M57065537 has a factor: 352728852190117662247
    {   53051491, 68,        3337130398905ULL }, // M53051491 has a factor: 354079486646670034711
    {   59013301, 68,        3022128279560ULL }, // M59013301 has a factor: 356691531644572855121
    {   53078867, 68,        3384185201769ULL }, // M53078867 has a factor: 359257432456129831447
    {   55000513, 68,        3281572369968ULL }, // M55000513 has a factor: 360976327589731587169
    {   59096299, 68,        3064779354969ULL }, // M59096299 has a factor: 362234234260550319463
    {   55077817, 68,        3298529534223ULL }, // M55077817 has a factor: 363351612110059262383
    {   59066401, 68,        3083700591015ULL }, // M59066401 has a factor: 364286191345657974031
    {   53014837, 68,        3507412723788ULL }, // M53014837 has a factor: 371889827686693685113
    {   53046871, 68,        3530491659041ULL }, // M53046871 has a factor: 374563071207447821423
    {   55083803, 68,        3435104485081ULL }, // M55083803 has a factor: 378437237481236486087
    {   53058283, 68,        3570862262048ULL }, // M53058283 has a factor: 378927640907525887169
    {   55068203, 68,        3442791592641ULL }, // M55068203 has a factor: 379176692620495788247
    {   57079717, 68,        3375285473979ULL }, // M57079717 has a factor: 385320679297864367887
    {   53003437, 68,        3646354394712ULL }, // M53003437 has a factor: 386538630879581250289
    {   55084031, 68,        3597672773733ULL }, // M55084031 has a factor: 396348637192329115447
    {   55083517, 68,        3617601286479ULL }, // M55083517 has a factor: 398540403925975733287
    {   53031871, 68,        3812750158605ULL }, // M53031871 has a factor: 404394549132739799911
    {   59079967, 68,        3432242018900ULL }, // M59079967 has a factor: 405553490425250752601
    {   59070103, 68,        3439651268613ULL }, // M59070103 has a factor: 406361109442101154279
    {   53038771, 68,        3842264275236ULL }, // M53038771 has a factor: 407577950031446349913
    {   53031287, 68,        3885344849245ULL }, // M53031287 has a factor: 412089675588566656631
    {   53058727, 68,        3898540534512ULL }, // M53058727 has a factor: 413703195838212572449
    {   53069501, 68,        3904816707024ULL }, // M53069501 has a factor: 414453348276453750049
    {   55047137, 68,        3767277625032ULL }, // M55047137 has a factor: 414755695084342266769
    {   57083549, 68,        3643681611324ULL }, // M57083549 has a factor: 415988555600825017753
    {   59049979, 68,        3523687592477ULL }, // M59049979 has a factor: 416147356676654815967
    {   53042021, 68,        3931602948571ULL }, // M53042021 has a factor: 417080332323529803983
    {   55085917, 68,        3810198453528ULL }, // M55085917 has a factor: 419776551529143530353
    {   57006679, 68,        3685796173961ULL }, // M57006679 has a factor: 420229998696845771039
    {   53065567, 68,        3986350942857ULL }, // M53065567 has a factor: 423075946087382609839
    {   59037749, 68,        3602365531855ULL }, // M59037749 has a factor: 425351104151813988791
    {   57042071, 68,        3734744076645ULL }, // M57042071 has a factor: 426075073573627063591
    {   55033673, 68,        3920704503003ULL }, // M55033673 has a factor: 431541539095789240039
    {   57069469, 68,        3805903857255ULL }, // M57069469 has a factor: 434401824397189295191
    {   53014669, 68,        4108689179679ULL }, // M53014669 has a factor: 435641593769127422503
    {   53077097, 68,        4154812754607ULL }, // M53077097 has a factor: 441050799186225871759
    {   57011179, 68,        3868984813920ULL }, // M57011179 has a factor: 441150771549349623361
    {   53026759, 68,        4164367352957ULL }, // M53026759 has a factor: 441645808025437552727
    {   57040481, 68,        3898033275579ULL }, // M57040481 has a factor: 444691385986063426999
    {   59084479, 68,        3769750896912ULL }, // M59084479 has a factor: 445467535407656457697
    {   53024077, 68,        4240362826035ULL }, // M53024077 has a factor: 449682649991234889391
    {   55015201, 68,        4107304039004ULL }, // M55015201 has a factor: 451928314547833799609
    {   53060101, 68,        4317376765100ULL }, // M53060101 has a factor: 458160894422518550201
    {   55069327, 68,        4172208296660ULL }, // M55069327 has a factor: 459521406001765095641
    {   59096057, 68,        3902566339975ULL }, // M59096057 has a factor: 461252565746887957151
    {   59014489, 68,        3940188444167ULL }, // M59014489 has a factor: 465056415192441071327
    {   55067347, 68,        4253234259113ULL }, // M55067347 has a factor: 468428653637726966423
    {   57000469, 68,        4127247410915ULL }, // M57000469 has a factor: 470510076202381438271
    {   59056169, 68,        3998322399292ULL }, // M59056169 has a factor: 472251206658147664697
    {   55010849, 68,        4296158264152ULL }, // M55010849 has a factor: 472670627098735570097
    {   57015797, 68,        4162055069992ULL }, // M57015797 has a factor: 474605773946969327249
    {   55003643, 68,        4328694313773ULL }, // M55003643 has a factor: 476187913381800150079
    {   57042437, 68,        4185079138347ULL }, // M57042437 has a factor: 477454226178346063279
    {   57026111, 68,        4232947058449ULL }, // M57026111 has a factor: 482777017624472323679
    {   55001311, 68,        4406379333528ULL }, // M55001311 has a factor: 484713280214692510417
    {   59051131, 68,        4120919389868ULL }, // M59051131 has a factor: 486689901463070681417
    {   59014147, 68,        4159081536089ULL }, // M59014147 has a factor: 490889298311484102167
    {   57088379, 68,        4320532347436ULL }, // M57088379 has a factor: 493304376264372092489
    {   55095149, 68,        4477524583975ULL }, // M55095149 has a factor: 493379768210531274551
    {   55089869, 68,        4612344080932ULL }, // M55089869 has a factor: 508186862402938555817
    {   55002137, 68,        4630400697840ULL }, // M55002137 has a factor: 509363867094982568161
    {   53013907, 68,        4829274010773ULL }, // M53013907 has a factor: 512037366569273640223
    {   55077601, 68,        4694486049504ULL }, // M55077601 has a factor: 517122059069295119809
    {   55089943, 68,        4712596779452ULL }, // M55089943 has a factor: 519233375923988502473
    {   53029351, 68,        4908542975688ULL }, // M53029351 has a factor: 520593696712686836977
    {   55053839, 68,        4764263056401ULL }, // M55053839 has a factor: 524581942521497146879
    {   57073361, 68,        4613666192415ULL }, // M57073361 has a factor: 526634872266393513631
    {   55009847, 68,        4797522905680ULL }, // M55009847 has a factor: 527822002040904461921
    {   59061713, 68,        4477943524672ULL }, // M59061713 has a factor: 528950030568772166273
    {   53006227, 68,        4996467592013ULL }, // M53006227 has a factor: 529687790760768929903
    {   59086823, 68,        4487564228440ULL }, // M59086823 has a factor: 530311826533931692241
    {   55006153, 68,        4878313194111ULL }, // M55006153 has a factor: 536674483874376729967
    {   57059953, 68,        4779096096860ULL }, // M57059953 has a factor: 545389997338630095161
    {   57004261, 68,        4786912234503ULL }, // M57004261 has a factor: 545748788799404434567
    {   57060649, 68,        4785531975396ULL }, // M57060649 has a factor: 546131120652695584009
    {   57062329, 68,        4796452128980ULL }, // M57062329 has a factor: 547393458833214388841
    {   57046559, 68,        4809574122537ULL }, // M57046559 has a factor: 548739307892360400367
    {   55002251, 68,        5024509893309ULL }, // M55002251 has a factor: 552718708607529677119
    {   53029531, 68,        5222428128593ULL }, // M53029531 has a factor: 553885828680988959767
    {   53056543, 68,        5239943972720ULL }, // M53056543 has a factor: 556026625412419013921
    {   53077679, 68,        5268962648869ULL }, // M53077679 has a factor: 559328616279316990103
    {   57078811, 68,        4900564167789ULL }, // M57078811 has a factor: 559436751853201237759
    {   55030463, 68,        5111816961997ULL }, // M55030463 has a factor: 562611308379896629223
    {   59057731, 68,        4764575353364ULL }, // M59057731 has a factor: 562770019096402114169
    {   57009761, 68,        4947977295996ULL }, // M57009761 has a factor: 564166006156316433913
    {   59020963, 68,        4789394683665ULL }, // M59020963 has a factor: 565349372833977338791
    {   57027329, 68,        4957030081716ULL }, // M57027329 has a factor: 565372370665830433129
    {   57002573, 68,        5004894313863ULL }, // M57002573 has a factor: 570583706966521138999
    {   59017171, 68,        4858064868281ULL }, // M59017171 has a factor: 573418490120864506103
    {   57036839, 68,        5033404440009ULL }, // M57036839 has a factor: 574178957333356983103
    {   59086603, 68,        4859446476348ULL }, // M59086603 has a factor: 574256369495446331689
    {   53092363, 68,        5431798484988ULL }, // M53092363 has a factor: 576774033815665893289
    {   53050819, 68,        5473591595724ULL }, // M53050819 has a factor: 580757034049350195913
    {   53016419, 68,        5491188934404ULL }, // M53016419 has a factor: 582246346709051958553
    {   59010139, 68,        4972007374484ULL }, // M59010139 has a factor: 586797692554651786553
    {   55066493, 68,        5337149285391ULL }, // M55066493 has a factor: 587796187527877007527
    {   55044889, 68,        5355821776331ULL }, // M55044889 has a factor: 589621230363845444519
    {   53002811, 69,        5691243157221ULL }, // M53002811 has a factor: 603303770834455896463
    {   59074789, 69,        5126224802772ULL }, // M59074789 has a factor: 605661297180645030217
    {   59051777, 69,        5165052768960ULL }, // M59051777 has a factor: 610011088611716883841
    {   53035417, 69,        5754966795075ULL }, // M53035417 has a factor: 610434127595912342551
    {   57073273, 69,        5358575497028ULL }, // M57073273 has a factor: 611662884465979465289
    {   57049357, 69,        5384897502620ULL }, // M57049357 has a factor: 614409880070753630681
    {   59059783, 69,        5202678477501ULL }, // M59059783 has a factor: 614538123799958884567
    {   55097759, 69,        5592027381877ULL }, // M55097759 has a factor: 616216354016119827287
    {   53070833, 69,        5947687866607ULL }, // M53070833 has a factor: 631297499009652747263
    {   57096113, 69,        5531349392412ULL }, // M57096113 has a factor: 631637099903273789113
    {   57061003, 69,        5576211869237ULL }, // M57061003 has a factor: 636368484398336129423
    {   59049223, 69,        5396181837341ULL }, // M59049223 has a factor: 637280689323396872087
    {   55028569, 69,        5813320632231ULL }, // M55028569 has a factor: 639797431059694414879
    {   53007761, 69,        6095357885739ULL }, // M53007761 has a factor: 646202548033436440759
    {   53048341, 69,        6109380870903ULL }, // M53048341 has a factor: 648185039477078643847
    {   59084371, 69,        5592241206885ULL }, // M59084371 has a factor: 660828108378162188671
    {   55089043, 69,        6021647269121ULL }, // M55089043 has a factor: 663453570678878682407
    {   55038169, 69,        6047735595671ULL }, // M55038169 has a factor: 665712587563712332799
    {   55093721, 69,        6058180355208ULL }, // M55093721 has a factor: 667535396515020897937
    {   53047277, 69,        6380811402564ULL }, // M53047277 has a factor: 676969339913142036457
    {   53044591, 69,        6496663464549ULL }, // M53044591 has a factor: 689225712683289408919
    {   53021497, 69,        6616832560335ULL }, // M53021497 has a factor: 701668735494609042991
    {   57093929, 69,        6150102728260ULL }, // M57093929 has a factor: 702267057019965467081
    {   57088123, 69,        6176662232420ULL }, // M57088123 has a factor: 705228106507695095321
    {   57080197, 69,        6295902292763ULL }, // M57080197 has a factor: 718742686327327428623
    {   57057853, 69,        6324800522540ULL }, // M57057853 has a factor: 721759076938821013241
    {   57029363, 69,        6387945890616ULL }, // M57029363 has a factor: 728600970040596315217
    {   59081557, 69,        6177607456463ULL }, // M59081557 has a factor: 729965334125287505783
    {   55006321, 69,        6645757454171ULL }, // M55006321 has a factor: 731117335624545629783
    {   59087521, 69,        6212753238579ULL }, // M59087521 has a factor: 734192374904709345319
    {   53012441, 69,        6996460321891ULL }, // M53012441 has a factor: 741798880046175291863
    {   59042791, 69,        6291711538161ULL }, // M59042791 has a factor: 742960418759856894703
    {   59054077, 69,        6309560592819ULL }, // M59054077 has a factor: 745210554168997746127
    {   53019667, 69,        7057902143948ULL }, // M53019667 has a factor: 748415242781418050633
    {   57013289, 69,        6661235842800ULL }, // M57013289 has a factor: 759557928405429938401
    {   55062379, 69,        6993301452369ULL }, // M55062379 has a factor: 770135630063184651703
    {   55042399, 69,        7075521779700ULL }, // M55042399 has a factor: 778907385862875000601
    {   53070517, 69,        7349211010899ULL }, // M53070517 has a factor: 780052855781005129567
    {   55013027, 69,        7089986336169ULL }, // M55013027 has a factor: 780083219482592547127
    {   57020027, 69,        6956512595844ULL }, // M57020027 has a factor: 793321072081729935577
    {   59028451, 69,        6769899304973ULL }, // M59028451 has a factor: 799233338797065573647
    {   57035659, 69,        7031840265449ULL }, // M57035659 has a factor: 802131287045237291783
    {   59006797, 69,        6830747241300ULL }, // M59006797 has a factor: 806121031651398232201
    {   55014343, 69,        7362888174861ULL }, // M55014343 has a factor: 810128911044894062647
    {   53054663, 69,        7700803157932ULL }, // M53054663 has a factor: 817127032746836073833
    {   57017273, 69,        7226606422908ULL }, // M57017273 has a factor: 824082782556997779769
    {   53034743, 69,        7789372933561ULL }, // M53034743 has a factor: 826214783325127419647
    {   53069323, 69,        7825737636321ULL }, // M53069323 has a factor: 830613196670351361367
    {   59084507, 69,        7044781406505ULL }, // M59084507 has a factor: 832474872652229036071
    {   59086873, 69,        7093633081163ULL }, // M59086873 has a factor: 838281193950553746599
    {   59046557, 69,        7103113440100ULL }, // M59046557 has a factor: 838828785236661471401
    {   57004153, 69,        7358182255563ULL }, // M57004153 has a factor: 838893894195996706279
    {   53008009, 69,        7920653693732ULL }, // M53008009 has a factor: 839716164566458199177
    {   53010071, 69,        7936574973061ULL }, // M53010071 has a factor: 841436805637573394663
    {   55045787, 69,        7697617396680ULL }, // M55045787 has a factor: 847442815250283574321
    {   59085017, 69,        7238974619580ULL }, // M59085017 has a factor: 855429876920905665721
    {   59017643, 69,        7284767834641ULL }, // M59017643 has a factor: 859859654805451142327
    {   53086769, 69,        8103584765199ULL }, // M53086769 has a factor: 860386265004077104063
    {   59029081, 69,        7310384771339ULL }, // M59029081 has a factor: 863050589617072618919
    {   53060773, 69,        8198754064032ULL }, // M53060773 has a factor: 870064456548858833473
    {   55060471, 69,        7917442096544ULL }, // M55060471 has a factor: 871876181901880224449
    {   57005603, 69,        7652438728672ULL }, // M57005603 has a factor: 872463768297001498433
    {   55008917, 69,        7988270476092ULL }, // M55008917 has a factor: 878852215185790624729
    {   53025851, 69,        8288961675529ULL }, // M53025851 has a factor: 879058493502622200359
    {   53068439, 69,        8305856952652ULL }, // M53068439 has a factor: 881557726069077100457
    {   57087197, 69,        7722982156015ULL }, // M57087197 has a factor: 881766807535826079911
    {   53040397, 69,        8434600554924ULL }, // M53040397 has a factor: 894749123939178529657
    {   53015381, 69,        8484482169120ULL }, // M53015381 has a factor: 899616109567206469441
    {   55051651, 69,        8198158202309ULL }, // M55051651 has a factor: 902644288392604924319
    {   55049609, 69,        8229378260484ULL }, // M55049609 has a factor: 906048111105488701513
    {   59030779, 69,        7699181750444ULL }, // M59030779 has a factor: 908977392782585831753
    {   59090033, 69,        7695478905115ULL }, // M59090033 has a factor: 909452204908098437591
    {   55044151, 69,        8321117487825ULL }, // M55044151 has a factor: 916057694977159923151
    {   55004471, 69,        8332847872668ULL }, // M55004471 has a factor: 916687778319157397257
    {   59092183, 69,        7776017492628ULL }, // M59092183 has a factor: 919003697371149853849
    {   53026381, 69,        8723846744715ULL }, // M53026381 has a factor: 925188042541734652831
    {   59018051, 69,        7896569951313ULL }, // M59018051 has a factor: 932080336223316301927
    {   59096003, 69,        8062786048776ULL }, // M59096003 has a factor: 952956857053649284657
    {   57068383, 69,        8371157892656ULL }, // M57068383 has a factor: 955456889543130990497
    {   59001907, 69,        8100351509777ULL }, // M59001907 has a factor: 955872372894344289479
    {   59011483, 69,        8110792078917ULL }, // M59011483 has a factor: 957259737763090407823
    {   57099697, 69,        8389059104127ULL }, // M57099697 has a factor: 958025465921486299039
    {   53003033, 69,        9196350832588ULL }, // M53003033 has a factor: 974868973318478478809
    {   59095877, 69,        8343309601368ULL }, // M59095877 has a factor: 986110395950724719473
    {   57017027, 69,        8695743071800ULL }, // M57017027 has a factor: 991610835019767077201
    {   53005499, 69,        9394411521181ULL }, // M53005499 has a factor: 995910940983095948639
    {   59092021, 69,        8458651347296ULL }, // M59092021 has a factor: 999677606092187050433
    {   57069547, 69,        8823977710245ULL }, // M57069547 has a factor: 1007160821323558818031
    {   55041587, 69,        9170899243213ULL }, // M55041587 has a factor: 1009561697127084998063
    {   59022671, 69,        8556629094348ULL }, // M59022671 has a factor: 1010070207809459927017
    {   57041741, 69,        8896741602568ULL }, // M57041741 has a factor: 1014971260475217581777
    {   53094857, 69,        9620400259872ULL }, // M53094857 has a factor: 1021587552161333356609
    {   53067367, 69,        9739960859937ULL }, // M53067367 has a factor: 1033748155039824751759
    {   55076101, 69,        9406224876848ULL }, // M55076101 has a factor: 1036116382691986019297
    {   57096287, 69,        9095255934457ULL }, // M57096287 has a factor: 1038610686344420122319
    {   53099047, 69,        9795137233113ULL }, // M53099047 has a factor: 1040224904625034286623
    {   53000789, 69,        9940416035932ULL }, // M53000789 has a factor: 1053699785785296700697
    {   53038847, 69,       10004849381044ULL }, // M53038847 has a factor: 1061291351158474832537
    {   59007587, 69,        9031335447649ULL }, // M59007587 has a factor: 1065834624306664625927
    {   55074091, 69,        9767043733040ULL }, // M55074091 has a factor: 1075822110708849333281
    {   55094197, 69,        9771737658195ULL }, // M55094197 has a factor: 1076732079145827988831
    {   59095061, 69,        9168657959856ULL }, // M59095061 has a factor: 1083644802851651742433
    {   59029567, 69,        9243441935445ULL }, // M59029567 has a factor: 1091272750077920604631
    {   59019533, 69,        9269333297212ULL }, // M59019533 has a factor: 1094143444845604883993
    {   55026341, 69,        9948220305291ULL }, // M55026341 has a factor: 1094828325724133340463
    {   59091811, 69,        9270073510769ULL }, // M59091811 has a factor: 1095570863708936425319
    {   59002973, 69,        9463808963971ULL }, // M59002973 has a factor: 1116785729556677771567
    {   55025059, 69,       10153991605964ULL }, // M55025059 has a factor: 1117447974407347703753
    {   59060453, 69,        9484054091043ULL }, // M59060453 has a factor: 1120265061787005644959
    {   53002903, 69,       10654344067080ULL }, // M53002903 has a factor: 1129422330232133466481
    {   53024401, 69,       10663510157919ULL }, // M53024401 has a factor: 1130852477362140763039
    {   55073567, 69,       10312554453793ULL }, // M55073567 has a factor: 1135898317304234379263
    {   55074403, 69,       10414489300173ULL }, // M55074403 has a factor: 1147143561513831543439
    {   53014513, 69,       10982191096211ULL }, // M53014513 has a factor: 1164431025277124620487
    {   53081767, 69,       11039668371645ULL }, // M53081767 has a factor: 1172010208521858593431
    {   59085757, 70,       10973764226567ULL }, // M59085757 has a factor: 1296786332932461412439
    {   53020921, 70,       12449816180120ULL }, // M53020921 has a factor: 1320201440301328581041
    {   55004857, 70,       12513612812099ULL }, // M55004857 has a factor: 1376618966565746729687
    {   59097047, 70,       12428515730764ULL }, // M59097047 has a factor: 1468977156562398907817
    {   57034027, 70,       13489842199065ULL }, // M57034027 has a factor: 1538760048414425169511
    {   59050507, 70,       13034575780373ULL }, // M59050507 has a factor: 1539396616721892598223
    {   53042911, 70,       14787522006068ULL }, // M53042911 has a factor: 1568746427356812767897
    {   53037889, 70,       15060603405876ULL }, // M53037889 has a factor: 1597565223427746471529
    {   59084351, 70,       14538262125580ULL }, // M59084351 has a factor: 1717967564715549597161
    {   59082013, 70,       14574655181292ULL }, // M59082013 has a factor: 1722199933783222601593
    {   53047303, 70,       16559509315437ULL }, // M53047303 has a factor: 1756874616374618232823
    {   53068987, 70,       16616904651920ULL }, // M53068987 has a factor: 1763684593905964010081
    {   53020897, 70,       17135468571228ULL }, // M53020897 has a factor: 1817075828323633903033
    {   55008823, 70,       16848361117653ULL }, // M55008823 has a factor: 1853617029122112104839
    {   55006423, 70,       17783602827497ULL }, // M55006423 has a factor: 1956424759186592026463
    {   55004491, 70,       17991637665993ULL }, // M55004491 has a factor: 1979241744148745949127
    {   59093821, 70,       17247431719376ULL }, // M59093821 has a factor: 2038433285469055151393
    {   55072529, 70,       19072176306211ULL }, // M55072529 has a factor: 2100705965433836355239
    {   59081027, 70,       19739849850384ULL }, // M59081027 has a factor: 2332501203972966128737
    {   53098891, 71,       23701475186585ULL }, // M53098891 has a factor: 2517044094943363154471
    {   53054003, 71,       25965374884605ULL }, // M53054003 has a factor: 2755134154047916647631
    {   53071913, 71,       27494270070736ULL }, // M53071913 has a factor: 2918347018385209675937
    {   53042551, 71,       29448171670221ULL }, // M53042551 has a factor: 3124012295348905147543
    {   59081219, 71,       30371580373636ULL }, // M59081219 has a factor: 3588779982861780684569
    {   53019053, 71,       35529538993632ULL }, // M53019053 has a factor: 3767485021937883340993
    {   53030851, 71,       35904387888264ULL }, // M53030851 has a factor: 3808080488697465665329
    {   53088509, 71,       37594989081195ULL }, // M53088509 has a factor: 3991723832383844976511
    {   53093479, 71,       40458219120456ULL }, // M53093479 has a factor: 4296135214498658212849
    {   53062591, 71,       41349578058845ULL }, // M53062591 has a factor: 4388231497118132334791
    {   53033059, 71,       41935796374196ULL }, // M53033059 has a factor: 4447967126649445091129
    {   53020403, 72,       47592621564828ULL }, // M53020403 has a factor: 5046759950387342371369
    {   53084533, 72,       48070791832748ULL }, // M53084533 has a factor: 5103631070763283373369
    {   53038499, 72,       48630398704200ULL }, // M53038499 has a factor: 5158566706084625991601
    {   53039123, 72,       49332576228388ULL }, // M53039123 has a factor: 5233113156968694447449
    {   55072561, 72,       48482119352744ULL }, // M55072561 has a factor: 5340068950926548914769
    {   53019457, 72,       50821452373619ULL }, // M53019457 has a factor: 5389051617601281009767
    {   53018023, 72,       51815428534757ULL }, // M53018023 has a factor: 5494303163621205850823
    {   53061917, 72,       66681512653668ULL }, // M53061917 has a factor: 7076497779726762323113
    {   53084477, 72,       80861310659188ULL }, // M53084477 has a factor: 8584960771755040449353
    {   53066239, 72,       87283119933537ULL }, // M53066239 has a factor: 9263573806117477114687
    {   53018549, 72,       88611061738447ULL }, // M53018549 has a factor: 9396059837443754906807
    {   53006851, 73,       92775661554729ULL }, // M53006851 has a factor: 9835491336915896896759
    {   53010319, 73,       98474670889584ULL }, // M53010319 has a factor: 10440347434553723234593
    {   59000581, 73,       92940118912844ULL }, // M59000581 has a factor: 10967042028133768724729
    {   53024761, 73,      128817174681435ULL }, // M53024761 has a factor: 13660999800356684024071
    {   53050111, 73,      132402158653128ULL }, // M53050111 has a factor: 14047898426376101794417
    {   53022611, 73,      148020244911336ULL }, // M53022611 has a factor: 15696839732116996436593
    {   53029799, 73,      177872388120297ULL }, // M53029799 has a factor: 18865073979338675460607
    {   53022457, 74,      198472168704800ULL }, // M53022457 has a factor: 21046964061694007387201
    {   53016793, 74,      291083818433787ULL }, // M53016793 has a factor: 30864661095107339170183
    {   57000443, 74,      293378053427736ULL }, // M57000443 has a factor: 33445358023717240974097
    {   53081891, 75,      386157411282960ULL }, // M53081891 has a factor: 40995931229128505754721
    {   57000487, 75,      361521255205517ULL }, // M57000487 has a factor: 41213775215131508173559
    {   53061187, 75,      426643247402852ULL }, // M53061187 has a factor: 45276394265459988610649
    {   53078689, 75,      434339246277140ULL }, // M53078689 has a factor: 46108315547277443738921
    {   57000257, 75,      417712132260144ULL }, // M57000257 has a factor: 47619397781692397714017
    {   57000763, 75,      540877969472528ULL }, // M57000763 has a factor: 61660913899649607077729
    {   53064863, 75,      594278282461813ULL }, // M53064863 has a factor: 63070591285422819153239
    {   53044609, 75,      614917961099460ULL }, // M53044609 has a factor: 65236165627196131622281
    {   53050111, 76,      768920427885728ULL }, // M53050111 has a factor: 81582628099010731431617
    {   53094473, 76,      878919127974691ULL }, // M53094473 has a factor: 93331495818871551965687
    {   53004449, 76,      918534704293932ULL }, // M53004449 has a factor: 97372851776955599406937
    {   53029937, 76,      943037681935699ULL }, // M53029937 has a factor: 100018457723352312041927
    {   53062447, 76,     1028170233829125ULL }, // M53062447 has a factor: 109114457079071104737751
    {   53084827, 76,     1059144150703625ULL }, // M53084827 has a factor: 112448968016327722795751
    {   53088829, 76,     1159130084719931ULL }, // M53088829 has a factor: 123073717712903859501599
    {   53044099, 76,     1267732323953900ULL }, // M53044099 has a factor: 134491437794621486072201
    {   53044039, 76,     1290659778439737ULL }, // M53044039 has a factor: 136923615246577537155487
    {   53059429, 77,     1446495975456587ULL }, // M53059429 has a factor: 153500501017049041017647
    {   53095543, 77,     1525344134793677ULL }, // M53095543 has a factor: 161977950197470946563223
    {   53009771, 77,     2210787761203644ULL }, // M53009771 has a factor: 234386705902015705611049
    {   53065567, 77,     2540078201431413ULL }, // M53065567 has a factor: 269581379966596284912343
    {   53088691, 77,     2551280043119528ULL }, // M53088691 has a factor: 270888235727278596115697
    {   59000327, 78,     3352267850409973ULL }, // M59000327 has a factor: 395569798731550982122343
    {   53051221, 78,     4163773360864388ULL }, // M53051221 has a factor: 441786521522258797635497
    {   53028419, 78,     4965028712418049ULL }, // M53028419 has a factor: 526575245818269611069063
    {   53037371, 78,     5571167425289781ULL }, // M53037371 has a factor: 590960147276417794811503
    {   53082719, 79,     5933623173454032ULL }, // M53082719 has a factor: 629945703136697280146017
    {   53087093, 79,     6002212097998168ULL }, // M53087093 has a factor: 637279983704307716891249
    {   53088883, 79,     6021838563689916ULL }, // M53088883 has a factor: 639385365905243997607657
    {   53082581, 79,     7898168688909744ULL }, // M53082581 has a factor: 838510358361430575138529
    {   53068859, 79,     8268780657335457ULL }, // M53068859 has a factor: 877629509612125366467127
    {   53012683, 79,     9009978447212285ULL }, // M53012683 has a factor: 955286262517794196821311
    {   53034979, 79,     9133825347709872ULL }, // M53034979 has a factor: 968824471010921519225377
    {   53005387, 79,     9700341334900797ULL }, // M53005387 has a factor: 1028340692977026703186879
    {   53023253, 79,    10352781386886511ULL }, // M53023253 has a factor: 1097876293461148710080567
    {   53069609, 79,    10432286715549811ULL }, // M53069609 has a factor: 1107274753940245379587799
    {   53041039, 80,    11447730330473552ULL }, // M53041039 has a factor: 1214399021840261120201057
    {   53081923, 80,    13008353094881957ULL }, // M53081923 has a factor: 1381016794678671471126623
    {   53001709, 80,    14544347121690252ULL }, // M53001709 has a factor: 1541750507477628649281337
    {   53051513, 81,    25400641105665876ULL }, // M53051513 has a factor: 2695084883651135188540777
    {   53070817, 81,    25449238147490279ULL }, // M53070817 has a factor: 2701223721029751212175887
    {   53088911, 81,    33337244996055961ULL }, // M53088911 has a factor: 3539676065161620529096943
    {   53099239, 81,    34022791077796796ULL }, // M53099239 has a factor: 3613168629773999328476489
    {   53046979, 81,    38311654756902632ULL }, // M53046979 has a factor: 4064635090689328049497457
    {   53090729, 81,    39013342094197995ULL }, // M53090729 has a factor: 4142493545014716449776711
    {   59000521, 82,    52458215998362768ULL }, // M59000521 has a factor: 6190124149267876918004257
    {   53023727, 82,    60514352076223044ULL }, // M53023727 has a factor: 6417392968143067752329977
    {   53067871, 82,    64953428965361244ULL }, // M53067871 has a factor: 6893880378682907929983049
    {   53032183, 82,    66201239283267200ULL }, // M53032183 has a factor: 7021592472994029976595201
    {   53070701, 83,   124753600587908599ULL }, // M53070701 has a factor: 13241522070948642945715799
    {   53006321, 84,   190383228169207579ULL }, // M53006321 has a factor: 20183029010706518496213719
    {   53039501, 84,   194225082089011303ULL }, // M53039501 has a factor: 20603202871370394188959607
    {   53042503, 85,   556554380633003408ULL }, // M53042503 has a factor: 59042074808778450335700449
    {   53052781, 85,   575903318987911400ULL }, // M53052781 has a factor: 61106545318877610303206801
    {   53032349, 86,   737953769588724291ULL }, // M53032349 has a factor: 78270843709389626130179119
    {   53025209, 86,   782495269697275984ULL }, // M53025209 has a factor: 82983950434418851564561313
    {   53050747, 86,   823239913109231529ULL }, // M53050747 has a factor: 87346984701319650418804327
    {   53000869, 86,  1271483669602049760ULL }, // M53000869 has a factor: 134779478816435042922482881
    {   53097391, 87,  1660470362901298004ULL }, // M53097391 has a factor: 176333288205764229051815129
    {   53015323, 87,  2589820601322255465ULL }, // M53015323 has a factor: 274600351382307201130980391

    /* some (all) known factors from the primenet server (2013-12-18) http://www.mersenne.org/
for exponents from 100000 to 101000 */
    {     100043, 17,                    1ULL }, // M100043 has a factor: 200087
    {     100403, 17,                    1ULL }, // M100403 has a factor: 200807
    {     100559, 17,                    1ULL }, // M100559 has a factor: 201119
    {     100799, 17,                    1ULL }, // M100799 has a factor: 201599
    {     100811, 17,                    1ULL }, // M100811 has a factor: 201623
    {     100237, 19,                    3ULL }, // M100237 has a factor: 601423
    {     100357, 19,                    3ULL }, // M100357 has a factor: 602143
    {     100769, 19,                    4ULL }, // M100769 has a factor: 806153
    {     100393, 20,                    8ULL }, // M100393 has a factor: 1606289
    {     100019, 20,                    9ULL }, // M100019 has a factor: 1800343
    {     100153, 21,                   12ULL }, // M100153 has a factor: 2403673
    {     100493, 21,                   12ULL }, // M100493 has a factor: 2411833
    {     100769, 21,                   12ULL }, // M100769 has a factor: 2418457
    {     100393, 21,                   15ULL }, // M100393 has a factor: 3011791
    {     100937, 21,                   19ULL }, // M100937 has a factor: 3835607
    {     100459, 21,                   20ULL }, // M100459 has a factor: 4018361
    {     100003, 22,                   32ULL }, // M100003 has a factor: 6400193
    {     100493, 22,                   36ULL }, // M100493 has a factor: 7235497
    {     100109, 22,                   39ULL }, // M100109 has a factor: 7808503
    {     100271, 22,                   40ULL }, // M100271 has a factor: 8021681
    {     100747, 23,                   44ULL }, // M100747 has a factor: 8865737
    {     100043, 23,                   48ULL }, // M100043 has a factor: 9604129
    {     100169, 23,                   55ULL }, // M100169 has a factor: 11018591
    {     100379, 23,                   57ULL }, // M100379 has a factor: 11443207
    {     100511, 23,                   76ULL }, // M100511 has a factor: 15277673
    {     100943, 23,                   81ULL }, // M100943 has a factor: 16352767
    {     100357, 24,                   84ULL }, // M100357 has a factor: 16859977
    {     100829, 24,                  100ULL }, // M100829 has a factor: 20165801
    {     100501, 25,                  168ULL }, // M100501 has a factor: 33768337
    {     100823, 25,                  217ULL }, // M100823 has a factor: 43757183
    {     100043, 25,                  237ULL }, // M100043 has a factor: 47420383
    {     100129, 25,                  267ULL }, // M100129 has a factor: 53468887
    {     100957, 26,                  467ULL }, // M100957 has a factor: 94293839
    {     100931, 26,                  589ULL }, // M100931 has a factor: 118896719
    {     100057, 27,                 1224ULL }, // M100057 has a factor: 244939537
    {     100153, 27,                 1263ULL }, // M100153 has a factor: 252986479
    {     100169, 28,                 1639ULL }, // M100169 has a factor: 328353983
    {     100511, 28,                 2568ULL }, // M100511 has a factor: 516224497
    {     100559, 29,                 3444ULL }, // M100559 has a factor: 692650393
    {     100483, 29,                 5208ULL }, // M100483 has a factor: 1046630929
    {     100811, 29,                 5301ULL }, // M100811 has a factor: 1068798223
    {     100999, 31,                12429ULL }, // M100999 has a factor: 2510633143
    {     100673, 32,                22167ULL }, // M100673 has a factor: 4463236783
    {     100237, 32,                23027ULL }, // M100237 has a factor: 4616314799
    {     100049, 32,                30379ULL }, // M100049 has a factor: 6078777143
    {     100417, 32,                31935ULL }, // M100417 has a factor: 6413633791
    {     100537, 32,                32448ULL }, // M100537 has a factor: 6524449153
    {     100999, 32,                35352ULL }, // M100999 has a factor: 7141033297
    {     100363, 32,                35957ULL }, // M100363 has a factor: 7217504783
    {     100103, 33,                59433ULL }, // M100103 has a factor: 11898843199
    {     100393, 34,               114740ULL }, // M100393 has a factor: 23038185641
    {     100787, 35,               177657ULL }, // M100787 has a factor: 35811032119
    {     100693, 35,               219867ULL }, // M100693 has a factor: 44278135663
    {     100787, 35,               227869ULL }, // M100787 has a factor: 45932465807
    {     100999, 35,               237009ULL }, // M100999 has a factor: 47875343983
    {     100291, 36,               656120ULL }, // M100291 has a factor: 131605861841
    {     100829, 36,               662107ULL }, // M100829 has a factor: 133519173407
    {     100669, 37,               787559ULL }, // M100669 has a factor: 158565553943
    {     100483, 37,               930668ULL }, // M100483 has a factor: 187032625289
    {     100649, 37,              1185099ULL }, // M100649 has a factor: 238558058503
    {     100447, 39,              3510920ULL }, // M100447 has a factor: 705322762481
    {     100523, 40,              6113037ULL }, // M100523 has a factor: 1229001636703
    {     100129, 41,             13268072ULL }, // M100129 has a factor: 2657037562577
    {     100189, 41,             14645492ULL }, // M100189 has a factor: 2934634395977
    {     100213, 42,             23854023ULL }, // M100213 has a factor: 4780966413799
    {     100271, 42,             34663264ULL }, // M100271 has a factor: 6951440289089
    {     100981, 42,             35356236ULL }, // M100981 has a factor: 7140616135033
    {     100379, 42,             42710449ULL }, // M100379 has a factor: 8574464320343
    {     100703, 43,             53904313ULL }, // M100703 has a factor: 10856652064079
    {     100267, 44,            118047837ULL }, // M100267 has a factor: 23672604944959
    {     100189, 45,            268070355ULL }, // M100189 has a factor: 53715401594191
    {     100267, 45,            293651969ULL }, // M100267 has a factor: 58887203951447
    {     100493, 46,            453665007ULL }, // M100493 has a factor: 91180315096903
    {     100403, 46,            518192028ULL }, // M100403 has a factor: 104056068374569
    {     100523, 47,           1321701597ULL }, // M100523 has a factor: 265722819270463
    {     100931, 49,           3698522476ULL }, // M100931 has a factor: 746591144050313
    {     100517, 49,           4971592035ULL }, // M100517 has a factor: 999459033164191
    {     100417, 50,           7113590255ULL }, // M100417 has a factor: 1428650785272671
    {     100271, 51,          18259227193ULL }, // M100271 has a factor: 3661741939738607
    {     100357, 51,          21115638440ULL }, // M100357 has a factor: 4238204253846161
    {     100649, 52,          25828175187ULL }, // M100649 has a factor: 5199160008792727
    {     100193, 53,          48637950732ULL }, // M100193 has a factor: 9746364395382553
    {     100447, 53,          53926266749ULL }, // M100447 has a factor: 10833463432273607
    {     100103, 54,         105546339241ULL }, // M100103 has a factor: 21131010394083647
    {     100823, 54,         162257166637ULL }, // M100823 has a factor: 32718508623684503
    {     100823, 55,         186425135397ULL }, // M100823 has a factor: 37591882852263463
    {     100237, 57,        1195048616883ULL }, // M100237 has a factor: 239576176421002543
    {     100501, 58,        2446117675556ULL }, // M100501 has a factor: 491674545022107113
    {     100981, 58,        2640218499260ULL }, // M100981 has a factor: 533223808547548121
    {     100669, 59,        5238354965519ULL }, // M100669 has a factor: 1054679912047664423
    {     100109, 60,        7697236893639ULL }, // M100109 has a factor: 1541125376370613303
    {     100547, 60,        8052533675733ULL }, // M100547 has a factor: 1619316206987851903
    {     100109, 64,      147190637154712ULL }, // M100109 has a factor: 29470214989842127217
    {     100057, 64,      173873893912808ULL }, // M100057 has a factor: 34794600406467660113
    {     100183, 66,      541916075435685ULL }, // M100183 has a factor: 108581556370746460711
    {     100931, 66,      644890766071380ULL }, // M100931 has a factor: 130178939820700909561
    {     100333, 67,     1041176942158508ULL }, // M100333 has a factor: 208928812275179166329
    {     100291, 68,     1667180850072888ULL }, // M100291 has a factor: 334406469269320020817
    {     100183, 68,     1929570575988300ULL }, // M100183 has a factor: 386620338028471717801
    {     100829, 68,     2260541311306992ULL }, // M100829 has a factor: 455856239755545392737
    {     100459, 68,     2509905825303341ULL }, // M100459 has a factor: 504285258608296667039
    {     100511, 72,    30675493244800389ULL }, // M100511 has a factor: 6166449003056263797559
    {     100501, 73,    76870106980661460ULL }, // M100501 has a factor: 15451045243326914782921
    {     100207, 76,   499740582916255325ULL }, // M100207 has a factor: 100155009184578394704551
    {     100469, 77,   838696466191163767ULL }, // M100469 has a factor: 168525990523520065013447
    {     100799, 78,  1969190014961933644ULL }, // M100799 has a factor: 396984768636295898763113
    {     100393, 78,  2070612562845883112ULL }, // M100393 has a factor: 415750014043573486526033
    {     100931, 78,  2624663732789617893ULL }, // M100931 has a factor: 529819870428377847116767

    /* some (all) known factors from the primenet server (2013-12-18) http://www.mersenne.org/
for exponents from 200000 to 201000 */
    {     200351, 18,                    1ULL }, // M200351 has a factor: 400703
    {     200639, 18,                    1ULL }, // M200639 has a factor: 401279
    {     200713, 20,                    3ULL }, // M200713 has a factor: 1204279
    {     200797, 20,                    3ULL }, // M200797 has a factor: 1204783
    {     200159, 20,                    4ULL }, // M200159 has a factor: 1601273
    {     200201, 20,                    4ULL }, // M200201 has a factor: 1601609
    {     200861, 20,                    4ULL }, // M200861 has a factor: 1606889
    {     200191, 20,                    5ULL }, // M200191 has a factor: 2001911
    {     200597, 21,                    7ULL }, // M200597 has a factor: 2808359
    {     200371, 21,                    9ULL }, // M200371 has a factor: 3606679
    {     200063, 22,                   12ULL }, // M200063 has a factor: 4801513
    {     200201, 22,                   15ULL }, // M200201 has a factor: 6006031
    {     200869, 22,                   15ULL }, // M200869 has a factor: 6026071
    {     200171, 22,                   16ULL }, // M200171 has a factor: 6405473
    {     200909, 22,                   16ULL }, // M200909 has a factor: 6429089
    {     200797, 23,                   27ULL }, // M200797 has a factor: 10843039
    {     200891, 23,                   28ULL }, // M200891 has a factor: 11249897
    {     200467, 23,                   32ULL }, // M200467 has a factor: 12829889
    {     200227, 23,                   33ULL }, // M200227 has a factor: 13214983
    {     200297, 24,                   43ULL }, // M200297 has a factor: 17225543
    {     200573, 24,                   55ULL }, // M200573 has a factor: 22063031
    {     200869, 25,                  152ULL }, // M200869 has a factor: 61064177
    {     200191, 26,                  321ULL }, // M200191 has a factor: 128522623
    {     200029, 27,                  347ULL }, // M200029 has a factor: 138820127
    {     200609, 27,                  375ULL }, // M200609 has a factor: 150456751
    {     200689, 27,                  491ULL }, // M200689 has a factor: 197076599
    {     200009, 27,                  507ULL }, // M200009 has a factor: 202809127
    {     200401, 27,                  531ULL }, // M200401 has a factor: 212825863
    {     200171, 27,                  624ULL }, // M200171 has a factor: 249813409
    {     200257, 27,                  639ULL }, // M200257 has a factor: 255928447
    {     200237, 28,                  780ULL }, // M200237 has a factor: 312369721
    {     200591, 29,                 1885ULL }, // M200591 has a factor: 756228071
    {     200983, 29,                 2240ULL }, // M200983 has a factor: 900403841
    {     200689, 30,                 2964ULL }, // M200689 has a factor: 1189684393
    {     200989, 30,                 4320ULL }, // M200989 has a factor: 1736544961
    {     200351, 31,                 5493ULL }, // M200351 has a factor: 2201056087
    {     200029, 31,                 5607ULL }, // M200029 has a factor: 2243125207
    {     200363, 31,                 7900ULL }, // M200363 has a factor: 3165735401
    {     200063, 32,                10773ULL }, // M200063 has a factor: 4310557399
    {     200201, 32,                11064ULL }, // M200201 has a factor: 4430047729
    {     200351, 32,                18904ULL }, // M200351 has a factor: 7574870609
    {     200771, 33,                22381ULL }, // M200771 has a factor: 8986911503
    {     200569, 33,                25911ULL }, // M200569 has a factor: 10393886719
    {     200293, 33,                29003ULL }, // M200293 has a factor: 11618195759
    {     200869, 33,                35535ULL }, // M200869 has a factor: 14275759831
    {     200843, 33,                36780ULL }, // M200843 has a factor: 14774011081
    {     200609, 34,                80331ULL }, // M200609 has a factor: 32230243159
    {     200971, 35,               131709ULL }, // M200971 has a factor: 52939378879
    {     200003, 35,               162777ULL }, // M200003 has a factor: 65111776663
    {     200989, 36,               178415ULL }, // M200989 has a factor: 71718904871
    {     200257, 36,               193139ULL }, // M200257 has a factor: 77354873447
    {     200009, 36,               296959ULL }, // M200009 has a factor: 118788945263
    {     200293, 36,               311060ULL }, // M200293 has a factor: 124606281161
    {     200437, 36,               324492ULL }, // M200437 has a factor: 130080406009
    {     200273, 37,               345051ULL }, // M200273 has a factor: 138208797847
    {     200131, 37,               373524ULL }, // M200131 has a factor: 149507463289
    {     200183, 37,               388476ULL }, // M200183 has a factor: 155532582217
    {     200989, 38,              1183676ULL }, // M200989 has a factor: 475811711129
    {     200597, 38,              1217388ULL }, // M200597 has a factor: 488408761273
    {     200861, 39,              1523044ULL }, // M200861 has a factor: 611840281769
    {     200401, 39,              2039691ULL }, // M200401 has a factor: 817512232183
    {     200807, 39,              2347548ULL }, // M200807 has a factor: 942808142473
    {     200017, 40,              4560447ULL }, // M200017 has a factor: 1824333855199
    {     200041, 40,              5367951ULL }, // M200041 has a factor: 2147620571983
    {     200131, 42,             12623060ULL }, // M200131 has a factor: 5052531241721
    {     200929, 44,             57515696ULL }, // M200929 has a factor: 23113142563169
    {     200357, 44,             76604139ULL }, // M200357 has a factor: 30696350955247
    {     200989, 45,            138315155ULL }, // M200989 has a factor: 55599649376591
    {     200029, 45,            139556340ULL }, // M200029 has a factor: 55830630267721
    {     200003, 46,            177611176ULL }, // M200003 has a factor: 71045536067057
    {     200087, 46,            328389993ULL }, // M200087 has a factor: 131413137058783
    {     200587, 48,            818207184ULL }, // M200587 has a factor: 328243448834017
    {     200731, 49,           2614221933ULL }, // M200731 has a factor: 1049510765666047
    {     200657, 50,           2810501175ULL }, // M200657 has a factor: 1127893468543951
    {     200117, 53,          22634454423ULL }, // M200117 has a factor: 9059078231534983
    {     200867, 53,          31778304585ULL }, // M200867 has a factor: 12766425414150391
    {     200017, 54,          85846303143ULL }, // M200017 has a factor: 34341440031506863
    {     200899, 56,         189907803081ULL }, // M200899 has a factor: 76304575462339639
    {     200671, 57,         568865018613ULL }, // M200671 has a factor: 228309424300178647
    {     200987, 57,         644025438244ULL }, // M200987 has a factor: 258881481512693657
    {     200323, 63,       44082775877508ULL }, // M200323 has a factor: 17661587824220070169
    {     200329, 67,      530416497807072ULL }, // M200329 has a factor: 212515613178385853377
    {     200381, 69,     1764106172735431ULL }, // M200381 has a factor: 706986717997796798423
    {     200579, 71,     7124604582470136ULL }, // M200579 has a factor: 2858092125094554817489
    {     200023, 75,   134049395598996777ULL }, // M200023 has a factor: 53625924511796264651743
    {     200513, 77,   506218960959779235ULL }, // M200513 has a factor: 203006965037856427495111

    /* some (all) known factors from the primenet server (2013-12-18) http://www.mersenne.org/
for exponents from 500000 to 501000 */
    {     500459, 19,                    1ULL }, // M500459 has a factor: 1000919
    {     500579, 19,                    1ULL }, // M500579 has a factor: 1001159
    {     500723, 19,                    1ULL }, // M500723 has a factor: 1001447
    {     500891, 19,                    1ULL }, // M500891 has a factor: 1001783
    {     500057, 21,                    3ULL }, // M500057 has a factor: 3000343
    {     500153, 21,                    3ULL }, // M500153 has a factor: 3000919
    {     500321, 21,                    3ULL }, // M500321 has a factor: 3001927
    {     500933, 21,                    3ULL }, // M500933 has a factor: 3005599
    {     500111, 21,                    4ULL }, // M500111 has a factor: 4000889
    {     500501, 21,                    4ULL }, // M500501 has a factor: 4004009
    {     500509, 23,                   11ULL }, // M500509 has a factor: 11011199
    {     500777, 23,                   15ULL }, // M500777 has a factor: 15023311
    {     500009, 23,                   16ULL }, // M500009 has a factor: 16000289
    {     500777, 24,                   24ULL }, // M500777 has a factor: 24037297
    {     500807, 24,                   24ULL }, // M500807 has a factor: 24038737
    {     500501, 24,                   28ULL }, // M500501 has a factor: 28028057
    {     500693, 24,                   28ULL }, // M500693 has a factor: 28038809
    {     500393, 25,                   36ULL }, // M500393 has a factor: 36028297
    {     500501, 25,                   39ULL }, // M500501 has a factor: 39039079
    {     500417, 25,                   48ULL }, // M500417 has a factor: 48040033
    {     500567, 25,                   64ULL }, // M500567 has a factor: 64072577
    {     500167, 26,                   72ULL }, // M500167 has a factor: 72024049
    {     500861, 26,                   88ULL }, // M500861 has a factor: 88151537
    {     500933, 26,                  132ULL }, // M500933 has a factor: 132246313
    {     500471, 27,                  264ULL }, // M500471 has a factor: 264248689
    {     500029, 28,                  312ULL }, // M500029 has a factor: 312018097
    {     500257, 28,                  440ULL }, // M500257 has a factor: 440226161
    {     500257, 29,                  564ULL }, // M500257 has a factor: 564289897
    {     500791, 29,                  768ULL }, // M500791 has a factor: 769214977
    {     500233, 30,                 1791ULL }, // M500233 has a factor: 1791834607
    {     500579, 30,                 1981ULL }, // M500579 has a factor: 1983293999
    {     500209, 31,                 2391ULL }, // M500209 has a factor: 2391999439
    {     500041, 31,                 3399ULL }, // M500041 has a factor: 3399278719
    {     500873, 33,                 8655ULL }, // M500873 has a factor: 8670111631
    {     500677, 33,                11004ULL }, // M500677 has a factor: 11018899417
    {     500177, 33,                11380ULL }, // M500177 has a factor: 11384028521
    {     500729, 33,                15816ULL }, // M500729 has a factor: 15839059729
    {     500809, 34,                18675ULL }, // M500809 has a factor: 18705216151
    {     500333, 34,                25051ULL }, // M500333 has a factor: 25067683967
    {     500693, 34,                27360ULL }, // M500693 has a factor: 27397920961
    {     500873, 34,                27568ULL }, // M500873 has a factor: 27616133729
    {     500167, 36,                71049ULL }, // M500167 has a factor: 71072730367
    {     500299, 36,               104045ULL }, // M500299 has a factor: 104107218911
    {     500873, 38,               316848ULL }, // M500873 has a factor: 317401216609
    {     500041, 38,               376808ULL }, // M500041 has a factor: 376838898257
    {     500177, 39,               886528ULL }, // M500177 has a factor: 886841830913
    {     500791, 39,               902345ULL }, // M500791 has a factor: 903772509791
    {     500909, 40,              1397616ULL }, // M500909 has a factor: 1400156865889
    {     500107, 40,              1542540ULL }, // M500107 has a factor: 1542870103561
    {     500431, 40,              1871276ULL }, // M500431 has a factor: 1872889039913
    {     500237, 40,              2144463ULL }, // M500237 has a factor: 2145479475463
    {     500119, 41,              3785601ULL }, // M500119 has a factor: 3786501973039
    {     500509, 43,             15805395ULL }, // M500509 has a factor: 15821484892111
    {     500807, 43,             16225285ULL }, // M500807 has a factor: 16251472609991
    {     500527, 44,             22775244ULL }, // M500527 has a factor: 22799249107177
    {     500113, 44,             34005983ULL }, // M500113 has a factor: 34013668352159
    {     500887, 45,             50628980ULL }, // M500887 has a factor: 50718795810521
    {     500119, 45,             58804916ULL }, // M500119 has a factor: 58818911570009
    {     500393, 46,            101658592ULL }, // M500393 has a factor: 101738495653313
    {     500693, 46,            108981903ULL }, // M500693 has a factor: 109132951917559
    {     500957, 46,            111621544ULL }, // M500957 has a factor: 111835187635217
    {     500473, 47,            249779280ULL }, // M500473 has a factor: 250015571198881
    {     500587, 48,            367076864ULL }, // M500587 has a factor: 367507812238337
    {     500777, 50,           1769975419ULL }, // M500777 has a factor: 1772725960801127
    {     500911, 50,           1975620309ULL }, // M500911 has a factor: 1979219889202999
    {     500341, 50,           2194209788ULL }, // M500341 has a factor: 2195706239075417
    {     500459, 51,           3542197321ULL }, // M500459 has a factor: 3545449058140679
    {     500209, 52,           5275067439ULL }, // M500209 has a factor: 5277272417189503
    {     500177, 52,           6806841495ULL }, // M500177 has a factor: 6809251116889231
    {     500249, 53,          13357425519ULL }, // M500249 has a factor: 13364077516908463
    {     500083, 55,          41086841960ULL }, // M500083 has a factor: 41093662375765361
    {     500909, 57,         275427260559ULL }, // M500909 has a factor: 275927987318696263
    {     500881, 58,         563032721151ULL }, // M500881 has a factor: 564024784805668063
    {     500179, 71,     2986307427190001ULL }, // M500179 has a factor: 2987376525248935020359
    {     500923, 72,     8173323366139452ULL }, // M500923 has a factor: 8188411321073345428393
    {     500953, 79,   895189023449202923ULL }  // M500953 has a factor: 896895253727897103771239
};
