/*
This file is part of mfaktc (mfakto).
Copyright (C) 2009 - 2013  Oliver Weihe (o.weihe@t-online.de)
                           Bertram Franz (bertramf@gmx.net)

mfaktc (mfakto) is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mfaktc (mfakto) is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mfaktc (mfakto).  If not, see <http://www.gnu.org/licenses/>.
*/

/* some factors I found with P-1 factoring */

#ifndef __SELFTEST_DATA_INCLUDED__
#define __SELFTEST_DATA_INCLUDED__
typedef struct _test_set
{ 
  unsigned int exp;
  unsigned int bit_min;
  unsigned long long int k;
} test_set;

static test_set st_data[] =
{
  // 0.13pre4 -st2 failure on Cayman:
  // { 597345241, 63, 9440112356},   // factor: 11278012380723795593

  // testing special failures with Cat14.12
  { 67094119, 81, 19547391707946912ULL },   // factor: 2623030050785206718821057
  { 45448679, 81, 30351096280664320ULL },   // factor: 2758834464316013172866561
  { 30568231, 81, 60459638564566820ULL },   // factor: 3696288395636373937390841
  { 71065531, 81, 33085617732560736ULL },   // factor: 4702493985254889387181633
  { 72067427, 82, 46771068908445148ULL },   // factor: 6741341188542680773988393
  { 52031087, 82, 71173502423506224ULL },   // factor: 7406469393384326371970977
  { 49346867, 82, 93491210160916720ULL },   // factor: 9226996626959611959832481
  { 45588523, 87, 2600820182983504020ULL },   // factor: 237135101461615363272724921
  { 71115521, 87, 2156639879097110275ULL },   // factor: 306741137222736013602156551

  
  // generated out of the previous header file by 
// sed -e s'/^exp\[[ 0-9]*\]=/  { /' -e s'/; bit_min\[[ 0-9]*\]=/, /'  -e s'/; k\[[ 0-9]*\]=/, /' -e s'/;/ },  /' st_data  >st_data.h
//
  { 50804297, 67, 1777608657747ULL },   // M50804297 has a factor: 180620316395899877719 (67.29 Bits), 3387
  { 50725243, 67, 2270235299916ULL },   // M50725243 has a factor: 230316474510833959177 (67.64 Bits), 276
  { 49635893, 67, 2822192209735ULL },   // M49635893 has a factor: 280164061095680036711 (67.92 Bits), 3055
  { 51332417, 68, 2901602967304ULL },   // M51332417 has a factor: 297892586972172587537 (68.01 Bits), 1504
  { 51413951, 68, 3084924765984ULL },   // M51413951 has a factor: 317216341513975685569 (68.10 Bits), 1524
  { 53134687, 68, 3171882111900ULL },   // M53134687 has a factor: 337073926433410950601 (68.19 Bits), 3120
  { 51265327, 68, 3399493885248ULL },   // M51265327 has a factor: 348552331323478392193 (68.23 Bits), 1308
  { 53146649, 68, 3397856891695ULL },   // M53146649 has a factor: 361169415150290360111 (68.29 Bits), 3115
  { 53068331, 68, 3747918509325ULL },   // M53068331 has a factor: 397791560027771373151 (68.43 Bits), 2685
  { 50787953, 68, 4022261889255ULL },   // M50787953 has a factor: 408564895570348290031 (68.46 Bits), 2535
  { 51737573, 68, 3987309195583ULL },   // M51737573 has a factor: 412587401160093480119 (68.48 Bits), 2023
  { 51161503, 68, 4060374149840ULL },   // M51161503 has a factor: 415469688496323219041 (68.49 Bits), 2780
  { 51061601, 68, 4190037673596ULL },   // M51061601 has a factor: 427900063728254374393 (68.53 Bits), 1776
  { 51082547, 68, 4560615285580ULL },   // M51082547 has a factor: 465935689349117544521 (68.65 Bits), 3280
  { 51437311, 68, 4897791053193ULL },   // M51437311 has a factor: 503858403232211768047 (68.77 Bits), 2733
  { 51486859, 68, 4955487665772ULL },   // M51486859 has a factor: 510284989447684180297 (68.78 Bits), 4032
  { 51408359, 68, 5079314752137ULL },   // M51408359 has a factor: 522238472503709826367 (68.82 Bits), 2397
  { 51532279, 68, 5256827119472ULL },   // M51532279 has a factor: 541792563550794873377 (68.87 Bits), 3932
  { 50751637, 68, 5420726350868ULL },   // M50751637 has a factor: 550221472071174741833 (68.89 Bits), 4448
  { 51629843, 68, 5410622486860ULL },   // M51629843 has a factor: 558699179057702725961 (68.92 Bits), 1900
  { 51302663, 69, 5883290728777ULL },   // M51302663 has a factor: 603656963178941666303 (69.03 Bits), 3157
  { 51960509, 69, 6240631719180ULL },   // M51960509 has a factor: 648532801220275725241 (69.13 Bits), 1860
  { 51683747, 69, 6539840634253ULL },   // M51683747 has a factor: 676006937522103171983 (69.19 Bits), 3853
  { 51163433, 69, 6686338931736ULL },   // M51163433 has a factor: 684192107898332819377 (69.21 Bits), 156
  { 50896831, 69, 6932063326709ULL },   // M50896831 has a factor: 705640111241611518359 (69.25 Bits), 2369
  { 51375383, 69, 6940180143997ULL },   // M51375383 has a factor: 713108825973682051703 (69.27 Bits), 1717
  { 51133343, 69, 7791765251988ULL },   // M51133343 has a factor: 796838010410767671769 (69.43 Bits), 1488
  { 52548403, 69, 7700004611768ULL },   // M52548403 has a factor: 809245890882086813009 (69.45 Bits), 4088
  { 51023447, 69, 9127164820560ULL },   // M51023447 has a factor: 931398820964215340641 (69.65 Bits), 4560
  { 53057161, 69, 8788978937844ULL },   // M53057161 has a factor: 932636541061596201769 (69.65 Bits), 2184
  { 50863909, 69, 9428548724480ULL },   // M50863909 has a factor: 959145688648033584641 (69.70 Bits), 1040
  { 51683719, 69, 9349316766029ULL },   // M51683719 has a factor: 966414921154863163703 (69.71 Bits), 3089
  { 51785093, 69, 10061750158576ULL },   // M51785093 has a factor: 1042097335409245815137 (69.81 Bits), 3196
  { 51445357, 69, 10810403816960ULL },   // M51445357 has a factor: 1112290167355339709441 (69.91 Bits), 440
  { 53136437, 70, 11182837510428ULL },   // M53136437 has a factor: 1188432281708188530073 (70.00 Bits), 3048
  { 50920721, 70, 12311227247460ULL },   // M50920721 has a factor: 1253793135671017237321 (70.08 Bits), 2220
  { 52188473, 70, 12244536814095ULL },   // M52188473 has a factor: 1278047357839805853871 (70.11 Bits), 3435
  { 48630643, 70, 14360013843000ULL },   // M48630643 has a factor: 1396673413347982098001 (70.24 Bits), 2520
  { 51250613, 70, 13784248858471ULL },   // M51250613 has a factor: 1412902407482377985447 (70.25 Bits), 91
  { 51406301, 70, 13876172279503ULL },   // M51406301 has a factor: 1426645377855974696807 (70.27 Bits), 1843
  { 50893061, 70, 14165527205908ULL },   // M50893061 has a factor: 1441854080374870808777 (70.28 Bits), 3928
  { 50979079, 70, 14154674984616ULL },   // M50979079 has a factor: 1443184588520125697329 (70.28 Bits), 936
  { 51064417, 70, 14335850580495ULL },   // M51064417 has a factor: 1464103704184177492831 (70.31 Bits), 675
  { 51293899, 70, 15549106121072ULL },   // M51293899 has a factor: 1595148557829097879457 (70.43 Bits), 2372
  { 51132959, 70, 15736957340044ULL },   // M51132959 has a factor: 1609354388906437820393 (70.44 Bits), 2404
  { 51125413, 70, 17159859494700ULL },   // M51125413 has a factor: 1754609807377017622201 (70.57 Bits), 4080
  { 52249541, 70, 16836000669924ULL },   // M52249541 has a factor: 1759346614558443009769 (70.57 Bits), 744
  { 50781589, 70, 17443383452799ULL },   // M50781589 has a factor: 1771605458538879435223 (70.58 Bits), 4539
  { 51321659, 70, 17370566757769ULL },   // M51321659 has a factor: 1782972607557912437543 (70.59 Bits), 2689
  { 51745849, 70, 19378619790720ULL },   // M51745849 has a factor: 2005526267038017442561 (70.76 Bits), 960
  { 49715873, 70, 20406300460375ULL },   // M49715873 has a factor: 2029034084175690064751 (70.78 Bits), 2755
  { 53110691, 70, 19255777679248ULL },   // M53110691 has a factor: 2045375316574475280737 (70.79 Bits), 2728
  { 49915309, 70, 20895019231944ULL },   // M49915309 has a factor: 2085962683046854861393 (70.82 Bits), 2244
  { 51152869, 70, 20582854459640ULL },   // M51152869 has a factor: 2105744115640061414321 (70.83 Bits), 4400
  { 50909147, 70, 21785705793504ULL },   // M50909147 has a factor: 2218183397480493562177 (70.90 Bits), 2424
  { 51651337, 70, 21996976083347ULL },   // M51651337 has a factor: 2272346449323791969879 (70.94 Bits), 2267
  { 51340871, 70, 22243376181213ULL },   // M51340871 has a factor: 2283988614248258513047 (70.95 Bits), 33
  { 47644171, 70, 24735972078953ULL },   // M47644171 has a factor: 2357049767161724465927 (70.99 Bits), 2753
  { 48103381, 71, 24689718456956ULL },   // M48103381 has a factor: 2375317867435373136473 (71.00 Bits), 476
  { 51175363, 71, 23413141155273ULL },   // M51175363 has a factor: 2396351995182670278199 (71.02 Bits), 3873
  { 51705649, 71, 24393803641236ULL },   // M51705649 has a factor: 2522594897697341084329 (71.09 Bits), 876
  { 51512189, 71, 29154877583320ULL },   // M51512189 has a factor: 3003663128687686174961 (71.34 Bits), 2260
  { 51772243, 71, 33454813100780ULL },   // M51772243 has a factor: 3464061426746331299081 (71.55 Bits), 4460
  { 51232133, 71, 34623350060728ULL },   // M51232133 has a factor: 3547656150433549945649 (71.58 Bits), 4048
  { 50830523, 71, 35147782395693ULL },   // M50830523 has a factor: 3573160322926536274879 (71.59 Bits), 1353
  { 51657589, 71, 34811323791024ULL },   // M51657589 has a factor: 3596538113885279362273 (71.60 Bits), 2244
  { 53093213, 71, 35465933017840ULL },   // M53093213 has a factor: 3766000671919823839841 (71.67 Bits), 1480
  { 50734577, 71, 40168065930832ULL },   // M50734577 has a factor: 4075819667817745556129 (71.78 Bits), 532
  { 50337173, 71, 40611552822547ULL },   // M50337173 has a factor: 4088541520454373279263 (71.79 Bits), 3787
  { 53050093, 71, 38928727165488ULL },   // M53050093 has a factor: 4130345193001529580769 (71.80 Bits), 468
  { 51038681, 71, 40470748619263ULL },   // M51038681 has a factor: 4131147257219509424207 (71.80 Bits), 2503
  { 51203717, 71, 41028152424784ULL },   // M51203717 has a factor: 4201587811583007444257 (71.83 Bits), 4144
  { 49717271, 71, 44611668558205ULL },   // M49717271 has a factor: 4435940830940914517111 (71.90 Bits), 2905
  { 50752613, 72, 48930580734708ULL },   // M50752613 has a factor: 4966709655787781584009 (72.07 Bits), 288
  { 50804063, 72, 50136644425165ULL },   // M50804063 has a factor: 5094290483969362890791 (72.10 Bits), 4225
  { 50944769, 72, 50328898134240ULL },   // M50944769 has a factor: 5127988178946775581121 (72.11 Bits), 3960
  { 48096799, 72, 53645214716660ULL },   // M48096799 has a factor: 5160326219078075942681 (72.12 Bits), 4340
  { 51532177, 72, 50343307097223ULL },   // M51532177 has a factor: 5188600424198903688943 (72.13 Bits), 63
  { 50755769, 72, 51731986277692ULL },   // M50755769 has a factor: 5251393490843410010297 (72.15 Bits), 952
  { 51507913, 72, 53272356477048ULL },   // M51507913 has a factor: 5487895805449549761649 (72.21 Bits), 1248
  { 51149009, 72, 60713154710736ULL },   // M51149009 has a factor: 6210835393435656121249 (72.39 Bits), 2376
  { 53022301, 72, 60937455648860ULL },   // M53022301 has a factor: 6462088231176010453721 (72.45 Bits), 560
  { 50908933, 72, 65755731907307ULL },   // M50908933 has a factor: 6695108300070108546863 (72.50 Bits), 827
  { 51573077, 72, 78064255115328ULL },   // M51573077 has a factor: 8052027680020909648513 (72.76 Bits), 3408
  { 51291299, 72, 82468544838405ULL },   // M51291299 has a factor: 8459837582803075076191 (72.84 Bits), 2805
  { 46510507, 72, 91053161264120ULL },   // M46510507 has a factor: 8469857388693964217681 (72.84 Bits), 440
  { 47963869, 73, 102880777724327ULL },   // M47963869 has a factor: 9869120290775476682327 (73.06 Bits), 4607
  { 50739071, 73, 103222393285365ULL },   // M50739071 has a factor: 10474816683392115991831 (73.14 Bits), 585
  { 53076719, 73, 120985819416700ULL },   // M53076719 has a factor: 12843060680329859614601 (73.44 Bits), 700
  { 51844393, 73, 124630146569448ULL },   // M51844393 has a factor: 12922748596788127810129 (73.45 Bits), 828
  { 51916901, 73, 143378013809076ULL },   // M51916901 has a factor: 14887484297004863186953 (73.65 Bits), 816
  { 51426913, 73, 164984955585372ULL },   // M51426913 has a factor: 16969333914395579833273 (73.84 Bits)
  { 49870277, 74, 190291970650119ULL },   // M49870277 has a factor: 18979826574394609225927 (74.00 Bits)
  { 48996149, 74, 205866337947124ULL },   // M48996149 has a factor: 20173315536283283250953 (74.09 Bits)
  { 49671203, 74, 226516545825768ULL },   // M49671203 has a factor: 22502698661141049917809 (74.25 Bits)
  { 50956709, 74, 233279129629399ULL },   // M50956709 has a factor: 23774273448597125375783 (74.33 Bits)
  { 50758453, 74, 234355374782232ULL },   // M50758453 has a factor: 23791032552362616414193 (74.33 Bits)
  { 51157933, 74, 240326919436856ULL },   // M51157933 has a factor: 24589256885294153957297 (74.38 Bits)
  { 50719327, 74, 247749185591957ULL },   // M50719327 has a factor: 25131343916044311305879 (74.41 Bits)
  { 51611033, 74, 255365528058471ULL },   // M51611033 has a factor: 26359357391376345421087 (74.48 Bits)
  { 49990951, 74, 270230842152824ULL },   // M49990951 has a factor: 27018193577501118191249 (74.51 Bits)
  { 51287959, 74, 305774524088597ULL },   // M51287959 has a factor: 31365102509400950607047 (74.73 Bits)
  { 50122463, 74, 329640317831160ULL },   // M50122463 has a factor: 33044769267601114694161 (74.80 Bits)
  { 51567589, 74, 320838875139612ULL },   // M51567589 has a factor: 33089774496843658470937 (74.80 Bits)
  { 53067527, 74, 323356685174709ULL },   // M53067527 has a factor: 34319479242278739149287 (74.86 Bits)
  { 51604321, 74, 349923559412700ULL },   // M51604321 has a factor: 36115135370791084553401 (74.93 Bits)
  { 53123843, 74, 341136139967028ULL },   // M53123843 has a factor: 36244925482468841297209 (74.94 Bits)
  { 49891693, 75, 398606803340948ULL },   // M49891693 has a factor: 39774336519995903889929 (75.07 Bits)
  { 51308501, 75, 391985259732660ULL },   // M51308501 has a factor: 40224352181956890685321 (75.09 Bits)
  { 51412421, 75, 435756142663416ULL },   // M51412421 has a factor: 44806556519895209380273 (75.24 Bits)
  { 51082211, 75, 491122141966716ULL },   // M51082211 has a factor: 50175209765431483378153 (75.40 Bits)
  { 53066743, 75, 485301756769808ULL },   // M53066743 has a factor: 51506767207903822590689 (75.44 Bits)
  { 51421577, 75, 503084197984504ULL },   // M51421577 has a factor: 51738765648286834485617 (75.45 Bits)
  { 51351359, 75, 506102808316921ULL },   // M51351359 has a factor: 51978134001580792091279 (75.46 Bits)
  { 50923703, 75, 518593175553825ULL },   // M50923703 has a factor: 52817369699459689627951 (75.48 Bits)
  { 48234931, 75, 559683122468976ULL },   // M48234931 has a factor: 53992553588311214001313 (75.51 Bits)
  { 50831093, 75, 575906549567376ULL },   // M50831093 has a factor: 58547918760736798443937 (75.63 Bits)
  { 51784223, 75, 567404368721140ULL },   // M51784223 has a factor: 58765188722059477148441 (75.63 Bits)
  { 51065437, 75, 627334896409280ULL },   // M51065437 has a factor: 64070261260979228110721 (75.76 Bits)
  { 53127847, 75, 655094257057457ULL },   // M53127847 has a factor: 69607494919054491410159 (75.88 Bits)
  { 51671491, 75, 684920466832080ULL },   // M51671491 has a factor: 70781723475259240462561 (75.90 Bits)
  { 49395389, 75, 760048958043384ULL },   // M49395389 has a factor: 75085827883195263112753 (75.99 Bits)
  { 51027377, 76, 762832516479103ULL },   // M51027377 has a factor: 77850684812475802805663 (76.04 Bits)
  { 50292533, 76, 852593845105383ULL },   // M50292533 has a factor: 85758208181118726010279 (76.18 Bits)
  { 51084851, 76, 842953375628356ULL },   // M51084851 has a factor: 86124295187843195269913 (76.18 Bits)
  { 51703507, 76, 891760399003244ULL },   // M51703507 has a factor: 92214280064374038353417 (76.28 Bits)
  { 53143919, 76, 950870091161484ULL },   // M53143919 has a factor: 101065926208417043231593 (76.41 Bits)
  { 53120449, 76, 972220249593336ULL },   // M53120449 has a factor: 103289552370580151455729 (76.45 Bits)
  { 53028841, 76, 978905090236568ULL },   // M53028841 has a factor: 103820404768491233715377 (76.45 Bits)
  { 53113309, 76, 1360920819506039ULL },   // M53113309 has a factor: 144566016021914953546103 (76.93 Bits)
  { 50825813, 77, 1555903361140608ULL },   // M50825813 has a factor: 158160106558808017828609 (77.06 Bits)
  { 50805581, 77, 1629725732542368ULL },   // M50805581 has a factor: 165598325424931226711617 (77.13 Bits)
  { 51465133, 77, 1614486667474043ULL },   // M51465133 has a factor: 166179542136556794085439 (77.13 Bits)
  { 51274621, 77, 1773083455092731ULL },   // M51274621 has a factor: 181828364322500603759903 (77.26 Bits)
  { 51739937, 77, 1893321717865743ULL },   // M51739937 has a factor: 195920692806210634556383 (77.37 Bits)
  { 53034889, 77, 1901446186305996ULL },   // M53034889 has a factor: 201685974860423635788889 (77.41 Bits)
  { 51251191, 77, 2264364163381373ULL },   // M51251191 has a factor: 232102720462027906930487 (77.61 Bits)
  { 50969377, 77, 2326754711370384ULL },   // M50969377 has a factor: 237186476140726577461537 (77.65 Bits)
  { 51798647, 77, 2371082863020228ULL },   // M51798647 has a factor: 245637768458668288063033 (77.70 Bits)
  { 51219499, 77, 2425900736757245ULL },   // M51219499 has a factor: 248506840720873947040511 (77.71 Bits)
  { 51587957, 77, 2526550153000120ULL },   // M51587957 has a factor: 260679121302627223109681 (77.78 Bits)
  { 51364549, 77, 2806848277852392ULL },   // M51364549 has a factor: 288344991806629607302417 (77.93 Bits)
  { 51517409, 77, 2837794280980659ULL },   // M51517409 has a factor: 292391617262283061585063 (77.95 Bits)
  { 51047807, 78, 3212463592350172ULL },   // M51047807 has a factor: 327978442913636513345609 (78.11 Bits)
  { 53011421, 78, 3111062249431024ULL },   // M53011421 has a factor: 329843661323590047450209 (78.12 Bits)
  { 51157429, 78, 3231084979105664ULL },   // M51157429 has a factor: 330588000823128979155713 (78.12 Bits)
  { 51089657, 78, 3908828422014967ULL },   // M51089657 has a factor: 399401406705191825792639 (78.40 Bits)
  { 50981263, 78, 4145553624833393ULL },   // M50981263 has a factor: 422691119256469079430719 (78.48 Bits)
  { 50751083, 78, 4175492695040121ULL },   // M50751083 has a factor: 423821552663749738402087 (78.48 Bits)
  { 51406151, 78, 4374586798481625ULL },   // M51406151 has a factor: 449761339050705970950751 (78.57 Bits)
  { 51679921, 78, 4364056812997860ULL },   // M51679921 has a factor: 451068222670482355938121 (78.57 Bits)
  { 53077207, 78, 4348685045428169ULL },   // M53077207 has a factor: 461632112667990659287967 (78.61 Bits)
  { 50939887, 78, 4860179336195424ULL },   // M50939887 has a factor: 495153972371059816954177 (78.71 Bits)
  { 50846503, 78, 4933354746515741ULL },   // M50846503 has a factor: 501687673837553728607447 (78.73 Bits)
  { 53081201, 78, 4782428627939931ULL },   // M53081201 has a factor: 507714110535667386674263 (78.74 Bits)
  { 51478381, 79, 6209661314961368ULL },   // M51478381 has a factor: 639326622105084604370417 (79.08 Bits)
  { 51590083, 79, 6250074060114660ULL },   // M51590083 has a factor: 644883679034924597833561 (79.09 Bits)
  { 51363101, 79, 6406752166300024ULL },   // M51363101 has a factor: 658141317199273858028849 (79.12 Bits)
  { 53111563, 79, 7195836194712837ULL },   // M53111563 has a factor: 764364214786342218468463 (79.33 Bits)
  { 51124373, 80, 13270114151094636ULL },   // M51124373 has a factor: 1356852531226281058326457 (80.16 Bits)
  { 50884469, 80, 13549853162862207ULL },   // M50884469 has a factor: 1378954166440427846726167 (80.18 Bits)
  { 50425469, 80, 13675643212263651ULL },   // M50425469 has a factor: 1379201445710122306654639 (80.19 Bits)
  { 51231259, 80, 13464357885526221ULL },   // M51231259 has a factor: 1379592012204172358684479 (80.19 Bits)
  { 51592423, 80, 13762495546987160ULL },   // M51592423 has a factor: 1420080983591555868577361 (80.23 Bits)
  { 51378827, 80, 15089985884385288ULL },   // M51378827 has a factor: 1550611548372547426994353 (80.35 Bits)
  { 50599849, 80, 19278173834439036ULL },   // M50599849 has a factor: 1950945370036732442611129 (80.69 Bits)
  { 51350527, 80, 19129858966989825ULL },   // M51350527 has a factor: 1964656678781206234775551 (80.70 Bits)
  { 51640507, 80, 19158377957052480ULL },   // M51640507 has a factor: 1978696701999628585614721 (80.71 Bits)
  { 53061139, 80, 19379098034090852ULL },   // M53061139 has a factor: 2056554028963042873200857 (80.76 Bits)
  { 51599917, 80, 20989621071714804ULL },   // M51599917 has a factor: 2166125410323869868142537 (80.84 Bits)
  { 51414301, 80, 22088670725501184ULL },   // M51414301 has a factor: 2271347130741612500064769 (80.90 Bits)
  { 51793993, 81, 24596847011914395ULL },   // M51793993 has a factor: 2547937843914330182458471 (81.07 Bits)
  { 51116959, 81, 28754123428372545ULL },   // M51116959 has a factor: 2939646696738117638981311 (81.28 Bits)
  { 50561177, 81, 34090469752046095ULL },   // M50561177 has a factor: 3447308550292697442907631 (81.51 Bits)
  { 48629519, 81, 36429370074739780ULL },   // M48629519 has a factor: 3543085488415179103131641 (81.55 Bits)
  { 50842793, 81, 39248615511665503ULL },   // M50842793 has a factor: 3991018467992396508539759 (81.72 Bits)
  { 53013923, 82, 59944886981546908ULL },   // M53013923 has a factor: 6355827245366860403200169 (82.39 Bits)
  { 51029593, 82, 65712746453662971ULL },   // M51029593 has a factor: 6706589412885229538601607 (82.47 Bits)
  { 50811659, 82, 72126762754163920ULL },   // M50811659 has a factor: 7329760947676955866286561 (82.60 Bits)
  { 53065907, 83, 102023340917861625ULL },   // M53065907 has a factor: 10827922241953079262237751 (83.16 Bits)
  { 51550007, 83, 109181510683870365ULL },   // M51550007 has a factor: 11256615280048184205685111 (83.21 Bits)
  { 51752893, 83, 117022821796058360ULL },   // M51752893 has a factor: 12112539149938952253670961 (83.32 Bits)
  { 51814799, 83, 124544575186532481ULL },   // M51814799 has a factor: 12906504259661136019972639 (83.41 Bits)
  { 51713567, 83, 128825998254635412ULL },   // M51713567 has a factor: 13324103784165942878069209 (83.46 Bits)
  { 50792059, 83, 133234554406787292ULL },   // M50792059 has a factor: 13534514696536500271428457 (83.48 Bits)
  { 51760133, 83, 133322806690603780ULL },   // M51760133 has a factor: 13801612412477883006205481 (83.51 Bits)
  { 51573157, 83, 138752195749747512ULL },   // M51573157 has a factor: 14311777550992922293470769 (83.56 Bits)
  { 50771599, 83, 189101755334162741ULL },   // M50771599 has a factor: 19201996984044443373585719 (83.98 Bits)
  { 43996961, 84, 225542457114451048ULL },   // M43996961 has a factor: 19846365379017350590530257 (84.03 Bits)
  { 51090757, 84, 277992681646859627ULL },   // M51090757 has a factor: 28405713091596130032335279 (84.55 Bits)
  { 51050171, 84, 284784486351473784ULL },   // M51050171 has a factor: 29076593452779805550434129 (84.58 Bits)
  { 50131129, 85, 401356818837779156ULL },   // M50131129 has a factor: 40240940920372673885894249 (85.05 Bits)
  { 50193919, 85, 518598741131214869ULL },   // M50193919 has a factor: 52061006411684335012363223 (85.42 Bits)
  { 50251387, 85, 578228338376308653ULL },   // M50251387 has a factor: 58113552012229675506703423 (85.58 Bits)
  { 50903353, 85, 595405644154249931ULL },   // M50903353 has a factor: 60616287365152341375837287 (85.64 Bits)
  { 50989481, 86, 837867019459207431ULL },   // M50989481 has a factor: 85444808938483775156066623 (86.14 Bits)
  { 51308849, 86, 948804681506263635ULL },   // M51308849 has a factor: 97364152267795946804812231 (86.33 Bits)
  { 51124973, 86, 1239510621560436148ULL },   // M51124973 has a factor: 126739894120981031869448009 (86.71 Bits)
  { 50856937, 86, 1266848678358044360ULL },   // M50856937 has a factor: 128856086847576650919450641 (86.73 Bits)
  { 50864773, 87, 1683302908372660140ULL },   // M50864773 has a factor: 171241640649230314854496441 (87.14 Bits)
  { 51254911, 88, 3371505488794878653ULL },   // M51254911 has a factor: 345612427528386005230629767 (88.15 Bits)
  { 53065231, 88, 3810932634544041924ULL },   // M53065231 has a factor: 404456041155036328741488889 (88.38 Bits)
  { 51007903, 88, 4081456202747311440ULL },   // M51007903 has a factor: 416373044176966390884620641 (88.42 Bits)
  { 51113333, 88, 4260667320623951875ULL },   // M51113333 has a factor: 435553815122539639925698751 (88.49 Bits)
  { 51248731, 88, 4367104879757564436ULL },   // M51248731 has a factor: 447617166462965529991461433 (88.53 Bits)
  { 51094921, 89, 6068461944418778075ULL },   // M51094921 has a factor: 620135167283167713317314151 (89.00 Bits)
  { 51076919, 89, 7852756657332703936ULL },   // M51076919 has a factor: 802189231426586549980106369 (89.37 Bits)
  { 49954973, 89, 11564613340167814576ULL },   // M49954973 has a factor: 1155419894327045985226172897 (89.90 Bits)
  { 51202493, 89, 11597949758246665147ULL },   // M51202493 has a factor: 1187687882621953128925222943 (89.94 Bits)
  { 53091919, 90, 15788962197790786464ULL },   // M53091919 has a factor: 1676532604198340827785968833 (90.43 Bits)
  { 51612269, 90, 17856408109488433059ULL },   // M51612269 has a factor: 1843219477441396918859201743 (90.57 Bits)

/* some (all) known factors from the primenet server (2010-02-14) http://www.mersenne.org/
for exponents from 60000000 to 60010000 */
/* mfakto does not deliver kernels below 58 bits: skip these

  { 60000359, 26, 1ULL },   // M60000359 has a factor: 120000719
  { 60000851, 26, 1ULL },   // M60000851 has a factor: 120001703
  { 60001451, 26, 1ULL },   // M60001451 has a factor: 120002903
  { 60001811, 26, 1ULL },   // M60001811 has a factor: 120003623
  { 60003143, 26, 1ULL },   // M60003143 has a factor: 120006287
  { 60003431, 26, 1ULL },   // M60003431 has a factor: 120006863
  { 60004319, 26, 1ULL },   // M60004319 has a factor: 120008639
  { 60004991, 26, 1ULL },   // M60004991 has a factor: 120009983
  { 60005483, 26, 1ULL },   // M60005483 has a factor: 120010967
  { 60006623, 26, 1ULL },   // M60006623 has a factor: 120013247
  { 60006671, 26, 1ULL },   // M60006671 has a factor: 120013343
  { 60007523, 26, 1ULL },   // M60007523 has a factor: 120015047
  { 60007763, 26, 1ULL },   // M60007763 has a factor: 120015527
  { 60008159, 26, 1ULL },   // M60008159 has a factor: 120016319
  { 60008183, 26, 1ULL },   // M60008183 has a factor: 120016367
  { 60008303, 26, 1ULL },   // M60008303 has a factor: 120016607
  { 60009203, 26, 1ULL },   // M60009203 has a factor: 120018407
  { 60009479, 26, 1ULL },   // M60009479 has a factor: 120018959
  { 60009611, 26, 1ULL },   // M60009611 has a factor: 120019223
  { 60009791, 26, 1ULL },   // M60009791 has a factor: 120019583
  { 60009959, 26, 1ULL },   // M60009959 has a factor: 120019919
  { 60000713, 28, 3ULL },   // M60000713 has a factor: 360004279
  { 60001133, 28, 3ULL },   // M60001133 has a factor: 360006799
  { 60001477, 28, 3ULL },   // M60001477 has a factor: 360008863
  { 60001553, 28, 3ULL },   // M60001553 has a factor: 360009319
  { 60001741, 28, 3ULL },   // M60001741 has a factor: 360010447
  { 60003277, 28, 3ULL },   // M60003277 has a factor: 360019663
  { 60004177, 28, 3ULL },   // M60004177 has a factor: 360025063
  { 60004733, 28, 3ULL },   // M60004733 has a factor: 360028399
  { 60005357, 28, 3ULL },   // M60005357 has a factor: 360032143
  { 60005833, 28, 3ULL },   // M60005833 has a factor: 360034999
  { 60006893, 28, 3ULL },   // M60006893 has a factor: 360041359
  { 60007793, 28, 3ULL },   // M60007793 has a factor: 360046759
  { 60009533, 28, 3ULL },   // M60009533 has a factor: 360057199
  { 60000257, 28, 4ULL },   // M60000257 has a factor: 480002057
  { 60001811, 28, 4ULL },   // M60001811 has a factor: 480014489
  { 60002141, 28, 4ULL },   // M60002141 has a factor: 480017129
  { 60002339, 28, 4ULL },   // M60002339 has a factor: 480018713
  { 60003857, 28, 4ULL },   // M60003857 has a factor: 480030857
  { 60005207, 28, 4ULL },   // M60005207 has a factor: 480041657
  { 60006647, 28, 4ULL },   // M60006647 has a factor: 480053177
  { 60006677, 28, 4ULL },   // M60006677 has a factor: 480053417
  { 60001567, 29, 5ULL },   // M60001567 has a factor: 600015671
  { 60002671, 29, 5ULL },   // M60002671 has a factor: 600026711
  { 60003847, 29, 5ULL },   // M60003847 has a factor: 600038471
  { 60007951, 29, 5ULL },   // M60007951 has a factor: 600079511
  { 60009919, 29, 5ULL },   // M60009919 has a factor: 600099191
  { 60001433, 29, 7ULL },   // M60001433 has a factor: 840020063
  { 60000553, 29, 8ULL },   // M60000553 has a factor: 960008849
  { 60008671, 29, 8ULL },   // M60008671 has a factor: 960138737
  { 60000679, 30, 9ULL },   // M60000679 has a factor: 1080012223
  { 60002359, 30, 9ULL },   // M60002359 has a factor: 1080042463
  { 60003499, 30, 9ULL },   // M60003499 has a factor: 1080062983
  { 60005107, 30, 9ULL },   // M60005107 has a factor: 1080091927
  { 60005719, 30, 9ULL },   // M60005719 has a factor: 1080102943
  { 60001453, 30, 11ULL },   // M60001453 has a factor: 1320031967
  { 60003143, 30, 12ULL },   // M60003143 has a factor: 1440075433
  { 60005293, 30, 12ULL },   // M60005293 has a factor: 1440127033
  { 60005377, 30, 12ULL },   // M60005377 has a factor: 1440129049
  { 60005483, 30, 12ULL },   // M60005483 has a factor: 1440131593
  { 60007169, 30, 12ULL },   // M60007169 has a factor: 1440172057
  { 60008407, 30, 12ULL },   // M60008407 has a factor: 1440201769
  { 60009109, 30, 12ULL },   // M60009109 has a factor: 1440218617
  { 60005303, 30, 13ULL },   // M60005303 has a factor: 1560137879
  { 60009491, 30, 13ULL },   // M60009491 has a factor: 1560246767
  { 60000553, 30, 15ULL },   // M60000553 has a factor: 1800016591
  { 60003341, 30, 15ULL },   // M60003341 has a factor: 1800100231
  { 60001703, 30, 16ULL },   // M60001703 has a factor: 1920054497
  { 60001063, 31, 20ULL },   // M60001063 has a factor: 2400042521
  { 60002113, 31, 20ULL },   // M60002113 has a factor: 2400084521
  { 60002491, 31, 20ULL },   // M60002491 has a factor: 2400099641
  { 60005227, 31, 20ULL },   // M60005227 has a factor: 2400209081
  { 60008527, 31, 20ULL },   // M60008527 has a factor: 2400341081
  { 60008551, 31, 20ULL },   // M60008551 has a factor: 2400342041
  { 60003037, 31, 24ULL },   // M60003037 has a factor: 2880145777
  { 60004621, 31, 24ULL },   // M60004621 has a factor: 2880221809
  { 60007811, 31, 24ULL },   // M60007811 has a factor: 2880374929
  { 60000011, 31, 25ULL },   // M60000011 has a factor: 3000000551
  { 60003037, 31, 27ULL },   // M60003037 has a factor: 3240163999
  { 60009997, 31, 27ULL },   // M60009997 has a factor: 3240539839
  { 60006377, 31, 28ULL },   // M60006377 has a factor: 3360357113
  { 60008231, 31, 28ULL },   // M60008231 has a factor: 3360460937
  { 60003967, 31, 29ULL },   // M60003967 has a factor: 3480230087
  { 60001589, 31, 31ULL },   // M60001589 has a factor: 3720098519
  { 60000337, 31, 32ULL },   // M60000337 has a factor: 3840021569
  { 60006217, 31, 32ULL },   // M60006217 has a factor: 3840397889
  { 60009349, 31, 32ULL },   // M60009349 has a factor: 3840598337
  { 60002251, 31, 33ULL },   // M60002251 has a factor: 3960148567
  { 60003347, 31, 33ULL },   // M60003347 has a factor: 3960220903
  { 60005047, 31, 33ULL },   // M60005047 has a factor: 3960333103
  { 60007777, 31, 35ULL },   // M60007777 has a factor: 4200544391
  { 60005171, 32, 36ULL },   // M60005171 has a factor: 4320372313
  { 60003949, 32, 39ULL },   // M60003949 has a factor: 4680308023
  { 60005399, 32, 40ULL },   // M60005399 has a factor: 4800431921
  { 60006299, 32, 40ULL },   // M60006299 has a factor: 4800503921
  { 60006533, 32, 43ULL },   // M60006533 has a factor: 5160561839
  { 60004387, 32, 44ULL },   // M60004387 has a factor: 5280386057
  { 60008491, 32, 44ULL },   // M60008491 has a factor: 5280747209
  { 60005447, 32, 45ULL },   // M60005447 has a factor: 5400490231
  { 60001453, 32, 47ULL },   // M60001453 has a factor: 5640136583
  { 60002951, 32, 48ULL },   // M60002951 has a factor: 5760283297
  { 60004093, 32, 48ULL },   // M60004093 has a factor: 5760392929
  { 60004111, 32, 48ULL },   // M60004111 has a factor: 5760394657
  { 60006131, 32, 48ULL },   // M60006131 has a factor: 5760588577
  { 60007561, 32, 48ULL },   // M60007561 has a factor: 5760725857
  { 60008699, 32, 49ULL },   // M60008699 has a factor: 5880852503
  { 60002693, 32, 51ULL },   // M60002693 has a factor: 6120274687
  { 60006601, 32, 51ULL },   // M60006601 has a factor: 6120673303
  { 60005587, 32, 53ULL },   // M60005587 has a factor: 6360592223
  { 60008269, 32, 56ULL },   // M60008269 has a factor: 6720926129
  { 60006721, 32, 59ULL },   // M60006721 has a factor: 7080793079
  { 60002693, 32, 60ULL },   // M60002693 has a factor: 7200323161
  { 60005503, 32, 60ULL },   // M60005503 has a factor: 7200660361
  { 60006763, 32, 60ULL },   // M60006763 has a factor: 7200811561
  { 60007811, 32, 61ULL },   // M60007811 has a factor: 7320952943
  { 60001919, 32, 64ULL },   // M60001919 has a factor: 7680245633
  { 60003227, 32, 64ULL },   // M60003227 has a factor: 7680413057
  { 60005549, 32, 67ULL },   // M60005549 has a factor: 8040743567
  { 60002573, 33, 75ULL },   // M60002573 has a factor: 9000385951
  { 60006851, 33, 76ULL },   // M60006851 has a factor: 9121041353
  { 60008239, 33, 77ULL },   // M60008239 has a factor: 9241268807
  { 60008647, 33, 77ULL },   // M60008647 has a factor: 9241331639
  { 60008159, 33, 81ULL },   // M60008159 has a factor: 9721321759
  { 60006217, 33, 83ULL },   // M60006217 has a factor: 9961032023
  { 60005531, 33, 85ULL },   // M60005531 has a factor: 10200940271
  { 60004817, 33, 88ULL },   // M60004817 has a factor: 10560847793
  { 60002359, 33, 89ULL },   // M60002359 has a factor: 10680419903
  { 60001481, 33, 91ULL },   // M60001481 has a factor: 10920269543
  { 60007333, 33, 92ULL },   // M60007333 has a factor: 11041349273
  { 60005303, 33, 96ULL },   // M60005303 has a factor: 11521018177
  { 60005531, 33, 96ULL },   // M60005531 has a factor: 11521061953
  { 60006139, 33, 96ULL },   // M60006139 has a factor: 11521178689
  { 60003287, 33, 109ULL },   // M60003287 has a factor: 13080716567
  { 60000653, 33, 111ULL },   // M60000653 has a factor: 13320144967
  { 60008573, 33, 112ULL },   // M60008573 has a factor: 13441920353
  { 60008159, 33, 120ULL },   // M60008159 has a factor: 14401958161
  { 60005741, 33, 123ULL },   // M60005741 has a factor: 14761412287
  { 60002507, 33, 124ULL },   // M60002507 has a factor: 14880621737
  { 60008671, 33, 125ULL },   // M60008671 has a factor: 15002167751
  { 60006347, 33, 129ULL },   // M60006347 has a factor: 15481637527
  { 60007693, 34, 147ULL },   // M60007693 has a factor: 17642261743
  { 60005711, 34, 153ULL },   // M60005711 has a factor: 18361747567
  { 60007261, 34, 156ULL },   // M60007261 has a factor: 18722265433
  { 60008021, 34, 168ULL },   // M60008021 has a factor: 20162695057
  { 60009109, 34, 171ULL },   // M60009109 has a factor: 20523115279
  { 60003469, 34, 180ULL },   // M60003469 has a factor: 21601248841
  { 60007361, 34, 184ULL },   // M60007361 has a factor: 22082708849
  { 60002273, 34, 211ULL },   // M60002273 has a factor: 25320959207
  { 60004621, 34, 216ULL },   // M60004621 has a factor: 25921996273
  { 60005311, 34, 221ULL },   // M60005311 has a factor: 26522347463
  { 60003703, 34, 233ULL },   // M60003703 has a factor: 27961725599
  { 60000349, 34, 236ULL },   // M60000349 has a factor: 28320164729
  { 60009109, 34, 239ULL },   // M60009109 has a factor: 28684354103
  { 60003469, 34, 240ULL },   // M60003469 has a factor: 28801665121
  { 60003193, 34, 251ULL },   // M60003193 has a factor: 30121602887
  { 60002473, 34, 275ULL },   // M60002473 has a factor: 33001360151
  { 60007499, 34, 276ULL },   // M60007499 has a factor: 33124139449
  { 60008681, 34, 280ULL },   // M60008681 has a factor: 33604861361
  { 60009791, 34, 280ULL },   // M60009791 has a factor: 33605482961
  { 60007261, 35, 311ULL },   // M60007261 has a factor: 37324516343
  { 60002003, 35, 333ULL },   // M60002003 has a factor: 39961333999
  { 60004181, 35, 348ULL },   // M60004181 has a factor: 41762909977
  { 60009629, 35, 364ULL },   // M60009629 has a factor: 43687009913
  { 60002141, 35, 375ULL },   // M60002141 has a factor: 45001605751
  { 60001477, 35, 383ULL },   // M60001477 has a factor: 45961131383
  { 60008573, 35, 391ULL },   // M60008573 has a factor: 46926704087
  { 60008239, 35, 417ULL },   // M60008239 has a factor: 50046871327
  { 60006649, 35, 431ULL },   // M60006649 has a factor: 51725731439
  { 60005093, 35, 436ULL },   // M60005093 has a factor: 52324441097
  { 60002179, 35, 441ULL },   // M60002179 has a factor: 52921921879
  { 60005723, 35, 460ULL },   // M60005723 has a factor: 55205265161
  { 60008407, 35, 473ULL },   // M60008407 has a factor: 56767953023
  { 60009487, 35, 504ULL },   // M60009487 has a factor: 60489562897
  { 60004151, 35, 508ULL },   // M60004151 has a factor: 60964217417
  { 60002573, 35, 523ULL },   // M60002573 has a factor: 62762691359
  { 60000793, 35, 551ULL },   // M60000793 has a factor: 66120873887
  { 60007261, 36, 576ULL },   // M60007261 has a factor: 69128364673
  { 60007267, 36, 585ULL },   // M60007267 has a factor: 70208502391
  { 60009137, 36, 628ULL },   // M60009137 has a factor: 75371476073
  { 60009997, 36, 699ULL },   // M60009997 has a factor: 83893975807
  { 60002237, 36, 700ULL },   // M60002237 has a factor: 84003131801
  { 60005999, 36, 705ULL },   // M60005999 has a factor: 84608458591
  { 60003431, 36, 720ULL },   // M60003431 has a factor: 86404940641
  { 60000439, 36, 732ULL },   // M60000439 has a factor: 87840642697
  { 60007523, 36, 745ULL },   // M60007523 has a factor: 89411209271
  { 60006721, 36, 755ULL },   // M60006721 has a factor: 90610148711
  { 60009437, 36, 759ULL },   // M60009437 has a factor: 91094325367
  { 60005719, 36, 765ULL },   // M60005719 has a factor: 91808750071
  { 60008503, 36, 812ULL },   // M60008503 has a factor: 97453808873
  { 60008719, 36, 812ULL },   // M60008719 has a factor: 97454159657
  { 60008269, 36, 819ULL },   // M60008269 has a factor: 98293544623
  { 60000431, 36, 840ULL },   // M60000431 has a factor: 100800724081
  { 60006407, 36, 892ULL },   // M60006407 has a factor: 107051430089
  { 60006053, 36, 928ULL },   // M60006053 has a factor: 111371234369
  { 60000761, 36, 988ULL },   // M60000761 has a factor: 118561503737
  { 60001267, 36, 1044ULL },   // M60001267 has a factor: 125282645497
  { 60008687, 36, 1048ULL },   // M60008687 has a factor: 125778207953
  { 60006773, 36, 1120ULL },   // M60006773 has a factor: 134415171521
  { 60007219, 37, 1161ULL },   // M60007219 has a factor: 139336762519
  { 60008471, 37, 1173ULL },   // M60008471 has a factor: 140779872967
  { 60003509, 37, 1192ULL },   // M60003509 has a factor: 143048365457
  { 60006929, 37, 1227ULL },   // M60006929 has a factor: 147257003767
  { 60006077, 37, 1239ULL },   // M60006077 has a factor: 148695058807
  { 60000991, 37, 1353ULL },   // M60000991 has a factor: 162362681647
  { 60005531, 37, 1456ULL },   // M60005531 has a factor: 174736106273
  { 60000991, 37, 1469ULL },   // M60000991 has a factor: 176282911559
  { 60003971, 37, 1521ULL },   // M60003971 has a factor: 182532079783
  { 60008159, 37, 1600ULL },   // M60008159 has a factor: 192026108801
  { 60003287, 37, 1608ULL },   // M60003287 has a factor: 192970570993
  { 60001307, 37, 1645ULL },   // M60001307 has a factor: 197404300031
  { 60007499, 37, 1797ULL },   // M60007499 has a factor: 215666951407
  { 60004001, 37, 1980ULL },   // M60004001 has a factor: 237615843961
  { 60006677, 37, 2064ULL },   // M60006677 has a factor: 247707562657
  { 60004027, 37, 2184ULL },   // M60004027 has a factor: 262097589937
  { 60001367, 38, 2457ULL },   // M60001367 has a factor: 294846717439
  { 60002251, 38, 2493ULL },   // M60002251 has a factor: 299171223487
  { 60003247, 38, 2525ULL },   // M60003247 has a factor: 303016397351
  { 60003551, 38, 2553ULL },   // M60003551 has a factor: 306378131407
  { 60008621, 38, 2704ULL },   // M60008621 has a factor: 324526622369
  { 60006773, 38, 2728ULL },   // M60006773 has a factor: 327396953489
  { 60008687, 38, 2808ULL },   // M60008687 has a factor: 337008786193
  { 60001793, 38, 2811ULL },   // M60001793 has a factor: 337330080247
  { 60008209, 38, 2811ULL },   // M60008209 has a factor: 337366150999
  { 60006053, 38, 2887ULL },   // M60006053 has a factor: 346474950023
  { 60006259, 38, 2889ULL },   // M60006259 has a factor: 346716164503
  { 60006601, 38, 3039ULL },   // M60006601 has a factor: 364720120879
  { 60004547, 38, 3133ULL },   // M60004547 has a factor: 375988491503
  { 60005159, 38, 3489ULL },   // M60005159 has a factor: 418715999503
  { 60002819, 38, 3741ULL },   // M60002819 has a factor: 448941091759
  { 60000673, 38, 3795ULL },   // M60000673 has a factor: 455405108071
  { 60004387, 38, 3944ULL },   // M60004387 has a factor: 473314604657
  { 60005963, 38, 4492ULL },   // M60005963 has a factor: 539093571593
  { 60003743, 38, 4557ULL },   // M60003743 has a factor: 546874113703
  { 60009991, 39, 4928ULL },   // M60009991 has a factor: 591458471297
  { 60003469, 39, 5384ULL },   // M60003469 has a factor: 646117354193
  { 60002023, 39, 5477ULL },   // M60002023 has a factor: 657262159943
  { 60007049, 39, 5596ULL },   // M60007049 has a factor: 671598892409
  { 60006259, 39, 5612ULL },   // M60006259 has a factor: 673510251017
  { 60006647, 39, 5665ULL },   // M60006647 has a factor: 679875310511
  { 60002869, 39, 5747ULL },   // M60002869 has a factor: 689672976287
  { 60008089, 39, 6047ULL },   // M60008089 has a factor: 725737828367
  { 60006337, 39, 7163ULL },   // M60006337 has a factor: 859650783863
  { 60003721, 39, 8163ULL },   // M60003721 has a factor: 979620749047
  { 60003091, 39, 8708ULL },   // M60003091 has a factor: 1045013832857
  { 60005977, 39, 8783ULL },   // M60005977 has a factor: 1054064991983
  { 60000209, 39, 9135ULL },   // M60000209 has a factor: 1096203818431
  { 60005513, 40, 9351ULL },   // M60005513 has a factor: 1122223104127
  { 60004811, 40, 9816ULL },   // M60004811 has a factor: 1178014449553
  { 60007147, 40, 11009ULL },   // M60007147 has a factor: 1321237362647
  { 60001199, 40, 11101ULL },   // M60001199 has a factor: 1332146620199
  { 60003997, 40, 11639ULL },   // M60003997 has a factor: 1396773042167
  { 60008303, 40, 12513ULL },   // M60008303 has a factor: 1501767790879
  { 60008239, 40, 12621ULL },   // M60008239 has a factor: 1514727968839
  { 60000439, 40, 13889ULL },   // M60000439 has a factor: 1666692194543
  { 60009379, 40, 14637ULL },   // M60009379 has a factor: 1756714560847
  { 60005047, 40, 17645ULL },   // M60005047 has a factor: 2117578108631
  { 60000679, 41, 20112ULL },   // M60000679 has a factor: 2413467312097
  { 60006893, 41, 20152ULL },   // M60006893 has a factor: 2418517815473
  { 60008999, 41, 21924ULL },   // M60008999 has a factor: 2631274588153
  { 60008471, 41, 23829ULL },   // M60008471 has a factor: 2859883710919
  { 60001477, 41, 24164ULL },   // M60001477 has a factor: 2899751380457
  { 60002389, 41, 28836ULL },   // M60002389 has a factor: 3460457778409
  { 60005893, 41, 33120ULL },   // M60005893 has a factor: 3974790352321
  { 60000653, 41, 34795ULL },   // M60000653 has a factor: 4175445442271
  { 60002713, 41, 35651ULL },   // M60002713 has a factor: 4278313442327
  { 60000253, 41, 36195ULL },   // M60000253 has a factor: 4343418314671
  { 60002981, 41, 36244ULL },   // M60002981 has a factor: 4349496086729
  { 60001433, 41, 36460ULL },   // M60001433 has a factor: 4375304494361
  { 60000653, 42, 38080ULL },   // M60000653 has a factor: 4569649732481
  { 60006671, 42, 43648ULL },   // M60006671 has a factor: 5238342351617
  { 60009491, 42, 44013ULL },   // M60009491 has a factor: 5282395454767
  { 60001699, 42, 56672ULL },   // M60001699 has a factor: 6800832571457
  { 60002771, 42, 57316ULL },   // M60002771 has a factor: 6878237645273
  { 60004517, 42, 59932ULL },   // M60004517 has a factor: 7192381425689
  { 60004913, 42, 62668ULL },   // M60004913 has a factor: 7520775775769
  { 60008183, 42, 67072ULL },   // M60008183 has a factor: 8049737700353
  { 60000047, 43, 73332ULL },   // M60000047 has a factor: 8799846893209
  { 60004913, 43, 77928ULL },   // M60004913 has a factor: 9352125720529
  { 60003061, 43, 79820ULL },   // M60003061 has a factor: 9578888658041
  { 60008573, 43, 84955ULL },   // M60008573 has a factor: 10196056638431
  { 60007427, 43, 93669ULL },   // M60007427 has a factor: 11241671359327
  { 60008737, 43, 105788ULL },   // M60008737 has a factor: 12696408539513
  { 60007951, 43, 110673ULL },   // M60007951 has a factor: 13282519922047
  { 60000047, 43, 130824ULL },   // M60000047 has a factor: 15698892297457
  { 60000337, 43, 132168ULL },   // M60000337 has a factor: 15860249081233
  { 60008129, 43, 132600ULL },   // M60008129 has a factor: 15914155810801
  { 60000641, 43, 141975ULL },   // M60000641 has a factor: 17037182011951
  { 60003997, 44, 155687ULL },   // M60003997 has a factor: 18683684561879
  { 60001307, 44, 161637ULL },   // M60001307 has a factor: 19396862519119
  { 60005203, 44, 175476ULL },   // M60005203 has a factor: 21058946003257
  { 60009979, 44, 181845ULL },   // M60009979 has a factor: 21825029262511
  { 60007547, 44, 185913ULL },   // M60007547 has a factor: 22312366170823
  { 60005983, 44, 186992ULL },   // M60005983 has a factor: 22441277546273
  { 60000209, 44, 194100ULL },   // M60000209 has a factor: 23292081133801
  { 60005399, 44, 197760ULL },   // M60005399 has a factor: 23733335412481
  { 60001283, 44, 205257ULL },   // M60001283 has a factor: 24631366689463
  { 60003833, 44, 224200ULL },   // M60003833 has a factor: 26905718717201
  { 60009143, 44, 227976ULL },   // M60009143 has a factor: 27361288769137
  { 60000013, 44, 232836ULL },   // M60000013 has a factor: 27940326053737
  { 60002797, 44, 234779ULL },   // M60002797 has a factor: 28174793353727
  { 60004327, 44, 251324ULL },   // M60004327 has a factor: 30161054957897
  { 60008101, 44, 284795ULL },   // M60008101 has a factor: 34180014248591
  { 60006409, 44, 286371ULL },   // M60006409 has a factor: 34368190703479
  { 60006901, 45, 311015ULL },   // M60006901 has a factor: 37326092629031
  { 60005747, 45, 333540ULL },   // M60005747 has a factor: 40028633708761
  { 60009181, 45, 335720ULL },   // M60009181 has a factor: 40292564490641
  { 60007267, 45, 382848ULL },   // M60007267 has a factor: 45947324312833
  { 60001811, 45, 412773ULL },   // M60001811 has a factor: 49534255063807
  { 60006623, 45, 477105ULL },   // M60006623 has a factor: 57258919732831
  { 60009437, 45, 484320ULL },   // M60009437 has a factor: 58127541055681
  { 60000431, 45, 488793ULL },   // M60000431 has a factor: 58655581339567
  { 60006773, 45, 491652ULL },   // M60006773 has a factor: 59004899917993
  { 60001393, 45, 496415ULL },   // M60001393 has a factor: 59571183012191
  { 60001811, 45, 503388ULL },   // M60001811 has a factor: 60408383271337
  { 60000653, 45, 518292ULL },   // M60000653 has a factor: 62195716889353
  { 60002689, 45, 534824ULL },   // M60002689 has a factor: 64181756283473
  { 60002491, 45, 578465ULL },   // M60002491 has a factor: 69418681912631
  { 60005329, 46, 607119ULL },   // M60005329 has a factor: 72860750674303
  { 60005303, 46, 617545ULL },   // M60005303 has a factor: 74111949682271
  { 60003661, 46, 625539ULL },   // M60003661 has a factor: 75069260196559
  { 60003269, 46, 658056ULL },   // M60003269 has a factor: 78971022370129
  { 60009487, 46, 704660ULL },   // M60009487 has a factor: 84572570218841
  { 60004073, 46, 706827ULL },   // M60004073 has a factor: 84824997812743
  { 60008629, 46, 774812ULL },   // M60008629 has a factor: 92990811705497
  { 60007147, 46, 811325ULL },   // M60007147 has a factor: 97370597079551
  { 60001423, 46, 829157ULL },   // M60001423 has a factor: 99501199780823
  { 60007939, 46, 911517ULL },   // M60007939 has a factor: 109396513066927
  { 60004753, 46, 912963ULL },   // M60004753 has a factor: 109564238626279
  { 60004733, 46, 939415ULL },   // M60004733 has a factor: 112738692502391
  { 60006671, 46, 963460ULL },   // M60006671 has a factor: 115628054483321
  { 60006211, 46, 1013813ULL },   // M60006211 has a factor: 121670153585087
  { 60001199, 46, 1148341ULL },   // M60001199 has a factor: 137803673721719
  { 60003499, 47, 1242572ULL },   // M60003499 has a factor: 149117335518857
  { 60006913, 47, 1251488ULL },   // M60006913 has a factor: 150195863073089
  { 60003019, 47, 1257177ULL },   // M60003019 has a factor: 150868830834727
  { 60007267, 47, 1493493ULL },   // M60007267 has a factor: 179240866427263
  { 60002953, 47, 1494407ULL },   // M60002953 has a factor: 179337665967743
  { 60005549, 47, 1501560ULL },   // M60005549 has a factor: 180203864312881
  { 60002491, 47, 1510913ULL },   // M60002491 has a factor: 181317087368567
  { 60004331, 47, 1583845ULL },   // M60004331 has a factor: 190075119265391
  { 60003689, 47, 1918959ULL },   // M60003689 has a factor: 230289238079503
  { 60001873, 47, 1953728ULL },   // M60001873 has a factor: 234454678665089
  { 60003403, 47, 2060352ULL },   // M60003403 has a factor: 247256262755713
  { 60006433, 47, 2131335ULL },   // M60006433 has a factor: 255787621756111
  { 60005237, 47, 2176704ULL },   // M60005237 has a factor: 261227278797697
  { 60009013, 48, 2358308ULL },   // M60009013 has a factor: 283039470860009
  { 60005531, 48, 2452773ULL },   // M60005531 has a factor: 294359892574927
  { 60006521, 48, 2811748ULL },   // M60006521 has a factor: 337446430817417
  { 60005389, 48, 3212579ULL },   // M60005389 has a factor: 385544105176463
  { 60006151, 48, 3235500ULL },   // M60006151 has a factor: 388299803121001
  { 60009791, 48, 3459525ULL },   // M60009791 has a factor: 415210744418551
  { 60003271, 48, 3577196ULL },   // M60003271 has a factor: 429286922016233
  { 60002273, 48, 3685231ULL },   // M60002273 has a factor: 442244473060127
  { 60006467, 48, 3691732ULL },   // M60006467 has a factor: 443055588861689
  { 60009569, 48, 3802447ULL },   // M60009569 has a factor: 456366411230687
  { 60000251, 48, 4109209ULL },   // M60000251 has a factor: 493107142822919
  { 60004073, 48, 4344223ULL },   // M60004073 has a factor: 521342148040559
  { 60008503, 49, 4788896ULL },   // M60008503 has a factor: 574748959965377
  { 60007811, 49, 4850076ULL },   // M60007811 has a factor: 582084887887273
  { 60007907, 49, 4866880ULL },   // M60007907 has a factor: 584102564840321
  { 60002693, 49, 5258028ULL },   // M60002693 has a factor: 630991679738809
  { 60008903, 49, 5521236ULL },   // M60008903 has a factor: 662646631128217
  { 60001021, 49, 5578691ULL },   // M60001021 has a factor: 669454311687023
  { 60001463, 49, 5759332ULL },   // M60001463 has a factor: 691136691805433
  { 60001471, 49, 6211041ULL },   // M60001471 has a factor: 745343192882623
  { 60008647, 49, 6623912ULL },   // M60008647 has a factor: 794983993934129
  { 60000683, 49, 7202880ULL },   // M60000683 has a factor: 864355439134081
  { 60005317, 49, 7293908ULL },   // M60005317 has a factor: 875346523417673
  { 60000683, 49, 8270868ULL },   // M60000683 has a factor: 992515458005689
  { 60002617, 49, 9235895ULL },   // M60002617 has a factor: 1108355740674431
  { 60005447, 50, 9468217ULL },   // M60005447 has a factor: 1136289186755999
  { 60006299, 50, 10527664ULL },   // M60006299 has a factor: 1263452307511073
  { 60005441, 50, 10739248ULL },   // M60005441 has a factor: 1288826624496737
  { 60002477, 50, 11227512ULL },   // M60002477 has a factor: 1347357061094449
  { 60001223, 50, 12298345ULL },   // M60001223 has a factor: 1475831481751871
  { 60005713, 50, 13409007ULL },   // M60005713 has a factor: 1609234051313983
  { 60000253, 50, 15297875ULL },   // M60000253 has a factor: 1835752740724751
  { 60009487, 50, 15462177ULL },   // M60009487 has a factor: 1855754619346399
  { 60009569, 50, 15536895ULL },   // M60009569 has a factor: 1864724745096511
  { 60008503, 50, 15664736ULL },   // M60008503 has a factor: 1880034714500417
  { 60002869, 50, 15721632ULL },   // M60002869 has a factor: 1886686050724417
  { 60003721, 50, 17623755ULL },   // M60003721 has a factor: 2114981755984711
  { 60005531, 50, 18715393ULL },   // M60005531 has a factor: 2246054189677367
  { 60009179, 51, 19256181ULL },   // M60009179 has a factor: 2311095224970799
  { 60000403, 51, 20264145ULL },   // M60000403 has a factor: 2431713732900871
  { 60005587, 51, 21930213ULL },   // M60005587 has a factor: 2631870608200063
  { 60006403, 51, 22692701ULL },   // M60006403 has a factor: 2723414722729007
  { 60008089, 51, 23933727ULL },   // M60008089 has a factor: 2872434439835407
  { 60002489, 51, 24720219ULL },   // M60002489 has a factor: 2966549337250183
  { 60009419, 51, 25052740ULL },   // M60009419 has a factor: 3006800743516121
  { 60001849, 51, 25555715ULL },   // M60001849 has a factor: 3066780305034071
  { 60007327, 51, 27397152ULL },   // M60007327 has a factor: 3288059717865409
  { 60005713, 51, 27864827ULL },   // M60005713 has a factor: 3344097623513303
  { 60000023, 51, 28797676ULL },   // M60000023 has a factor: 3455722444693097
  { 60002489, 51, 31303392ULL },   // M60002489 has a factor: 3756562868285377
  { 60004411, 51, 34300224ULL },   // M60004411 has a factor: 4116329476576129
  { 60008293, 51, 36505983ULL },   // M60008293 has a factor: 4381323448234039
  { 60000103, 51, 37027253ULL },   // M60000103 has a factor: 4443277987614119
  { 60006449, 52, 38356311ULL },   // M60006449 has a factor: 4603252039699279
  { 60005159, 52, 42133549ULL },   // M60005159 has a factor: 5056460613958583
  { 60004129, 52, 46678092ULL },   // M60004129 has a factor: 5601756507683737
  { 60002489, 52, 53058292ULL },   // M60002489 has a factor: 6367259164177577
  { 60002993, 52, 53406735ULL },   // M60002993 has a factor: 6409127892715711
  { 60000211, 52, 56242233ULL },   // M60000211 has a factor: 6749091694222327
  { 60005159, 52, 58424404ULL },   // M60005159 has a factor: 7011531303000473
  { 60001021, 52, 60635696ULL },   // M60001021 has a factor: 7276407338091233
  { 60003043, 52, 62615528ULL },   // M60003043 has a factor: 7514244438103409
  { 60000541, 53, 85045008ULL },   // M60000541 has a factor: 10205492978698657
  { 60008887, 53, 91757225ULL },   // M60008887 has a factor: 11012497892917151
  { 60008651, 53, 112756068ULL },   // M60008651 has a factor: 13532679065488537
  { 60005899, 53, 124981101ULL },   // M60005899 has a factor: 14999206647029599
  { 60001147, 53, 130073828ULL },   // M60001147 has a factor: 15609157749361433
  { 60000071, 53, 138302805ULL },   // M60000071 has a factor: 16596356238998311
  { 60000067, 53, 140778128ULL },   // M60000067 has a factor: 16893394224269153
  { 60009889, 54, 166825091ULL },   // M60009889 has a factor: 20022310386649799
  { 60005123, 54, 241583121ULL },   // M60005123 has a factor: 28992449780657767
  { 60006833, 54, 242900323ULL },   // M60006833 has a factor: 29151358235814119
  { 60005233, 54, 276043331ULL },   // M60005233 has a factor: 33128088789502247
  { 60008539, 55, 329890104ULL },   // M60008539 has a factor: 39592446343196113
  { 60002153, 55, 366232428ULL },   // M60002153 has a factor: 43949468356834969
  { 60009709, 55, 543998019ULL },   // M60009709 has a factor: 65290325633532943
  { 60001351, 55, 579696120ULL },   // M60001351 has a factor: 69565100738916241
  { 60002021, 56, 605059011ULL },   // M60002021 has a factor: 72609526968522463
  { 60007979, 56, 629414497ULL },   // M60007979 has a factor: 75539783836543127
  { 60001637, 56, 686239767ULL },   // M60001637 has a factor: 82351018788997159
  { 60007151, 56, 848475108ULL },   // M60007151 has a factor: 101829147850994617
  { 60008833, 56, 878064260ULL },   // M60008833 has a factor: 105383223083217161
  { 60004979, 56, 951843181ULL },   // M60004979 has a factor: 114230660174396399
  { 60008677, 56, 1165182087ULL },   // M60008677 has a factor: 139842071009937799
  { 60002353, 57, 1721641491ULL },   // M60002353 has a factor: 206605080964856647
  { 60001349, 57, 1726131087ULL },   // M60001349 has a factor: 207140387541672727
  { 60007687, 57, 1847732669ULL },   // M60007687 has a factor: 221756327322053207
  { 60003089, 57, 2181993532ULL },   // M60003089 has a factor: 261852704196040697  end skip */
  { 60001237, 58, 2563304064ULL },   // M60001237 has a factor: 307602829294254337
  { 60006761, 58, 2663587080ULL },   // M60006761 has a factor: 319666466624495761
  { 60003157, 58, 3404512407ULL },   // M60003157 has a factor: 408562984931337799
  { 60008017, 58, 3676868648ULL },   // M60008017 has a factor: 441283192671902033
  { 60009827, 58, 4080970285ULL },   // M60009827 has a factor: 489796641589981391
  { 60009931, 59, 6042649461ULL },   // M60009931 has a factor: 725237954423594383
  { 60006181, 59, 6894845084ULL },   // M60006181 has a factor: 827466644154928409
  { 60007631, 59, 9291987076ULL },   // M60007631 has a factor: 1115180263426753913
  { 60003479, 60, 13275545949ULL },   // M60003479 has a factor: 1593157885128713143
  { 60001913, 60, 16252351135ULL },   // M60001913 has a factor: 1950344317695442511
  { 60002531, 61, 32036845168ULL },   // M60002531 has a factor: 3844583590670240417
  { 60002549, 61, 36055891015ULL },   // M60002549 has a factor: 4326890734732394471
  { 60005371, 62, 43027949420ULL },   // M60005371 has a factor: 5163816136632669641
  { 60008387, 62, 49583739672ULL },   // M60008387 has a factor: 5950880478289258129
  { 60005497, 62, 50865211319ULL },   // M60005497 has a factor: 6104384570413241087
  { 60008309, 62, 55459932147ULL },   // M60008309 has a factor: 6656113490792418847
  { 60009701, 62, 56315888143ULL },   // M60009701 has a factor: 6758999218021750487
  { 60009121, 62, 57333577508ULL },   // M60009121 has a factor: 6881075180080900937
  { 60004193, 62, 72020648952ULL },   // M60004193 has a factor: 8643081839402111473
  { 60003511, 63, 91880828649ULL },   // M60003511 has a factor: 11026344625058773279
  { 60002603, 63, 104075237440ULL },   // M60002603 has a factor: 12489570308486112641
  { 60007393, 63, 124699351796ULL },   // M60007393 has a factor: 14965766020135655657
  { 60004333, 63, 136606426127ULL },   // M60004333 has a factor: 16393954966528816583
  { 60008791, 64, 244596059409ULL },   // M60008791 has a factor: 29355827616996529039  class 9, 0.3%
  { 60008807, 64, 259574105937ULL },   // M60008807 has a factor: 31153464850741974319
  { 60003173, 65, 542202503032ULL },   // M60003173 has a factor: 65067741180924241073
  { 60002017, 66, 645764071988ULL },   // M60002017 has a factor: 77494293650826399593
  { 60000277, 66, 900078885083ULL },   // M60000277 has a factor: 108009964853662335983
  { 60008659, 66, 919681270124ULL },   // M60008659 has a factor: 110377679455116007433
  { 60007669, 67, 2212783918767ULL },   // M60007669 has a factor: 265568009931786048247
  { 60001507, 68, 2460213165605ULL },   // M60001507 has a factor: 295232994955081133471
  { 60004253, 68, 3118352232028ULL },   // M60004253 has a factor: 374228792547445630169
  { 60000049, 69, 5250034612427ULL },   // M60000049 has a factor: 630004667994632017847
  { 60000799, 69, 5779765242152ULL },   // M60000799 has a factor: 693581065123096958897
  { 60000587, 82, 55947442240407240ULL },   // M60000587 has a factor: 6713758751146059038099761

/* some (all) known factors from the primenet server (2010-02-14) http://www.mersenne.org/
for exponents from 332192857 to 332200000 (aka 100M digit range) */
/* mfakto does not deliver kernels below 58 bits: skip these
  { 332192879, 29, 1ULL },   // M332192879 has a factor: 664385759
  { 332192891, 29, 1ULL },   // M332192891 has a factor: 664385783
  { 332192963, 29, 1ULL },   // M332192963 has a factor: 664385927
  { 332193299, 29, 1ULL },   // M332193299 has a factor: 664386599
  { 332194283, 29, 1ULL },   // M332194283 has a factor: 664388567
  { 332194559, 29, 1ULL },   // M332194559 has a factor: 664389119
  { 332194799, 29, 1ULL },   // M332194799 has a factor: 664389599
  { 332195219, 29, 1ULL },   // M332195219 has a factor: 664390439
  { 332195471, 29, 1ULL },   // M332195471 has a factor: 664390943
  { 332195663, 29, 1ULL },   // M332195663 has a factor: 664391327
  { 332196071, 29, 1ULL },   // M332196071 has a factor: 664392143
  { 332196443, 29, 1ULL },   // M332196443 has a factor: 664392887
  { 332196863, 29, 1ULL },   // M332196863 has a factor: 664393727
  { 332197031, 29, 1ULL },   // M332197031 has a factor: 664394063
  { 332197223, 29, 1ULL },   // M332197223 has a factor: 664394447
  { 332199083, 29, 1ULL },   // M332199083 has a factor: 664398167
  { 332199863, 29, 1ULL },   // M332199863 has a factor: 664399727
  { 332192857, 30, 3ULL },   // M332192857 has a factor: 1993157143
  { 332192977, 30, 3ULL },   // M332192977 has a factor: 1993157863
  { 332193137, 30, 3ULL },   // M332193137 has a factor: 1993158823
  { 332193217, 30, 3ULL },   // M332193217 has a factor: 1993159303
  { 332194061, 30, 3ULL },   // M332194061 has a factor: 1993164367
  { 332194097, 30, 3ULL },   // M332194097 has a factor: 1993164583
  { 332194601, 30, 3ULL },   // M332194601 has a factor: 1993167607
  { 332195173, 30, 3ULL },   // M332195173 has a factor: 1993171039
  { 332195393, 30, 3ULL },   // M332195393 has a factor: 1993172359
  { 332195681, 30, 3ULL },   // M332195681 has a factor: 1993174087
  { 332197093, 30, 3ULL },   // M332197093 has a factor: 1993182559
  { 332194679, 31, 4ULL },   // M332194679 has a factor: 2657557433
  { 332197241, 31, 4ULL },   // M332197241 has a factor: 2657577929
  { 332197259, 31, 4ULL },   // M332197259 has a factor: 2657578073
  { 332197637, 31, 4ULL },   // M332197637 has a factor: 2657581097
  { 332198351, 31, 4ULL },   // M332198351 has a factor: 2657586809
  { 332198597, 31, 4ULL },   // M332198597 has a factor: 2657588777
  { 332194097, 32, 7ULL },   // M332194097 has a factor: 4650717359
  { 332196317, 32, 7ULL },   // M332196317 has a factor: 4650748439
  { 332198777, 32, 7ULL },   // M332198777 has a factor: 4650782879
  { 332198827, 32, 8ULL },   // M332198827 has a factor: 5315181233
  { 332194207, 32, 9ULL },   // M332194207 has a factor: 5979495727
  { 332195047, 32, 9ULL },   // M332195047 has a factor: 5979510847
  { 332195159, 32, 9ULL },   // M332195159 has a factor: 5979512863
  { 332195587, 32, 9ULL },   // M332195587 has a factor: 5979520567
  { 332196349, 32, 11ULL },   // M332196349 has a factor: 7308319679
  { 332193943, 32, 12ULL },   // M332193943 has a factor: 7972654633
  { 332197597, 32, 12ULL },   // M332197597 has a factor: 7972742329
  { 332197699, 32, 12ULL },   // M332197699 has a factor: 7972744777
  { 332197963, 32, 12ULL },   // M332197963 has a factor: 7972751113
  { 332199757, 32, 12ULL },   // M332199757 has a factor: 7972794169
  { 332197933, 33, 15ULL },   // M332197933 has a factor: 9965937991
  { 332198129, 33, 16ULL },   // M332198129 has a factor: 10630340129
  { 332197087, 33, 17ULL },   // M332197087 has a factor: 11294700959
  { 332199247, 33, 17ULL },   // M332199247 has a factor: 11294774399
  { 332195441, 33, 19ULL },   // M332195441 has a factor: 12623426759
  { 332196017, 33, 19ULL },   // M332196017 has a factor: 12623448647
  { 332198533, 33, 20ULL },   // M332198533 has a factor: 13287941321
  { 332199793, 33, 20ULL },   // M332199793 has a factor: 13287991721
  { 332195821, 33, 23ULL },   // M332195821 has a factor: 15281007767
  { 332194931, 33, 24ULL },   // M332194931 has a factor: 15945356689
  { 332194139, 33, 25ULL },   // M332194139 has a factor: 16609706951
  { 332194931, 33, 25ULL },   // M332194931 has a factor: 16609746551
  { 332197169, 34, 27ULL },   // M332197169 has a factor: 17938647127
  { 332197633, 34, 27ULL },   // M332197633 has a factor: 17938672183
  { 332199167, 34, 28ULL },   // M332199167 has a factor: 18603153353
  { 332194193, 34, 31ULL },   // M332194193 has a factor: 20596039967
  { 332194847, 34, 33ULL },   // M332194847 has a factor: 21924859903
  { 332196947, 34, 33ULL },   // M332196947 has a factor: 21924998503
  { 332197031, 34, 33ULL },   // M332197031 has a factor: 21925004047
  { 332194193, 34, 36ULL },   // M332194193 has a factor: 23917981897
  { 332196169, 34, 39ULL },   // M332196169 has a factor: 25911301183
  { 332197169, 34, 39ULL },   // M332197169 has a factor: 25911379183
  { 332197681, 34, 44ULL },   // M332197681 has a factor: 29233395929
  { 332196223, 34, 45ULL },   // M332196223 has a factor: 29897660071
  { 332199851, 34, 49ULL },   // M332199851 has a factor: 32555585399
  { 332194207, 35, 57ULL },   // M332194207 has a factor: 37870139599
  { 332193601, 35, 63ULL },   // M332193601 has a factor: 41856393727
  { 332196317, 35, 67ULL },   // M332196317 has a factor: 44514306479
  { 332197637, 35, 72ULL },   // M332197637 has a factor: 47836459729
  { 332195293, 35, 75ULL },   // M332195293 has a factor: 49829293951
  { 332195527, 35, 77ULL },   // M332195527 has a factor: 51158111159
  { 332194703, 35, 88ULL },   // M332194703 has a factor: 58466267729
  { 332198437, 35, 95ULL },   // M332198437 has a factor: 63117703031
  { 332194361, 36, 108ULL },   // M332194361 has a factor: 71753981977
  { 332197169, 36, 115ULL },   // M332197169 has a factor: 76405348871
  { 332193707, 36, 129ULL },   // M332193707 has a factor: 85705976407
  { 332193689, 36, 132ULL },   // M332193689 has a factor: 87699133897
  { 332199779, 36, 132ULL },   // M332199779 has a factor: 87700741657
  { 332193221, 36, 136ULL },   // M332193221 has a factor: 90356556113
  { 332194273, 36, 140ULL },   // M332194273 has a factor: 93014396441
  { 332193769, 36, 155ULL },   // M332193769 has a factor: 102980068391
  { 332198777, 36, 184ULL },   // M332198777 has a factor: 122249149937
  { 332198281, 36, 203ULL },   // M332198281 has a factor: 134872502087
  { 332197909, 37, 207ULL },   // M332197909 has a factor: 137529934327
  { 332194147, 37, 213ULL },   // M332194147 has a factor: 141514706623
  { 332197223, 37, 240ULL },   // M332197223 has a factor: 159454667041
  { 332199799, 37, 249ULL },   // M332199799 has a factor: 165435499903
  { 332198267, 37, 273ULL },   // M332198267 has a factor: 181380253783
  { 332193203, 37, 285ULL },   // M332193203 has a factor: 189350125711
  { 332198221, 37, 291ULL },   // M332198221 has a factor: 193339364623
  { 332195579, 37, 300ULL },   // M332195579 has a factor: 199317347401
  { 332194561, 37, 308ULL },   // M332194561 has a factor: 204631849577
  { 332198623, 37, 317ULL },   // M332198623 has a factor: 210613926983
  { 332197111, 37, 348ULL },   // M332197111 has a factor: 231209189257
  { 332197637, 37, 372ULL },   // M332197637 has a factor: 247155041929
  { 332194067, 38, 444ULL },   // M332194067 has a factor: 294988331497
  { 332194519, 38, 444ULL },   // M332194519 has a factor: 294988732873
  { 332192921, 38, 456ULL },   // M332192921 has a factor: 302959943953
  { 332195063, 38, 456ULL },   // M332195063 has a factor: 302961897457
  { 332194091, 38, 496ULL },   // M332194091 has a factor: 329536538273
  { 332199953, 38, 496ULL },   // M332199953 has a factor: 329542353377
  { 332193871, 38, 545ULL },   // M332193871 has a factor: 362091319391
  { 332193089, 38, 555ULL },   // M332193089 has a factor: 368734328791
  { 332195471, 38, 588ULL },   // M332195471 has a factor: 390661873897
  { 332197543, 38, 617ULL },   // M332197543 has a factor: 409931768063
  { 332198777, 38, 648ULL },   // M332198777 has a factor: 430529614993
  { 332197367, 38, 724ULL },   // M332197367 has a factor: 481021787417
  { 332198057, 38, 820ULL },   // M332198057 has a factor: 544804813481
  { 332195557, 39, 840ULL },   // M332195557 has a factor: 558088535761
  { 332199799, 39, 881ULL },   // M332199799 has a factor: 585336045839
  { 332193203, 39, 925ULL },   // M332193203 has a factor: 614557425551
  { 332196863, 39, 1053ULL },   // M332196863 has a factor: 699606593479
  { 332194679, 39, 1056ULL },   // M332194679 has a factor: 701595162049
  { 332196283, 39, 1073ULL },   // M332196283 has a factor: 712893223319
  { 332192873, 39, 1132ULL },   // M332192873 has a factor: 752084664473
  { 332197933, 39, 1172ULL },   // M332197933 has a factor: 778671954953
  { 332193383, 39, 1341ULL },   // M332193383 has a factor: 890942653207
  { 332198159, 39, 1540ULL },   // M332198159 has a factor: 1023170329721
  { 332192909, 39, 1575ULL },   // M332192909 has a factor: 1046407663351
  { 332193803, 39, 1593ULL },   // M332193803 has a factor: 1058369456359
  { 332199863, 40, 1840ULL },   // M332199863 has a factor: 1222495495841
  { 332197373, 40, 1960ULL },   // M332197373 has a factor: 1302213702161
  { 332196523, 40, 2105ULL },   // M332196523 has a factor: 1398547361831
  { 332196311, 40, 2413ULL },   // M332196311 has a factor: 1603179396887
  { 332193947, 40, 2493ULL },   // M332193947 has a factor: 1656319019743
  { 332193383, 40, 2917ULL },   // M332193383 has a factor: 1938016196423
  { 332193119, 40, 3001ULL },   // M332193119 has a factor: 1993823100239
  { 332199577, 40, 3195ULL },   // M332199577 has a factor: 2122755297031
  { 332193299, 40, 3276ULL },   // M332193299 has a factor: 2176530495049
  { 332196077, 41, 3435ULL },   // M332196077 has a factor: 2282187048991
  { 332198501, 41, 3895ULL },   // M332198501 has a factor: 2587826322791
  { 332195327, 41, 4168ULL },   // M332195327 has a factor: 2769180245873
  { 332197603, 41, 4253ULL },   // M332197603 has a factor: 2825672811119
  { 332197909, 41, 4299ULL },   // M332197909 has a factor: 2856237621583
  { 332194679, 41, 4416ULL },   // M332194679 has a factor: 2933943404929
  { 332196863, 41, 6048ULL },   // M332196863 has a factor: 4018253254849
  { 332194519, 41, 6284ULL },   // M332194519 has a factor: 4175020714793
  { 332198437, 41, 6599ULL },   // M332198437 has a factor: 4384354971527
  { 332194703, 42, 8701ULL },   // M332194703 has a factor: 5780852221607
  { 332199757, 42, 8843ULL },   // M332199757 has a factor: 5875284902303
  { 332197967, 42, 9109ULL },   // M332197967 has a factor: 6051982562807
  { 332199121, 42, 9116ULL },   // M332199121 has a factor: 6056654374073
  { 332195401, 42, 9519ULL },   // M332195401 has a factor: 6324336044239
  { 332198149, 42, 10040ULL },   // M332198149 has a factor: 6670538831921
  { 332197109, 43, 13279ULL },   // M332197109 has a factor: 8822490820823
  { 332194321, 43, 15111ULL },   // M332194321 has a factor: 10039576769263
  { 332195293, 43, 17051ULL },   // M332195293 has a factor: 11328523881887
  { 332198743, 43, 18953ULL },   // M332198743 has a factor: 12592325552159
  { 332199247, 43, 20024ULL },   // M332199247 has a factor: 13303915443857
  { 332198849, 43, 23776ULL },   // M332198849 has a factor: 15796719667649
  { 332199643, 44, 28232ULL },   // M332199643 has a factor: 18757320642353
  { 332196283, 44, 37241ULL },   // M332196283 has a factor: 24742643550407
  { 332197603, 44, 38741ULL },   // M332197603 has a factor: 25739334675647
  { 332196409, 44, 44807ULL },   // M332196409 has a factor: 29769448996127
  { 332194199, 44, 47829ULL },   // M332194199 has a factor: 31777032687943
  { 332192929, 44, 48860ULL },   // M332192929 has a factor: 32461893021881
  { 332195557, 45, 57467ULL },   // M332195557 has a factor: 38180564148239
  { 332198807, 45, 61840ULL },   // M332198807 has a factor: 41086348449761
  { 332196127, 45, 67505ULL },   // M332196127 has a factor: 44849799106271
  { 332198561, 45, 71659ULL },   // M332198561 has a factor: 47610033365399
  { 332196649, 45, 73479ULL },   // M332196649 has a factor: 48818955143743
  { 332197111, 45, 73809ULL },   // M332197111 has a factor: 49038273131599
  { 332193161, 45, 74464ULL },   // M332193161 has a factor: 49472863081409
  { 332198623, 45, 78777ULL },   // M332198623 has a factor: 52339221848143
  { 332195063, 45, 89461ULL },   // M332195063 has a factor: 59437005062087
  { 332195443, 45, 101988ULL },   // M332195443 has a factor: 67759897681369
  { 332194847, 45, 104005ULL },   // M332194847 has a factor: 69099850124471
  { 332193137, 46, 110367ULL },   // M332193137 has a factor: 73326319902559
  { 332197933, 46, 118428ULL },   // M332197933 has a factor: 78683073618649
  { 332193569, 46, 124551ULL },   // M332193569 has a factor: 82750082425039
  { 332194969, 46, 126687ULL },   // M332194969 has a factor: 84169568075407
  { 332198123, 46, 134268ULL },   // M332198123 has a factor: 89207155157929
  { 332195207, 46, 141988ULL },   // M332195207 has a factor: 94335466103033
  { 332195531, 46, 157965ULL },   // M332195531 has a factor: 104950534108831
  { 332198707, 46, 173817ULL },   // M332198707 has a factor: 115483565309239
  { 332196649, 46, 185427ULL },   // M332196649 has a factor: 123196456068247
  { 332198351, 46, 205729ULL },   // M332198351 has a factor: 136685669105759
  { 332193709, 47, 226784ULL },   // M332193709 has a factor: 150672436203713
  { 332194699, 47, 232661ULL },   // M332194699 has a factor: 154577501728079
  { 332193013, 47, 288728ULL },   // M332193013 has a factor: 191826848514929
  { 332199563, 47, 308220ULL },   // M332199563 has a factor: 204781098615721
  { 332196023, 47, 320617ULL },   // M332196023 has a factor: 213015384612383
  { 332196307, 48, 583473ULL },   // M332196307 has a factor: 387655151668423
  { 332197319, 48, 672621ULL },   // M332197319 has a factor: 446885785806199
  { 332194969, 48, 696992ULL },   // M332194969 has a factor: 463074471666497
  { 332193601, 48, 775068ULL },   // M332193601 has a factor: 514945259879737
  { 332195989, 49, 939407ULL },   // M332195989 has a factor: 624134474877047
  { 332196287, 49, 988449ULL },   // M332196287 has a factor: 656718175377727
  { 332193709, 49, 994187ULL },   // M332193709 has a factor: 660525333939167
  { 332194657, 49, 1137923ULL },   // M332194657 has a factor: 756023881354823
  { 332193467, 49, 1148208ULL },   // M332193467 has a factor: 762854392714273
  { 332198827, 49, 1187624ULL },   // M332198827 has a factor: 789054599434097
  { 332196311, 49, 1460100ULL },   // M332196311 has a factor: 970079667382201
  { 332199691, 49, 1516593ULL },   // M332199691 has a factor: 1007623451945527
  { 332197237, 50, 1741923ULL },   // M332197237 has a factor: 1157324015333503
  { 332196071, 50, 2051029ULL },   // M332196071 has a factor: 1362687550614119
  { 332195951, 50, 2262700ULL },   // M332195951 has a factor: 1503319556655401
  { 332194141, 50, 2364588ULL },   // M332194141 has a factor: 1571004558957817
  { 332196283, 50, 2843216ULL },   // M332196283 has a factor: 1889011573932257
  { 332193269, 50, 2973376ULL },   // M332193269 has a factor: 1975470986812289
  { 332192863, 50, 3232965ULL },   // M332192863 has a factor: 2147935798657591
  { 332194283, 50, 3312936ULL },   // M332194283 has a factor: 2201076798289777
  { 332192989, 51, 3716927ULL },   // M332192989 has a factor: 2469474180049607
  { 332199181, 51, 3920195ULL },   // M332199181 has a factor: 2604571136720591
  { 332192863, 51, 4674852ULL },   // M332192863 has a factor: 3105904939962553
  { 332195587, 51, 4968177ULL },   // M332195587 has a factor: 3300812949669799
  { 332198707, 52, 9097380ULL },   // M332198707 has a factor: 6044275746175321
  { 332193803, 52, 9211141ULL },   // M332193803 has a factor: 6119767917518447
  { 332193989, 52, 10951264ULL },   // M332193989 has a factor: 7275888145504193
  { 332198213, 52, 10980660ULL },   // M332198213 has a factor: 7295511259121161
  { 332198437, 52, 11820872ULL },   // M332198437 has a factor: 7853750404754129
  { 332192863, 53, 14703681ULL },   // M332192863 has a factor: 9768915776057407
  { 332198917, 53, 16168824ULL },   // M332198917 has a factor: 10742531643927217
  { 332195009, 53, 17704164ULL },   // M332195009 has a factor: 11762469838634953
  { 332196013, 53, 18351015ULL },   // M332196013 has a factor: 12192268035006391
  { 332198267, 53, 19184817ULL },   // M332198267 has a factor: 12746325920224279
  { 332192929, 53, 20278335ULL },   // M332192929 has a factor: 13472638997786431
  { 332195173, 53, 21480200ULL },   // M332195173 has a factor: 14271237510149201
  { 332193299, 54, 27839625ULL },   // M332193299 has a factor: 18496273743345751
  { 332193661, 54, 31864191ULL },   // M332193661 has a factor: 21170164526186503
  { 332196041, 54, 46222743ULL },   // M332196041 has a factor: 30710024457520927
  { 332197301, 54, 47209728ULL },   // M332197301 has a factor: 31365888445088257
  { 332195707, 54, 48037545ULL },   // M332195707 has a factor: 31915732447638631
  { 332199451, 54, 48649845ULL },   // M332199451 has a factor: 32322903600470191
  { 332195191, 54, 48878061ULL },   // M332195191 has a factor: 32474113619209303
  { 332199457, 54, 52048535ULL },   // M332199457 has a factor: 34580990129290991
  { 332193769, 55, 55060776ULL },   // M332193769 has a factor: 36581693407009489
  { 332199631, 55, 56072228ULL },   // M332199631 has a factor: 37254346901895737
  { 332199103, 55, 76363008ULL },   // M332199103 has a factor: 50735445519963649
  { 332199377, 55, 85701660ULL },   // M332199377 has a factor: 56940076119731641
  { 332197321, 55, 88619456ULL },   // M332197321 has a factor: 58878291743354753
  { 332199697, 55, 104503304ULL },   // M332199697 has a factor: 69431931848597777
  { 332194211, 56, 126741880ULL },   // M332194211 has a factor: 84205837654513361
  { 332195719, 56, 131855196ULL },   // M332195719 has a factor: 87603463278211849
  { 332195863, 56, 169624532ULL },   // M332195863 has a factor: 112697135587422233
  { 332193139, 56, 194051225ULL },   // M332193139 has a factor: 128924971119090551
  { 332195687, 56, 203529613ULL },   // M332195687 has a factor: 135223319230758263
  { 332199001, 56, 203629080ULL },   // M332199001 has a factor: 135290753901098161
  { 332193259, 57, 224734097ULL },   // M332193259 has a factor: 149310304181704247
  { 332198747, 57, 260974464ULL },   // M332198747 has a factor: 173390779879593217
  { 332194147, 57, 274469024ULL },   // M332194147 has a factor: 182354006611205057
  { 332193137, 57, 274988919ULL },   // M332193137 has a factor: 182698863285697807
  { 332193947, 57, 362103133ULL },   // M332193947 has a factor: 240576937944671903
  { 332194327, 57, 387013637ULL },   // M332194327 has a factor: 257127469366074599
  { 332193053, 57, 421997196ULL },   // M332193053 has a factor: 280369073793358777   end skip */
  { 332192953, 58, 527503223ULL },   // M332192953 has a factor: 350465706730775039
  { 332192977, 58, 594222332ULL },   // M332192977 has a factor: 394792970933924729
  { 332197361, 58, 718216063ULL },   // M332197361 has a factor: 477178961512819487
  { 332195987, 58, 724454172ULL },   // M332195987 has a factor: 481321537407615529
  { 332195881, 59, 1253531559ULL },   // M332195881 has a factor: 832836041206616959
  { 332198803, 59, 1398886428ULL },   // M332198803 has a factor: 929416793829091369
  { 332193871, 59, 1403187144ULL },   // M332193871 has a factor: 932260338205588849
  { 332194663, 60, 2038665116ULL },   // M332194663 has a factor: 1354467342358951817
  { 332195933, 60, 2178277515ULL },   // M332195933 has a factor: 1447229862856692991
  { 332194981, 60, 3042225840ULL },   // M332194981 has a factor: 2021224310233018081
  { 332193047, 61, 4404911320ULL },   // M332193047 has a factor: 2926561826311184081
  { 332193569, 61, 4829527656ULL },   // M332193569 has a factor: 3208676057261688529
  { 332197069, 61, 4903793127ULL },   // M332197069 has a factor: 3258051407543489527
  { 332193203, 61, 5332673013ULL },   // M332193203 has a factor: 3542955457480261279
  { 332196757, 61, 6016146459ULL },   // M332196757 has a factor: 3997088686633666927
  { 332198467, 62, 12951433629ULL },   // M332198467 has a factor: 8604892794012093487
  { 332193629, 63, 14884578940ULL },   // M332193629 has a factor: 9889124588431146521
  { 332193013, 63, 23023051611ULL },   // M332193013 has a factor: 15296193766225187887
  { 332195503, 64, 34768671201ULL },   // M332195503 has a factor: 23099992436515618207
  { 332196197, 64, 41957877547ULL },   // M332196197 has a factor: 27876494710610177519
  { 332196463, 64, 49202125128ULL },   // M332196463 has a factor: 32689543879210044529
  { 332195111, 64, 52245394801ULL },   // M332195111 has a factor: 34711329450314035823
  { 332195729, 65, 92860536415ULL },   // M332195729 has a factor: 61695747179423943071
  { 332193469, 65, 93931219527ULL },   // M332193469 has a factor: 62406675324149338327
  { 332196379, 66, 115850972244ULL },   // M332196379 has a factor: 76970546966172608953
  { 332194567, 66, 152641497369ULL },   // M332194567 has a factor: 101413352249453188447
  { 332197897, 66, 175933372535ULL },   // M332197897 has a factor: 116889392736489117791
  { 332193817, 67, 232499484395ULL },   // M332193817 has a factor: 154469782343413971431
  { 332193019, 67, 369585210272ULL },   // M332193019 has a factor: 245547253556010982337
  { 332197979, 67, 431926706817ULL },   // M332197979 has a factor: 286970358161465845687
  { 332196673, 68, 493107936632ULL },   // M332196673 has a factor: 327617631958090450673
  { 332193149, 68, 568114683852ULL },   // M332193149 has a factor: 377447611643870659897
  { 332199163, 68, 594630384225ULL },   // M332199163 has a factor: 395071431867826807351
  { 332193721, 68, 806411594595ULL },   // M332193721 has a factor: 535769736532113075991
  { 332195893, 68, 834838090263ULL },   // M332195893 has a factor: 554659569810663779719
  { 332195359, 69, 1080379460985ULL },   // M332195359 has a factor: 717794085796277137231
  { 332193529, 69, 1508698848680ULL },   // M332193529 has a factor: 1002359989482492383441
  { 332194279, 69, 1527449764500ULL },   // M332194279 has a factor: 1014820146453594591001
  { 332194901, 69, 1578160474915ULL },   // M332194901 has a factor: 1048513725453002816831
  { 332194417, 69, 1755489119552ULL },   // M332194417 has a factor: 1166327369238839882369
  { 332193149, 70, 1850786672832ULL },   // M332193149 has a factor: 1229637305950589655937
  { 332197631, 70, 2508416914828ULL },   // M332197631 has a factor: 1666580313332380744937
  { 332194033, 70, 2603852997095ULL },   // M332194033 has a factor: 1729968856888250668271
  { 332197219, 71, 5417520283061ULL },   // M332197219 has a factor: 3599370343817914014719  (71.608 bits)
  { 332196937, 72, 8345291320155ULL },   // M332196937 has a factor: 5544560429856354730471
  { 332194351, 72, 10810045498316ULL },   // M332194351 has a factor: 7182072097187110425833
  { 332199223, 72, 12316666745133ULL },   // M332199223 has a factor: 8183174245366243263319
  { 332196173, 73, 15086682666063ULL },   // M332196173 has a factor: 10023476489863131153799
  { 332195561, 84, 50419803040370676ULL },   // M332195561 has a factor: 33498469513010884723538473

/* some (all) known factors from the primenet server (2010-02-14) http://www.mersenne.org/
for exponents from 800000000 to 800010000 */
/* mfakto does not deliver kernels below 58 bits: skip these
  { 800000171, 30, 1ULL },   // M800000171 has a factor: 1600000343
  { 800000711, 30, 1ULL },   // M800000711 has a factor: 1600001423
  { 800000759, 30, 1ULL },   // M800000759 has a factor: 1600001519
  { 800002319, 30, 1ULL },   // M800002319 has a factor: 1600004639
  { 800002331, 30, 1ULL },   // M800002331 has a factor: 1600004663
  { 800002811, 30, 1ULL },   // M800002811 has a factor: 1600005623
  { 800002919, 30, 1ULL },   // M800002919 has a factor: 1600005839
  { 800003339, 30, 1ULL },   // M800003339 has a factor: 1600006679
  { 800004311, 30, 1ULL },   // M800004311 has a factor: 1600008623
  { 800004743, 30, 1ULL },   // M800004743 has a factor: 1600009487
  { 800005931, 30, 1ULL },   // M800005931 has a factor: 1600011863
  { 800006639, 30, 1ULL },   // M800006639 has a factor: 1600013279
  { 800007251, 30, 1ULL },   // M800007251 has a factor: 1600014503
  { 800007563, 30, 1ULL },   // M800007563 has a factor: 1600015127
  { 800008463, 30, 1ULL },   // M800008463 has a factor: 1600016927
  { 800008823, 30, 1ULL },   // M800008823 has a factor: 1600017647
  { 800009351, 30, 1ULL },   // M800009351 has a factor: 1600018703
  { 800009531, 30, 1ULL },   // M800009531 has a factor: 1600019063
  { 800000557, 32, 3ULL },   // M800000557 has a factor: 4800003343
  { 800003957, 32, 3ULL },   // M800003957 has a factor: 4800023743
  { 800004113, 32, 3ULL },   // M800004113 has a factor: 4800024679
  { 800004553, 32, 3ULL },   // M800004553 has a factor: 4800027319
  { 800004593, 32, 3ULL },   // M800004593 has a factor: 4800027559
  { 800005901, 32, 3ULL },   // M800005901 has a factor: 4800035407
  { 800007577, 32, 3ULL },   // M800007577 has a factor: 4800045463
  { 800007773, 32, 3ULL },   // M800007773 has a factor: 4800046639
  { 800008481, 32, 3ULL },   // M800008481 has a factor: 4800050887
  { 800000321, 32, 4ULL },   // M800000321 has a factor: 6400002569
  { 800000759, 32, 4ULL },   // M800000759 has a factor: 6400006073
  { 800001989, 32, 4ULL },   // M800001989 has a factor: 6400015913
  { 800003999, 32, 4ULL },   // M800003999 has a factor: 6400031993
  { 800004287, 32, 4ULL },   // M800004287 has a factor: 6400034297
  { 800005967, 32, 4ULL },   // M800005967 has a factor: 6400047737
  { 800007191, 32, 4ULL },   // M800007191 has a factor: 6400057529
  { 800008067, 32, 4ULL },   // M800008067 has a factor: 6400064537
  { 800008757, 32, 4ULL },   // M800008757 has a factor: 6400070057
  { 800009429, 32, 4ULL },   // M800009429 has a factor: 6400075433
  { 800009831, 32, 4ULL },   // M800009831 has a factor: 6400078649
  { 800009849, 32, 4ULL },   // M800009849 has a factor: 6400078793
  { 800002267, 32, 5ULL },   // M800002267 has a factor: 8000022671
  { 800002531, 32, 5ULL },   // M800002531 has a factor: 8000025311
  { 800004847, 32, 5ULL },   // M800004847 has a factor: 8000048471
  { 800000521, 33, 8ULL },   // M800000521 has a factor: 12800008337
  { 800001211, 33, 8ULL },   // M800001211 has a factor: 12800019377
  { 800003401, 33, 8ULL },   // M800003401 has a factor: 12800054417
  { 800005627, 33, 8ULL },   // M800005627 has a factor: 12800090033
  { 800007997, 33, 8ULL },   // M800007997 has a factor: 12800127953
  { 800009473, 33, 8ULL },   // M800009473 has a factor: 12800151569
  { 800000659, 33, 9ULL },   // M800000659 has a factor: 14400011863
  { 800002139, 33, 9ULL },   // M800002139 has a factor: 14400038503
  { 800002699, 33, 9ULL },   // M800002699 has a factor: 14400048583
  { 800004871, 33, 9ULL },   // M800004871 has a factor: 14400087679
  { 800007067, 33, 9ULL },   // M800007067 has a factor: 14400127207
  { 800008051, 33, 9ULL },   // M800008051 has a factor: 14400144919
  { 800007409, 34, 11ULL },   // M800007409 has a factor: 17600162999
  { 800003723, 34, 12ULL },   // M800003723 has a factor: 19200089353
  { 800007617, 34, 12ULL },   // M800007617 has a factor: 19200182809
  { 800004347, 34, 13ULL },   // M800004347 has a factor: 20800113023
  { 800002249, 34, 15ULL },   // M800002249 has a factor: 24000067471
  { 800002649, 34, 15ULL },   // M800002649 has a factor: 24000079471
  { 800006869, 34, 15ULL },   // M800006869 has a factor: 24000206071
  { 800007937, 34, 15ULL },   // M800007937 has a factor: 24000238111
  { 800002649, 34, 19ULL },   // M800002649 has a factor: 30400100663
  { 800007869, 34, 19ULL },   // M800007869 has a factor: 30400299023
  { 800000041, 34, 20ULL },   // M800000041 has a factor: 32000001641
  { 800001211, 34, 20ULL },   // M800001211 has a factor: 32000048441
  { 800003107, 34, 20ULL },   // M800003107 has a factor: 32000124281
  { 800004973, 34, 20ULL },   // M800004973 has a factor: 32000198921
  { 800002639, 34, 21ULL },   // M800002639 has a factor: 33600110839
  { 800005403, 34, 21ULL },   // M800005403 has a factor: 33600226927
  { 800009099, 34, 21ULL },   // M800009099 has a factor: 33600382159
  { 800002909, 35, 24ULL },   // M800002909 has a factor: 38400139633
  { 800005439, 35, 24ULL },   // M800005439 has a factor: 38400261073
  { 800000573, 35, 27ULL },   // M800000573 has a factor: 43200030943
  { 800006573, 35, 28ULL },   // M800006573 has a factor: 44800368089
  { 800006741, 35, 28ULL },   // M800006741 has a factor: 44800377497
  { 800002453, 35, 32ULL },   // M800002453 has a factor: 51200156993
  { 800004097, 35, 32ULL },   // M800004097 has a factor: 51200262209
  { 800009557, 35, 35ULL },   // M800009557 has a factor: 56000668991
  { 800001463, 35, 36ULL },   // M800001463 has a factor: 57600105337
  { 800002781, 35, 39ULL },   // M800002781 has a factor: 62400216919
  { 800001269, 35, 40ULL },   // M800001269 has a factor: 64000101521
  { 800003903, 35, 40ULL },   // M800003903 has a factor: 64000312241
  { 800006261, 35, 40ULL },   // M800006261 has a factor: 64000500881
  { 800004769, 36, 44ULL },   // M800004769 has a factor: 70400419673
  { 800007067, 36, 45ULL },   // M800007067 has a factor: 72000636031
  { 800006741, 36, 51ULL },   // M800006741 has a factor: 81600687583
  { 800005139, 36, 52ULL },   // M800005139 has a factor: 83200534457
  { 800004511, 36, 56ULL },   // M800004511 has a factor: 89600505233
  { 800006663, 36, 61ULL },   // M800006663 has a factor: 97600812887
  { 800000473, 36, 80ULL },   // M800000473 has a factor: 128000075681
  { 800003129, 36, 84ULL },   // M800003129 has a factor: 134400525673
  { 800007937, 37, 92ULL },   // M800007937 has a factor: 147201460409
  { 800009351, 37, 93ULL },   // M800009351 has a factor: 148801739287
  { 800007881, 37, 99ULL },   // M800007881 has a factor: 158401560439
  { 800006393, 37, 115ULL },   // M800006393 has a factor: 184001470391
  { 800007433, 37, 132ULL },   // M800007433 has a factor: 211201962313
  { 800006351, 37, 133ULL },   // M800006351 has a factor: 212801689367
  { 800008141, 37, 140ULL },   // M800008141 has a factor: 224002279481
  { 800000933, 37, 156ULL },   // M800000933 has a factor: 249600291097
  { 800006981, 37, 163ULL },   // M800006981 has a factor: 260802275807
  { 800002403, 37, 168ULL },   // M800002403 has a factor: 268800807409
  { 800000609, 37, 171ULL },   // M800000609 has a factor: 273600208279
  { 800002157, 38, 180ULL },   // M800002157 has a factor: 288000776521
  { 800009473, 38, 183ULL },   // M800009473 has a factor: 292803467119
  { 800002639, 38, 197ULL },   // M800002639 has a factor: 315201039767
  { 800006029, 38, 200ULL },   // M800006029 has a factor: 320002411601
  { 800006947, 38, 248ULL },   // M800006947 has a factor: 396803445713
  { 800007841, 38, 248ULL },   // M800007841 has a factor: 396803889137
  { 800000359, 38, 261ULL },   // M800000359 has a factor: 417600187399
  { 800001211, 38, 276ULL },   // M800001211 has a factor: 441600668473
  { 800007983, 38, 280ULL },   // M800007983 has a factor: 448004470481
  { 800007721, 38, 291ULL },   // M800007721 has a factor: 465604493623
  { 800000209, 38, 296ULL },   // M800000209 has a factor: 473600123729
  { 800000741, 38, 303ULL },   // M800000741 has a factor: 484800449047
  { 800000063, 38, 336ULL },   // M800000063 has a factor: 537600042337
  { 800007589, 38, 339ULL },   // M800007589 has a factor: 542405145343
  { 800006453, 38, 340ULL },   // M800006453 has a factor: 544004388041
  { 800002603, 39, 348ULL },   // M800002603 has a factor: 556801811689
  { 800009563, 39, 356ULL },   // M800009563 has a factor: 569606808857
  { 800002003, 39, 360ULL },   // M800002003 has a factor: 576001442161
  { 800009503, 39, 365ULL },   // M800009503 has a factor: 584006937191
  { 800009101, 39, 375ULL },   // M800009101 has a factor: 600006825751
  { 800004731, 39, 396ULL },   // M800004731 has a factor: 633603746953
  { 800005483, 39, 432ULL },   // M800005483 has a factor: 691204737313
  { 800006503, 39, 456ULL },   // M800006503 has a factor: 729605930737
  { 800001649, 39, 471ULL },   // M800001649 has a factor: 753601553359
  { 800009333, 39, 480ULL },   // M800009333 has a factor: 768008959681
  { 800008969, 39, 492ULL },   // M800008969 has a factor: 787208825497
  { 800005901, 39, 519ULL },   // M800005901 has a factor: 830406125239
  { 800000953, 39, 563ULL },   // M800000953 has a factor: 900801073079
  { 800000561, 39, 600ULL },   // M800000561 has a factor: 960000673201
  { 800002297, 39, 620ULL },   // M800002297 has a factor: 992002848281
  { 800002457, 40, 699ULL },   // M800002457 has a factor: 1118403434887
  { 800009333, 40, 711ULL },   // M800009333 has a factor: 1137613271527
  { 800004757, 40, 764ULL },   // M800004757 has a factor: 1222407268697
  { 800002669, 40, 771ULL },   // M800002669 has a factor: 1233604115599
  { 800009369, 40, 787ULL },   // M800009369 has a factor: 1259214746807
  { 800004167, 40, 829ULL },   // M800004167 has a factor: 1326406908887
  { 800007707, 40, 988ULL },   // M800007707 has a factor: 1580815229033
  { 800008463, 40, 988ULL },   // M800008463 has a factor: 1580816722889
  { 800009933, 40, 1087ULL },   // M800009933 has a factor: 1739221594343
  { 800008513, 40, 1092ULL },   // M800008513 has a factor: 1747218592393
  { 800005139, 40, 1137ULL },   // M800005139 has a factor: 1819211686087
  { 800007997, 40, 1163ULL },   // M800007997 has a factor: 1860818601023
  { 800003627, 40, 1165ULL },   // M800003627 has a factor: 1864008450911
  { 800001547, 40, 1253ULL },   // M800001547 has a factor: 2004803876783
  { 800006869, 41, 1380ULL },   // M800006869 has a factor: 2208018958441
  { 800000561, 41, 1384ULL },   // M800000561 has a factor: 2214401552849
  { 800006981, 41, 1528ULL },   // M800006981 has a factor: 2444821333937
  { 800006173, 41, 1580ULL },   // M800006173 has a factor: 2528019506681
  { 800008691, 41, 1636ULL },   // M800008691 has a factor: 2617628436953
  { 800002603, 41, 1881ULL },   // M800002603 has a factor: 3009609792487
  { 800002781, 41, 1936ULL },   // M800002781 has a factor: 3097610768033
  { 800002667, 41, 1984ULL },   // M800002667 has a factor: 3174410582657
  { 800005853, 41, 2056ULL },   // M800005853 has a factor: 3289624067537
  { 800004679, 41, 2364ULL },   // M800004679 has a factor: 3782422122313
  { 800002741, 41, 2576ULL },   // M800002741 has a factor: 4121614121633
  { 800004769, 41, 2604ULL },   // M800004769 has a factor: 4166424836953
  { 800001247, 41, 2685ULL },   // M800001247 has a factor: 4296006696391
  { 800001677, 42, 3135ULL },   // M800001677 has a factor: 5016010514791
  { 800008633, 42, 3855ULL },   // M800008633 has a factor: 6168066560431
  { 800007401, 42, 3879ULL },   // M800007401 has a factor: 6206457416959
  { 800001271, 42, 4308ULL },   // M800001271 has a factor: 6892810950937
  { 800004167, 42, 4317ULL },   // M800004167 has a factor: 6907235977879
  { 800002909, 42, 4460ULL },   // M800002909 has a factor: 7136025948281
  { 800005741, 42, 4676ULL },   // M800005741 has a factor: 7481653689833
  { 800001767, 42, 5205ULL },   // M800001767 has a factor: 8328018394471
  { 800008393, 43, 6471ULL },   // M800008393 has a factor: 10353708622207
  { 800007869, 43, 6684ULL },   // M800007869 has a factor: 10694505192793
  { 800000749, 43, 7052ULL },   // M800000749 has a factor: 11283210563897
  { 800006827, 43, 7764ULL },   // M800006827 has a factor: 12422506009657
  { 800003389, 43, 7856ULL },   // M800003389 has a factor: 12569653247969
  { 800004109, 43, 8879ULL },   // M800004109 has a factor: 14206472967623
  { 800007653, 43, 9495ULL },   // M800007653 has a factor: 15192145330471
  { 800005511, 43, 9501ULL },   // M800005511 has a factor: 15201704720023
  { 800001121, 43, 9515ULL },   // M800001121 has a factor: 15224021332631
  { 800000711, 43, 9676ULL },   // M800000711 has a factor: 15481613759273
  { 800000449, 43, 10356ULL },   // M800000449 has a factor: 16569609299689
  { 800009129, 43, 10591ULL },   // M800009129 has a factor: 16945793370479
  { 800006947, 44, 13052ULL },   // M800006947 has a factor: 20883381344489
  { 800005859, 44, 14505ULL },   // M800005859 has a factor: 23208169969591
  { 800002967, 44, 15453ULL },   // M800002967 has a factor: 24724891698103
  { 800006351, 44, 16521ULL },   // M800006351 has a factor: 26433809849743
  { 800000287, 44, 17165ULL },   // M800000287 has a factor: 27464009852711
  { 800004743, 44, 18117ULL },   // M800004743 has a factor: 28987371857863
  { 800000209, 44, 18435ULL },   // M800000209 has a factor: 29496007705831
  { 800002781, 44, 20224ULL },   // M800002781 has a factor: 32358512485889
  { 800002667, 44, 21505ULL },   // M800002667 has a factor: 34408114707671
  { 800002387, 44, 21657ULL },   // M800002387 has a factor: 34651303390519
  { 800007433, 45, 22311ULL },   // M800007433 has a factor: 35697931675327
  { 800003903, 45, 22497ULL },   // M800003903 has a factor: 35995375611583
  { 800006387, 45, 24384ULL },   // M800006387 has a factor: 39014711481217
  { 800000359, 45, 25385ULL },   // M800000359 has a factor: 40616018226431
  { 800002039, 45, 27137ULL },   // M800002039 has a factor: 43419310664687
  { 800008213, 45, 28431ULL },   // M800008213 has a factor: 45490067007607
  { 800005879, 45, 28460ULL },   // M800005879 has a factor: 45536334632681
  { 800001071, 45, 28560ULL },   // M800001071 has a factor: 45696061175521
  { 800007757, 45, 28692ULL },   // M800007757 has a factor: 45907645127689
  { 800007779, 45, 29289ULL },   // M800007779 has a factor: 46862855678263
  { 800007751, 45, 29340ULL },   // M800007751 has a factor: 46944454828681
  { 800005541, 45, 29520ULL },   // M800005541 has a factor: 47232327140641
  { 800006293, 45, 29576ULL },   // M800006293 has a factor: 47321972243537
  { 800006323, 45, 30317ULL },   // M800006323 has a factor: 48507583388783
  { 800004131, 45, 35724ULL },   // M800004131 has a factor: 57158695151689
  { 800006059, 45, 40449ULL },   // M800006059 has a factor: 64718890160983
  { 800008481, 45, 40780ULL },   // M800008481 has a factor: 65248691710361
  { 800009303, 45, 40873ULL },   // M800009303 has a factor: 65397560483039
  { 800000857, 45, 42504ULL },   // M800000857 has a factor: 68006472851857
  { 800008751, 46, 45525ULL },   // M800008751 has a factor: 72840796778551
  { 800007449, 46, 47116ULL },   // M800007449 has a factor: 75386301934169
  { 800002267, 46, 56337ULL },   // M800002267 has a factor: 90139455431959
  { 800002387, 46, 62649ULL },   // M800002387 has a factor: 100238699086327
  { 800003929, 46, 64755ULL },   // M800003929 has a factor: 103608508844791
  { 800005627, 46, 74360ULL },   // M800005627 has a factor: 118976836847441
  { 800009593, 46, 77276ULL },   // M800009593 has a factor: 123643082617337
  { 800008691, 46, 79045ULL },   // M800008691 has a factor: 126473373960191
  { 800008733, 46, 81915ULL },   // M800008733 has a factor: 131065430727391
  { 800006113, 46, 86583ULL },   // M800006113 has a factor: 138533858563759
  { 800004503, 47, 98581ULL },   // M800004503 has a factor: 157730487820487
  { 800001949, 47, 99275ULL },   // M800001949 has a factor: 158840386973951
  { 800005891, 47, 102461ULL },   // M800005891 has a factor: 163938807195503
  { 800003317, 47, 104724ULL },   // M800003317 has a factor: 167559094739017
  { 800002501, 47, 113883ULL },   // M800002501 has a factor: 182213369642767
  { 800004349, 47, 114551ULL },   // M800004349 has a factor: 183282596364599
  { 800003753, 47, 130192ULL },   // M800003753 has a factor: 208308177221153
  { 800005439, 47, 138420ULL },   // M800005439 has a factor: 221473505732761
  { 800002453, 47, 143963ULL },   // M800002453 has a factor: 230341506282479
  { 800007583, 47, 154560ULL },   // M800007583 has a factor: 247298344056961
  { 800002249, 47, 160860ULL },   // M800002249 has a factor: 257376723548281
  { 800009333, 47, 161203ULL },   // M800009333 has a factor: 257927809015199
  { 800009593, 47, 167160ULL },   // M800009593 has a factor: 267459207131761
  { 800007557, 47, 174480ULL },   // M800007557 has a factor: 279170637090721
  { 800001151, 48, 177825ULL },   // M800001151 has a factor: 284520409353151
  { 800002241, 48, 188863ULL },   // M800002241 has a factor: 302181646483967
  { 800004319, 48, 190140ULL },   // M800004319 has a factor: 304225642429321
  { 800006833, 48, 213552ULL },   // M800006833 has a factor: 341686118401633
  { 800009741, 48, 217075ULL },   // M800009741 has a factor: 347324229055151
  { 800008067, 48, 220077ULL },   // M800008067 has a factor: 352126750722319
  { 800006551, 48, 249660ULL },   // M800006551 has a factor: 399459271045321
  { 800002097, 48, 273195ULL },   // M800002097 has a factor: 437113145779831
  { 800003693, 49, 385923ULL },   // M800003693 has a factor: 617479650427279
  { 800003563, 49, 393672ULL },   // M800003563 has a factor: 629878005306673
  { 800009857, 49, 399867ULL },   // M800009857 has a factor: 639795082978039
  { 800006173, 49, 400715ULL },   // M800006173 has a factor: 641148947227391
  { 800005121, 49, 446376ULL },   // M800005121 has a factor: 714206171782993
  { 800005541, 49, 477988ULL },   // M800005541 has a factor: 764786097063017
  { 800004827, 49, 518965ULL },   // M800004827 has a factor: 830349010088111
  { 800006257, 49, 529547ULL },   // M800006257 has a factor: 847281826751159
  { 800009131, 49, 540368ULL },   // M800009131 has a factor: 864598668200417
  { 800008943, 49, 572985ULL },   // M800008943 has a factor: 916786248409711
  { 800009887, 49, 597665ULL },   // M800009887 has a factor: 956275818227711
  { 800009213, 49, 656595ULL },   // M800009213 has a factor: 1050564098419471
  { 800007499, 50, 807536ULL },   // M800007499 has a factor: 1292069711424929
  { 800000527, 50, 919968ULL },   // M800000527 has a factor: 1471949769646273
  { 800004287, 50, 926409ULL },   // M800004287 has a factor: 1482262343030767
  { 800006113, 50, 947171ULL },   // M800006113 has a factor: 1515485180112647
  { 800007463, 50, 950201ULL },   // M800007463 has a factor: 1520335782700127
  { 800006941, 50, 1035624ULL },   // M800006941 has a factor: 1657012776532369
  { 800007409, 50, 1086912ULL },   // M800007409 has a factor: 1739075305862017
  { 800004217, 50, 1206707ULL },   // M800004217 has a factor: 1930741377366839
  { 800008213, 50, 1307336ULL },   // M800008213 has a factor: 2091759074301137
  { 800003539, 50, 1337105ULL },   // M800003539 has a factor: 2139377464029191
  { 800007193, 51, 1408083ULL },   // M800007193 has a factor: 2252953056682039
  { 800008367, 51, 1647613ULL },   // M800008367 has a factor: 2636208371155943
  { 800002919, 51, 1715385ULL },   // M800002919 has a factor: 2744626014417631
  { 800002451, 51, 1806256ULL },   // M800002451 has a factor: 2890018454266913
  { 800003713, 51, 1869348ULL },   // M800003713 has a factor: 2990970681778249
  { 800004973, 51, 2352236ULL },   // M800004973 has a factor: 3763600995339257
  { 800005663, 51, 2409633ULL },   // M800005663 has a factor: 3855440091503359
  { 800004761, 51, 2735019ULL },   // M800004761 has a factor: 4376056442850919
  { 800001131, 52, 2951641ULL },   // M800001131 has a factor: 4722632276611943
  { 800002741, 52, 3733656ULL },   // M800002741 has a factor: 5973870067902193
  { 800009339, 52, 3765996ULL },   // M800009339 has a factor: 6025663941273289
  { 800001179, 52, 4101864ULL },   // M800001179 has a factor: 6562992072195313
  { 800008189, 52, 4312799ULL },   // M800008189 has a factor: 6900549035022023
  { 800009531, 52, 4620048ULL },   // M800009531 has a factor: 7392164867354977
  { 800009779, 52, 4783124ULL },   // M800009779 has a factor: 7653091948339193
  { 800009491, 52, 4997784ULL },   // M800009491 has a factor: 7996549267935889
  { 800008367, 52, 5009868ULL },   // M800008367 has a factor: 8015872635131113
  { 800000557, 52, 5163332ULL },   // M800000557 has a factor: 8261336951951849
  { 800005769, 52, 5182335ULL },   // M800005769 has a factor: 8291795793781231
  { 800000429, 52, 5246847ULL },   // M800000429 has a factor: 8394959701794727
  { 800006189, 53, 5741076ULL },   // M800006189 has a factor: 9185792663038729
  { 800002199, 53, 5779212ULL },   // M800002199 has a factor: 9246764616974377
  { 800007499, 53, 6213420ULL },   // M800007499 has a factor: 9941565188873161
  { 800003317, 53, 6270195ULL },   // M800003317 has a factor: 10032353596473631
  { 800006413, 53, 6298511ULL },   // M800006413 has a factor: 10077698384702087
  { 800006509, 53, 7464464ULL },   // M800006509 has a factor: 11943239572392353
  { 800009027, 53, 7933284ULL },   // M800009027 has a factor: 12693397627509337
  { 800008603, 53, 8367873ULL },   // M800008603 has a factor: 13388740777622839
  { 800005597, 53, 8823359ULL },   // M800005597 has a factor: 14117473168680647
  { 800002279, 53, 9238685ULL },   // M800002279 has a factor: 14781938109926231
  { 800007973, 53, 10141803ULL },   // M800007973 has a factor: 16227046521190639
  { 800000657, 53, 10934988ULL },   // M800000657 has a factor: 17495995168574233
  { 800007379, 54, 12101981ULL },   // M800007379 has a factor: 19363348201035599
  { 800004599, 54, 14239936ULL },   // M800004599 has a factor: 22784028578931329
  { 800000809, 54, 15228215ULL },   // M800000809 has a factor: 24365168639251871
  { 800009569, 54, 16423572ULL },   // M800009569 has a factor: 26278029514320937
  { 800008939, 54, 18387485ULL },   // M800008939 has a factor: 29420304731456831
  { 800007181, 55, 25074908ULL },   // M800007181 has a factor: 40120212925828697
  { 800009359, 55, 31664265ULL },   // M800009359 has a factor: 50663416691712271
  { 800007023, 55, 35006401ULL },   // M800007023 has a factor: 56010733299908447
  { 800009417, 55, 37005564ULL },   // M800009417 has a factor: 59209599362792377
  { 800009417, 55, 42601420ULL },   // M800009417 has a factor: 68163074355144281
  { 800005163, 56, 52916928ULL },   // M800005163 has a factor: 84667631220198529
  { 800001281, 56, 76731144ULL },   // M800001281 has a factor: 122770026985190929
  { 800003311, 56, 78822249ULL },   // M800003311 has a factor: 126116120360932879
  { 800008177, 57, 115262312ULL },   // M800008177 has a factor: 184421584199850449
  { 800005447, 57, 148096644ULL },   // M800005447 has a factor: 236956243764839737   end skip */
  { 800009293, 58, 195263607ULL },   // M800009293 has a factor: 312425400369399703
  { 800003843, 58, 233053653ULL },   // M800003843 has a factor: 372887636050376959
  { 800009107, 58, 236086613ULL },   // M800009107 has a factor: 377742880881569183
  { 800007517, 58, 248028783ULL },   // M800007517 has a factor: 396849781664723623
  { 800003101, 58, 291024176ULL },   // M800003101 has a factor: 465640486531939553
  { 800009297, 58, 339261055ULL },   // M800009297 has a factor: 542823996220056671
  { 800001967, 59, 501349929ULL },   // M800001967 has a factor: 802161858710620687
  { 800004577, 59, 569501048ULL },   // M800004577 has a factor: 911206890012593393
  { 800003431, 59, 581642729ULL },   // M800003431 has a factor: 930632357632406399
  { 800004433, 59, 604273820ULL },   // M800004433 has a factor: 966843469491688121
  { 800007823, 60, 803048981ULL },   // M800007823 has a factor: 1284890934104356727
  { 800004749, 60, 1063703659ULL },   // M800004749 has a factor: 1701935957457353183
  { 800003387, 60, 1170513328ULL },   // M800003387 has a factor: 1872829253857283873
  { 800005699, 60, 1346019692ULL },   // M800005699 has a factor: 2153646849132449417
  { 800008973, 61, 1757044083ULL },   // M800008973 has a factor: 2811302064713113519
  { 800003137, 61, 1776234659ULL },   // M800003137 has a factor: 2841986598496250567
  { 800007349, 61, 1861755344ULL },   // M800007349 has a factor: 2978835914480046113
  { 800005783, 61, 2181749568ULL },   // M800005783 has a factor: 3490824542915503489
  { 800000963, 62, 2910763116ULL },   // M800000963 has a factor: 4657226591729761417
  { 800002757, 62, 2942318043ULL },   // M800002757 has a factor: 4707725092741689103
  { 800008613, 62, 3268743663ULL },   // M800008613 has a factor: 5230046168178338839
  { 800007443, 62, 3494835405ULL },   // M800007443 has a factor: 5591788672119838831
  { 800002799, 62, 3911585109ULL },   // M800002799 has a factor: 6258558071453440183
  { 800009599, 62, 4204663845ULL },   // M800009599 has a factor: 6727542873136496311
  { 800006183, 63, 6694759488ULL },   // M800006183 has a factor: 10711697968195828609
  { 800009843, 63, 10501731576ULL },   // M800009843 has a factor: 16802977258687805137
  { 800000233, 69, 700130179352ULL },   // M800000233 has a factor: 1120208613223863578033
  { 800000011, 70, 955047115584ULL },   // M800000011 has a factor: 1528075405945436542849
  { 800000479, 72, 3089082494924ULL },   // M800000479 has a factor: 4942534951219430137193

/* some (all) known factors from ElevenSmooth "Operation Billion Digits"
2010-02-07 http://www.moregimps.it/billion/expo_f.php */
/* mfakto does not deliver kernels below 58 bits: skip these
  { 3321929603, 32, 1ULL },   // M3321929603 has a factor: 6643859207
  { 3321929843, 32, 1ULL },   // M3321929843 has a factor: 6643859687
  { 3321930431, 32, 1ULL },   // M3321930431 has a factor: 6643860863
  { 3321931199, 32, 1ULL },   // M3321931199 has a factor: 6643862399
  { 3321931559, 32, 1ULL },   // M3321931559 has a factor: 6643863119
  { 3321931859, 32, 1ULL },   // M3321931859 has a factor: 6643863719
  { 3321932891, 32, 1ULL },   // M3321932891 has a factor: 6643865783
  { 3321933071, 32, 1ULL },   // M3321933071 has a factor: 6643866143
  { 3321933971, 32, 1ULL },   // M3321933971 has a factor: 6643867943
  { 3321928661, 34, 3ULL },   // M3321928661 has a factor: 19931571967
  { 3321930301, 34, 3ULL },   // M3321930301 has a factor: 19931581807
  { 3321930793, 34, 3ULL },   // M3321930793 has a factor: 19931584759
  { 3321931213, 34, 3ULL },   // M3321931213 has a factor: 19931587279
  { 3321931337, 34, 3ULL },   // M3321931337 has a factor: 19931588023
  { 3321932701, 34, 3ULL },   // M3321932701 has a factor: 19931596207
  { 3321929357, 34, 4ULL },   // M3321929357 has a factor: 26575434857
  { 3321929969, 34, 4ULL },   // M3321929969 has a factor: 26575439753
  { 3321932897, 34, 4ULL },   // M3321932897 has a factor: 26575463177
  { 3321932851, 34, 5ULL },   // M3321932851 has a factor: 33219328511
  { 3321931133, 35, 7ULL },   // M3321931133 has a factor: 46507035863
  { 3321931973, 35, 7ULL },   // M3321931973 has a factor: 46507047623
  { 3321929683, 35, 8ULL },   // M3321929683 has a factor: 53150874929
  { 3321931927, 35, 8ULL },   // M3321931927 has a factor: 53150910833
  { 3321933211, 35, 8ULL },   // M3321933211 has a factor: 53150931377
  { 3321928607, 35, 9ULL },   // M3321928607 has a factor: 59794714927
  { 3321930587, 35, 9ULL },   // M3321930587 has a factor: 59794750567
  { 3321931957, 36, 12ULL },   // M3321931957 has a factor: 79726366969
  { 3321932473, 36, 12ULL },   // M3321932473 has a factor: 79726379353
  { 3321933053, 36, 12ULL },   // M3321933053 has a factor: 79726393273
  { 3321933709, 36, 12ULL },   // M3321933709 has a factor: 79726409017
  { 3321930757, 36, 15ULL },   // M3321930757 has a factor: 99657922711
  { 3321931313, 36, 15ULL },   // M3321931313 has a factor: 99657939391
  { 3321932479, 36, 20ULL },   // M3321932479 has a factor: 132877299161
  { 3321933721, 36, 20ULL },   // M3321933721 has a factor: 132877348841
  { 3321930583, 37, 33ULL },   // M3321930583 has a factor: 219247418479
  { 3321933917, 38, 43ULL },   // M3321933917 has a factor: 285686316863
  { 3321930769, 38, 44ULL },   // M3321930769 has a factor: 292329907673
  { 3321928189, 38, 47ULL },   // M3321928189 has a factor: 312261249767
  { 3321930431, 38, 48ULL },   // M3321930431 has a factor: 318905321377
  { 3321928679, 38, 49ULL },   // M3321928679 has a factor: 325549010543
  { 3321932353, 38, 56ULL },   // M3321932353 has a factor: 372056423537
  { 3321928501, 38, 59ULL },   // M3321928501 has a factor: 391987563119
  { 3321930839, 38, 61ULL },   // M3321930839 has a factor: 405275562359
  { 3321933697, 38, 63ULL },   // M3321933697 has a factor: 418563645823
  { 3321929777, 38, 64ULL },   // M3321929777 has a factor: 425207011457
  { 3321929749, 38, 71ULL },   // M3321929749 has a factor: 471714024359
  { 3321930529, 38, 71ULL },   // M3321930529 has a factor: 471714135119
  { 3321932189, 39, 84ULL },   // M3321932189 has a factor: 558084607753
  { 3321933397, 39, 84ULL },   // M3321933397 has a factor: 558084810697
  { 3321929879, 39, 85ULL },   // M3321929879 has a factor: 564728079431
  { 3321930769, 39, 96ULL },   // M3321930769 has a factor: 637810707649
  { 3321928121, 39, 103ULL },   // M3321928121 has a factor: 684317192927
  { 3321931051, 39, 113ULL },   // M3321931051 has a factor: 750756417527
  { 3321929867, 39, 117ULL },   // M3321929867 has a factor: 777331588879
  { 3321928619, 39, 120ULL },   // M3321928619 has a factor: 797262868561
  { 3321932377, 39, 123ULL },   // M3321932377 has a factor: 817195364743
  { 3321931517, 39, 135ULL },   // M3321931517 has a factor: 896921509591
  { 3321929129, 39, 160ULL },   // M3321929129 has a factor: 1063017321281
  { 3321931973, 39, 160ULL },   // M3321931973 has a factor: 1063018231361
  { 3321931313, 40, 172ULL },   // M3321931313 has a factor: 1142744371673
  { 3321932063, 40, 177ULL },   // M3321932063 has a factor: 1175963950303
  { 3321928949, 40, 207ULL },   // M3321928949 has a factor: 1375278584887
  { 3321929509, 40, 219ULL },   // M3321929509 has a factor: 1455005124943
  { 3321930841, 40, 255ULL },   // M3321930841 has a factor: 1694184728911
  { 3321930827, 40, 265ULL },   // M3321930827 has a factor: 1760623338311
  { 3321933781, 40, 288ULL },   // M3321933781 has a factor: 1913433857857
  { 3321930793, 41, 380ULL },   // M3321930793 has a factor: 2524667402681
  { 3321928703, 41, 388ULL },   // M3321928703 has a factor: 2577816673529
  { 3321929843, 41, 481ULL },   // M3321929843 has a factor: 3195696508967
  { 3321933691, 41, 489ULL },   // M3321933691 has a factor: 3248851149799
  { 3321933023, 41, 565ULL },   // M3321933023 has a factor: 3753784315991
  { 3321932423, 41, 616ULL },   // M3321932423 has a factor: 4092620745137
  { 3321933271, 42, 785ULL },   // M3321933271 has a factor: 5215435235471
  { 3321928097, 42, 927ULL },   // M3321928097 has a factor: 6158854691839
  { 3321932479, 42, 1032ULL },   // M3321932479 has a factor: 6856468636657
  { 3321930587, 42, 1104ULL },   // M3321930587 has a factor: 7334822736097
  { 3321933379, 42, 1124ULL },   // M3321933379 has a factor: 7467706235993
  { 3321932897, 42, 1288ULL },   // M3321932897 has a factor: 8557299142673
  { 3321933287, 42, 1300ULL },   // M3321933287 has a factor: 8637026546201
  { 3321931849, 43, 1404ULL },   // M3321931849 has a factor: 9327984631993
  { 3321930377, 43, 1692ULL },   // M3321930377 has a factor: 11241412395769
  { 3321932407, 43, 1692ULL },   // M3321932407 has a factor: 11241419265289
  { 3321931213, 43, 1751ULL },   // M3321931213 has a factor: 11633403107927
  { 3321929599, 43, 1764ULL },   // M3321929599 has a factor: 11719767625273
  { 3321928513, 43, 2220ULL },   // M3321928513 has a factor: 14749362597721
  { 3321933397, 43, 2424ULL },   // M3321933397 has a factor: 16104733108657
  { 3321931763, 44, 3261ULL },   // M3321931763 has a factor: 21665638958287
  { 3321929867, 44, 3865ULL },   // M3321929867 has a factor: 25678517871911
  { 3321931813, 44, 5043ULL },   // M3321931813 has a factor: 33505004265919
  { 3321931541, 45, 5715ULL },   // M3321931541 has a factor: 37969677513631
  { 3321928097, 45, 6240ULL },   // M3321928097 has a factor: 41457662650561
  { 3321929029, 45, 6347ULL },   // M3321929029 has a factor: 42168567094127
  { 3321928189, 45, 6515ULL },   // M3321928189 has a factor: 43284724302671
  { 3321933607, 45, 9857ULL },   // M3321933607 has a factor: 65488599128399
  { 3321931661, 46, 12183ULL },   // M3321931661 has a factor: 80942186851927
  { 3321931973, 46, 13327ULL },   // M3321931973 has a factor: 88542774808343
  { 3321930841, 46, 14208ULL },   // M3321930841 has a factor: 94395986777857
  { 3321931897, 46, 15468ULL },   // M3321931897 has a factor: 102767285165593
  { 3321931117, 46, 15612ULL },   // M3321931117 has a factor: 103723977197209
  { 3321929959, 46, 16029ULL },   // M3321929959 has a factor: 106494430625623
  { 3321932249, 46, 19504ULL },   // M3321932249 has a factor: 129581933168993
  { 3321932759, 47, 22629ULL },   // M3321932759 has a factor: 150344032806823
  { 3321929993, 47, 37000ULL },   // M3321929993 has a factor: 245822819482001
  { 3321928391, 47, 39148ULL },   // M3321928391 has a factor: 260093705301737
  { 3321929129, 48, 61192ULL },   // M3321929129 has a factor: 406550974523537
  { 3321928109, 48, 61512ULL },   // M3321928109 has a factor: 408676883681617
  { 3321930769, 48, 65775ULL },   // M3321930769 has a factor: 436999992661951
  { 3321928531, 48, 65861ULL },   // M3321928531 has a factor: 437571069960383
  { 3321930421, 48, 75051ULL },   // M3321930421 has a factor: 498628400052943
  { 3321928121, 48, 75703ULL },   // M3321928121 has a factor: 502959849088127
  { 3321928703, 48, 84108ULL },   // M3321928703 has a factor: 558801558703849
  { 3321928391, 49, 87000ULL },   // M3321928391 has a factor: 578015540034001
  { 3321928919, 49, 119989ULL },   // M3321928919 has a factor: 797189858123783
  { 3321932423, 49, 125037ULL },   // M3321932423 has a factor: 830728928749303
  { 3321931729, 49, 134304ULL },   // M3321931729 has a factor: 892297437863233
  { 3321928217, 50, 175579ULL },   // M3321928217 has a factor: 1166521668825287
  { 3321929257, 50, 191972ULL },   // M3321929257 has a factor: 1275434806649609
  { 3321932149, 50, 268707ULL },   // M3321932149 has a factor: 1785252843922687
  { 3321929957, 50, 289252ULL },   // M3321929957 has a factor: 1921749767844329
  { 3321930893, 50, 295567ULL },   // M3321930893 has a factor: 1963706296502663
  { 3321929531, 50, 312313ULL },   // M3321929531 has a factor: 2074963555230407
  { 3321933709, 51, 380004ULL },   // M3321933709 has a factor: 2524696194309673
  { 3321932063, 51, 412860ULL },   // M3321932063 has a factor: 2742985743060361
  { 3321929587, 51, 429489ULL },   // M3321929587 has a factor: 2853464432782087
  { 3321931579, 51, 475257ULL },   // M3321931579 has a factor: 3157542472881607
  { 3321930817, 51, 481875ULL },   // M3321930817 has a factor: 3201510824883751
  { 3321933221, 51, 553300ULL },   // M3321933221 has a factor: 3676051302358601
  { 3321932597, 51, 563439ULL },   // M3321932597 has a factor: 3743412761042167
  { 3321931703, 51, 621136ULL },   // M3321931703 has a factor: 4126742740549217
  { 3321930893, 51, 671763ULL },   // M3321930893 has a factor: 4463100524948719
  { 3321929531, 52, 690093ULL },   // M3321929531 has a factor: 4584880631672767
  { 3321931007, 52, 733309ULL },   // M3321931007 has a factor: 4872003809624327
  { 3321929339, 52, 768556ULL },   // M3321929339 has a factor: 5106177450128969
  { 3321930317, 52, 814875ULL },   // M3321930317 has a factor: 5413915934130751
  { 3321929393, 52, 891276ULL },   // M3321929393 has a factor: 5921511883350937
  { 3321928567, 52, 960060ULL },   // M3321928567 has a factor: 6378501480068041
  { 3321933341, 52, 1035460ULL },   // M3321933341 has a factor: 6879458194543721
  { 3321931183, 52, 1107561ULL },   // M3321931183 has a factor: 7358482845949327
  { 3321931973, 52, 1166400ULL },   // M3321931973 has a factor: 7749402906614401
  { 3321929551, 52, 1230345ULL },   // M3321929551 has a factor: 8174238826850191
  { 3321928849, 53, 1417172ULL },   // M3321928849 has a factor: 9415489101590057
  { 3321931729, 53, 1629944ULL },   // M3321931729 has a factor: 10829125380186353
  { 3321929861, 53, 1868391ULL },   // M3321929861 has a factor: 12413327709847303
  { 3321933829, 53, 2148996ULL },   // M3321933829 has a factor: 14277645021571369
  { 3321931579, 53, 2420121ULL },   // M3321931579 has a factor: 16078952749802119
  { 3321931463, 53, 2497317ULL },   // M3321931463 has a factor: 16591831830769543
  { 3321928993, 54, 2828376ULL },   // M3321928993 has a factor: 18791328475010737
  { 3321932839, 54, 2863832ULL },   // M3321932839 has a factor: 19026915132358097
  { 3321931313, 54, 2958568ULL },   // M3321931313 has a factor: 19656319361679569
  { 3321932893, 54, 3553683ULL },   // M3321932893 has a factor: 23610192897989839
  { 3321933697, 54, 3893123ULL },   // M3321933697 has a factor: 25865392960531463
  { 3321931213, 54, 4223991ULL },   // M3321931213 has a factor: 28063615092662167
  { 3321929867, 54, 5239684ULL },   // M3321929867 has a factor: 34811725546484057
  { 3321929393, 54, 5270835ULL },   // M3321929393 has a factor: 35018683424306311
  { 3321932839, 55, 6570617ULL },   // M3321932839 has a factor: 43654296769583327
  { 3321928619, 55, 7327797ULL },   // M3321928619 has a factor: 48684837137044687
  { 3321933931, 55, 8389628ULL },   // M3321933931 has a factor: 55739579843335337
  { 3321928619, 55, 8892025ULL },   // M3321928619 has a factor: 59077344656726951
  { 3321933781, 56, 14692191ULL },   // M3321933781 has a factor: 97612971199608343
  { 3321931727, 56, 16491100ULL },   // M3321931727 has a factor: 109564616606259401
  { 3321931927, 57, 23164788ULL },   // M3321931927 has a factor: 153903697678772953
  { 3321930769, 57, 31528151ULL },   // M3321930769 has a factor: 209468669793156239
  { 3321933281, 57, 37202620ULL },   // M3321933281 has a factor: 247169243036792441   end skip */
  { 3321933073, 58, 56160011ULL },   // M3321933073 has a factor: 373119595841887607
  { 3321932591, 58, 66850224ULL },   // M3321932591 has a factor: 444143875642500769
  { 3321929129, 58, 67245844ULL },   // M3321929129 has a factor: 446771855975579753
  { 3321932099, 58, 72817924ULL },   // M3321932099 has a factor: 483792398236284953
  { 3321933473, 58, 73307343ULL },   // M3321933473 has a factor: 487044233056784479
  { 3321933473, 58, 75500260ULL },   // M3321933473 has a factor: 501613681828405961
  { 3321929843, 58, 78901228ULL },   // M3321929843 has a factor: 524208687885094409
  { 3321929477, 59, 89605180ULL },   // M3321929477 has a factor: 595324177467781721
  { 3321931981, 59, 93805959ULL },   // M3321931981 has a factor: 623234030420949559
  { 3321930047, 59, 120998172ULL },   // M3321930047 has a factor: 803894926397748169
  { 3321928991, 59, 142300185ULL },   // M3321928991 has a factor: 945422219952326671
  { 3321933397, 59, 146715695ULL },   // M3321933397 has a factor: 974759534169131831
  { 3321930839, 59, 158992936ULL },   // M3321930839 has a factor: 1056327074563106609
  { 3321933073, 61, 400769348ULL },   // M3321933073 has a factor: 2662657903531692809
  { 3321932953, 61, 532598700ULL },   // M3321932953 has a factor: 3538514344509922201
  { 3321928567, 61, 549413525ULL },   // M3321928567 has a factor: 3650224967587337351
  { 3321930817, 61, 689350739ULL },   // M3321930817 has a factor: 4579950927211647527
  { 3321930317, 62, 801027507ULL },   // M3321930317 has a factor: 5321915120508459439
  { 3321931957, 62, 984938652ULL },   // M3321931957 has a factor: 6543798367526603929
  { 3321931729, 62, 1186851432ULL },   // M3321931729 has a factor: 7885278859139771857
  { 3321932179, 63, 1460024880ULL },   // M3321932179 has a factor: 9700207262025227041
  { 3321931213, 63, 1963101651ULL },   // M3321931213 has a factor: 13042577297497465327
  { 3321929777, 63, 1989692928ULL },   // M3321929777 has a factor: 13219240369219034113
  { 3321930701, 63, 2035742611ULL },   // M3321930701 has a factor: 13525191757629600623
  { 3321930817, 63, 2080613835ULL },   // M3321930817 has a factor: 13823310433526106391
  { 3321930841, 63, 2530561248ULL },   // M3321930841 has a factor: 16812698909541299137
  { 3321931973, 64, 4016423448ULL },   // M3321931973 has a factor: 26684570938036205809
  { 3321933469, 64, 4667161176ULL },   // M3321933469 has a factor: 31007997831543599089
  { 3321929477, 65, 6108537892ULL },   // M3321929477 has a factor: 40584264169612484969
  { 3321933689, 65, 6661541896ULL },   // M3321933689 has a factor: 44258400890014668689
  { 3321932099, 65, 7682803957ULL },   // M3321932099 has a factor: 51043506150165031487
  { 3321931831, 65, 10267537485ULL },   // M3321931831 has a factor: 68216119194814370071
  { 3321931517, 65, 10611759067ULL },   // M3321931517 has a factor: 70503073790955629279
  { 3321931013, 65, 10788755307ULL },   // M3321931013 has a factor: 71679001691983271983
  { 3321928567, 66, 11167520232ULL },   // M3321928567 has a factor: 74195408962462535089
  { 3321931793, 66, 11678917503ULL },   // M3321931793 has a factor: 77593134722079745759
  { 3321928703, 66, 12050934813ULL },   // M3321928703 has a factor: 80064692506573275079
  { 3321930221, 66, 12199903263ULL },   // M3321930221 has a factor: 81054454685272422247
  { 3321928787, 66, 16384425312ULL },   // M3321928787 has a factor: 108855788204768513089
  { 3321933169, 66, 19116490796ULL },   // M3321933169 has a factor: 127007409700231225049
  { 3321929843, 66, 19972897321ULL },   // M3321929843 has a factor: 132697127323609301207
  { 3321930671, 66, 21510654421ULL },   // M3321930671 has a factor: 142913805348803292983
  { 3321931463, 67, 22464313428ULL },   // M3321931463 has a factor: 149249819142333170329
  { 3321929461, 67, 28646296443ULL },   // M3321929461 has a factor: 190321952205082414447
  { 3321928949, 67, 32943049887ULL },   // M3321928949 has a factor: 218868942175952957527
  { 3321930769, 67, 36766980680ULL },   // M3321930769 has a factor: 244274728808241085841
  { 3321928513, 67, 38682105743ULL },   // M3321928513 has a factor: 256998380021105500319
  { 3321930289, 68, 59194382247ULL },   // M3321930289 has a factor: 393279222649906358767
  { 3321928439, 68, 70524128169ULL },   // M3321928439 has a factor: 468552214000564196383
  { 3321931337, 68, 76145382348ULL },   // M3321931337 has a factor: 505899463579335678553
  { 3321928243, 69, 93229904040ULL },   // M3321928243 has a factor: 619406102645311603441
  { 3321931969, 69, 99810006639ULL },   // M3321931969 has a factor: 663124103760392684383
  { 3321932947, 69, 150253371513ULL },   // M3321932947 has a factor: 998263250453731877623
  { 3321932819, 69, 151702088425ULL },   // M3321932819 has a factor: 1007888292499695040151
  { 3321929579, 69, 158875882444ULL },   // M3321929579 has a factor: 1055548986560900822153
  { 3321931267, 69, 162390773433ULL },   // M3321931267 has a factor: 1078901975478791259223
  { 3321931111, 70, 256205911040ULL },   // M3321931111 has a factor: 1702196773411748730881
  { 3321931037, 70, 296232932380ULL },   // M3321931037 has a factor: 1968130744509288556121
  { 3321928921, 70, 320088740619ULL },   // M3321928921 has a factor: 2126624089497447084199
  { 3321929759, 71, 617575716316ULL },   // M3321929759 has a factor: 4103086300931724495689
  { 3321931637, 74, 4285913815420ULL },   // M3321931637 has a factor: 28475025393798152885081
  { 3321931061, 74, 4490333754576ULL },   // M3321931061 has a factor: 29833158347165530570273
  { 3321933893, 74, 5461440407140ULL },   // M3321933893 has a factor: 36285087986156170392041
  { 3321929827, 75, 11095452686288ULL },   // M3321929827 has a factor: 73716630445294762224353

/* some COMPOSITE factors build, each one build from two factors above (Operation Billion Digits) */
  { 3321928703, 90, 216815004777177520ULL },   // M3321928703 has a factor: 1440487975220776246028713121
  { 3321932063, 91, 485508476522096757ULL },   // M3321932063 has a factor: 3225652350034071890133239383
  { 3321932423, 91, 511729020109695685ULL },   // M3321932423 has a factor: 3399858447384834225329389511
  { 3321929843, 91, 524208687963995637ULL },   // M3321929843 has a factor: 3482768969014944032144189983
  { 3321931927, 92, 1231229581453348412ULL },   // M3321931927 has a factor: 8180121712193450301755099849
  { 3321931973, 92, 1239904465059470560ULL },   // M3321931973 has a factor: 8237756571893033199432429761
  { 3321933697, 93, 1629519756517375292ULL },   // M3321933697 has a factor: 10826313178204608696980029049
  { 3321931313, 94, 3380886930211844436ULL },   // M3321931313 has a factor: 22462148318366343510866448937
  { 3321929867, 94, 4072971888943874353ULL },   // M3321929867 has a factor: 27060253930668126599852002103
  { 3321928619, 94, 5842180456452690237ULL },   // M3321928619 has a factor: 38814612911305349835664385407

/* test cases that helped showing errors in mfakto */
  { 6599953, 25, 3 },   // M6599953 has a factor: 39599719

/* all known factors from primenet (2011-07-16) with at least 20 digits and a k <= 2^63.9
for M5x.000.000 to M5x.100.000 with x = 3, 5, 7 and 9
except those which were allready in this file before */
  { 53054873, 63, 94448564136ULL },   // M53054873 has a factor: 10021913150535669457
  { 55085521, 63, 91109099676ULL },   // M55085521 has a factor: 10037584446986782393
  { 53026187, 63, 95608729528ULL },   // M53026187 has a factor: 10139532741568299473
  { 53007413, 63, 96180756151ULL },   // M53007413 has a factor: 10196586127896694727
  { 57078799, 63, 89531446640ULL },   // M57078799 has a factor: 10220694893887570721
  { 55038257, 63, 93441513192ULL },   // M55038257 has a factor: 10285716035060372689
  { 55020013, 63, 94543419423ULL },   // M55020013 has a factor: 10403560331435824999
  { 53062883, 63, 98485354285ULL },   // M53062883 has a factor: 10451833663277007311
  { 59001361, 63, 88887700491ULL },   // M59001361 has a factor: 10488990610258736503
  { 59037061, 63, 89165515115ULL },   // M59037061 has a factor: 10528139909881354031
  { 53050799, 63, 99672114220ULL },   // M53050799 has a factor: 10575370594780523561
  { 55030981, 63, 96270806400ULL },   // M55030981 has a factor: 10595753835706156801
  { 53020711, 63, 100675222101ULL },   // M53020711 has a factor: 10675743711755867623
  { 55098163, 63, 97447628853ULL },   // M55098163 has a factor: 10738370677012194079
  { 53005223, 63, 102012279388ULL },   // M53005223 has a factor: 10814367235398487049
  { 57069851, 63, 94878477561ULL },   // M57069851 has a factor: 10829401155026226823
  { 53062393, 63, 102123560463ULL },   // M53062393 has a factor: 10837840999693935919
  { 59036773, 63, 92213074251ULL },   // M59036773 has a factor: 10887924664376864047
  { 55052887, 63, 99552074453ULL },   // M55052887 has a factor: 10961258210953191623
  { 53040961, 63, 103466588771ULL },   // M53040961 has a factor: 10975934599611297863
  { 59067311, 63, 93232182213ULL },   // M59067311 has a factor: 11013948603967878487
  { 55032083, 63, 100131132901ULL },   // M55032083 has a factor: 11020849633383725567
  { 55035257, 63, 100339158952ULL },   // M55035257 has a factor: 11044382800174341329
  { 59047129, 63, 93523468751ULL },   // M59047129 has a factor: 11044584647735531759
  { 59012617, 63, 93936289763ULL },   // M59012617 has a factor: 11086852580369879543
  { 55059877, 63, 101701731788ULL },   // M55059877 has a factor: 11199369685868540153
  { 55077619, 63, 102198884825ULL },   // M55077619 has a factor: 11257742481232463351
  { 59060107, 63, 95559427445ULL },   // M59060107 has a factor: 11287500019520873231
  { 53009701, 63, 106517787408ULL },   // M53009701 has a factor: 11292952123359290017
  { 53078863, 63, 106401170337ULL },   // M53078863 has a factor: 11295306286714573663
  { 55035163, 63, 103705095797ULL },   // M55035163 has a factor: 11414853702237019823
  { 59046577, 63, 98127703799ULL },   // M59046577 has a factor: 11588210036401692047
  { 57069143, 63, 101879976313ULL },   // M57069143 has a factor: 11628405874086419519
  { 53065427, 63, 109646543952ULL },   // M53065427 has a factor: 11636881347774295009
  { 53040641, 63, 109858134028ULL },   // M53040641 has a factor: 11653891695818063897
  { 53079757, 63, 110066473764ULL },   // M53079757 has a factor: 11684603362479990697
  { 59045171, 63, 101042885269ULL },   // M59045171 has a factor: 11932188878082971999
  { 59041783, 63, 102706772357ULL },   // M59041783 has a factor: 12127981932264785063
  { 53037623, 63, 114651076513ULL },   // M53037623 has a factor: 12161641145281297199
  { 57046321, 63, 106912144863ULL },   // M57046321 has a factor: 12197889069306398047
  { 59054509, 63, 103624915499ULL },   // M59054509 has a factor: 12239037009919869983
  { 55049573, 63, 111716435928ULL },   // M55049573 has a factor: 12299884189836517489
  { 59015161, 63, 104219544144ULL },   // M59015161 has a factor: 12301066354009534369
  { 59038913, 63, 104680620187ULL },   // M59038913 has a factor: 12360460056012673463
  { 59056889, 63, 104910345771ULL },   // M59056889 has a factor: 12391357290299132839
  { 57085289, 63, 108563967691ULL },   // M57085289 has a factor: 12394810941254795399
  { 57029551, 63, 109551401928ULL },   // M57029551 has a factor: 12495334526748748657
  { 57062347, 63, 110286072897ULL },   // M57062347 has a factor: 12586364321831818519
  { 55072519, 63, 114622684641ULL },   // M55072519 has a factor: 12625119955444961359
  { 55056571, 63, 116710344084ULL },   // M55056571 has a factor: 12851342690990351929
  { 53031269, 63, 121352559391ULL },   // M53031269 has a factor: 12870960441805194359
  { 57004543, 63, 116536379273ULL },   // M57004543 has a factor: 13286206086664074479
  { 55065797, 63, 121319834779ULL },   // M55065797 has a factor: 13361146788027907727
  { 53099791, 63, 126153492948ULL },   // M53099791 has a factor: 13397448218917547737
  { 55000709, 63, 121800357964ULL },   // M55000709 has a factor: 13398212088947592953
  { 53000183, 63, 126401296096ULL },   // M53000183 has a factor: 13398583649050371137
  { 53035963, 63, 127239979340ULL },   // M53035963 has a factor: 13496589672794008841
  { 55063303, 63, 122872463681ULL },   // M55063303 has a factor: 13531527396046796687
  { 59019473, 63, 114683356675ULL },   // M59019473 has a factor: 13537102545659064551
  { 53044847, 63, 128681173777ULL },   // M53044847 has a factor: 13651746349562754239
  { 55062737, 63, 124007097615ULL },   // M55062737 has a factor: 13656340404216144511
  { 55098151, 63, 124640168564ULL },   // M55098151 has a factor: 13734885656409450329
  { 57055259, 63, 123289705489ULL },   // M57055259 has a factor: 14068652157417233303
  { 59068661, 63, 120367116304ULL },   // M59068661 has a factor: 14219848777017097889
  { 53049839, 63, 134096604777ULL },   // M53049839 has a factor: 14227606587732961807
  { 55037849, 63, 129654294367ULL },   // M55037849 has a factor: 14271786951144993167
  { 59013763, 63, 122465357177ULL },   // M59013763 has a factor: 14454283128307654103
  { 57065123, 63, 127071568248ULL },   // M57065123 has a factor: 14502709343750029009
  { 55056653, 63, 132573530788ULL },   // M55056653 has a factor: 14598109763159465129
  { 57097331, 63, 128404448641ULL },   // M57097331 has a factor: 14663102611855354343
  { 55092671, 63, 134036593708ULL },   // M55092671 has a factor: 14768867918231028137
  { 55081861, 63, 135042351236ULL },   // M55081861 has a factor: 14876768039789060393
  { 57016027, 63, 130531550453ULL },   // M57016027 has a factor: 14884780809960220463
  { 57061819, 63, 130465953165ULL },   // M57061819 has a factor: 14889249210327414271
  { 53048287, 63, 141146910489ULL },   // M53048287 has a factor: 14975203633567564687
  { 53077249, 63, 142712498340ULL },   // M53077249 has a factor: 15149573619608533321
  { 53059063, 63, 142921431252ULL },   // M53059063 has a factor: 15166554449700073753
  { 57071029, 63, 133603554492ULL },   // M57071029 has a factor: 15249784665832024537
  { 55031917, 63, 139604760347ULL },   // M55031917 has a factor: 15365435168441990399
  { 55028821, 63, 139778080608ULL },   // M55028821 has a factor: 15383645955002406337
  { 55079483, 63, 139738038445ULL },   // M55079483 has a factor: 15393397825969447871
  { 59096087, 63, 130384658004ULL },   // M59096087 has a factor: 15410446185739260697
  { 57006139, 63, 135998925641ULL },   // M57006139 has a factor: 15505547317883020199
  { 57044573, 63, 136347506200ULL },   // M57044573 has a factor: 15555770541587705201
  { 59074123, 63, 135936489113ULL },   // M59074123 has a factor: 16060657756099045799
  { 53076629, 63, 151352879035ULL },   // M53076629 has a factor: 16066601217245146031
  { 55034851, 63, 146197107809ULL },   // M55034851 has a factor: 16091872089798502919
  { 59030129, 63, 136415158980ULL },   // M59030129 has a factor: 16105208864289816841
  { 59046991, 63, 136856648324ULL },   // M59046991 has a factor: 16161946563754786169
  { 57016459, 63, 141859551992ULL },   // M57016459 has a factor: 16176658659820472657
  { 55099523, 63, 147286632913ULL },   // M55099523 has a factor: 16230846435564800999
  { 57079807, 63, 142687939232ULL },   // M57079807 has a factor: 16289200065180576449
  { 57062737, 63, 143266639604ULL },   // M57062737 has a factor: 16350373153193672297
  { 55043869, 63, 149530064784ULL },   // M55043869 has a factor: 16461426595064018593
  { 55080611, 63, 150890397960ULL },   // M55080611 has a factor: 16622270627339907121
  { 53073899, 63, 156836763732ULL },   // M53073899 has a factor: 16647877115598062137
  { 55096747, 63, 151127464580ULL },   // M55096747 has a factor: 16653263361431442521
  { 55026757, 63, 151837260159ULL },   // M55026757 has a factor: 16710224036630148727
  { 59002969, 63, 143087295191ULL },   // M59002969 has a factor: 16885150484896844159
  { 59068993, 63, 143162022420ULL },   // M59068993 has a factor: 16912873000385646121
  { 55012819, 63, 153989677652ULL },   // M55012819 has a factor: 16942812529075641977
  { 55073311, 63, 155481222461ULL },   // M55073311 has a factor: 17125731438509676743
  { 53021753, 63, 161688218175ULL },   // M53021753 has a factor: 17145985534169921551
  { 55091297, 63, 155664391428ULL },   // M55091297 has a factor: 17151506440968404233
  { 59079733, 63, 145797691256ULL },   // M59079733 has a factor: 17227377342841829297
  { 57048247, 63, 151100541540ULL },   // M57048247 has a factor: 17240042031215360761
  { 57093079, 63, 151830338000ULL },   // M57093079 has a factor: 17336922964061404001
  { 55024033, 63, 157679352503ULL },   // M55024033 has a factor: 17352307791087409199
  { 57079733, 63, 152136302788ULL },   // M57079733 has a factor: 17367799085492391209
  { 55081489, 63, 159371320415ULL },   // M55081489 has a factor: 17556819264708595871
  { 55003129, 63, 160638687327ULL },   // M55003129 has a factor: 17671260882875292367
  { 57087557, 63, 156602266732ULL },   // M57087557 has a factor: 17880081656784507449
  { 55089787, 63, 163401858173ULL },   // M55089787 has a factor: 18003547124309558303
  { 59098271, 64, 156889373088ULL },   // M59098271 has a factor: 18543781375549461697
  { 59043371, 64, 159554544129ULL },   // M59043371 has a factor: 18841276287488837719
  { 59037943, 64, 160117003121ULL },   // M59037943 has a factor: 18905957007176840207
  { 53055577, 64, 178393432319ULL },   // M53055577 has a factor: 18929532969389986127
  { 59006071, 64, 160727752113ULL },   // M59006071 has a factor: 18967826305700156047
  { 57051343, 64, 168715023428ULL },   // M57051343 has a factor: 19250837341687727609
  { 55046977, 64, 175347089027ULL },   // M55046977 has a factor: 19304654353372442759
  { 55071829, 64, 175567827132ULL },   // M55071829 has a factor: 19337682707430128857
  { 59081389, 64, 163842910952ULL },   // M59081389 has a factor: 19360133513694944657
  { 55016623, 64, 176222945036ULL },   // M55016623 has a factor: 19390382661990666857
  { 57015719, 64, 170746285524ULL },   // M57015719 has a factor: 19470444471460303513
  { 55000027, 64, 177145614744ULL },   // M55000027 has a factor: 19486027187703196177
  { 57065677, 64, 171337620680ULL },   // M57065677 has a factor: 19554994639346800721
  { 59027953, 64, 166739622792ULL },   // M59027953 has a factor: 19684597234807809553
  { 55031813, 64, 178994992156ULL },   // M55031813 has a factor: 19700837872530917657
  { 55099537, 64, 179333098872ULL },   // M55099537 has a factor: 19762341433244844529
  { 57093019, 64, 173437509669ULL },   // M57093019 has a factor: 19804142069689801423
  { 59092309, 64, 169028641964ULL },   // M59092309 has a factor: 19976585481574109753
  { 57022181, 64, 176950447276ULL },   // M57022181 has a factor: 20180200865206057913
  { 59008459, 64, 171765821036ULL },   // M59008459 has a factor: 20271272816408287049
  { 57094001, 64, 178949169156ULL },   // M57094001 has a factor: 20433848085483666313
  { 57079181, 64, 180294349416ULL },   // M57079181 has a factor: 20582107607186216593
  { 57003679, 64, 181606883612ULL },   // M57003679 has a factor: 20704520995217617097
  { 59050279, 64, 175470245157ULL },   // M59050279 has a factor: 20723133865438497607
  { 57058739, 64, 181836379552ULL },   // M57058739 has a factor: 20750709043125009857
  { 57014873, 64, 183181376160ULL },   // M57014873 has a factor: 20888125795455255361
  { 55055999, 64, 189704906737ULL },   // M55055999 has a factor: 20888786311214730527
  { 55094279, 64, 189603136597ULL },   // M55094279 has a factor: 20892096213900457127
  { 57078331, 64, 184387558593ULL },   // M57078331 has a factor: 21049068203306296567
  { 59073439, 64, 179970665637ULL },   // M59073439 has a factor: 21262972276593431287
  { 57040411, 64, 186634298625ULL },   // M57040411 has a factor: 21291394200533469751
  { 53013679, 64, 202136993069ULL },   // M53013679 has a factor: 21432051329170381703
  { 59054057, 64, 182779979919ULL },   // M59054057 has a factor: 21587798705190962767
  { 59079877, 64, 183306541143ULL },   // M59079877 has a factor: 21659455808047758823
  { 57069613, 64, 191621127192ULL },   // M57069613 has a factor: 21871487142942433393
  { 57047609, 64, 192829108716ULL },   // M57047609 has a factor: 22000879195697720089
  { 57098681, 64, 193065539868ULL },   // M57098681 has a factor: 22047575346031428217
  { 53092931, 64, 207878910424ULL },   // M53092931 has a factor: 22073801294993225489
  { 55012079, 64, 202388833216ULL },   // M55012079 has a factor: 22267660963192832129
  { 57063389, 64, 195358565764ULL },   // M57063389 has a factor: 22295643665346428393
  { 59019143, 64, 190399255180ULL },   // M59019143 has a factor: 22474401737123821481
  { 53023177, 64, 212743433352ULL },   // M53023177 has a factor: 22560665444421598609
  { 57013237, 64, 198831583788ULL },   // M57013237 has a factor: 22672064419181203513
  { 53039599, 64, 215174188460ULL },   // M53039599 has a factor: 22825505342137655081
  { 59064589, 64, 193515173100ULL },   // M59064589 has a factor: 22859788328830711801
  { 55080127, 64, 208410722357ULL },   // M55080127 has a factor: 22958578111170598679
  { 55071251, 64, 209795602501ULL },   // M55071251 has a factor: 23107412568057597503
  { 53082059, 64, 219184506324ULL },   // M53082059 has a factor: 23269529793152882233
  { 55004629, 64, 214677471551ULL },   // M55004629 has a factor: 23616509354641619159
  { 55021921, 64, 214743151583ULL },   // M55021921 has a factor: 23631161443381701887
  { 59087687, 64, 201199405057ULL },   // M59087687 has a factor: 23776814941188466319
  { 59014679, 64, 201771139792ULL },   // M59014679 has a factor: 23814918092578013537
  { 55087699, 64, 217753927377ULL },   // M55087699 has a factor: 23991125614824071047
  { 59000287, 64, 203683389929ULL },   // M59000287 has a factor: 24034756925887819247
  { 55008689, 64, 219210784032ULL },   // M55008689 has a factor: 24116995688524908097
  { 57000011, 64, 211943701341ULL },   // M57000011 has a factor: 24161586615635429503
  { 55026241, 64, 219781831155ULL },   // M55026241 has a factor: 24187536017112676711
  { 53013967, 64, 233382038897ULL },   // M53013967 has a factor: 24745015416956548799
  { 59045783, 64, 210593348820ULL },   // M59045783 has a factor: 24869298351338052121
  { 55054183, 64, 226216051845ULL },   // M55054183 has a factor: 24908279831624235271
  { 53029267, 64, 234895217928ULL },   // M53029267 has a factor: 24912642457054197553
  { 53027911, 64, 236388283581ULL },   // M53027911 has a factor: 25070353726352058583
  { 55052567, 64, 227766110848ULL },   // M55052567 has a factor: 25078218155577893633
  { 57082639, 64, 220951985952ULL },   // M57082639 has a factor: 25225044900862174657
  { 55030489, 64, 229774385460ULL },   // M55030489 has a factor: 25289193583076579881
  { 53040223, 64, 239627013056ULL },   // M53040223 has a factor: 25419740418628302977
  { 57018383, 64, 223704774292ULL },   // M57018383 has a factor: 25510568999019619673
  { 53005817, 64, 242114829343ULL },   // M53005817 has a factor: 25666988674282576463
  { 59038219, 64, 220654643264ULL },   // M59038219 has a factor: 26054114304773813633
  { 55088357, 64, 238015561875ULL },   // M55088357 has a factor: 26223772488251178751
  { 53096833, 64, 249225625668ULL },   // M53096833 has a factor: 26466182850828618889
  { 55089871, 64, 241217266700ULL },   // M55089871 has a factor: 26577256210951191401
  { 59028527, 64, 225723349492ULL },   // M59028527 has a factor: 26648233660037916569
  { 53044841, 64, 251590962168ULL },   // M53044841 has a factor: 26691205170477150577
  { 57092621, 64, 235122068251ULL },   // M57092621 has a factor: 26847470262780951743
  { 59068901, 64, 229413607416ULL },   // M59068901 has a factor: 27102419329017139633
  { 53091191, 64, 255591124684ULL },   // M53091191 has a factor: 27139274437006117289
  { 57017731, 64, 238365156348ULL },   // M57017731 has a factor: 27182080728846412777
  { 55039147, 64, 250698985544ULL },   // M55039147 has a factor: 27596516636214181937
  { 55076027, 64, 251192054589ULL },   // M55076027 has a factor: 27669320761458475807
  { 53050423, 64, 261869371805ULL },   // M53050423 has a factor: 27784561889999047031
  { 59016557, 64, 236755204375ULL },   // M59016557 has a factor: 27944954028087673751
  { 57063791, 64, 244858927024ULL },   // M57063791 has a factor: 27945157272363575969
  { 57032279, 64, 245081809836ULL },   // M57032279 has a factor: 27955148312783392489
  { 55079237, 64, 253891166107ULL },   // M55079237 has a factor: 27968263420427640719
  { 57015997, 64, 246210954755ULL },   // M57015997 has a factor: 28075926115356431471
  { 57044837, 64, 246196932603ULL },   // M57044837 has a factor: 28088527780476241423
  { 57077333, 64, 247593104983ULL },   // M57077333 has a factor: 28263908203237300679
  { 57023683, 64, 248081853977ULL },   // M57023683 has a factor: 28293081998473474583
  { 59058203, 64, 240599435560ULL },   // M59058203 has a factor: 28418740613975797361
  { 53048503, 64, 270201983076ULL },   // M53048503 has a factor: 28667621419626270457
  { 55051369, 64, 263205737355ULL },   // M55051369 has a factor: 28979672340094377991
  { 59000609, 64, 245639179399ULL },   // M59000609 has a factor: 28985722357602507983
  { 53066173, 64, 275199853427ULL },   // M53066173 has a factor: 29207606063063649743
  { 53014531, 64, 275549971344ULL },   // M53014531 has a factor: 29216304995731199329
  { 57031357, 64, 257046188112ULL },   // M57031357 has a factor: 29319385839409255969
  { 55014979, 64, 270147907896ULL },   // M55014979 has a factor: 29724362959584748369
  { 57082409, 64, 263277922596ULL },   // M57082409 has a factor: 30057076116590427529
  { 53019931, 64, 284488019556ULL },   // M53019931 has a factor: 30167070334371541273
  { 57055351, 64, 265316137260ULL },   // M57055351 has a factor: 30275410674666956521
  { 53039809, 64, 285918502776ULL },   // M53039809 has a factor: 30330125553610019569
  { 53040821, 64, 286643016895ULL },   // M53040821 has a factor: 30407561900055341591
  { 55077527, 64, 276519022593ULL },   // M55077527 has a factor: 30459967865759135023
  { 55023049, 64, 276986628591ULL },   // M55023049 has a factor: 30481297674614787919
  { 55048129, 64, 277393395611ULL },   // M55048129 has a factor: 30539974850684723639
  { 59006483, 64, 259426269168ULL },   // M59006483 has a factor: 30615663482830032289
  { 59003731, 64, 260242961709ULL },   // M59003731 has a factor: 30710611414642272559
  { 53043253, 64, 290887007603ULL },   // M53043253 has a factor: 30859186277397705119
  { 59096833, 64, 261373294503ULL },   // M59096833 has a factor: 30892667871807217999
  { 55026269, 64, 280755690271ULL },   // M55026269 has a factor: 30897876272265457799
  { 53029073, 64, 292204553223ULL },   // M53029073 has a factor: 30990673167589704559
  { 59094127, 64, 264316933337ULL },   // M59094127 has a factor: 31239156853734423599
  { 55066343, 64, 284460980937ULL },   // M55066343 has a factor: 31328451892786606783
  { 55086077, 64, 286657949943ULL },   // M55086077 has a factor: 31581723806444487223
  { 59013821, 64, 267814543240ULL },   // M59013821 has a factor: 31609519031924240081
  { 59000363, 64, 268782264261ULL },   // M59000363 has a factor: 31716502318721853487
  { 53006479, 64, 301690567320ULL },   // M53006479 has a factor: 31983109442291332561
  { 55020919, 64, 291997739300ULL },   // M55020919 has a factor: 32131967924416833401
  { 57085909, 64, 281616386612ULL },   // M57085909 has a factor: 32152654838082900617
  { 59082433, 64, 272152341300ULL },   // M59082433 has a factor: 32158844941300765801
  { 59036273, 64, 272543768575ULL },   // M59036273 has a factor: 32179936652085041951
  { 53096669, 64, 303516555195ULL },   // M53096669 has a factor: 32231436134418290911
  { 55032337, 64, 293853447695ULL },   // M55032337 has a factor: 32342883924326226431
  { 59039831, 64, 276205558441ULL },   // M59039831 has a factor: 32614258983234526943
  { 55084433, 64, 296093522235ULL },   // M55084433 has a factor: 32620287574575735511
  { 59051813, 64, 276202964263ULL },   // M59051813 has a factor: 32620571591408717639
  { 59097683, 64, 277137476868ULL },   // M59097683 has a factor: 32756365510729793689
  { 53078213, 64, 308916238596ULL },   // M53078213 has a factor: 32793443822714617897
  { 57042779, 64, 287612000745ULL },   // M57042779 has a factor: 32812375592489740711
  { 57011131, 64, 289765638953ULL },   // M57011131 has a factor: 33039733603296371687
  { 57068057, 64, 293186155060ULL },   // M57068057 has a factor: 33463128417149836841
  { 59000629, 64, 283784529920ULL },   // M59000629 has a factor: 33486931531498639361
  { 57015883, 64, 296961876276ULL },   // M57015883 has a factor: 33863087186425783417
  { 53090627, 64, 319331138857ULL },   // M53090627 has a factor: 33906980765084386679
  { 57095917, 64, 298011885900ULL },   // M57095917 has a factor: 34030523804719740601
  { 55021157, 64, 311752536487ULL },   // M55021157 has a factor: 34305970510398910919
  { 55020871, 64, 311811371589ULL },   // M55020871 has a factor: 34312266505062868039
  { 57058411, 64, 301118625356ULL },   // M57058411 has a factor: 34362700570635338633
  { 57080867, 64, 301172274432ULL },   // M57080867 has a factor: 34382349081880985089
  { 57066091, 64, 302988235380ULL },   // M57066091 has a factor: 34580708424248999161
  { 59024347, 64, 294837224045ULL },   // M59024347 has a factor: 34805149241097647231
  { 59001889, 64, 295004209331ULL },   // M59001889 has a factor: 34811611226960852519
  { 55091119, 64, 316186914612ULL },   // M55091119 has a factor: 34838181878265061657
  { 53057071, 64, 328743149120ULL },   // M53057071 has a factor: 34884297207246855041
  { 53036153, 64, 330358347360ULL },   // M53036153 has a factor: 35041871710824212161
  { 55069117, 64, 321024557904ULL },   // M55069117 has a factor: 35357077878177301537
  { 59010641, 64, 301212321355ULL },   // M59010641 has a factor: 35549464320513077111
  { 57032413, 64, 311810649000ULL },   // M57032413 has a factor: 35566627423132074001
  { 55060283, 64, 328272230572ULL },   // M55060283 has a factor: 36149523832671143753
  { 55026407, 64, 328670034592ULL },   // M55026407 has a factor: 36171062184326941889
  { 53057923, 64, 343483457048ULL },   // M53057923 has a factor: 36449037631653182609
  { 59050219, 64, 310051380056ULL },   // M59050219 has a factor: 36617203787118064529
  { 53046139, 64, 345536552460ULL },   // M53046139 has a factor: 36658759982747903881
  { 55059091, 64, 333670840044ULL },   // M55059091 has a factor: 36743226292058080009
  { 53034599, 64, 346879445284ULL },   // M53034599 has a factor: 36793224563958762233
  { 57079643, 64, 322580313468ULL },   // M57079643 has a factor: 36825538263163063849
  { 57076367, 65, 324643858669ULL },   // M57076367 has a factor: 37058984043375951047
  { 59058211, 65, 314304207228ULL },   // M59058211 has a factor: 37124488377317898217
  { 59049047, 65, 316660689405ULL },   // M59049047 has a factor: 37397023863456494071
  { 53005891, 65, 353436803024ULL },   // M53005891 has a factor: 37468465312957228769
  { 57041483, 65, 328891138600ULL },   // M57041483 has a factor: 37520876582605087601
  { 53048351, 65, 355182230193ULL },   // M53048351 has a factor: 37683663232482123487
  { 59021363, 65, 319356626452ULL },   // M59021363 has a factor: 37697726752557788153
  { 53064377, 65, 356809182120ULL },   // M53064377 has a factor: 37867713914154678481
  { 57050867, 65, 332881021465ULL },   // M57050867 has a factor: 37982301764847720311
  { 57043579, 65, 333887165060ULL },   // M57043579 has a factor: 38092237754372299481
  { 53002009, 65, 359412672539ULL },   // M53002009 has a factor: 38099187409252261703
  { 55025437, 65, 347566741268ULL },   // M55025437 has a factor: 38250023649875268233
  { 55034437, 65, 350201211728ULL },   // M55034437 has a factor: 38546253048336554273
  { 55043293, 65, 350412731075ULL },   // M55043293 has a factor: 38575741254982859951
  { 59078447, 65, 333522527353ULL },   // M59078447 has a factor: 39407985911060521583
  { 59043679, 65, 335082852272ULL },   // M59043679 has a factor: 39569048735904777377
  { 59098453, 65, 336141551468ULL },   // M59098453 has a factor: 39730891361557358009
  { 57024367, 65, 349349545749ULL },   // M57024367 has a factor: 39842873416148531767
  { 59056483, 65, 337843925060ULL },   // M59056483 has a factor: 39903748033918327961
  { 57005381, 65, 352608002143ULL },   // M57005381 has a factor: 40201107011621062967
  { 59053471, 65, 340439354588ULL },   // M59053471 has a factor: 40208251106842349897
  { 55025293, 65, 366142405188ULL },   // M55025293 has a factor: 40294186250388840169
  { 59086999, 65, 343222849940ULL },   // M59086999 has a factor: 40560016382363860121
  { 59007211, 65, 346187603241ULL },   // M59007211 has a factor: 40855129900051941703
  { 53045029, 65, 386065384344ULL },   // M53045029 has a factor: 40957699016847251953
  { 53076869, 65, 386015885676ULL },   // M53076869 has a factor: 40977029191888056889
  { 57003631, 65, 359804871144ULL },   // M57003631 has a factor: 41020368213390247729
  { 57055849, 65, 360565614032ULL },   // M57055849 has a factor: 41144754457604146337
  { 53078071, 65, 392859186669ULL },   // M53078071 has a factor: 41704415606038870999
  { 57062983, 65, 365497305893ULL },   // M57062983 has a factor: 41712733105436117639
  { 53026249, 65, 395212081364ULL },   // M53026249 has a factor: 41913228468431447273
  { 55038749, 65, 380860876800ULL },   // M55038749 has a factor: 41924212404230246401
  { 59084533, 65, 354984764132ULL },   // M59084533 has a factor: 41948218021708740713
  { 57094403, 65, 367817252905ULL },   // M57094403 has a factor: 42000612935421981431
  { 55050547, 65, 382102629992ULL },   // M55050547 has a factor: 42069917582396411249
  { 55011499, 65, 382805417552ULL },   // M55011499 has a factor: 42117399689712860897
  { 59004133, 65, 357640501067ULL },   // M59004133 has a factor: 42204535382287819823
  { 55085911, 65, 384548965536ULL },   // M55085911 has a factor: 42366460181316326593
  { 53039873, 65, 404497889932ULL },   // M53039873 has a factor: 42909033421522517273
  { 55044841, 65, 390060258948ULL },   // M55044841 has a factor: 42941609868422974537
  { 57020573, 65, 378605932083ULL },   // M57020573 has a factor: 43176654377143487119
  { 59007203, 65, 365910827613ULL },   // M59007203 has a factor: 43182748969716592879
  { 57062237, 65, 379067801800ULL },   // M57062237 has a factor: 43260913490761253201
  { 55037111, 65, 394999877713ULL },   // M55037111 has a factor: 43479304229353614287
  { 59010011, 65, 372013994445ULL },   // M59010011 has a factor: 43905099808706777791
  { 53067389, 65, 413825486155ULL },   // M53067389 has a factor: 43921276103802998591
  { 53022187, 65, 414656088068ULL },   // M53022187 has a factor: 43971945284459929433
  { 57038609, 65, 388929425832ULL },   // M57038609 has a factor: 44367986897251895377
  { 53018629, 65, 422711728371ULL },   // M53018629 has a factor: 44823192600901646719
  { 55009481, 65, 410598686628ULL },   // M55009481 has a factor: 45173641301375840137
  { 53071301, 65, 427005365763ULL },   // M53071301 has a factor: 45323460590046535327
  { 55050601, 65, 421647274283ULL },   // M55050601 has a factor: 46423871718581988167
  { 57027931, 65, 410323472181ULL },   // M57027931 has a factor: 46799797318436975023
  { 53016221, 65, 446696785788ULL },   // M53016221 has a factor: 47364351030652534297
  { 57075517, 65, 416477915948ULL },   // M57075517 has a factor: 47541384743629290233
  { 53098781, 65, 448572800416ULL },   // M53098781 has a factor: 47637337783691785793
  { 57098519, 65, 417372157701ULL },   // M57098519 has a factor: 47662664153123089639
  { 53050649, 65, 450084317544ULL },   // M53050649 has a factor: 47754530300862572113
  { 53067881, 65, 451295446024ULL },   // M53067881 has a factor: 47898586050887110289
  { 57049313, 65, 420696729411ULL },   // M57049313 has a factor: 48000918788488889287
  { 55063849, 65, 436192952871ULL },   // M55063849 has a factor: 48036925783505720959
  { 53072399, 65, 459834010761ULL },   // M53072399 has a factor: 48808988185756171279
  { 53040137, 65, 460156027632ULL },   // M53040137 has a factor: 48813477493954131169
  { 53013167, 65, 463139078488ULL },   // M53013167 has a factor: 49104938624220902993
  { 57043247, 65, 430516228449ULL },   // M57043247 has a factor: 49116087113849467807
  { 57069911, 65, 432582836121ULL },   // M57069911 has a factor: 49374927915106110463
  { 53098169, 65, 466488893916ULL },   // M53098169 has a factor: 49539412251549679609
  { 53015737, 65, 469240963064ULL },   // M53015737 has a factor: 49754310974855476337
  { 59055511, 65, 425006285321ULL },   // M59055511 has a factor: 50197926715686908063
  { 53091067, 65, 472969320005ULL },   // M53091067 has a factor: 50220891714659790671
  { 59095297, 65, 425721109688ULL },   // M59095297 has a factor: 50316230832363874673
  { 57050347, 65, 443821333385ULL },   // M57050347 has a factor: 50640322151233869191
  { 57007297, 65, 447002425800ULL },   // M57007297 has a factor: 50964800094602125201
  { 59094097, 65, 431237483972ULL },   // M59094097 has a factor: 50967179415754626569
  { 59060129, 65, 435527939991ULL },   // M59060129 has a factor: 51444672637945437679
  { 59022893, 65, 441697892320ULL },   // M59022893 has a factor: 52140574873457763521
  { 53095501, 65, 492587012184ULL },   // M53095501 has a factor: 52308308396005168369
  { 53075537, 65, 494920498695ULL },   // M53075537 has a factor: 52536342481089848431
  { 53071021, 65, 495766962560ULL },   // M53071021 has a factor: 52621717762255947521
  { 59052289, 65, 445563288927ULL },   // M59052289 has a factor: 52623064211015407807
  { 59065999, 65, 446895560669ULL },   // M59065999 has a factor: 52792665479159186663
  { 55045867, 65, 484124774829ULL },   // M55045867 has a factor: 53298135933284163487
  { 59084573, 65, 453390340251ULL },   // M59084573 has a factor: 53576749312110095647
  { 57073069, 65, 471924182600ULL },   // M57073069 has a factor: 53868322872596798801
  { 59074207, 65, 458654146305ULL },   // M59074207 has a factor: 54189259960459710271
  { 59060933, 65, 459823174332ULL },   // M59060933 has a factor: 54315171382139143513
  { 57085003, 65, 482411768673ULL },   // M57085003 has a factor: 55076954523867022039
  { 59043419, 65, 467456148285ULL },   // M59043419 has a factor: 55200418454634772831
  { 57071743, 65, 484202260845ULL },   // M57071743 has a factor: 55268533981929605671
  { 57010927, 65, 485572073937ULL },   // M57010927 has a factor: 55365828120921819199
  { 57001517, 65, 492314997015ULL },   // M57001517 has a factor: 56125403343410943511
  { 55043477, 65, 510197229900ULL },   // M55043477 has a factor: 56166058978928724601
  { 57073411, 65, 497544403524ULL },   // M57073411 has a factor: 56793112466150200729
  { 53096867, 65, 540837718789ULL },   // M53096867 has a factor: 57433576846245868127
  { 57080171, 65, 504894681988ULL },   // M57080171 has a factor: 57638949569731319897
  { 55039297, 65, 527429916147ULL },   // M55039297 has a factor: 58058743602999657319
  { 55062911, 65, 527490284844ULL },   // M55062911 has a factor: 58090301215459641769
  { 55029497, 65, 531291321520ULL },   // M55029497 has a factor: 58473388367421750881
  { 53001703, 65, 556381475501ULL },   // M53001703 has a factor: 58978331438411556407
  { 57054031, 65, 518700505476ULL },   // M57054031 has a factor: 59187909438286747513
  { 55043333, 65, 545961722896ULL },   // M55043333 has a factor: 60103105837236504737
  { 53057911, 65, 571881757209ULL },   // M53057911 has a factor: 60685702753037460799
  { 55005359, 65, 556633800316ULL },   // M55005359 has a factor: 61235684035831786889
  { 59046139, 65, 523454544164ULL },   // M59046139 has a factor: 61815939549778365593
  { 57057601, 65, 544467244884ULL },   // M57057601 has a factor: 62131989632321126569
  { 57039181, 65, 545092115519ULL },   // M57039181 has a factor: 62183215677522299879
  { 59080673, 65, 526911234303ULL },   // M59080673 has a factor: 62260540667763851839
  { 53026411, 65, 592290674321ULL },   // M53026411 has a factor: 62814097456024983863
  { 59060579, 65, 532556122180ULL },   // M59060579 has a factor: 62906145851891084441
  { 57014977, 65, 552114059364ULL },   // M57014977 has a factor: 62957540792030189257
  { 59082479, 65, 536961536404ULL },   // M59082479 has a factor: 63450037396794131033
  { 53046317, 65, 605327413279ULL },   // M53046317 has a factor: 64220779707175686887
  { 55072987, 65, 583409178977ULL },   // M55072987 has a factor: 64260172258961988599
  { 57087733, 65, 563591448500ULL },   // M57087733 has a factor: 64348316266102501001
  { 59043827, 65, 545125452753ULL },   // M59043827 has a factor: 64372585851289611463
  { 57063211, 65, 565584101013ULL },   // M57063211 has a factor: 64548089788700265487
  { 59021951, 65, 547758575965ULL },   // M59021951 has a factor: 64659559660872015431
  { 59012167, 65, 549707046893ULL },   // M59012167 has a factor: 64878808104653094263
  { 57065443, 65, 568987655177ULL },   // M57065443 has a factor: 64939065208413496823
  { 57094603, 65, 570091742285ULL },   // M57094603 has a factor: 65098323398680775711
  { 57079223, 65, 580729620481ULL },   // M57079223 has a factor: 66295191020280732527
  { 53029709, 65, 627271467772ULL },   // M53029709 has a factor: 66528046799904076697
  { 59089493, 65, 566278194931ULL },   // M59089493 has a factor: 66922182870855919967
  { 57078349, 65, 587375351355ULL },   // M57078349 has a factor: 67052830597276625791
  { 59055307, 65, 568935211725ULL },   // M59055307 has a factor: 67197287183059749151
  { 55067261, 65, 610951725828ULL },   // M55067261 has a factor: 67286876289141834217
  { 57059773, 65, 590744592555ULL },   // M57059773 has a factor: 67415504704331580031
  { 59026273, 65, 573075567152ULL },   // M59026273 has a factor: 67653029752687568993
  { 55091083, 65, 616051776057ULL },   // M55091083 has a factor: 67877919054107199463
  { 55016293, 65, 617781544560ULL },   // M55016293 has a factor: 67976100931011032161
  { 59023799, 65, 576454678992ULL },   // M59023799 has a factor: 68049090210866661217
  { 57000353, 65, 604825689231ULL },   // M57000353 has a factor: 68950555579270597087
  { 59002873, 65, 585431087948ULL },   // M59002873 has a factor: 69084232264895349209
  { 57045959, 65, 607103748637ULL },   // M57045959 has a factor: 69265631106985215767
  { 59015581, 65, 591948471600ULL },   // M59015581 has a factor: 69868365947071999201
  { 59012539, 65, 593961962100ULL },   // M59012539 has a factor: 70102406905885543801
  { 55097989, 65, 646562198912ULL },   // M55097989 has a factor: 71248553846938375937
  { 57018463, 65, 625172255201ULL },   // M57018463 has a factor: 71292722203609552127
  { 59009579, 65, 608499357084ULL },   // M59009579 has a factor: 71814581766595015273
  { 59032733, 65, 609131688667ULL },   // M59032733 has a factor: 71917416677836273823
  { 55066129, 66, 670452484416ULL },   // M55066129 has a factor: 73838445990443891329
  { 53054879, 66, 698717691201ULL },   // M53054879 has a factor: 74140765123656839359
  { 55008671, 66, 675499455201ULL },   // M55008671 has a factor: 74316654583662095743
  { 55080299, 66, 674783424784ULL },   // M55080299 has a factor: 74334545594693460833
  { 57036829, 66, 652112349152ULL },   // M57036829 has a factor: 74388841094741838017
  { 53046827, 66, 707439966933ULL },   // M53046827 has a factor: 75054891077561143183
  { 57028511, 66, 660083040696ULL },   // M57028511 has a factor: 75287105894490567313
  { 57048197, 66, 663927630835ULL },   // M57048197 has a factor: 75751748555236708991
  { 59025289, 66, 644788100604ULL },   // M59025289 has a factor: 76117607963824349113
  { 55095541, 66, 701602867208ULL },   // M55095541 has a factor: 77310379071951839057
  { 55009453, 66, 704202782055ULL },   // M55009453 has a factor: 77475619683847531831
  { 57092741, 66, 679111913256ULL },   // M57092741 has a factor: 77544721147078549393
  { 57083669, 66, 682343521944ULL },   // M57083669 has a factor: 77901343501891065073
  { 59037169, 66, 660899147976ULL },   // M59037169 has a factor: 78035229382030239889
  { 57076249, 66, 689043861596ULL },   // M57076249 has a factor: 78656078032749666809
  { 57088729, 66, 689998351280ULL },   // M57088729 has a factor: 78782257773341446241
  { 53040367, 66, 744940440729ULL },   // M53040367 has a factor: 79023828738815815087
  { 59088739, 66, 671019490517ULL },   // M59088739 has a factor: 79299391078143976127
  { 55062977, 66, 730145554120ULL },   // M55062977 has a factor: 80407975706323630481
  { 59016257, 66, 690132744955ULL },   // M59016257 has a factor: 81458102880759466871
  { 53065927, 66, 767682868517ULL },   // M53065927 has a factor: 81475606119747440519
  { 57081709, 66, 730187226719ULL },   // M57081709 has a factor: 83360669582181965543
  { 53067943, 66, 786101043788ULL },   // M53067943 has a factor: 83433530767964176169
  { 59043143, 66, 708185466628ULL },   // M59043143 has a factor: 83626991553277463609
  { 57003259, 66, 735946519092ULL },   // M57003259 has a factor: 83902700075899441657
  { 55062859, 66, 764513686616ULL },   // M55062859 has a factor: 84192618659413990289
  { 55056887, 66, 771519135600ULL },   // M55056887 has a factor: 84954883734133754401
  { 59048593, 66, 720990391416ULL },   // M59048593 has a factor: 85146936359268155377
  { 59041813, 66, 723185116931ULL },   // M59041813 has a factor: 85396320876446471807
  { 59042531, 66, 723319012753ULL },   // M59042531 has a factor: 85413170466716795687
  { 59006921, 66, 724757068636ULL },   // M59006921 has a factor: 85531366186392059513
  { 55020583, 66, 779241225080ULL },   // M55020583 has a factor: 85748613003071643281
  { 59077663, 66, 731537439108ULL },   // M59077663 has a factor: 86435044599010889209
  { 55068283, 66, 786075869621ULL },   // M55068283 has a factor: 86575696895520661487
  { 53064593, 66, 819037415295ULL },   // M53064593 has a factor: 86923774188802299871
  { 53080151, 66, 820165829601ULL },   // M53080151 has a factor: 87069052160522699503
  { 59061071, 66, 738796990093ULL },   // M59061071 has a factor: 87268282972937939207
  { 59061811, 66, 738969169809ULL },   // M59061811 has a factor: 87289714884172128199
  { 57040127, 66, 766520306508ULL },   // M57040127 has a factor: 87444831262590493033
  { 57097531, 66, 767957805981ULL },   // M57097531 has a factor: 87696989267384265823
  { 55095067, 66, 801461933708ULL },   // M55095067 has a factor: 88313197871183636873
  { 57066797, 66, 775628826759ULL },   // M57066797 has a factor: 88525305608008041847
  { 55080761, 66, 805956949740ULL },   // M55080761 has a factor: 88785444249835904281
  { 55075373, 66, 808794854307ULL },   // M55075373 has a factor: 89089356562877363023
  { 53017463, 66, 850206981372ULL },   // M53017463 has a factor: 90151634354463398473
  { 57063607, 66, 803066313600ULL },   // M57063607 has a factor: 91651721028418310401
  { 53022049, 66, 865609389719ULL },   // M53022049 has a factor: 91792766953081828463
  { 59071561, 66, 778542052715ULL },   // M59071561 has a factor: 91979388716038676231
  { 59063549, 66, 787598916667ULL },   // M59063549 has a factor: 93036774413816542367
  { 57020603, 66, 816719001888ULL },   // M57020603 has a factor: 93139619938423796929
  { 59051227, 66, 789231868800ULL },   // M59051227 has a factor: 93210220480286035201
  { 53043031, 66, 882918058260ULL },   // M53043031 has a factor: 93665299869489972121
  { 57055787, 66, 829242196513ULL },   // M57055787 has a factor: 94626132271315741463
  { 59031067, 66, 803415268845ULL },   // M59031067 has a factor: 94852921128024415231
  { 55023587, 66, 865414203873ULL },   // M55023587 has a factor: 95236387475683504903
  { 57052729, 66, 834678256716ULL },   // M57052729 has a factor: 95241344765220755929
  { 59096899, 66, 807974725997ULL },   // M59096899 has a factor: 95497601553594766607
  { 53095039, 66, 900798691920ULL },   // M53095039 has a factor: 95655883357282769761
  { 57077201, 66, 842450960511ULL },   // M57077201 has a factor: 96169485611458819423
  { 55038901, 66, 876545950175ULL },   // M55038901 has a factor: 96488251547265515351
  { 53093063, 66, 913679425737ULL },   // M53093063 has a factor: 97020078624916724863
  { 59082349, 66, 824971268252ULL },   // M59082349 has a factor: 97482480771674567897
  { 53095019, 66, 924392028832ULL },   // M53095019 has a factor: 98161224668567175617
  { 59012029, 66, 836278671944ULL },   // M59012029 has a factor: 98701002481681628753
  { 55056257, 66, 898685569827ULL },   // M55056257 has a factor: 98956527389173515079
  { 57035107, 66, 870243798317ULL },   // M57035107 has a factor: 99268896306193029839
  { 59039579, 66, 841854118780ULL },   // M59039579 has a factor: 99405425504374387241
  { 59028533, 66, 847026655216ULL },   // M59028533 has a factor: 99997481738594556257
  { 53028523, 66, 949772515385ULL },   // M53028523 has a factor: 100730067353722652711
  { 55082891, 66, 915558438568ULL },   // M55082891 has a factor: 100863211351542680177
  { 59088721, 66, 855434752091ULL },   // M59088721 has a factor: 101093090800018531223
  { 53073359, 66, 958455933721ULL },   // M53073359 has a factor: 101736951712109677679
  { 59008549, 66, 863961270407ULL },   // M59008549 has a factor: 101962201917827418887
  { 59043799, 66, 878862642809ULL },   // M59043799 has a factor: 103782778461246782783
  { 53069161, 66, 988433142135ULL },   // M53069161 has a factor: 104910635115396397471
  { 59002213, 66, 892334601051ULL },   // M59002213 has a factor: 105299432396962251727
  { 53049023, 66, 995370240348ULL },   // M53049023 has a factor: 105606837547473160009
  { 57025081, 66, 933926318568ULL },   // M57025081 has a factor: 106514447928744008017
  { 53077771, 66, 1006453764021ULL },   // M53077771 has a factor: 106840644817589354383
  { 57015349, 66, 937779232964ULL },   // M57015349 has a factor: 106935620504789528873
  { 59078897, 66, 905813217468ULL },   // M59078897 has a factor: 107028891552061145593
  { 57022697, 66, 946770302140ULL },   // M57022697 has a factor: 107974792135055343161
  { 55067953, 66, 999627926840ULL },   // M55067953 has a factor: 110094927385425117041
  { 59065309, 66, 936635600672ULL },   // M59065309 has a factor: 110645342348184575297
  { 59082943, 66, 941162028348ULL },   // M59082943 has a factor: 111213244949298536329
  { 55051291, 66, 1013218454168ULL },   // M55051291 has a factor: 111557967933945461777
  { 57083701, 66, 979476358976ULL },   // M57083701 has a factor: 111824271224709300353
  { 55024213, 66, 1018405521960ULL },   // M55024213 has a factor: 112073924721406434961
  { 57098879, 66, 981520813125ULL },   // M57098879 has a factor: 112087476289211973751
  { 59011409, 66, 958010600016ULL },   // M59011409 has a factor: 113067110687759165089
  { 53061499, 66, 1072343514272ULL },   // M53061499 has a factor: 113800308620400427457
  { 53053487, 66, 1076884936057ULL },   // M53053487 has a factor: 114265001911191761519
  { 59072291, 66, 967294223389ULL },   // M59072291 has a factor: 114280571693308028399
  { 59094767, 66, 973106604009ULL },   // M59094767 has a factor: 115011016060146241807
  { 57063007, 66, 1008179165228ULL },   // M57063007 has a factor: 115059469525319041193
  { 55009901, 66, 1056411157384ULL },   // M55009901 has a factor: 116226146365978517969
  { 55092923, 66, 1066689551137ULL },   // M55092923 has a factor: 117534090611390606903
  { 59001797, 66, 1002513655252ULL },   // M59001797 has a factor: 118300214353812975689
  { 59009297, 66, 1006763702164ULL },   // M59009297 has a factor: 118816836619630037417
  { 55041073, 66, 1084522586931ULL },   // M55041073 has a factor: 119386573754836033927
  { 59064911, 66, 1010813539216ULL },   // M59064911 has a factor: 119407223462776099553
  { 57043697, 66, 1051993423687ULL },   // M57043697 has a factor: 120019188213587701679
  { 55084669, 66, 1095808016411ULL },   // M55084669 has a factor: 120724443743093005919
  { 57016733, 66, 1062121437156ULL },   // M57016733 has a factor: 121117388791799862697
  { 59002217, 66, 1029738831343ULL },   // M59002217 has a factor: 121513747960452174863
  { 53067299, 66, 1153517174185ULL },   // M53067299 has a factor: 122428081568220952631
  { 53005019, 66, 1155251404689ULL },   // M53005019 has a factor: 122468245310634268183
  { 59059549, 66, 1037489024712ULL },   // M59059549 has a factor: 122547267783881149777
  { 57046537, 66, 1091622611835ULL },   // M57046537 has a factor: 124546579432163930791
  { 55050089, 66, 1137516261172ULL },   // M55050089 has a factor: 125240742832931688617
  { 55094107, 66, 1139342206877ULL },   // M55094107 has a factor: 125542082910595147679
  { 59052871, 66, 1066568623104ULL },   // M59052871 has a factor: 125967878625616263169
  { 53002321, 66, 1192590549204ULL },   // M53002321 has a factor: 126420134220953404969
  { 57000193, 66, 1112492966072ULL },   // M57000193 has a factor: 126824627554492903793
  { 59015519, 66, 1074573237349ULL },   // M59015519 has a factor: 126832994611322838263
  { 59034439, 66, 1076845639725ULL },   // M59034439 has a factor: 127141956461522978551
  { 59093963, 66, 1082853068637ULL },   // M59093963 has a factor: 127980158344942676863
  { 55067921, 66, 1162115151520ULL },   // M55067921 has a factor: 127990530713612779841
  { 59050139, 66, 1089889159876ULL },   // M59050139 has a factor: 128716212770542045529
  { 59079421, 66, 1090966922931ULL },   // M59079421 has a factor: 128907388273830205903
  { 59009311, 66, 1094509523585ULL },   // M59009311 has a factor: 129172505739378199871
  { 59061683, 66, 1104399184137ULL },   // M59061683 has a factor: 130455349037916245143
  { 53074111, 66, 1249094956049ULL },   // M53074111 has a factor: 132589208693769494879
  { 57088613, 66, 1162831727443ULL },   // M57088613 has a factor: 132768900944229813119
  { 57090031, 66, 1171596536381ULL },   // M57090031 has a factor: 133772965162967835623
  { 55046197, 66, 1242407349183ULL },   // M55046197 has a factor: 136779599394750414103
  { 57085393, 66, 1198141900692ULL },   // M57085393 has a factor: 136792802541539583913
  { 53001043, 66, 1297977951173ULL },   // M53001043 has a factor: 137588370406344146879
  { 59058347, 66, 1165021565824ULL },   // M59058347 has a factor: 137608495793834265857
  { 57007453, 66, 1207101967136ULL },   // M57007453 has a factor: 137627617315426129217
  { 59079169, 66, 1170741803840ULL },   // M59079169 has a factor: 138332905768856417921
  { 55008467, 66, 1260077669280ULL },   // M55008467 has a factor: 138629881776051587521
  { 55046623, 66, 1259289445973ULL },   // M55046623 has a factor: 138639262760709198359
  { 59006803, 66, 1185003907037ULL },   // M59006803 has a factor: 139846584193525145423
  { 53079317, 66, 1319172291804ULL },   // M53079317 has a factor: 140041528508562035737
  { 55091609, 66, 1286220126624ULL },   // M55091609 has a factor: 141719872607799796033
  { 55091873, 66, 1286342699451ULL },   // M55091873 has a factor: 141734057265263323447
  { 55087433, 66, 1289969137603ULL },   // M55087433 has a factor: 142122176879546086199
  { 53056957, 66, 1342277432924ULL },   // M53056957 has a factor: 142434312081438104537
  { 57024043, 66, 1256983495976ULL },   // M57024043 has a factor: 143356561849651501937
  { 55048751, 66, 1310718428536ULL },   // M55048751 has a factor: 144306824807179117073
  { 59006687, 66, 1225540844788ULL },   // M59006687 has a factor: 144630210068242194713
  { 59012843, 66, 1230152134785ULL },   // M59012843 has a factor: 145189549592364087511
  { 57008929, 66, 1276588744640ULL },   // M57008929 has a factor: 145553914210761781121
  { 55090031, 66, 1325627240388ULL },   // M55090031 has a factor: 146057691534838744057
  { 57061663, 66, 1281780359172ULL },   // M57061663 has a factor: 146281037790183246073
  { 57072629, 66, 1284580800459ULL },   // M57072629 has a factor: 146628806890239073423
  { 53091043, 66, 1388613901301ULL },   // M53091043 has a factor: 147445920688738293887
  { 53081527, 66, 1389759159404ULL },   // M53081527 has a factor: 147541076686801459817
  { 57064607, 67, 1299154528720ULL },   // M57064607 has a factor: 148271485227354026081
  { 59041769, 67, 1262313931567ULL },   // M59041769 has a factor: 149058495106121244047
  { 55066399, 67, 1369804815117ULL },   // M55066399 has a factor: 150860437002707907367
  { 53013887, 67, 1425975591613ULL },   // M53013887 has a factor: 151193017757059459463
  { 53091667, 67, 1426167185697ULL },   // M53091667 has a factor: 151435186618704573799
  { 55061987, 67, 1380710036937ULL },   // M55061987 has a factor: 152049276209189227639
  { 53060869, 67, 1455795834899ULL },   // M53060869 has a factor: 154491584172642934463
  { 53006537, 67, 1459161615915ULL },   // M53006537 has a factor: 154690208365956472711
  { 59000639, 67, 1335623710729ULL },   // M59000639 has a factor: 157605304793124311663
  { 55008979, 67, 1444348516716ULL },   // M55008979 has a factor: 158904274449423185929
  { 55070863, 67, 1449442813817ULL },   // M55070863 has a factor: 159644133252101028143
  { 55047677, 67, 1467079889479ULL },   // M55047677 has a factor: 161518679778471380567
  { 59006053, 67, 1369960382847ULL },   // M59006053 has a factor: 161671909916340745783
  { 59003327, 67, 1375543874877ULL },   // M59003327 has a factor: 162323330104429431559
  { 57099989, 67, 1426245441387ULL },   // M57099989 has a factor: 162877198028995689487
  { 53020067, 67, 1547199933828ULL },   // M53020067 has a factor: 164065288307912252953
  { 55027733, 67, 1500935190835ULL },   // M55027733 has a factor: 165186121863144854111
  { 53017183, 67, 1565922404708ULL },   // M53017183 has a factor: 166041589388408195129
  { 55047457, 67, 1518329781348ULL },   // M55047457 has a factor: 167160386701146864073
  { 59095261, 67, 1414956733580ULL },   // M59095261 has a factor: 167234474949235128761
  { 53038969, 67, 1587672660156ULL },   // M53038969 has a factor: 168417042008323238329
  { 59076179, 67, 1427156074441ULL },   // M59076179 has a factor: 168621855429227681879
  { 57000137, 67, 1485674742424ULL },   // M57000137 has a factor: 169367327711215424177
  { 53081969, 67, 1597083915207ULL },   // M53081969 has a factor: 169552717754833205167
  { 53032379, 67, 1599392627340ULL },   // M53032379 has a factor: 169639191965801283721
  { 53000461, 67, 1602653229455ULL },   // M53000461 has a factor: 169882719968507557511
  { 57069427, 67, 1491210800552ULL },   // M57069427 has a factor: 170205091847427847409
  { 59054389, 67, 1448901616400ULL },   // M59054389 has a factor: 171127999355228759201
  { 53078611, 67, 1615789422140ULL },   // M53078611 has a factor: 171527716391367695081
  { 57060067, 67, 1537223211192ULL },   // M57060067 has a factor: 175428118849141339729
  { 57005297, 67, 1539221972808ULL },   // M57005297 has a factor: 175487611417691927953
  { 55036367, 67, 1611330714025ULL },   // M55036367 has a factor: 177363577070903894351
  { 55036789, 67, 1615574869755ULL },   // M55036789 has a factor: 177832106440816833391
  { 57069869, 67, 1562004266659ULL },   // M57069869 has a factor: 178286757751340395343
  { 55080131, 67, 1620643696048ULL },   // M55080131 has a factor: 178530534165296044577
  { 57074629, 67, 1568178313496ULL },   // M57074629 has a factor: 179006390897259785969
  { 59018087, 67, 1517931833364ULL },   // M59018087 has a factor: 179170866003092109337
  { 53031751, 67, 1695143055609ULL },   // M53031751 has a factor: 179792808868871282719
  { 57043001, 67, 1580996675056ULL },   // M57043001 has a factor: 180369589832432166113
  { 53051147, 67, 1707427438333ULL },   // M53051147 has a factor: 181161968045674835903
  { 55048687, 67, 1659586200725ULL },   // M55048687 has a factor: 182716082626459396151
  { 53065981, 67, 1733307534404ULL },   // M53065981 has a factor: 183959329375679020649
  { 57050129, 67, 1617560655987ULL },   // M57050129 has a factor: 184564088178765944647
  { 55031803, 67, 1677140933580ULL },   // M55031803 has a factor: 184592178920021289481
  { 55002889, 67, 1695952707032ULL },   // M55002889 has a factor: 186564596988261230897
  { 59024747, 67, 1586047377313ULL },   // M59024747 has a factor: 187232090351826729623
  { 53067307, 67, 1776151408149ULL },   // M53067307 has a factor: 188511144109450569487
  { 55015547, 67, 1715526844725ULL },   // M55015547 has a factor: 188761295511459879151
  { 55046279, 67, 1721189385081ULL },   // M55046279 has a factor: 189490142206014327199
  { 59052283, 67, 1620097277337ULL },   // M59052283 has a factor: 191340885817668020743
  { 53070869, 67, 1817290161844ULL },   // M53070869 has a factor: 192890336228423444873
  { 57030073, 67, 1693316983647ULL },   // M57030073 has a factor: 193139982379056432463
  { 55026661, 67, 1764035655504ULL },   // M55026661 has a factor: 194137984014662784289
  { 59063453, 67, 1667310376836ULL },   // M59063453 has a factor: 196954216157330749417
  { 57050359, 67, 1726568450729ULL },   // M57050359 has a factor: 197002699904326523423
  { 55044389, 67, 1820464298539ULL },   // M55044389 has a factor: 200412690018785695343
  { 55096091, 67, 1829575214881ULL },   // M55096091 has a factor: 201604885060856260343
  { 59029519, 67, 1717727651276ULL },   // M59029519 has a factor: 202793274055644032489
  { 59068201, 67, 1744449099431ULL },   // M59068201 has a factor: 206082940078918587263
  { 55004051, 67, 1880539098421ULL },   // M55004051 has a factor: 206874536954085406943
  { 57079961, 67, 1818644796435ULL },   // M57079961 has a factor: 207616348106725478071
  { 55075021, 67, 1889085201584ULL },   // M55075021 has a factor: 208082814296056066529
  { 55084637, 67, 1918464523780ULL },   // M55084637 has a factor: 211355843779598335721
  { 57080213, 67, 1853354362588ULL },   // M57080213 has a factor: 211579723562004542489
  { 55045943, 67, 1922280451821ULL },   // M55045943 has a factor: 211627480361906024407
  { 57040583, 67, 1867796250145ULL },   // M57040583 has a factor: 213080374066969269071
  { 55035179, 67, 1936194876685ULL },   // M55035179 has a factor: 213117663234483803231
  { 59037677, 67, 1804938420468ULL },   // M59037677 has a factor: 213118742944959945673
  { 57031801, 67, 1870097676599ULL },   // M57031801 has a factor: 213310077084713049599
  { 53055839, 67, 2014477664781ULL },   // M53055839 has a factor: 213759605303433412519
  { 57073829, 67, 1874251634716ULL },   // M57073829 has a factor: 213941434605502895129
  { 57079441, 67, 1894638074535ULL },   // M57079441 has a factor: 216289764383548269871
  { 59028127, 67, 1842892707020ULL },   // M59028127 has a factor: 217565009514700703081
  { 57058129, 67, 1931593697327ULL },   // M57058129 has a factor: 220426244715341842367
  { 57040877, 67, 1939352446407ULL },   // M57040877 has a factor: 221244728710301557879
  { 53028541, 67, 2087251328675ULL },   // M53028541 has a factor: 221367785319893426351
  { 53059351, 67, 2089112346744ULL },   // M53059351 has a factor: 221693890568647206289
  { 55081387, 67, 2017187651684ULL },   // M55081387 has a factor: 222218987388055211417
  { 55099903, 67, 2026736818613ULL },   // M55099903 has a factor: 223346004224209789079
  { 55003027, 67, 2039647673853ULL },   // M55003027 has a factor: 224373592150847506063
  { 59084407, 67, 1899195045444ULL },   // M59084407 has a factor: 224425626074793583417
  { 53056537, 67, 2124928149579ULL },   // M53056537 has a factor: 225482657980959495847
  { 53082853, 67, 2126612335791ULL },   // M53082853 has a factor: 225773300017560583447
  { 59068187, 67, 1923285505668ULL },   // M59068187 has a factor: 227209975806373967833
  { 53085947, 67, 2150089827408ULL },   // M53085947 has a factor: 228279109246040470753
  { 59078801, 67, 1956560690280ULL },   // M59078801 has a factor: 231182519330949508561
  { 53034463, 67, 2204193298317ULL },   // M53034463 has a factor: 233796415848881797543
  { 57072187, 67, 2083846378524ULL },   // M57072187 has a factor: 237859340388789023977
  { 55054829, 67, 2165631725451ULL },   // M55054829 has a factor: 238456968643359505759
  { 59099087, 67, 2017471156384ULL },   // M59099087 has a factor: 238461406782257242817
  { 57038411, 67, 2094682151265ULL },   // M57038411 has a factor: 238954682916434479831
  { 59050837, 67, 2023316932427ULL },   // M59050837 has a factor: 238957116752173582799
  { 53036383, 67, 2256186241661ULL },   // M53036383 has a factor: 239319915264126704327
  { 59027411, 67, 2043832539216ULL },   // M59027411 has a factor: 241284286614952899553
  { 53078581, 67, 2303940958559ULL },   // M53078581 has a factor: 244579833576183049559
  { 59032361, 67, 2071902632811ULL },   // M59032361 has a factor: 244618608353898793543
  { 55067393, 67, 2243774321788ULL },   // M55067393 has a factor: 247117604762416517369
  { 59093291, 67, 2091140866948ULL },   // M59093291 has a factor: 247144791545100891737
  { 57032021, 67, 2208398753076ULL },   // M57032021 has a factor: 251898888123608493193
  { 53096447, 67, 2373532279908ULL },   // M53096447 has a factor: 252052261805848573753
  { 53014613, 67, 2388135374268ULL },   // M53014613 has a factor: 253212145316856356569
  { 57077509, 67, 2254504330727ULL },   // M57077509 has a factor: 257362982455218638087
  { 55001567, 67, 2343019925865ULL },   // M55001567 has a factor: 257739534869597660911
  { 59039683, 67, 2221958549732ULL },   // M59039683 has a factor: 262367456830634029913
  { 55071871, 67, 2390442082496ULL },   // M55071871 has a factor: 263292236000382140033
  { 59067557, 67, 2246581859248ULL },   // M59067557 has a factor: 265400204052594434273
  { 55019849, 67, 2413489868727ULL },   // M55019849 has a factor: 265579696280778724447
  { 59061241, 67, 2251102231560ULL },   // M59061241 has a factor: 265905782827605931921
  { 53097743, 67, 2515557847080ULL },   // M53097743 has a factor: 267140888131774280881
  { 53066219, 67, 2520627275200ULL },   // M53066219 has a factor: 267520318006272937601
  { 57046229, 67, 2346967122031ULL },   // M57046229 has a factor: 267771247797702742199
  { 59042261, 67, 2271360283108ULL },   // M59042261 has a factor: 268212493320592854377
  { 53030447, 67, 2602928759485ULL },   // M53030447 has a factor: 276068951249290079591
  { 59047889, 67, 2344135982611ULL },   // M59047889 has a factor: 276832562604240516359
  { 53003527, 67, 2657202098325ULL },   // M53003527 has a factor: 281682166326051584551
  { 55098647, 67, 2559256176820ULL },   // M55098647 has a factor: 282023105338349525081
  { 55098149, 67, 2566170201207ULL },   // M55098149 has a factor: 282782456210926531687
  { 55053953, 67, 2581691632315ULL },   // M55053953 has a factor: 284264659571926582391
  { 59057071, 67, 2441114587884ULL },   // M59057071 has a factor: 288330155071602255529
  { 57001573, 67, 2532281485928ULL },   // M57001573 has a factor: 288688055953346729489
  { 59035751, 67, 2446672014496ULL },   // M59035751 has a factor: 288882239652908492993
  { 53085559, 67, 2765310741084ULL },   // M53085559 has a factor: 293596132998296811913
  { 53074279, 67, 2777686385792ULL },   // M53074279 has a factor: 294847404428052487937
  { 57040693, 68, 2609662118972ULL },   // M57040693 has a factor: 297713871524022655193
  { 59052193, 68, 2523493909056ULL },   // M59052193 has a factor: 298035698703798719617
  { 57024587, 68, 2616279566980ULL },   // M57024587 has a factor: 298384523567146674521
  { 55068203, 68, 2709618578961ULL },   // M55068203 has a factor: 298427651917591754167
  { 57067561, 68, 2628007623611ULL },   // M57067561 has a factor: 299947970737771565543
  { 53030099, 68, 2835137388381ULL },   // M53030099 has a factor: 300695232768891759439
  { 57056347, 68, 2678555125032ULL },   // M57056347 has a factor: 305657141344908356209
  { 53042987, 68, 2898552201429ULL },   // M53042987 has a factor: 307495733478439656847
  { 57076979, 68, 2716769223196ULL },   // M57076979 has a factor: 310129959800408809769
  { 55091093, 68, 2844246932440ULL },   // M55091093 has a factor: 313385344540033513841
  { 59041369, 68, 2657399617392ULL },   // M59041369 has a factor: 313793022781799779297
  { 55029893, 68, 2905046310252ULL },   // M55029893 has a factor: 319728775226424726073
  { 59013961, 68, 2714717152923ULL },   // M59013961 has a factor: 320412424377257916007
  { 57082433, 68, 2816254988136ULL },   // M57082433 has a factor: 321517373342378029777
  { 53006483, 68, 3036453963900ULL },   // M53006483 has a factor: 321903490835495927401
  { 55071167, 68, 2959045933732ULL },   // M55071167 has a factor: 325916225554451810489
  { 55070473, 68, 2972652291608ULL },   // M55070473 has a factor: 327410735526772981169
  { 55049053, 68, 2982699370296ULL },   // M55049053 has a factor: 328389551436982259377
  { 55005991, 68, 3000835073285ULL },   // M55005991 has a factor: 330127814067198100871
  { 59016383, 68, 2799008951661ULL },   // M59016383 has a factor: 330374768623308124327
  { 53041847, 68, 3121605233229ULL },   // M53041847 has a factor: 331151414350663867927
  { 55075367, 68, 3032689163845ULL },   // M55075367 has a factor: 334052937391373012231
  { 59064701, 68, 2829799263288ULL },   // M59064701 has a factor: 334282494752251993777
  { 57053993, 68, 2937048869832ULL },   // M57053993 has a factor: 335140731320105678353
  { 55094173, 68, 3048960418716ULL },   // M55094173 has a factor: 335959905557783483737
  { 57038291, 68, 2951525213661ULL },   // M57038291 has a factor: 336699908061266586703
  { 57050471, 68, 2972171204304ULL },   // M57050471 has a factor: 339127534196360854369
  { 57074371, 68, 2976698063453ULL },   // M57074371 has a factor: 339786339256996126127
  { 55066061, 68, 3093727785408ULL },   // M55066061 has a factor: 340718805897343675777
  { 59088833, 68, 2896403756367ULL },   // M59088833 has a factor: 342290235721084699423
  { 55056137, 68, 3118789629360ULL },   // M55056137 has a factor: 343417018216446764641
  { 55012381, 68, 3145477594424ULL },   // M55012381 has a factor: 346080423702833127089
  { 59076593, 68, 2931701183611ULL },   // M59076593 has a factor: 346389835243610634647
  { 53097127, 68, 3299532798060ULL },   // M53097127 has a factor: 350391424038514347241
  { 59063843, 68, 2971392152476ULL },   // M59063843 has a factor: 351003679170549050537
  { 57065537, 68, 3090559300179ULL },   // M57065537 has a factor: 352728852190117662247
  { 53051491, 68, 3337130398905ULL },   // M53051491 has a factor: 354079486646670034711
  { 59013301, 68, 3022128279560ULL },   // M59013301 has a factor: 356691531644572855121
  { 53078867, 68, 3384185201769ULL },   // M53078867 has a factor: 359257432456129831447
  { 55000513, 68, 3281572369968ULL },   // M55000513 has a factor: 360976327589731587169
  { 59096299, 68, 3064779354969ULL },   // M59096299 has a factor: 362234234260550319463
  { 55077817, 68, 3298529534223ULL },   // M55077817 has a factor: 363351612110059262383
  { 59066401, 68, 3083700591015ULL },   // M59066401 has a factor: 364286191345657974031
  { 53014837, 68, 3507412723788ULL },   // M53014837 has a factor: 371889827686693685113
  { 53046871, 68, 3530491659041ULL },   // M53046871 has a factor: 374563071207447821423
  { 55083803, 68, 3435104485081ULL },   // M55083803 has a factor: 378437237481236486087
  { 53058283, 68, 3570862262048ULL },   // M53058283 has a factor: 378927640907525887169
  { 55068203, 68, 3442791592641ULL },   // M55068203 has a factor: 379176692620495788247
  { 57079717, 68, 3375285473979ULL },   // M57079717 has a factor: 385320679297864367887
  { 53003437, 68, 3646354394712ULL },   // M53003437 has a factor: 386538630879581250289
  { 55084031, 68, 3597672773733ULL },   // M55084031 has a factor: 396348637192329115447
  { 55083517, 68, 3617601286479ULL },   // M55083517 has a factor: 398540403925975733287
  { 53031871, 68, 3812750158605ULL },   // M53031871 has a factor: 404394549132739799911
  { 59079967, 68, 3432242018900ULL },   // M59079967 has a factor: 405553490425250752601
  { 59070103, 68, 3439651268613ULL },   // M59070103 has a factor: 406361109442101154279
  { 53038771, 68, 3842264275236ULL },   // M53038771 has a factor: 407577950031446349913
  { 53031287, 68, 3885344849245ULL },   // M53031287 has a factor: 412089675588566656631
  { 53058727, 68, 3898540534512ULL },   // M53058727 has a factor: 413703195838212572449
  { 53069501, 68, 3904816707024ULL },   // M53069501 has a factor: 414453348276453750049
  { 55047137, 68, 3767277625032ULL },   // M55047137 has a factor: 414755695084342266769
  { 57083549, 68, 3643681611324ULL },   // M57083549 has a factor: 415988555600825017753
  { 59049979, 68, 3523687592477ULL },   // M59049979 has a factor: 416147356676654815967
  { 53042021, 68, 3931602948571ULL },   // M53042021 has a factor: 417080332323529803983
  { 55085917, 68, 3810198453528ULL },   // M55085917 has a factor: 419776551529143530353
  { 57006679, 68, 3685796173961ULL },   // M57006679 has a factor: 420229998696845771039
  { 53065567, 68, 3986350942857ULL },   // M53065567 has a factor: 423075946087382609839
  { 59037749, 68, 3602365531855ULL },   // M59037749 has a factor: 425351104151813988791
  { 57042071, 68, 3734744076645ULL },   // M57042071 has a factor: 426075073573627063591
  { 55033673, 68, 3920704503003ULL },   // M55033673 has a factor: 431541539095789240039
  { 57069469, 68, 3805903857255ULL },   // M57069469 has a factor: 434401824397189295191
  { 53014669, 68, 4108689179679ULL },   // M53014669 has a factor: 435641593769127422503
  { 53077097, 68, 4154812754607ULL },   // M53077097 has a factor: 441050799186225871759
  { 57011179, 68, 3868984813920ULL },   // M57011179 has a factor: 441150771549349623361
  { 53026759, 68, 4164367352957ULL },   // M53026759 has a factor: 441645808025437552727
  { 57040481, 68, 3898033275579ULL },   // M57040481 has a factor: 444691385986063426999
  { 59084479, 68, 3769750896912ULL },   // M59084479 has a factor: 445467535407656457697
  { 53024077, 68, 4240362826035ULL },   // M53024077 has a factor: 449682649991234889391
  { 55015201, 68, 4107304039004ULL },   // M55015201 has a factor: 451928314547833799609
  { 53060101, 68, 4317376765100ULL },   // M53060101 has a factor: 458160894422518550201
  { 55069327, 68, 4172208296660ULL },   // M55069327 has a factor: 459521406001765095641
  { 59096057, 68, 3902566339975ULL },   // M59096057 has a factor: 461252565746887957151
  { 59014489, 68, 3940188444167ULL },   // M59014489 has a factor: 465056415192441071327
  { 55067347, 68, 4253234259113ULL },   // M55067347 has a factor: 468428653637726966423
  { 57000469, 68, 4127247410915ULL },   // M57000469 has a factor: 470510076202381438271
  { 59056169, 68, 3998322399292ULL },   // M59056169 has a factor: 472251206658147664697
  { 55010849, 68, 4296158264152ULL },   // M55010849 has a factor: 472670627098735570097
  { 57015797, 68, 4162055069992ULL },   // M57015797 has a factor: 474605773946969327249
  { 55003643, 68, 4328694313773ULL },   // M55003643 has a factor: 476187913381800150079
  { 57042437, 68, 4185079138347ULL },   // M57042437 has a factor: 477454226178346063279
  { 57026111, 68, 4232947058449ULL },   // M57026111 has a factor: 482777017624472323679
  { 55001311, 68, 4406379333528ULL },   // M55001311 has a factor: 484713280214692510417
  { 59051131, 68, 4120919389868ULL },   // M59051131 has a factor: 486689901463070681417
  { 59014147, 68, 4159081536089ULL },   // M59014147 has a factor: 490889298311484102167
  { 57088379, 68, 4320532347436ULL },   // M57088379 has a factor: 493304376264372092489
  { 55095149, 68, 4477524583975ULL },   // M55095149 has a factor: 493379768210531274551
  { 55089869, 68, 4612344080932ULL },   // M55089869 has a factor: 508186862402938555817
  { 55002137, 68, 4630400697840ULL },   // M55002137 has a factor: 509363867094982568161
  { 53013907, 68, 4829274010773ULL },   // M53013907 has a factor: 512037366569273640223
  { 55077601, 68, 4694486049504ULL },   // M55077601 has a factor: 517122059069295119809
  { 55089943, 68, 4712596779452ULL },   // M55089943 has a factor: 519233375923988502473
  { 53029351, 68, 4908542975688ULL },   // M53029351 has a factor: 520593696712686836977
  { 55053839, 68, 4764263056401ULL },   // M55053839 has a factor: 524581942521497146879
  { 57073361, 68, 4613666192415ULL },   // M57073361 has a factor: 526634872266393513631
  { 55009847, 68, 4797522905680ULL },   // M55009847 has a factor: 527822002040904461921
  { 59061713, 68, 4477943524672ULL },   // M59061713 has a factor: 528950030568772166273
  { 53006227, 68, 4996467592013ULL },   // M53006227 has a factor: 529687790760768929903
  { 59086823, 68, 4487564228440ULL },   // M59086823 has a factor: 530311826533931692241
  { 55006153, 68, 4878313194111ULL },   // M55006153 has a factor: 536674483874376729967
  { 57059953, 68, 4779096096860ULL },   // M57059953 has a factor: 545389997338630095161
  { 57004261, 68, 4786912234503ULL },   // M57004261 has a factor: 545748788799404434567
  { 57060649, 68, 4785531975396ULL },   // M57060649 has a factor: 546131120652695584009
  { 57062329, 68, 4796452128980ULL },   // M57062329 has a factor: 547393458833214388841
  { 57046559, 68, 4809574122537ULL },   // M57046559 has a factor: 548739307892360400367
  { 55002251, 68, 5024509893309ULL },   // M55002251 has a factor: 552718708607529677119
  { 53029531, 68, 5222428128593ULL },   // M53029531 has a factor: 553885828680988959767
  { 53056543, 68, 5239943972720ULL },   // M53056543 has a factor: 556026625412419013921
  { 53077679, 68, 5268962648869ULL },   // M53077679 has a factor: 559328616279316990103
  { 57078811, 68, 4900564167789ULL },   // M57078811 has a factor: 559436751853201237759
  { 55030463, 68, 5111816961997ULL },   // M55030463 has a factor: 562611308379896629223
  { 59057731, 68, 4764575353364ULL },   // M59057731 has a factor: 562770019096402114169
  { 57009761, 68, 4947977295996ULL },   // M57009761 has a factor: 564166006156316433913
  { 59020963, 68, 4789394683665ULL },   // M59020963 has a factor: 565349372833977338791
  { 57027329, 68, 4957030081716ULL },   // M57027329 has a factor: 565372370665830433129
  { 57002573, 68, 5004894313863ULL },   // M57002573 has a factor: 570583706966521138999
  { 59017171, 68, 4858064868281ULL },   // M59017171 has a factor: 573418490120864506103
  { 57036839, 68, 5033404440009ULL },   // M57036839 has a factor: 574178957333356983103
  { 59086603, 68, 4859446476348ULL },   // M59086603 has a factor: 574256369495446331689
  { 53092363, 68, 5431798484988ULL },   // M53092363 has a factor: 576774033815665893289
  { 53050819, 68, 5473591595724ULL },   // M53050819 has a factor: 580757034049350195913
  { 53016419, 68, 5491188934404ULL },   // M53016419 has a factor: 582246346709051958553
  { 59010139, 68, 4972007374484ULL },   // M59010139 has a factor: 586797692554651786553
  { 55066493, 68, 5337149285391ULL },   // M55066493 has a factor: 587796187527877007527
  { 55044889, 68, 5355821776331ULL },   // M55044889 has a factor: 589621230363845444519
  { 53002811, 69, 5691243157221ULL },   // M53002811 has a factor: 603303770834455896463
  { 59074789, 69, 5126224802772ULL },   // M59074789 has a factor: 605661297180645030217
  { 59051777, 69, 5165052768960ULL },   // M59051777 has a factor: 610011088611716883841
  { 53035417, 69, 5754966795075ULL },   // M53035417 has a factor: 610434127595912342551
  { 57073273, 69, 5358575497028ULL },   // M57073273 has a factor: 611662884465979465289
  { 57049357, 69, 5384897502620ULL },   // M57049357 has a factor: 614409880070753630681
  { 59059783, 69, 5202678477501ULL },   // M59059783 has a factor: 614538123799958884567
  { 55097759, 69, 5592027381877ULL },   // M55097759 has a factor: 616216354016119827287
  { 53070833, 69, 5947687866607ULL },   // M53070833 has a factor: 631297499009652747263
  { 57096113, 69, 5531349392412ULL },   // M57096113 has a factor: 631637099903273789113
  { 57061003, 69, 5576211869237ULL },   // M57061003 has a factor: 636368484398336129423
  { 59049223, 69, 5396181837341ULL },   // M59049223 has a factor: 637280689323396872087
  { 55028569, 69, 5813320632231ULL },   // M55028569 has a factor: 639797431059694414879
  { 53007761, 69, 6095357885739ULL },   // M53007761 has a factor: 646202548033436440759
  { 53048341, 69, 6109380870903ULL },   // M53048341 has a factor: 648185039477078643847
  { 59084371, 69, 5592241206885ULL },   // M59084371 has a factor: 660828108378162188671
  { 55089043, 69, 6021647269121ULL },   // M55089043 has a factor: 663453570678878682407
  { 55038169, 69, 6047735595671ULL },   // M55038169 has a factor: 665712587563712332799
  { 55093721, 69, 6058180355208ULL },   // M55093721 has a factor: 667535396515020897937
  { 53047277, 69, 6380811402564ULL },   // M53047277 has a factor: 676969339913142036457
  { 53044591, 69, 6496663464549ULL },   // M53044591 has a factor: 689225712683289408919
  { 53021497, 69, 6616832560335ULL },   // M53021497 has a factor: 701668735494609042991
  { 57093929, 69, 6150102728260ULL },   // M57093929 has a factor: 702267057019965467081
  { 57088123, 69, 6176662232420ULL },   // M57088123 has a factor: 705228106507695095321
  { 57080197, 69, 6295902292763ULL },   // M57080197 has a factor: 718742686327327428623
  { 57057853, 69, 6324800522540ULL },   // M57057853 has a factor: 721759076938821013241
  { 57029363, 69, 6387945890616ULL },   // M57029363 has a factor: 728600970040596315217
  { 59081557, 69, 6177607456463ULL },   // M59081557 has a factor: 729965334125287505783
  { 55006321, 69, 6645757454171ULL },   // M55006321 has a factor: 731117335624545629783
  { 59087521, 69, 6212753238579ULL },   // M59087521 has a factor: 734192374904709345319
  { 53012441, 69, 6996460321891ULL },   // M53012441 has a factor: 741798880046175291863
  { 59042791, 69, 6291711538161ULL },   // M59042791 has a factor: 742960418759856894703
  { 59054077, 69, 6309560592819ULL },   // M59054077 has a factor: 745210554168997746127
  { 53019667, 69, 7057902143948ULL },   // M53019667 has a factor: 748415242781418050633
  { 57013289, 69, 6661235842800ULL },   // M57013289 has a factor: 759557928405429938401
  { 55062379, 69, 6993301452369ULL },   // M55062379 has a factor: 770135630063184651703
  { 55042399, 69, 7075521779700ULL },   // M55042399 has a factor: 778907385862875000601
  { 53070517, 69, 7349211010899ULL },   // M53070517 has a factor: 780052855781005129567
  { 55013027, 69, 7089986336169ULL },   // M55013027 has a factor: 780083219482592547127
  { 57020027, 69, 6956512595844ULL },   // M57020027 has a factor: 793321072081729935577
  { 59028451, 69, 6769899304973ULL },   // M59028451 has a factor: 799233338797065573647
  { 57035659, 69, 7031840265449ULL },   // M57035659 has a factor: 802131287045237291783
  { 59006797, 69, 6830747241300ULL },   // M59006797 has a factor: 806121031651398232201
  { 55014343, 69, 7362888174861ULL },   // M55014343 has a factor: 810128911044894062647
  { 53054663, 69, 7700803157932ULL },   // M53054663 has a factor: 817127032746836073833
  { 57017273, 69, 7226606422908ULL },   // M57017273 has a factor: 824082782556997779769
  { 53034743, 69, 7789372933561ULL },   // M53034743 has a factor: 826214783325127419647
  { 53069323, 69, 7825737636321ULL },   // M53069323 has a factor: 830613196670351361367
  { 59084507, 69, 7044781406505ULL },   // M59084507 has a factor: 832474872652229036071
  { 59086873, 69, 7093633081163ULL },   // M59086873 has a factor: 838281193950553746599
  { 59046557, 69, 7103113440100ULL },   // M59046557 has a factor: 838828785236661471401
  { 57004153, 69, 7358182255563ULL },   // M57004153 has a factor: 838893894195996706279
  { 53008009, 69, 7920653693732ULL },   // M53008009 has a factor: 839716164566458199177
  { 53010071, 69, 7936574973061ULL },   // M53010071 has a factor: 841436805637573394663
  { 55045787, 69, 7697617396680ULL },   // M55045787 has a factor: 847442815250283574321
  { 59085017, 69, 7238974619580ULL },   // M59085017 has a factor: 855429876920905665721
  { 59017643, 69, 7284767834641ULL },   // M59017643 has a factor: 859859654805451142327
  { 53086769, 69, 8103584765199ULL },   // M53086769 has a factor: 860386265004077104063
  { 59029081, 69, 7310384771339ULL },   // M59029081 has a factor: 863050589617072618919
  { 53060773, 69, 8198754064032ULL },   // M53060773 has a factor: 870064456548858833473
  { 55060471, 69, 7917442096544ULL },   // M55060471 has a factor: 871876181901880224449
  { 57005603, 69, 7652438728672ULL },   // M57005603 has a factor: 872463768297001498433
  { 55008917, 69, 7988270476092ULL },   // M55008917 has a factor: 878852215185790624729
  { 53025851, 69, 8288961675529ULL },   // M53025851 has a factor: 879058493502622200359
  { 53068439, 69, 8305856952652ULL },   // M53068439 has a factor: 881557726069077100457
  { 57087197, 69, 7722982156015ULL },   // M57087197 has a factor: 881766807535826079911
  { 53040397, 69, 8434600554924ULL },   // M53040397 has a factor: 894749123939178529657
  { 53015381, 69, 8484482169120ULL },   // M53015381 has a factor: 899616109567206469441
  { 55051651, 69, 8198158202309ULL },   // M55051651 has a factor: 902644288392604924319
  { 55049609, 69, 8229378260484ULL },   // M55049609 has a factor: 906048111105488701513
  { 59030779, 69, 7699181750444ULL },   // M59030779 has a factor: 908977392782585831753
  { 59090033, 69, 7695478905115ULL },   // M59090033 has a factor: 909452204908098437591
  { 55044151, 69, 8321117487825ULL },   // M55044151 has a factor: 916057694977159923151
  { 55004471, 69, 8332847872668ULL },   // M55004471 has a factor: 916687778319157397257
  { 59092183, 69, 7776017492628ULL },   // M59092183 has a factor: 919003697371149853849
  { 53026381, 69, 8723846744715ULL },   // M53026381 has a factor: 925188042541734652831
  { 59018051, 69, 7896569951313ULL },   // M59018051 has a factor: 932080336223316301927
  { 59096003, 69, 8062786048776ULL },   // M59096003 has a factor: 952956857053649284657
  { 57068383, 69, 8371157892656ULL },   // M57068383 has a factor: 955456889543130990497
  { 59001907, 69, 8100351509777ULL },   // M59001907 has a factor: 955872372894344289479
  { 59011483, 69, 8110792078917ULL },   // M59011483 has a factor: 957259737763090407823
  { 57099697, 69, 8389059104127ULL },   // M57099697 has a factor: 958025465921486299039
  { 53003033, 69, 9196350832588ULL },   // M53003033 has a factor: 974868973318478478809
  { 59095877, 69, 8343309601368ULL },   // M59095877 has a factor: 986110395950724719473
  { 57017027, 69, 8695743071800ULL },   // M57017027 has a factor: 991610835019767077201
  { 53005499, 69, 9394411521181ULL },   // M53005499 has a factor: 995910940983095948639
  { 59092021, 69, 8458651347296ULL },   // M59092021 has a factor: 999677606092187050433
  { 57069547, 69, 8823977710245ULL },   // M57069547 has a factor: 1007160821323558818031
  { 55041587, 69, 9170899243213ULL },   // M55041587 has a factor: 1009561697127084998063
  { 59022671, 69, 8556629094348ULL },   // M59022671 has a factor: 1010070207809459927017
  { 57041741, 69, 8896741602568ULL },   // M57041741 has a factor: 1014971260475217581777
  { 53094857, 69, 9620400259872ULL },   // M53094857 has a factor: 1021587552161333356609
  { 53067367, 69, 9739960859937ULL },   // M53067367 has a factor: 1033748155039824751759
  { 55076101, 69, 9406224876848ULL },   // M55076101 has a factor: 1036116382691986019297
  { 57096287, 69, 9095255934457ULL },   // M57096287 has a factor: 1038610686344420122319
  { 53099047, 69, 9795137233113ULL },   // M53099047 has a factor: 1040224904625034286623
  { 53000789, 69, 9940416035932ULL },   // M53000789 has a factor: 1053699785785296700697
  { 53038847, 69, 10004849381044ULL },   // M53038847 has a factor: 1061291351158474832537
  { 59007587, 69, 9031335447649ULL },   // M59007587 has a factor: 1065834624306664625927
  { 55074091, 69, 9767043733040ULL },   // M55074091 has a factor: 1075822110708849333281
  { 55094197, 69, 9771737658195ULL },   // M55094197 has a factor: 1076732079145827988831
  { 59095061, 69, 9168657959856ULL },   // M59095061 has a factor: 1083644802851651742433
  { 59029567, 69, 9243441935445ULL },   // M59029567 has a factor: 1091272750077920604631
  { 59019533, 69, 9269333297212ULL },   // M59019533 has a factor: 1094143444845604883993
  { 55026341, 69, 9948220305291ULL },   // M55026341 has a factor: 1094828325724133340463
  { 59091811, 69, 9270073510769ULL },   // M59091811 has a factor: 1095570863708936425319
  { 59002973, 69, 9463808963971ULL },   // M59002973 has a factor: 1116785729556677771567
  { 55025059, 69, 10153991605964ULL },   // M55025059 has a factor: 1117447974407347703753
  { 59060453, 69, 9484054091043ULL },   // M59060453 has a factor: 1120265061787005644959
  { 53002903, 69, 10654344067080ULL },   // M53002903 has a factor: 1129422330232133466481
  { 53024401, 69, 10663510157919ULL },   // M53024401 has a factor: 1130852477362140763039
  { 55073567, 69, 10312554453793ULL },   // M55073567 has a factor: 1135898317304234379263
  { 55074403, 69, 10414489300173ULL },   // M55074403 has a factor: 1147143561513831543439
  { 53014513, 69, 10982191096211ULL },   // M53014513 has a factor: 1164431025277124620487
  { 53081767, 69, 11039668371645ULL },   // M53081767 has a factor: 1172010208521858593431
  { 59085757, 70, 10973764226567ULL },   // M59085757 has a factor: 1296786332932461412439
  { 53020921, 70, 12449816180120ULL },   // M53020921 has a factor: 1320201440301328581041
  { 55004857, 70, 12513612812099ULL },   // M55004857 has a factor: 1376618966565746729687
  { 59097047, 70, 12428515730764ULL },   // M59097047 has a factor: 1468977156562398907817
  { 57034027, 70, 13489842199065ULL },   // M57034027 has a factor: 1538760048414425169511
  { 59050507, 70, 13034575780373ULL },   // M59050507 has a factor: 1539396616721892598223
  { 53042911, 70, 14787522006068ULL },   // M53042911 has a factor: 1568746427356812767897
  { 53037889, 70, 15060603405876ULL },   // M53037889 has a factor: 1597565223427746471529
  { 59084351, 70, 14538262125580ULL },   // M59084351 has a factor: 1717967564715549597161
  { 59082013, 70, 14574655181292ULL },   // M59082013 has a factor: 1722199933783222601593
  { 53047303, 70, 16559509315437ULL },   // M53047303 has a factor: 1756874616374618232823
  { 53068987, 70, 16616904651920ULL },   // M53068987 has a factor: 1763684593905964010081
  { 53020897, 70, 17135468571228ULL },   // M53020897 has a factor: 1817075828323633903033
  { 55008823, 70, 16848361117653ULL },   // M55008823 has a factor: 1853617029122112104839
  { 55006423, 70, 17783602827497ULL },   // M55006423 has a factor: 1956424759186592026463
  { 55004491, 70, 17991637665993ULL },   // M55004491 has a factor: 1979241744148745949127
  { 59093821, 70, 17247431719376ULL },   // M59093821 has a factor: 2038433285469055151393
  { 55072529, 70, 19072176306211ULL },   // M55072529 has a factor: 2100705965433836355239  (70.831 bits)
  { 59081027, 70, 19739849850384ULL },   // M59081027 has a factor: 2332501203972966128737
  { 53098891, 71, 23701475186585ULL },   // M53098891 has a factor: 2517044094943363154471
  { 53054003, 71, 25965374884605ULL },   // M53054003 has a factor: 2755134154047916647631
  { 53071913, 71, 27494270070736ULL },   // M53071913 has a factor: 2918347018385209675937
  { 53042551, 71, 29448171670221ULL },   // M53042551 has a factor: 3124012295348905147543
  { 59081219, 71, 30371580373636ULL },   // M59081219 has a factor: 3588779982861780684569
  { 53019053, 71, 35529538993632ULL },   // M53019053 has a factor: 3767485021937883340993
  { 53030851, 71, 35904387888264ULL },   // M53030851 has a factor: 3808080488697465665329
  { 53088509, 71, 37594989081195ULL },   // M53088509 has a factor: 3991723832383844976511
  { 53093479, 71, 40458219120456ULL },   // M53093479 has a factor: 4296135214498658212849
  { 53062591, 71, 41349578058845ULL },   // M53062591 has a factor: 4388231497118132334791
  { 53033059, 71, 41935796374196ULL },   // M53033059 has a factor: 4447967126649445091129
  { 53020403, 72, 47592621564828ULL },   // M53020403 has a factor: 5046759950387342371369
  { 53084533, 72, 48070791832748ULL },   // M53084533 has a factor: 5103631070763283373369
  { 53038499, 72, 48630398704200ULL },   // M53038499 has a factor: 5158566706084625991601
  { 53039123, 72, 49332576228388ULL },   // M53039123 has a factor: 5233113156968694447449
  { 55072561, 72, 48482119352744ULL },   // M55072561 has a factor: 5340068950926548914769
  { 53019457, 72, 50821452373619ULL },   // M53019457 has a factor: 5389051617601281009767
  { 53018023, 72, 51815428534757ULL },   // M53018023 has a factor: 5494303163621205850823
  { 53061917, 72, 66681512653668ULL },   // M53061917 has a factor: 7076497779726762323113
  { 53084477, 72, 80861310659188ULL },   // M53084477 has a factor: 8584960771755040449353
  { 53066239, 72, 87283119933537ULL },   // M53066239 has a factor: 9263573806117477114687
  { 53018549, 72, 88611061738447ULL },   // M53018549 has a factor: 9396059837443754906807
  { 53006851, 73, 92775661554729ULL },   // M53006851 has a factor: 9835491336915896896759
  { 53010319, 73, 98474670889584ULL },   // M53010319 has a factor: 10440347434553723234593
  { 59000581, 73, 92940118912844ULL },   // M59000581 has a factor: 10967042028133768724729
  { 53024761, 73, 128817174681435ULL },   // M53024761 has a factor: 13660999800356684024071
  { 53050111, 73, 132402158653128ULL },   // M53050111 has a factor: 14047898426376101794417
  { 53022611, 73, 148020244911336ULL },   // M53022611 has a factor: 15696839732116996436593
  { 53029799, 73, 177872388120297ULL },   // M53029799 has a factor: 18865073979338675460607
  { 53022457, 74, 198472168704800ULL },   // M53022457 has a factor: 21046964061694007387201
  { 53016793, 74, 291083818433787ULL },   // M53016793 has a factor: 30864661095107339170183
  { 57000443, 74, 293378053427736ULL },   // M57000443 has a factor: 33445358023717240974097
  { 53081891, 75, 386157411282960ULL },   // M53081891 has a factor: 40995931229128505754721
  { 57000487, 75, 361521255205517ULL },   // M57000487 has a factor: 41213775215131508173559
  { 53061187, 75, 426643247402852ULL },   // M53061187 has a factor: 45276394265459988610649
  { 53078689, 75, 434339246277140ULL },   // M53078689 has a factor: 46108315547277443738921
  { 57000257, 75, 417712132260144ULL },   // M57000257 has a factor: 47619397781692397714017
  { 57000763, 75, 540877969472528ULL },   // M57000763 has a factor: 61660913899649607077729
  { 53064863, 75, 594278282461813ULL },   // M53064863 has a factor: 63070591285422819153239
  { 53044609, 75, 614917961099460ULL },   // M53044609 has a factor: 65236165627196131622281
  { 53050111, 76, 768920427885728ULL },   // M53050111 has a factor: 81582628099010731431617
  { 53094473, 76, 878919127974691ULL },   // M53094473 has a factor: 93331495818871551965687
  { 53004449, 76, 918534704293932ULL },   // M53004449 has a factor: 97372851776955599406937
  { 53029937, 76, 943037681935699ULL },   // M53029937 has a factor: 100018457723352312041927
  { 53062447, 76, 1028170233829125ULL },   // M53062447 has a factor: 109114457079071104737751
  { 53084827, 76, 1059144150703625ULL },   // M53084827 has a factor: 112448968016327722795751
  { 53088829, 76, 1159130084719931ULL },   // M53088829 has a factor: 123073717712903859501599
  { 53044099, 76, 1267732323953900ULL },   // M53044099 has a factor: 134491437794621486072201
  { 53044039, 76, 1290659778439737ULL },   // M53044039 has a factor: 136923615246577537155487
  { 53059429, 77, 1446495975456587ULL },   // M53059429 has a factor: 153500501017049041017647
  { 53095543, 77, 1525344134793677ULL },   // M53095543 has a factor: 161977950197470946563223
  { 53009771, 77, 2210787761203644ULL },   // M53009771 has a factor: 234386705902015705611049
  { 53065567, 77, 2540078201431413ULL },   // M53065567 has a factor: 269581379966596284912343
  { 53088691, 77, 2551280043119528ULL },   // M53088691 has a factor: 270888235727278596115697
  { 59000327, 78, 3352267850409973ULL },   // M59000327 has a factor: 395569798731550982122343
  { 53051221, 78, 4163773360864388ULL },   // M53051221 has a factor: 441786521522258797635497
  { 53028419, 78, 4965028712418049ULL },   // M53028419 has a factor: 526575245818269611069063
  { 53037371, 78, 5571167425289781ULL },   // M53037371 has a factor: 590960147276417794811503
  { 53082719, 79, 5933623173454032ULL },   // M53082719 has a factor: 629945703136697280146017
  { 53087093, 79, 6002212097998168ULL },   // M53087093 has a factor: 637279983704307716891249
  { 53088883, 79, 6021838563689916ULL },   // M53088883 has a factor: 639385365905243997607657
  { 53082581, 79, 7898168688909744ULL },   // M53082581 has a factor: 838510358361430575138529
  { 53068859, 79, 8268780657335457ULL },   // M53068859 has a factor: 877629509612125366467127
  { 53012683, 79, 9009978447212285ULL },   // M53012683 has a factor: 955286262517794196821311
  { 53034979, 79, 9133825347709872ULL },   // M53034979 has a factor: 968824471010921519225377
  { 53005387, 79, 9700341334900797ULL },   // M53005387 has a factor: 1028340692977026703186879
  { 53023253, 79, 10352781386886511ULL },   // M53023253 has a factor: 1097876293461148710080567
  { 53069609, 79, 10432286715549811ULL },   // M53069609 has a factor: 1107274753940245379587799
  { 53041039, 80, 11447730330473552ULL },   // M53041039 has a factor: 1214399021840261120201057
  { 53081923, 80, 13008353094881957ULL },   // M53081923 has a factor: 1381016794678671471126623
  { 53001709, 80, 14544347121690252ULL },   // M53001709 has a factor: 1541750507477628649281337
  { 53051513, 81, 25400641105665876ULL },   // M53051513 has a factor: 2695084883651135188540777
  { 53070817, 81, 25449238147490279ULL },   // M53070817 has a factor: 2701223721029751212175887
  { 53088911, 81, 33337244996055961ULL },   // M53088911 has a factor: 3539676065161620529096943
  { 53099239, 81, 34022791077796796ULL },   // M53099239 has a factor: 3613168629773999328476489
  { 53046979, 81, 38311654756902632ULL },   // M53046979 has a factor: 4064635090689328049497457
  { 53090729, 81, 39013342094197995ULL },   // M53090729 has a factor: 4142493545014716449776711
  { 59000521, 82, 52458215998362768ULL },   // M59000521 has a factor: 6190124149267876918004257
  { 53023727, 82, 60514352076223044ULL },   // M53023727 has a factor: 6417392968143067752329977
  { 53067871, 82, 64953428965361244ULL },   // M53067871 has a factor: 6893880378682907929983049
  { 53032183, 82, 66201239283267200ULL },   // M53032183 has a factor: 7021592472994029976595201
  { 53070701, 83, 124753600587908599ULL },   // M53070701 has a factor: 13241522070948642945715799
  { 53006321, 84, 190383228169207579ULL },   // M53006321 has a factor: 20183029010706518496213719
  { 53039501, 84, 194225082089011303ULL },   // M53039501 has a factor: 20603202871370394188959607
  { 53042503, 85, 556554380633003408ULL },   // M53042503 has a factor: 59042074808778450335700449
  { 53052781, 85, 575903318987911400ULL },   // M53052781 has a factor: 61106545318877610303206801
  { 53032349, 86, 737953769588724291ULL },   // M53032349 has a factor: 78270843709389626130179119
  { 53025209, 86, 782495269697275984ULL },   // M53025209 has a factor: 82983950434418851564561313
  { 53050747, 86, 823239913109231529ULL },   // M53050747 has a factor: 87346984701319650418804327
  { 53000869, 86, 1271483669602049760ULL },   // M53000869 has a factor: 134779478816435042922482881
  { 53097391, 87, 1660470362901298004ULL },   // M53097391 has a factor: 176333288205764229051815129
  { 53015323, 87, 2589820601322255465ULL },   // M53015323 has a factor: 274600351382307201130980391
  { 601983997, 65, 49948926615ULL },   // M601983997 has a factor: 60136908979114760311 (65.705 bits)
  { 601986001, 65, 34847593440ULL }   // M601986001 has a factor: 41955526838838866881 (65.185 bits)

#ifdef EXTENDED_SELFTEST
// generated out of a csv file ("exp";bits;k;"factor") by
// sed -e 's/^"/  { /' -e 's/";/, /' -e 's/;/, /' -e 's/;"/},   \/\/ factor: /' -e 's/"$//' all.csv > all.h

  ,
  { 1158743, 62, 1993912308273ULL },   // factor: 4620863859650361679
  { 1017623, 62, 2306815047816ULL },   // factor: 4694936098807322737
  { 1093993, 62, 2146033807448ULL },   // factor: 4695491926222919729
  { 1011349, 62, 2341996179212ULL },   // factor: 4737150987699753977
  { 1126703, 62, 2135611134361ULL },   // factor: 4812398943835883567
  { 1054373, 62, 2293109352316ULL },   // factor: 4835585174258955737
  { 1177541, 62, 2064184317868ULL },   // factor: 4861323331693205177
  { 1007557, 62, 2450940495335ULL },   // factor: 4938924505316493191
  { 1186033, 62, 2173997534940ULL },   // factor: 5156865636714986041
  { 1041449, 62, 2486961588304ULL },   // factor: 5180087318355224993
  { 1056623, 62, 2460517373988ULL },   // factor: 5199678498510645049
  { 1166383, 62, 2266267103781ULL },   // factor: 5286670846618788247
  { 1005637, 62, 2632068723359ULL },   // factor: 5293811389505149367
  { 1158757, 62, 2312001397164ULL },   // factor: 5358095605947130297
  { 1024909, 62, 2615877495504ULL },   // factor: 5362072776079018273
  { 1127443, 62, 2388329303888ULL },   // factor: 5385410310726796769
  { 1111211, 62, 2424975696049ULL },   // factor: 5389319336364610679
  { 1082491, 62, 2513024331876ULL },   // factor: 5440652444073566233
  { 1193429, 62, 2328381807939ULL },   // factor: 5557516745333665663
  { 1128769, 62, 2471875138359ULL },   // factor: 5580352056100700143
  { 1160219, 62, 2415185146224ULL },   // factor: 5604287390333726113
  { 1164101, 62, 2429200737795ULL },   // factor: 5655670016135794591
  { 1044347, 62, 2718863350284ULL },   // factor: 5678873566558089097
  { 1112269, 62, 2674775207655ULL },   // factor: 5950139090886438391
  { 1190947, 62, 2539248828405ULL },   // factor: 6048221548884899071
  { 1071241, 62, 2834174101688ULL },   // factor: 6072166997732709617
  { 1167559, 62, 2610000763136ULL },   // factor: 6094659762012610049
  { 1123319, 62, 2754466912756ULL },   // factor: 6188290035940314329
  { 1030919, 62, 3049533681525ULL },   // factor: 6287644426848142951
  { 1118393, 62, 2820906455940ULL },   // factor: 6309764067956208841
  { 1004449, 62, 3158522409171ULL },   // factor: 6345149350738803559
  { 1034069, 62, 3151305374091ULL },   // factor: 6517334393761812559
  { 1174507, 62, 2856075860925ULL },   // factor: 6708962182374877951
  { 1099493, 62, 3073045463343ULL },   // factor: 6757583951254770199
  { 1076137, 62, 3175768713599ULL },   // factor: 6835124432292574127
  { 1148963, 62, 2979271744305ULL },   // factor: 6846146002303811431
  { 1039667, 62, 3569826723928ULL },   // factor: 7422862081172103953
  { 1061689, 62, 3532221173235ULL },   // factor: 7500240730381387831
  { 1175021, 62, 3236848597791ULL },   // factor: 7606730152449957223
  { 1182413, 62, 3266182331836ULL },   // factor: 7723952899066400537
  { 1036363, 62, 3735942936797ULL },   // factor: 7743586059615498623
  { 1067987, 62, 3646132487965ULL },   // factor: 7788044194848552911
  { 1190513, 62, 3285324269703ULL },   // factor: 7822442504593855279
  { 1197971, 62, 3308912315553ULL },   // factor: 7927961991150685927
  { 1034849, 62, 3864169351024ULL },   // factor: 7997663577475670753
  { 1077721, 62, 3712628935568ULL },   // factor: 8002356338138561057
  { 1076429, 62, 3761916041227ULL },   // factor: 8098871044683876767
  { 1109509, 62, 3672502395327ULL },   // factor: 8149348920273728887
  { 1094689, 62, 3773091186239ULL },   // factor: 8260722835145569343
  { 1036499, 62, 3996501133089ULL },   // factor: 8284738855891230823
  { 1101403, 62, 3781743492165ULL },   // factor: 8330447255002014991
  { 1118317, 62, 3728294300375ULL },   // factor: 8338829794224937751
  { 1194293, 62, 3497380467867ULL },   // factor: 8353794022220566063
  { 1194163, 62, 3537062091728ULL },   // factor: 8447657357288367329
  { 1175173, 62, 3604481384580ULL },   // factor: 8471778404322064681
  { 1108823, 62, 3827413691433ULL },   // factor: 8487848663151626719
  { 1056361, 62, 4153303958459ULL },   // factor: 8774776645723415399
  { 1156297, 62, 3810268792647ULL },   // factor: 8811604748262696319
  { 1072867, 62, 4153551463088ULL },   // factor: 8912416595097666593
  { 1003003, 62, 4459539314768ULL },   // factor: 8945862622660496609
  { 1045411, 62, 4294935327920ULL },   // factor: 8979945272192350241
  { 1191613, 62, 3829363310328ULL },   // factor: 9126238204619758129
  { 1170641, 63, 4001679010528ULL },   // factor: 9369059037127016897
  { 1110311, 63, 4245266351188ULL },   // factor: 9427131855307798937
  { 1084949, 63, 4435350733560ULL },   // factor: 9624258686050376881
  { 1015967, 63, 4767793288644ULL },   // factor: 9687841288167557497
  { 1094999, 63, 4431808023897ULL },   // factor: 9705650708718382207
  { 1150921, 63, 4253183401715ULL },   // factor: 9790156187770459031
  { 1076639, 63, 4628879299264ULL },   // factor: 9967263959760587393
  { 1077227, 63, 4627736908128ULL },   // factor: 9970246292664002113
  { 1183561, 63, 4232597823920ULL },   // factor: 10019075426153158241
  { 1063891, 63, 4711553864024ULL },   // factor: 10025159503900714769
  { 1135279, 63, 4418040136965ULL },   // factor: 10031416377306976471
  { 1106671, 63, 4574387436005ULL },   // factor: 10124683836382178711
  { 1195121, 63, 4238087284959ULL },   // factor: 10130054228174970079
  { 1194797, 63, 4250572729864ULL },   // factor: 10157143091846635217
  { 1085429, 63, 4693302722487ULL },   // factor: 10188493761532683847
  { 1048867, 63, 4899593796017ULL },   // factor: 10278044492093925479
  { 1100171, 63, 4690483671801ULL },   // factor: 10320668223377955943
  { 1106891, 63, 4769955730344ULL },   // factor: 10559642136632401009
  { 1167421, 63, 4558468762260ULL },   // factor: 10643304321812662921
  { 1165279, 63, 4596861804605ULL },   // factor: 10713253053616619591
  { 1169563, 63, 4624098896496ULL },   // factor: 10816349955365102497
  { 1191209, 63, 4627929695844ULL },   // factor: 11025663010113270793
  { 1005287, 63, 5719975586133ULL },   // factor: 11500434194113770343
  { 1028617, 63, 5609258045084ULL },   // factor: 11539556365120337657
  { 1193501, 63, 4875576480495ULL },   // factor: 11638010810094525991
  { 1064873, 63, 5468595781003ULL },   // factor: 11646719990208015239
  { 1081139, 63, 5490902479185ULL },   // factor: 11872857630887183431
  { 1193237, 63, 5132746297128ULL },   // factor: 12249165586692246673
  { 1048891, 63, 5935887073488ULL },   // factor: 12452197056795803617
  { 1081679, 63, 5795971152472ULL },   // factor: 12538760560469520977
  { 1047247, 63, 6065044631304ULL },   // factor: 12703199589998440177
  { 1004963, 63, 6321210220080ULL },   // factor: 12705164772804514081
  { 1157063, 63, 5641551788625ULL },   // factor: 13055261674403616751
  { 1104449, 63, 5923602658539ULL },   // factor: 13084634065241480023
  { 1008187, 63, 6515243314173ULL },   // factor: 13137167222372268703
  { 1031831, 63, 6413167963048ULL },   // factor: 13234611024959561777
  { 1119959, 63, 6132632537544ULL },   // factor: 13736594008230481393
  { 1057613, 63, 6604668057151ULL },   // factor: 13970365595855281127
  { 1033337, 63, 6905271228907ULL },   // factor: 14270944511730145319
  { 1163629, 63, 6308411979855ULL },   // factor: 14681302247413387591
  { 1111757, 63, 6641369740843ULL },   // factor: 14767178597940782303
  { 1029517, 63, 7343232887760ULL },   // factor: 15119966185816023841
  { 1016401, 63, 7441158243960ULL },   // factor: 15126401360638375921
  { 1032299, 63, 7481389648720ULL },   // factor: 15446062105968014561
  { 1160927, 63, 6787661951872ULL },   // factor: 15759960053601810689
  { 1131857, 63, 7371186523000ULL },   // factor: 16686258128726422001
  { 1069807, 63, 7845024519752ULL },   // factor: 16785324292804655729
  { 1105961, 63, 7651273304176ULL },   // factor: 16924019749519586273
  { 1187863, 63, 7234083989781ULL },   // factor: 17186201420706456007
  { 1036913, 63, 8425625175943ULL },   // factor: 17473280556125167919
  { 1190311, 63, 7583772931269ULL },   // factor: 18054096683183469319
  { 1052039, 63, 8653115867445ULL },   // factor: 18206830728141940711
  { 1129127, 64, 8291775482473ULL },   // factor: 18724935150396582143
  { 1179989, 64, 7945170570612ULL },   // factor: 18750427752891766537
  { 1087001, 64, 8668562911504ULL },   // factor: 18845473106735519009
  { 1088579, 64, 8672531312980ULL },   // factor: 18881470928304910841
  { 1162229, 64, 8197425034287ULL },   // factor: 19054570200348691447
  { 1039543, 64, 9190718322101ULL },   // factor: 19108293793423679687
  { 1009927, 64, 9538068116765ULL },   // factor: 19265505037920252311
  { 1186373, 64, 8124207846235ULL },   // factor: 19276681670322711311
  { 1189637, 64, 8148927072783ULL },   // factor: 19388530312168699543
  { 1000117, 64, 9727236081723ULL },   // factor: 19456748336689123183
  { 1047997, 64, 9747291706992ULL },   // factor: 20430264934104990049
  { 1181633, 64, 8722700627151ULL },   // factor: 20614061820324635167
  { 1012967, 64, 10554673649569ULL },   // factor: 21383072205565922447
  { 1051979, 64, 10272380010004ULL },   // factor: 21612656101087995833
  { 1035637, 64, 10443970551819ULL },   // factor: 21632324660748347407
  { 1075351, 64, 10106086612164ULL },   // factor: 21735180688954339129
  { 1059511, 64, 10292750141348ULL },   // factor: 21810563990019521657
  { 1167659, 64, 9358333287205ULL },   // factor: 21854684175609006191
  { 1187339, 64, 9331193094492ULL },   // factor: 22158578955242073577
  { 1189831, 64, 9454672178061ULL },   // factor: 22498924104588995383
  { 1026331, 64, 11118963365144ULL },   // factor: 22823473579023213329
  { 1038041, 64, 11070912201003ULL },   // factor: 22984121544082710247
  { 1006883, 64, 11519063441448ULL },   // factor: 23196698310230973169
  { 1173463, 64, 9994943993916ULL },   // factor: 23457393927865302217
  { 1048559, 64, 11255061373957ULL },   // factor: 23603191798429955927
  { 1126991, 64, 10490116509328ULL },   // factor: 23644533789928144097
  { 1145533, 64, 10329303069575ULL },   // factor: 23665115066398916951
  { 1048627, 64, 11326394015105ULL },   // factor: 23754325153755021671
  { 1146697, 64, 10780220337063ULL },   // factor: 24723292639698261823
  { 1088023, 64, 11470079732972ULL },   // factor: 24959421122614788713
  { 1170193, 64, 10934434883700ULL },   // factor: 25590798319723108201
  { 1134989, 64, 11330511006055ULL },   // factor: 25720010712502716791
  { 1174687, 64, 11080730617028ULL },   // factor: 26032780412649540473
  { 1188613, 64, 11070634602791ULL },   // factor: 26317400414254437767
  { 1021621, 64, 12907015764603ULL },   // factor: 26372156704898962927
  { 1118303, 64, 11872800402453ULL },   // factor: 26554776616928794519
  { 1120529, 64, 11951080444047ULL },   // factor: 26783064437775081727
  { 1053467, 64, 12717821072257ULL },   // factor: 26795609623054730039
  { 1032613, 64, 13197881401896ULL },   // factor: 27256607816112068497
  { 1033069, 64, 13213064795192ULL },   // factor: 27300015269808408497
  { 1013839, 64, 13501805630405ULL },   // factor: 27377314237048349591
  { 1070681, 64, 12921090374799ULL },   // factor: 27668731927160336239
  { 1051987, 64, 13296963482928ULL },   // factor: 27976465447029955873
  { 1111543, 64, 12889399106417ULL },   // factor: 28654242701888142863
  { 1080091, 64, 13335501145320ULL },   // factor: 28807109535099648241
  { 1002527, 64, 14832797258757ULL },   // factor: 29740559474859757879
  { 1138741, 64, 13073392758224ULL },   // factor: 29774416685785511969
  { 1052473, 64, 14190808208511ULL },   // factor: 29870884975272395407
  { 1116473, 64, 13441909065648ULL },   // factor: 30015057080502439009
  { 1190347, 64, 12620160084693ULL },   // factor: 30044739392668116943
  { 1137233, 64, 13626703603707ULL },   // factor: 30993474038709045463
  { 1109021, 64, 14300875786639ULL },   // factor: 31719943131548340839
  { 1071991, 64, 15156742791240ULL },   // factor: 32495783723048317681
  { 1158293, 64, 14115890161072ULL },   // factor: 32700673524677140193
  { 1093199, 64, 15661851333541ULL },   // factor: 34243040431951375319
  { 1187639, 64, 14595210526456ULL },   // factor: 34667682468859354769
  { 1185181, 64, 14939939640164ULL },   // factor: 35413065205338419369
  { 1168247, 64, 15172600841437ULL },   // factor: 35450690830412501879
  { 1027001, 64, 17614076061204ULL },   // factor: 36179347457865138409
  { 1162243, 64, 15601880587761ULL },   // factor: 36266352999922215847
  { 1132477, 64, 16070136151208ULL },   // factor: 36398119156223164433
  { 1093069, 64, 16759958421111ULL },   // factor: 36639581982810759319
  { 1083193, 65, 17155557891992ULL },   // factor: 37165560439400980913
  { 1115743, 65, 16932792475548ULL },   // factor: 37785289350090704329
  { 1026031, 65, 18421935307721ULL },   // factor: 37802953411432570703
  { 1014173, 65, 18795181412316ULL },   // factor: 38123131036945509337
  { 1009993, 65, 18878888790171ULL },   // factor: 38135091051702357607
  { 1052851, 65, 18119429657244ULL },   // factor: 38154119268118005289
  { 1105537, 65, 17327063321183ULL },   // factor: 38311419205821380543
  { 1052111, 65, 18613089172308ULL },   // factor: 39166071724332284377
  { 1187047, 65, 16550508203084ULL },   // factor: 39292462221892505897
  { 1169873, 65, 16862034598312ULL },   // factor: 39452878003262108753
  { 1045543, 65, 19754256979265ULL },   // factor: 41307850209743331791
  { 1169593, 65, 17708632185263ULL },   // factor: 41423784486916615919
  { 1121539, 65, 18784230006816ULL },   // factor: 42134493075228819649
  { 1137547, 65, 18670717899053ULL },   // factor: 42477638267828085983
  { 1035613, 65, 21153278565011ULL },   // factor: 43813220549093473487
  { 1027261, 65, 21994952430539ULL },   // factor: 45189113657495847359
  { 1104749, 65, 20598784133724ULL },   // factor: 45512972345894910553
  { 1181281, 65, 19367785691340ULL },   // factor: 45757594498503613081
  { 1033099, 65, 22230232286309ULL },   // factor: 45932061489507083183
  { 1068037, 65, 21548119457700ULL },   // factor: 46028377722487069801
  { 1117763, 65, 20757961041736ULL },   // factor: 46404961615787913137
  { 1070569, 65, 21947281872932ULL },   // factor: 46992159214845876617
  { 1061591, 65, 22718661554953ULL },   // factor: 48235853277568220447
  { 1133009, 65, 21415607784324ULL },   // factor: 48528152720218301833
  { 1131643, 65, 21451864642316ULL },   // factor: 48551704918848810377
  { 1040671, 65, 24009717129833ULL },   // factor: 49972432670440875887
  { 1106653, 65, 23301117205596ULL },   // factor: 51572502517848860377
  { 1136123, 65, 23141394669381ULL },   // factor: 52582941471922299727
  { 1158467, 65, 22753336021873ULL },   // factor: 52717977842502297383
  { 1182341, 65, 22644482114004ULL },   // factor: 53546999254307206729
  { 1084771, 65, 25165834469684ULL },   // factor: 54598334847027164729
  { 1168183, 65, 23439682326477ULL },   // factor: 54763676838381762583
  { 1161289, 65, 23692368548376ULL },   // factor: 55027373958350033329
  { 1150159, 65, 23948230928244ULL },   // factor: 55088546672396381593
  { 1178131, 65, 23725503462876ULL },   // factor: 55903502240443129513
  { 1197827, 65, 23361742956832ULL },   // factor: 55966652961506408129
  { 1191899, 65, 23639542750140ULL },   // factor: 56351894728698231721
  { 1014037, 65, 27833074522047ULL },   // factor: 56447534778225947479
  { 1145789, 65, 24757455638440ULL },   // factor: 56733640677025058321
  { 1115767, 65, 26407586312445ULL },   // factor: 58929426714155640631
  { 1064953, 65, 28586448827187ULL },   // factor: 60886448875718554423
  { 1060481, 65, 28811967851596ULL },   // factor: 61109088958456755353
  { 1132063, 65, 27011461712256ULL },   // factor: 61157352760723328257
  { 1099289, 65, 28114232395036ULL },   // factor: 61811332830613458809
  { 1160479, 65, 27743220509157ULL },   // factor: 64390849586492012407
  { 1011737, 65, 31877958469924ULL },   // factor: 64504220136970995977
  { 1134667, 65, 28564176710265ULL },   // factor: 64821657390612513511
  { 1019717, 65, 31955660153608ULL },   // factor: 65171459809713377873
  { 1175939, 65, 27718692078172ULL },   // factor: 65190982087427007017
  { 1162543, 65, 28287057076637ULL },   // factor: 65769840390089615783
  { 1097237, 65, 30111224070412ULL },   // factor: 66078298330693303289
  { 1058381, 65, 31915734415548ULL },   // factor: 67558013812924215577
  { 1124051, 65, 30433413617625ULL },   // factor: 68417418020609997751
  { 1086493, 65, 31613593745348ULL },   // factor: 68695896618328769129
  { 1147051, 65, 30173830442336ULL },   // factor: 69221844765423902273
  { 1013933, 65, 34165571990236ULL },   // factor: 69283201809551916377
  { 1122091, 65, 31072231528784ULL },   // factor: 69731742696729534689
  { 1132561, 65, 30899394190700ULL },   // factor: 69990897568026765401
  { 1168879, 65, 30362726286596ULL },   // factor: 70980706278300091769
  { 1139393, 65, 31419760872796ULL },   // factor: 71598911200275305657
  { 1181153, 65, 30503158147431ULL },   // factor: 72057793510625135887
  { 1033801, 65, 35300034757056ULL },   // factor: 72986422463758499713
  { 1166987, 66, 32115466924005ULL },   // factor: 74956664798487645871
  { 1133017, 66, 33343408315539ULL },   // factor: 75557296918894102327
  { 1131869, 66, 34099630112916ULL },   // factor: 77192628472552240009
  { 1088543, 66, 35619218275380ULL },   // factor: 77546101438273942681
  { 1072439, 66, 36284913612981ULL },   // factor: 77826712940383461319
  { 1120517, 66, 35093403907815ULL },   // factor: 78645511333146280711
  { 1138171, 66, 35727649542884ULL },   // factor: 81328349215747650329
  { 1041163, 66, 39274960266008ULL },   // factor: 81783270910875374609
  { 1153871, 66, 35892470277640ULL },   // factor: 82830561143461488881
  { 1035403, 66, 40066641974132ULL },   // factor: 82970242599884390393
  { 1180477, 66, 36169524417195ULL },   // factor: 85394583350874204031
  { 1198187, 66, 35919847514685ULL },   // factor: 86077388668155752191
  { 1130651, 66, 39792896783484ULL },   // factor: 89983757082285936169
  { 1156741, 66, 39332748154559ULL },   // factor: 90995604866105464439
  { 1007861, 66, 47993873728723ULL },   // factor: 96742307140208983007
  { 1109281, 66, 44076913692879ULL },   // factor: 97787365796301019999
  { 1173959, 66, 41946923736276ULL },   // factor: 98487937285029673369
  { 1140901, 66, 43344643869483ULL },   // factor: 98903895070674048367
  { 1192097, 66, 41842728998820ULL },   // factor: 99761183422612651081
  { 1159997, 66, 43178696942440ULL },   // factor: 100174317834279145361
  { 1117901, 66, 45765342511359ULL },   // factor: 102322244317581474919
  { 1111049, 66, 46283201865720ULL },   // factor: 102845810299412680561
  { 1054309, 66, 50698066171515ULL },   // factor: 106902854894447616271
  { 1123621, 66, 47590272103551ULL },   // factor: 106946858262528156343
  { 1103449, 66, 52195639062012ULL },   // factor: 115190451454676158777
  { 1114349, 66, 53099863776432ULL },   // factor: 118343560198806445537
  { 1135951, 66, 52969987978529ULL },   // factor: 120342621628395992159
  { 1011719, 66, 59659016408565ULL },   // factor: 120716320843713946471
  { 1110541, 66, 54567492466236ULL },   // factor: 121198875301892387353
  { 1195771, 66, 51043104041736ULL },   // factor: 122071727126181396913
  { 1137007, 66, 54408617327237ULL },   // factor: 123725957522779519319
  { 1082143, 66, 57385492514100ULL },   // factor: 124198618051371432601
  { 1184489, 66, 53337735067827ULL },   // factor: 126355920945510670807
  { 1074607, 66, 59623545434088ULL },   // factor: 128143758576578006833
  { 1090469, 66, 59685438887580ULL },   // factor: 130170241716600950041
  { 1072943, 66, 61451431903632ULL },   // factor: 131867767401957257953
  { 1149403, 66, 57443676538973ULL },   // factor: 132051868289850366239
  { 1125193, 66, 59615663757783ULL },   // factor: 134158255101222254239
  { 1123919, 66, 60230152396749ULL },   // factor: 135387625303203478663
  { 1039421, 66, 66144180338688ULL },   // factor: 137503300143638839297
  { 1118437, 66, 62098232844380ULL },   // factor: 138905922495539668121
  { 1045621, 66, 67872080841939ULL },   // factor: 141936946084058198239
  { 1077751, 66, 66407739188184ULL },   // factor: 143142014635608988369
  { 1056739, 66, 68166229421625ULL },   // factor: 144067826225557161751
  { 1190249, 66, 61880721759084ULL },   // factor: 147306934386055943833
  { 1068989, 67, 69659138276832ULL },   // factor: 148929705134824725697
  { 1121707, 67, 66724770175317ULL },   // factor: 149691283558088612239
  { 1146841, 67, 65958280520111ULL },   // factor: 151287320779929238703
  { 1032259, 67, 74370353124000ULL },   // factor: 153538932690854232001
  { 1085309, 67, 71531221410315ULL },   // factor: 155266956755215124671
  { 1069919, 67, 73773462398025ULL },   // factor: 157863258230865019951
  { 1160359, 67, 69765829193921ULL },   // factor: 161906815595257955279
  { 1092059, 67, 74395978105480ULL },   // factor: 162489594907784766641
  { 1146281, 67, 71071992022719ULL },   // factor: 162936948175588716079
  { 1014547, 67, 80952155096760ULL },   // factor: 164259532193905135441
  { 1061911, 67, 79411095028340ULL },   // factor: 168655030665279115481
  { 1179571, 67, 71621252876933ULL },   // factor: 168964705754593471487
  { 1147889, 67, 75676312279660ULL },   // factor: 173736012852773275481
  { 1163971, 67, 74772450411060ULL },   // factor: 174065927754823838521
  { 1147183, 67, 76337016306077ULL },   // factor: 175145054754108662183
  { 1137817, 67, 77936150734143ULL },   // factor: 177354154439740771663
  { 1016123, 67, 90064719295596ULL },   // factor: 183033665529597788617
  { 1156633, 67, 80226766121256ULL },   // factor: 185585850358253382097
  { 1142171, 67, 83728406464780ULL },   // factor: 191264315480568474761
  { 1079011, 67, 93043103390744ULL },   // factor: 200789064065500148369
  { 1043183, 67, 97916687673240ULL },   // factor: 204290047994067045841
  { 1133479, 67, 90216985319169ULL },   // factor: 204518116605172717903
  { 1045763, 67, 98603098346313ULL },   // factor: 206230943871870643639
  { 1037479, 67, 100116261280772ULL },   // factor: 207737037274628107577
  { 1117069, 67, 94647815837295ULL },   // factor: 211456281979102576711
  { 1060567, 67, 101099627486000ULL },   // factor: 214445857247889124001
  { 1128947, 67, 95037129920304ULL },   // factor: 214583765424274879777
  { 1195709, 67, 92134107466227ULL },   // factor: 220331163008669639887
  { 1028047, 67, 115087605497537ULL },   // factor: 236630935137852840479
  { 1138141, 67, 106050431005235ULL },   // factor: 241400687189458336271
  { 1108463, 67, 108907733097621ULL },   // factor: 241440385105176533047
  { 1175371, 67, 104304901117464ULL },   // factor: 245193911862669558289
  { 1156427, 67, 106894807994637ULL },   // factor: 247232084249628163999
  { 1077533, 67, 117861634908055ULL },   // factor: 253999602094762456631
  { 1001003, 67, 131177589876601ULL },   // factor: 262618321998494461607
  { 1170049, 67, 114524580937691ULL },   // factor: 267998742803128833719
  { 1127369, 67, 120348264739440ULL },   // factor: 271353805742075466721
  { 1118303, 67, 121663919603500ULL },   // factor: 272114252568705721001
  { 1178927, 67, 118688081456173ULL },   // factor: 279849167613763332743
  { 1131353, 67, 123719508269163ULL },   // factor: 279940873677684735079
  { 1057907, 67, 134906032879257ULL },   // factor: 285436073050392270199
  { 1025009, 67, 139931639914444ULL },   // factor: 286862380594128659993
  { 1159027, 67, 126924829449692ULL },   // factor: 294218608605176339369
  { 1157293, 67, 127305718504128ULL },   // factor: 294660033769595611009
  { 1174973, 68, 128762654565696ULL },   // factor: 302585285046039052417
  { 1105873, 68, 136832713341395ULL },   // factor: 302639206401977025671
  { 1144981, 68, 133271745623723ULL },   // factor: 305187233151991968527
  { 1124437, 68, 136098860777547ULL },   // factor: 306069189432245232079
  { 1147451, 68, 138599020609500ULL },   // factor: 318071169594782769001
  { 1069927, 68, 149571207447872ULL },   // factor: 320060546542158690689
  { 1170581, 68, 137166133872423ULL },   // factor: 321128140309029575527
  { 1056271, 68, 153238329464940ULL },   // factor: 323722407004523277481
  { 1185383, 68, 136913322058660ULL },   // factor: 324589448883721133561
  { 1137067, 68, 143429263942452ULL },   // factor: 326177365726504136569
  { 1135291, 68, 147831161683268ULL },   // factor: 335662774757118021977
  { 1128161, 68, 151037008810344ULL },   // factor: 340788125792972994769
  { 1148729, 68, 148362334784931ULL },   // factor: 340856232950318005399
  { 1148087, 68, 151756961432712ULL },   // factor: 348460389160796043889
  { 1004917, 68, 178515527730848ULL },   // factor: 358786577161401159233
  { 1193683, 68, 150755600979341ULL },   // factor: 359908796087645405807
  { 1022201, 68, 178430717949135ULL },   // factor: 364784116636647492271
  { 1101697, 68, 166335486188988ULL },   // factor: 366502612255899025273
  { 1073201, 68, 171430360372803ULL },   // factor: 367958468364905104807
  { 1008937, 68, 183878097562328ULL },   // factor: 371042832240485050673
  { 1145873, 68, 166107914010015ULL },   // factor: 380677147500795836191
  { 1158887, 68, 165541727847220ULL },   // factor: 383688312719362488281
  { 1006189, 68, 194158730292092ULL },   // factor: 390720757347739514777
  { 1045003, 68, 188915685587988ULL },   // factor: 394834916373008447929
  { 1093633, 68, 185220814484156ULL },   // factor: 405127190013501957497
  { 1051949, 68, 193945925185000ULL },   // factor: 408042444104871130001
  { 1162043, 68, 175576823640933ULL },   // factor: 408055637748361412239
  { 1112147, 68, 184914572022444ULL },   // factor: 411304373062090054537
  { 1076731, 68, 197646741904085ULL },   // factor: 425624748114254692271
  { 1031707, 68, 207107248199985ULL },   // factor: 427347995437323848791
  { 1087843, 68, 198381758308433ULL },   // factor: 431616414207041360039
  { 1093243, 68, 202415641885865ULL },   // factor: 442578967164457420391
  { 1065011, 68, 210477495532236ULL },   // factor: 448321695988564389193
  { 1116329, 68, 200896165434520ULL },   // factor: 448532430926704554161
  { 1187947, 68, 196630366927545ULL },   // factor: 467172909000952600231
  { 1028411, 68, 230788671616536ULL },   // factor: 474691217131666808593
  { 1097819, 68, 217893882171540ULL },   // factor: 478416087663355742521
  { 1079233, 68, 222669862345596ULL },   // factor: 480625327097649215737
  { 1187413, 68, 202407730108523ULL },   // factor: 480683140062703241999
  { 1049827, 68, 243008401230209ULL },   // factor: 510233561676613247687
  { 1171033, 68, 222557574325695ULL },   // factor: 521244527870683185871
  { 1134311, 68, 234344317097449ULL },   // factor: 531638673342248945279
  { 1026167, 68, 260153130932677ULL },   // factor: 533921115819584718119
  { 1052629, 68, 259774819427175ULL },   // factor: 546893016797615586151
  { 1122599, 68, 245988727533849ULL },   // factor: 552293399081542707103
  { 1160581, 68, 239249821881504ULL },   // factor: 555337595058115587649
  { 1074713, 68, 262576210566660ULL },   // factor: 564388133973453737161
  { 1094029, 68, 258866847762836ULL },   // factor: 566415677182255412489
  { 1079021, 68, 266821586061868ULL },   // factor: 575812189228125742457
  { 1059871, 68, 275563162396844ULL },   // factor: 584122808985410894249
  { 1164029, 69, 255619890834631ULL },   // factor: 595097931816689376599
  { 1118947, 69, 270333316928669ULL },   // factor: 604977307954766783087
  { 1164853, 69, 262624084015928ULL },   // factor: 611836904276411557169
  { 1102951, 69, 298344825729968ULL },   // factor: 658119447767387871137
  { 1039349, 69, 323116877138467ULL },   // factor: 671662406273977075967
  { 1062931, 69, 316028188320653ULL },   // factor: 671832316479720027887
  { 1133683, 69, 297126375569465ULL },   // factor: 673694241669435579191
  { 1153853, 69, 303932217903808ULL },   // factor: 701386202849925144449
  { 1108223, 69, 319941044707152ULL },   // factor: 709132048776988221793
  { 1179419, 69, 302981026505212ULL },   // factor: 714683158599501263657
  { 1024021, 69, 350028113522900ULL },   // factor: 716872277675667161801
  { 1179337, 69, 315616282341312ULL },   // factor: 744435919135111740289
  { 1019647, 69, 371236797037820ULL },   // factor: 757060972778444099081
  { 1188247, 69, 319441564765625ULL },   // factor: 759150962016119218751
  { 1166531, 69, 336937023660489ULL },   // factor: 786094966295387787319
  { 1089497, 69, 370290169448664ULL },   // factor: 806860057487622164017
  { 1194379, 69, 398907031858520ULL },   // factor: 952892363608294518161
  { 1028333, 69, 476062180161456ULL },   // factor: 979100899823941065697
  { 1000889, 69, 490030900917984ULL },   // factor: 980933076777800175553
  { 1002647, 69, 491114563385413ULL },   // factor: 984829087269388376423
  { 1083301, 69, 473549941875116ULL },   // factor: 1025994251166510075833
  { 1020979, 69, 502598346048024ULL },   // factor: 1026284713499530990993
  { 1184671, 69, 434892402310388ULL },   // factor: 1030408834274899324697
  { 1022249, 69, 504640333915975ULL },   // factor: 1031736153410543055551
  { 1023353, 69, 523863554069907ULL },   // factor: 1072194679296203076343
  { 1143067, 69, 469290267571077ULL },   // factor: 1072860436563336546319
  { 1158251, 69, 470654323487313ULL },   // factor: 1090271681667007539127
  { 1188287, 69, 459115852677085ULL },   // factor: 1091122798460190606791
  { 1023353, 69, 535369376050816ULL },   // factor: 1095743714179461412097
  { 1071773, 69, 513328817669775ULL },   // factor: 1100343933800775522151
  { 1190143, 69, 485903732579132ULL },   // factor: 1156589852005851791753
  { 1022017, 69, 566494470887148ULL },   // factor: 1157933959305340675033
  { 1194449, 70, 524720105285664ULL },   // factor: 1253502810076712158273
  { 1102253, 70, 581586192124740ULL },   // factor: 1282110250056142078441
  { 1111043, 70, 582705223942285ULL },   // factor: 1294821120249016306511
  { 1008451, 70, 697594502576985ULL },   // factor: 1406979747436526200471
  { 1132499, 70, 622870633030957ULL },   // factor: 1410800738073851543087
  { 1042709, 70, 677594165840772ULL },   // factor: 1413067070139331062697
  { 1087487, 70, 650818667916633ULL },   // factor: 1415513681433310942543
  { 1044851, 70, 677612227801600ULL },   // factor: 1416007627661459123201
  { 1068887, 70, 677196028185889ULL },   // factor: 1447692061959060671087
  { 1196347, 70, 631500991565433ULL },   // factor: 1510988633512662146503
  { 1064191, 70, 730105363907700ULL },   // factor: 1553943114644598341401
  { 1000159, 70, 784691163851204ULL },   // factor: 1569631859492512682873
  { 1014259, 70, 775036179222365ULL },   // factor: 1572174840203793405071
  { 1152343, 70, 689142283599552ULL },   // factor: 1588256573019917100673
  { 1114657, 70, 723693603481775ULL },   // factor: 1613340281952369752351
  { 1139681, 70, 709903956245340ULL },   // factor: 1618128101515290673081
  { 1042123, 70, 777844977086496ULL },   // factor: 1621220282112620942017
  { 1073393, 70, 758021927598396ULL },   // factor: 1627310861861250155257
  { 1110539, 70, 733927044524952ULL },   // factor: 1630109212199391338257
  { 1068629, 70, 785978631430147ULL },   // factor: 1679839117853133116927
  { 1159577, 70, 727755359473792ULL },   // factor: 1687776752945082611969
  { 1199839, 70, 741295798137360ULL },   // factor: 1778871218282663770081
  { 1033057, 70, 885389243616500ULL },   // factor: 1829315111685461281001
  { 1100837, 70, 851821297364419ULL },   // factor: 1875432803053509837407
  { 1190831, 70, 804619396170685ULL },   // factor: 1916331440322665978471
  { 1104853, 70, 878899699543772ULL },   // factor: 1942109939480070251033
  { 1056589, 70, 922847757193904ULL },   // factor: 1950141577851499666913
  { 1017953, 70, 967037290952067ULL },   // factor: 1968797022873058917703
  { 1097147, 70, 908250850294540ULL },   // factor: 1992969391296207354761
  { 1151401, 70, 902380611027836ULL },   // factor: 2078003875836122796473
  { 1091633, 70, 954960961348768ULL },   // factor: 2084933798240079316289
  { 1053509, 70, 1021989945932412ULL },   // factor: 2153351211898618867417
  { 1099369, 70, 1033698142056207ULL },   // factor: 2272831385468380466767
  { 1085023, 70, 1082249861357925ULL },   // factor: 2348531982640319714551
  { 1053509, 71, 1134905275579456ULL },   // factor: 2391265843940874222209
  { 1066159, 71, 1149571635853920ULL },   // factor: 2451252291420758986561
  { 1003741, 71, 1228200023051976ULL },   // factor: 2465589438676426884433
  { 1030411, 71, 1244285637363428ULL },   // factor: 2564251215762574417817
  { 1156367, 71, 1114124886347029ULL },   // factor: 2576674504900909767287
  { 1153277, 71, 1124275603164472ULL },   // factor: 2593202389581425549489
  { 1048633, 71, 1245188346824400ULL },   // factor: 2611491183391022090401
  { 1015559, 71, 1306583031392689ULL },   // factor: 2653824313556255696303
  { 1069207, 71, 1248894142959269ULL },   // factor: 2670652719822102259367
  { 1069933, 71, 1326892876820196ULL },   // factor: 2839372952749725533737
  { 1006937, 71, 1425997311788508ULL },   // factor: 2871778910280769759993
  { 1052063, 71, 1380737807354916ULL },   // factor: 2905246319638469983417
  { 1128997, 71, 1303117361035787ULL },   // factor: 2942431182514640831279
  { 1097069, 71, 1341716522940399ULL },   // factor: 2943911208211401181063
  { 1100147, 71, 1363982882246500ULL },   // factor: 3001163351909680471001
  { 1160717, 71, 1313135027345259ULL },   // factor: 3048356299070213981407
  { 1189339, 71, 1334519266982240ULL },   // factor: 3174391620946780678721
  { 1125931, 71, 1462862422296041ULL },   // factor: 3294164299996407478343
  { 1172443, 71, 1406708856004913ULL },   // factor: 3298571902521936424919
  { 1021067, 71, 1672767260506228ULL },   // factor: 3416014896766625410553
  { 1040227, 71, 1652978813800404ULL },   // factor: 3438946385086305703417
  { 1091021, 71, 1578173175121375ULL },   // factor: 3443640151388195347751
  { 1098953, 71, 1584768861881292ULL },   // factor: 3483172990142062974553
  { 1045507, 71, 1688015328571689ULL },   // factor: 3529663684258001702647
  { 1052309, 71, 1701762504851500ULL },   // factor: 3581559999435554227001
  { 1143167, 71, 1659255272879545ULL },   // factor: 3793611745063781638031
  { 1003543, 71, 1901940520893413ULL },   // factor: 3817358192317876724519
  { 1080097, 71, 1776036571979372ULL },   // factor: 3836583546570407518169
  { 1186769, 71, 1690236407662336ULL },   // factor: 4011840342570045664769
  { 1058779, 71, 2061519598119876ULL },   // factor: 4365387317155528382809
  { 1105339, 71, 2024103678403116ULL },   // factor: 4474641471564843672649
  { 1142599, 71, 1965853140869876ULL },   // factor: 4492363665809558895449
  { 1107511, 71, 2081143195936685ULL },   // factor: 4609777964150067882071
  { 149095181, 62, 15466923864ULL },   // factor: 4612087626032598769
  { 148814987, 62, 15515302729ULL },   // factor: 4617819147834399047
  { 149366081, 62, 15479898123ULL },   // factor: 4624343433823531927
  { 148998907, 62, 15524604405ULL },   // factor: 4626298175904770671
  { 148103773, 62, 15660854616ULL },   // factor: 4638863314068132337
  { 149106361, 62, 15557127596ULL },   // factor: 4639333366904476313
  { 148971881, 62, 15584575603ULL },   // factor: 4643327084331238487
  { 148204367, 62, 15700834672ULL },   // factor: 4653864527870825249
  { 148396673, 62, 15695721511ULL },   // factor: 4658385705133865807
  { 148794197, 62, 15684554860ULL },   // factor: 4667541491392294841
  { 148262113, 62, 15745544292ULL },   // factor: 4668935334134017993
  { 149942467, 62, 15576659084ULL },   // factor: 4671205381345840457
  { 148942177, 62, 15682836900ULL },   // factor: 4671671738843862601
  { 149079727, 62, 15669933732ULL },   // factor: 4672138885749302329
  { 148998271, 62, 15691501149ULL },   // factor: 4676013081191026759
  { 149429011, 62, 15663559973ULL },   // factor: 4681180551009153407
  { 149661419, 62, 15651739144ULL },   // factor: 4684922980217770673
  { 149027173, 62, 15722447567ULL },   // factor: 4686143827101476183
  { 148931807, 62, 15738031272ULL },   // factor: 4687786871922937009
  { 148976437, 62, 15739431432ULL },   // factor: 4689608830290335569
  { 149769539, 62, 15656818540ULL },   // factor: 4689828989884906121
  { 149380303, 62, 15698524121ULL },   // factor: 4690100579695577327
  { 148228207, 62, 15824802720ULL },   // factor: 4691364266628646081
  { 149570809, 62, 15682478247ULL },   // factor: 4691281917057383647
  { 148850531, 62, 15770003508ULL },   // factor: 4694746792075325497
  { 148802809, 62, 15800784692ULL },   // factor: 4702402293147599657
  { 149318381, 62, 15751673008ULL },   // factor: 4704028623191920097
  { 148516463, 62, 15845912400ULL },   // factor: 4706757725311682401
  { 149819333, 62, 15719519907ULL },   // factor: 4710175975093924063
  { 148503559, 62, 15916849016ULL },   // factor: 4727417453883295889
  { 148360613, 62, 15934034992ULL },   // factor: 4727966397953140193
  { 149973029, 62, 15770501844ULL },   // factor: 4730299860789530953
  { 148618303, 62, 15929081981ULL },   // factor: 4734706264728196487
  { 149685157, 62, 15836329239ULL },   // factor: 4740926856886811047
  { 149405881, 62, 15872550203ULL },   // factor: 4742904693591887687
  { 149616023, 62, 15851518501ULL },   // factor: 4743282313261083047
  { 149430433, 62, 15875766123ULL },   // factor: 4744645211933242519
  { 148781279, 62, 15977975340ULL },   // factor: 4754447213831319721
  { 149187979, 62, 15943475816ULL },   // factor: 4757149870448831729
  { 149436257, 62, 15917167179ULL },   // factor: 4757203770546018007
  { 149664019, 62, 15894357305ULL },   // factor: 4757626787376617591
  { 148019251, 62, 16103207429ULL },   // factor: 4767169404676431359
  { 149998619, 62, 15926039949ULL },   // factor: 4777767996977660863
  { 148775071, 62, 16059779516ULL },   // factor: 4778589675474491273
  { 148357481, 62, 16108192911ULL },   // factor: 4779541847476034383
  { 148979329, 62, 16045994055ULL },   // factor: 4781042854903778191
  { 149666057, 62, 15986805628ULL },   // factor: 4785364324736337593
  { 149343893, 62, 16028174331ULL },   // factor: 4787419904548421167
  { 149780821, 62, 15981439056ULL },   // factor: 4787426125138289953
  { 149374739, 62, 16046673660ULL },   // factor: 4793935379561349481
  { 148783391, 62, 16128057628ULL },   // factor: 4799174208274513097
  { 149333123, 62, 16070205073ULL },   // factor: 4799627821603065959
  { 148321517, 62, 16191458052ULL },   // factor: 4803083241429009769
  { 149619047, 62, 16063446397ULL },   // factor: 4806795082909447319
  { 148572143, 62, 16181813401ULL },   // factor: 4808333389225376687
  { 148451287, 62, 16206067637ULL },   // factor: 4811623195843397639
  { 149416103, 62, 16115345013ULL },   // factor: 4815784100685888679
  { 149401367, 62, 16126864173ULL },   // factor: 4818751105739048983
  { 148633361, 62, 16217563743ULL },   // factor: 4820942012707660447
  { 149888699, 62, 16096469152ULL },   // factor: 4825357639373826497
  { 149089379, 62, 16185268749ULL },   // factor: 4826103333473033743
  { 148676239, 62, 16236882905ULL },   // factor: 4828077366797588591
  { 149516287, 62, 16167169992ULL },   // factor: 4834510457003319409
  { 149800789, 62, 16154042975ULL },   // factor: 4839776766389814551
  { 148354249, 62, 16312336556ULL },   // factor: 4840008878401252889
  { 149555359, 62, 16208473385ULL },   // factor: 4848128111871240431
  { 148915043, 62, 16289445876ULL },   // factor: 4851487066141425337
  { 148851203, 62, 16330901913ULL },   // factor: 4861748791650102679
  { 148275679, 62, 16402986645ULL },   // factor: 4864327964830613911
  { 148096717, 62, 16440096332ULL },   // factor: 4869448587865884089
  { 149914801, 62, 16250145375ULL },   // factor: 4872274620228390751
  { 148336051, 62, 16450890060ULL },   // factor: 4880520133871106121
  { 149020429, 62, 16396518884ULL },   // factor: 4886832556400562473
  { 148992001, 62, 16414573008ULL },   // factor: 4891280156045018017
  { 149798039, 62, 16332206829ULL },   // factor: 4893065111053216663
  { 148992049, 62, 16423490219ULL },   // factor: 4893938918920537463
  { 149914277, 62, 16334614659ULL },   // factor: 4897583893355173087
  { 148324321, 62, 16527604419ULL },   // factor: 4902891406409548999
  { 149402587, 62, 16409710272ULL },   // factor: 4903306333114547329
  { 148092449, 62, 16581388279ULL },   // factor: 4911156796114010543
  { 148324639, 62, 16611078932ULL },   // factor: 4927664571978811097
  { 149593793, 62, 16474087296ULL },   // factor: 4928842409643507457
  { 149628443, 62, 16486232877ULL },   // factor: 4933618712641841023
  { 148991099, 62, 16560199020ULL },   // factor: 4934644503297045961
  { 149951209, 62, 16482842796ULL },   // factor: 4943244410034280729
  { 149110751, 62, 16579576476ULL },   // factor: 4944386199196586953
  { 149535137, 62, 16532922900ULL },   // factor: 4944505781723874601
  { 149658409, 62, 16527362172ULL },   // factor: 4946917455256608697
  { 149824957, 62, 16513942347ULL },   // factor: 4948401404079508159
  { 148676789, 62, 16667257324ULL },   // factor: 4956068600738105273
  { 149888119, 62, 16534197512ULL },   // factor: 4956559528496319857
  { 148516243, 62, 16697738717ULL },   // factor: 4959770841688960463
  { 148923427, 62, 16656573660ULL },   // factor: 4961108063050265641
  { 149037089, 62, 16649409652ULL },   // factor: 4962759096205166057
  { 148541963, 62, 16716332913ULL },   // factor: 4966153810117056439
  { 149985751, 62, 16555131561ULL },   // factor: 4966067680160774623
  { 148407269, 62, 16767850752ULL },   // factor: 4976941874207832577
  { 148059251, 62, 16817601916ULL },   // factor: 4980003086598249833
  { 149235091, 62, 16688943524ULL },   // factor: 4981152010996001369
  { 148954733, 62, 16751589775ULL },   // factor: 4990457164521310151
  { 149397901, 62, 16705510640ULL },   // factor: 4991536449498333281
  { 149205097, 62, 16738182300ULL },   // factor: 4994844227350366201
  { 148742467, 62, 16793882429ULL },   // factor: 4995927005994824687
  { 149160793, 62, 16754848172ULL },   // factor: 4998332879860240793
  { 149995631, 62, 16677966885ULL },   // factor: 5003244333425358871
  { 148735661, 62, 16856134879ULL },   // factor: 5014216726266440039
  { 149715491, 62, 16759831276ULL },   // factor: 5018412737126993033
  { 148313567, 62, 16952788380ULL },   // factor: 5028657030467902921
  { 148287829, 62, 16959000332ULL },   // factor: 5029626682485118457
  { 148917721, 62, 16892269860ULL },   // factor: 5031116660136378121
  { 149968727, 62, 16784645064ULL },   // factor: 5034343706789827057
  { 148615619, 62, 16981535280ULL },   // factor: 5047442754415076641
  { 148431823, 62, 17027991105ULL },   // factor: 5054991523485868831
  { 149082077, 62, 16963299048ULL },   // factor: 5057847709695925393
  { 149468951, 62, 16953325749ULL },   // factor: 5067991631328638599
  { 148784737, 62, 17039598875ULL },   // factor: 5070464474404741751
  { 148576361, 62, 17068949280ULL },   // factor: 5072084740231940161
  { 148923337, 62, 17043586784ULL },   // factor: 5076375636644756417
  { 149613473, 62, 16965273948ULL },   // factor: 5076467111513402809
  { 149654221, 62, 16969957395ULL },   // factor: 5079251508703828591
  { 149012821, 62, 17054797800ULL },   // factor: 5082767063525187601
  { 148239437, 62, 17170607152ULL },   // factor: 5090722274321306849
  { 149631863, 62, 17017073881ULL },   // factor: 5092592935245340607
  { 149464883, 62, 17052984040ULL },   // factor: 5097644528678934641
  { 149491777, 62, 17054911055ULL },   // factor: 5099137920377789471
  { 148642103, 62, 17169538632ULL },   // factor: 5104232659600446193
  { 149157769, 62, 17125565544ULL },   // factor: 5108822298812622673
  { 148855673, 62, 17166485583ULL },   // factor: 5110657529004524719
  { 148155377, 62, 17267890807ULL },   // factor: 5116661745011838479
  { 149168483, 62, 17151201505ULL },   // factor: 5116837420256333831
  { 148716767, 62, 17214204384ULL },   // factor: 5120081644931413057
  { 149516291, 62, 17122269021ULL },   // factor: 5120116315048242223
  { 148109369, 62, 17310037404ULL },   // factor: 5127557434545676153
  { 148358311, 62, 17282887440ULL },   // factor: 5128119979603027681
  { 149100533, 62, 17214569848ULL },   // factor: 5133403079405057969
  { 149967431, 62, 17114643228ULL },   // factor: 5133278154769414537
  { 148422199, 62, 17335198056ULL },   // factor: 5145856431144090289
  { 148080143, 62, 17402010592ULL },   // factor: 5153784433901749313
  { 149529343, 62, 17273929061ULL },   // factor: 5165918527039873847
  { 149804449, 62, 17271357540ULL },   // factor: 5174652399523390921
  { 149778529, 62, 17291738696ULL },   // factor: 5179862371478516369
  { 148133339, 62, 17498485792ULL },   // factor: 5184218255626038977
  { 148455887, 62, 17466559480ULL },   // factor: 5186027160883317521
  { 148753897, 62, 17454337403ULL },   // factor: 5192801416498218983
  { 149188157, 62, 17414529252ULL },   // factor: 5196083048256937129
  { 149182367, 62, 17431226005ULL },   // factor: 5200863110275707671
  { 149138867, 62, 17462554045ULL },   // factor: 5208691050395134031
  { 148402663, 62, 17552417028ULL },   // factor: 5209650858083491129
  { 148349951, 62, 17585344453ULL },   // factor: 5217569975841343607
  { 148434367, 62, 17579918312ULL },   // factor: 5218928093106857009
  { 149787997, 62, 17430893595ULL },   // factor: 5221877275030358431
  { 148505323, 62, 17586463308ULL },   // factor: 5223366827964376969
  { 149666983, 62, 17449990005ULL },   // factor: 5223374714857009831
  { 149751799, 62, 17458563705ULL },   // factor: 5228902645559710591
  { 149412539, 62, 17527267980ULL },   // factor: 5237587221250402441
  { 148397857, 62, 17648423499ULL },   // factor: 5237976453360083287
  { 149072083, 62, 17584545720ULL },   // factor: 5242729718178269521
  { 148449541, 62, 17662473191ULL },   // factor: 5243972076257510663
  { 148041827, 62, 17753344584ULL },   // factor: 5256475135151829937
  { 149612621, 62, 17574010923ULL },   // factor: 5258587671345318367
  { 149804813, 62, 17582467767ULL },   // factor: 5267876591827925143
  { 148783729, 62, 17740150160ULL },   // factor: 5278891387649493281
  { 149238769, 62, 17691959331ULL },   // factor: 5280652463513007079
  { 148500551, 62, 17795119209ULL },   // factor: 5285170015294368319
  { 149647733, 62, 17661781320ULL },   // factor: 5286091070559495121
  { 148680811, 62, 17779293684ULL },   // factor: 5286879607888595449
  { 149670481, 62, 17670031259ULL },   // factor: 5289364155639131159
  { 148779583, 62, 17788919553ULL },   // factor: 5293256066231772799
  { 148249889, 62, 17897179827ULL },   // factor: 5306509845531578407
  { 149397233, 62, 17766979896ULL },   // factor: 5308675270458055537
  { 149686561, 62, 17773204136ULL },   // factor: 5320819610137632593
  { 148415759, 62, 17938595356ULL },   // factor: 5324740490309230409
  { 148750363, 62, 17901370196ULL },   // factor: 5325670629704762297
  { 148551341, 62, 17964130063ULL },   // factor: 5337191221514128967
  { 149898193, 62, 17804795408ULL },   // factor: 5337813316787795489
  { 149131403, 62, 17898872973ULL },   // factor: 5338568077164542239
  { 149758747, 62, 17863095165ULL },   // factor: 5350309498904316511
  { 149753959, 62, 17899694012ULL },   // factor: 5361100086371187017
  { 149353549, 62, 17964796080ULL },   // factor: 5366212103218575841
  { 149911813, 62, 17914684812ULL },   // factor: 5371245758980968313
  { 148529981, 62, 18084677568ULL },   // factor: 5372233631132332417
  { 148625549, 62, 18078563847ULL },   // factor: 5373872953783854007
  { 148980901, 62, 18052032951ULL },   // factor: 5378816267843337703
  { 148031407, 62, 18190849029ULL },   // factor: 5385633952574907607
  { 149336849, 62, 18056616972ULL },   // factor: 5393036564396802457
  { 148129939, 62, 18241380692ULL },   // factor: 5404189218363475577
  { 148621457, 62, 18207365712ULL },   // factor: 5412010440498564769
  { 148149571, 62, 18305299956ULL },   // factor: 5423844671015437753
  { 148140077, 62, 18315166864ULL },   // factor: 5426420459001617057
  { 149665937, 62, 18168876244ULL },   // factor: 5438523774590601257
  { 149670713, 62, 18194253811ULL },   // factor: 5446293880790674487
  { 149129147, 62, 18274369725ULL },   // factor: 5450482338103749151
  { 149042741, 62, 18308232784ULL },   // factor: 5457418393986841889
  { 148845241, 62, 18336253164ULL },   // factor: 5458528042465185049
  { 148249177, 62, 18437421884ULL },   // factor: 5466665240609578937
  { 148744969, 62, 18406545012ULL },   // factor: 5475761934414089257
  { 149030183, 62, 18371958988ULL },   // factor: 5475952820100269609
  { 148354651, 62, 18459054920ULL },   // factor: 5476973300892865841
  { 148972337, 62, 18389712019ULL },   // factor: 5479116752454836807
  { 148174501, 62, 18493995596ULL },   // factor: 5480677137866995193
  { 148193719, 62, 18493160700ULL },   // factor: 5481140520395286601
  { 148436429, 62, 18471571080ULL },   // factor: 5483708098269746641
  { 149858663, 62, 18308631625ULL },   // factor: 5487414113364034751
  { 149772239, 62, 18327168481ULL },   // factor: 5489802115859197919
  { 148326083, 62, 18514640056ULL },   // factor: 5492408075322761297
  { 148185937, 62, 18546587952ULL },   // factor: 5496687027640062049
  { 148958141, 62, 18480003015ULL },   // factor: 5505493789577590231
  { 148273129, 62, 18592596215ULL },   // factor: 5513564834063213471
  { 149254757, 62, 18471867708ULL },   // factor: 5514028252187373913
  { 148186459, 62, 18608159297ULL },   // factor: 5514954469460718647
  { 148173437, 62, 18612337179ULL },   // factor: 5515707940830628447
  { 148681109, 62, 18562467679ULL },   // factor: 5519776560580752023
  { 148442647, 62, 18635142797ULL },   // factor: 5532499848019327319
  { 149935117, 62, 18459922283ULL },   // factor: 5535581214625024223
  { 148678381, 62, 18651001235ULL },   // factor: 5546001335297601071
  { 149466257, 62, 18571870687ULL },   // factor: 5551735994147817119
  { 148819469, 62, 18693991575ULL },   // factor: 5564059799363947351
  { 148599739, 62, 18753213116ULL },   // factor: 5573445148897953449
  { 148514371, 62, 18780139349ULL },   // factor: 5578241165418168959
  { 148600099, 62, 18773496764ULL },   // factor: 5579486955413159273
  { 148794029, 62, 18750086440ULL },   // factor: 5579801811011733521
  { 149179757, 62, 18706665624ULL },   // factor: 5581311664137146737
  { 149849041, 62, 18626000444ULL },   // factor: 5582176608397948409
  { 149104649, 62, 18743931240ULL },   // factor: 5589614576840669521
  { 149828093, 62, 18667410352ULL },   // factor: 5593804988577237473
  { 148484519, 62, 18861337857ULL },   // factor: 5601233358786271567
  { 148331221, 62, 18893368179ULL },   // factor: 5604952741587233119
  { 148612721, 62, 18900076368ULL },   // factor: 5617583552312554657
  { 148697873, 62, 18943482411ULL },   // factor: 5633711083457223607
  { 148812331, 62, 18932015001ULL },   // factor: 5634634565651554663
  { 149226149, 62, 18893961300ULL },   // factor: 5638946168308067401
  { 148142669, 62, 19047658339ULL },   // factor: 5643541889079133583
  { 148956377, 62, 18947498659ULL },   // factor: 5644701506913996887
  { 148925929, 62, 18995466659ULL },   // factor: 5657835037960202423
  { 149047711, 62, 19011926480ULL },   // factor: 5667368247088574561
  { 148431497, 62, 19110058479ULL },   // factor: 5673069175591026127
  { 149266133, 62, 19004375740ULL },   // factor: 5673419353577626841
  { 148538113, 62, 19123972215ULL },   // factor: 5681277491761060591
  { 149899661, 62, 18964879579ULL },   // factor: 5685658039595845439
  { 148754129, 62, 19120138371ULL },   // factor: 5688399059475167719
  { 149900053, 62, 18990681903ULL },   // factor: 5693408447531681719
  { 149600887, 62, 19033790124ULL },   // factor: 5694943771044479977
  { 149768483, 62, 19019658525ULL },   // factor: 5697090808934535151
  { 148744241, 62, 19152189603ULL },   // factor: 5697555811972652647
  { 148251821, 62, 19228149064ULL },   // factor: 5701216226394891089
  { 149112409, 62, 19126689116ULL },   // factor: 5704053380561680889
  { 148853773, 62, 19171816775ULL },   // factor: 5707594524446884151
  { 149255039, 62, 19132921717ULL },   // factor: 5711369954109563927
  { 149692937, 62, 19089061587ULL },   // factor: 5714995387063822039
  { 148719533, 62, 19216935111ULL },   // factor: 5715867230798446327
  { 149064623, 62, 19174177701ULL },   // factor: 5716383140669143447
  { 149316341, 62, 19189318128ULL },   // factor: 5730557538315859297
  { 149488861, 62, 19174879628ULL },   // factor: 5732861830803647417
  { 149688337, 62, 19160419979ULL },   // factor: 5736182805756169847
  { 149806739, 62, 19164642640ULL },   // factor: 5741985235997501921
  { 148429889, 62, 19347583804ULL },   // factor: 5743519432891835513
  { 148314701, 62, 19374808704ULL },   // factor: 5747137919731915009
  { 148229369, 62, 19422798427ULL },   // factor: 5758058310096805127
  { 149466073, 62, 19264965663ULL },   // factor: 5758917528256902799
  { 148246027, 62, 19425233129ULL },   // factor: 5759427269846056967
  { 149627551, 62, 19252306664ULL },   // factor: 5761350994470599729
  { 149678329, 62, 19262363960ULL },   // factor: 5766316900245245681
  { 149393779, 62, 19302022556ULL },   // factor: 5767204183968158249
  { 149983037, 62, 19278041295ULL },   // factor: 5782758361671025831
  { 149999141, 62, 19296324648ULL },   // factor: 5788864243314254737
  { 149494721, 62, 19392051823ULL },   // factor: 5798018753793852767
  { 149781659, 62, 19368743592ULL },   // factor: 5802165095910758257
  { 149082617, 62, 19466251372ULL },   // factor: 5804159395435201049
  { 148041701, 62, 19619695716ULL },   // factor: 5809066253798105833
  { 148721249, 62, 19540776780ULL },   // factor: 5812257458303596441
  { 149332279, 62, 19470239040ULL },   // factor: 5815070337035944321
  { 149168473, 62, 19524922895ULL },   // factor: 5825005867379778671
  { 148643141, 62, 19603698400ULL },   // factor: 5827910610785348801
  { 149453921, 62, 19506313036ULL },   // factor: 5830589934967228313
  { 149866901, 62, 19480265619ULL },   // factor: 5838894077952753439
  { 148901267, 62, 19633271032ULL },   // factor: 5846837864038395089
  { 149472539, 62, 19567883412ULL },   // factor: 5849722432895246137
  { 148719367, 62, 19671990017ULL },   // factor: 5851211805917118479
  { 149232163, 62, 19642404113ULL },   // factor: 5862556904606172839
  { 148316863, 62, 19764757485ULL },   // factor: 5862893656261939111
  { 149606731, 62, 19603351625ULL },   // factor: 5865586706519575751
  { 149734537, 62, 19619323644ULL },   // factor: 5875380684174985657
  { 149806861, 62, 19615903643ULL },   // factor: 5877193900872589247
  { 149522453, 62, 19681969176ULL },   // factor: 5885792622131817457
  { 149405017, 62, 19705874268ULL },   // factor: 5888312960020805113
  { 148456643, 62, 19835815261ULL },   // factor: 5889517089632457647
  { 149159201, 62, 19742721975ULL },   // factor: 5889617270712283951
  { 148008017, 62, 19904960880ULL },   // factor: 5892187576622749921
  { 148949039, 62, 19788137916ULL },   // factor: 5894848252375325449
  { 148764559, 62, 19820068301ULL },   // factor: 5897047440296288519
  { 149030771, 62, 19804752900ULL },   // factor: 5903035188302971801
  { 148748387, 62, 19866092208ULL },   // factor: 5910098343866536993
  { 149903651, 62, 19712806669ULL },   // factor: 5910043382280497039
  { 149287987, 62, 19813799333ULL },   // factor: 5915924434491025343
  { 149698981, 62, 19777138343ULL },   // factor: 5921234914086256967
  { 149006339, 62, 19896603816ULL },   // factor: 5929440186311179249
  { 148076567, 62, 20034061489ULL },   // factor: 5933150096716056527
  { 149614561, 62, 19830902636ULL },   // factor: 5933983584237765593
  { 148122523, 62, 20039940252ULL },   // factor: 5936733021790991593
  { 148383607, 62, 20018637948ULL },   // factor: 5940875411902636873
  { 149059321, 62, 19936729460ULL },   // factor: 5943510712536593321
  { 148655809, 62, 19996733715ULL },   // factor: 5945261255521800871
  { 149335717, 62, 19930173824ULL },   // factor: 5952573595883343617
  { 149168893, 62, 19954242975ULL },   // factor: 5953104670467553351
  { 148346027, 62, 20068904544ULL },   // factor: 5954284510689293377
  { 149731853, 62, 19882402167ULL },   // factor: 5954057837112250903
  { 148878071, 62, 20031874345ULL },   // factor: 5964613621995976991
  { 149527127, 62, 19945866084ULL },   // factor: 5964896102134521337
  { 149357683, 62, 20009298221ULL },   // factor: 5977084841489163887
  { 148535701, 62, 20129046404ULL },   // factor: 5979764036159338409
  { 148338961, 62, 20157884156ULL },   // factor: 5980399183318803833
  { 148228781, 62, 20208373428ULL },   // factor: 5990925118450462537
  { 148759921, 62, 20152060608ULL },   // factor: 5995637888066583937
  { 148907023, 62, 20134723716ULL },   // factor: 5996403534954114937
  { 149349359, 62, 20078034396ULL },   // factor: 5997283134045104329
  { 149870327, 62, 20008001808ULL },   // factor: 5997211547163102433
  { 148129561, 62, 20257841271ULL },   // factor: 6001570268561824063
  { 148060859, 62, 20270509576ULL },   // factor: 6002538120380571569
  { 149690897, 62, 20058750295ULL },   // factor: 6005224648715129231
  { 149639599, 62, 20068104276ULL },   // factor: 6005966153101650649
  { 148588241, 62, 20211627283ULL },   // factor: 6006420291457158407
  { 149220007, 62, 20171257808ULL },   // factor: 6019910462617129313
  { 148524637, 62, 20273085723ULL },   // factor: 6022105395756915103
  { 149500931, 62, 20142898984ULL },   // factor: 6022764302293908209
  { 149222351, 62, 20211772468ULL },   // factor: 6032096411104064537
  { 148083781, 62, 20409256580ULL },   // factor: 6044559763531057961
  { 148674179, 62, 20342350852ULL },   // factor: 6048764623702101017
  { 149329849, 62, 20261371767ULL },   // factor: 6051255172997946367
  { 148258601, 62, 20422481364ULL },   // factor: 6055617031950423529
  { 149035673, 62, 20323758367ULL },   // factor: 6057930012230451983
  { 148471423, 62, 20403425400ULL },   // factor: 6058651206424688401
  { 149202029, 62, 20311201456ULL },   // factor: 6060944937325908449
  { 149556133, 62, 20268415308ULL },   // factor: 6062531631004967929
  { 148750769, 62, 20402236791ULL },   // factor: 6069696823962684559
  { 148709107, 62, 20427846948ULL },   // factor: 6075613755139510873
  { 149432827, 62, 20339377817ULL },   // factor: 6078741453230797319
  { 149611901, 62, 20332265316ULL },   // factor: 6083897731126251433
  { 148246909, 62, 20523104496ULL },   // factor: 6084973609232005729
  { 149745133, 62, 20410787412ULL },   // factor: 6112832151289331593
  { 149911331, 62, 20396164525ULL },   // factor: 6115232342475465551
  { 149958301, 62, 20402622480ULL },   // factor: 6119085206090412961
  { 149040641, 62, 20557658071ULL },   // factor: 6127853072721327023
  { 148109851, 62, 20691764009ULL },   // factor: 6129308168600305319
  { 148868227, 62, 20593592057ULL },   // factor: 6131463074173745879
  { 148240423, 62, 20702982516ULL },   // factor: 6138037771066888537
  { 148992359, 62, 20603860252ULL },   // factor: 6139635486903628937
  { 148219901, 62, 20762499928ULL },   // factor: 6154831367681334257
  { 149584217, 62, 20591980044ULL },   // factor: 6160470422722731097
  { 149501831, 62, 20626615576ULL },   // factor: 6167433591890239313
  { 149370187, 62, 20656237925ULL },   // factor: 6170852243147483951
  { 149840503, 62, 20604216173ULL },   // factor: 6174692230566110039
  { 148817791, 62, 20755325264ULL },   // factor: 6177523314549943649
  { 149277253, 62, 20711715695ULL },   // factor: 6183576047733171671
  { 148072129, 62, 20895664232ULL },   // factor: 6188130979402779857
  { 149152153, 62, 20750221667ULL },   // factor: 6189880473720598103
  { 149204983, 62, 20774092080ULL },   // factor: 6199196111273669281
  { 148104893, 62, 20953635915ULL },   // factor: 6206672010304064191
  { 148395239, 62, 20918894677ULL },   // factor: 6208528750418485607
  { 148421579, 62, 20924137965ULL },   // factor: 6211187191958293471
  { 149853391, 62, 20745098016ULL },   // factor: 6217446568649944513
  { 148201129, 62, 21015496656ULL },   // factor: 6229040661829849249
  { 148748651, 62, 20956363621ULL },   // factor: 6234461636978450543
  { 148097767, 62, 21058784573ULL },   // factor: 6237517941990696983
  { 149191321, 62, 20907853028ULL },   // factor: 6238540425042339977
  { 148771351, 62, 20992439808ULL },   // factor: 6246147262044681217
  { 149538061, 62, 20904603819ULL },   // factor: 6252067842132909919
  { 149877109, 62, 20882593320ULL },   // factor: 6259645430448623761
  { 149724571, 62, 20911125401ULL },   // factor: 6261818559583855943
  { 148802287, 62, 21049486985ULL },   // factor: 6264423607089469391
  { 148153333, 62, 21181852403ULL },   // factor: 6276324065237018399
  { 148514953, 62, 21132976896ULL },   // factor: 6277126140919051777
  { 149499761, 62, 21015214911ULL },   // factor: 6283539213116272543
  { 149991557, 62, 20947623864ULL },   // factor: 6283933437623432497
  { 149514653, 62, 21076352047ULL },   // factor: 6302446925626089383
  { 149004329, 62, 21195152091ULL },   // factor: 6316338830744803879
  { 148398149, 62, 21294838855ULL },   // factor: 6320229338670558791
  { 149018087, 62, 21264328393ULL },   // factor: 6337539076929288383
  { 148598687, 62, 21330491880ULL },   // factor: 6339366172864323121
  { 148179587, 62, 21404335888ULL },   // factor: 6343371303786236513
  { 148482329, 62, 21366950095ULL },   // factor: 6345229027464742511
  { 149202223, 62, 21437181293ULL },   // factor: 6396950207539228679
  { 149181229, 62, 21470806676ULL },   // factor: 6406082655094169609
  { 149949389, 62, 21411921091ULL },   // factor: 6421408969823326799
  { 149502149, 62, 21533996599ULL },   // factor: 6438757536218382503
  { 148164397, 62, 21730356507ULL },   // factor: 6439330336909362559
  { 148455023, 62, 21741802668ULL },   // factor: 6455359630278802729
  { 149975789, 62, 21524140932ULL },   // factor: 6456200037647790697
  { 149755423, 62, 21558204900ULL },   // factor: 6456916187840345401
  { 149466299, 62, 21647163904ULL },   // factor: 6471042945154542593
  { 149527627, 62, 21643832469ULL },   // factor: 6472701816550242127
  { 149992769, 62, 21595962295ULL },   // factor: 6478476367693289711
  { 149384201, 62, 21690944844ULL },   // factor: 6480568928912019289
  { 148346117, 62, 21852245739ULL },   // factor: 6483391606220890927
  { 148544689, 62, 21823507316ULL },   // factor: 6483532214288889449
  { 148418887, 62, 21845420352ULL },   // factor: 6484545949381976449
  { 148768237, 62, 21812380479ULL },   // factor: 6489978777268091047
  { 149817737, 62, 21665861860ULL },   // factor: 6491860788039621641
  { 148974773, 62, 21803412231ULL },   // factor: 6496316775477297127
  { 148341577, 62, 21924445983ULL },   // factor: 6504613783939070383
  { 148043699, 62, 21975148705ULL },   // factor: 6506564600726519591
  { 149242309, 62, 21799409435ULL },   // factor: 6506788397831570831
  { 148886581, 62, 21862628403ULL },   // factor: 6510103989192320287
  { 148775741, 62, 21883054255ULL },   // factor: 6511335224261655911
  { 149564017, 62, 21771066884ULL },   // factor: 6512336435093426057
  { 148666831, 62, 21914056889ULL },   // factor: 6515786784082697519
  { 149749231, 62, 21781830185ULL },   // factor: 6523624639952675471
  { 149684663, 62, 21880829925ULL },   // factor: 6550449306967880551
  { 148774399, 62, 22017974364ULL },   // factor: 6551421806403014473
  { 149292761, 62, 21942512115ULL },   // factor: 6551716433848599031
  { 149929903, 62, 21854487092ULL },   // factor: 6553282259636624153
  { 149151689, 62, 21973601395ULL },   // factor: 6554799522954012311
  { 148036079, 62, 22145830980ULL },   // factor: 6556763968951854841
  { 148446503, 62, 22084709248ULL },   // factor: 6556795715274719489
  { 149890109, 62, 21898199407ULL },   // factor: 6564646992037930727
  { 149222767, 62, 22007472984ULL },   // factor: 6568032026700453457
  { 148276753, 62, 22203605403ULL },   // factor: 6584557028100192919
  { 148541339, 62, 22168026385ULL },   // factor: 6585736644430459031
  { 148906141, 62, 22202642960ULL },   // factor: 6612219766348834721
  { 149072927, 62, 22211505840ULL },   // factor: 6622268377292787361
  { 149448697, 62, 22167007872ULL },   // factor: 6625660885718285569
  { 149259293, 62, 22212610095ULL },   // factor: 6630876956928725671
  { 148418909, 62, 22366875139ULL },   // factor: 6639334411739206703
  { 149926291, 62, 22169532308ULL },   // factor: 6647591504286219257
  { 149875423, 62, 22186959141ULL },   // factor: 6650559772682183287
  { 149126473, 62, 22328993771ULL },   // factor: 6659688173416399367
  { 149963377, 62, 22229961083ULL },   // factor: 6667360069170514583
  { 149842699, 62, 22257227196ULL },   // factor: 6670165990609684009
  { 148741277, 62, 22457911912ULL },   // factor: 6680836993088783249
  { 149698993, 62, 22323744092ULL },   // factor: 6683684021124198713
  { 148425313, 62, 22535307872ULL },   // factor: 6689620248905927873
  { 148060097, 62, 22620758367ULL },   // factor: 6698463356063163199
  { 148978933, 62, 22482834980ULL },   // factor: 6698937532270952681
  { 148296581, 62, 22591438483ULL },   // factor: 6700466173801453247
  { 148880971, 62, 22509209336ULL },   // factor: 6702385884771890513
  { 149807299, 62, 22376916261ULL },   // factor: 6704450770019178079
  { 149090861, 62, 22491612451ULL },   // factor: 6706587731195820623
  { 149807789, 62, 22424689351ULL },   // factor: 6718786261370309879
  { 149005573, 62, 22553944812ULL },   // factor: 6721326940244874553
  { 148874017, 62, 22587836880ULL },   // factor: 6725484023332693921
  { 149793509, 62, 22449402664ULL },   // factor: 6725549599989015953
  { 149605067, 62, 22500320845ULL },   // factor: 6732324015075443231
  { 148798439, 62, 22644872200ULL },   // factor: 6739043269428991601
  { 148479907, 62, 22731345360ULL },   // factor: 6750296090075363041
  { 148922377, 62, 22673031843ULL },   // factor: 6753043591712501623
  { 148555373, 62, 22750871415ULL },   // factor: 6759528378260725591
  { 149070799, 62, 22683266624ULL },   // factor: 6762825359139425153
  { 148446349, 62, 22785943035ULL },   // factor: 6764980104135458431
  { 149703523, 62, 22603766577ULL },   // factor: 6767726979293101543
  { 148380979, 62, 22836755921ULL },   // factor: 6777080401484053319
  { 148329283, 62, 22852504085ULL },   // factor: 6779391091365242111
  { 149963357, 62, 22645904515ULL },   // factor: 6792111726741713711
  { 149474203, 62, 22730095077ULL },   // factor: 6795125691497597263
  { 149202671, 62, 22772708896ULL },   // factor: 6795497986377322433
  { 148557601, 62, 22918637096ULL },   // factor: 6809475490342733393
  { 148281929, 62, 22976321620ULL },   // factor: 6813946582276009961
  { 149272883, 62, 22827321837ULL },   // factor: 6815000283555692143
  { 149892293, 62, 22811062383ULL },   // factor: 6838404892707828439
  { 149673533, 62, 22859677543ULL },   // factor: 6842977402203138839
  { 148952753, 62, 22986007083ULL },   // factor: 6847658070980698999
  { 148398197, 62, 23096804775ULL },   // factor: 6855048370141981351
  { 149463427, 62, 22958824800ULL },   // factor: 6863009269001179201
  { 148046341, 62, 23194656960ULL },   // factor: 6867768187356366721
  { 148081333, 62, 23197435995ULL },   // factor: 6870214488643562671
  { 148810847, 62, 23110562572ULL },   // factor: 6878204781971636969
  { 148076711, 62, 23237945604ULL },   // factor: 6881997110874456889
  { 149492561, 62, 23038411816ULL },   // factor: 6888142367493001553
  { 149697557, 62, 23010691507ULL },   // factor: 6889288606957096799
  { 148038977, 62, 23294361012ULL },   // factor: 6896946748170329449
  { 148255909, 62, 23269349595ULL },   // factor: 6899637152091013711
  { 149070091, 62, 23149544361ULL },   // factor: 6901809369005613703
  { 148262963, 62, 23294460048ULL },   // factor: 6907411336403204449
  { 149988053, 62, 23026694667ULL },   // factor: 6907458200257626703
  { 149906401, 62, 23069450111ULL },   // factor: 6916516478378121023
  { 148277917, 62, 23327705403ULL },   // factor: 6917967131092971103
  { 149567233, 62, 23135446400ULL },   // factor: 6920609404535622401
  { 148850077, 62, 23278833779ULL },   // factor: 6930112400948701967
  { 148603823, 62, 23339965912ULL },   // factor: 6936816326425763153
  { 148692487, 62, 23334700173ULL },   // factor: 6939389204245400503
  { 149257769, 62, 23270243836ULL },   // factor: 6946529358094723769
  { 149085331, 62, 23305682904ULL },   // factor: 6949070899847762449
  { 149843647, 62, 23192892228ULL },   // factor: 6950615111842951033
  { 148592071, 62, 23407142816ULL },   // factor: 6956231654444423873
  { 149935817, 62, 23200041372ULL },   // factor: 6957034315089241849
  { 148327789, 62, 23470376879ULL },   // factor: 6962618218917581063
  { 148290281, 62, 23488527019ULL },   // factor: 6966240543847204679
  { 149376473, 62, 23355537532ULL },   // factor: 6977535643098569273
  { 149287001, 62, 23375452368ULL },   // factor: 6979302362074136737
  { 149007143, 62, 23434016068ULL },   // factor: 6983671566617547449
  { 148200649, 62, 23584785195ULL },   // factor: 6990560944849183111
  { 148252787, 62, 23613831412ULL },   // factor: 7001632637154290489
  { 148139053, 62, 23641230471ULL },   // factor: 7004378987457367927
  { 149120869, 62, 23503735896ULL },   // factor: 7009795043116027249
  { 148481831, 62, 23620922220ULL },   // factor: 7014555562268369641
  { 148894139, 62, 23557377196ULL },   // factor: 7015110789393308489
  { 148648763, 62, 23600405797ULL },   // factor: 7016342256044158223
  { 148783759, 62, 23579870856ULL },   // factor: 7016603645380455409
  { 148388659, 62, 23679543957ULL },   // factor: 7027551547021567327
  { 149759891, 62, 23482110969ULL },   // factor: 7033356758334688759
  { 149798029, 62, 23475451671ULL },   // factor: 7033152780401112919
  { 148517377, 62, 23710234848ULL },   // factor: 7042763775357907393
  { 149636083, 62, 23540166077ULL },   // factor: 7044916489863512783
  { 149195083, 62, 23612063393ULL },   // factor: 7045607515439793239
  { 149068177, 62, 23645640020ULL },   // factor: 7049624903559287081
  { 148013311, 62, 23826992796ULL },   // factor: 7053424189818215113
  { 148524911, 62, 23749818061ULL },   // factor: 7054879227552435143
  { 148948819, 62, 23690317305ULL },   // factor: 7057289568630025591
  { 149633203, 62, 23586220685ULL },   // factor: 7058563495522808111
  { 148025869, 62, 23844915987ULL },   // factor: 7059328820415335407
  { 149246351, 62, 23654093784ULL },   // factor: 7060574366947564369
  { 148212173, 62, 23849692491ULL },   // factor: 7069629498945785887
  { 148631983, 62, 23818320372ULL },   // factor: 7080328377239315353
  { 148425643, 62, 23875733757ULL },   // factor: 7087542269959061503
  { 149883859, 62, 23652270977ULL },   // factor: 7090187296292920487
  { 149424281, 62, 23734162191ULL },   // factor: 7092920241055119343
  { 149042209, 62, 23796636059ULL },   // factor: 7093406410004828663
  { 148622543, 62, 23869337896ULL },   // factor: 7095043395659579057
  { 148554299, 62, 23900239516ULL },   // factor: 7100966654462958569
  { 148942901, 62, 23837039724ULL },   // factor: 7100715695489598649
  { 148572383, 62, 23916803853ULL },   // factor: 7106753084367583399
  { 148754621, 62, 23946942579ULL },   // factor: 7124436734895815119
  { 148517779, 62, 24074355180ULL },   // factor: 7150939524381490441
  { 148045267, 62, 24154158153ULL },   // factor: 7151817585842223703
  { 148812799, 62, 24036874836ULL },   // factor: 7153989247115651929
  { 148893737, 62, 24061567732ULL },   // factor: 7165233475392188969
  { 149779759, 62, 23942246684ULL },   // factor: 7172127876496138313
  { 148395413, 62, 24177637795ULL },   // factor: 7175701091906868671
  { 149789569, 62, 23964576291ULL },   // factor: 7179287107793017159
  { 149416963, 62, 24026664672ULL },   // factor: 7179982532619262273
  { 148013111, 62, 24271295488ULL },   // factor: 7184939906358286337
  { 148913459, 62, 24234128821ULL },   // factor: 7217575897173403679
  { 149702011, 62, 24121435781ULL },   // factor: 7222054889246111183
  { 149716079, 62, 24142025565ULL },   // factor: 7228898813419119271
  { 149416541, 62, 24212332383ULL },   // factor: 7235445908420294407
  { 148252891, 62, 24415182773ULL },   // factor: 7239242860781293487
  { 148618091, 62, 24381921885ULL },   // factor: 7247189370919643071
  { 148588709, 62, 24434699967ULL },   // factor: 7261441045797745207
  { 148837043, 62, 24394484796ULL },   // factor: 7261605965090196457
  { 149166841, 62, 24411431315ULL },   // factor: 7282752187094051831
  { 149485789, 62, 24462838407ULL },   // factor: 7313693400899796247
  { 149390663, 62, 24484577592ULL },   // factor: 7315534559487646993
  { 148949279, 62, 24567127032ULL },   // factor: 7318511717035619857
  { 149105029, 62, 24544832499ULL },   // factor: 7319515923127074943
  { 148775509, 62, 24618326460ULL },   // factor: 7325208099629336281
  { 149361307, 62, 24521447048ULL },   // factor: 7325110761241143473
  { 148447493, 62, 24690152460ULL },   // factor: 7330382468949565561
  { 149324429, 62, 24551864196ULL },   // factor: 7332386203906488169
  { 149182801, 62, 24609279671ULL },   // factor: 7342562543824276943
  { 149830867, 62, 24515030409ULL },   // factor: 7346216521423669207
  { 149859803, 62, 24518649220ULL },   // factor: 7348719883870607321
  { 149552047, 62, 24580963037ULL },   // factor: 7352266678829373479
  { 149789093, 62, 24552378231ULL },   // factor: 7355356932428868967
  { 148016221, 62, 24850086015ULL },   // factor: 7356431646930498631
  { 149498303, 62, 24640882201ULL },   // factor: 7367540146944809807
  { 148275469, 62, 24929827376ULL },   // factor: 7392963692530878689
  { 149457709, 62, 24825566259ULL },   // factor: 7420744515395681263
  { 148717979, 62, 24975302056ULL },   // factor: 7428552893365729649
  { 148534261, 62, 25024450844ULL },   // factor: 7433976626088732569
  { 149974717, 62, 24868471023ULL },   // factor: 7459283807794250983
  { 149172293, 62, 25007482168ULL },   // factor: 7460846914314342449
  { 148150141, 62, 25191638759ULL },   // factor: 7464289668333830039
  { 149587517, 62, 24964660683ULL },   // factor: 7468803208634988223
  { 149483671, 62, 25013759736ULL },   // factor: 7478297261698541713
  { 149379743, 62, 25080721248ULL },   // factor: 7493103388561758529
  { 149262349, 62, 25115382467ULL },   // factor: 7497561966115669967
  { 149022637, 62, 25177655508ULL },   // factor: 7504081234559469193
  { 149680541, 62, 25079253895ULL },   // factor: 7507752581759914391
  { 148566617, 62, 25329000547ULL },   // factor: 7526087846517878999
  { 148033163, 62, 25421305341ULL },   // factor: 7526392474434047167
  { 149845979, 62, 25135393141ULL },   // factor: 7532875185526060079
  { 148975037, 62, 25305028707ULL },   // factor: 7539635175822774319
  { 149583607, 62, 25264591769ULL },   // factor: 7558337532379061567
  { 148497359, 62, 25470703401ULL },   // factor: 7564664373841635919
  { 148893109, 62, 25413919775ULL },   // factor: 7567915054352660951
  { 149388781, 62, 25350406808ULL },   // factor: 7574132741802442097
  { 148967717, 62, 25493266407ULL },   // factor: 7595347391047165639
  { 148449599, 62, 25645226257ULL },   // factor: 7614047108231841887
  { 148436599, 62, 25654921976ULL },   // factor: 7616258731455599249
  { 149760181, 62, 25443483663ULL },   // factor: 7620841437282846007
  { 148606811, 62, 25645805640ULL },   // factor: 7622282783372428081
  { 148055107, 62, 25749532728ULL },   // factor: 7624699646488083793
  { 148706501, 62, 25727920776ULL },   // factor: 7651818153208329553
  { 149714419, 62, 25568897789ULL },   // factor: 7656065353901039183
  { 148845989, 62, 25786622671ULL },   // factor: 7676470708869633239
  { 148568113, 62, 25847472132ULL },   // factor: 7680220320942653833
  { 148673593, 62, 25839856472ULL },   // factor: 7683408608593087793
  { 149313733, 62, 25737923955ULL },   // factor: 7686051010782348031
  { 149922889, 62, 25648870175ULL },   // factor: 7690705432443871151
  { 148255771, 62, 25938137073ULL },   // factor: 7690957020122596567
  { 148206727, 62, 25968900549ULL },   // factor: 7697531508311586247
  { 148505563, 62, 25921453196ULL },   // factor: 7698960001300258697
  { 149733277, 62, 25722549635ULL },   // factor: 7703043299287407791
  { 149674397, 62, 25737527679ULL },   // factor: 7704497871250269127
  { 149822383, 62, 25724792768ULL },   // factor: 7708299509365852289
  { 149274947, 62, 25823232984ULL },   // factor: 7709523470110503697
  { 148643029, 62, 25933163664ULL },   // factor: 7709567997139396513
  { 148136717, 62, 26034785244ULL },   // factor: 7713415227692407897
  { 149727251, 62, 25757850933ULL },   // factor: 7713304423731750367
  { 148565177, 62, 25979951040ULL },   // factor: 7719432049417868161
  { 149729533, 62, 25810289396ULL },   // factor: 7729125155715864137
  { 149689741, 62, 25822223619ULL },   // factor: 7730643931144385359
  { 149051159, 62, 25948680972ULL },   // factor: 7735361946795693097
  { 148071211, 62, 26140836513ULL },   // factor: 7741410638065854487
  { 148939849, 62, 25993001051ULL },   // factor: 7742787303185562599
  { 149605147, 62, 25887811005ULL },   // factor: 7745899541822485471
  { 148073789, 62, 26158996960ULL },   // factor: 7746923592613362881
  { 148296943, 62, 26127389340ULL },   // factor: 7749223935385575241
  { 149503499, 62, 25950319305ULL },   // factor: 7759327072529496391
  { 149462297, 62, 26063839759ULL },   // factor: 7791122718040132847
  { 149661563, 62, 26038439536ULL },   // factor: 7793907118077509537
  { 148881259, 62, 26200655040ULL },   // factor: 7801573017959790721
  { 149383979, 62, 26135720860ULL },   // factor: 7808515952200203881
  { 148846757, 62, 26232734832ULL },   // factor: 7809315013968279649
  { 148246627, 62, 26339866589ULL },   // factor: 7809592754898490607
  { 148173373, 62, 26391124383ULL },   // factor: 7820923834183307719
  { 149085943, 62, 26255733185ULL },   // factor: 7828721482084236911
  { 149801711, 62, 26149695361ULL },   // factor: 7834538214413125343
  { 148892083, 62, 26313587972ULL },   // factor: 7835769848709651353
  { 149591059, 62, 26196084216ULL },   // factor: 7837399959049249489
  { 149217671, 62, 26267276484ULL },   // factor: 7839083640911097529
  { 149646353, 62, 26245826568ULL },   // factor: 7855184454743413009
  { 149457653, 62, 26308837860ULL },   // factor: 7864114319426285161
  { 149347469, 62, 26373035980ULL },   // factor: 7877492346917869241
  { 149156131, 62, 26431187349ULL },   // factor: 7884747285425973439
  { 149915999, 62, 26335092156ULL },   // factor: 7896103298647607689
  { 148870609, 62, 26598728799ULL },   // factor: 7919537909865937183
  { 149442479, 62, 26505578340ULL },   // factor: 7922118668916609721
  { 148005059, 62, 26766252849ULL },   // factor: 7923081664250326183
  { 149779039, 62, 26483165112ULL },   // factor: 7933246040307374737
  { 148940579, 62, 26637841465ULL },   // factor: 7934911062214616471
  { 148706213, 62, 26691665292ULL },   // factor: 7938432928473718393
  { 148937177, 62, 26651946708ULL },   // factor: 7938931408487926633
  { 149117113, 62, 26637703587ULL },   // factor: 7944274911686368663
  { 148910413, 62, 26694164291ULL },   // factor: 7950078058525324367
  { 149519473, 62, 26589773463ULL },   // factor: 7951377830754289999
  { 148237729, 62, 26836077131ULL },   // factor: 7956238258336550999
  { 149670403, 62, 26579426781ULL },   // factor: 7956307035642525487
  { 149448653, 62, 26625322263ULL },   // factor: 7958237095792523479
  { 149955539, 62, 26578743220ULL },   // factor: 7971259530995391161
  { 148843907, 62, 26792293320ULL },   // factor: 7975739230477602481
  { 149809567, 62, 26638741053ULL },   // factor: 7981476525150108103
  { 148504667, 62, 26939569489ULL },   // factor: 8001303592174610327
  { 148780693, 62, 26901232127ULL },   // factor: 8004767916817848023
  { 149898779, 62, 26702026117ULL },   // factor: 8005202223528822287
  { 149003219, 62, 26907593452ULL },   // factor: 8018636079782643977
  { 149804903, 62, 26775147160ULL },   // factor: 8022096646229050961
  { 148270567, 62, 27076879673ULL },   // factor: 8029408603412969183
  { 148043923, 62, 27120333245ULL },   // factor: 8030001053314240271
  { 149569591, 62, 26916472748ULL },   // factor: 8051771640162012137
  { 148880497, 62, 27099234795ULL },   // factor: 8069095089198586231
  { 148450693, 62, 27242983836ULL },   // factor: 8088479659683996697
  { 148426961, 62, 27253251075ULL },   // factor: 8090234468864466151
  { 149395637, 62, 27113269660ULL },   // factor: 8101208384016946841
  { 149348999, 62, 27130783492ULL },   // factor: 8103910713231849017
  { 149801411, 62, 27113722909ULL },   // factor: 8123347898462449199
  { 149901889, 62, 27115014060ULL },   // factor: 8129183655711118681
  { 148985857, 62, 27293525612ULL },   // factor: 8132698607710538969
  { 149590759, 62, 27199690496ULL },   // factor: 8137644691723452929
  { 148221287, 62, 27454599429ULL },   // factor: 8138712122871690247
  { 148325521, 62, 27441759419ULL },   // factor: 8140626525959664599
  { 149629031, 62, 27245862304ULL },   // factor: 8153543950613894849
  { 149922679, 62, 27229805177ULL },   // factor: 8164730681567818367
  { 149657897, 62, 27282476292ULL },   // factor: 8166076053626155849
  { 149740429, 62, 27297805256ULL },   // factor: 8175170139583789649
  { 149920657, 62, 27272361975ULL },   // factor: 8177380850467635151
  { 149309243, 62, 27395742633ULL },   // factor: 8180875187912113639
  { 148039273, 62, 27675189956ULL },   // factor: 8194030002446283977
  { 148170857, 62, 27710080560ULL },   // factor: 8211652768228479841
  { 149824033, 62, 27403806956ULL },   // factor: 8211497755402747097
  { 149969549, 62, 27402702516ULL },   // factor: 8219141875411370569
  { 148773463, 62, 27668107473ULL },   // factor: 8232560326828777999
  { 149209259, 62, 27661917516ULL },   // factor: 8254828430162961289
  { 149695853, 62, 27577935307ULL },   // factor: 8256605099520363743
  { 148359947, 62, 27839204320ULL },   // factor: 8260445754874742081
  { 148416739, 62, 27841870749ULL },   // factor: 8264399328452135023
  { 149549761, 62, 27640348199ULL },   // factor: 8267214934234460879
  { 149614067, 62, 27641463393ULL },   // factor: 8271103512116698663
  { 149082851, 62, 27843694281ULL },   // factor: 8302034651567750263
  { 148710691, 62, 27938239404ULL },   // factor: 8309429774184536329
  { 148217281, 62, 28067360211ULL },   // factor: 8320135630644012583
  { 148429049, 62, 28060767892ULL },   // factor: 8330066184838589417
  { 149859893, 62, 27810414883ULL },   // factor: 8335331597303975039
  { 149052769, 62, 27977473032ULL },   // factor: 8340239650084851217
  { 148984259, 62, 28005735612ULL },   // factor: 8344827535807463017
  { 148767257, 62, 28066940479ULL },   // factor: 8350883494886192207
  { 149335843, 62, 27986969432ULL },   // factor: 8358915346285902353
  { 149413301, 62, 27998868468ULL },   // factor: 8366806724137385737
  { 148377773, 62, 28343014675ULL },   // factor: 8410946795165637551
  { 149946371, 62, 28047252556ULL },   // factor: 8411167474585348553
  { 148259003, 62, 28402325988ULL },   // factor: 8421801067723739929
  { 149039509, 62, 28252829411ULL },   // factor: 8421575646552398399
  { 148823267, 62, 28324375777ULL },   // factor: 8430652277737606919
  { 148093739, 62, 28487569876ULL },   // factor: 8437661475921212729
  { 148925603, 62, 28344510768ULL },   // factor: 8442446715728786209
  { 149011883, 62, 28335360180ULL },   // factor: 8444610751810037881
  { 148085761, 62, 28528679928ULL },   // factor: 8449382554926610417
  { 148843351, 62, 28385771525ULL },   // factor: 8450066709002760551
  { 149427137, 62, 28313954059ULL },   // factor: 8461746184371798167
  { 149598103, 62, 28292715948ULL },   // factor: 8465073269077293289
  { 148638869, 62, 28529767980ULL },   // factor: 8481264890759229241
  { 149735461, 62, 28340633711ULL },   // factor: 8487195707497451543
  { 149017243, 62, 28525406253ULL },   // factor: 8501554790554040959
  { 149351009, 62, 28499228739ULL },   // factor: 8512777135782895303
  { 149015749, 62, 28576243635ULL },   // factor: 8516620697752015231
  { 148335709, 62, 28761431384ULL },   // factor: 8532694632400982513
  { 149155441, 62, 28639167639ULL },   // factor: 8543375358135947599
  { 148168217, 62, 28842771472ULL },   // factor: 8547164044689410849
  { 148443733, 62, 28800091727ULL },   // factor: 8550386253396593783
  { 149553407, 62, 28605105253ULL },   // factor: 8555981896359493943
  { 148514453, 62, 28848635191ULL },   // factor: 8568878550375831047
  { 148225817, 62, 28919796000ULL },   // factor: 8573320779146664001
  { 149918917, 62, 28599903764ULL },   // factor: 8575333197206207177
  { 149832197, 62, 28656815703ULL },   // factor: 8587427311609178983
  { 149768587, 62, 28671528504ULL },   // factor: 8588188622348607697
  { 148873547, 62, 28858889988ULL },   // factor: 8592650629992694873
  { 149699761, 62, 28703637404ULL },   // factor: 8593855318418920889
  { 148787057, 62, 28893750900ULL },   // factor: 8598032324204202601
  { 148280359, 62, 29004070160ULL },   // factor: 8601467871571974881
  { 149260093, 62, 28818454076ULL },   // factor: 8602890270999978137
  { 148790911, 62, 28969505628ULL },   // factor: 8620798267219494217
  { 148801039, 62, 29015823816ULL },   // factor: 8635169462523489649
  { 148981069, 62, 28986791252ULL },   // factor: 8636966295205616777
  { 148165019, 62, 29167245601ULL },   // factor: 8643130997299662839
  { 149818931, 62, 28861651968ULL },   // factor: 8648043689479612417
  { 148331609, 62, 29217131859ULL },   // factor: 8667648358021262263
  { 148548461, 62, 29173527711ULL },   // factor: 8667365286819805543
  { 149035811, 62, 29096775169ULL },   // factor: 8672922969593154119
  { 149973853, 62, 28923070212ULL },   // factor: 8675408560566333673
  { 148661687, 62, 29219114764ULL },   // factor: 8687525786925693737
  { 149822137, 62, 28993720784ULL },   // factor: 8687802414880390817
  { 149403451, 62, 29112420861ULL },   // factor: 8698992287195582623
  { 149497223, 62, 29098618977ULL },   // factor: 8700325460393201743
  { 149916293, 62, 29047329087ULL },   // factor: 8709335796548228983
  { 148015969, 62, 29440911660ULL },   // factor: 8715450135196597081
  { 149684149, 62, 29123974047ULL },   // factor: 8718794541446562007
  { 148980113, 62, 29282857515ULL },   // factor: 8725126843095198391
  { 149225389, 62, 29279940672ULL },   // factor: 8738621073352242817
  { 148244051, 62, 29511946224ULL },   // factor: 8749940922279826849
  { 148050401, 62, 29616464184ULL },   // factor: 8769458797286675569
  { 148836211, 62, 29475330653ULL },   // factor: 8773993064729351567
  { 148405919, 62, 29563551216ULL },   // factor: 8774811974228095009
  { 148545049, 62, 29541346752ULL },   // factor: 8776441601603661697
  { 148864787, 62, 29497323172ULL },   // factor: 8782225462139888729
  { 148850729, 62, 29522408799ULL },   // factor: 8788864143134328943
  { 148956607, 62, 29508038813ULL },   // factor: 8790834681617574983
  { 149595353, 62, 29418290016ULL },   // factor: 8801678959199791297
  { 148133963, 62, 29721882300ULL },   // factor: 8805640425837109801
  { 148753697, 62, 29612579827ULL },   // factor: 8809961453947740839
  { 148551617, 62, 29658206308ULL },   // factor: 8811549008746000073
  { 148433731, 62, 29723549364ULL },   // factor: 8823954661322394169
  { 148798219, 62, 29668397976ULL },   // factor: 8829209558824009489
  { 149776889, 62, 29481376791ULL },   // factor: 8831257798385566399
  { 148687531, 62, 29723601668ULL },   // factor: 8839057888884803417
  { 149120047, 62, 29682304853ULL },   // factor: 8852453389495376183
  { 148790617, 62, 29799773684ULL },   // factor: 8867853425805446057
  { 149232949, 62, 29761233696ULL },   // factor: 8882713340664499009
  { 148762463, 62, 29925659085ULL },   // factor: 8903629504765852711
  { 149207501, 62, 29838206544ULL },   // factor: 8904168465504173089
  { 149853467, 62, 29772321069ULL },   // factor: 8922971065653592447
  { 149850721, 62, 29844817548ULL },   // factor: 8944534855362504217
  { 149484007, 62, 29920801848ULL },   // factor: 8945362705784089873
  { 149145341, 62, 30015683280ULL },   // factor: 8953398636287196961
  { 149958239, 62, 29853761925ULL },   // factor: 8953635131596500151
  { 149370821, 62, 29987894404ULL },   // factor: 8958632814373571369
  { 148325431, 62, 30216359148ULL },   // factor: 8963708987755785577
  { 148659347, 62, 30152687253ULL },   // factor: 8964957594652407583
  { 149684699, 62, 29957921317ULL },   // factor: 8968484870001657167
  { 149230181, 62, 30067925175ULL },   // factor: 8974083832319413351
  { 149017409, 62, 30160512015ULL },   // factor: 8988882709177338271
  { 149182883, 62, 30129743968ULL },   // factor: 8989684138396199489
  { 149031221, 62, 30169228383ULL },   // factor: 8992313885092691287
  { 148537001, 62, 30299610544ULL },   // factor: 9001226563347477089
  { 149932429, 62, 30061059956ULL },   // factor: 9014255475035426249
  { 148953349, 62, 30301361075ULL },   // factor: 9026978422758980351
  { 149564749, 62, 30191639616ULL },   // factor: 9031210002130992769
  { 148867981, 62, 30333595551ULL },   // factor: 9031402252295905063
  { 148336907, 62, 30490191408ULL },   // factor: 9045641374601390113
  { 149225491, 62, 30332229888ULL },   // factor: 9052683796323350017
  { 148988303, 62, 30396453720ULL },   // factor: 9057432113921674321
  { 148685263, 62, 30485678960ULL },   // factor: 9065542387802332961
  { 149465273, 62, 30403620891ULL },   // factor: 9088570993323636487
  { 148192831, 62, 30683208488ULL },   // factor: 9094063059999899057
  { 149987153, 62, 30331184472ULL },   // factor: 9098576012146176433
  { 149470963, 62, 30447454185ULL },   // factor: 9102020595860660311
  { 148402637, 62, 30685135948ULL },   // factor: 9107510182773389753
  { 149398619, 62, 30496332652ULL },   // factor: 9112219965546815177
  { 149733973, 62, 30446874960ULL },   // factor: 9117863106390032161
  { 149338967, 62, 30550460820ULL },   // factor: 9124748520465545881
  { 148749551, 62, 30697664644ULL },   // factor: 9132527665087149689
  { 149817659, 62, 30477678232ULL },   // factor: 9132188808946997777
  { 148358449, 62, 30862826736ULL },   // factor: 9157522212617384929
  { 149378851, 62, 30661993773ULL },   // factor: 9160506798359789647
  { 149200801, 62, 30717729224ULL },   // factor: 9166219610243816849
  { 148152401, 62, 30941995680ULL },   // factor: 9168261903447255361
  { 148597991, 62, 30870823153ULL },   // factor: 9174684602104171247
  { 148769237, 62, 30835939275ULL },   // factor: 9174878316240166351
  { 149506711, 62, 30688378016ULL },   // factor: 9176236926193730753
  { 149714857, 62, 30649229987ULL },   // factor: 9177290169327633719
  { 149574301, 62, 30718002171ULL },   // factor: 9189247405687614943
  { 149756419, 62, 30692091852ULL },   // factor: 9192675534749195977
  { 149142677, 62, 30826198768ULL },   // factor: 9195003611987243873
  { 149396239, 62, 30831273192ULL },   // factor: 9212152516932649777
  { 149575147, 62, 30797894624ULL },   // factor: 9213199231350619457
  { 149034707, 62, 30934763988ULL },   // factor: 9220706974131463033
  { 149235631, 62, 30898592445ULL },   // factor: 9222341881082815591
  { 149969363, 63, 30767699140ULL },   // factor: 9228424482002895641
  { 149514647, 63, 30878633377ULL },   // factor: 9233615938409145839
  { 148620739, 63, 31086763637ULL },   // factor: 9240275569698535487
  { 149139733, 63, 31064539931ULL },   // factor: 9265914382154356847
  { 148742687, 63, 31150404232ULL },   // factor: 9266789653207702769
  { 149692951, 63, 30954138408ULL },   // factor: 9267232647911924017
  { 148015037, 63, 31334130883ULL },   // factor: 9275845084020175343
  { 149653501, 63, 30992739356ULL },   // factor: 9276343900411770713
  { 149863243, 63, 30958396997ULL },   // factor: 9279051544103762543
  { 148089307, 63, 31338950709ULL },   // factor: 9281926985205937327
  { 149471627, 63, 31048528168ULL },   // factor: 9281748042452578673
  { 148197703, 63, 31321677701ULL },   // factor: 9283601378789041607
  { 149087377, 63, 31147660667ULL },   // factor: 9287446057058200919
  { 148244623, 63, 31350181548ULL },   // factor: 9294991689129632809
  { 148175387, 63, 31388318793ULL },   // factor: 9301952568864295783
  { 149043127, 63, 31215165684ULL },   // factor: 9304811806732907737
  { 148511911, 63, 31353154533ULL },   // factor: 9312633791148285127
  { 149308723, 63, 31191649296ULL },   // factor: 9314370649299218017
  { 149858609, 63, 31091149356ULL },   // factor: 9318552789402811609
  { 149810929, 63, 31124525519ULL },   // factor: 9325588165371194303
  { 149163437, 63, 31307565415ULL },   // factor: 9339888122807462711
  { 149893039, 63, 31157081937ULL },   // factor: 9340459395817873087
  { 148630247, 63, 31468461972ULL },   // factor: 9354330551216934169
  { 148485721, 63, 31546975980ULL },   // factor: 9368550947519963161
  { 148376399, 63, 31597235989ULL },   // factor: 9376568188802047223
  { 149069671, 63, 31491485480ULL },   // factor: 9388850759609754161
  { 148330111, 63, 31691177364ULL },   // factor: 9401511712245614809
  { 148956739, 63, 31558101941ULL },   // factor: 9401583908321860799
  { 149347171, 63, 31478886653ULL },   // factor: 9402565335710417327
  { 148709657, 63, 31644797884ULL },   // factor: 9411774078327931577
  { 149170891, 63, 31633415109ULL },   // factor: 9437569434364784239
  { 149436173, 63, 31584868243ULL },   // factor: 9439843669886308079
  { 149851337, 63, 31515798588ULL },   // factor: 9445369110069024313
  { 148073531, 63, 31895294908ULL },   // factor: 9445697878627760297
  { 148373921, 63, 31836278388ULL },   // factor: 9447346908950238697
  { 148980563, 63, 31734839532ULL },   // factor: 9455748520384033033
  { 148472741, 63, 31852544311ULL },   // factor: 9458469123356252903
  { 148930039, 63, 31817417865ULL },   // factor: 9477138567027493471
  { 148655933, 63, 31894347508ULL },   // factor: 9482567972455929929
  { 149767873, 63, 31660753827ULL },   // factor: 9483527516492799943
  { 149232029, 63, 31873516564ULL },   // factor: 9513099096421656713
  { 148299061, 63, 32074751576ULL },   // factor: 9513311081058140273
  { 148906427, 63, 32022927124ULL },   // factor: 9536839320232451897
  { 149731411, 63, 31874020193ULL },   // factor: 9545084035480764647
  { 149797343, 63, 31870618996ULL },   // factor: 9548268090732255257
  { 148883653, 63, 32066933928ULL },   // factor: 9548484527420557969
  { 149429503, 63, 31973517045ULL },   // factor: 9555573522392757271
  { 149063311, 63, 32089157460ULL },   // factor: 9566632116375900121
  { 149138057, 63, 32097367207ULL },   // factor: 9573877960134993599
  { 148048657, 63, 32344036947ULL },   // factor: 9576982463923460359
  { 149678101, 63, 32263357580ULL },   // factor: 9658236188916711161
  { 148821263, 63, 32538257437ULL },   // factor: 9684769135186965863
  { 148214071, 63, 32675398736ULL },   // factor: 9685907736421628513
  { 148663937, 63, 32643265980ULL },   // factor: 9705752874249926521
  { 148516931, 63, 32707946544ULL },   // factor: 9715367680053872929
  { 149175361, 63, 32575050816ULL },   // factor: 9718789930140289153
  { 149037439, 63, 32638033544ULL },   // factor: 9728577866787707633
  { 149457559, 63, 32569755812ULL },   // factor: 9735592401775165817
  { 148430237, 63, 32800841152ULL },   // factor: 9737273251981426049
  { 149572331, 63, 32644797949ULL },   // factor: 9765517048511898239
  { 148108073, 63, 33089629740ULL },   // factor: 9801682594149782041
  { 149084627, 63, 32873702920ULL },   // factor: 9801927475874021681
  { 148514173, 63, 33025515983ULL },   // factor: 9809514388227054119
  { 148139653, 63, 33203444871ULL },   // factor: 9837493603189139527
  { 148776851, 63, 33077772741ULL },   // factor: 9842413732999237183
  { 148292029, 63, 33186831815ULL },   // factor: 9842685251856205271
  { 149955523, 63, 32829710805ULL },   // factor: 9845992907405052031
  { 149467663, 63, 33014256212ULL },   // factor: 9869127443381745113
  { 149893903, 63, 32932900992ULL },   // factor: 9872882133606903553
  { 148313927, 63, 33323496393ULL },   // factor: 9884677222832330623
  { 149886731, 63, 32984577816ULL },   // factor: 9887901084510718993
  { 148529021, 63, 33361063323ULL },   // factor: 9910172149768393567
  { 148048609, 63, 33478161035ULL },   // factor: 9912790346219500631
  { 148376251, 63, 33422113601ULL },   // factor: 9918095833224979703
  { 149212001, 63, 33292795255ULL },   // factor: 9935369197763710511
  { 148469423, 63, 33499332273ULL },   // factor: 9947253066915176959
  { 149604683, 63, 33243880281ULL },   // factor: 9946880342257911847
  { 149360293, 63, 33371365371ULL },   // factor: 9968713819245227407
  { 149790877, 63, 33280289943ULL },   // factor: 9970167634752500023
  { 149869189, 63, 33365435507ULL },   // factor: 10000901520131787647
  { 148743241, 63, 33622506951ULL },   // factor: 10002241308873536383
  { 148135447, 63, 33772514313ULL },   // factor: 10005813008140305823
  { 148244141, 63, 33767537563ULL },   // factor: 10011679199424336767
  { 149070287, 63, 33580343128ULL },   // factor: 10011662775298875473
  { 148165631, 63, 33909206181ULL },   // factor: 10048357861033930423
  { 148122097, 63, 33924849647ULL },   // factor: 10050039740246699519
  { 149585563, 63, 33618342281ULL },   // factor: 10057637314460178407
  { 149682751, 63, 33634031801ULL },   // factor: 10068868814390329103
  { 148879177, 63, 33883295319ULL },   // factor: 10089034242281344927
  { 149758093, 63, 33712660803ULL },   // factor: 10097487583626257359
  { 149915989, 63, 33675282915ULL },   // factor: 10096926686114055871
  { 149356579, 63, 33808325241ULL },   // factor: 10098991599430221079
  { 148974869, 63, 33930075375ULL },   // factor: 10109457068301501751
  { 149074657, 63, 33906870179ULL },   // factor: 10109310083755907207
  { 148323353, 63, 34095824692ULL },   // factor: 10114414083235264553
  { 148044769, 63, 34165789004ULL },   // factor: 10116132681599840153
  { 148721527, 63, 34038512825ULL },   // factor: 10124519208286167551
  { 148105957, 63, 34202816100ULL },   // factor: 10131281621171015401
  { 149956613, 63, 33880014595ULL },   // factor: 10161064474113533471
  { 149539963, 63, 34046986872ULL },   // factor: 10182770314200731473
  { 148825087, 63, 34245514092ULL },   // factor: 10193183228203252009
  { 148333681, 63, 34378637268ULL },   // factor: 10199019627452447017
  { 148845383, 63, 34327514788ULL },   // factor: 10218984172116047609
  { 149901049, 63, 34116720144ULL },   // factor: 10228264276050062113
  { 149074609, 63, 34326009276ULL },   // factor: 10234272822700146169
  { 148224421, 63, 34542841299ULL },   // factor: 10240185302478325759
  { 148202573, 63, 34577141131ULL },   // factor: 10248842565196660127
  { 149616751, 63, 34291882185ULL },   // factor: 10261279996388961871
  { 149346811, 63, 34356621801ULL },   // factor: 10262103805424853223
  { 149634931, 63, 34328601980ULL },   // factor: 10273515977207526761
  { 149608969, 63, 34349455679ULL },   // factor: 10277973299692769903
  { 148515167, 63, 34651499869ULL },   // factor: 10292546579690026247
  { 149538869, 63, 34423820512ULL },   // factor: 10295398372046961857
  { 149791093, 63, 34385100360ULL },   // factor: 10301163531678186961
  { 148539109, 63, 34687857111ULL },   // factor: 10305006776774508199
  { 149915981, 63, 34370729608ULL },   // factor: 10305443293738130897
  { 148592911, 63, 34703633781ULL },   // factor: 10313427931593452983
  { 148718077, 63, 34725659880ULL },   // factor: 10328666719819301521
  { 149977307, 63, 34504232985ULL },   // factor: 10349703886381742791
  { 149217727, 63, 34688887185ULL },   // factor: 10352393795810256991
  { 149002531, 63, 34841440389ULL },   // factor: 10382925603293249119
  { 148014533, 63, 35076763123ULL },   // factor: 10383741425604933119
  { 149017339, 63, 34855252685ULL },   // factor: 10388074010582610431
  { 148311151, 63, 35041402745ULL },   // factor: 10394061547531018991
  { 148451977, 63, 35050009523ULL },   // factor: 10406486415116353943
  { 149399521, 63, 34833679775ULL },   // factor: 10408270146104775551
  { 149162323, 63, 34896138480ULL },   // factor: 10410378158812978081
  { 149241817, 63, 34948212923ULL },   // factor: 10431469595062802183
  { 148890541, 63, 35043037868ULL },   // factor: 10435153732900013177
  { 148873511, 63, 35057894016ULL },   // factor: 10438383540855620353
  { 148061869, 63, 35316693116ULL },   // factor: 10458111179308787609
  { 149196869, 63, 35052693715ULL },   // factor: 10459504304587956671
  { 148709203, 63, 35199812868ULL },   // factor: 10469072234698848409
  { 148849931, 63, 35167585948ULL },   // factor: 10469385483592739177
  { 148110043, 63, 35344543116ULL },   // factor: 10469763601452227977
  { 148359803, 63, 35309432265ULL },   // factor: 10477000829754487591
  { 148070827, 63, 35397215928ULL },   // factor: 10482590071913064913
  { 149574353, 63, 35094040155ULL },   // factor: 10498336700680289431
  { 149553589, 63, 35159412579ULL },   // factor: 10516432676642392063
  { 149388487, 63, 35207368829ULL },   // factor: 10519151121230543447
  { 149763191, 63, 35127190276ULL },   // factor: 10521520213195861433
  { 149254471, 63, 35265150288ULL },   // factor: 10526962701941875297
  { 149398031, 63, 35244661485ULL },   // factor: 10530966058241072071
  { 148331929, 63, 35507367539ULL },   // factor: 10533752641543705463
  { 149197621, 63, 35370761100ULL },   // factor: 10554466818158686201
  { 148987511, 63, 35484063661ULL },   // factor: 10573364650035875543
  { 149848681, 63, 35304132783ULL },   // factor: 10580555462762818447
  { 148991071, 63, 35550209028ULL },   // factor: 10593327434711177977
  { 149292023, 63, 35480616076ULL },   // factor: 10593945902544723497
  { 148143403, 63, 35795998701ULL },   // factor: 10605882122699439007
  { 149280949, 63, 35526405867ULL },   // factor: 10606831164769855567
  { 149922769, 63, 35413024755ULL },   // factor: 10618437459870293191
  { 148508489, 63, 35814429331ULL },   // factor: 10637493568688181719
  { 148997671, 63, 35696887293ULL },   // factor: 10637506137212989207
  { 149166373, 63, 35657439072ULL },   // factor: 10637781713677451713
  { 149155987, 63, 35673571497ULL },   // factor: 10641853532900205079
  { 149235521, 63, 35663412579ULL },   // factor: 10644495913730037319
  { 148718809, 63, 35851061495ULL },   // factor: 10663454333844318911
  { 149097001, 63, 35770725536ULL },   // factor: 10666615802023435073
  { 149568143, 63, 35712344448ULL },   // factor: 10682858082527440129
  { 148010227, 63, 36137595113ULL },   // factor: 10697467311818441303
  { 149145781, 63, 35863311344ULL },   // factor: 10697723159294079329
  { 148971929, 63, 36025742491ULL },   // factor: 10733648705083070279
  { 148102223, 63, 36276623716ULL },   // factor: 10745297230548241337
  { 149252209, 63, 36001259127ULL },   // factor: 10746534902972323087
  { 149944027, 63, 35840855612ULL },   // factor: 10748244443177659049
  { 149630629, 63, 35964520320ULL },   // factor: 10762787594329762561
  { 148161973, 63, 36323655900ULL },   // factor: 10763569049434181401
  { 149053721, 63, 36140001876ULL },   // factor: 10773603513129561193
  { 148781027, 63, 36256644129ULL },   // factor: 10788601498172280967
  { 148770863, 63, 36285500836ULL },   // factor: 10796450547517882937
  { 149858047, 63, 36033638409ULL },   // factor: 10799861356553854447
  { 149190467, 63, 36274503253ULL },   // factor: 10823620161016178303
  { 149216843, 63, 36287361981ULL },   // factor: 10829371191206091967
  { 149337593, 63, 36321252831ULL },   // factor: 10848256945051951567
  { 148359557, 63, 36618560863ULL },   // factor: 10865426935224435383
  { 148809979, 63, 36523983272ULL },   // factor: 10870266367405342577
  { 149126773, 63, 36492232007ULL },   // factor: 10883937597542446823
  { 148309643, 63, 36709886877ULL },   // factor: 10888860434596509823
  { 149561861, 63, 36464128168ULL },   // factor: 10907285737097201297
  { 149087317, 63, 36589009223ULL },   // factor: 10909914433490649383
  { 148826807, 63, 36718056489ULL },   // factor: 10929262213007001247
  { 149552443, 63, 36546599456ULL },   // factor: 10931266463974542017
  { 148028941, 63, 36924710660ULL },   // factor: 10931851631462422121
  { 149914931, 63, 36484831981ULL },   // factor: 10939242137956416623
  { 148533601, 63, 36832063563ULL },   // factor: 10941598066546560727
  { 149355233, 63, 36638739076ULL },   // factor: 10944374823044369417
  { 149648179, 63, 36630726741ULL },   // factor: 10963443104474509279
  { 149052109, 63, 36787613091ULL },   // factor: 10966542632579117839
  { 148425707, 63, 36956864832ULL },   // factor: 10970697582386072449
  { 149749123, 63, 36688722888ULL },   // factor: 10988208152936054449
  { 149241101, 63, 36825391908ULL },   // factor: 10991724066212821417
  { 149573447, 63, 36778144732ULL },   // factor: 11002067763660262409
  { 148552907, 63, 37052798277ULL },   // factor: 11008601793065882479
  { 149948039, 63, 36723341136ULL },   // factor: 11013185977742464609
  { 148515517, 63, 37081895568ULL },   // factor: 11014473783243057313
  { 149259437, 63, 36896278243ULL },   // factor: 11014235435891058383
  { 149700839, 63, 36862377612ULL },   // factor: 11036657712102432937
  { 149947241, 63, 36846169171ULL },   // factor: 11049962817221414423
  { 149794741, 63, 37079781588ULL },   // factor: 11108712558622057417
  { 149996761, 63, 37031068088ULL },   // factor: 11109080539140925937
  { 148996949, 63, 37287037392ULL },   // factor: 11111309617313834017
  { 148379641, 63, 37490919384ULL },   // factor: 11125778317915722289
  { 149941357, 63, 37152183452ULL },   // factor: 11141297604611648729
  { 148488017, 63, 37518770652ULL },   // factor: 11142175708786554169
  { 148571179, 63, 37505160264ULL },   // factor: 11144371758012862513
  { 148700917, 63, 37502721188ULL },   // factor: 11153378061301858793
  { 148863569, 63, 37477147675ULL },   // factor: 11157963917681104151
  { 149206051, 63, 37444299921ULL },   // factor: 11173832247344043943
  { 148881637, 63, 37564730504ULL },   // factor: 11185397141798710097
  { 148945963, 63, 37554718352ULL },   // factor: 11187247380264825953
  { 148337851, 63, 37729551396ULL },   // factor: 11193441146553379993
  { 149672387, 63, 37420979488ULL },   // factor: 11201774647693995713
  { 148518791, 63, 37730463301ULL },   // factor: 11207365586668778183
  { 148556119, 63, 37748429264ULL },   // factor: 11215520299611732833
  { 149925547, 63, 37438510277ULL },   // factor: 11225978264288693039
  { 148056173, 63, 37916978088ULL },   // factor: 11227685334868274449
  { 148093181, 63, 37958721339ULL },   // factor: 11242855579570178719
  { 148133941, 63, 38003580875ULL },   // factor: 11259240414251956751
  { 149811461, 63, 37597647703ULL },   // factor: 11265117065099448167
  { 148106429, 63, 38036580864ULL },   // factor: 11266924326273549313
  { 148474507, 63, 37944754944ULL },   // factor: 11267657567092425217
  { 148492121, 63, 37977461004ULL },   // factor: 11278707469357498969
  { 148700701, 63, 37922282768ULL },   // factor: 11278140062243640737
  { 148641923, 63, 38041559205ULL },   // factor: 11309141028299102431
  { 148728757, 63, 38025288767ULL },   // factor: 11310907865763945239
  { 149269171, 63, 37890571664ULL },   // factor: 11311788442002741089
  { 148132051, 63, 38217743676ULL },   // factor: 11322545510636318953
  { 148133191, 63, 38257898601ULL },   // factor: 11334529201441131583
  { 149313937, 63, 37994587028ULL },   // factor: 11346242747679618473
  { 148253269, 63, 38411825295ULL },   // factor: 11389357336481278711
  { 149983247, 63, 37986729925ULL },   // factor: 11394746194127132951
  { 148129151, 63, 38511223828ULL },   // factor: 11409269779225220057
  { 148467857, 63, 38446458568ULL },   // factor: 11416126625660497553
  { 148255741, 63, 38522452383ULL },   // factor: 11422349446357761607
  { 149234717, 63, 38271291159ULL },   // factor: 11422810610675934007
  { 148511411, 63, 38481008329ULL },   // factor: 11429737687285084439
  { 148677343, 63, 38476504481ULL },   // factor: 11441168908325347967
  { 148730371, 63, 38464572225ULL },   // factor: 11441700194761090951
  { 148128511, 63, 38686870728ULL },   // factor: 11461257112376252017
  { 148861747, 63, 38500060209ULL },   // factor: 11462372444633850247
  { 148092949, 63, 38731040075ULL },   // factor: 11471587885087862351
  { 148981073, 63, 38506289800ULL },   // factor: 11473416743305910801
  { 148679989, 63, 38607448527ULL },   // factor: 11480310044624852407
  { 148370701, 63, 38722463219ULL },   // factor: 11490558024499493039
  { 149293481, 63, 38484809008ULL },   // factor: 11491062204848953697
  { 149897807, 63, 38415621052ULL },   // factor: 11516834700475665929
  { 148610269, 63, 38801238476ULL },   // factor: 11532524974903020089
  { 148830089, 63, 38824478644ULL },   // factor: 11556501223930238633
  { 148926671, 63, 38866318425ULL },   // factor: 11576462834122426351
  { 149988103, 63, 38593552952ULL },   // factor: 11577147590601060113
  { 149789891, 63, 38671964656ULL },   // factor: 11585338741156184993
  { 148424231, 63, 39033768064ULL },   // factor: 11587114015863117569
  { 149568469, 63, 38739314516ULL },   // factor: 11588359924535192009
  { 148097909, 63, 39128852727ULL },   // factor: 11589802540875295687
  { 148361441, 63, 39119960755ULL },   // factor: 11607787498950495911
  { 148506037, 63, 39091625432ULL },   // factor: 11610684745589465969
  { 149569997, 63, 38854581484ULL },   // factor: 11622959271996271097
  { 149509337, 63, 38882213703ULL },   // factor: 11626507983655689823
  { 149411023, 63, 39022821125ULL },   // factor: 11660879249264521751
  { 148224877, 63, 39383873912ULL },   // factor: 11675339732779417649
  { 148191629, 63, 39448664127ULL },   // factor: 11691923597707985767
  { 149278273, 63, 39179281767ULL },   // factor: 11697231039116296783
  { 149322457, 63, 39168812492ULL },   // factor: 11697566638155465689
  { 148734023, 63, 39328001337ULL },   // factor: 11698823710802777503
  { 149604877, 63, 39184867032ULL },   // factor: 11724494425167430129
  { 148821229, 63, 39401511215ULL },   // factor: 11727562646947166471
  { 149792239, 63, 39192106500ULL },   // factor: 11741346767522907001
  { 148645691, 63, 39619863808ULL },   // factor: 11778644066132102657
  { 149823119, 63, 39312931372ULL },   // factor: 11779971990371978537
  { 148203521, 63, 39758430504ULL },   // factor: 11784678780253209169
  { 148968553, 63, 39563636591ULL },   // factor: 11787475388758245647
  { 149907983, 63, 39340679433ULL },   // factor: 11794963807301227279
  { 148765961, 63, 39648229048ULL },   // factor: 11796613792547670257
  { 149668993, 63, 39447740031ULL },   // factor: 11808207053131117567
  { 148433227, 63, 39810205412ULL },   // factor: 11818314513672049049
  { 148275913, 63, 39924994035ULL },   // factor: 11839829884118357911
  { 148077107, 63, 40105113064ULL },   // factor: 11877298236850051697
  { 149144657, 63, 39837650907ULL },   // factor: 11883145560420507799
  { 149108503, 63, 39859301445ULL },   // factor: 11886721538179373671
  { 149856397, 63, 39685561700ULL },   // factor: 11894270578566389801
  { 149560231, 63, 39801148748ULL },   // factor: 11905338001632481577
  { 149309879, 63, 39896211852ULL },   // factor: 11913797128360971817
  { 149851981, 63, 39841406376ULL },   // factor: 11940627342539261713
  { 149998657, 63, 39898605360ULL },   // factor: 11969474440346003041
  { 148857061, 63, 40220060744ULL },   // factor: 11974080071186626769
  { 149243819, 63, 40115462689ULL },   // factor: 11973969705316738583
  { 149937751, 63, 39985636353ULL },   // factor: 11990712774145324207
  { 149330957, 63, 40179842928ULL },   // factor: 12000188793095844193
  { 149391401, 63, 40204169283ULL },   // factor: 12012314350457070967
  { 149239267, 63, 40256334440ULL },   // factor: 12015651687864910961
  { 149325079, 63, 40282681325ULL },   // factor: 12030429142374899351
  { 148621519, 63, 40491905289ULL },   // factor: 12035936942510627983
  { 149401907, 63, 40289452393ULL },   // factor: 12038642038999826903
  { 149773489, 63, 40200720444ULL },   // factor: 12042004322423018233
  { 149409857, 63, 40314518283ULL },   // factor: 12046772823373831063
  { 148161721, 63, 40737737975ULL },   // factor: 12071546736046109951
  { 149288851, 63, 40562472980ULL },   // factor: 12111049969805491961
  { 148517123, 63, 40780812505ULL },   // factor: 12113297893690046231
  { 148549903, 63, 40781841848ULL },   // factor: 12116277301363481489
  { 149053103, 63, 40654806745ULL },   // factor: 12119450194415159471
  { 148801661, 63, 40751755224ULL },   // factor: 12127857731993254129
  { 149220013, 63, 40721910516ULL },   // factor: 12153048033164713417
  { 148464769, 63, 40956339515ULL },   // factor: 12161146970360094071
  { 149351177, 63, 40756132648ULL },   // factor: 12173952761893853393
  { 148191269, 63, 41099982892ULL },   // factor: 12181317241287539897
  { 149480959, 63, 40846108020ULL },   // factor: 12211430796494382361
  { 149961089, 63, 40776945027ULL },   // factor: 12229910164684108807
  { 148756607, 63, 41282079357ULL },   // factor: 12281964110104123399
  { 149498653, 63, 41122530971ULL },   // factor: 12295525976230564127
  { 148408319, 63, 41493868525ULL },   // factor: 12316070553204518951
  { 149882311, 63, 41136250820ULL },   // factor: 12331192677554490041
  { 149883469, 63, 41136889035ULL },   // factor: 12331479264867724831
  { 149323127, 63, 41475459652ULL },   // factor: 12386490657997943609
  { 148740013, 63, 41664036003ULL },   // factor: 12394218513437376079
  { 149995427, 63, 41367156789ULL },   // factor: 12409768692684007807
  { 149281397, 63, 41585828947ULL },   // factor: 12415981281222397919
  { 148230359, 63, 41901713737ULL },   // factor: 12422212139901483167
  { 149041133, 63, 41734445556ULL },   // factor: 12440298101586109897
  { 148170203, 63, 42049936092ULL },   // factor: 12461095133777333353
  { 149613949, 63, 41686610715ULL },   // factor: 12473796898993727071
  { 149749147, 63, 41699909120ULL },   // factor: 12489051641395041281
  { 149873743, 63, 41705344416ULL },   // factor: 12501072141460138177
  { 149991701, 63, 41704536184ULL },   // factor: 12510668643308417969
  { 148123007, 63, 42288837957ULL },   // factor: 12527899681453153399
  { 149240759, 63, 42027629244ULL },   // factor: 12544470574690312393
  { 148140053, 63, 42406528888ULL },   // factor: 12564210874028702129
  { 149507909, 63, 42048653392ULL },   // factor: 12573212489807354657
  { 148932239, 63, 42241771405ULL },   // factor: 12582323189345651591
  { 149998879, 63, 41971137365ULL },   // factor: 12591247110210027671
  { 148455143, 63, 42438400821ULL },   // factor: 12600397725145744807
  { 148741547, 63, 42369911073ULL },   // factor: 12604332238500899863
  { 149402447, 63, 42245360148ULL },   // factor: 12623120361014964313
  { 148283977, 63, 42674313983ULL },   // factor: 12655833986291900783
  { 148100389, 63, 42812219700ULL },   // factor: 12681012783046926601
  { 149527463, 63, 42415329513ULL },   // factor: 12684513228775831039
  { 148071089, 63, 42867904219ULL },   // factor: 12694994521710048983
  { 149428219, 63, 42510605841ULL },   // factor: 12704568238863254359
  { 148038929, 63, 42915820827ULL },   // factor: 12706424304769948567
  { 149804147, 63, 42464521332ULL },   // factor: 12722722791807127609
  { 148745893, 63, 42821960895ULL },   // factor: 12739181626675708471
  { 149281057, 63, 42670596699ULL },   // factor: 12739823556094861687
  { 148222271, 63, 43012599924ULL },   // factor: 12750850484699414809
  { 148602029, 63, 42953489224ULL },   // factor: 12765951302632070993
  { 148307461, 63, 43044482871ULL },   // factor: 12767635929312001063
  { 149890289, 63, 42698510307ULL },   // factor: 12800184099571417447
  { 148335611, 63, 43179297085ULL },   // factor: 12810054831307987871
  { 149050721, 63, 42973866940ULL },   // factor: 12810571703130127481
  { 149500319, 63, 42847842921ULL },   // factor: 12811532370302783599
  { 148556431, 63, 43264588653ULL },   // factor: 12854465757945554887
  { 149355301, 63, 43046867384ULL },   // factor: 12858555670488805169
  { 149682979, 63, 42968182956ULL },   // factor: 12863211254142211849
  { 149881141, 63, 42938990984ULL },   // factor: 12871489924141265489
  { 148585663, 63, 43363589360ULL },   // factor: 12886415350230691361
  { 148487189, 63, 43476090600ULL },   // factor: 12911284963806646801
  { 149879993, 63, 43097128603ULL },   // factor: 12918794666675479559
  { 148147903, 63, 43614986976ULL },   // factor: 12922937719733422657
  { 149482913, 63, 43263193863ULL },   // factor: 12934216488649925839
  { 149287783, 63, 43372178072ULL },   // factor: 12949872616500188753
  { 148712491, 63, 43572815184ULL },   // factor: 12959643771790526689
  { 148778983, 63, 43637392092ULL },   // factor: 12984653632440004873
  { 148675577, 63, 43676028447ULL },   // factor: 12987117460852277839
  { 149372579, 63, 43491004377ULL },   // factor: 12992726974185556567
  { 148161709, 63, 43965069447ULL },   // factor: 13027879651142409847
  { 148919579, 63, 43744131985ULL },   // factor: 13028715437853268631
  { 148203493, 63, 44021975811ULL },   // factor: 13048421167903415647
  { 148902287, 63, 43941855772ULL },   // factor: 13086085638949901129
  { 148832753, 63, 43971695475ULL },   // factor: 13088856983243785351
  { 148529971, 63, 44118903389ULL },   // factor: 13105958881839943439
  { 148804277, 63, 44227289799ULL },   // factor: 13162419764419340647
  { 149509813, 63, 44034725676ULL },   // factor: 13167247202650117177
  { 149638589, 63, 44052510516ULL },   // factor: 13183911031043803849
  { 149378329, 63, 44186852619ULL },   // factor: 13201116415990987303
  { 149867527, 63, 44047246269ULL },   // factor: 13202503738990013527
  { 149560051, 63, 44161485365ULL },   // factor: 13209588006850307231
  { 149471219, 63, 44203924977ULL },   // factor: 13214429101793473927
  { 149164013, 63, 44328835663ULL },   // factor: 13224534038221191239
  { 149448569, 63, 44306302404ULL },   // factor: 13243026983918119753
  { 149119669, 63, 44426688972ULL },   // factor: 13249786308541180537
  { 149136331, 63, 44428893996ULL },   // factor: 13251924481902737353
  { 148047089, 63, 44781791095ULL },   // factor: 13259627623641744911
  { 149944079, 63, 44281343221ULL },   // factor: 13279450452311476919
  { 148424791, 63, 44777013536ULL },   // factor: 13292037751369941953
  { 148815761, 63, 44702496439ULL },   // factor: 13304872052339150159
  { 148037521, 63, 44977265424ULL },   // factor: 13316645749455947809
  { 148022827, 63, 45010951152ULL },   // factor: 13325296470955893409
  { 148418251, 63, 44908343105ULL },   // factor: 13330435477904018711
  { 148957603, 63, 44842980780ULL },   // factor: 13359405856727740681
  { 148413901, 63, 45039483695ULL },   // factor: 13368970948401688391
  { 148664377, 63, 44981804123ULL },   // factor: 13374383772563652743
  { 149727979, 63, 44709078369ULL },   // factor: 13388399894285972503
  { 149461547, 63, 44808272028ULL },   // factor: 13394227311403414633
  { 148326571, 63, 45164332665ULL },   // factor: 13398141191405483431
  { 148492153, 63, 45113518080ULL },   // factor: 13398006858207252481
  { 149452543, 63, 44826943388ULL },   // factor: 13399001368507271369
  { 149789177, 63, 44732714820ULL },   // factor: 13400953075727006281
  { 148161133, 63, 45275194040ULL },   // factor: 13416048091522494641
  { 148238917, 63, 45287079315ULL },   // factor: 13426615183497403711
  { 148658231, 63, 45170782824ULL },   // factor: 13430017335002048689
  { 149233639, 63, 45234884181ULL },   // factor: 13501132752148329319
  { 148241521, 63, 45581725271ULL },   // factor: 13514208567954354383
  { 148809433, 63, 45436157283ULL },   // factor: 13522657605964101079
  { 149420083, 63, 45287197716ULL },   // factor: 13533633683124260857
  { 148437833, 63, 45592647063ULL },   // factor: 13535347461531068959
  { 149279887, 63, 45385030844ULL },   // factor: 13550144551767669257
  { 149152819, 63, 45439269621ULL },   // factor: 13554790314546423199
  { 149700203, 63, 45344683117ULL },   // factor: 13576216535171145503
  { 148474853, 63, 45764256600ULL },   // factor: 13589682542678559601
  { 148266449, 63, 45907879387ULL },   // factor: 13613196515661573527
  { 148235027, 63, 45966247525ULL },   // factor: 13627615885914116351
  { 148877579, 63, 45806504557ULL },   // factor: 13639123001797255007
  { 148547459, 63, 45964718989ULL },   // factor: 13655884418929997903
  { 149820449, 63, 45600000727ULL },   // factor: 13663625166638932847
  { 148119823, 63, 46165489985ULL },   // factor: 13676048410572945311
  { 148424587, 63, 46098746820ULL },   // factor: 13684374915952126681
  { 148938341, 63, 45969323904ULL },   // factor: 13693189678306806529
  { 149063017, 63, 45932053539ULL },   // factor: 13693540955057734327
  { 148033117, 63, 46302790868ULL },   // factor: 13708692915978351113
  { 148936309, 63, 46046743116ULL },   // factor: 13716063922336397689
  { 148247761, 63, 46315606764ULL },   // factor: 13732370004238910809
  { 148574707, 63, 46241218884ULL },   // factor: 13740551094026333977
  { 148685969, 63, 46227849651ULL },   // factor: 13746865240290493639
  { 148660433, 63, 46249207603ULL },   // factor: 13750854456337744199
  { 149345687, 63, 46041364669ULL },   // factor: 13752158473818665207
  { 148470103, 63, 46315342860ULL },   // factor: 13752887449809029161
  { 148599307, 63, 46304003144ULL },   // factor: 13761485557048442417
  { 149582159, 63, 46004018752ULL },   // factor: 13762760895201291137
  { 149924963, 63, 45956679060ULL },   // factor: 13780106815346749561
  { 148882763, 63, 46320223720ULL },   // factor: 13792565780423476721
  { 148672211, 63, 46400435785ULL },   // factor: 13796910759038941271
  { 149711743, 63, 46088833092ULL },   // factor: 13800079070078798713
  { 148058657, 63, 46639819852ULL },   // factor: 13810858180018117529
  { 148875401, 63, 46438435255ULL },   // factor: 13827081340801324511
  { 149250583, 63, 46319328912ULL },   // factor: 13826373688569511393
  { 148834549, 63, 46574456240ULL },   // factor: 13863776378801271521
  { 148064233, 63, 46898865915ULL },   // factor: 13888089220548636391
  { 148597021, 63, 46753103124ULL },   // factor: 13894743693464387209
  { 148320229, 63, 46859380040ULL },   // factor: 13900387956661658321
  { 149801423, 63, 46437135220ULL },   // factor: 13912697871998836121
  { 148469837, 63, 46947370180ULL },   // factor: 13940536796406521321
  { 149462977, 63, 46634975000ULL },   // factor: 13940404391641150001
  { 149924221, 63, 46518877224ULL },   // factor: 13948612859205685009
  { 149736161, 63, 46631214924ULL },   // factor: 13964758210971333529
  { 149726371, 63, 46661304645ULL },   // factor: 13972855621242586591
  { 148361611, 63, 47141503856ULL },   // factor: 13987978914077744033
  { 149517869, 63, 46810413216ULL },   // factor: 13997986462131513409
  { 149191433, 63, 46990525323ULL },   // factor: 14021167620722315719
  { 149693521, 63, 46884064400ULL },   // factor: 14036481357653504801
  { 149835193, 63, 46880677331ULL },   // factor: 14048750671722219767
  { 149817191, 63, 46933790784ULL },   // factor: 14062977396481135489
  { 148040281, 63, 47516140196ULL },   // factor: 14068605493302470153
  { 149852243, 63, 46949051121ULL },   // factor: 14070841234407028807
  { 149835451, 63, 46989194709ULL },   // factor: 14081294362699657519
  { 148598833, 63, 47434411196ULL },   // factor: 14097396295535468537
  { 148440973, 63, 47497853511ULL },   // factor: 14101255181168612407
  { 149539301, 63, 47219197971ULL },   // factor: 14122251716727916543
  { 149087507, 63, 47424289164ULL },   // factor: 14140738085415748297
  { 149249101, 63, 47377660140ULL },   // factor: 14142146366757068281
  { 149249879, 63, 47476057156ULL },   // factor: 14171591571860168249
  { 148107121, 63, 47847721800ULL },   // factor: 14173176644413875601
  { 148881827, 63, 47597801817ULL },   // factor: 14172895391397759319
  { 149833837, 63, 47315013635ULL },   // factor: 14178780081278734991
  { 148649807, 63, 47763473548ULL },   // factor: 14200062249119610473
  { 149697239, 63, 47599851661ULL },   // factor: 14251132740922527959
  { 148235141, 63, 48095025060ULL },   // factor: 14258745642335266921
  { 149689291, 63, 47649289224ULL },   // factor: 14265176641189000369
  { 148094957, 63, 48201322264ULL },   // factor: 14276745496060445297
  { 148553611, 63, 48113537964ULL },   // factor: 14294879605075576009
  { 149870923, 63, 47694759833ULL },   // factor: 14296115356870071719
  { 148417547, 63, 48195126145ULL },   // factor: 14306004799592932631
  { 149999429, 63, 47719466644ULL },   // factor: 14315785497569092553
  { 148914641, 63, 48091327719ULL },   // factor: 14323005604976467759
  { 149033567, 63, 48060740520ULL },   // factor: 14325327184714069681
  { 149093419, 63, 48044497104ULL },   // factor: 14326236674741917153
  { 149600753, 63, 47885405616ULL },   // factor: 14327385475728057697
  { 148536379, 63, 48250127124ULL },   // factor: 14333798338577287993
  { 149805533, 63, 47966823615ULL },   // factor: 14371391155924123591
  { 149257453, 63, 48166181871ULL },   // factor: 14378323253600469127
  { 148080161, 63, 48557485203ULL },   // factor: 14380800453230715367
  { 149701837, 63, 48124194104ULL },   // factor: 14408560523026738097
  { 148475753, 63, 48559548372ULL },   // factor: 14419831019745248233
  { 148717759, 63, 48541040120ULL },   // factor: 14437829412350982161
  { 149000689, 63, 48483727932ULL },   // factor: 14448217734313090297
  { 149894131, 63, 48214739384ULL },   // factor: 14454212922712310609
  { 149246959, 63, 48500982417ULL },   // factor: 14477248268499439807
  { 149269349, 63, 48499001976ULL },   // factor: 14478828904214467249
  { 149757079, 63, 48340518197ULL },   // factor: 14478669605058133127
  { 148493591, 63, 48952283916ULL },   // factor: 14538200852676764713
  { 149052679, 63, 48804851004ULL },   // factor: 14548987580684079433
  { 148452439, 63, 49014388485ULL },   // factor: 14552611033383529831
  { 149906399, 63, 48557837464ULL },   // factor: 14558261114911064273
  { 148237721, 63, 49136798935ULL },   // factor: 14567854182719254271
  { 148036249, 63, 49229796864ULL },   // factor: 14575588933557046273
  { 149044733, 63, 48899254612ULL },   // factor: 14576352695089117193
  { 149989867, 63, 48648508025ULL },   // factor: 14593566496836365351
  { 149097587, 63, 48950981649ULL },   // factor: 14596946490294361927
  { 148279709, 63, 49307444692ULL },   // factor: 14622587100926709257
  { 149035387, 63, 49068518172ULL },   // factor: 14625891190561105129
  { 149337973, 63, 48972391991ULL },   // factor: 14626875505794748487
  { 149288983, 63, 49019352816ULL },   // factor: 14636098658437652257
  { 148098607, 63, 49427937728ULL },   // factor: 14640417448799089793
  { 148722373, 63, 49235827652ULL },   // factor: 14644938250048916393
  { 149743511, 63, 49030492585ULL },   // factor: 14683996211474731871
  { 148116701, 63, 49577672016ULL },   // factor: 14686562444539878433
  { 148627961, 63, 49429688656ULL },   // factor: 14693267675612220833
  { 149367073, 63, 49223642943ULL },   // factor: 14704782937586031679
  { 148771969, 63, 49425399947ULL },   // factor: 14706228137455371287
  { 148317307, 63, 49647196332ULL },   // factor: 14727076920125035849
  { 148151063, 63, 49712217861ULL },   // factor: 14729835840389472487
  { 149477333, 63, 49359103200ULL },   // factor: 14756134211215531201
  { 149417291, 63, 49520069481ULL },   // factor: 14798309263965591943
  { 148409353, 63, 49862196512ULL },   // factor: 14800032647009553473
  { 149155469, 63, 49610823099ULL },   // factor: 14799451173614756863
  { 148867703, 63, 49723767357ULL },   // factor: 14804526061885941943
  { 148701767, 63, 49801702905ULL },   // factor: 14811202443165066271
  { 149163097, 63, 49652411087ULL },   // factor: 14812614822508112879
  { 149170337, 63, 49696694259ULL },   // factor: 14826545260801990567
  { 148818281, 63, 49846811896ULL },   // factor: 14836233719386141553
  { 148402147, 63, 50027108897ULL },   // factor: 14848260737035203719
  { 149782379, 63, 49588498816ULL },   // factor: 14854966647398326529
  { 148813747, 63, 49944766940ULL },   // factor: 14864935822766248361
  { 148906579, 63, 50015474352ULL },   // factor: 14895266365637123617
  { 148429451, 63, 50195149285ULL },   // factor: 14900876902471185071
  { 148778977, 63, 50117901627ULL },   // factor: 14912980266903391159
  { 149305867, 63, 50062926873ULL },   // factor: 14949377402661727783
  { 148495829, 63, 50345736079ULL },   // factor: 14952263631332628983
  { 148600979, 63, 50312452996ULL },   // factor: 14952959542194166169
  { 149558467, 63, 50037553100ULL },   // factor: 14967079468134195401
  { 148029731, 63, 50608002165ULL },   // factor: 14982977893864735231
  { 149727689, 63, 50053039884ULL },   // factor: 14988651978512296153
  { 149259731, 63, 50332032616ULL },   // factor: 15025091297894772593
  { 148440911, 63, 50645590593ULL },   // factor: 15035755211515900447
  { 149976707, 63, 50178164469ULL },   // factor: 15051111740730047167
  { 149159081, 63, 50484161163ULL },   // factor: 15060342168257942407
  { 149199227, 63, 50603413533ULL },   // factor: 15099980365369877983
  { 148779979, 63, 50760533169ULL },   // factor: 15104302117825246903
  { 149055749, 63, 50698229967ULL },   // factor: 15113725281410860567
  { 149168167, 63, 50698992633ULL },   // factor: 15125351599622227423
  { 149620243, 63, 50569066560ULL },   // factor: 15132312053980748161
  { 148355731, 63, 51041826360ULL },   // factor: 15144694922425738321
  { 149190233, 63, 50759294703ULL },   // factor: 15145582007312471599
  { 148482137, 63, 51011106688ULL },   // factor: 15148476263538464513
  { 148902701, 63, 50873751459ULL },   // factor: 15150478004495581519
  { 149332147, 63, 50789450057ULL },   // factor: 15168995243922164759
  { 149895913, 63, 50635759775ULL },   // factor: 15180186883844599151
  { 148922909, 63, 50995124520ULL },   // factor: 15188684576671257361
  { 149178613, 63, 50911594272ULL },   // factor: 15189842038231409473
  { 148424417, 63, 51174329652ULL },   // factor: 15191040087927825769
  { 149807261, 63, 50759950548ULL },   // factor: 15208418320182658057
  { 148613767, 63, 51186263937ULL },   // factor: 15213967004667641359
  { 149573077, 63, 50914915988ULL },   // factor: 15231001299043310153
  { 148381819, 63, 51383307729ULL },   // factor: 15248697334131558103
  { 149087779, 63, 51171524972ULL },   // factor: 15258098012237034377
  { 148513441, 63, 51495566576ULL },   // factor: 15295567576892696033
  { 148437001, 63, 51627030083ULL },   // factor: 15326723032114602167
  { 149826517, 63, 51199199139ULL },   // factor: 15341995360371537727
  { 149142731, 63, 51449198044ULL },   // factor: 15346547808084036329
  { 148140229, 63, 51856772759ULL },   // factor: 15364148383438443623
  { 149476541, 63, 51391871080ULL },   // factor: 15363758249112668561
  { 148725037, 63, 51675848715ULL },   // factor: 15370985024289554911
  { 149205011, 63, 51522987204ULL },   // factor: 15374975745051358489
  { 149653169, 63, 51405292035ULL },   // factor: 15385929712816417831
  { 149749427, 63, 51407251653ULL },   // factor: 15396412957363105663
  { 149968433, 63, 51344887135ULL },   // factor: 15400224532395618911
  { 149618101, 63, 51481015103ULL },   // factor: 15404983434526358807
  { 149027951, 63, 51726465529ULL },   // factor: 15417378340518002159
  { 149403161, 63, 51738412324ULL },   // factor: 15459764692653912329
  { 148088609, 63, 52253106280ULL },   // factor: 15476179649868729041
  { 148393639, 63, 52202224500ULL },   // factor: 15492956114899911001
  { 148223501, 63, 52331394268ULL },   // factor: 15513484941228584537
  { 149748241, 63, 51801949844ULL },   // factor: 15514501739018448809
  { 149336123, 63, 52036521297ULL },   // factor: 15541864689801823063
  { 149436799, 63, 52062968729ULL },   // factor: 15560246786597716943
  { 148887983, 63, 52284983388ULL },   // factor: 15569211435655652809
  { 149185969, 63, 52193959892ULL },   // factor: 15573212964870310697
  { 148850843, 63, 52320865356ULL },   // factor: 15576009829460190217
  { 149247089, 63, 52209248656ULL },   // factor: 15584156761570324769
  { 148453919, 63, 52602705505ULL },   // factor: 15618155564440248191
  { 149705401, 63, 52168850943ULL },   // factor: 15619917500262086287
  { 148176461, 63, 52731546100ULL },   // factor: 15627147768312704201
  { 149419057, 63, 52305781479ULL },   // factor: 15630961088480490607
  { 148020251, 63, 52848708849ULL },   // factor: 15645358297709802199
  { 149218631, 63, 52502221701ULL },   // factor: 15668619293363422663
  { 149884037, 63, 52335838764ULL },   // factor: 15688613587458820537
  { 148239529, 63, 53052737091ULL },   // factor: 15729025517061340279
  { 148561009, 63, 52982402895ULL },   // factor: 15742238466651442111
  { 148094977, 63, 53343727088ULL },   // factor: 15799876072383273953
  { 148998637, 63, 53061153128ULL },   // factor: 15812078987440573073
  { 148783469, 63, 53152482159ULL },   // factor: 15816421363153259143
  { 149698027, 63, 52832628464ULL },   // factor: 15817880484569681057
  { 148232153, 63, 53377813800ULL },   // factor: 15824616524014222801
  { 149622139, 63, 52903049732ULL },   // factor: 15830934921050433497
  { 148651717, 63, 53321579168ULL },   // factor: 15852688592949262913
  { 149268079, 63, 53136599225ULL },   // factor: 15863196181817277551
  { 149686723, 63, 52997659608ULL },   // factor: 15866091986781969169
  { 148355231, 63, 53476662900ULL },   // factor: 15867085355277259801
  { 148928513, 63, 53346634572ULL },   // factor: 15889669920724702873
  { 149724109, 63, 53061353807ULL },   // factor: 15889127842173665927
  { 149340511, 63, 53318611349ULL },   // factor: 15925257329340118679
  { 149214487, 63, 53453365128ULL },   // factor: 15952032911996418673
  { 148838861, 63, 53629613908ULL },   // factor: 15964341299872957577
  { 149313551, 63, 53562363124ULL },   // factor: 15995173275991786649
  { 149330287, 63, 53645018189ULL },   // factor: 16021651924567180487
  { 148934347, 63, 53890663977ULL },   // factor: 16052341697621836039
  { 148215329, 63, 54198773832ULL },   // factor: 16066178189812941457
  { 149765977, 63, 53657052132ULL },   // factor: 16072001670977825929
  { 148137049, 63, 54273355124ULL },   // factor: 16079789334796778153
  { 148017799, 63, 54516063609ULL },   // factor: 16138695491096353183
  { 148963063, 63, 54216821705ULL },   // factor: 16152607654603364831
  { 149612987, 63, 54006197793ULL },   // factor: 16160057136647075383
  { 149153813, 63, 54224936208ULL },   // factor: 16175711990209922209
  { 149735389, 63, 54134104587ULL },   // factor: 16211582417002258687
  { 149602643, 63, 54234043732ULL },   // factor: 16227112565769567353
  { 148687237, 63, 54676967303ULL },   // factor: 16259534391644823623
  { 149176243, 63, 54584025960ULL },   // factor: 16285279841054536561
  { 149877349, 63, 54427675304ULL },   // factor: 16314951373592578193
  { 149247061, 63, 54671580191ULL },   // factor: 16319145327465137303
  { 149274299, 63, 54737458125ULL },   // factor: 16341791381302458751
  { 148891997, 63, 54967727139ULL },   // factor: 16368509328553613167
  { 148220231, 63, 55307981929ULL },   // factor: 16395523715320411199
  { 149251121, 63, 54928196275ULL },   // factor: 16396189737103548551
  { 149224913, 63, 54997475427ULL },   // factor: 16413986971627425703
  { 148990033, 63, 55115331543ULL },   // factor: 16423270130795021839
  { 148093669, 63, 55486573071ULL },   // factor: 16434420372641974999
  { 149782277, 63, 54867470520ULL },   // factor: 16436349335431948081
  { 148652323, 63, 55354775840ULL },   // factor: 16457232035520552641
  { 148462871, 63, 55485677284ULL },   // factor: 16475125897924244729
  { 149371777, 63, 55285146303ULL },   // factor: 16516081089968180863
  { 149584417, 63, 55243404104ULL },   // factor: 16527104791984494737
  { 148157239, 63, 55881860769ULL },   // factor: 16558604403434913583
  { 148193317, 63, 55989199152ULL },   // factor: 16594450277016934369
  { 149702753, 63, 55443264763ULL },   // factor: 16600018740657985079
  { 149718427, 63, 55442870165ULL },   // factor: 16601638618938060911
  { 148190951, 63, 56029199548ULL },   // factor: 16606040729573780297
  { 149014757, 63, 55735907415ULL },   // factor: 16610945399241446311
  { 148926941, 63, 55790915655ULL },   // factor: 16617540808176322711
  { 149657593, 63, 55568887760ULL },   // factor: 16632611975697523361
  { 149389007, 63, 55729277692ULL },   // factor: 16650682910470263689
  { 148632703, 63, 56021873700ULL },   // factor: 16653365030311222201
  { 149419433, 63, 55734787515ULL },   // factor: 16655720697733557991
  { 149948107, 63, 55608555713ULL },   // factor: 16676795324336770583
  { 148470059, 63, 56278434396ULL },   // factor: 16711324950403498729
  { 149936453, 63, 55762646275ULL },   // factor: 16721706784734325151
  { 149729243, 63, 55850270616ULL },   // factor: 16724837481357647377
  { 149846287, 63, 55875552113ULL },   // factor: 16745488036416108863
  { 149247689, 63, 56105440447ULL },   // factor: 16747214654083753967
  { 149939869, 63, 55928241935ULL },   // factor: 16771746538268413031
  { 148512223, 63, 56642089961ULL },   // factor: 16824085390948186607
  { 149783093, 63, 56166566292ULL },   // factor: 16825604044810602313
  { 148014547, 63, 56854053972ULL },   // factor: 16830454087558261369
  { 148980277, 63, 56635913184ULL },   // factor: 16875268068600543937
  { 149590039, 63, 56608450316ULL },   // factor: 16936120581000004649
  { 148776487, 63, 56918878320ULL },   // factor: 16936381520860123681
  { 148983071, 63, 56858273029ULL },   // factor: 16941840255233784119
  { 148725329, 63, 57087746284ULL },   // factor: 16980787695912854873
  { 148270679, 63, 57304256112ULL },   // factor: 16993081926632280097
  { 148823723, 63, 57226050936ULL },   // factor: 17033187905766309457
  { 149819689, 63, 56852883596ULL },   // factor: 17035362678211843289
  { 148166107, 63, 57549405533ULL },   // factor: 17053742755977740063
  { 149171471, 63, 57175690849ULL },   // factor: 17057963818773137759
  { 148921433, 63, 57418449883ULL },   // factor: 17101675674430084679
  { 149605429, 63, 57227957240ULL },   // factor: 17123226187367711921
  { 148508407, 63, 57818735685ULL },   // factor: 17173136662666807591
  { 149548769, 63, 57511663155ULL },   // factor: 17201596855945812391
  { 149718323, 63, 57595976200ULL },   // factor: 17246345936423825201
  { 148486927, 63, 58079376632ULL },   // factor: 17248056316322579729
  { 149070707, 63, 57854823964ULL },   // factor: 17248919023348045097
  { 149706617, 63, 57625866984ULL },   // factor: 17253947195733266257
  { 149712391, 63, 57674339904ULL },   // factor: 17269126652749100929
  { 148312357, 63, 58366954335ULL },   // factor: 17313081136670435191
  { 148397383, 63, 58353147776ULL },   // factor: 17318908839541340417
  { 148923479, 63, 58277311165ULL },   // factor: 17357719850914686071
  { 148639571, 63, 58393268640ULL },   // factor: 17359100799874706881
  { 149603833, 63, 58081638068ULL },   // factor: 17378471363783029289
  { 148819133, 63, 58404871471ULL },   // factor: 17383524670581309287
  { 148363771, 63, 58664708225ULL },   // factor: 17407434673751432951
  { 148269809, 63, 58712310720ULL },   // factor: 17410526192806104961
  { 148011869, 63, 58824766839ULL },   // factor: 17413527366659224183
  { 148941239, 63, 58504403845ULL },   // factor: 17427436791261327911
  { 148945213, 63, 58520260655ULL },   // factor: 17432625376148989031
  { 149378459, 63, 58371540984ULL },   // factor: 17438901683290527313
  { 148913053, 63, 58584377103ULL },   // factor: 17447956905022050919
  { 148186123, 63, 58894427573ULL },   // factor: 17454673776694338959
  { 149955137, 63, 58249642792ULL },   // factor: 17469666330150845009
  { 148180367, 63, 58965007620ULL },   // factor: 17474912938578793081
  { 148035709, 63, 59057700480ULL },   // factor: 17485297124932880641
  { 149015479, 63, 58704763964ULL },   // factor: 17495837043354797513
  { 149770997, 63, 58442480139ULL },   // factor: 17505977035141457167
  { 148538869, 63, 58933685219ULL },   // factor: 17507885896864554623
  { 149515783, 63, 58559789180ULL },   // factor: 17511225463125255881
  { 148873589, 63, 58851013644ULL },   // factor: 17522723234940496633
  { 149663077, 63, 58577153147ULL },   // factor: 17533673963760506639
  { 148152583, 63, 59250820877ULL },   // factor: 17556324315595750583
  { 149370131, 63, 58812619189ULL },   // factor: 17569697265428087519
  { 149607013, 63, 58727229831ULL },   // factor: 17572010873560809607
  { 148633987, 63, 59153170233ULL },   // factor: 17584343070841017943
  { 148103927, 63, 59395181617ULL },   // factor: 17593319284711819919
  { 148095679, 63, 59499782540ULL },   // factor: 17623321391227289321
  { 148510799, 63, 59387935116ULL },   // factor: 17639499390074635369
  { 149391391, 63, 59036627756ULL },   // factor: 17639127880836097193
  { 149216807, 63, 59208172008ULL },   // factor: 17669708750681076913
  { 148646143, 63, 59522765708ULL },   // factor: 17695659086373728489
  { 148763291, 63, 59487064920ULL },   // factor: 17698983098859703441
  { 149121187, 63, 59465359748ULL },   // factor: 17735090062007561753
  { 149532011, 63, 59303655201ULL },   // factor: 17735589643712278423
  { 148293911, 63, 60127063629ULL },   // factor: 17832954844980526039
  { 149003273, 63, 60009893427ULL },   // factor: 17883341066008373143
  { 148171883, 63, 60360623640ULL },   // factor: 17887494527586228241
  { 149094299, 63, 60020572872ULL },   // factor: 17897450475858513457
  { 149780167, 63, 59807657108ULL },   // factor: 17916001739029954073
  { 149319133, 63, 60048400136ULL },   // factor: 17932750092689204177
  { 149810797, 63, 59967641759ULL },   // factor: 17967600412252543847
  { 148087057, 63, 60825485967ULL },   // factor: 18014934414895658239
  { 148334581, 63, 60737447748ULL },   // factor: 18018927725417947177
  { 149706451, 63, 60189441825ULL },   // factor: 18021495446583426151
  { 148067039, 63, 61001458005ULL },   // factor: 18064610522966394391
  { 149669693, 63, 60380487856ULL },   // factor: 18074258161195496417
  { 148349417, 63, 60948274255ULL },   // factor: 18083281905770718671
  { 148184213, 63, 61051164196ULL },   // factor: 18093637438236075497
  { 149468593, 63, 60558311660ULL },   // factor: 18103131276551388761
  { 149772677, 63, 60436636219ULL },   // factor: 18103513590789576527
  { 148794551, 63, 60846818748ULL },   // factor: 18107350150774084297
  { 149347661, 63, 60740020551ULL },   // factor: 18142759996767562423
  { 149531297, 63, 60686619799ULL },   // factor: 18149097938180698607
  { 149315237, 63, 60804998940ULL },   // factor: 18158225655021697561
  { 149906839, 63, 60679914036ULL },   // factor: 18192668207856984409
  { 148007879, 63, 61471673997ULL },   // factor: 18196584173750844727
  { 149006609, 63, 61111210275ULL },   // factor: 18211948429927414951
  { 148723591, 63, 61245377441ULL },   // factor: 18217264930351821263
  { 148000217, 63, 61563646288ULL },   // factor: 18222866019870488993
  { 149216713, 63, 61111367676ULL },   // factor: 18237674823094337977
  { 148857421, 63, 61272016860ULL },   // factor: 18241588818496236121
  { 148699783, 63, 61344339525ULL },   // factor: 18243779951291646151
  { 148610327, 63, 61398090489ULL },   // factor: 18248780609491759807
  { 149703209, 63, 60955901859ULL },   // factor: 18250588231562731063
  { 149306557, 63, 61156726920ULL },   // factor: 18262200667628828881
  { 148464353, 63, 61645469068ULL },   // factor: 18304309361124266009
  { 149615971, 63, 61214360013ULL },   // factor: 18317291824977135247
  { 149904107, 63, 61263633585ULL },   // factor: 18367340568269267191
  { 149796443, 63, 61313090817ULL },   // factor: 18368965827445127863
  { 148953053, 63, 61677297708ULL },   // factor: 18374043588793005049
  { 149732827, 63, 61383576677ULL },   // factor: 18382272934436951759
  { 149272133, 63, 61619142387ULL },   // factor: 18396041635476402943
  { 149790161, 63, 61434691980ULL },   // factor: 18404624805339217561
  { 148223599, 63, 62164309040ULL },   // factor: 18428435230514069921
  { 148705699, 64, 62030240561ULL },   // factor: 18448500563523314279
  { 148281971, 64, 62256970989ULL },   // factor: 18463172733477478639
  { 148914301, 64, 61996498268ULL },   // factor: 18464330408053861337
  { 148306313, 64, 62391551811ULL },   // factor: 18506122022875765687
  { 148969187, 64, 62177722980ULL },   // factor: 18525129683683634521
  { 149854469, 64, 61830188535ULL },   // factor: 18531060142164625831
  { 149363261, 64, 62100244575ULL },   // factor: 18550990077239118151
  { 149892997, 64, 61892583008ULL },   // factor: 18554529518280789953
  { 149228627, 64, 62181900897ULL },   // factor: 18558639390218756839
  { 149617249, 64, 62210889131ULL },   // factor: 18615644179248441239
  { 148890487, 64, 62580683757ULL },   // factor: 18635336962745439319
  { 149885987, 64, 62233868140ULL },   // factor: 18655969501983508361
  { 149400991, 64, 62705045604ULL },   // factor: 18736391907875587129
  { 148268777, 64, 63235992787ULL },   // factor: 18751846625818622999
  { 149606773, 64, 62681225328ULL },   // factor: 18755071698015893089
  { 149072111, 64, 62929193616ULL },   // factor: 18761975471729686753
  { 149607103, 64, 62785250856ULL },   // factor: 18786238983388860337
  { 148728169, 64, 63262671371ULL },   // factor: 18817882558115099399
  { 149946877, 64, 62858809944ULL },   // factor: 18850964486078689777
  { 148392883, 64, 63550038537ULL },   // factor: 18860746866533064343
  { 149663401, 64, 63078369251ULL },   // factor: 18881046543276965303
  { 148170943, 64, 63731883645ULL },   // factor: 18886426597691854471
  { 148594939, 64, 63549443880ULL },   // factor: 18886251473665046641
  { 149242333, 64, 63297834183ULL },   // factor: 18893432894636137879
  { 148881857, 64, 63464390539ULL },   // factor: 18897392633639101847
  { 149439397, 64, 63324675687ULL },   // factor: 18926402699771681479
  { 149275459, 64, 63420528701ULL },   // factor: 18934257063728897519
  { 148469603, 64, 63788218753ULL },   // factor: 18941223028670130119
  { 148739389, 64, 63681189296ULL },   // factor: 18943802373360760289
  { 149843543, 64, 63266927157ULL },   // factor: 18960281039855594503
  { 148379597, 64, 63934923100ULL },   // factor: 18973276247607981401
  { 148125337, 64, 64132057323ULL },   // factor: 18999165206945385703
  { 149234507, 64, 63683048533ULL },   // factor: 19007416704158656463
  { 148005457, 64, 64560163220ULL },   // factor: 19110512922741383081
  { 149610661, 64, 63880396440ULL },   // factor: 19114376672660893681
  { 149807507, 64, 63801983184ULL },   // factor: 19116032084901924577
  { 148052327, 64, 64672442529ULL },   // factor: 19149811218384429967
  { 149166737, 64, 64240706424ULL },   // factor: 19165153119686036977
  { 149229551, 64, 64345898913ULL },   // factor: 19204619206956756127
  { 149985811, 64, 64047840981ULL },   // factor: 19212534744668641183
  { 149517391, 64, 64335710676ULL },   // factor: 19238615216812732633
  { 149834149, 64, 64312335867ULL },   // factor: 19272368229668244367
  { 149936933, 64, 64276542588ULL },   // factor: 19274855318977205209
  { 148722463, 64, 64822561325ULL },   // factor: 19281141956445086951
  { 148940423, 64, 64728649801ULL },   // factor: 19281424963159611647
  { 149500903, 64, 64569031373ULL },   // factor: 19306256992197659639
  { 149236289, 64, 64769702224ULL },   // factor: 19331979999089613473
  { 149794661, 64, 64589549368ULL },   // factor: 19350339303444648497
  { 149427149, 64, 64847937756ULL },   // factor: 19380084914817075289
  { 149460863, 64, 64854396820ULL },   // factor: 19386388236123311321
  { 148120433, 64, 65459586711ULL },   // factor: 19391804655268731727
  { 149981537, 64, 64702427700ULL },   // factor: 19408339108154749801
  { 148723781, 64, 65359064731ULL },   // factor: 19440894458836135823
  { 149649089, 64, 64958381727ULL },   // factor: 19441925296719593407
  { 149101193, 64, 65345847640ULL },   // factor: 19486287681440469041
  { 149685223, 64, 65224572392ULL },   // factor: 19526309327152326833
  { 148140491, 64, 66430141240ULL },   // factor: 19681987480985897681
  { 148766951, 64, 66335227201ULL },   // factor: 19736978989170068303
  { 148240847, 64, 66737031669ULL },   // factor: 19786308201756767287
  { 149838319, 64, 66048585572ULL },   // factor: 19793218068872266937
  { 148393061, 64, 66810535168ULL },   // factor: 19828439641255338497
  { 149357381, 64, 66380152516ULL },   // factor: 19828731460340641193
  { 148832587, 64, 66633740273ULL },   // factor: 19834543892633352503
  { 149790577, 64, 66279482583ULL },   // factor: 19856083878738040783
  { 148460981, 64, 66932119159ULL },   // factor: 19873616141508069959
  { 148879697, 64, 66802105887ULL },   // factor: 19890954566836952479
  { 148934707, 64, 66825530744ULL },   // factor: 19905281682954264017
  { 149488483, 64, 66606339672ULL },   // factor: 19913761351499995153
  { 149612069, 64, 66675059680ULL },   // factor: 19950787258846555841
  { 148443527, 64, 67410747069ULL },   // factor: 20013378105254544727
  { 149033221, 64, 67144417928ULL },   // factor: 20013497751959972177
  { 148346797, 64, 67469231327ULL },   // factor: 20017688726825019239
  { 148792621, 64, 67296615131ULL },   // factor: 20026479499539496703
  { 149420477, 64, 67099915755ULL },   // factor: 20052202837543830271
  { 148975921, 64, 67334795580ULL },   // factor: 20062526373754458361
  { 149170447, 64, 67262897948ULL },   // factor: 20067273106837085513
  { 148222159, 64, 67726014540ULL },   // factor: 20076992191168383721
  { 148065721, 64, 67806035939ULL },   // factor: 20079499198919894039
  { 149632369, 64, 67199454771ULL },   // factor: 20110427225786164999
  { 148845877, 64, 67681314440ULL },   // factor: 20148169208669127761
  { 148169393, 64, 68150572816ULL },   // factor: 20195658013498041377
  { 149985769, 64, 67327628895ULL },   // factor: 20196372389526390511
  { 148485377, 64, 68046041104ULL },   // factor: 20207684133369872417
  { 149056249, 64, 67781364027ULL },   // factor: 20206471747936309447
  { 149231501, 64, 67723348164ULL },   // factor: 20212913798518628329
  { 148916951, 64, 67928263713ULL },   // factor: 20231339837727798127
  { 149614921, 64, 67668324836ULL },   // factor: 20248382149080955913
  { 148887797, 64, 68011831339ULL },   // factor: 20252263475998540367
  { 148286573, 64, 68380129431ULL },   // factor: 20279710109238859927
  { 149002879, 64, 68127156581ULL },   // factor: 20302284937305593399
  { 149504837, 64, 68022892687ULL },   // factor: 20339502966876854039
  { 149178011, 64, 68211889129ULL },   // factor: 20351427893633484839
  { 148976341, 64, 68346473400ULL },   // factor: 20364015054771658801
  { 148623851, 64, 68750654325ULL },   // factor: 20435974009102611151
  { 149702947, 64, 68393196444ULL },   // factor: 20477326124833440937
  { 149417557, 64, 68862882728ULL },   // factor: 20578647410390510993
  { 149658941, 64, 68807962723ULL },   // factor: 20595453666983312687
  { 149876057, 64, 68724456955ULL },   // factor: 20600301255763252871
  { 148676617, 64, 69327787712ULL },   // factor: 20614841882228660609
  { 148036753, 64, 69674255352ULL },   // factor: 20628701060005904113
  { 148816193, 64, 69361012392ULL },   // factor: 20644083613606527313
  { 149851547, 64, 68910289360ULL },   // factor: 20652626929627279841
  { 149424043, 64, 69172869432ULL },   // factor: 20672179632881107153
  { 148561121, 64, 69695549059ULL },   // factor: 20708097793831070279
  { 149208907, 64, 69417382112ULL },   // factor: 20715383423465743169
  { 149005627, 64, 69569507505ULL },   // factor: 20732496171727461271
  { 149526173, 64, 69466151848ULL },   // factor: 20774015677736635409
  { 149663083, 64, 69418417677ULL },   // factor: 20778748813043036383
  { 149016073, 64, 69924774132ULL },   // factor: 20839830493125247273
  { 149483843, 64, 69711963457ULL },   // factor: 20841624401255850503
  { 148243391, 64, 70490872341ULL },   // factor: 20899611900755896663
  { 149938339, 64, 70090701701ULL },   // factor: 21018566784784829279
  { 149677963, 64, 70286724576ULL },   // factor: 21040747520955437377
  { 148440683, 64, 70883088573ULL },   // factor: 21043868161851230719
  { 148434211, 64, 70904965113ULL },   // factor: 21049445105061361687
  { 148906777, 64, 70711419387ULL },   // factor: 21058819116026971399
  { 149971529, 64, 70231577767ULL },   // factor: 21065474203598791487
  { 148067677, 64, 71145743484ULL },   // factor: 21068769932227533337
  { 149134187, 64, 70672923265ULL },   // factor: 21079497908078321111
  { 148112621, 64, 71314105071ULL },   // factor: 21125038032670402183
  { 148036849, 64, 71417365335ULL },   // factor: 21144803456150458831
  { 149697943, 64, 70688170268ULL },   // factor: 21163747367106717449
  { 148568183, 64, 71306283252ULL },   // factor: 21187689878465942233
  { 148743347, 64, 71271229108ULL },   // factor: 21202242324655488953
  { 149030461, 64, 71190288483ULL },   // factor: 21219043022688961327
  { 148545811, 64, 71495332985ULL },   // factor: 21240664441943751671
  { 149777809, 64, 70934206107ULL },   // factor: 21248739947721759127
  { 149239999, 64, 71274576785ULL },   // factor: 21274035536237646431
  { 149519407, 64, 71195572284ULL },   // factor: 21290239497858631177
  { 148258597, 64, 71870675147ULL },   // factor: 21310890925473977519
  { 148905257, 64, 71561432607ULL },   // factor: 21311747027267029999
  { 149647807, 64, 71331828372ULL },   // factor: 21349303370340360409
  { 148516033, 64, 71892060512ULL },   // factor: 21354247262876377793
  { 148813661, 64, 71782671651ULL },   // factor: 21364484329492448623
  { 148661189, 64, 71864064331ULL },   // factor: 21366794499637899119
  { 148443707, 64, 72239576800ULL },   // factor: 21447021144606395201
  { 148629821, 64, 72315639939ULL },   // factor: 21496521239268041839
  { 149530987, 64, 71945224572ULL },   // factor: 21516080880375625129
  { 149265887, 64, 72237907732ULL },   // factor: 21565310745282276569
  { 148803037, 64, 72517396008ULL },   // factor: 21581617522644152593
  { 149456057, 64, 72343753635ULL },   // factor: 21624424333733034391
  { 149955361, 64, 72160277600ULL },   // factor: 21641640954736427201
  { 149005601, 64, 72778073235ULL },   // factor: 21688681084006378471
  { 149124589, 64, 72825553500ULL },   // factor: 21720161468770023001
  { 148543009, 64, 73157470640ULL },   // factor: 21734061639389511521
  { 149479961, 64, 72777990808ULL },   // factor: 21757702455276396977
  { 149554469, 64, 72801648000ULL },   // factor: 21775623617929824001
  { 148606123, 64, 73312756797ULL },   // factor: 21789449108088136063
  { 149393863, 64, 72972282380ULL },   // factor: 21803222313350067881
  { 148426463, 64, 73551690288ULL },   // factor: 21834034474238582689
  { 148150181, 64, 73753424731ULL },   // factor: 21853166446535052623
  { 149537473, 64, 73089547827ULL },   // factor: 21859252569524442343
  { 148912039, 64, 73455342957ULL },   // factor: 21876769790342318647
  { 149827663, 64, 73094785968ULL },   // factor: 21903241918141265569
  { 149250091, 64, 73494332924ULL },   // factor: 21938071753782592169
  { 148347091, 64, 74034499901ULL },   // factor: 21965605387906275983
  { 149020187, 64, 73711565680ULL },   // factor: 21969022603392764321
  { 148459709, 64, 74042084184ULL },   // factor: 21984532543420284913
  { 149928529, 64, 73393438212ULL },   // factor: 22007540458755100297
  { 149825153, 64, 73450578900ULL },   // factor: 22009488443262143401
  { 148216643, 64, 74445799633ULL },   // factor: 22068213014107784039
  { 148630171, 64, 74367212265ULL },   // factor: 22106422951480494631
  { 148900811, 64, 74232350509ULL },   // factor: 22106514386452725599
  { 148262837, 64, 74570185332ULL },   // factor: 22111974465876213769
  { 148842359, 64, 74284429512ULL },   // factor: 22113339451070597617
  { 149846497, 64, 73795590348ULL },   // factor: 22116021415389621913
  { 148304309, 64, 74651768856ULL },   // factor: 22142357991633601009
  { 149228543, 64, 74305709205ULL },   // factor: 22177065442487676631
  { 148179007, 64, 74896459164ULL },   // factor: 22196165893475140297
  { 148357303, 64, 75014826537ULL },   // factor: 22257994700084299423
  { 148487497, 64, 74984365092ULL },   // factor: 22268481373290509449
  { 149460557, 64, 74508031183ULL },   // factor: 22272023683169097863
  { 148946683, 64, 74891744181ULL },   // factor: 22309753759689003247
  { 149492501, 64, 74647113019ULL },   // factor: 22318367235279941039
  { 148148179, 64, 75369848312ULL },   // factor: 22331811557858047697
  { 149882903, 64, 74498719801ULL },   // factor: 22332168787114924607
  { 148842509, 64, 75240271155ULL },   // factor: 22397901473101055791
  { 148588553, 64, 75388723767ULL },   // factor: 22403802754110478303
  { 148413953, 64, 75490539711ULL },   // factor: 22407698825225975167
  { 148115027, 64, 75717035200ULL },   // factor: 22429661426015900801
  { 149872781, 64, 74855752491ULL },   // factor: 22437679599347694943
  { 149230489, 64, 75361240811ULL },   // factor: 22492389635744573159
  { 149925071, 64, 75023629968ULL },   // factor: 22495846099260255457
  { 149006101, 64, 75498704876ULL },   // factor: 22499535288244896953
  { 149361161, 64, 75331671000ULL },   // factor: 22503251681260062001
  { 149595041, 64, 75254339068ULL },   // factor: 22515351876610723577
  { 149689987, 64, 75208052412ULL },   // factor: 22515784775695197289
  { 148801613, 64, 75664834776ULL },   // factor: 22518098924094587377
  { 149916779, 64, 75100357720ULL },   // factor: 22517607462260367761
  { 148376897, 64, 75956866788ULL },   // factor: 22540488399691593673
  { 149477423, 64, 75403287888ULL },   // factor: 22542178318450705249
  { 148732781, 64, 75811847544ULL },   // factor: 22551413835934279729
  { 148547813, 64, 75961938247ULL },   // factor: 22567959595665807623
  { 148672301, 64, 75932689575ULL },   // factor: 22578175360467924151
  { 148735183, 64, 75904129128ULL },   // factor: 22579229072617420849
  { 148551133, 64, 76010379828ULL },   // factor: 22582856086419490249
  { 148835761, 64, 76021189820ULL },   // factor: 22629343277970306041
  { 148405133, 64, 76289980600ULL },   // factor: 22643649435020839601
  { 149475089, 64, 75952211955ULL },   // factor: 22705927283440977991
  { 149623363, 64, 75883644185ULL },   // factor: 22707932079310188311
  { 148496167, 64, 76714157984ULL },   // factor: 22783516830512894657
  { 148731229, 64, 76773061787ULL },   // factor: 22837103667346892447
  { 149905871, 64, 76277315385ULL },   // factor: 22868834800660250671
  { 148920389, 64, 76947292255ULL },   // factor: 22918041390222574391
  { 149964629, 64, 76520454579ULL },   // factor: 22950723163702172383
  { 148978937, 64, 77101884244ULL },   // factor: 22973113510736337257
  { 148687589, 64, 77322575980ULL },   // factor: 22993814795471024441
  { 148556831, 64, 77662565749ULL },   // factor: 23074609310001162839
  { 149683459, 64, 77084419184ULL },   // factor: 23076524996934154913
  { 149074111, 64, 77456478440ULL },   // factor: 23093511329267333681
  { 148611607, 64, 78024310025ULL },   // factor: 23190636195762920351
  { 149150347, 64, 77768398332ULL },   // factor: 23198367193704042409
  { 149426261, 64, 77771093739ULL },   // factor: 23242087502598559759
  { 149053039, 64, 78033406661ULL },   // factor: 23262232812689785559
  { 148496069, 64, 78521344804ULL },   // factor: 23320222071975150953
  { 149014351, 64, 78396696285ULL },   // factor: 23364465634906772071
  { 148243129, 64, 78845560955ULL },   // factor: 23376625327458856391
  { 148874293, 64, 78550048772ULL },   // factor: 23388165952094036393
  { 148285789, 64, 79120425284ULL },   // factor: 23464869378506978153
  { 149182729, 64, 78654434856ULL },   // factor: 23467766479541604049
  { 149412113, 64, 78577930492ULL },   // factor: 23480989259953699193
  { 149571449, 64, 78515881635ULL },   // factor: 23487468371318878231
  { 149873849, 64, 78374562112ULL },   // factor: 23492594574830018177
  { 149099183, 64, 78856091352ULL },   // factor: 23514757590313130833
  { 149567723, 64, 78722852712ULL },   // factor: 23548795656396429553
  { 148344241, 64, 79384919651ULL },   // factor: 23552591304947159783
  { 149363101, 64, 78842343984ULL },   // factor: 23552273975117868769
  { 149562341, 64, 78751061823ULL },   // factor: 23556386324967215287
  { 149705461, 64, 78678870783ULL },   // factor: 23557313243056891927
  { 148613909, 64, 79463483116ULL },   // factor: 23618757697248520889
  { 149229107, 64, 79209940389ULL },   // factor: 23640857339547405247
  { 149723689, 64, 79160977587ULL },   // factor: 23704547178343916887
  { 148905377, 64, 79638667363ULL },   // factor: 23717251574930221703
  { 148356787, 64, 79945784808ULL },   // factor: 23720999536616583793
  { 148844191, 64, 79778925680ULL },   // factor: 23749259303377449761
  { 148454437, 64, 80006236527ULL },   // factor: 23754561600209240599
  { 149622703, 64, 79569810200ULL },   // factor: 23810900158641941201
  { 148922597, 64, 80023774435ULL },   // factor: 23834696621204815391
  { 148066661, 64, 80548533931ULL },   // factor: 23853104935216748783
  { 149416433, 64, 79838460807ULL },   // factor: 23858356059984482863
  { 148464373, 64, 80589071231ULL },   // factor: 23929211861925506327
  { 148251907, 64, 80898468464ULL },   // factor: 23986704446334721697
  { 148854617, 64, 80610954703ULL },   // factor: 23998625576638827503
  { 148810873, 64, 80950468680ULL },   // factor: 24092619828059915281
  { 149987093, 64, 80312964120ULL },   // factor: 24091816037144206321
  { 148227649, 64, 81407975031ULL },   // factor: 24133825497391664239
  { 149255009, 64, 80971454647ULL },   // factor: 24170790384162153647
  { 148695929, 64, 81283343400ULL },   // factor: 24173004518178037201
  { 148437173, 64, 81470382336ULL },   // factor: 24186466474369952257
  { 148901503, 64, 81261739593ULL },   // factor: 24199990323584616559
  { 149128717, 64, 81186084735ULL },   // factor: 24214353309567669991
  { 149642029, 64, 80993804756ULL },   // factor: 24240154560235379849
  { 149161861, 64, 81273079535ULL },   // factor: 24245687585283229271
  { 148680523, 64, 81549914745ULL },   // factor: 24249767949784023271
  { 149701463, 64, 81360191401ULL },   // factor: 24359479365379439327
  { 149804003, 64, 81438218217ULL },   // factor: 24399542172188245303
  { 148618439, 64, 82141365384ULL },   // factor: 24415443001397431153
  { 149178619, 64, 81900117077ULL },   // factor: 24435492722970353327
  { 148609673, 64, 82226742940ULL },   // factor: 24439378760336917241
  { 149554879, 64, 81790048124ULL },   // factor: 24464201501177993993
  { 148698373, 64, 82302480623ULL },   // factor: 24476489925008252759
  { 149166257, 64, 82063045372ULL },   // factor: 24482074632324825209
  { 149979623, 64, 81656233413ULL },   // factor: 24493542205763486599
  { 148625881, 64, 82450543676ULL },   // factor: 24508569385548957113
  { 149957371, 64, 81718281284ULL },   // factor: 24508517247974288729
  { 149891009, 64, 81767341455ULL },   // factor: 24512378627874956191
  { 149497351, 64, 82289797628ULL },   // factor: 24604213519424166857
  { 149597321, 64, 82270485211ULL },   // factor: 24614888369871439463
  { 148098151, 64, 83179979160ULL },   // factor: 24637602227629066321
  { 149135783, 64, 82621635076ULL },   // factor: 24643684479599049017
  { 149375299, 64, 82645346709ULL },   // factor: 24690346751231081983
  { 149210417, 64, 82762660207ULL },   // factor: 24698102083031552639
  { 148721737, 64, 83107470212ULL },   // factor: 24719774655208796489
  { 149018627, 64, 82972169112ULL },   // factor: 24728797440564098449
  { 149815597, 64, 82646380595ULL },   // factor: 24763433697458280431
  { 148155661, 64, 83657746868ULL },   // factor: 24788737569998439497
  { 149141261, 64, 83154896043ULL },   // factor: 24803652108353860447
  { 149745749, 64, 82933475007ULL },   // factor: 24837870664191990487
  { 148479809, 64, 83800440931ULL },   // factor: 24885346927101324359
  { 148659677, 64, 83792209983ULL },   // factor: 24913045742377910983
  { 149915879, 64, 83138651580ULL },   // factor: 24927608060980877641
  { 148815883, 64, 83771094548ULL },   // factor: 24932938810074211769
  { 149089253, 64, 83624435028ULL },   // factor: 24935009101743108169
  { 149651093, 64, 83461808476ULL },   // factor: 24980301724380128537
  { 148647307, 64, 84028339832ULL },   // factor: 24981172855415264849
  { 149745989, 64, 83416720735ULL },   // factor: 24982638691198763831
  { 149510539, 64, 83651401232ULL },   // factor: 25013532172603168097
  { 148987079, 64, 83946725140ULL },   // factor: 25013954740448932121
  { 149222611, 64, 83819828885ULL },   // factor: 25015627439585837471
  { 149686877, 64, 83579642403ULL },   // factor: 25021551304163690863
  { 149892683, 64, 83520260145ULL },   // factor: 25038151755984038071
  { 148668367, 64, 84301003628ULL },   // factor: 25065785091671670953
  { 148057667, 64, 84716273853ULL },   // factor: 25085787727216561903
  { 149113271, 64, 84229524465ULL },   // factor: 25119479815501350031
  { 149509603, 64, 84042596840ULL },   // factor: 25130350577274909041
  { 148665763, 64, 84596121420ULL },   // factor: 25153093875489886921
  { 148160231, 64, 84950199085ULL },   // factor: 25172482239859177271
  { 148015213, 64, 85149669603ULL },   // factor: 25206892966335340879
  { 149626481, 64, 84414418963ULL },   // factor: 25261264910186718407
  { 148759459, 64, 84918640689ULL },   // factor: 25264902095822054503
  { 149365663, 64, 84582812625ULL },   // factor: 25267535772275790751
  { 149527247, 64, 84514840084ULL },   // factor: 25274542736811537497
  { 149788957, 64, 84372362723ULL },   // factor: 25276096423807699823
  { 149564581, 64, 84648143555ULL },   // factor: 25320728246462850911
  { 148715129, 64, 85361071324ULL },   // factor: 25388965467053721593
  { 149132779, 64, 85459247072ULL },   // factor: 25489550014189946177
  { 149917039, 64, 85153696449ULL },   // factor: 25531980063077789023
  { 149025059, 64, 85906525069ULL },   // factor: 25604449933785408143
  { 149389661, 64, 85764194643ULL },   // factor: 25624567927311572047
  { 149172523, 64, 86056459025ULL },   // factor: 25674518226410740151
  { 148273849, 64, 86657164172ULL },   // factor: 25697982550414676057
  { 148622189, 64, 86664053535ULL },   // factor: 25760402687969776231
  { 149336003, 64, 86403445380ULL },   // factor: 25806290356956032281
  { 149486801, 64, 86423054248ULL },   // factor: 25838211824365961297
  { 149558749, 64, 86395553535ULL },   // factor: 25842421811714255431
  { 148201057, 64, 87235963788ULL },   // factor: 25856924083590647833
  { 148168789, 64, 87312119112ULL },   // factor: 25873861907697590737
  { 148977539, 64, 86904960777ULL },   // factor: 25893774366897975607
  { 148074887, 64, 87630577864ULL },   // factor: 25951775829913002737
  { 148130249, 64, 88127603115ULL },   // factor: 26108727586396251271
  { 149239609, 64, 87577057619ULL },   // factor: 26139931672860061943
  { 149823787, 64, 87310500713ULL },   // factor: 26162379723375720263
  { 149985379, 64, 87253539584ULL },   // factor: 26173510407195484673
  { 148632457, 64, 88140918504ULL },   // factor: 26201202558972568657
  { 149410267, 64, 87896317760ULL },   // factor: 26265224609676883841
  { 148493053, 64, 88528492895ULL },   // factor: 26291732374934716871
  { 148278289, 64, 88675736351ULL },   // factor: 26297372923882766879
  { 148355371, 64, 88779761528ULL },   // factor: 26341908917555933777
  { 149522441, 64, 88223939340ULL },   // factor: 26382917529505457881
  { 149722879, 64, 88148944281ULL },   // factor: 26395827437123809999
  { 148201219, 64, 89148045824ULL },   // factor: 26423698125169318913
  { 148270403, 64, 89188608801ULL },   // factor: 26448061939867233607
  { 149533763, 64, 88551567525ULL },   // factor: 26482898223123693151
  { 148705079, 64, 89048302281ULL },   // factor: 26483869651023970399
  { 148818409, 64, 89014133727ULL },   // factor: 26493883519530760687
  { 149251633, 64, 88791015392ULL },   // factor: 26504408085968270273
  { 148689469, 64, 89293420556ULL },   // factor: 26553982575330649529
  { 149201209, 64, 89046633876ULL },   // factor: 26571730863359112169
  { 148305383, 64, 89934800088ULL },   // factor: 26675629944158547409
  { 148217779, 64, 90088148036ULL },   // factor: 26705330432238264089
  { 149814787, 64, 89175945977ULL },   // factor: 26719750704135523799
  { 149921689, 64, 89161105712ULL },   // factor: 26734367122901175137
  { 148226599, 64, 90248516157ULL },   // factor: 26754461229497320087
  { 148275961, 64, 90306021668ULL },   // factor: 26780424293819045897
  { 148842271, 64, 89993352993ULL },   // factor: 26789630068765534207
  { 148893959, 64, 90279970417ULL },   // factor: 26884284427580021807
  { 149228987, 64, 90088513453ULL },   // factor: 26887635205854124223
  { 149635711, 64, 89861339001ULL },   // factor: 26892930705653329423
  { 148775581, 64, 90534515168ULL },   // factor: 26938650189345025217
  { 149605303, 64, 90146440892ULL },   // factor: 26972771208038500553
  { 148063987, 64, 91160621153ULL },   // factor: 26995210050619434023
  { 149067151, 64, 90626289428ULL },   // factor: 27018805541466759257
  { 149967667, 64, 90191908545ULL },   // factor: 27051740213542029031
  { 148132729, 64, 91388764772ULL },   // factor: 27075334251230845577
  { 149319083, 64, 90669663532ULL },   // factor: 27077422029033562313
  { 149237923, 64, 90743192952ULL },   // factor: 27084651285089437393
  { 149725267, 64, 90556702469ULL },   // factor: 27117252911621168447
  { 148270393, 64, 91537211727ULL },   // factor: 27144516713772997423
  { 148844603, 64, 91209303948ULL },   // factor: 27152025272092785289
  { 149472241, 64, 90896351916ULL },   // factor: 27172962839218327513
  { 148476187, 64, 91716574152ULL },   // factor: 27235454429583436849
  { 148021099, 64, 92079154317ULL },   // factor: 27259315233985868767
  { 149759587, 64, 91310280632ULL },   // factor: 27349179832604837969
  { 149619011, 64, 91414156585ULL },   // factor: 27354591399293674871
  { 149661797, 64, 91523531247ULL },   // factor: 27395152308423341719
  { 149949403, 64, 91544078333ULL },   // factor: 27453959788437170399
  { 148236937, 64, 92720286023ULL },   // factor: 27489142395626863103
  { 148603937, 64, 92497450863ULL },   // factor: 27490970721411695263
  { 148657357, 64, 92621529540ULL },   // factor: 27537743565427651561
  { 148131859, 64, 92960285441ULL },   // factor: 27540759791091929639
  { 148761511, 64, 92581976336ULL },   // factor: 27545269382219207393
  { 149504093, 64, 92214464083ULL },   // factor: 27572879628419983439
  { 148268737, 64, 93199305924ULL },   // factor: 27637086757256195977
  { 149818091, 64, 92244015129ULL },   // factor: 27639644505603797479
  { 148783049, 64, 92956808676ULL },   // factor: 27660794840249866249
  { 148972897, 64, 92855598159ULL },   // factor: 27665934920828193247
  { 149583023, 64, 92575637025ULL },   // factor: 27695487284700453151
  { 148194073, 64, 93498290867ULL },   // factor: 27711785084238862583
  { 148607477, 64, 93316641528ULL },   // factor: 27735101319179009713
  { 149199109, 64, 92946064571ULL },   // factor: 27734940038099334479
  { 149941691, 64, 92538199068ULL },   // factor: 27750668100701087977
  { 148289111, 64, 93612518013ULL },   // factor: 27763434149238512887
  { 149722303, 64, 93049996533ULL },   // factor: 27863319550125550999
  { 148654531, 64, 93733955021ULL },   // factor: 27867954244843700303
  { 149234333, 64, 93454027720ULL },   // factor: 27893098985915421521
  { 148478887, 64, 94031157573ULL },   // factor: 27923283239521322503
  { 148478779, 64, 94045335125ULL },   // factor: 27927473060011624751
  { 148890979, 64, 93846235605ULL },   // factor: 27945715789386214591
  { 149260571, 64, 93620371213ULL },   // factor: 27947660128968685247
  { 149305861, 64, 93623601596ULL },   // factor: 27957104892423508313
  { 148552793, 64, 94178362456ULL },   // factor: 27980917566010279217
  { 148335323, 64, 94371760545ULL },   // factor: 27997331165042462071
  { 148013053, 64, 94777054752ULL },   // factor: 28056482456383355713
  { 149962577, 64, 93567061287ULL },   // factor: 28063115265830913199
  { 148879817, 64, 94262144808ULL },   // factor: 28067461738085080273
  { 148424401, 64, 94554556679ULL },   // factor: 28068406873802248559
  { 148240711, 64, 94748926748ULL },   // factor: 28091296535220875657
  { 148380307, 64, 94818968628ULL },   // factor: 28138535348892017593
  { 149554591, 64, 94088815973ULL },   // factor: 28142828781032564087
  { 149284673, 64, 94265130528ULL },   // factor: 28144678372349594689
  { 149138777, 64, 94421731903ULL },   // factor: 28163883236470605263
  { 149477591, 64, 94246663273ULL },   // factor: 28175528371672430687
  { 148279099, 64, 95171515569ULL },   // factor: 28223893158071584663
  { 149590951, 64, 94340424900ULL },   // factor: 28224947757070159801
  { 148767139, 64, 95010060936ULL },   // factor: 28268749883328764209
  { 148001257, 64, 95504395080ULL },   // factor: 28269541041729231121
  { 149715827, 64, 94434255253ULL },   // factor: 28276605244663978463
  { 148644497, 64, 95216547759ULL },   // factor: 28306831695426064447
  { 149638523, 64, 94659300853ULL },   // factor: 28329355935711120239
  { 149707567, 64, 94622912517ULL },   // factor: 28331532030747832279
  { 149918423, 64, 94750414812ULL },   // factor: 28409665534421762953
  { 148856249, 64, 95492514679ULL },   // factor: 28429315085386758143
  { 149943671, 64, 94802259036ULL },   // factor: 28429997477901522313
  { 149808817, 64, 94893737880ULL },   // factor: 28431837225021775921
  { 149161603, 64, 95405278637ULL },   // factor: 28461608592313150223
  { 148947713, 64, 95859582063ULL },   // factor: 28556131034839343839
  { 149020681, 64, 95922081476ULL },   // factor: 28588747808982010313
  { 148243817, 64, 96549844567ULL },   // factor: 28625834978737584479
  { 149628541, 64, 95721544491ULL },   // factor: 28645350088909835263
  { 149357267, 64, 95948041804ULL },   // factor: 28661074595694379337
  { 148848853, 64, 96491523116ULL },   // factor: 28725305080079171897
  { 149189861, 64, 96277023475ULL },   // factor: 28727111499457973951
  { 149146997, 64, 96368195052ULL },   // factor: 28746053796632117689
  { 149230789, 64, 96341205816ULL },   // factor: 28754148314266137649
  { 149735771, 64, 96092074648ULL },   // factor: 28776841768815667217
  { 148345541, 64, 97002562183ULL },   // factor: 28779795130846552007
  { 148129357, 64, 97254632147ULL },   // factor: 28812532250413278959
  { 148722967, 64, 96897162285ULL },   // factor: 28821666937811399191
  { 148532887, 64, 97061311892ULL },   // factor: 28833593742652384409
  { 148365559, 64, 97285564560ULL },   // factor: 28867654337149978081
  { 149386331, 64, 96635609145ULL },   // factor: 28872078188243193991
  { 148613693, 64, 97144888968ULL },   // factor: 28874121411218877649
  { 148760543, 64, 97204153017ULL },   // factor: 28920285169328016463
  { 149968277, 64, 96432449428ULL },   // factor: 28923616575213591113
  { 148808563, 64, 97191243188ULL },   // factor: 28925778469979637689
  { 148510841, 64, 97485223503ULL },   // factor: 28955225055006992047
  { 148141327, 64, 97756532912ULL },   // factor: 28963565017005708449
  { 148512313, 64, 97526227455ULL },   // factor: 28967691235012306831
  { 148068469, 64, 97910613164ULL },   // factor: 28994949180089451833
  { 148790023, 64, 97527196028ULL },   // factor: 29022147480263257289
  { 149121859, 64, 97350062744ULL },   // factor: 29034044660303842193
  { 148629101, 64, 97722107959ULL },   // factor: 29048698107542229719
  { 149600083, 64, 97167265988ULL },   // factor: 29072462113375754009
  { 149976473, 64, 96933934383ULL },   // factor: 29075619185551542319
  { 149481083, 64, 97340094820ULL },   // factor: 29101005586032580121
  { 149526341, 64, 97362873231ULL },   // factor: 29116628366956555543
  { 148551031, 64, 98022062288ULL },   // factor: 29122556827257237857
  { 148041601, 64, 98430989799ULL },   // factor: 29143762635717256399
  { 149767967, 64, 97458965772ULL },   // factor: 29192462339190051049
  { 149938021, 64, 97344262019ULL },   // factor: 29191212005668648799
  { 148732663, 64, 98168080476ULL },   // factor: 29201600061587575177
  { 148067527, 64, 98619934980ULL },   // factor: 29204819770778788921
  { 148592567, 64, 98412600984ULL },   // factor: 29246762010718571857
  { 148106249, 64, 98832965544ULL },   // factor: 29275559608536168913
  { 148310189, 64, 98764234455ULL },   // factor: 29295484556922723991
  { 149119891, 64, 98398694333ULL },   // factor: 29346405146958555407
  { 149037319, 64, 98642919044ULL },   // factor: 29402952385303606073
  { 148030667, 64, 99416882104ULL },   // factor: 29433494737830966737
  { 149382469, 64, 98534491640ULL },   // factor: 29438651285686118321
  { 148825139, 64, 99056867016ULL },   // factor: 29484304005121430449
  { 148073803, 64, 99974613177ULL },   // factor: 29607242353144604263
  { 149084161, 64, 99389415444ULL },   // factor: 29634775227498364969
  { 149691263, 64, 99140345136ULL },   // factor: 29680886955327493537
  { 148087879, 64, 100403026460ULL },   // factor: 29736942467284556681
  { 149086747, 64, 99781547660ULL },   // factor: 29752212702509724041
  { 149690743, 64, 99434044421ULL },   // factor: 29768711977748989607
  { 148908989, 64, 100001133880ULL },   // factor: 29782135489848894641
  { 149212867, 64, 99843801692ULL },   // factor: 29795959805285541929
  { 148968109, 64, 100040809556ULL },   // factor: 29805780444772899209
  { 149331521, 64, 99924713448ULL },   // factor: 29843818889357988817
  { 148575227, 64, 100478190613ULL },   // factor: 29857139957751488303
  { 148381733, 64, 100728222655ULL },   // factor: 29892456479117522231
  { 149749037, 64, 99944437128ULL },   // factor: 29933166426850091473
  { 149489297, 64, 100217592072ULL },   // factor: 29962914771752106769
  { 148306337, 64, 101187683332ULL },   // factor: 30013549328969749769
  { 149550677, 64, 100386758484ULL },   // factor: 30025815386235387337
  { 148210331, 64, 101345896629ULL },   // factor: 30041017769751748399
  { 148632493, 64, 101172452907ULL },   // factor: 30075027796985014303
  { 148301107, 64, 101438926260ULL },   // factor: 30087010114498739641
  { 149718277, 64, 100620486744ULL },   // factor: 30129451812426040177
  { 148075181, 64, 101751882099ULL },   // factor: 30133856717800169839
  { 149186501, 64, 101041077768ULL },   // factor: 30147929698953619537
  { 148620421, 64, 101730214991ULL },   // factor: 30238374760765862423
  { 149813791, 64, 100973064381ULL },   // factor: 30254315127609356743
  { 148944883, 64, 101579942741ULL },   // factor: 30259625373409888607
  { 149627473, 64, 101339766627ULL },   // factor: 30326426389615487143
  { 148836901, 64, 102056013231ULL },   // factor: 30379401475434074263
  { 148160179, 64, 103025249732ULL },   // factor: 30528478883625644057
  { 148442101, 64, 102840278163ULL },   // factor: 30531653915880280927
  { 148234943, 64, 103018205572ULL },   // factor: 30541795661855404793
  { 149452181, 64, 102261939843ULL },   // factor: 30566539885654295167
  { 148949011, 64, 102643169928ULL },   // factor: 30577197293361082417
  { 148438259, 64, 103143387505ULL },   // factor: 30620849737209107591
  { 149564117, 64, 102446744467ULL },   // factor: 30644713751462981279
  { 148646741, 64, 103284709744ULL },   // factor: 30705870997153088609
  { 148121209, 64, 103658167407ULL },   // factor: 30707946158098470127
  { 149755147, 64, 102666680244ULL },   // factor: 30749727583884431737
  { 148439101, 64, 103657366620ULL },   // factor: 30773612626200417241
  { 148833241, 64, 103440896043ULL },   // factor: 30790887620047530727
  { 148991971, 64, 103536136113ULL },   // factor: 30852105978400297447
  { 149030521, 64, 103552877448ULL },   // factor: 30865078554249180817
  { 149898643, 64, 102953263325ULL },   // factor: 30865108929678335951
  { 148234123, 64, 104113293165ULL },   // factor: 30866285409911338591
  { 148511053, 64, 103980237456ULL },   // factor: 30884429111561202337
  { 148405879, 64, 104065460801ULL },   // factor: 30887852367424898159
  { 148932037, 64, 103700652260ULL },   // factor: 30888698758620907241
  { 149249773, 64, 103613583828ULL },   // factor: 30928607732090942089
  { 148263131, 64, 104441926189ULL },   // factor: 30969773968904075519
  { 149881733, 64, 103341095496ULL },   // factor: 30977884966117949137
  { 148694983, 64, 104191809873ULL },   // factor: 30985598795609934319
  { 149119561, 64, 103974641516ULL },   // factor: 31009305795996588953
  { 148937149, 64, 104221868951ULL },   // factor: 31045016050027121399
  { 148365787, 64, 104634988944ULL },   // factor: 31048504964825717857
  { 148952983, 64, 104329238112ULL },   // factor: 31080302461799376193
  { 148309453, 64, 104794149456ULL },   // factor: 31083925966839215137
  { 148691167, 64, 104566758444ULL },   // factor: 31096306684890928297
  { 149070497, 64, 104374782304ULL },   // factor: 31118401344648170177
  { 148829861, 64, 104566798848ULL },   // factor: 31125324275525600257
  { 148284821, 64, 105139934308ULL },   // factor: 31181312677627077737
  { 148967557, 64, 105025465364ULL },   // factor: 31290773996126391497
  { 149635261, 64, 104608931391ULL },   // factor: 31306369503246756103
  { 148657963, 64, 105307740708ULL },   // factor: 31309668443566915609
  { 149765621, 64, 104527629063ULL },   // factor: 31309290556555686247
  { 148074457, 64, 105762051212ULL },   // factor: 31321316608846183769
  { 149188177, 64, 105023916864ULL },   // factor: 31336653396679433857
  { 148695887, 64, 105532743400ULL },   // factor: 31384569774812791601
  { 149890927, 64, 104702243984ULL },   // factor: 31387832819483866337
  { 149198353, 64, 105561083571ULL },   // factor: 31499079619377117127
  { 148785937, 64, 105880973612ULL },   // factor: 31507199738667388889
  { 148212541, 64, 106645859271ULL },   // factor: 31612507579366635223
  { 149360747, 64, 105822143353ULL },   // factor: 31611348760690329383
  { 148083979, 64, 106773787937ULL },   // factor: 31622974741226322647
  { 148467763, 64, 106565188925ULL },   // factor: 31642990426734249551
  { 148223557, 64, 106807447500ULL },   // factor: 31662759565081515001
  { 148875949, 64, 106338642464ULL },   // factor: 31662532624399396673
  { 149709401, 64, 106404342771ULL },   // factor: 31859460840090180343
  { 149512703, 64, 106673295180ULL },   // factor: 31898025400557343081
  { 148209023, 64, 107686831668ULL },   // factor: 31920320222959480729
  { 148838059, 64, 107234755556ULL },   // factor: 31921225748589011609
  { 148941049, 64, 107185244579ULL },   // factor: 31928565529835646743
  { 148125821, 64, 107811058360ULL },   // factor: 31939203064907827121
  { 149623769, 64, 106795482619ULL },   // factor: 31958285243257542023
  { 149650649, 64, 106803072196ULL },   // factor: 31966298138650510409
  { 149726323, 64, 107005458921ULL },   // factor: 32043067810337754967
  { 149433719, 64, 107283439380ULL },   // factor: 32063526667328908441
  { 149347687, 64, 107360630889ULL },   // factor: 32068123796265807487
  { 148250129, 64, 108195089259ULL },   // factor: 32079871879626528823
  { 148885511, 64, 107815342276ULL },   // factor: 32104284656804326073
  { 149216273, 64, 107642977123ULL },   // factor: 32124167721836645159
  { 148849223, 64, 108199566037ULL },   // factor: 32210842667089278503
  { 148689773, 64, 108357232311ULL },   // factor: 32223224550461710807
  { 149003633, 64, 108165550011ULL },   // factor: 32234119834164379927
  { 148751263, 64, 108423735696ULL },   // factor: 32256335247916368097
  { 149486101, 64, 107895010356ULL },   // factor: 32257608830946123913
  { 149196907, 64, 108215868068ULL },   // factor: 32290945608131331353
  { 148817437, 64, 108510562764ULL },   // factor: 32296527675932231737
  { 148319291, 64, 109006402180ULL },   // factor: 32335504571596908761
  { 149746991, 64, 108036505105ULL },   // factor: 32356283115259778111
  { 149039999, 64, 108662506192ULL },   // factor: 32390119628386347617
  { 149828183, 64, 108122511337ULL },   // factor: 32399598830039221343
  { 149938471, 64, 108042370173ULL },   // factor: 32399415573911250967
  { 148066463, 64, 109517295345ULL },   // factor: 32431677118121029471
  { 148001801, 64, 109741942476ULL },   // factor: 32484010263372798553
  { 148015057, 64, 109820554152ULL },   // factor: 32510191165159733329
  { 149886941, 64, 108749634448ULL },   // factor: 32600300084557887137
  { 149604019, 64, 108959502116ULL },   // factor: 32601558849585208409
  { 148824469, 64, 109634400131ULL },   // factor: 32632562767259210879
  { 148736491, 64, 109712855741ULL },   // factor: 32636610361011089663
  { 148049659, 64, 110526804297ULL },   // factor: 32726911373061169447
  { 148933847, 64, 109867062097ULL },   // factor: 32725848433388194319
  { 149114843, 64, 109766662396ULL },   // factor: 32735677259627087657
  { 148234421, 64, 110694313956ULL },   // factor: 32817415074519758953
  { 148923949, 64, 110227974180ULL },   // factor: 32831170410311273641
  { 148629233, 64, 110464990036ULL },   // factor: 32836653484806644777
  { 148850677, 64, 110377611855ULL },   // factor: 32859564500519951671
  { 148199179, 64, 110978495604ULL },   // factor: 32893843870335818233
  { 149250727, 64, 110255425544ULL },   // factor: 32911404836272740977
  { 148972489, 64, 110506808699ULL },   // factor: 32924948686673763623
  { 149566397, 64, 110088345283ULL },   // factor: 32931034311340510703
  { 148113913, 64, 111198703287ULL },   // factor: 32940150128727064063
  { 148654141, 64, 110806730595ULL },   // factor: 32943758707236287791
  { 149993527, 64, 110026552184ULL },   // factor: 33006541251455425937
  { 149311271, 64, 110610154168ULL },   // factor: 33030685408660055057
  { 148499903, 64, 111266146732ULL },   // factor: 33046023993771533993
  { 149993917, 64, 110175696855ULL },   // factor: 33051368658972062071
  { 149156753, 64, 110883954732ULL },   // factor: 33078181295248210393
  { 148007399, 64, 111803268157ULL },   // factor: 33095421839234187287
  { 149211407, 64, 111444875485ULL },   // factor: 33257693348113314791
  { 149072101, 64, 111652930151ULL },   // factor: 33288673760831634503
  { 148380433, 64, 112202193920ULL },   // factor: 33297220234799134721
  { 148066559, 64, 112671991576ULL },   // factor: 33365908176670613969
  { 149322167, 64, 111725363448ULL },   // factor: 33366146757835903633
  { 148668241, 64, 112365532248ULL },   // factor: 33410372056677871537
  { 149214223, 64, 111977321220ULL },   // factor: 33417217958927424121
  { 148774187, 64, 112311592620ULL },   // factor: 33418131765431399881
  { 148942247, 64, 112192198068ULL },   // factor: 33420316152233957593
  { 148405721, 64, 112734468708ULL },   // factor: 33460880220325356937
  { 149993453, 64, 111807911847ULL },   // factor: 33540909541302275383
  { 149361551, 64, 112316515341ULL },   // factor: 33551537868494107783
  { 148890563, 64, 112756496220ULL },   // factor: 33576756408206343721
  { 148514827, 64, 113180778525ULL },   // factor: 33618047484731380351
  { 148699981, 64, 113151372519ULL },   // factor: 33651213887398444279
  { 148170167, 64, 113620788757ULL },   // factor: 33670422489592824839
  { 149723243, 64, 112738109077ULL },   // factor: 33759030601392353423
  { 148186891, 64, 113981030669ULL },   // factor: 33780989135629520159
  { 148647043, 64, 113681131653ULL },   // factor: 33796728130224304159
  { 149883827, 64, 112770009664ULL },   // factor: 33804801238534608257
  { 148164703, 64, 114138672152ULL },   // factor: 33822644920430901713
  { 148022257, 64, 114452647980ULL },   // factor: 33883078547252181721
  { 148742761, 64, 113910334635ULL },   // factor: 33886675360087654471
  { 149624261, 64, 113247913788ULL },   // factor: 33889270820642421337
  { 149995751, 64, 113049807345ULL },   // factor: 33913981506237182191
  { 148817239, 64, 113975188856ULL },   // factor: 33922945840106977169
  { 148679537, 64, 114219477504ULL },   // factor: 33964198063353271297
  { 149670823, 64, 113841332765ULL },   // factor: 34077451932708831191
  { 148923317, 64, 114465772824ULL },   // factor: 34093245143837074417
  { 148917779, 64, 114525531900ULL },   // factor: 34109775698683300201
  { 149491739, 64, 114125457541ULL },   // factor: 34121626223949507599
  { 149568179, 64, 114233818585ULL },   // factor: 34171488451949613431
  { 149102909, 64, 114652138591ULL },   // factor: 34189934773978522439
  { 148063171, 64, 115509494964ULL },   // factor: 34205404209956741689
  { 148373257, 64, 115521619139ULL },   // factor: 34280637771133931447
  { 148333879, 64, 115598290877ULL },   // factor: 34294285783111443767
  { 149684839, 64, 114842375489ULL },   // factor: 34380324970897022543
  { 149761679, 64, 114905104780ULL },   // factor: 34416762835047451241
  { 148952087, 64, 115588062828ULL },   // factor: 34434166381035444073
  { 149389811, 64, 115275448816ULL },   // factor: 34441955023124827553
  { 149948363, 64, 115063067377ULL },   // factor: 34507037189879707703
  { 148394041, 64, 116280444015ULL },   // factor: 34510649953320229231
  { 148029781, 64, 116579849264ULL },   // factor: 34514579111125862369
  { 148788317, 64, 115989241480ULL },   // factor: 34515688059831578321
  { 149118589, 64, 115788914411ULL },   // factor: 34532559077620172159
  { 149784001, 64, 115275842391ULL },   // factor: 34532953783938772783
  { 149623387, 64, 115514680032ULL },   // factor: 34567395349218216769
  { 149701879, 64, 115501174169ULL },   // factor: 34581485599611127103
  { 148663439, 64, 116316767085ULL },   // factor: 34584101216436210631
  { 149637911, 64, 115708426845ULL },   // factor: 34628734556364241591
  { 148041419, 64, 116974983921ULL },   // factor: 34634285214334047799
  { 149844449, 64, 115585662352ULL },   // factor: 34639739774870968097
  { 149137333, 64, 116255209403ULL },   // factor: 34675983755439884399
  { 149860349, 64, 115981608327ULL },   // factor: 34762088602931052247
  { 148515797, 64, 117102383383ULL },   // factor: 34783107597451602503
  { 149397331, 64, 116599547868ULL },   // factor: 34839322494571880617
  { 149217067, 64, 116773355525ULL },   // factor: 34849155230377490351
  { 149487619, 64, 116587586324ULL },   // factor: 34856801369063445113
  { 148848361, 64, 117103859915ULL },   // factor: 34861435230242698631
  { 148997683, 64, 117051225017ULL },   // factor: 34880722639689271223
  { 148960883, 64, 117115042405ULL },   // factor: 34891120258462487231
  { 148664521, 64, 117799121691ULL },   // factor: 35025100000826450023
  { 148025693, 64, 118383890520ULL },   // factor: 35047714868518260721
  { 149760511, 64, 117038310668ULL },   // factor: 35055434424432862697
  { 149341559, 64, 117448763857ULL },   // factor: 35079962994054466127
  { 149961739, 64, 117047253737ULL },   // factor: 35105219431149537287
  { 148332719, 64, 118447666620ULL },   // factor: 35139328897900279561
  { 149926123, 64, 117322170533ULL },   // factor: 35179316339915067119
  { 148868567, 64, 118190178084ULL },   // factor: 35189604889679771257
  { 148757431, 64, 118309594085ULL },   // factor: 35198862557474791271
  { 148969889, 64, 118360211136ULL },   // factor: 35264215029892967809
  { 149669339, 64, 117827740189ULL },   // factor: 35270399979902730143
  { 149292529, 64, 118265020832ULL },   // factor: 35312168104493928257
  { 149584759, 64, 118129332656ULL },   // factor: 35340695512357179809
  { 149307827, 64, 118405150753ULL },   // factor: 35357631529075687463
  { 148117303, 64, 119443190108ULL },   // factor: 35383206361026477449
  { 149135449, 64, 118625590536ULL },   // factor: 35382561414953021329
  { 149514263, 64, 118358300140ULL },   // factor: 35392508030729793641
  { 148899397, 64, 119020076075ULL },   // factor: 35444035116923253551
  { 149368691, 64, 118741153585ULL },   // factor: 35472421357642814471
  { 149164259, 64, 119085386677ULL },   // factor: 35526566922806354687
  { 149718629, 64, 118655688531ULL },   // factor: 35529934019824687999
  { 148545689, 64, 119778441819ULL },   // factor: 35585142334699536583
  { 149839633, 64, 118823470271ULL },   // factor: 35608930354386101087
  { 149443249, 64, 119241203156ULL },   // factor: 35639585628603387689
  { 149987939, 64, 118836693460ULL },   // factor: 35648141459280357881
  { 148362979, 64, 120299706437ULL },   // factor: 35696045639637591647
  { 148169783, 64, 120800367625ULL },   // factor: 35797928514632950751
  { 149036317, 64, 120331748688ULL },   // factor: 35867601285258204193
  { 148081201, 64, 121128077435ULL },   // factor: 35873582362791598871
  { 149929357, 64, 119663131179ULL },   // factor: 35882032628548243807
  { 149203567, 64, 120253838660ULL },   // factor: 35884603347029000441
  { 149435647, 64, 120282951545ULL },   // factor: 35949121374393449231
  { 149312497, 64, 120474379080ULL },   // factor: 35976660729918725521
  { 148161473, 64, 121433140555ULL },   // factor: 35983425951289675031
  { 148537373, 64, 121209477148ULL },   // factor: 36008274636534904409
  { 148694773, 64, 121135671227ULL },   // factor: 36024482270602792943
  { 148123663, 64, 121920852441ULL },   // factor: 36118726519286822767
  { 149148631, 64, 121281231536ULL },   // factor: 36177859299176854433
  { 148813859, 64, 121558666156ULL },   // factor: 36179228411134112009
  { 148886363, 64, 121527629073ULL },   // factor: 36187613393384062999
  { 148902463, 64, 121569034121ULL },   // factor: 36203857210295880047
  { 148347113, 64, 122058575967ULL },   // factor: 36214074723191266543
  { 149114443, 64, 121604027460ULL },   // factor: 36265833642509209561
  { 148415299, 64, 122385811425ULL },   // factor: 36327853591997982151
  { 148730579, 64, 122135864476ULL },   // factor: 36330675680362023209
  { 148831621, 64, 122075250483ULL },   // factor: 36337314826731845887
  { 148406689, 64, 122451877635ULL },   // factor: 36345355443287001031
  { 148102919, 64, 122855715484ULL },   // factor: 36390580158027795593
  { 148231009, 64, 122926746311ULL },   // factor: 36443111277533115599
  { 149873179, 64, 121620493469ULL },   // factor: 36455299975495535903
  { 148198811, 64, 123067132165ULL },   // factor: 36476805320065711631
  { 148899133, 64, 122596342211ULL },   // factor: 36508978128378406127
  { 148034153, 64, 123474086691ULL },   // factor: 36556763681501515447
  { 149393077, 64, 122429908983ULL },   // factor: 36580361639600621383
  { 149825719, 64, 122137382136ULL },   // factor: 36598642190607911569
  { 148318831, 64, 123406246808ULL },   // factor: 36606940529320082897
  { 148643731, 64, 123486861041ULL },   // factor: 36711095509225567943
  { 148804093, 64, 123421049372ULL },   // factor: 36731114617817359193
  { 149308597, 64, 123037107855ULL },   // factor: 36740995905535458871
  { 149260159, 64, 123129467337ULL },   // factor: 36756647744611853167
  { 148549637, 64, 123782424087ULL },   // factor: 36775668330207812839
  { 148989163, 66, 311242747188ULL },   // factor: 92743592786721447289
  { 149333941, 66, 389638709823ULL },   // factor: 116372568208048004887
  { 148444841, 71, 10311679559371ULL },   // factor: 3061431265267556310023
  { 150620023, 62, 15312078560ULL },   // factor: 4612611249770013761
  { 150404953, 62, 15375250476ULL },   // factor: 4625027650412015257
  { 150255817, 62, 15397770807ULL },   // factor: 4627209265169068639
  { 150021931, 62, 15463228073ULL },   // factor: 4639646670009737927
  { 150626981, 62, 15409935864ULL },   // factor: 4642304233195893169
  { 150709253, 62, 15408769327ULL },   // factor: 4644488229842965463
  { 150989323, 62, 15413674280ULL },   // factor: 4654600488959424881
  { 150704863, 62, 15457852773ULL },   // factor: 4659147168858270199
  { 150891469, 62, 15479087667ULL },   // factor: 4671324553706825647
  { 150787123, 62, 15495066072ULL },   // factor: 4672912867383581713
  { 150394357, 62, 15564223835ULL },   // factor: 4681542871737798191
  { 150734417, 62, 15580258660ULL },   // factor: 4696962411648602441
  { 150727987, 62, 15621428664ULL },   // factor: 4709172993177638737
  { 150955261, 62, 15631771331ULL },   // factor: 4719396242326844783
  { 150386707, 62, 15729707829ULL },   // factor: 4731077924950858207
  { 150396611, 62, 15739344493ULL },   // factor: 4734288142217426447
  { 150893773, 62, 15711046976ULL },   // factor: 4741398311977760897
  { 150486097, 62, 15810408627ULL },   // factor: 4758493372504717639
  { 150529531, 62, 15805510304ULL },   // factor: 4758392106553574849
  { 150397937, 62, 15842268067ULL },   // factor: 4765288869355555559
  { 150919159, 62, 15817417685ULL },   // factor: 4774302749143853831
  { 150072319, 62, 15943094969ULL },   // factor: 4785234468070126223
  { 150208507, 62, 15933737748ULL },   // factor: 4786765916113244473
  { 150099671, 62, 15989682088ULL },   // factor: 4800092041606786097
  { 150452717, 62, 15969344587ULL },   // factor: 4805262563646785759
  { 150575441, 62, 15987330055ULL },   // factor: 4814598546888358511
  { 150123119, 62, 16143926869ULL },   // factor: 4847153308964368823
  { 150398723, 62, 16153973440ULL },   // factor: 4859073953503834241
  { 150482209, 62, 16153183455ULL },   // factor: 4861533457381304191
  { 150804673, 62, 16118825448ULL },   // factor: 4861588401659437009
  { 150004121, 62, 16246555296ULL },   // factor: 4874100492908749633
  { 150632389, 62, 16195464095ULL },   // factor: 4879122895187145911
  { 150653323, 62, 16239047756ULL },   // factor: 4892933013594186377
  { 150171377, 62, 16292509444ULL },   // factor: 4893337155981968777
  { 150566167, 62, 16280467089ULL },   // factor: 4902575053120755727
  { 150981121, 62, 16259074116ULL },   // factor: 4909626472911528073
  { 150710057, 62, 16313881983ULL },   // factor: 4917332167098406063
  { 150702037, 62, 16323896183ULL },   // factor: 4920088813109249543
  { 150099809, 62, 16413109536ULL },   // factor: 4927209212899357249
  { 150152033, 62, 16419227940ULL },   // factor: 4930760910962804041
  { 150409219, 62, 16399343685ULL },   // factor: 4933224951546864031
  { 150033727, 62, 16468424637ULL },   // factor: 4941638252215464199
  { 150059621, 62, 16490513695ULL },   // factor: 4949120470334019191
  { 150927407, 62, 16397267373ULL },   // factor: 4949594092985183623
  { 150092213, 62, 16523337655ULL },   // factor: 4960048629570361031
  { 150473549, 62, 16484194267ULL },   // factor: 4960870427521887167
  { 150461501, 62, 16507063140ULL },   // factor: 4967354994292346281
  { 150980059, 62, 16460501345ULL },   // factor: 4970414928475358711
  { 150872999, 62, 16501921104ULL },   // factor: 4979388652443741793
  { 150936641, 62, 16530879879ULL },   // factor: 4990230963421492879
  { 150861769, 62, 16540371312ULL },   // factor: 4990619352090341857
  { 150071629, 62, 16677844472ULL },   // factor: 5005742576243369777
  { 150478739, 62, 16686634261ULL },   // factor: 5021967363498953759
  { 150679363, 62, 16675802640ULL },   // factor: 5025398638617836641
  { 150899081, 62, 16735180575ULL },   // factor: 5050646738273103151
  { 150078619, 62, 16830268701ULL },   // factor: 5051726968090007839
  { 150997337, 62, 16757847087ULL },   // factor: 5060780567980414639
  { 150724531, 62, 16805660460ULL },   // factor: 5066050581957488521
  { 150632917, 62, 16918197675ULL },   // factor: 5096874932335735951
  { 150875801, 62, 16913196096ULL },   // factor: 5103584016908145793
  { 150704731, 62, 16952847564ULL },   // factor: 5109748663633250569
  { 150857887, 62, 16945048385ULL },   // factor: 5112588388947724991
  { 150326621, 62, 17126460208ULL },   // factor: 5149125785519194337
  { 150852721, 62, 17110213295ULL },   // factor: 5162244464882251391
  { 150432151, 62, 17167122308ULL },   // factor: 5164974270545049017
  { 150969803, 62, 17113451020ULL },   // factor: 5167228658279098121
  { 150098719, 62, 17249450141ULL },   // factor: 5178240739236938759
  { 150539023, 62, 17211464016ULL },   // factor: 5181993954736592737
  { 150316169, 62, 17289395316ULL },   // factor: 5197751336455328809
  { 150096967, 62, 17336483664ULL },   // factor: 5204307232822894177
  { 150333223, 62, 17322850656ULL },   // factor: 5208399941328288577
  { 150629573, 62, 17337119572ULL },   // factor: 5222965836360605513
  { 150795361, 62, 17364425459ULL },   // factor: 5236949611294991399
  { 150476177, 62, 17427155487ULL },   // factor: 5244743467336666399
  { 150887701, 62, 17393058224ULL },   // factor: 5248797137557006049
  { 150653759, 62, 17433093976ULL },   // factor: 5252722276969311569
  { 150876137, 62, 17420939095ULL },   // factor: 5256807987131752031
  { 150923651, 62, 17431973401ULL },   // factor: 5261794139627614103
  { 150745423, 62, 17509563192ULL },   // factor: 5278973019846540433
  { 150958277, 62, 17532403243ULL },   // factor: 5293322770464984623
  { 150319531, 62, 17625902468ULL },   // factor: 5299034784883005017
  { 150306407, 62, 17714495793ULL },   // factor: 5325204428924891503
  { 150125617, 62, 17741889987ULL },   // factor: 5327024362088993959
  { 150072799, 62, 17752434624ULL },   // factor: 5328315106176385153
  { 150265067, 62, 17797554024ULL },   // factor: 5348701295704959217
  { 150227171, 62, 17824456104ULL },   // factor: 5355435230235203569
  { 150278257, 62, 17826463835ULL },   // factor: 5357859827194671191
  { 150851851, 62, 17778024765ULL },   // factor: 5363695885848180031
  { 150681911, 62, 17847861949ULL },   // factor: 5378699891479009079
  { 150433373, 62, 17898767836ULL },   // factor: 5385144036226781657
  { 150456751, 62, 17923944648ULL },   // factor: 5393556953683837297
  { 150346711, 62, 18019388129ULL },   // factor: 5418311478855187439
  { 150552631, 62, 18076821209ULL },   // factor: 5443025986263101759
  { 150767273, 62, 18061300011ULL },   // factor: 5446105898986680007
  { 150630451, 62, 18115213133ULL },   // factor: 5457405448369825967
  { 150675977, 62, 18115777788ULL },   // factor: 5459225034643597753
  { 150077423, 62, 18245662645ULL },   // factor: 5476524061377927671
  { 150105481, 62, 18256131420ULL },   // factor: 5480690775996626041
  { 150005411, 62, 18340701328ULL },   // factor: 5502408881469771617
  { 150257027, 62, 18358897477ULL },   // factor: 5517106707783641759
  { 150151607, 62, 18384739584ULL },   // factor: 5520996385628222977
  { 150839471, 62, 18305037780ULL },   // factor: 5522244430740428761
  { 150666419, 62, 18335940117ULL },   // factor: 5525220872853662047
  { 150737267, 62, 18392879893ULL },   // factor: 5544984894660144863
  { 150816049, 62, 18390832592ULL },   // factor: 5547265418691738017
  { 150908179, 62, 18447561945ULL },   // factor: 5567775960219296311
  { 150284153, 62, 18536079063ULL },   // factor: 5571357883847977279
  { 150607241, 62, 18500477548ULL },   // factor: 5572611761373450137
  { 150533129, 62, 18521966235ULL },   // factor: 5576339065173798631
  { 150101099, 62, 18580540392ULL },   // factor: 5577919065706181617
  { 150466747, 62, 18543972732ULL },   // factor: 5580502506881485609
  { 150446759, 62, 18561025320ULL },   // factor: 5584892206221875761
  { 150493583, 62, 18559033248ULL },   // factor: 5586030821015295169
  { 150489533, 62, 18676841043ULL },   // factor: 5621338172952605839
  { 150826141, 62, 18644345036ULL },   // factor: 5624109226504772153
  { 150437759, 62, 18724716801ULL },   // factor: 5633808866904177919
  { 150600647, 62, 18724057932ULL },   // factor: 5639710478049364009
  { 150098257, 62, 18854381147ULL },   // factor: 5660019493956721559
  { 150019213, 62, 19035542247ULL },   // factor: 5711394133846383223
  { 150651559, 62, 19014201569ULL },   // factor: 5729038219020192143
  { 150933709, 62, 18996218700ULL },   // factor: 5734339490732316601
  { 150403823, 62, 19068511312ULL },   // factor: 5735954000487091553
  { 150377323, 62, 19103160593ULL },   // factor: 5745364301628865079
  { 150890507, 62, 19055862393ULL },   // factor: 5750697475604006503
  { 150001211, 62, 19299868968ULL },   // factor: 5790007434682640497
  { 150725777, 62, 19212075907ULL },   // factor: 5791510137731109479
  { 150315443, 62, 19304056360ULL },   // factor: 5803395566900734961
  { 150651707, 62, 19358054832ULL },   // factor: 5832648009280796449
  { 150695659, 62, 19406508144ULL },   // factor: 5848953067297893793
  { 150956723, 62, 19442758377ULL },   // factor: 5870030181345437143
  { 150203621, 62, 19553370240ULL },   // factor: 5873974025603278081
  { 150130753, 62, 19590795840ULL },   // factor: 5882361862656935041
  { 150749777, 62, 19590308583ULL },   // factor: 5906469300496871983
  { 150345079, 62, 19659852936ULL },   // factor: 5911524285582603889
  { 150753061, 62, 19669155396ULL },   // factor: 5930370766463334313
  { 150445391, 62, 19786538509ULL },   // factor: 5953587045046124039
  { 150205283, 62, 19857940921ULL },   // factor: 5965535271672171287
  { 150510287, 62, 19848917572ULL },   // factor: 5974932560802126329
  { 150314617, 62, 19885753739ULL },   // factor: 5978238914068205927
  { 150551911, 62, 19880935536ULL },   // factor: 5986225674825218593
  { 150559949, 62, 19919409567ULL },   // factor: 5998130577035264167
  { 150318061, 62, 19979320208ULL },   // factor: 6006505347529353377
  { 150992467, 62, 19932065072ULL },   // factor: 6019183355251625249
  { 150825673, 62, 19999959612ULL },   // factor: 6033014736905437753
  { 150009913, 62, 20144383340ULL },   // factor: 6043714384544098841
  { 150445039, 62, 20135131005ULL },   // factor: 6058461138634668391
  { 150595517, 62, 20227644000ULL },   // factor: 6092385011743896001
  { 150231751, 62, 20284985601ULL },   // factor: 6094897811696034703
  { 150645511, 62, 20228891481ULL },   // factor: 6094783388237583583
  { 150804607, 62, 20267000952ULL },   // factor: 6112714227269971729
  { 150076907, 62, 20395166233ULL },   // factor: 6121686931998962663
  { 150265571, 62, 20462721348ULL },   // factor: 6149685015142219417
  { 150818807, 62, 20400317044ULL },   // factor: 6153502957995693017
  { 150784597, 62, 20417547464ULL },   // factor: 6157303332175224017
  { 150925039, 62, 20431367216ULL },   // factor: 6167209787796242849
  { 150849943, 62, 20447373180ULL },   // factor: 6168970157405457481
  { 150640337, 62, 20495867679ULL },   // factor: 6175008828543935647
  { 150441383, 62, 20529698373ULL },   // factor: 6177032431613939719
  { 150847091, 62, 20526666904ULL },   // factor: 6192775980788752529
  { 150066251, 62, 20669925036ULL },   // factor: 6203716317207120073
  { 150040747, 62, 20705052500ULL },   // factor: 6213203087548435001
  { 150294887, 62, 20725660800ULL },   // factor: 6229921695872659201
  { 150391387, 62, 20814823248ULL },   // factor: 6260740276853129953
  { 150977023, 62, 20827658973ULL },   // factor: 6288995895605554759
  { 150669853, 62, 20880221111ULL },   // factor: 6292039690803733367
  { 150906061, 62, 20894741060ULL },   // factor: 6306286137959129321
  { 150712439, 62, 20989778932ULL },   // factor: 6326841553825070297
  { 150859417, 62, 21031595027ULL },   // factor: 6345628328706638519
  { 150034243, 62, 21161513505ULL },   // factor: 6349903318913903431
  { 150174697, 62, 21159865175ULL },   // factor: 6355352682432953951
  { 150777359, 62, 21106912572ULL },   // factor: 6364889068500114697
  { 150637549, 62, 21174021024ULL },   // factor: 6379205259059660353
  { 150442709, 62, 21211270392ULL },   // factor: 6382161958207943857
  { 150118291, 62, 21272133449ULL },   // factor: 6386672638575631319
  { 150287351, 62, 21271984288ULL },   // factor: 6393820338314282177
  { 150901073, 62, 21211110211ULL },   // factor: 6401558580722312807
  { 150846617, 62, 21283124524ULL },   // factor: 6420974667270270617
  { 150700721, 62, 21310684236ULL },   // factor: 6423070958737068313
  { 150876923, 62, 21298145076ULL },   // factor: 6426797189348962297
  { 150095849, 62, 21415797436ULL },   // factor: 6428844596336886329
  { 150621461, 62, 21362442924ULL },   // factor: 6435284727483983929
  { 150573173, 62, 21411899967ULL },   // factor: 6448115435979570583
  { 150092741, 62, 21508079796ULL },   // factor: 6456413300456721673
  { 150740131, 62, 21428882421ULL },   // factor: 6460385086650274303
  { 150578551, 62, 21492177633ULL },   // factor: 6472521931623499567
  { 150449921, 62, 21561028375ULL },   // factor: 6487710031395016751
  { 150156623, 62, 21669585088ULL },   // factor: 6507663437250475649
  { 150649549, 62, 21784978592ULL },   // factor: 6563794399718910017
  { 150944473, 62, 21745285352ULL },   // factor: 6564661275384518993
  { 150673157, 62, 21893300227ULL },   // factor: 6597465324701813279
  { 150225221, 62, 21987121371ULL },   // factor: 6606040334224595983
  { 150075641, 62, 22080907659ULL },   // factor: 6627612741572468839
  { 150114067, 62, 22172676873ULL },   // factor: 6656861403365744983
  { 150061151, 62, 22189632396ULL },   // factor: 6659603555221295593
  { 150298969, 62, 22169475119ULL },   // factor: 6664098507313704623
  { 150451531, 62, 22183506893ULL },   // factor: 6675085150001806367
  { 150642623, 62, 22224897628ULL },   // factor: 6696033749176796489
  { 150732683, 62, 22220481168ULL },   // factor: 6698705488007227489
  { 150784859, 62, 22239510805ULL },   // factor: 6706763001921802991
  { 150932729, 62, 22226028867ULL },   // factor: 6709270383458176087
  { 150185489, 62, 22353965560ULL },   // factor: 6714482497435517681
  { 150449381, 62, 22361721084ULL },   // factor: 6728614190364898009
  { 150107759, 62, 22494544104ULL },   // factor: 6753211210356205873
  { 150719519, 62, 22412025309ULL },   // factor: 6755859348776612743
  { 150292301, 62, 22535677800ULL },   // factor: 6773877742313235601
  { 150110797, 62, 22578923619ULL },   // factor: 6778680439700428687
  { 150439633, 62, 22551572532ULL },   // factor: 6785300590573921513
  { 150608993, 62, 22683822667ULL },   // factor: 6832775378534888663
  { 150702523, 62, 22840889753ULL },   // factor: 6884359426683893639
  { 150484669, 62, 22917541251ULL },   // factor: 6897477218901161839
  { 150061117, 62, 23118256992ULL },   // factor: 6938302934625160129
  { 150068959, 62, 23118628541ULL },   // factor: 6938777037311117639
  { 150399619, 62, 23069633889ULL },   // factor: 6939328294750176583
  { 150403571, 62, 23071839868ULL },   // factor: 6940174211374737257
  { 150731963, 62, 23052952728ULL },   // factor: 6949633635275290129
  { 150520967, 62, 23175538177ULL },   // factor: 6976808834294914319
  { 150996683, 62, 23111413093ULL },   // factor: 6979493432971541039
  { 150152627, 62, 23270645772ULL },   // factor: 6988297189304486089
  { 150483791, 62, 23233702009ULL },   // factor: 6992591114557272239
  { 150456767, 62, 23241687369ULL },   // factor: 6993738282328952047
  { 150717797, 62, 23227018135ULL },   // factor: 7001450008372497191
  { 150129509, 62, 23352484536ULL },   // factor: 7011794074639545649
  { 150658147, 62, 23294841972ULL },   // factor: 7019115452318691769
  { 150008171, 62, 23405524420ULL },   // factor: 7022039819080071641
  { 150156073, 62, 23477963831ULL },   // factor: 7050717701797991327
  { 150716689, 62, 23405122031ULL },   // factor: 7055084996306550719
  { 150324943, 62, 23492242908ULL },   // factor: 7062940152174508489
  { 150489743, 62, 23486270433ULL },   // factor: 7068885602981337439
  { 150963983, 62, 23530290336ULL },   // factor: 7104452700537936577
  { 150101947, 62, 23692791665ULL },   // factor: 7112668317563743511
  { 150366539, 62, 23661245785ULL },   // factor: 7115719274237576231
  { 150170429, 62, 23741431776ULL },   // factor: 7130521989752303809
  { 150429857, 62, 23710280368ULL },   // factor: 7133468170376294753
  { 150808157, 62, 23750483019ULL },   // factor: 7163533143910371967
  { 150317093, 62, 23898899631ULL },   // factor: 7184826236861385367
  { 150740287, 62, 23860503689ULL },   // factor: 7193478348088837487
  { 150057289, 62, 24035919699ULL },   // factor: 7213529897307272023
  { 150682699, 62, 23937796925ULL },   // factor: 7214023697545801151
  { 150904927, 62, 23938321433ULL },   // factor: 7224821296698800783
  { 150556309, 62, 24007792451ULL },   // factor: 7229049237321246719
  { 150086533, 62, 24155028867ULL },   // factor: 7250689074325896223
  { 150364759, 62, 24115209677ULL },   // factor: 7252155382633145687
  { 150942227, 62, 24026805793ULL },   // factor: 7253319148183842023
  { 150572021, 62, 24110433079ULL },   // factor: 7260713271780565319
  { 150332719, 62, 24248250636ULL },   // factor: 7290610898206718569
  { 150659629, 62, 24238594400ULL },   // factor: 7303555279570955201
  { 150722557, 62, 24232083188ULL },   // factor: 7304643079064143433
  { 150517177, 62, 24348711443ULL },   // factor: 7329798619975912823
  { 150514129, 62, 24383796456ULL },   // factor: 7340211770576253649
  { 150318499, 62, 24437618604ULL },   // factor: 7346852295375510793
  { 150415831, 62, 24459036608ULL },   // factor: 7358052633703482497
  { 150145883, 62, 24514708776ULL },   // factor: 7361565191320738417
  { 150809437, 62, 24434266595ULL },   // factor: 7369835977399714031
  { 150022967, 62, 24598265212ULL },   // factor: 7380609460314248009
  { 150633437, 62, 24502601655ULL },   // factor: 7381822205469076471
  { 150898463, 62, 24479223916ULL },   // factor: 7387754528714482217
  { 150806959, 62, 24520829837ULL },   // factor: 7395823559748871367
  { 150568081, 62, 24584628099ULL },   // factor: 7403320549930216039
  { 150448789, 62, 24615145196ULL },   // factor: 7406637571594735289
  { 150997039, 62, 24547621584ULL },   // factor: 7413236347352979553
  { 150289123, 62, 24734121236ULL },   // factor: 7434538777468232057
  { 150660151, 62, 24783369533ULL },   // factor: 7467732392261158967
  { 150849403, 62, 24760532096ULL },   // factor: 7470222969287877377
  { 150338471, 62, 24963067821ULL },   // factor: 7505818895356883383
  { 150645809, 62, 24914095675ULL },   // factor: 7506408196927552151
  { 150423877, 62, 25110065523ULL },   // factor: 7554306815387385343
  { 150234191, 62, 25194858420ULL },   // factor: 7570258344176476441
  { 150453847, 62, 25165495104ULL },   // factor: 7572491100112930177
  { 150120031, 62, 25345744761ULL },   // factor: 7609807978478815183
  { 150849301, 62, 25537015791ULL },   // factor: 7704481963396624183
  { 150452681, 62, 25605833799ULL },   // factor: 7704932688599930239
  { 150842801, 62, 25548798283ULL },   // factor: 7707704590383421367
  { 150669709, 62, 25609672419ULL },   // factor: 7717203781912112143
  { 150925637, 62, 25583132304ULL },   // factor: 7722301078872955297
  { 150002357, 62, 25753083459ULL },   // factor: 7726046437735425727
  { 150759877, 62, 25656154364ULL },   // factor: 7735837352419306457
  { 150100889, 62, 25776290904ULL },   // factor: 7738088359626027313
  { 150752633, 62, 25703370115ULL },   // factor: 7749701443619525591
  { 150676237, 62, 25769032008ULL },   // factor: 7765561548195987793
  { 150690277, 62, 25766965488ULL },   // factor: 7765662333672320353
  { 150438241, 62, 25925924175ULL },   // factor: 7800500858372752351
  { 150275893, 62, 26053384200ULL },   // factor: 7830391152654181201
  { 150645361, 62, 25991457360ULL },   // factor: 7830984953826613921
  { 150321799, 62, 26123719592ULL },   // factor: 7853929051281972017
  { 150653213, 62, 26084190043ULL },   // factor: 7859334076961116319
  { 150752401, 62, 26070184800ULL },   // factor: 7860285906227409601
  { 150480581, 62, 26177088040ULL },   // factor: 7878286834294702481
  { 150703361, 62, 26159857300ULL },   // factor: 7884756836780770601
  { 150320657, 62, 26238020880ULL },   // factor: 7888233074122636321
  { 150204221, 62, 26321922688ULL },   // factor: 7907327785146532097
  { 150686993, 62, 26324800455ULL },   // factor: 7933610043777963631
  { 150232993, 62, 26419799207ULL },   // factor: 7938251018653273103
  { 150850853, 62, 26401361152ULL },   // factor: 7965335700280525313
  { 150283453, 62, 26536991408ULL },   // factor: 7976141402051143649
  { 150108229, 62, 26661326571ULL },   // factor: 8004169028726905519
  { 150652457, 62, 26661377263ULL },   // factor: 8033203983349770383
  { 150345757, 62, 26770950168ULL },   // factor: 8049797537234474353
  { 150219851, 62, 26803135516ULL },   // factor: 8052726047092656233
  { 150304171, 62, 26804281700ULL },   // factor: 8057590680337941401
  { 150963773, 62, 26708295900ULL },   // factor: 8063970238928861401
  { 150331567, 62, 26841150180ULL },   // factor: 8070144333283464121
  { 150341111, 62, 26883326253ULL },   // factor: 8083338272502974167
  { 150787213, 62, 26827789767ULL },   // factor: 8090575299831698743
  { 150472453, 62, 26886659552ULL },   // factor: 8091403231530642113
  { 150657979, 62, 26868468132ULL },   // factor: 8095898215186050457
  { 150350273, 62, 26962085272ULL },   // factor: 8107513762588958513
  { 150946331, 62, 26919430305ULL },   // factor: 8126778474299921911
  { 150594487, 62, 27013586268ULL },   // factor: 8136194332119409033
  { 150445793, 62, 27126481423ULL },   // factor: 8162130017966006879
  { 150265807, 62, 27276068997ULL },   // factor: 8197321039243771159
  { 150619531, 62, 27225474260ULL },   // factor: 8201376328587544121
  { 150568433, 62, 27276032200ULL },   // factor: 8213818853623085201
  { 150689129, 62, 27259307239ULL },   // factor: 8215362529976609663
  { 150533969, 62, 27415634100ULL },   // factor: 8253968427449485801
  { 150393233, 62, 27445663996ULL },   // factor: 8255284280380278137
  { 150964027, 62, 27356120348ULL },   // factor: 8259580181661442793
  { 150066509, 62, 27547857204ULL },   // factor: 8268021522069561673
  { 150900437, 62, 27425182603ULL },   // factor: 8276944079194995023
  { 150126931, 62, 27616877213ULL },   // factor: 8292074039583046607
  { 150911797, 62, 27478348524ULL },   // factor: 8293613908698275257
  { 150807247, 62, 27540778620ULL },   // factor: 8306698007837318281
  { 150380999, 62, 27655980829ULL },   // factor: 8317868050779736343
  { 150165749, 62, 27798539427ULL },   // factor: 8348776988322971647
  { 150379309, 62, 27774666155ULL },   // factor: 8353470208189173791
  { 150678793, 62, 27819763740ULL },   // factor: 8383696843776731641
  { 150768983, 62, 27915400905ULL },   // factor: 8417553208968259231
  { 150825079, 62, 27957885741ULL },   // factor: 8433500651118597079
  { 150120281, 62, 28145891344ULL },   // factor: 8450538235113495329
  { 150418469, 62, 28110517632ULL },   // factor: 8456682050005890817
  { 150142439, 62, 28183293729ULL },   // factor: 8463016919050930063
  { 150013859, 62, 28220682700ULL },   // factor: 8466987030883078601
  { 150002081, 62, 28265503120ULL },   // factor: 8479768577023985441
  { 150221723, 62, 28343417317ULL },   // factor: 8515593970135554383
  { 150136339, 62, 28500491901ULL },   // factor: 8557919027430580879
  { 150018541, 62, 28615651239ULL },   // factor: 8585756497279244599
  { 150492343, 62, 28555012488ULL },   // factor: 8594621467426758769
  { 150383707, 62, 28592892629ULL },   // factor: 8599810374803991407
  { 150583117, 62, 28597887828ULL },   // factor: 8612718177513199753
  { 150477281, 62, 28626240816ULL },   // factor: 8615197766485802593
  { 150483131, 62, 28643229829ULL },   // factor: 8620645813241029199
  { 150528239, 62, 28633880529ULL },   // factor: 8620415223533516863
  { 150555547, 62, 28683356712ULL },   // factor: 8636876919142562929
  { 150206323, 62, 28779186336ULL },   // factor: 8645631516924805057
  { 150236533, 62, 28795049507ULL },   // factor: 8652136810990078463
  { 150104303, 62, 28823252736ULL },   // factor: 8652988524260246017
  { 150151121, 62, 28814502996ULL },   // factor: 8653059851814517033
  { 150677333, 62, 28714713156ULL },   // factor: 8653312792412185897
  { 150672569, 62, 28729020795ULL },   // factor: 8657350736074144711
  { 150475667, 62, 28940652588ULL },   // factor: 8709728003189152393
  { 150195917, 62, 29024451715ULL },   // factor: 8718708281513295311
  { 150825011, 62, 28921610820ULL },   // factor: 8724204540128438041
  { 150547799, 62, 29069045512ULL },   // factor: 8752561641724856177
  { 150522877, 62, 29080103900ULL },   // factor: 8754441804973840601
  { 150641069, 62, 29065162747ULL },   // factor: 8756814373734113087
  { 150500239, 62, 29232925901ULL },   // factor: 8799124669539580679
  { 150871579, 62, 29212478825ULL },   // factor: 8814665613663629351
  { 150847793, 62, 29227031056ULL },   // factor: 8817666261480118817
  { 150593063, 62, 29365877577ULL },   // factor: 8844594904006896703
  { 150934843, 62, 29317636296ULL },   // factor: 8850105662935723057
  { 150031913, 62, 29509956868ULL },   // factor: 8854870562907056969
  { 150753653, 62, 29603275455ULL },   // factor: 8925603831212974231
  { 150699257, 62, 29689377199ULL },   // factor: 8948334169364082287
  { 150046751, 62, 29855901381ULL },   // factor: 8959562000790926263
  { 150962191, 62, 29787839301ULL },   // factor: 8993674972069736983
  { 150276241, 62, 29941380783ULL },   // factor: 8998956308837753407
  { 150109987, 62, 30073455365ULL },   // factor: 9028651987770460511
  { 150794179, 62, 30102634809ULL },   // factor: 9078604203519953623
  { 150415297, 62, 30209970947ULL },   // factor: 9088083504708752519
  { 150042047, 62, 30316032564ULL },   // factor: 9097359165642437017
  { 150520289, 62, 30240705100ULL },   // factor: 9103679342431547801
  { 150746093, 62, 30221216428ULL },   // factor: 9111460604456831609
  { 150290797, 62, 30417070988ULL },   // factor: 9142811682384194873
  { 150086003, 62, 30491221173ULL },   // factor: 9152611024889083039
  { 150486461, 62, 30514669335ULL },   // factor: 9184089193618746871
  { 150780061, 62, 30475759044ULL },   // factor: 9190273615351243369
  { 150947957, 62, 30488727288ULL },   // factor: 9204422191307501233
  { 150924211, 62, 30548697009ULL },   // factor: 9221075986322769799
  { 150353207, 62, 30666923605ULL },   // factor: 9221740625671502471
  { 150804733, 63, 30653182743ULL },   // factor: 9245290078316645239
  { 150246001, 63, 30779883683ULL },   // factor: 9249108869231803367
  { 150981197, 63, 30715645180ULL },   // factor: 9274969751807360921
  { 150021271, 63, 30940311173ULL },   // factor: 9283409614617921767
  { 150951179, 63, 30785637549ULL },   // factor: 9294256568576440543
  { 150352049, 63, 30974501971ULL },   // factor: 9314159676188777159
  { 150539143, 63, 30944196461ULL },   // factor: 9316625632125145847
  { 150138601, 63, 31096452816ULL },   // factor: 9337555843713500833
  { 150317693, 63, 31123307971ULL },   // factor: 9356767705458461807
  { 150613861, 63, 31066161476ULL },   // factor: 9357989052699637673
  { 150126973, 63, 31203306236ULL },   // factor: 9368915825605407257
  { 150363977, 63, 31390893459ULL },   // factor: 9440119164157052887
  { 150136307, 63, 31469319469ULL },   // factor: 9449374817757721967
  { 150714323, 63, 31384822137ULL },   // factor: 9460284441706736503
  { 150935789, 63, 31441326240ULL },   // factor: 9491242766481606721
  { 150910801, 63, 31472439483ULL },   // factor: 9499062103607111767
  { 150484673, 63, 31658468727ULL },   // factor: 9528228628126642543
  { 150364909, 63, 31685850279ULL },   // factor: 9528879987578919223
  { 150677119, 63, 31660751732ULL },   // factor: 9541101712704040217
  { 150232171, 63, 31791381653ULL },   // factor: 9552176569639517327
  { 150467503, 63, 31818375641ULL },   // factor: 9575263064434588847
  { 150305317, 63, 31912332788ULL },   // factor: 9593186591819667593
  { 150983801, 63, 31771201356ULL },   // factor: 9593873486130468313
  { 150833339, 63, 31831664301ULL },   // factor: 9602552424893862079
  { 150647867, 63, 31889871112ULL },   // factor: 9608282123855436209
  { 150326639, 63, 32018673276ULL },   // factor: 9626519077640398729
  { 150321287, 63, 32168707237ULL },   // factor: 9671282945984108039
  { 150321053, 63, 32181091387ULL },   // factor: 9674991087966141023
  { 150220853, 63, 32234341320ULL },   // factor: 9684540497967091921
  { 150077693, 63, 32274250140ULL },   // factor: 9687290008632254041
  { 150995519, 63, 32083173037ULL },   // factor: 9688830727777242407
  { 150716053, 63, 32148420947ULL },   // factor: 9690566230628724383
  { 150634051, 63, 32181272421ULL },   // factor: 9695190862219614943
  { 150905611, 63, 32184287904ULL },   // factor: 9713579261506058689
  { 150526633, 63, 32271124016ULL },   // factor: 9715327282507836257
  { 150244111, 63, 32398227248ULL },   // factor: 9735285701703473057
  { 150498349, 63, 32342409035ULL },   // factor: 9734958324900366431
  { 150102509, 63, 32439368844ULL },   // factor: 9738461307721659193
  { 150704657, 63, 32431581700ULL },   // factor: 9775180792131953801
  { 150303599, 63, 32578256737ULL },   // factor: 9793258473434192927
  { 150954263, 63, 32462531601ULL },   // factor: 9800715065886330127
  { 150654341, 63, 32682825531ULL },   // factor: 9847619084781560143
  { 150664643, 63, 32721870652ULL },   // factor: 9860057920151514473
  { 150385093, 63, 32790114243ULL },   // factor: 9862288759828359199
  { 150797233, 63, 32807934155ULL },   // factor: 9894691382040386231
  { 150460669, 63, 32968723347ULL },   // factor: 9920992341731078287
  { 150833251, 63, 32970270648ULL },   // factor: 9946026216375433297
  { 150103207, 63, 33222298652ULL },   // factor: 9973547143153953929
  { 150612361, 63, 33125508623ULL },   // factor: 9978222126071777807
  { 150411791, 63, 33228500800ULL },   // factor: 9995916635145865601
  { 150430799, 63, 33226838856ULL },   // factor: 9996679834704651889
  { 150807089, 63, 33265314255ULL },   // factor: 10033290414933507391
  { 150199537, 63, 33435684395ULL },   // factor: 10044048630814250231
  { 150378769, 63, 33424129484ULL },   // factor: 10052558893401050393
  { 150574001, 63, 33428981388ULL },   // factor: 10067070953891386777
  { 150531817, 63, 33530636895ULL },   // factor: 10094855393943176431
  { 150948307, 63, 33505534260ULL },   // factor: 10115207343354995641
  { 150850417, 63, 33643795539ULL },   // factor: 10150361173041779527
  { 150365741, 63, 33958891488ULL },   // factor: 10212507764263425217
  { 150067499, 63, 34079044201ULL },   // factor: 10228313863109046599
  { 150188791, 63, 34247029121ULL },   // factor: 10287039798049565423
  { 150018559, 63, 34349960436ULL },   // factor: 10306263132631463449
  { 150573427, 63, 34223337732ULL },   // factor: 10306250491371295129
  { 150132343, 63, 34458638196ULL },   // factor: 10346712177909546457
  { 150825901, 63, 34432605651ULL },   // factor: 10386657542179533103
  { 150235441, 63, 34597039895ULL },   // factor: 10395403091839837391
  { 150588563, 63, 34545002245ULL },   // factor: 10404164493812647871
  { 150649127, 63, 34587393385ULL },   // factor: 10421121237311649791
  { 150672113, 63, 34629000136ULL },   // factor: 10435249243136814737
  { 150037513, 63, 34791188936ULL },   // factor: 10439966924541112337
  { 150300379, 63, 34809709844ULL },   // factor: 10463825164866461753
  { 150142039, 63, 34882348425ULL },   // factor: 10474613835275877151
  { 150337921, 63, 34922111111ULL },   // factor: 10500235162717480463
  { 150340439, 63, 35324192572ULL },   // factor: 10621309237190038217
  { 150238619, 63, 35378167365ULL },   // factor: 10630334015336937871
  { 150174341, 63, 35399035276ULL },   // factor: 10632053589218106233
  { 150362171, 63, 35399538540ULL },   // factor: 10645502934545140681
  { 150963217, 63, 35560619600ULL },   // factor: 10736691066658506401
  { 150369847, 63, 35711745425ULL },   // factor: 10739939391320399951
  { 150820279, 63, 35677745789ULL },   // factor: 10761855147976110263
  { 150237671, 63, 35827303461ULL },   // factor: 10765221260381758663
  { 150154471, 63, 36038198225ULL },   // factor: 10822593180536027951
  { 150113653, 63, 36190710203ULL },   // factor: 10865439426473403119
  { 150544349, 63, 36096702259ULL },   // factor: 10868309085255968783
  { 150439999, 63, 36240248364ULL },   // factor: 10903965855279823273
  { 150181439, 63, 36335681421ULL },   // factor: 10913889845702689639
  { 150030409, 63, 36406160012ULL },   // factor: 10924062153439609817
  { 150869573, 63, 36217450276ULL },   // factor: 10928222516577704297
  { 150146869, 63, 36442911827ULL },   // factor: 10943578216134239327
  { 150225841, 63, 36581608559ULL },   // factor: 10991005821817146239
  { 150259541, 63, 36593364291ULL },   // factor: 10997004244022900863
  { 150332419, 63, 36578597376ULL },   // factor: 10997898054322265089
  { 150976757, 63, 36470713987ULL },   // factor: 11012460246463600319
  { 150112453, 63, 36739363508ULL },   // factor: 11030071955689130249
  { 150202691, 63, 36731685769ULL },   // factor: 11034396094940408759
  { 150735581, 63, 36634115280ULL },   // factor: 11044129302303555361
  { 150647911, 63, 36695932364ULL },   // factor: 11056331105667783209
  { 150711467, 63, 36683556004ULL },   // factor: 11057265080278995737
  { 150331033, 63, 36847092087ULL },   // factor: 11078522832969671743
  { 150433183, 63, 36855720920ULL },   // factor: 11088646819510576721
  { 150306083, 63, 36902857861ULL },   // factor: 11093448033185336927
  { 150963361, 63, 36744004500ULL },   // factor: 11093996831838249001
  { 150829141, 63, 36817902084ULL },   // factor: 11106425089503659689
  { 150731873, 63, 36999504688ULL },   // factor: 11154009283389041249
  { 150817787, 63, 37013803105ULL },   // factor: 11164679745499657271
  { 150934669, 63, 37235689340ULL },   // factor: 11240312891039456921
  { 150355847, 63, 37490986417ULL },   // factor: 11273978035187060399
  { 150975163, 63, 37381806768ULL },   // factor: 11287448740066606369
  { 150036581, 63, 37695612559ULL },   // factor: 11311441654106041559
  { 150026959, 63, 37773301112ULL },   // factor: 11334026994449356817
  { 150769169, 63, 37622736324ULL },   // factor: 11344697382151189513
  { 150442087, 63, 37822764728ULL },   // factor: 11380271323580614673
  { 150113081, 63, 37914461655ULL },   // factor: 11382913306976818111
  { 150692623, 63, 37962557025ULL },   // factor: 11441354587768653151
  { 150274043, 63, 38165025421ULL },   // factor: 11470425342422894207
  { 150324959, 63, 38162055112ULL },   // factor: 11473418740134280817
  { 150547819, 63, 38181306072ULL },   // factor: 11496224711422113937
  { 150285719, 63, 38278103037ULL },   // factor: 11505304473743257207
  { 150159991, 63, 38315779608ULL },   // factor: 11506994242190527057
  { 150296683, 63, 38294826833ULL },   // factor: 11511170898118589879
  { 150748901, 63, 38189858080ULL },   // factor: 11514158269811940161
  { 150718637, 63, 38235282888ULL },   // factor: 11525539444377567313
  { 150412007, 63, 38499548248ULL },   // factor: 11581588641150027473
  { 150628927, 63, 38541434745ULL },   // factor: 11610909921359737231
  { 150208187, 63, 38666881185ULL },   // factor: 11616164239486523191
  { 150863513, 63, 38512412551ULL },   // factor: 11620235703098303327
  { 150605783, 63, 38603397877ULL },   // factor: 11627789927452245383
  { 150251653, 63, 38701242975ULL },   // factor: 11629851460296775351
  { 150668261, 63, 38731703763ULL },   // factor: 11671276903076732287
  { 150555149, 63, 39020501196ULL },   // factor: 11749474743236916409
  { 150595831, 63, 39058363013ULL },   // factor: 11764053270884797607
  { 150871517, 63, 38998424548ULL },   // factor: 11767502944333598633
  { 150111809, 63, 39346925440ULL },   // factor: 11812876312773041921
  { 150873763, 63, 39381533841ULL },   // factor: 11883280406607027367
  { 150760387, 63, 39535663725ULL },   // factor: 11920823926965723151
  { 150643531, 63, 39582700041ULL },   // factor: 11925755401380169543
  { 150229669, 63, 39743223344ULL },   // factor: 11941222575924386273
  { 150795973, 63, 39636998627ULL },   // factor: 11954199549516258143
  { 150614839, 63, 39900629552ULL },   // factor: 12019253791946244257
  { 150137347, 63, 40078932560ULL },   // factor: 12034689210300636641
  { 150524893, 63, 40098057515ULL },   // factor: 12071511633906441791
  { 150507857, 63, 40155651415ULL },   // factor: 12087482081821335311
  { 150653879, 63, 40358226009ULL },   // factor: 12160246595629077823
  { 150178349, 63, 40579849095ULL },   // factor: 12188429479512488311
  { 150495767, 63, 40838296213ULL },   // factor: 12291981423097260743
  { 150484181, 63, 40921382955ULL },   // factor: 12316041598741069711
  { 150687871, 63, 40892460249ULL },   // factor: 12323995549747879759
  { 150509917, 63, 40999396424ULL },   // factor: 12341631505652673617
  { 150123581, 63, 41240076855ULL },   // factor: 12382216036375635511
  { 150139237, 63, 41489228744ULL },   // factor: 12458322294685256657
  { 150171361, 63, 41558535303ULL },   // factor: 12481803615236114767
  { 150128449, 63, 41577821120ULL },   // factor: 12484027595090085761
  { 150705859, 63, 41478318360ULL },   // factor: 12502051196638542481
  { 150928357, 63, 41510689323ULL },   // factor: 12530280274915664623
  { 150876569, 63, 41543520139ULL },   // factor: 12535887565509446183
  { 150463087, 63, 41671694424ULL },   // factor: 12540103567111453777
  { 150896219, 63, 41589126129ULL },   // factor: 12551283768760412503
  { 150948503, 63, 41713756332ULL },   // factor: 12593258145644341993
  { 150425881, 63, 41868630120ULL },   // factor: 12596251144128271441
  { 150890221, 63, 41817162396ULL },   // factor: 12619601751050659033
  { 150434663, 63, 41995795896ULL },   // factor: 12635246806063086097
  { 150916693, 63, 41931334212ULL },   // factor: 12656276584705601833
  { 150113647, 63, 42159213185ULL },   // factor: 12657346491701671391
  { 150249601, 63, 42177328740ULL },   // factor: 12674253628861665481
  { 150404561, 63, 42138677779ULL },   // factor: 12675698664941900039
  { 150130037, 63, 42257062540ULL },   // factor: 12688108725283027961
  { 150598519, 63, 42245624925ULL },   // factor: 12724257095868972151
  { 150452857, 63, 42363726639ULL },   // factor: 12747487412009115247
  { 150578881, 63, 42399476748ULL },   // factor: 12768931527398717977
  { 150445331, 63, 42461483640ULL },   // factor: 12776263921941769681
  { 150849487, 63, 42368795909ULL },   // factor: 12782622255360697367
  { 150331261, 63, 42569152203ULL },   // factor: 12798948660755835967
  { 150397921, 63, 42587228456ULL },   // factor: 12810061241868879953
  { 150658217, 63, 42548549719ULL },   // factor: 12820577273200782047
  { 150081523, 63, 42770494940ULL },   // factor: 12838122040117987241
  { 150119369, 63, 42830386507ULL },   // factor: 12859341192913908167
  { 150230023, 63, 43093373300ULL },   // factor: 12947836924013171801
  { 150410287, 63, 43047949533ULL },   // factor: 12949708888040091943
  { 150288431, 63, 43225075920ULL },   // factor: 12992457679745363041
  { 150148907, 63, 43390896033ULL },   // factor: 13030191226211171863
  { 150977329, 63, 43349110887ULL },   // factor: 13089465952488161647
  { 150297127, 63, 43683235625ULL },   // factor: 13130929625003098751
  { 150069001, 63, 43766812568ULL },   // factor: 13136083678068009137
  { 150101233, 63, 43840005443ULL },   // factor: 13160877743442022439
  { 150480299, 63, 43750816957ULL },   // factor: 13167272034367260287
  { 150625511, 63, 43710900496ULL },   // factor: 13167953446960306913
  { 150049271, 63, 43897612908ULL },   // factor: 13173609630971180137
  { 150643007, 63, 43767831633ULL },   // factor: 13186635534129680863
  { 150910057, 63, 43693165407ULL },   // factor: 13187476164161596399
  { 150069119, 63, 43997523624ULL },   // factor: 13205339216870734513
  { 150964837, 63, 43816141559ULL },   // factor: 13229393336846721767
  { 150993079, 63, 43863492197ULL },   // factor: 13246167485035009127
  { 150280171, 63, 44076839933ULL },   // factor: 13247750084541737087
  { 150051449, 63, 44151951700ULL },   // factor: 13250128657526026601
  { 150242161, 63, 44104741368ULL },   // factor: 13252783306948832497
  { 150312697, 63, 44191433012ULL },   // factor: 13285066960657106729
  { 150499429, 63, 44154696651ULL },   // factor: 13290513267287424559
  { 150513247, 63, 44292711752ULL },   // factor: 13333279728457157489
  { 150872401, 63, 44206915428ULL },   // factor: 13339206942852605257
  { 150980807, 63, 44333795524ULL },   // factor: 13387104451173015737
  { 150587531, 63, 44759569633ULL },   // factor: 13480466159312092247
  { 150910219, 63, 44830395252ULL },   // factor: 13530729530671760377
  { 150909947, 63, 44833378128ULL },   // factor: 13531605434254878433
  { 150472879, 63, 45166257384ULL },   // factor: 13592593564450977073
  { 150388411, 63, 45199102056ULL },   // factor: 13594842273657346033
  { 150608191, 63, 45235051260ULL },   // factor: 13625538480121741321
  { 150701149, 63, 45205804067ULL },   // factor: 13625133228731545967
  { 150626909, 63, 45361850155ULL },   // factor: 13665430550737641791
  { 150770437, 63, 45352081827ULL },   // factor: 13675506391833096799
  { 150478103, 63, 45557011992ULL },   // factor: 13710665485808822353
  { 150592259, 63, 45528993025ULL },   // factor: 13712627819259986951
  { 150017447, 63, 45720826888ULL },   // factor: 13717843448933429873
  { 150997529, 63, 45442219236ULL },   // factor: 13723325633824535689
  { 150700391, 63, 45608216296ULL },   // factor: 13746352057239543473
  { 150028157, 63, 45840635667ULL },   // factor: 13754772169656951439
  { 150649069, 63, 45707002796ULL },   // factor: 13771434835995593849
  { 150765463, 63, 45871867040ULL },   // factor: 13831786545920079041
  { 150025397, 63, 46183480779ULL },   // factor: 13857390077422688527
  { 150309191, 63, 46113813861ULL },   // factor: 13862660110742992903
  { 150609611, 63, 46388284524ULL },   // factor: 13973042974233920329
  { 150308989, 63, 46596717315ULL },   // factor: 14007810940672889071
  { 150743431, 63, 46527660968ULL },   // factor: 14027478501442202417
  { 150084989, 63, 46906591812ULL },   // factor: 14079950632263020137
  { 150918853, 63, 46752989147ULL },   // factor: 14111814992773376783
  { 150913759, 63, 46874671512ULL },   // factor: 14148065759532267217
  { 150516313, 63, 47013765176ULL },   // factor: 14152677189078632177
  { 150910631, 63, 46894616025ULL },   // factor: 14153792189670923551
  { 150475121, 63, 47057225011ULL },   // factor: 14161883254908902663
  { 150423787, 63, 47133810552ULL },   // factor: 14180092557944800849
  { 150835621, 63, 47053066808ULL },   // factor: 14194557103878335537
  { 150700997, 63, 47128526664ULL },   // factor: 14204631910811768017
  { 150176149, 63, 47436338547ULL },   // factor: 14247613291297431007
  { 150470189, 63, 47401261992ULL },   // factor: 14264953701549512977
  { 150715069, 63, 47579155275ULL },   // factor: 14341791340466677951
  { 150061321, 63, 47791418196ULL },   // factor: 14343286693910393833
  { 150663943, 63, 47695615196ULL },   // factor: 14372018898480155657
  { 150447527, 63, 47868723012ULL },   // factor: 14403461995606782649
  { 150646697, 63, 47848226647ULL },   // factor: 14416354603355869919
  { 150103567, 63, 48119871257ULL },   // factor: 14445928638512947439
  { 150112297, 63, 48240673523ULL },   // factor: 14483036622729224663
  { 150374659, 63, 48211081721ULL },   // factor: 14499449947633016279
  { 150754501, 63, 48286190624ULL },   // factor: 14558721145423997249
  { 150404479, 63, 48479035556ULL },   // factor: 14582928170445310649
  { 150519157, 63, 48485587403ULL },   // factor: 14596019485098758543
  { 150062291, 63, 48697312221ULL },   // factor: 14615260474851116623
  { 150672601, 63, 48667415528ULL },   // factor: 14665692163103096657
  { 150642677, 63, 48745733620ULL },   // factor: 14686375609691401481
  { 150178879, 63, 48944720924ULL },   // factor: 14700926642668328393
  { 150750631, 63, 48814070276ULL },   // factor: 14717503791570688313
  { 150202433, 63, 49038724752ULL },   // factor: 14731471537935443233
  { 150798751, 63, 48994328108ULL },   // factor: 14776566969541186217
  { 150345883, 63, 49241603768ULL },   // factor: 14806544797672174289
  { 150413257, 63, 49341496443ULL },   // factor: 14843230370491089703
  { 150635041, 63, 49300928363ULL },   // factor: 14852894730597135767
  { 150118811, 63, 49476594465ULL },   // factor: 14854735066829962231
  { 150924083, 63, 49489361328ULL },   // factor: 14938272953368124449
  { 150347993, 63, 49731138880ULL },   // factor: 14953953840424535681
  { 150289277, 63, 49935776392ULL },   // factor: 15009623460774697169
  { 150145319, 63, 50039257597ULL },   // factor: 15026320588849476887
  { 150387521, 63, 49962889431ULL },   // factor: 15027590167050381103
  { 150755959, 63, 49891291776ULL },   // factor: 15042819074879386369
  { 150188747, 63, 50090700585ULL },   // factor: 15046119114426633991
  { 150126637, 63, 50170416404ULL },   // factor: 15063831783244306697
  { 150488293, 63, 50206823091ULL },   // factor: 15111078207835147327
  { 150293089, 63, 50283961487ULL },   // factor: 15114663798076526687
  { 150037141, 63, 50414529804ULL },   // factor: 15128103833302900729
  { 150637469, 63, 50490556027ULL },   // factor: 15211539136619951327
  { 150063713, 63, 50725241692ULL },   // factor: 15224036222247844793
  { 150343877, 63, 50645686084ULL },   // factor: 15228537598387015337
  { 150375119, 63, 50665684272ULL },   // factor: 15237716603236856737
  { 150642721, 63, 50606806103ULL },   // factor: 15247093944950652527
  { 150502201, 63, 50701364319ULL },   // factor: 15261333847424732239
  { 150510473, 63, 50698721275ULL },   // factor: 15261377039190826151
  { 150398687, 63, 50846252869ULL },   // factor: 15294419340735166007
  { 150309491, 63, 50970409360ULL },   // factor: 15322672573926471521
  { 150541561, 63, 51269220624ULL },   // factor: 15436297007980708129
  { 150485477, 63, 51336863740ULL },   // factor: 15450904855195807961
  { 150645529, 63, 51312044639ULL },   // factor: 15459860217427538063
  { 150298891, 63, 51807192429ULL },   // factor: 15573127135804592479
  { 150210397, 63, 51888112763ULL },   // factor: 15588268035421993823
  { 150477407, 63, 51799352008ULL },   // factor: 15589264348888166513
  { 150047809, 63, 52078945820ULL },   // factor: 15628663430641416761
  { 150773281, 63, 52041355391ULL },   // factor: 15692891799976215743
  { 150980029, 63, 52075012491ULL },   // factor: 15724573792133084479
  { 150063637, 63, 52447117887ULL },   // factor: 15740810520581950039
  { 150735883, 63, 52220913372ULL },   // factor: 15743130976389854953
  { 150443269, 63, 52336832280ULL },   // factor: 15747448274615846641
  { 150934561, 63, 52225269479ULL },   // factor: 15765196243839127439
  { 150109903, 63, 52568222265ULL },   // factor: 15782021490163180591
  { 150820463, 63, 52386698748ULL },   // factor: 15801972320429760649
  { 150466091, 63, 52526553141ULL },   // factor: 15806930249660083663
  { 150359221, 63, 52653705968ULL },   // factor: 15833940424223061857
  { 150594929, 63, 52636754136ULL },   // factor: 15853656503802752689
  { 150679579, 63, 52617107472ULL },   // factor: 15856647204157428577
  { 150581521, 63, 52676411891ULL },   // factor: 15864188446738532423
  { 150071737, 63, 52999772348ULL },   // factor: 15907535793737856953
  { 150502727, 63, 52933327744ULL },   // factor: 15933220349313515777
  { 150872747, 63, 52827465664ULL },   // factor: 15940449723551718017
  { 150616849, 63, 52937260472ULL },   // factor: 15946486733969785457
  { 150581077, 63, 52973565363ULL },   // factor: 15953633049780871903
  { 150984371, 63, 53046986685ULL },   // factor: 16018531836160200271
  { 150876767, 63, 53175779380ULL },   // factor: 16045979351119328921
  { 150222133, 63, 53446021655ULL },   // factor: 16057550746756580231
  { 150724493, 63, 53460224775ULL },   // factor: 16115530549755828151
  { 150808429, 63, 53448887004ULL },   // factor: 16121085361743513433
  { 150576593, 63, 53763442452ULL },   // factor: 16191031984747452073
  { 150763061, 63, 53736726940ULL },   // factor: 16203026883191126681
  { 150187111, 63, 53945372468ULL },   // factor: 16203799285575719897
  { 150948601, 63, 53783719239ULL },   // factor: 16237154351407669279
  { 150960041, 63, 53785199883ULL },   // factor: 16238831959061750407
  { 150351913, 63, 54068054708ULL },   // factor: 16258470915072912809
  { 150527501, 63, 54036810471ULL },   // factor: 16268052084420525943
  { 150541163, 63, 54061935996ULL },   // factor: 16277093437738806697
  { 150107717, 63, 54275542080ULL },   // factor: 16294355421132462721
  { 150946151, 63, 54021102996ULL },   // factor: 16308555140041536793
  { 150695243, 63, 54164241252ULL },   // factor: 16324586994761528473
  { 150129923, 63, 54460328985ULL },   // factor: 16352249994145436311
  { 150045409, 63, 54506801979ULL },   // factor: 16356990792442128823
  { 150643547, 63, 54717461769ULL },   // factor: 16485665047438109287
  { 150553691, 63, 54775023841ULL },   // factor: 16493164027751094263
  { 150373693, 63, 54872399748ULL },   // factor: 16502730787758058729
  { 150333241, 63, 55183142988ULL },   // factor: 16591721467904928217
  { 150985301, 63, 55075975020ULL },   // factor: 16631325332526362041
  { 150008317, 63, 55436708079ULL },   // factor: 16631934557902186087
  { 150275141, 63, 55550544823ULL },   // factor: 16695731911806290087
  { 150931817, 63, 55417685040ULL },   // factor: 16728583794041835361
  { 150394061, 63, 55642017444ULL },   // factor: 16736457931272000169
  { 150387353, 63, 56418126003ULL },   // factor: 16969145261623280119
  { 150701647, 63, 56304159668ULL },   // factor: 16970259189837146393
  { 150411227, 63, 56556949905ULL },   // factor: 17013600461177166871
  { 150436511, 63, 56606201061ULL },   // factor: 17031278777162676343
  { 150753751, 63, 56615559909ULL },   // factor: 17070016042493937319
  { 150583259, 63, 56711281092ULL },   // factor: 17079539057796877657
  { 150696527, 63, 56998594104ULL },   // factor: 17178980350710953617
  { 150189719, 63, 57225463377ULL },   // factor: 17189352528472842127
  { 150645893, 63, 57287083131ULL },   // factor: 17260127591269461967
  { 150353641, 63, 57421370723ULL },   // factor: 17267024318827704887
  { 150535547, 63, 57402455509ULL },   // factor: 17282220078380956847
  { 150569701, 63, 57447783968ULL },   // factor: 17299791310348707137
  { 150478511, 63, 57488111584ULL },   // factor: 17301450862724342849
  { 150781837, 63, 57430184240ULL },   // factor: 17318857357911297761
  { 150417919, 63, 57615582584ULL },   // factor: 17332832068515845393
  { 150899951, 63, 57462189025ULL },   // factor: 17342083016450475551
  { 150897973, 63, 57766379652ULL },   // factor: 17433659194070490793
  { 150510161, 63, 58050542791ULL },   // factor: 17474393083221598703
  { 150590189, 63, 58021543872ULL },   // factor: 17474950515512543617
  { 150276649, 63, 58245920712ULL },   // factor: 17506003565038108177
  { 150172483, 63, 58313775357ULL },   // factor: 17514248876929802863
  { 150141469, 63, 58387790024ULL },   // factor: 17532857131733810513
  { 150540431, 63, 58341041613ULL },   // factor: 17565371098819910407
  { 150840169, 63, 58359991295ULL },   // factor: 17606061899552657711
  { 150317333, 63, 58610938792ULL },   // factor: 17620480007679363473
  { 150843569, 63, 58694712939ULL },   // factor: 17707439962298478583
  { 150254227, 63, 58935198164ULL },   // factor: 17710525286447278457
  { 150522287, 63, 58886812165ULL },   // factor: 17727555282430442711
  { 150664747, 63, 58931193009ULL },   // factor: 17757706570218307447
  { 150078199, 63, 59203529840ULL },   // factor: 17770318265659916321
  { 150173489, 63, 59351413200ULL },   // factor: 17826017594649309601
  { 150269237, 63, 59360692564ULL },   // factor: 17840171958767707337
  { 150572561, 63, 59371772991ULL },   // factor: 17879519820730999903
  { 150157793, 63, 59545136515ULL },   // factor: 17882332565952222791
  { 150272137, 63, 59511054719ULL },   // factor: 17885706735496129007
  { 150279047, 63, 59562203668ULL },   // factor: 17901902408893888793
  { 150409913, 63, 59591212875ULL },   // factor: 17926218288186459751
  { 150748879, 63, 59526061272ULL },   // factor: 17946974016078628177
  { 150368563, 63, 59758898877ULL },   // factor: 17971719501193607503
  { 150167587, 63, 60029144153ULL },   // factor: 18028863454262337623
  { 150033133, 63, 60112103687ULL },   // factor: 18037614494762922743
  { 150449879, 63, 59997176884ULL },   // factor: 18053136005078794073
  { 150672947, 63, 60045396997ULL },   // factor: 18094433838645880319
  { 150099077, 63, 60338403552ULL },   // factor: 18113477361617443009
  { 150428099, 63, 60545998417ULL },   // factor: 18215638887852638567
  { 150047767, 63, 60781290692ULL },   // factor: 18240193887424969529
  { 150623269, 63, 60550390400ULL },   // factor: 18240595482548435201
  { 150847583, 63, 60907690453ULL },   // factor: 18375555781894450199
  { 150233147, 63, 61216233945ULL },   // factor: 18393414946091149831
  { 150583481, 63, 61096962148ULL },   // factor: 18400386477542154377
  { 150187313, 63, 61282818555ULL },   // factor: 18407803703683985431
  { 150947273, 63, 60975500716ULL },   // factor: 18408171105779494937
  { 150928403, 64, 61198918500ULL },   // factor: 18473310069064311001
  { 150228313, 64, 61823500760ULL },   // factor: 18575280445858035761
  { 150824633, 64, 61813632732ULL },   // factor: 18646036942401374713
  { 150849731, 64, 61841666989ULL },   // factor: 18657597659764459919
  { 150690929, 64, 62375196447ULL },   // factor: 18798752598311858527
  { 150588629, 64, 62575099455ULL },   // factor: 18846196872934194391
  { 150920261, 64, 62460320743ULL },   // factor: 18853055817354547847
  { 150484949, 64, 62734454344ULL },   // factor: 18881182324999336913
  { 150100879, 64, 63204430205ULL },   // factor: 18974081060929300391
  { 150214877, 64, 63163775919ULL },   // factor: 18976277661056293927
  { 150707603, 64, 63241508832ULL },   // factor: 19061952412348099393
  { 150069253, 64, 63611899235ULL },   // factor: 19092380400215442911
  { 150430261, 64, 63691998219ULL },   // factor: 19162407831391410319
  { 150362243, 64, 63927833752ULL },   // factor: 19224664946163651473
  { 150796523, 64, 64041537045ULL },   // factor: 19314482227923389071
  { 150544159, 64, 64244623172ULL },   // factor: 19343305531401304697
  { 150786023, 64, 64241530752ULL },   // factor: 19373449867052558593
  { 150077467, 64, 64623210980ULL },   // factor: 19396975626569975321
  { 150907733, 64, 64291644807ULL },   // factor: 19404212737331185063
  { 150240511, 64, 64686615128ULL },   // factor: 19437100223382100817
  { 150727097, 64, 64505327500ULL },   // factor: 19445401510218535001
  { 150749941, 64, 64535210871ULL },   // factor: 19457358462451617223
  { 150880277, 64, 64546056508ULL },   // factor: 19477453770369385433
  { 150858671, 64, 64629296028ULL },   // factor: 19499779412899317577
  { 150409433, 64, 64934085463ULL },   // factor: 19533397953726744959
  { 150006641, 64, 65214841384ULL },   // factor: 19565318598723262289
  { 150035027, 64, 65210231949ULL },   // factor: 19567637822288955247
  { 150893189, 64, 64920290559ULL },   // factor: 19592059346508205303
  { 150005117, 64, 65418788748ULL },   // factor: 19626306120284047033
  { 150190627, 64, 65351763765ULL },   // factor: 19630444750842461311
  { 150637943, 64, 65451824125ULL },   // factor: 19719056303575549751
  { 150105077, 64, 65847900795ULL },   // factor: 19768208438243672431
  { 150116833, 64, 66238705695ULL },   // factor: 19887089441904927871
  { 150134857, 64, 66447539040ULL },   // factor: 19952183543544634561
  { 150444367, 64, 66348731889ULL },   // factor: 19963585940586638527
  { 150802969, 64, 66197323196ULL },   // factor: 19965505755618737849
  { 150815311, 64, 66189241580ULL },   // factor: 19964702107483662761
  { 150520577, 64, 66569283019ULL },   // factor: 20040093780992363927
  { 150600377, 64, 66597394168ULL },   // factor: 20059185337836802673
  { 150349723, 64, 66933874292ULL },   // factor: 20126978918238042233
  { 150655301, 64, 67047690360ULL },   // factor: 20202179945081196721
  { 150427933, 64, 67360903932ULL },   // factor: 20265923087004665113
  { 150529697, 64, 67325912728ULL },   // factor: 20269098486388566833
  { 150804151, 64, 67276118568ULL },   // factor: 20291035886445151537
  { 150597683, 64, 67396187293ULL },   // factor: 20299419298719684239
  { 150017393, 64, 67688856727ULL },   // factor: 20309011642670105423
  { 150206741, 64, 67620768420ULL },   // factor: 20314190496567838441
  { 150468743, 64, 67644051676ULL },   // factor: 20356630854229526537
  { 150316493, 64, 67724789880ULL },   // factor: 20360305807846981681
  { 150288293, 64, 67849773387ULL },   // factor: 20394053245538116783
  { 150242483, 64, 67891202241ULL },   // factor: 20400285597086008807
  { 150672329, 64, 67848080275ULL },   // factor: 20445656546426420951
  { 150037577, 64, 68274481524ULL },   // factor: 20487475557584454697
  { 150851971, 64, 67905344580ULL },   // factor: 20487310142654334361
  { 150819307, 64, 67952049257ULL },   // factor: 20496961956341209799
  { 150378671, 64, 68187542020ULL },   // factor: 20507903895448510841
  { 150080521, 64, 68553296739ULL },   // factor: 20577028981713442039
  { 150252617, 64, 68502646243ULL },   // factor: 20585403738871935863
  { 150030847, 64, 68617692920ULL },   // factor: 20589541175947006481
  { 150785081, 64, 68312604715ULL },   // factor: 20601043270544513831
  { 150671959, 64, 68376440636ULL },   // factor: 20604824520146651849
  { 150874259, 64, 68560446001ULL },   // factor: 20688012974220776519
  { 150382201, 64, 68798136995ULL },   // factor: 20692030532015251991
  { 150097151, 64, 68977455861ULL },   // factor: 20706639215928704023
  { 150504953, 64, 69021348580ULL },   // factor: 20776109648059033481
  { 150613193, 64, 69012108315ULL },   // factor: 20788267977967999591
  { 150114863, 64, 69479585380ULL },   // factor: 20859836881231005881
  { 150113591, 64, 69621363708ULL },   // factor: 20902225833049910857
  { 150441199, 64, 69470902172ULL },   // factor: 20902571636734768457
  { 150984151, 64, 69339762009ULL },   // factor: 20938410194941838719
  { 150193093, 64, 69897931431ULL },   // factor: 20996373031847612167
  { 150154363, 64, 69978555341ULL },   // factor: 21015170801776205567
  { 150181699, 64, 70026386937ULL },   // factor: 21033363530060131927
  { 150104803, 64, 70123058573ULL },   // factor: 21051615785715252239
  { 150311597, 64, 70108968960ULL },   // factor: 21076382176802058241
  { 150543637, 64, 70103433527ULL },   // factor: 21107251698684635399
  { 150956129, 64, 69972190420ULL },   // factor: 21125462006908168361
  { 150036427, 64, 70664885648ULL },   // factor: 21204613913978999393
  { 150524741, 64, 70478341224ULL },   // factor: 21217468117704445969
  { 150894269, 64, 70597911675ULL },   // factor: 21305640550251381151
  { 150383731, 64, 71316458421ULL },   // factor: 21449670198112697503
  { 150421981, 64, 71858705564ULL },   // factor: 21618257686065204569
  { 150654157, 64, 71864261367ULL },   // factor: 21653299429346105239
  { 150612463, 64, 72025373820ULL },   // factor: 21695837899051837321
  { 150030557, 64, 72341646535ULL },   // factor: 21706915047886339991
  { 150937673, 64, 72405150012ULL },   // factor: 21857329712054404153
  { 150191627, 64, 72916379980ULL },   // factor: 21902859488292854921
  { 150069541, 64, 73023274511ULL },   // factor: 21917138576365538903
  { 150256853, 64, 72974148168ULL },   // factor: 21929731708158790609
  { 150630923, 64, 72948442260ULL },   // factor: 21976582378072011961
  { 150698089, 64, 72938483835ULL },   // factor: 21983380256983782631
  { 150309373, 64, 73368919652ULL },   // factor: 22056072621158996393
  { 150448273, 64, 73474295403ULL },   // factor: 22108161706546378039
  { 150110437, 64, 73841065439ULL },   // factor: 22168629203187773687
  { 150960373, 64, 73546604936ULL },   // factor: 22205245828044402257
  { 150472019, 64, 73845943209ULL },   // factor: 22223496339235137943
  { 150527017, 64, 73888767515ULL },   // factor: 22244511527678905511
  { 150422617, 64, 74025877863ULL },   // factor: 22270332547749654943
  { 150531961, 64, 74083810988ULL },   // factor: 22303962692753974937
  { 150275557, 64, 74297787788ULL },   // factor: 22330282887418995833
  { 150624853, 64, 74162345612ULL },   // factor: 22341384811885390073
  { 150125981, 64, 74698388079ULL },   // factor: 22428337578957160999
  { 150259873, 64, 74821189200ULL },   // factor: 22485244773801943201
  { 150591263, 64, 74883198520ULL },   // factor: 22553510885213061521
  { 150788273, 64, 74813547676ULL },   // factor: 22562011302134407097
  { 150012997, 64, 75322726560ULL },   // factor: 22598775906954200641
  { 150202709, 64, 75385582932ULL },   // factor: 22646237551861125577
  { 150732541, 64, 75225492000ULL },   // factor: 22677859114270344001
  { 150539177, 64, 75379295164ULL },   // factor: 22695074113657280057
  { 150164257, 64, 75827515919ULL },   // factor: 22773165176264614367
  { 150672979, 64, 75787900985ULL },   // factor: 22838377627133968631
  { 150470389, 64, 76403358291ULL },   // factor: 22992886085906290399
  { 150556579, 64, 76605503720ULL },   // factor: 23066925145309947761
  { 150345407, 64, 77037808893ULL },   // factor: 23164561464812608903
  { 150211429, 64, 77348483775ULL },   // factor: 23237252557652128951
  { 150878347, 64, 77143680392ULL },   // factor: 23278621958082544049
  { 150989483, 64, 77100594877ULL },   // factor: 23282757918941357183
  { 150429001, 64, 77835717659ULL },   // factor: 23417498499122857319
  { 150984709, 64, 77560279640ULL },   // factor: 23420832502808049521
  { 150758137, 64, 78207162995ULL },   // factor: 23580732386363080631
  { 150241447, 64, 78562713620ULL },   // factor: 23606751549030816281
  { 150882257, 64, 78727401304ULL },   // factor: 23757135992984526257
  { 150036697, 64, 79244680767ULL },   // factor: 23779220314200213199
  { 150910687, 64, 78784163013ULL },   // factor: 23778744330023639863
  { 150162437, 64, 79242847360ULL },   // factor: 23798598148793232641
  { 150689753, 64, 79016728068ULL },   // factor: 23814022470870174409
  { 150005293, 64, 79463551356ULL },   // factor: 23839906607954654617
  { 150849533, 64, 79074671916ULL },   // factor: 23856754661313630457
  { 150651089, 64, 79241578564ULL },   // factor: 23875660209491312393
  { 150241639, 64, 79474898937ULL },   // factor: 23880878151308475487
  { 150814747, 64, 79385037569ULL },   // factor: 23944868713108460087
  { 150113303, 64, 79839075240ULL },   // factor: 23969814585483835441
  { 150030407, 64, 80107466713ULL },   // factor: 24037111669380684383
  { 150461161, 64, 79878284168ULL },   // factor: 24037158749210398097
  { 150344333, 64, 79959603447ULL },   // factor: 24042946494367431703
  { 150249109, 64, 80099144900ULL },   // factor: 24069650305773788201
  { 150136967, 64, 80465666689ULL },   // factor: 24161742288638784527
  { 150461527, 64, 80433378240ULL },   // factor: 24204257823517944961
  { 150470471, 64, 80451614580ULL },   // factor: 24211184677126134361
  { 150598361, 64, 80386244704ULL },   // factor: 24212073398734660289
  { 150741263, 64, 80321568613ULL },   // factor: 24215549397729556439
  { 150797663, 64, 80340197088ULL },   // factor: 24230227931659610689
  { 150256207, 64, 80826623684ULL },   // factor: 24289403798748413177
  { 150599467, 64, 80663172345ULL },   // factor: 24295661523372280231
  { 150391427, 64, 80844318669ULL },   // factor: 24316584898947301327
  { 150713557, 64, 80671132227ULL },   // factor: 24316466570297002879
  { 150876997, 64, 81065318835ULL },   // factor: 24461783733344676991
  { 150349763, 64, 81546663052ULL },   // factor: 24521042926618113353
  { 150939973, 64, 81475704836ULL },   // factor: 24595881376203618857
  { 150150347, 64, 81928546024ULL },   // factor: 24603199229418140657
  { 150266647, 64, 82120694465ULL },   // factor: 24680002813134017711
  { 150353543, 64, 82308958900ULL },   // factor: 24750887182512765401
  { 150455047, 64, 82310190624ULL },   // factor: 24767967197825758657
  { 150766279, 64, 82176657485ULL },   // factor: 24778937739341896631
  { 150643033, 64, 82342831088ULL },   // factor: 24808747641806019809
  { 150527771, 64, 82444181445ULL },   // factor: 24820277729670818191
  { 150773309, 64, 82487377260ULL },   // factor: 24873789640443106681
  { 150475151, 64, 82982772465ULL },   // factor: 24973690434139034431
  { 150111029, 64, 83537352399ULL },   // factor: 25079755857099017143
  { 150222463, 64, 83569806108ULL },   // factor: 25108124211952408009
  { 150896617, 64, 83490689508ULL },   // factor: 25196925195509188873
  { 150469421, 64, 83792946168ULL },   // factor: 25216552187566257457
  { 150731419, 64, 83776224521ULL },   // factor: 25255418401025850599
  { 150440167, 64, 83963586293ULL },   // factor: 25262991887675661863
  { 150428141, 64, 84024085000ULL },   // factor: 25279173811551970001
  { 150924359, 64, 83856563365ULL },   // factor: 25311996147611016071
  { 150530983, 64, 84305357220ULL },   // factor: 25381136588985494521
  { 150504883, 64, 84356362668ULL },   // factor: 25392088987305815689
  { 150681991, 64, 84264919329ULL },   // factor: 25394411631896208079
  { 150276419, 64, 84631141237ULL },   // factor: 25436129681959180607
  { 150726347, 64, 85096194792ULL },   // factor: 25652477169197169649
  { 150557753, 64, 85362690415ULL },   // factor: 25704029717834074991
  { 150425081, 64, 85535249191ULL },   // factor: 25733293575822718943
  { 150208273, 64, 85746586983ULL },   // factor: 25759693492721420719
  { 150323549, 64, 85750733424ULL },   // factor: 25780709155297203553
  { 150838693, 64, 85557961592ULL },   // factor: 25810902204562958513
  { 150796621, 64, 85629190208ULL },   // factor: 25825185084665374337
  { 150662791, 64, 85717952840ULL },   // factor: 25829012027361552881
  { 150366707, 64, 85960506105ULL },   // factor: 25851196470124492471
  { 150296233, 64, 86042636732ULL },   // factor: 25863768356414061113
  { 150497339, 64, 86047325089ULL },   // factor: 25899786907924876343
  { 150726767, 64, 85986722488ULL },   // factor: 25921001371084872593
  { 150867089, 64, 86024575524ULL },   // factor: 25956554583533059273
  { 150988417, 64, 86403419172ULL },   // factor: 26091830968335461449
  { 150871769, 64, 86769704716ULL },   // factor: 26182197692221125209
  { 150143041, 64, 87201647688ULL },   // factor: 26185441128173878417
  { 150687139, 64, 87035350140ULL },   // factor: 26230215808919698921
  { 150381487, 64, 87345537260ULL },   // factor: 26270303551945411241
  { 150500489, 64, 87364015195ULL },   // factor: 26296654015701860711
  { 150331583, 64, 87532704633ULL },   // factor: 26317860103500648079
  { 150458863, 64, 87541138572ULL },   // factor: 26342680350537127273
  { 150747943, 64, 87659890533ULL },   // factor: 26429096362909847239
  { 150522443, 64, 87892017217ULL },   // factor: 26459442303401802263
  { 150050573, 64, 88776941608ULL },   // factor: 26642061914935882769
  { 150876443, 64, 88309523065ULL },   // factor: 26647653446147315591
  { 150566959, 64, 88612744325ULL },   // factor: 26684302883319515351
  { 150802423, 64, 88508083160ULL },   // factor: 26694466791226993361
  { 150195079, 64, 89021836829ULL },   // factor: 26741283630513528983
  { 150655423, 64, 88938961496ULL },   // factor: 26798273730721185617
  { 150326353, 64, 89507091692ULL },   // factor: 26910549323389918553
  { 150323081, 64, 89900629104ULL },   // factor: 27028279101503098849
  { 150478637, 64, 89927473195ULL },   // factor: 27064327190475270431
  { 150065381, 64, 90186515220ULL },   // factor: 27067747535103197641
  { 150910537, 64, 89680617483ULL },   // factor: 27067500285702236743
  { 150281213, 64, 90232832740ULL },   // factor: 27120599113186627241
  { 150985157, 64, 90287494780ULL },   // factor: 27264143148989960921
  { 150052571, 64, 91192031908ULL },   // factor: 27367197685018870937
  { 150068927, 64, 91291320985ULL },   // factor: 27399981169263066191
  { 150194959, 64, 91260388560ULL },   // factor: 27413700636186538081
  { 150343777, 64, 91351916732ULL },   // factor: 27468384395356753529
  { 150015781, 64, 91704999863ULL },   // factor: 27514394352105676007
  { 150552859, 64, 91387722800ULL },   // factor: 27517365890078970401
  { 150840883, 64, 91791028077ULL },   // factor: 27691679453224943983
  { 150082789, 64, 92293732892ULL },   // factor: 27703401679304791577
  { 150314473, 64, 92192192387ULL },   // factor: 27715641626733034103
  { 150777793, 64, 91956763620ULL },   // factor: 27730075740092581321
  { 150525071, 64, 92177131104ULL },   // factor: 27749938408011816769
  { 150128141, 64, 92532963904ULL },   // factor: 27783603704255244929
  { 150132713, 64, 92771052483ULL },   // factor: 27855939594276352759
  { 150874583, 64, 92659364968ULL },   // factor: 27959886101183616689
  { 150478381, 64, 93119234616ULL },   // factor: 28024863329949673393
  { 150259537, 64, 93756361764ULL },   // factor: 28175575018926286537
  { 150944047, 64, 93695230380ULL },   // factor: 28285474516309095721
  { 150122561, 64, 94413200776ULL },   // factor: 28347102985400614673
  { 150721687, 64, 94106341149ULL },   // factor: 28367732990749596727
  { 150264731, 64, 94404783801ULL },   // factor: 28371418885940845063
  { 150319339, 64, 94482824489ULL },   // factor: 28405191448078985543
  { 150746017, 64, 94659098108ULL },   // factor: 28538964025186471673
  { 150444193, 64, 94888381103ULL },   // factor: 28550811840234569759
  { 150868517, 64, 94680055479ULL },   // factor: 28568479119188909287
  { 150637057, 64, 95295569099ULL },   // factor: 28710088148427003287
  { 150966689, 64, 95161873891ULL },   // factor: 28732546040719633799
  { 150571301, 64, 95639127535ULL },   // factor: 28801015718899746071
  { 150451393, 64, 96010479891ULL },   // factor: 28889820884398876327
  { 150026363, 64, 96296648932ULL },   // factor: 28894072016711588633
  { 150275603, 64, 96231821877ULL },   // factor: 28922590120709533663
  { 150452287, 64, 96205869740ULL },   // factor: 28948786250414190761
  { 150750239, 64, 96312313576ULL },   // factor: 29038208580449889329
  { 150971363, 64, 96779024088ULL },   // factor: 29221722352750383889
  { 150799709, 64, 96921567891ULL },   // factor: 29231488467573087439
  { 150737897, 64, 97099655107ULL },   // factor: 29273195620508979959
  { 150916177, 64, 97463852655ULL },   // factor: 29417744076767799871
  { 150033941, 64, 98091856084ULL },   // factor: 29434215496574694089
  { 150942199, 64, 97631968160ULL },   // factor: 29473567933536767681
  { 150598583, 64, 97924947780ULL },   // factor: 29494716752033991481
  { 150408827, 64, 98303516893ULL },   // factor: 29571433331701629023
  { 150960343, 64, 97972903752ULL },   // factor: 29580046310215813873
  { 150452069, 64, 98429272711ULL },   // factor: 29617775459070378119
  { 150387161, 64, 98512556064ULL },   // factor: 29630047258636588609
  { 150532783, 64, 98500754337ULL },   // factor: 29655185355895859743
  { 150185159, 64, 98744122896ULL },   // factor: 29659803594902600929
  { 150218791, 64, 99116516460ULL },   // factor: 29778326541505599721
  { 150215543, 64, 99347963373ULL },   // factor: 29847216528038613079
  { 150009311, 64, 99554813565ULL },   // factor: 29868297979238207431
  { 150767371, 64, 99458491569ULL },   // factor: 29990190594967590199
  { 150351433, 64, 99809505531ULL },   // factor: 30013004367214551847
  { 150280043, 64, 100153867465ULL },   // factor: 30102255018513001991
  { 150196559, 64, 100388950929ULL },   // factor: 30156149982311306623
  { 150742381, 64, 100119117831ULL },   // factor: 30184388410928991223
  { 150931309, 64, 100049348627ULL },   // factor: 30201158305740925487
  { 150414703, 64, 100710151776ULL },   // factor: 30296575136943925057
  { 150807659, 64, 100449239317ULL },   // factor: 30297029259455057807
  { 150880913, 64, 100881507243ULL },   // factor: 30442187835279905719
  { 150300511, 64, 101301315285ULL },   // factor: 30451278904615221271
  { 150660161, 64, 101075385520ULL },   // factor: 30456067711160537441
  { 150030869, 64, 101691171364ULL },   // factor: 30513629618737670633
  { 150125903, 64, 101721252621ULL },   // factor: 30541989808037483527
  { 150347891, 64, 102037403040ULL },   // factor: 30682216700361977281
  { 150105847, 64, 102228074049ULL },   // factor: 30690063284607729007
  { 150328879, 64, 102222710609ULL },   // factor: 30734050988384754623
  { 150330409, 64, 102380829215ULL },   // factor: 30781903859300197871
  { 150309539, 64, 103219212952ULL },   // factor: 31029664629515898257
  { 150994231, 64, 102865194665ULL },   // factor: 31064101930213955231
  { 150315089, 64, 103361467036ULL },   // factor: 31073576233373812409
  { 150320549, 64, 103627042996ULL },   // factor: 31154547988810649609
  { 150237013, 64, 103766161880ULL },   // factor: 31179036422651328881
  { 150431851, 64, 103743093968ULL },   // factor: 31212531308146349537
  { 150778703, 64, 103574479965ULL },   // factor: 31233651506044370791
  { 150652319, 64, 103695970729ULL },   // factor: 31244076922559941103
  { 150063769, 64, 104327432471ULL },   // factor: 31311535453382486399
  { 150689107, 64, 103937811533ULL },   // factor: 31324592006884142063
  { 150402617, 64, 104878411615ULL },   // factor: 31547975147398392911
  { 150282581, 64, 105022067064ULL },   // factor: 31565974600666024369
  { 150373147, 64, 105698062964ULL },   // factor: 31788300719401655417
  { 150734587, 64, 106188335525ULL },   // factor: 32012509799156606351
  { 150181337, 64, 106716902983ULL },   // factor: 32053774340972456543
  { 150754577, 64, 106394518852ULL },   // factor: 32078921369303571209
  { 150787019, 64, 106568394832ULL },   // factor: 32138261152664571617
  { 150800569, 64, 106651608275ULL },   // factor: 32166246425270216951
  { 150961667, 64, 106645228092ULL },   // factor: 32198682820727098729
  { 150683881, 64, 107403548300ULL },   // factor: 32367966982029904601
  { 150645673, 64, 107529953492ULL },   // factor: 32397844422922080233
  { 150577289, 64, 107634474336ULL },   // factor: 32414614696909910209
  { 150087643, 64, 108052651712ULL },   // factor: 32434735630707989633
  { 150769049, 64, 107887018132ULL },   // factor: 32532046246414792937
  { 150497927, 64, 108170154025ULL },   // factor: 32558767888066412351
  { 150799007, 64, 108097280728ULL },   // factor: 32601925186365274193
  { 150161593, 64, 108648379568ULL },   // factor: 32629627505599063649
  { 150527561, 64, 108515055819ULL },   // factor: 32669013368425854919
  { 150780563, 64, 108385686805ULL },   // factor: 32684909755199142431
  { 150516187, 64, 108693258825ULL },   // factor: 32720189741886200551
  { 150076369, 64, 109067653304ULL },   // factor: 32736954766430346353
  { 150362969, 64, 108893862891ULL },   // factor: 32747209060339366759
  { 150396721, 64, 109344005904ULL },   // factor: 32889959897932481569
  { 150895421, 64, 109149110259ULL },   // factor: 32940201888614448079
  { 150240109, 64, 110130569787ULL },   // factor: 33092057618061973567
  { 150941179, 64, 109709238096ULL },   // factor: 33119283490803910369
  { 150924161, 64, 110007222204ULL },   // factor: 33205495430158541689
  { 150192989, 64, 110817318604ULL },   // factor: 33287968628200134713
  { 150185569, 64, 111043629356ULL },   // factor: 33354301317311927129
  { 150383957, 64, 111018293143ULL },   // factor: 33390740444460613703
  { 150702577, 64, 111213395072ULL },   // factor: 33520290468539001089
  { 150313477, 64, 111709475703ULL },   // factor: 33582879413529898663
  { 150699599, 64, 111425230321ULL },   // factor: 33583475055714682559
  { 150200689, 64, 112102217159ULL },   // factor: 33675660511418845103
  { 150592073, 64, 111933490372ULL },   // factor: 33712592706490042313
  { 150122213, 64, 112295979708ULL },   // factor: 33716241969536107609
  { 150694057, 64, 111949272579ULL },   // factor: 33740180126256726007
  { 150015589, 64, 112566127331ULL },   // factor: 33773347786017925919
  { 150893203, 64, 112032861141ULL },   // factor: 33809994517639449247
  { 150377861, 64, 112483173295ULL },   // factor: 33829957997188843991
  { 150468091, 64, 112453765784ULL },   // factor: 33841406926559196689
  { 150776711, 64, 112252399813ULL },   // factor: 33850095291322310087
  { 150311107, 64, 112624930893ULL },   // factor: 33857556076650657103
  { 150798257, 64, 112566648403ULL },   // factor: 33949708751008467143
  { 150768217, 64, 112742432360ULL },   // factor: 33995951014320604241
  { 150304997, 64, 113259298215ULL },   // factor: 34046876956855360711
  { 150885803, 64, 112823985532ULL },   // factor: 34047075309312404393
  { 150163613, 64, 114015852891ULL },   // factor: 34242064818778110367
  { 150189073, 64, 114086331816ULL },   // factor: 34269040834830893137
  { 150442801, 64, 114591224628ULL },   // factor: 34478849606113006057
  { 150183419, 64, 114941778552ULL },   // factor: 34524698577760458577
  { 150666073, 64, 115061149376ULL },   // factor: 34671623062696640897
  { 150186373, 64, 115442154695ULL },   // factor: 34675677009893942471
  { 150816947, 64, 115194097089ULL },   // factor: 34746444070769134567
  { 150411913, 64, 115646345303ULL },   // factor: 34789176056965589279
  { 150113753, 64, 116300143975ULL },   // factor: 34916502173055176351
  { 150912653, 64, 115720855435ULL },   // factor: 34927482602250638111
  { 150778931, 64, 115844644980ULL },   // factor: 34933863464317832761
  { 150645877, 64, 115958755283ULL },   // factor: 34937416770871836383
  { 150917087, 64, 115977261013ULL },   // factor: 35005900780641258263
  { 150302599, 64, 116845761261ULL },   // factor: 35124443199323634679
  { 150305699, 64, 116851631364ULL },   // factor: 35126932262912686873
  { 150696379, 64, 116575265904ULL },   // factor: 35134940905389923233
  { 150916739, 64, 116422377336ULL },   // factor: 35140171068353254609
  { 150889049, 64, 116485450987ULL },   // factor: 35152757843529082727
  { 150473023, 64, 116881252185ULL },   // factor: 35174950696604610511
  { 150551413, 64, 116836257303ULL },   // factor: 35179727253196438279
  { 150679393, 64, 116874058683ULL },   // factor: 35221024439601638839
  { 150024143, 64, 117495145176ULL },   // factor: 35254216923379968337
  { 150835733, 64, 116896446136ULL },   // factor: 35264322276037155377
  { 150954289, 64, 117025800219ULL },   // factor: 35331092933430378583
  { 150663647, 64, 117759193320ULL },   // factor: 35484059066738476081
  { 150821441, 64, 117835280971ULL },   // factor: 35544173753372198423
  { 150516193, 64, 118391687087ULL },   // factor: 35639732046364999583
  { 150743107, 64, 118403043437ULL },   // factor: 35696885291898677519
  { 150444467, 64, 118785238197ULL },   // factor: 35741163696031411999
  { 150212599, 64, 118972112237ULL },   // factor: 35742220375278947927
  { 150125893, 64, 119311898627ULL },   // factor: 35823610653807697823
  { 150759283, 64, 119131927388ULL },   // factor: 35920487910845885609
  { 150915181, 64, 119009666528ULL },   // factor: 35920730729645523137
  { 150360829, 64, 119594239800ULL },   // factor: 35964578079905588401
  { 150358147, 64, 119621214044ULL },   // factor: 35972048171092432937
  { 150704849, 64, 119447187207ULL },   // factor: 36002540623011333487
  { 150343169, 64, 120033079240ULL },   // factor: 36092307035539423121
  { 150979201, 64, 119550661311ULL },   // factor: 36099326647512785023
  { 150556331, 64, 119982444820ULL },   // factor: 36128233353018310841
  { 150954901, 64, 120022828403ULL },   // factor: 36236068358629706207
  { 150645139, 64, 120580828904ULL },   // factor: 36329831461956595313
  { 150112073, 64, 121507504711ULL },   // factor: 36479486834450951807
  { 150257059, 64, 121468856261ULL },   // factor: 36503106203743192799
  { 150090469, 64, 121787953736ULL },   // factor: 36558422189573084369
  { 150115619, 64, 121886626917ULL },   // factor: 36594172894935033247
  { 150933901, 64, 121523153408ULL },   // factor: 36683927211381769217
  { 150264391, 64, 122123144061ULL },   // factor: 36701519738662863703
  { 150765233, 64, 121738435951ULL },   // factor: 36707847322416183167
  { 150824077, 64, 121743726815ULL },   // factor: 36723770454825049511
  { 150775753, 64, 121990259616ULL },   // factor: 36786346504535781697
  { 150000749, 65, 139793607984ULL },   // factor: 41938291806024760033
  { 150111499, 65, 151482625341ULL },   // factor: 45478567924785792319
  { 18641629, 62, 123911232647ULL },   // factor: 4619814455876123927
  { 18186653, 62, 127469988247ULL },   // factor: 4636504888324534583
  { 18856883, 62, 123072204976ULL },   // factor: 4641516339568899617
  { 18098173, 62, 128374354203ULL },   // factor: 4646682542258342239
  { 18717107, 62, 124188745204ULL },   // factor: 4648908064358009657
  { 18572011, 62, 125261031800ULL },   // factor: 4652698520921899601
  { 18575083, 62, 125456294588ULL },   // factor: 4660722169689101609
  { 18432143, 62, 126817710580ULL },   // factor: 4675044352686345881
  { 18222541, 62, 128524578408ULL },   // factor: 4684088799094989457
  { 18721837, 62, 125184755939ULL },   // factor: 4687377191149479887
  { 18726797, 62, 125229350428ULL },   // factor: 4690289247814038233
  { 18378229, 62, 128374287324ULL },   // factor: 4718584100304538393
  { 18302447, 62, 129179541837ULL },   // factor: 4728603435911950279
  { 18243691, 62, 129650863433ULL },   // factor: 4730620580709702407
  { 18608507, 62, 127376387529ULL },   // factor: 4740568797936218407
  { 18810409, 62, 126195505767ULL },   // factor: 4747578154878257407
  { 18004897, 62, 132183508952ULL },   // factor: 4759900927558675889
  { 18309337, 62, 130033755924ULL },   // factor: 4761663717176524777
  { 18062221, 62, 131842069851ULL },   // factor: 4762721205492398143
  { 18860263, 62, 126467887596ULL },   // factor: 4770435242229995497
  { 18443923, 62, 129388612581ULL },   // factor: 4772867215041590527
  { 18604571, 62, 128701593580ULL },   // factor: 4788875871144508361
  { 18760711, 62, 127993568540ULL },   // factor: 4802500698475263881
  { 18444037, 62, 130767125907ULL },   // factor: 4823747417224733119
  { 18208871, 62, 132504205149ULL },   // factor: 4825503957031353559
  { 18441881, 62, 131064575679ULL },   // factor: 4834154615975224399
  { 18270697, 62, 133633383843ULL },   // factor: 4883150130560297143
  { 18614951, 62, 131213042520ULL },   // factor: 4885048714141433041
  { 18786619, 62, 130056739896ULL },   // factor: 4886652841616503249
  { 18366377, 62, 133064427648ULL },   // factor: 4887822886944782593
  { 18580799, 62, 132136901772ULL },   // factor: 4910418424616551657
  { 18025171, 62, 137406712916ULL },   // factor: 4953558993717617273
  { 18343861, 62, 135110323899ULL },   // factor: 4956890002536468079
  { 18307651, 62, 135551224161ULL },   // factor: 4963249009124711623
  { 18001393, 62, 138176470523ULL },   // factor: 4974737898474877079
  { 18065573, 62, 137840137708ULL },   // factor: 4980322140187853369
  { 18083941, 62, 138409956140ULL },   // factor: 5005994961296695481
  { 18003169, 62, 139916285295ULL },   // factor: 5037873060036199711
  { 18378977, 62, 137481006555ULL },   // factor: 5053520514822388471
  { 18204833, 62, 139094030116ULL },   // factor: 5064367179117501257
  { 18321103, 62, 138544443672ULL },   // factor: 5076574045184820433
  { 18772867, 62, 135684108837ULL },   // factor: 5094359458421051359
  { 18626771, 62, 136803117649ULL },   // factor: 5096400689067962759
  { 18267047, 62, 139786917009ULL },   // factor: 5106988365977004847
  { 18825007, 62, 135669804585ULL },   // factor: 5107970042002514191
  { 18358619, 62, 139549853817ULL },   // factor: 5123885195463997447
  { 18857009, 62, 135859377336ULL },   // factor: 5123803002318696049
  { 18377063, 62, 139718643973ULL },   // factor: 5135236645132782599
  { 18110633, 62, 141843605016ULL },   // factor: 5137754947683470257
  { 18501799, 62, 139274810492ULL },   // factor: 5153669098972150217
  { 18406379, 62, 140100038565ULL },   // factor: 5157468815484012271
  { 18394589, 62, 140319091764ULL },   // factor: 5162224043704129993
  { 18820259, 62, 137203325361ULL },   // factor: 5164404237910576999
  { 18655907, 62, 138710687437ULL },   // factor: 5175547369461480719
  { 18813017, 62, 137627510968ULL },   // factor: 5178377407017340913
  { 18245911, 62, 142100477804ULL },   // factor: 5185505342138518889
  { 18254713, 62, 142255990412ULL },   // factor: 5193684555003623513
  { 18086069, 62, 143598409140ULL },   // factor: 5194261471992541321
  { 18764507, 62, 138494019792ULL },   // factor: 5197544007690245089
  { 18156139, 62, 143202650889ULL },   // factor: 5200014469418315143
  { 18831391, 62, 138229383708ULL },   // factor: 5206103144588755657
  { 18173773, 62, 143291580863ULL },   // factor: 5208297326830612199
  { 18473183, 62, 141048118897ULL },   // factor: 5211215424380078303
  { 18072773, 62, 145025034960ULL },   // factor: 5242009072298288161
  { 18274357, 62, 143649929952ULL },   // factor: 5250220205935681729
  { 18331501, 62, 143525610000ULL },   // factor: 5262079726481220001
  { 18758849, 62, 140786068920ULL },   // factor: 5281969216347746161
  { 18256003, 62, 144796552905ULL },   // factor: 5286812608446677431
  { 18473401, 62, 143210408216ULL },   // factor: 5291166596695725233
  { 18888263, 62, 140238239053ULL },   // factor: 5297713483779869879
  { 18328367, 62, 145079081709ULL },   // factor: 5318125307171078407
  { 18791813, 62, 141873127368ULL },   // factor: 5332106558449276369
  { 18408421, 62, 144868857339ULL },   // factor: 5333613831370503439
  { 18625889, 62, 143254210344ULL },   // factor: 5336474041299991633
  { 18617497, 62, 143408408864ULL },   // factor: 5339811243600586817
  { 18091793, 62, 148145632903ULL },   // factor: 5360440248670130159
  { 18687973, 62, 143539142100ULL },   // factor: 5364911224015926601
  { 18302569, 62, 146959189875ULL },   // factor: 5379461425742577751
  { 18706837, 62, 143783043735ULL },   // factor: 5379451925029032391
  { 18084103, 62, 149215562160ULL },   // factor: 5396859190608684961
  { 18799009, 62, 143674246679ULL },   // factor: 5401866912773482223
  { 18493183, 62, 146127150197ULL },   // factor: 5404712259723214103
  { 18305633, 62, 147774211396ULL },   // factor: 5410200961359187337
  { 18575497, 62, 145967980395ULL },   // factor: 5422855563846762631
  { 18166429, 62, 149915115047ULL },   // factor: 5446844587056314327
  { 18210989, 62, 149627265220ULL },   // factor: 5449720962043005161
  { 18179743, 62, 149903223261ULL },   // factor: 5450404147513203847
  { 18207751, 62, 149687980025ULL },   // factor: 5450962935976347551
  { 18313241, 62, 148911200943ULL },   // factor: 5454093420937172527
  { 18213967, 62, 149879192480ULL },   // factor: 5459789331634736321
  { 18505703, 62, 147830802645ULL },   // factor: 5471425855999968871
  { 18861529, 62, 145348568367ULL },   // factor: 5482992474725306287
  { 18361571, 62, 149379998584ULL },   // factor: 5485702899960030929
  { 18388819, 62, 149241854664ULL },   // factor: 5488762905281203633
  { 18302707, 62, 150044436317ULL },   // factor: 5492438709780420239
  { 18223157, 62, 151043803024ULL },   // factor: 5504989872766853537
  { 18100487, 62, 153574474545ULL },   // factor: 5559545560067206831
  { 18032737, 62, 154253125775ULL },   // factor: 5563212097056992351
  { 18457289, 62, 150872927527ULL },   // factor: 5569410451283788607
  { 18363347, 62, 151849835545ULL },   // factor: 5576942444011538231
  { 18870013, 62, 147947831460ULL },   // factor: 5583555005944017961
  { 18417611, 62, 151895005473ULL },   // factor: 5595086247289170007
  { 18845713, 62, 148565040692ULL },   // factor: 5599628237429506793
  { 18074531, 62, 155408584989ULL },   // factor: 5617874574099630319
  { 18537499, 62, 151734255969ULL },   // factor: 5625547236582163063
  { 18353507, 62, 153432220308ULL },   // factor: 5632038658896840313
  { 18054019, 62, 156457395305ULL },   // factor: 5649369575053961591
  { 18799343, 62, 150551923372ULL },   // factor: 5660554493559889193
  { 18647129, 62, 151795523035ULL },   // factor: 5661101399312233031
  { 18103049, 62, 156585917131ULL },   // factor: 5669365061064864839
  { 18324667, 62, 155038936568ULL },   // factor: 5682073769285445713
  { 18184009, 62, 156350932227ULL },   // factor: 5686173517548316087
  { 18113423, 62, 157645619740ULL },   // factor: 5711003588895540041
  { 18129487, 62, 157501537968ULL },   // factor: 5710844170141724833
  { 18140273, 62, 157482113020ULL },   // factor: 5713537045599308921
  { 18866429, 62, 151432619767ULL },   // factor: 5713985538236204087
  { 18199243, 62, 157022856693ULL },   // factor: 5715394251020166799
  { 18410453, 62, 155298638251ULL },   // factor: 5718236560968075407
  { 18652951, 62, 154253193056ULL },   // factor: 5754554503334216513
  { 18378883, 62, 157003736477ULL },   // factor: 5771106606547230383
  { 18304213, 62, 157758719016ULL },   // factor: 5775298390952028817
  { 18460423, 62, 156479182400ULL },   // factor: 5777343795596310401
  { 18812077, 62, 153880325904ULL },   // factor: 5789617079382285217
  { 18577357, 62, 156567004112ULL },   // factor: 5817202259618183969
  { 18234467, 62, 159656030289ULL },   // factor: 5822485231311541927
  { 18242249, 62, 159744105220ULL },   // factor: 5828183487410879561
  { 18741433, 62, 155703847140ULL },   // factor: 5836226438033103241
  { 18410611, 62, 159058565373ULL },   // factor: 5856730746600745807
  { 18555113, 62, 158313553792ULL },   // factor: 5875051760084276993
  { 18701713, 62, 157073413260ULL },   // factor: 5875083789437828761
  { 18360367, 62, 160337478905ULL },   // factor: 5887709913101116271
  { 18354799, 62, 160479188636ULL },   // factor: 5891126502193728329
  { 18101351, 62, 162769569724ULL },   // factor: 5892698227386194249
  { 18559811, 62, 159404667609ULL },   // factor: 5917041006681723799
  { 18661771, 62, 159107017905ULL },   // factor: 5938437465272019511
  { 18778153, 62, 158248833747ULL },   // factor: 5943241624345458583
  { 18075227, 62, 165032786272ULL },   // factor: 5966010148617767489
  { 18085877, 62, 165047429832ULL },   // factor: 5970055030215365329
  { 18683053, 62, 160032216671ULL },   // factor: 5979780771543553127
  { 18631061, 62, 160850521539ULL },   // factor: 5993631757349845759
  { 18691273, 62, 161012053188ULL },   // factor: 6019040484854856649
  { 18641297, 62, 161824410372ULL },   // factor: 6033233791188664969
  { 18155399, 62, 166438958800ULL },   // factor: 6043531412317122401
  { 18546887, 62, 163197546304ULL },   // factor: 6053612899955111297
  { 18594809, 62, 162906463120ULL },   // factor: 6058429133163888161
  { 18855407, 62, 160863378645ULL },   // factor: 6066288951493167031
  { 18244049, 62, 166335409432ULL },   // factor: 6069262720224940337
  { 18314419, 62, 165788775285ULL },   // factor: 6072650192132668831
  { 18852583, 62, 161120476076ULL },   // factor: 6075074296444608617
  { 18180931, 62, 167503292945ULL },   // factor: 6090731622611663591
  { 18673909, 62, 163297526007ULL },   // factor: 6098806281159702727
  { 18319463, 62, 166965001036ULL },   // factor: 6117418317547927337
  { 18726049, 62, 163487156159ULL },   // factor: 6122936994208171583
  { 18206063, 62, 169021372840ULL },   // factor: 6154427524543057841
  { 18479393, 62, 166705272112ULL },   // factor: 6161224477059176033
  { 18801703, 62, 163868388933ULL },   // factor: 6162009559613505799
  { 18229217, 62, 169307173612ULL },   // factor: 6172674414859643609
  { 18195643, 62, 169891644876ULL },   // factor: 6182575437692950537
  { 18022379, 62, 171535074621ULL },   // factor: 6182940253225886719
  { 18164953, 62, 170685206420ULL },   // factor: 6200977504829196521
  { 18640093, 62, 166424800052ULL },   // factor: 6204347500951369673
  { 18869047, 62, 164568319397ULL },   // factor: 6210494706826009319
  { 18157859, 62, 171057027576ULL },   // factor: 6212058775368239569
  { 18610793, 62, 166949806875ULL },   // factor: 6214136594281203751
  { 18567719, 62, 167471324724ULL },   // factor: 6219120996065969113
  { 18229957, 62, 170666587575ULL },   // factor: 6222489105657968551
  { 18282833, 62, 170331130432ULL },   // factor: 6228271224778947713
  { 18399169, 62, 170079431196ULL },   // factor: 6258640395998152249
  { 18046957, 62, 173581356579ULL },   // factor: 6265230556365760207
  { 18884557, 62, 166149153743ULL },   // factor: 6275306328722893703
  { 18252413, 62, 171936389355ULL },   // factor: 6276507976472527231
  { 18700261, 62, 169141375748ULL },   // factor: 6325975744773340457
  { 18110101, 62, 175491385848ULL },   // factor: 6356333444674501297
  { 18121843, 62, 175471995405ULL },   // factor: 6359751903252262831
  { 18764843, 62, 169836246520ULL },   // factor: 6373901003314192721
  { 18869759, 62, 169293600724ULL },   // factor: 6389058891808211033
  { 18850967, 62, 169549702668ULL },   // factor: 6392351699708559913
  { 18469573, 62, 173725758051ULL },   // factor: 6417281140606564447
  { 18763259, 62, 171084608025ULL },   // factor: 6420209622573106951
  { 18295987, 62, 175689892448ULL },   // factor: 6428839976520012353
  { 18532589, 62, 174499454815ULL },   // factor: 6467853353620932071
  { 18663427, 62, 173480726385ULL },   // factor: 6475489745586842791
  { 18623909, 62, 174047672635ULL },   // factor: 6482896033632060431
  { 18506753, 62, 175505965263ULL },   // factor: 6496091098297842079
  { 18181643, 62, 178915272897ULL },   // factor: 6505947238121659543
  { 18673153, 62, 174205130460ULL },   // factor: 6505918108929080761
  { 18076987, 62, 180158371685ULL },   // factor: 6513441085781826191
  { 18335819, 62, 177756743472ULL },   // factor: 6518630948664047137
  { 18726593, 62, 174358196943ULL },   // factor: 6530269980730810399
  { 18284107, 62, 179274959525ULL },   // factor: 6555765084751538351
  { 18573803, 62, 176513640048ULL },   // factor: 6557059154128925089
  { 18752131, 62, 174888557996ULL },   // factor: 6559066299884178953
  { 18034487, 62, 181967322249ULL },   // factor: 6563374615048802527
  { 18386971, 62, 178825286529ULL },   // factor: 6576110714950827319
  { 18367451, 62, 179449286889ULL },   // factor: 6592051967837299879
  { 18182933, 62, 181483427620ULL },   // factor: 6599802010049618921
  { 18180161, 62, 181839927508ULL },   // factor: 6611758316647537577
  { 18877799, 62, 175160512684ULL },   // factor: 6613289902371005033
  { 18585227, 62, 177987553492ULL },   // factor: 6615878169646925369
  { 18525907, 62, 178566581808ULL },   // factor: 6616215775765799713
  { 18635963, 62, 178351639281ULL },   // factor: 6647509101260125207
  { 18602713, 62, 179344200920ULL },   // factor: 6672577395858191921
  { 18876127, 62, 176750757645ULL },   // factor: 6672739497306481831
  { 18043657, 62, 185629924680ULL },   // factor: 6698885379723509521
  { 18087053, 62, 186219542911ULL },   // factor: 6736325484534062567
  { 18562553, 62, 182036624895ULL },   // factor: 6758128995109113871
  { 18784021, 62, 180954771575ULL },   // factor: 6798116458630006151
  { 18382337, 62, 184931142124ULL },   // factor: 6798933152636527577
  { 18681239, 62, 183423420372ULL },   // factor: 6853153508333601817
  { 18035789, 62, 190051650700ULL },   // factor: 6855462942253804601
  { 18481523, 62, 186184906297ULL },   // factor: 6881961255961700663
  { 18220193, 62, 188929782360ULL },   // factor: 6884674196094390961
  { 18668861, 62, 184672273536ULL },   // factor: 6895242010395124993
  { 18325079, 62, 188557635177ULL },   // factor: 6910667121343407967
  { 18594931, 62, 186218754228ULL },   // factor: 6925449771551236537
  { 18241291, 62, 190005657164ULL },   // factor: 6931896967949517449
  { 18825887, 62, 184134631105ULL },   // factor: 6932995515938830271
  { 18110737, 62, 191873244128ULL },   // factor: 6949931723478004673
  { 18179107, 62, 191174655044ULL },   // factor: 6950769019465931417
  { 18815911, 62, 184802210936ULL },   // factor: 6954443907150005393
  { 18115219, 62, 192323613977ULL },   // factor: 6967968772129631927
  { 18187153, 62, 191986445003ULL },   // factor: 6983373698391292919
  { 18898351, 62, 184938432780ULL },   // factor: 6990062832132691561
  { 18037231, 62, 193995355308ULL },   // factor: 6998278073234944297
  { 18293101, 62, 191300326919ULL },   // factor: 6998952403324571639
  { 18123817, 62, 194098330863ULL },   // factor: 7035605257132928143
  { 18872621, 62, 187150743844ULL },   // factor: 7064050116871790249
  { 18287099, 62, 193461336765ULL },   // factor: 7075693236187789471
  { 18412549, 62, 192195086252ULL },   // factor: 7077602886348352697
  { 18217097, 62, 194368192939ULL },   // factor: 7081648448968956167
  { 18232861, 62, 195063461688ULL },   // factor: 7113129966272258737
  { 18385547, 62, 193462278297ULL },   // factor: 7113819620713146919
  { 18870529, 62, 188795374376ULL },   // factor: 7125337174456329809
  { 18387289, 62, 193810039091ULL },   // factor: 7127282399735028599
  { 18760597, 62, 189970127780ULL },   // factor: 7127906018638169321
  { 18512587, 62, 192616609872ULL },   // factor: 7131663495800917729
  { 18287623, 62, 195138363705ULL },   // factor: 7137233656547846431
  { 18219679, 62, 196263916341ULL },   // factor: 7151731110031749079
  { 18327629, 62, 195359806675ULL },   // factor: 7160964116502247151
  { 18515971, 62, 194167550885ULL },   // factor: 7190401482655368671
  { 18851909, 62, 190714898967ULL },   // factor: 7190679840540156007
  { 18367801, 62, 195781194080ULL },   // factor: 7192140024807636161
  { 18312947, 62, 196667800800ULL },   // factor: 7203134025313915201
  { 18509033, 62, 195085037032ULL },   // factor: 7221670776463020113
  { 18616879, 62, 194304430760ULL },   // factor: 7234684153245596081
  { 18113437, 62, 199786950575ULL },   // factor: 7237656685324752551
  { 18530389, 62, 196108252452ULL },   // factor: 7267924408091527657
  { 18472547, 62, 196722940884ULL },   // factor: 7267947542915823097
  { 18766987, 62, 193771485972ULL },   // factor: 7273013916414412729
  { 18383803, 62, 197914497653ULL },   // factor: 7276842271393428719
  { 18628019, 62, 195517580316ULL },   // factor: 7284210401920948009
  { 18139543, 62, 200815632020ULL },   // factor: 7285407584197933721
  { 18026167, 62, 202513408577ULL },   // factor: 7301081045496468719
  { 18842869, 62, 193967025347ULL },   // factor: 7309790497866401087
  { 18660911, 62, 195962951649ULL },   // factor: 7313694400038584479
  { 18573553, 62, 197684017271ULL },   // factor: 7343389144071667727
  { 18705607, 62, 196743493088ULL },   // factor: 7360412923022688833
  { 18855181, 62, 195304081304ULL },   // factor: 7364987606051272049
  { 18011557, 62, 204502516460ULL },   // factor: 7366817463725456441
  { 18836383, 62, 195758100921ULL },   // factor: 7374749128601217487
  { 18217231, 62, 202870632585ULL },   // factor: 7391482353834144271
  { 18077539, 62, 204940566176ULL },   // factor: 7409642155457441729
  { 18853447, 62, 196564271633ULL },   // factor: 7411828154652737903
  { 18040691, 62, 206120636040ULL },   // factor: 7437117407042207281
  { 18656909, 62, 200255808444ULL },   // factor: 7472308789722279193
  { 18094199, 62, 206562369420ULL },   // factor: 7475161236393989161
  { 18572287, 62, 201508480244ULL },   // factor: 7484946656050796057
  { 18002471, 62, 207934123929ULL },   // factor: 7486656071884457119
  { 18227501, 62, 205566883591ULL },   // factor: 7493941152443672183
  { 18744133, 62, 200002819271ULL },   // factor: 7497758889581174087
  { 18579047, 62, 202010771557ULL },   // factor: 7506335238527532359
  { 18765251, 62, 200005762740ULL },   // factor: 7506316678525095481
  { 18451529, 62, 203994339780ULL },   // factor: 7528014952573047241
  { 18014389, 62, 209226933795ULL },   // factor: 7538190749320752511
  { 18201977, 62, 207575891532ULL },   // factor: 7556583206839917529
  { 18320461, 62, 206345322639ULL },   // factor: 7560682871880433159
  { 18490247, 62, 204631055008ULL },   // factor: 7567357501937013953
  { 18412447, 62, 205697426945ULL },   // factor: 7574785943322368831
  { 18620029, 62, 203528301992ULL },   // factor: 7579405770823595537
  { 18138451, 62, 209011293033ULL },   // factor: 7582282194251423767
  { 18294721, 62, 207410507099ULL },   // factor: 7589034719689448759
  { 18441301, 62, 205891215356ULL },   // factor: 7593803751271636313
  { 18173803, 62, 209343174605ULL },   // factor: 7609123229331745631
  { 18144433, 62, 210106119480ULL },   // factor: 7624512815589709681
  { 18342817, 62, 207967463024ULL },   // factor: 7629418232406997217
  { 18443251, 62, 206854136865ULL },   // factor: 7630125533179096231
  { 18220427, 62, 210254017044ULL },   // factor: 7661835938013915577
  { 18198839, 62, 211622798640ULL },   // factor: 7702578482357557921
  { 18248161, 62, 211245832035ULL },   // factor: 7709695907107275271
  { 18089221, 62, 213312620943ULL },   // factor: 7717318284654310807
  { 18005881, 62, 214825032735ULL },   // factor: 7736227950495029071
  { 18566549, 62, 208325381884ULL },   // factor: 7735766821385996633
  { 18519731, 62, 209161047769ULL },   // factor: 7747212680720060279
  { 18617881, 62, 208172927180ULL },   // factor: 7751477571317811161
  { 18129103, 62, 213936831125ULL },   // factor: 7756965693917461751
  { 18082601, 62, 214928356915ULL },   // factor: 7772927443359071831
  { 18471787, 62, 210975596453ULL },   // factor: 7794192559755543023
  { 18543743, 62, 210449147181ULL },   // factor: 7805029799787276967
  { 18829123, 62, 207800665877ULL },   // factor: 7825408594559871743
  { 18751813, 62, 209100695240ULL },   // factor: 7842034270620940241
  { 18680047, 62, 210863381412ULL },   // factor: 7877875750710172729
  { 18442709, 62, 213806975836ULL },   // factor: 7886359675026759449
  { 18602627, 62, 212224456273ULL },   // factor: 7895864800648858343
  { 18210487, 62, 217024954368ULL },   // factor: 7904260220388114433
  { 18487223, 62, 213920357913ULL },   // factor: 7909586721954891199
  { 18362359, 62, 216171892280ULL },   // factor: 7938851783509377041
  { 18802909, 62, 211348460759ULL },   // factor: 7947931749883095863
  { 18572909, 62, 214189451920ULL },   // factor: 7956242398540070561
  { 18576991, 62, 214138463360ULL },   // factor: 7956096613185099521
  { 18309029, 62, 219102774975ULL },   // factor: 8023118121995498551
  { 18375209, 62, 219780109204ULL },   // factor: 8077010881332647273
  { 18485431, 62, 218795271276ULL },   // factor: 8089049780597559913
  { 18728321, 62, 216833870680ULL },   // factor: 8121868667535056561
  { 18743383, 62, 216805352117ULL },   // factor: 8127331502357583623
  { 18834173, 62, 216040436227ULL },   // factor: 8137885901789570543
  { 18731281, 62, 217244814660ULL },   // factor: 8138547338378758921
  { 18041531, 62, 226025669116ULL },   // factor: 8155698232304113193
  { 18395033, 62, 221707933975ULL },   // factor: 8156649523663892351
  { 18481721, 62, 221111340064ULL },   // factor: 8173036193997940289
  { 18892693, 62, 216493829027ULL },   // factor: 8180302896403199423
  { 18139549, 62, 225862449915ULL },   // factor: 8194085954986376671
  { 18491777, 62, 221839355440ULL },   // factor: 8204407781240433761
  { 18465823, 62, 222236630477ULL },   // factor: 8207564565009375143
  { 18724127, 62, 219231004089ULL },   // factor: 8209818325799910607
  { 18312673, 62, 224182074872ULL },   // factor: 8210746059184905713
  { 18829649, 62, 218454325540ULL },   // factor: 8226836544899870921
  { 18016223, 62, 228332331268ULL },   // factor: 8227372396468321529
  { 18374203, 62, 224200159377ULL },   // factor: 8238998482050703063
  { 18238039, 62, 226371151209ULL },   // factor: 8257131768449278303
  { 18051151, 62, 229091119280ULL },   // factor: 8270716773764582561
  { 18521953, 62, 223364351543ULL },   // factor: 8274288042309846959
  { 18683491, 62, 221761439825ULL },   // factor: 8286555730234858151
  { 18890987, 62, 219349808808ULL },   // factor: 8287468773288826993
  { 18544199, 62, 224036216964ULL },   // factor: 8309144381175183673
  { 18308029, 62, 226960061219ULL },   // factor: 8310382765278454703
  { 18588607, 62, 224038830425ULL },   // factor: 8329139543019935951
  { 18503867, 62, 225099926473ULL },   // factor: 8330438202332342183
  { 18324829, 62, 227509802835ULL },   // factor: 8338156465550180431
  { 18433619, 62, 226701036205ULL },   // factor: 8357841056616351791
  { 18647977, 62, 224351487315ULL },   // factor: 8367402750731823511
  { 18586739, 62, 225278602024ULL },   // factor: 8374389156209919473
  { 18788683, 62, 223346543681ULL },   // factor: 8392774816735924247
  { 18868021, 62, 222712615784ULL },   // factor: 8404292623154886929
  { 18034129, 62, 233217267840ULL },   // factor: 8411740586508222721
  { 18839489, 62, 223879946724ULL },   // factor: 8435567587254768073
  { 18284093, 62, 230753765631ULL },   // factor: 8438246621794815367
  { 18880163, 62, 224029855485ULL },   // factor: 8459440376846488111
  { 18038843, 62, 234641853516ULL },   // factor: 8465335113608243977
  { 18518629, 62, 228632802440ULL },   // factor: 8467932091233309521
  { 18039821, 62, 235142935119ULL },   // factor: 8483872917922747399
  { 18583963, 62, 228526255473ULL },   // factor: 8493846952477558999
  { 18165757, 62, 235385532620ULL },   // factor: 8551912773780986681
  { 18550373, 62, 231595366708ULL },   // factor: 8592360875010364169
  { 18363659, 62, 234541323241ULL },   // factor: 8614073762812997639
  { 18434699, 62, 233634684085ULL },   // factor: 8613970154134130831
  { 18895801, 62, 230818420520ULL },   // factor: 8722997882560473041
  { 18341161, 62, 238676777460ULL },   // factor: 8755218404710062121
  { 18212209, 62, 241324067607ULL },   // factor: 8790088711977627727
  { 18785203, 62, 233989444005ULL },   // factor: 8791078410982116031
  { 18509989, 62, 237785729547ULL },   // factor: 8802822476543889967
  { 18072793, 62, 243989042760ULL },   // factor: 8819126928139257361
  { 18796363, 62, 234839192796ULL },   // factor: 8828245428841201897
  { 18414941, 62, 240117663963ULL },   // factor: 8843505229872942367
  { 18539557, 62, 239191187687ULL },   // factor: 8868997316041669319
  { 18390079, 62, 241331745972ULL },   // factor: 8876219747266023577
  { 18108749, 62, 245945293299ULL },   // factor: 8907523168165945903
  { 18209663, 62, 244785860520ULL },   // factor: 8914936054468409521
  { 18396629, 62, 243023747436ULL },   // factor: 8941635439539586489
  { 18251573, 62, 245764920523ULL },   // factor: 8971192775529465359
  { 18222679, 62, 246563732025ULL },   // factor: 8986103483467189951
  { 18232063, 62, 246454126517ULL },   // factor: 8986734322535829143
  { 18142309, 62, 247875197264ULL },   // factor: 8994056844398885153
  { 18739691, 62, 240130045140ULL },   // factor: 8999925691479303481
  { 18106423, 62, 248817897777ULL },   // factor: 9010404214242243343
  { 18629771, 62, 242007356944ULL },   // factor: 9017083280363959649
  { 18333703, 62, 246198297737ULL },   // factor: 9027452939631460223
  { 18050477, 62, 250257912559ULL },   // factor: 9034549389428481287
  { 18228671, 62, 247971037741ULL },   // factor: 9040364929018544423
  { 18306733, 62, 246984716823ULL },   // factor: 9042966531918538519
  { 18722987, 62, 241513167489ULL },   // factor: 9043695790450739287
  { 18874249, 62, 239610439740ULL },   // factor: 9044934205304510521
  { 18476251, 62, 246039460373ULL },   // factor: 9091773651512203247
  { 18727879, 62, 243105869789ULL },   // factor: 9105714627196295063
  { 18076753, 62, 251881597383ULL },   // factor: 9106402842275874799
  { 18341647, 62, 248783827880ULL },   // factor: 9126210300567436721
  { 18813391, 62, 242677655441ULL },   // factor: 9131179237549620863
  { 18712259, 62, 244216656645ULL },   // factor: 9139690662510622111
  { 18868693, 62, 242358308171ULL },   // factor: 9145969025755981007
  { 18005509, 62, 254713963152ULL },   // factor: 9172509111918008737
  { 18641521, 62, 246433371768ULL },   // factor: 9187785749827958257
  { 18563491, 62, 247725104448ULL },   // factor: 9197285493789015937
  { 18360659, 62, 250706195301ULL },   // factor: 9206261922218126719
  { 18859417, 62, 244225574903ULL },   // factor: 9211903918320823103
  { 18694573, 63, 247003197120ULL },   // factor: 9235238599586459521
  { 18122101, 63, 254892353723ULL },   // factor: 9238369956591864047
  { 18329119, 63, 252211519392ULL },   // factor: 9245629904213551297
  { 18196993, 63, 254853560552ULL },   // factor: 9275136914779640273
  { 18302611, 63, 255409614773ULL },   // factor: 9349325649700144607
  { 18562009, 63, 252262716867ULL },   // factor: 9365005641699411607
  { 18721739, 63, 250708507341ULL },   // factor: 9387398479035571999
  { 18886327, 63, 248748216785ULL },   // factor: 9395880325736797391
  { 18686279, 63, 251494839844ULL },   // factor: 9399005488770600953
  { 18627383, 63, 252330260781ULL },   // factor: 9400504820115132247
  { 18843607, 63, 250456728644ULL },   // factor: 9439016330146357817
  { 18643147, 63, 253545693920ULL },   // factor: 9453779285935132481
  { 18892807, 63, 250338480413ULL },   // factor: 9459193190232178583
  { 18887809, 63, 250576748084ULL },   // factor: 9465691515303415913
  { 18175387, 63, 260510545557ULL },   // factor: 9469759966159211119
  { 18336481, 63, 258923530376ULL },   // factor: 9495492790384893713
  { 18202697, 63, 261601486027ULL },   // factor: 9523705169798429639
  { 18753197, 63, 254576594899ULL },   // factor: 9548250071460284207
  { 18675487, 63, 256006855097ULL },   // factor: 9562105388549814479
  { 18121517, 63, 264887087647ULL },   // factor: 9600311723751200999
  { 18382003, 63, 261869892296ULL },   // factor: 9627386291589497777
  { 18540593, 63, 259674958132ULL },   // factor: 9629055422034904553
  { 18459053, 63, 262718628303ULL },   // factor: 9699074167864754119
  { 18826277, 63, 258979232995ULL },   // factor: 9751229555222819231
  { 18184013, 63, 268688849983ULL },   // factor: 9771683082091843559
  { 18090001, 63, 270581751095ULL },   // factor: 9789648295780602191
  { 18138227, 63, 270539775712ULL },   // factor: 9814223728786685249
  { 18310211, 63, 268372628556ULL },   // factor: 9827918910969970633
  { 18418759, 63, 267107874845ULL },   // factor: 9839591147544434711
  { 18199583, 63, 270727683216ULL },   // factor: 9854261882174597857
  { 18679273, 63, 264164076092ULL },   // factor: 9868785788230482233
  { 18488347, 63, 267237990089ULL },   // factor: 9881577384695985767
  { 18307999, 63, 272505424281ULL },   // factor: 9978058070462247439
  { 18066073, 63, 276364483815ULL },   // factor: 9985641878418216991
  { 18268189, 63, 273417636276ULL },   // factor: 9989690110846448329
  { 18232931, 63, 274336236964ULL },   // factor: 10003907358728522969
  { 18895589, 63, 264728280444ULL },   // factor: 10004393567893123033
  { 18565111, 63, 269469856764ULL },   // factor: 10005475603955521609
  { 18529741, 63, 270026690099ULL },   // factor: 10007049261243468719
  { 18609421, 63, 269045147616ULL },   // factor: 10013548839986580673
  { 18441847, 63, 273124472324ULL },   // factor: 10073839461109884857
  { 18540007, 63, 273565750745ULL },   // factor: 10143821867545110431
  { 18801611, 63, 270754741924ULL },   // factor: 10181250668120879129
  { 18728741, 63, 274002627819ULL },   // factor: 10263448499482891759
  { 18555541, 63, 277204005080ULL },   // factor: 10287340563252296561
  { 18306581, 63, 281914271484ULL },   // factor: 10321772891955672409
  { 18776293, 63, 275036642756ULL },   // factor: 10328337180245967017
  { 18538439, 63, 279537161784ULL },   // factor: 10364365243931630353
  { 18224827, 63, 284393507352ULL },   // factor: 10366044942826856209
  { 18453991, 63, 282254922144ULL },   // factor: 10417459585902153409
  { 18733153, 63, 278602140092ULL },   // factor: 10438193032941740153
  { 18490201, 63, 282637498740ULL },   // factor: 10452048323679693481
  { 18585037, 63, 281550142652ULL },   // factor: 10465239637085396249
  { 18838279, 63, 278470853529ULL },   // factor: 10491823264294873183
  { 18277607, 63, 287356078180ULL },   // factor: 10504362932070630521
  { 18346189, 63, 286550843336ULL },   // factor: 10514231859903293009
  { 18877631, 63, 279093560140ULL },   // factor: 10537250485598456681
  { 18321673, 63, 288134897655ULL },   // factor: 10558226749446753631
  { 18037577, 63, 292889965248ULL },   // factor: 10566050601376248193
  { 18487649, 63, 285936581712ULL },   // factor: 10572590317902550177
  { 18648137, 63, 284034106519ULL },   // factor: 10593413862077810207
  { 18051923, 63, 293568572568ULL },   // factor: 10598954534434896529
  { 18666509, 63, 284112468799ULL },   // factor: 10606775911697505383
  { 18653147, 63, 284624274228ULL },   // factor: 10618276853886391033
  { 18121799, 63, 293618267745ULL },   // factor: 10641782461606146511
  { 18558887, 63, 287077063864ULL },   // factor: 10655661577087518737
  { 18159851, 63, 293806504396ULL },   // factor: 10670964685324409993
  { 18257399, 63, 294099458565ULL },   // factor: 10738982321410344871
  { 18826151, 63, 285394837116ULL },   // factor: 10745772596332441033
  { 18532883, 63, 290083748245ULL },   // factor: 10752176332852080671
  { 18024151, 63, 298333375529ULL },   // factor: 10754411617748801759
  { 18816181, 63, 287381995164ULL },   // factor: 10814863274293897369
  { 18832501, 63, 288542052548ULL },   // factor: 10867936986304525097
  { 18388691, 63, 296018601180ULL },   // factor: 10886789174702510761
  { 18174743, 63, 299848898376ULL },   // factor: 10899353333633834737
  { 18675311, 63, 291932226240ULL },   // factor: 10903850231908721281
  { 18806453, 63, 291301505695ULL },   // factor: 10956696151364499671
  { 18357461, 63, 299191441408ULL },   // factor: 10984790434362290177
  { 18091883, 63, 303589407141ULL },   // factor: 10985008068068673007
  { 18310913, 63, 300476913547ULL },   // factor: 11004013244935276823
  { 18016303, 63, 305589705837ULL },   // factor: 11011193468080521223
  { 18198841, 63, 302909034920ULL },   // factor: 11025186727945055441
  { 18793883, 63, 293441915752ULL },   // factor: 11029826063877890033
  { 18896959, 63, 292917364100ULL },   // factor: 11070494839571543801
  { 18517753, 63, 299233653788ULL },   // factor: 11082269780267396729
  { 18255499, 63, 304270832816ULL },   // factor: 11109231768403310369
  { 18656623, 63, 298832005293ULL },   // factor: 11150392126171011079
  { 18593921, 63, 300462324844ULL },   // factor: 11173545463251346649
  { 18119851, 63, 308486743445ULL },   // factor: 11179467653397253391
  { 18202049, 63, 307134668655ULL },   // factor: 11180960576914148191
  { 18893779, 63, 296959133792ULL },   // factor: 11221360491794959937
  { 18821147, 63, 298934027353ULL },   // factor: 11252562544225667783
  { 18896047, 63, 297799259064ULL },   // factor: 11254457591677040017
  { 18275263, 63, 308144487285ULL },   // factor: 11262843094267061911
  { 18792187, 63, 301404231860ULL },   // factor: 11328089375408955641
  { 18748487, 63, 303309810685ULL },   // factor: 11373200085200367191
  { 18886873, 63, 301568700671ULL },   // factor: 11391379500696383567
  { 18539869, 63, 307232723312ULL },   // factor: 11392108885435452257
  { 18220999, 63, 312662311001ULL },   // factor: 11394039312173819999
  { 18789391, 63, 303424568324ULL },   // factor: 11402325706491701369
  { 18120799, 63, 315062852024ULL },   // factor: 11418381227787294353
  { 18422753, 63, 310253226976ULL },   // factor: 11431437136063569857
  { 18883429, 63, 302757816015ULL },   // factor: 11434211445828630871
  { 18898069, 63, 302681549844ULL },   // factor: 11440193627957702473
  { 18786451, 63, 304698022193ULL },   // factor: 11448388927451414087
  { 18067711, 63, 316851618981ULL },   // factor: 11449566963261644983
  { 18144733, 63, 315611550495ULL },   // factor: 11453374630895585671
  { 18170359, 63, 317970744704ULL },   // factor: 11555285165538057473
  { 18441317, 63, 313712392443ULL },   // factor: 11570539351739534863
  { 18440647, 63, 313907928045ULL },   // factor: 11577330583158490231
  { 18077821, 63, 321482990303ULL },   // factor: 11623423906484739527
  { 18138437, 63, 321530027479ULL },   // factor: 11664104294072220647
  { 18211993, 63, 322645725836ULL },   // factor: 11752043400810302297
  { 18362587, 63, 321529690073ULL },   // factor: 11808233814096997703
  { 18880007, 63, 313288262517ULL },   // factor: 11829769178677595239
  { 18142753, 63, 326354583851ULL },   // factor: 11841941210452963607
  { 18794297, 63, 315339193992ULL },   // factor: 11853156935252527249
  { 18310651, 63, 324020027145ULL },   // factor: 11866035268125242791
  { 18478973, 63, 321430588380ULL },   // factor: 11879414328096267481
  { 18620257, 63, 320046603464ULL },   // factor: 11918700016953540497
  { 18733189, 63, 318160787547ULL },   // factor: 11920332331013594767
  { 18879151, 63, 316513357989ULL },   // factor: 11951006957982774679
  { 18641713, 63, 321593421396ULL },   // factor: 11990104528704582697
  { 18024311, 63, 333244434909ULL },   // factor: 12013002667638145399
  { 18033511, 63, 333589176840ULL },   // factor: 12031568180050170481
  { 18767681, 63, 322683380739ULL },   // factor: 12112037507422192519
  { 18859979, 63, 321198921940ULL },   // factor: 12115609845222078521
  { 18410857, 63, 329359235688ULL },   // factor: 12127571579762129233
  { 18468049, 63, 328354351755ULL },   // factor: 12128128515149151991
  { 18131303, 63, 334574240116ULL },   // factor: 12132533847075902297
  { 18080273, 63, 336143997291ULL },   // factor: 12155150476665080887
  { 18513191, 63, 328823687049ULL },   // factor: 12175151447324726719
  { 18694547, 63, 325739707024ULL },   // factor: 12179112525452796257
  { 18620293, 63, 327692020691ULL },   // factor: 12203442878056964927
  { 18696901, 63, 326791865844ULL },   // factor: 12219990326581098889
  { 18551443, 63, 329740538696ULL },   // factor: 12234325616816276657
  { 18854501, 63, 324940484224ULL },   // factor: 12253181369483784449
  { 18588079, 63, 329616060777ULL },   // factor: 12253858754783354767
  { 18871789, 63, 324829004052ULL },   // factor: 12260208851098978057
  { 18754181, 63, 328910462976ULL },   // factor: 12336892710891405313
  { 18814967, 63, 327872239972ULL },   // factor: 12337810750578521849
  { 18897959, 63, 326961159364ULL },   // factor: 12357797168506676153
  { 18146147, 63, 341924824629ULL },   // factor: 12409236261334108927
  { 18437389, 63, 336530622560ULL },   // factor: 12409491997101791681
  { 18438193, 63, 337359686948ULL },   // factor: 12440606036733609929
  { 18627319, 63, 334553858364ULL },   // factor: 12463682884854092233
  { 18529547, 63, 337606069588ULL },   // factor: 12511375067832233273
  { 18300497, 63, 342419193252ULL },   // factor: 12532882837701292489
  { 18714799, 63, 335122785176ULL },   // factor: 12543511129778039249
  { 18874253, 63, 333881779975ULL },   // factor: 12603538374676967351
  { 18019909, 63, 350326232075ULL },   // factor: 12625693644608762351
  { 18281927, 63, 345458569464ULL },   // factor: 12631296696930554257
  { 18095521, 63, 349760057223ULL },   // factor: 12658180920879996367
  { 18842977, 63, 335950591283ULL },   // factor: 12660618529363938983
  { 18545363, 63, 341735332612ULL },   // factor: 12675211586430556313
  { 18292013, 63, 347223349843ULL },   // factor: 12702828058463407919
  { 18280159, 63, 349353798849ULL },   // factor: 12772485980427473983
  { 18059039, 63, 354702788560ULL },   // factor: 12811182984027587681
  { 18025781, 63, 355742390620ULL },   // factor: 12825068851465148441
  { 18181343, 63, 353587634193ULL },   // factor: 12857396115642922399
  { 18220127, 63, 354214720504ULL },   // factor: 12907674385704768017
  { 18445547, 63, 349896082912ULL },   // factor: 12908049284938385729
  { 18814261, 63, 343164307676ULL },   // factor: 12912765701001134873
  { 18877403, 63, 342068269312ULL },   // factor: 12914721146630313473
  { 18726137, 63, 346337367708ULL },   // factor: 12971121991838767993
  { 18724831, 63, 346924413200ULL },   // factor: 12992202013888338401
  { 18173191, 63, 358142285589ULL },   // factor: 13017176322370888999
  { 18738581, 63, 348285369048ULL },   // factor: 13052747198041681777
  { 18564619, 63, 352186152224ULL },   // factor: 13076403466229125313
  { 18174829, 63, 359916792335ULL },   // factor: 13082852309834271431
  { 18413027, 63, 355844975352ULL },   // factor: 13104366277941421009
  { 18817109, 63, 348277908144ULL },   // factor: 13107166719675271393
  { 18300641, 63, 358773112555ULL },   // factor: 13131555866643295511
  { 18716407, 63, 350833816604ULL },   // factor: 13132697001847643657
  { 18460093, 63, 357393363132ULL },   // factor: 13195029441998982553
  { 18190691, 63, 364312931253ULL },   // factor: 13254207919455131647
  { 18313517, 63, 361876769512ULL },   // factor: 13254472740726187409
  { 18763237, 63, 354868952619ULL },   // factor: 13316980523864135407
  { 18874039, 63, 353176763136ULL },   // factor: 13331744002645252609
  { 18759019, 63, 355531156989ULL },   // factor: 13338831458097267583
  { 18610939, 63, 361661389980ULL },   // factor: 13461716135145982441
  { 18683773, 63, 360363833315ULL },   // factor: 13465912118134594991
  { 18143239, 63, 371921399592ULL },   // factor: 13495717684024316977
  { 18136529, 63, 373660315255ULL },   // factor: 13553802287542899791
  { 18809369, 63, 360281969599ULL },   // factor: 13553353020468746063
  { 18422081, 63, 368720795695ULL },   // factor: 13585208729355482591
  { 18275251, 63, 372654769340ULL },   // factor: 13620718892071208681
  { 18620123, 63, 366220211628ULL },   // factor: 13638130771198780489
  { 18458197, 63, 369590667728ULL },   // factor: 13643954708569932833
  { 18457157, 63, 369782924095ULL },   // factor: 13650282971880995831
  { 18133517, 63, 378076193155ULL },   // factor: 13711702151742952271
  { 18638687, 63, 368028994125ULL },   // factor: 13719154456841427751
  { 18263647, 63, 376763115657ULL },   // factor: 13762137093959242159
  { 18075257, 63, 380768996563ULL },   // factor: 13764994941016683383
  { 18342179, 63, 376606344036ULL },   // factor: 13815561949687788889
  { 18275651, 63, 378820104361ULL },   // factor: 13846368038170428023
  { 18375391, 63, 376886907068ULL },   // factor: 13850888560310327177
  { 18304777, 63, 378718197032ULL },   // factor: 13864704285025643729
  { 18253589, 63, 381008729959ULL },   // factor: 13909553524167145703
  { 18146309, 63, 384153506220ULL },   // factor: 13941936454603083961
  { 18162883, 63, 384977857796ULL },   // factor: 13984615577478771737
  { 18107351, 63, 387859937896ULL },   // factor: 14046232068642146993
  { 18055627, 63, 389285634648ULL },   // factor: 14057592431325128593
  { 18563807, 63, 381115951933ULL },   // factor: 14149925952610977863
  { 18884269, 63, 375152290652ULL },   // factor: 14168953545277106777
  { 18338513, 63, 386703886983ULL },   // factor: 14183148517176552559
  { 18125911, 63, 394027479104ULL },   // factor: 14284214035586927489
  { 18341731, 63, 390286974384ULL },   // factor: 14317077393910437409
  { 18850549, 63, 379975522092ULL },   // factor: 14325494395991657017
  { 18442367, 63, 389726198605ULL },   // factor: 14374947168376596071
  { 18709909, 63, 384221109311ULL },   // factor: 14377483982175725399
  { 18474691, 63, 389560911884ULL },   // factor: 14394034945470255689
  { 18211309, 63, 396150895527ULL },   // factor: 14428852738137829687
  { 18003617, 63, 402714054619ULL },   // factor: 14500619199755113847
  { 18654589, 63, 389970220112ULL },   // factor: 14549468356857787937
  { 18307199, 63, 398504857036ULL },   // factor: 14591015440449204329
  { 18296671, 63, 399720034025ULL },   // factor: 14627091909328461551
  { 18821893, 63, 389130411603ULL },   // factor: 14648341940475248959
  { 18266777, 63, 403272119143ULL },   // factor: 14732963741405224223
  { 18776867, 63, 393033455740ULL },   // factor: 14759873849960733161
  { 18886823, 63, 391254166581ULL },   // factor: 14779096384455724327
  { 18040663, 63, 411820008681ULL },   // factor: 14859011986541991007
  { 18665551, 63, 398055694544ULL },   // factor: 14859857734702907489
  { 18601109, 63, 401856600532ULL },   // factor: 14949956857730379977
  { 18047423, 63, 415281178545ULL },   // factor: 14989510186280279071
  { 18649979, 63, 403044434044ULL },   // factor: 15033540461974970153
  { 18354179, 63, 409608131520ULL },   // factor: 15036041931547244161
  { 18107017, 63, 415442044515ULL },   // factor: 15044832325095723511
  { 18762493, 63, 401830059600ULL },   // factor: 15078667360869165601
  { 18625099, 63, 405347428661ULL },   // factor: 15099271976413124879
  { 18879253, 63, 402612685491ULL },   // factor: 15202053500788036447
  { 18665891, 63, 408188878713ULL },   // factor: 15238418234938156567
  { 18430079, 63, 413418081984ULL },   // factor: 15238655821987193473
  { 18835361, 63, 404924181024ULL },   // factor: 15253786254432779329
  { 18404201, 63, 414644285223ULL },   // factor: 15262393537490843647
  { 18157823, 63, 420594215836ULL },   // factor: 15274150651947770057
  { 18200849, 63, 419920468591ULL },   // factor: 15285818081668067519
  { 18754123, 63, 407770250613ULL },   // factor: 15294746871474054799
  { 18491773, 63, 414613809111ULL },   // factor: 15333888881491887607
  { 18258283, 63, 421033565628ULL },   // factor: 15374699987470193449
  { 18829477, 63, 408410850812ULL },   // factor: 15380325443829970649
  { 18506029, 63, 415967294519ULL },   // factor: 15395805630840310103
  { 18636911, 63, 413978049765ULL },   // factor: 15430544138847751831
  { 18190903, 63, 424328904681ULL },   // factor: 15437851890296633887
  { 18714823, 63, 412829649141ULL },   // factor: 15452067625651834087
  { 18215051, 63, 424476289048ULL },   // factor: 15463714506600122897
  { 18515617, 63, 419614397927ULL },   // factor: 15538838959403851919
  { 18064777, 63, 430110219648ULL },   // factor: 15539690406724276993
  { 18235879, 63, 426313554924ULL },   // factor: 15548404807307836393
  { 18479581, 63, 421060496891ULL },   // factor: 15562043116394965343
  { 18604721, 63, 418544176164ULL },   // factor: 15573795247412140489
  { 18383903, 63, 424243565545ULL },   // factor: 15598505114706844271
  { 18790939, 63, 415198519757ULL },   // factor: 15603940115288163647
  { 18827059, 63, 415040913860ULL },   // factor: 15627999545312275481
  { 18586889, 63, 420576260916ULL },   // factor: 15634408555361460649
  { 18881351, 63, 414466350436ULL },   // factor: 15651369280542238073
  { 18820481, 63, 416383574184ULL },   // factor: 15673078293284125009
  { 18426091, 63, 426149752196ULL },   // factor: 15704548227181891673
  { 18561113, 63, 426583578828ULL },   // factor: 15835732021141831129
  { 18832643, 63, 423158663233ULL },   // factor: 15938392074048629639
  { 18620297, 63, 430149407979ULL },   // factor: 16019019461886299527
  { 18824341, 63, 426409772628ULL },   // factor: 16053765931363876297
  { 18130529, 63, 444890391604ULL },   // factor: 16132196293595357033
  { 18242963, 63, 442199010456ULL },   // factor: 16134040372770842257
  { 18048313, 63, 449195607360ULL },   // factor: 16214445839716767361
  { 18819023, 63, 431266239876ULL },   // factor: 16232018574699922297
  { 18830047, 63, 431645522084ULL },   // factor: 16255810936362515897
  { 18269219, 63, 445685893840ULL },   // factor: 16284666399547421921
  { 18196709, 63, 447541436464ULL },   // factor: 16287562569554793953
  { 18336733, 63, 445214789511ULL },   // factor: 16327569445828815127
  { 18835409, 63, 433515564091ULL },   // factor: 16330885915039396439
  { 18433301, 63, 443163924948ULL },   // factor: 16337948041815786697
  { 18689257, 63, 437623063223ULL },   // factor: 16357699795403790623
  { 18415181, 63, 445022086119ULL },   // factor: 16390324529757945079
  { 18166397, 63, 453529724943ULL },   // factor: 16478002069230680743
  { 18373921, 63, 449976153443ULL },   // factor: 16535652590491120007
  { 18701297, 63, 442381170528ULL },   // factor: 16546203314503549633
  { 18857203, 63, 438975467988ULL },   // factor: 16555699023739435129
  { 18056047, 63, 458591949960ULL },   // factor: 16560715604598816241
  { 18177011, 63, 455576670013ULL },   // factor: 16562044284339342287
  { 18884813, 63, 438975655087ULL },   // factor: 16579946315740987463
  { 18702949, 63, 443786142264ULL },   // factor: 16600219171340673073
  { 18075791, 63, 461184580453ULL },   // factor: 16672552177382226647
  { 18151307, 63, 459890451589ULL },   // factor: 16695225546321153647
  { 18564929, 63, 452100898992ULL },   // factor: 16786442181245303137
  { 18415477, 63, 459237739488ULL },   // factor: 16914164058146511553
  { 18611027, 63, 456562870705ULL },   // factor: 16994207827776528071
  { 18563851, 63, 460706926893ULL },   // factor: 17104989491019089887
  { 18245207, 63, 468969811897ULL },   // factor: 17112902589623655359
  { 18814249, 63, 455624704220ULL },   // factor: 17144473271492861561
  { 18032587, 63, 476091202617ULL },   // factor: 17170312062251360359
  { 18079043, 63, 474848535837ULL },   // factor: 17169614195768327983
  { 18565619, 63, 464398950004ULL },   // factor: 17243707939548624953
  { 18528863, 63, 466291125256ULL },   // factor: 17279688755968527857
  { 18846887, 63, 461799847200ULL },   // factor: 17406979073591332801
  { 18781289, 63, 466908244839ULL },   // factor: 17538277365608034943
  { 18789973, 63, 466820513700ULL },   // factor: 17543089696538260201
  { 18739103, 63, 468478598725ULL },   // factor: 17557737429606887351
  { 18423211, 63, 480927523580ULL },   // factor: 17720458485243630761
  { 18525181, 63, 479981566428ULL },   // factor: 17783490789484446937
  { 18306941, 63, 487194045648ULL },   // factor: 17838065298458485537
  { 18495761, 63, 482687522208ULL },   // factor: 17855346096882720577
  { 18608437, 63, 480931728768ULL },   // factor: 17898775552160831233
  { 18286687, 63, 490285937400ULL },   // factor: 17931410955470787601
  { 18228937, 63, 492980943660ULL },   // factor: 17973037128357378841
  { 18079123, 63, 497550448436ULL },   // factor: 17990551511959203257
  { 18002561, 63, 501509716284ULL },   // factor: 18056918518990806649
  { 18552803, 63, 488481587337ULL },   // factor: 18125405317981311223
  { 18826981, 63, 481638076211ULL },   // factor: 18135581819402097983
  { 18547861, 63, 489443409536ULL },   // factor: 18156256654879604993
  { 18726173, 63, 487053462847ULL },   // factor: 18241294811043989063
  { 18231331, 63, 502655014280ULL },   // factor: 18328139888296813361
  { 18897547, 64, 489276872793ULL },   // factor: 18492265399237477543
  { 18154817, 64, 510239687815ULL },   // factor: 18526616316836909711
  { 18200599, 64, 509291506280ULL },   // factor: 18538820959816523441
  { 18673807, 64, 496856523020ULL },   // factor: 18556405635133074281
  { 18005447, 64, 516874557085ULL },   // factor: 18613114886484883991
  { 18405707, 64, 506625192084ULL },   // factor: 18649589688633646777
  { 18892067, 64, 494367617460ULL },   // factor: 18679252303369379641
  { 18716837, 64, 499032684664ULL },   // factor: 18680626833056975537
  { 18435103, 64, 507624288245ULL },   // factor: 18716212078196528471
  { 18560851, 64, 504830530796ULL },   // factor: 18740168524710934793
  { 18250433, 64, 514819075740ULL },   // factor: 18791342097829590841
  { 18876349, 64, 498420435479ULL },   // factor: 18816716177667172343
  { 18375893, 64, 512004221923ULL },   // factor: 18817069595210604479
  { 18651587, 64, 504699283137ULL },   // factor: 18826885176534776839
  { 18409597, 64, 512506641167ULL },   // factor: 18870081447416159399
  { 18603479, 64, 507679528377ULL },   // factor: 18889210889782847167
  { 18762581, 64, 505371990855ULL },   // factor: 18964165827096393511
  { 18785681, 64, 505523738791ULL },   // factor: 18993215389710103343
  { 18224719, 64, 521290393344ULL },   // factor: 19000741872187740673
  { 18150971, 64, 526208134980ULL },   // factor: 19102377195972131161
  { 18650369, 64, 512667691147ULL },   // factor: 19122883228539166487
  { 18839987, 64, 509146879177ULL },   // factor: 19184641169570501399
  { 18827023, 64, 510122786165ULL },   // factor: 19208186855905073591
  { 18831629, 64, 516733069240ULL },   // factor: 19461850903917983921
  { 18238631, 64, 533592396085ULL },   // factor: 19463989633200319271
  { 18613649, 64, 523883805291ULL },   // factor: 19502778536942033719
  { 18564869, 64, 527784955600ULL },   // factor: 19596517121769632801
  { 18051997, 64, 542796218844ULL },   // factor: 19597111428366462937
  { 18352001, 64, 536048965648ULL },   // factor: 19675142307242123297
  { 18456899, 64, 533126498637ULL },   // factor: 19679723879133493327
  { 18457133, 64, 533528172915ULL },   // factor: 19694800893478305391
  { 18321967, 64, 541844905409ULL },   // factor: 19855328952043639007
  { 18342319, 64, 542720272952ULL },   // factor: 19909496748505311377
  { 18386449, 64, 543584958840ULL },   // factor: 19989194245757518321
  { 18521137, 64, 540088875995ULL },   // factor: 20006120128958812631
  { 18206621, 64, 549656276139ULL },   // factor: 20014766999868232639
  { 18383201, 64, 545457263283ULL },   // factor: 20054501015682617767
  { 18529141, 64, 545520375351ULL },   // factor: 20216047906503206983
  { 18704729, 64, 542905999315ULL },   // factor: 20309819179322521271
  { 18284677, 64, 556084722620ULL },   // factor: 20335659075482587481
  { 18461759, 64, 552916769769ULL },   // factor: 20415632301067527343
  { 18463969, 64, 553865360340ULL },   // factor: 20453105686983178921
  { 18643477, 64, 548719723799ULL },   // factor: 20460087100186018247
  { 18615029, 64, 549570317479ULL },   // factor: 20460534794821583783
  { 18774661, 64, 545399739660ULL },   // factor: 20479390443209510521
  { 18282137, 64, 560173773847ULL },   // factor: 20482347354555742079
  { 18023917, 64, 568827130400ULL },   // factor: 20504985971355553601
  { 18320989, 64, 559830633171ULL },   // factor: 20513301744377852239
  { 18468631, 64, 555836489573ULL },   // factor: 20531078044518169127
  { 18603281, 64, 554200001323ULL },   // factor: 20619876709624281527
  { 18549611, 64, 556539552256ULL },   // factor: 20647184400925944833
  { 18419543, 64, 560513247576ULL },   // factor: 20648795731591555537
  { 18648863, 64, 553869638232ULL },   // factor: 20658078006496260433
  { 18561401, 64, 556949428903ULL },   // factor: 20675523373179146207
  { 18245951, 64, 566661611488ULL },   // factor: 20678559993582170177
  { 18405329, 64, 562949132647ULL },   // factor: 20722527993265351727
  { 18347003, 64, 565011737785ULL },   // factor: 20732544096353216711
  { 18641047, 64, 557558924744ULL },   // factor: 20786964242844733937
  { 18390131, 64, 567922585713ULL },   // factor: 20888341498241596807
  { 18476869, 64, 565614004535ULL },   // factor: 20901551732717201831
  { 18014323, 64, 580249193261ULL },   // factor: 20905592775786154607
  { 18817291, 64, 557333302869ULL },   // factor: 20975005888154215759
  { 18858113, 64, 558062612988ULL },   // factor: 21048015633605943289
  { 18133991, 64, 581199023785ULL },   // factor: 21078915733051951871
  { 18791167, 64, 560868073280ULL },   // factor: 21078731259945435521
  { 18877711, 64, 559197788289ULL },   // factor: 21112748478317852959
  { 18808093, 64, 561498622515ULL },   // factor: 21121436623268027791
  { 18495901, 64, 571835435979ULL },   // factor: 21153223224318844159
  { 18110201, 64, 584407304719ULL },   // factor: 21167467508658677039
  { 18100601, 64, 585412894884ULL },   // factor: 21192650461100450569
  { 18596009, 64, 569816391715ULL },   // factor: 21192621497359330871
  { 18880991, 64, 564321522229ULL },   // factor: 21309899164624097879
  { 18840959, 64, 565781318380ULL },   // factor: 21319725245127052841
  { 18741691, 64, 568923907769ULL },   // factor: 21325192163838194759
  { 18714347, 64, 571954794468ULL },   // factor: 21407520983975664793
  { 18687139, 64, 573319297364ULL },   // factor: 21427394802446803193
  { 18320231, 64, 585143814060ULL },   // factor: 21439939683600495721
  { 18810383, 64, 570669099268ULL },   // factor: 21469008646992199289
  { 18006713, 64, 596323392772ULL },   // factor: 21475648377663356873
  { 18000869, 64, 598611589947ULL },   // factor: 21551057625035327887
  { 18656819, 64, 578561263225ULL },   // factor: 21588225536800362551
  { 18731459, 64, 576890327605ULL },   // factor: 21611995038059251391
  { 18323381, 64, 593680586884ULL },   // factor: 21756471171558269609
  { 18123323, 64, 600807616893ULL },   // factor: 21777261003624190879
  { 18578869, 64, 586610486184ULL },   // factor: 21797118753677691793
  { 18866537, 64, 577664756359ULL },   // factor: 21797066998886117567
  { 18537023, 64, 588725282385ULL },   // factor: 21826428200504479711
  { 18836497, 64, 582047391252ULL },   // factor: 21927467878352248489
  { 18769327, 64, 584738132148ULL },   // factor: 21950282423310048793
  { 18587977, 64, 591583837427ULL },   // factor: 21992693527329630359
  { 18229837, 64, 607021271124ULL },   // factor: 22131797656246653577
  { 18563101, 64, 596605416276ULL },   // factor: 22149693198956863753
  { 18315977, 64, 605534619267ULL },   // factor: 22181916318396257719
  { 18363031, 64, 604343388788ULL },   // factor: 22195152765918192857
  { 18324941, 64, 607957618803ULL },   // factor: 22281574990130931247
  { 18308999, 64, 610766786736ULL },   // factor: 22365056975165274529
  { 18634769, 64, 600193618332ULL },   // factor: 22368938865781970617
  { 18290663, 64, 615326428092ULL },   // factor: 22509456662449009993
  { 18756029, 64, 600874792092ULL },   // factor: 22540050051693045337
  { 18537661, 64, 609520411763ULL },   // factor: 22598165531685812687
  { 18287713, 64, 618110624351ULL },   // factor: 22607659400763798527
  { 18825377, 64, 600813748767ULL },   // factor: 22621090654644120319
  { 18076511, 64, 625923175564ULL },   // factor: 22629014336475154409
  { 18325891, 64, 619102480785ULL },   // factor: 22691209161391008871
  { 18887291, 64, 601281202525ULL },   // factor: 22713146089839219551
  { 18574697, 64, 611542323564ULL },   // factor: 22718426725754520217
  { 18327467, 64, 620150342352ULL },   // factor: 22731569868989964769
  { 18692803, 64, 610498062417ULL },   // factor: 22823840025285369703
  { 18622817, 64, 613513323352ULL },   // factor: 22850692695692245169
  { 18303037, 64, 627295196000ULL },   // factor: 22962814364620504001
  { 18053807, 64, 636726644509ULL },   // factor: 22990679903446191527
  { 18300017, 64, 628485980415ULL },   // factor: 23002608251712334111
  { 18702913, 64, 616359195227ULL },   // factor: 23055424810161192503
  { 18634127, 64, 620328013897ULL },   // factor: 23118541985228925839
  { 18404741, 64, 633059798719ULL },   // factor: 23302603265870653559
  { 18066679, 64, 646061996544ULL },   // factor: 23344389411319114753
  { 18511769, 64, 630900624819ULL },   // factor: 23358173257209989623
  { 18144589, 64, 647526466011ULL },   // factor: 23498203184784128959
  { 18729167, 64, 628329796668ULL },   // factor: 23536187385742031113
  { 18486359, 64, 640148375649ULL },   // factor: 23668025371028543983
  { 18645227, 64, 634776643692ULL },   // factor: 23671109231870916169
  { 18457469, 64, 646959065707ULL },   // factor: 23882453799111831167
  { 18072421, 64, 662197403579ULL },   // factor: 23935020525173189519
  { 18815347, 64, 636099851477ULL },   // factor: 23936878864376435039
  { 18778037, 64, 638058572640ULL },   // factor: 23962974970402215361
  { 18144029, 64, 661979921167ULL },   // factor: 24021965774143523687
  { 18646939, 64, 645174533324ULL },   // factor: 24061060334492190473
  { 18789889, 64, 642287315732ULL },   // factor: 24137014737424467497
  { 18151787, 64, 666875063532ULL },   // factor: 24209948217688663369
  { 18574979, 64, 652378770265ULL },   // factor: 24235843915436398871
  { 18707627, 64, 650234786545ULL },   // factor: 24328699698216957431
  { 18314251, 64, 666938490053ULL },   // factor: 24428957816783290607
  { 18847571, 64, 649415183668ULL },   // factor: 24479797565321340857
  { 18338501, 64, 669200727883ULL },   // factor: 24544276434966246767
  { 18869581, 64, 650936906883ULL },   // factor: 24565813380636452047
  { 18498629, 64, 664431915372ULL },   // factor: 24582158996452049977
  { 18398207, 64, 669193806352ULL },   // factor: 24623932344764021729
  { 18224863, 64, 675624591260ULL },   // factor: 24626331230288994761
  { 18287327, 64, 673738492153ULL },   // factor: 24641752236977690063
  { 18210433, 64, 676823449871ULL },   // factor: 24650496173409408287
  { 18174397, 64, 679352451899ULL },   // factor: 24693642327471659807
  { 18673621, 64, 661262959811ULL },   // factor: 24696347785697691263
  { 18262147, 64, 676637924348ULL },   // factor: 24713722480436110313
  { 18035429, 64, 686073471372ULL },   // factor: 24747258763426477177
  { 18292607, 64, 679340160865ULL },   // factor: 24853805164040450111
  { 18737639, 64, 663200305861ULL },   // factor: 24853615831826004359
  { 18050729, 64, 688962636324ULL },   // factor: 24872555678820160393
  { 18372437, 64, 676967432164ULL },   // factor: 24875082996969727337
  { 18876133, 64, 658951321551ULL },   // factor: 24876905572244884567
  { 18143687, 64, 686740551324ULL },   // factor: 24920011226860183177
  { 18405733, 64, 678399257780ULL },   // factor: 24972871212193705481
  { 18322721, 64, 682848157399ULL },   // factor: 25023272546771925359
  { 18814771, 64, 664998106776ULL },   // factor: 25023574188847976593
  { 18791141, 64, 667462250623ULL },   // factor: 25084754527268261687
  { 18614731, 64, 676593913221ULL },   // factor: 25189227381692517103
  { 18610133, 64, 677497218895ULL },   // factor: 25216626701532126071
  { 18371209, 64, 686351767644ULL },   // factor: 25218223541814723193
  { 18661673, 64, 677867538300ULL },   // factor: 25300284674139151801
  { 18062267, 64, 700413330468ULL },   // factor: 25302105170544501913
  { 18548263, 64, 683446249977ULL },   // factor: 25353481581874279903
  { 18401783, 64, 698228861008ULL },   // factor: 25697311969212754529
  { 18248981, 64, 704777746455ULL },   // factor: 25722951408560224711
  { 18339337, 64, 702064887440ULL },   // factor: 25750809133258454561
  { 18338833, 64, 705113222351ULL },   // factor: 25861907261573712767
  { 18466667, 64, 701008364913ULL },   // factor: 25890576078125709943
  { 18207569, 64, 716432787895ULL },   // factor: 26088998838921154511
  { 18528707, 64, 706039439728ULL },   // factor: 26163995818328543393
  { 18772139, 64, 697618691004ULL },   // factor: 26191590073050275113
  { 18305767, 64, 716202757592ULL },   // factor: 26221281610473266129
  { 18749681, 64, 699615044400ULL },   // factor: 26235117810601672801
  { 18739939, 64, 703463217617ULL },   // factor: 26365715573772610727
  { 18301207, 64, 721690937784ULL },   // factor: 26415630484818210577
  { 18054097, 64, 733873317404ULL },   // factor: 26498840116247208377
  { 18558523, 64, 713948536220ULL },   // factor: 26499660660510406121
  { 18502837, 64, 716995450955ULL },   // factor: 26532899917523718671
  { 18091121, 64, 735111490188ULL },   // factor: 26597981834962841497
  { 18055393, 64, 741163844175ULL },   // factor: 26764008967940771551
  { 18782593, 64, 713615193687ULL },   // factor: 26807087483278180783
  { 18249053, 64, 735767676871ULL },   // factor: 26854126661811506327
  { 18625109, 64, 722187086404ULL },   // factor: 26901626405333836073
  { 18271801, 64, 737119116384ULL },   // factor: 26936987615728575169
  { 18435821, 64, 730546252551ULL },   // factor: 26936439888502058743
  { 18043997, 64, 747131207100ULL },   // factor: 26962466519037557401
  { 18298117, 64, 740057027508ULL },   // factor: 27083300152027204873
  { 18202253, 64, 747025128412ULL },   // factor: 27195080769425424473
  { 18100171, 64, 752195604093ULL },   // factor: 27229738119063199807
  { 18189331, 64, 748688435969ULL },   // factor: 27236283555424893479
  { 18792947, 64, 725673128365ULL },   // factor: 27275073281375283311
  { 18200087, 64, 751618907308ULL },   // factor: 27359059007701071593
  { 18634897, 64, 734667358388ULL },   // factor: 27380901105644932073
  { 18864493, 64, 726113287968ULL },   // factor: 27395518076158640449
  { 18011239, 64, 760583918201ULL },   // factor: 27398117460549322079
  { 18191993, 64, 753663318771ULL },   // factor: 27421275638877601207
  { 18367519, 64, 747157664921ULL },   // factor: 27446865212864201999
  { 18828841, 64, 730234289831ULL },   // factor: 27498930671951631743
  { 18629911, 64, 738349145681ULL },   // factor: 27510757741926128783
  { 18286589, 64, 754971546031ULL },   // factor: 27611708737926956519
  { 18844289, 64, 733584437824ULL },   // factor: 27647754304515974273
  { 18478961, 64, 749156339856ULL },   // factor: 27687261574203539233
  { 18101203, 64, 764919958965ULL },   // factor: 27691942911954269791
  { 18771733, 64, 738711307731ULL },   // factor: 27733782865614335647
  { 18153137, 64, 765121861563ULL },   // factor: 27778723949296346263
  { 18276023, 64, 760542841672ULL },   // factor: 27799396933765660913
  { 18845677, 64, 738089908047ULL },   // factor: 27819608008026925639
  { 18169451, 64, 766065177684ULL },   // factor: 27837967417471462969
  { 18558461, 64, 752500411275ULL },   // factor: 27930499070262095551
  { 18357403, 64, 762949173848ULL },   // factor: 28011530905689593489
  { 18200431, 64, 771541941081ULL },   // factor: 28084791724501611823
  { 18374149, 64, 764990654820ULL },   // factor: 28112104550540496361
  { 18430231, 64, 765967076856ULL },   // factor: 28233900329701667473
  { 18324191, 64, 770494990309ULL },   // factor: 28237394733930530039
  { 18815161, 64, 750830036571ULL },   // factor: 28253976043438505863
  { 18797797, 64, 751964849364ULL },   // factor: 28270565178960102217
  { 18893113, 64, 748969728116ULL },   // factor: 28300739413749730217
  { 18465157, 64, 767459773587ULL },   // factor: 28342530420936816319
  { 18521329, 64, 766032063104ULL },   // factor: 28375863730595890433
  { 18469597, 64, 768611021339ULL },   // factor: 28391871627779460767
  { 18642103, 64, 765370671357ULL },   // factor: 28536237777232687543
  { 18268543, 64, 781148636760ULL },   // factor: 28540894920082881361
  { 18214087, 64, 786591231972ULL },   // factor: 28654082265150379129
  { 18717877, 64, 769656095004ULL },   // factor: 28812656237170373017
  { 18211181, 64, 792956524195ULL },   // factor: 28881349574492048591
  { 18628877, 64, 776627244972ULL },   // factor: 28935386842864512889
  { 18479411, 64, 784152298536ULL },   // factor: 28981345222482884593
  { 18085237, 64, 804629224800ULL },   // factor: 29103820455268555201
  { 18734333, 64, 778893248503ULL },   // factor: 29184090977813906999
  { 18640103, 64, 783097430088ULL },   // factor: 29194033511751238129
  { 18663103, 64, 783792573908ULL },   // factor: 29256003074960233049
  { 18660487, 64, 785009258025ULL },   // factor: 29297310108510316351
  { 18647533, 64, 785993955623ULL },   // factor: 29313696450560856119
  { 18835261, 64, 778438357631ULL },   // factor: 29324179276782453383
  { 18537751, 64, 791455776956ULL },   // factor: 29343620241443731913
  { 18652273, 64, 788488405632ULL },   // factor: 29414201998365603073
  { 18564467, 64, 795578533240ULL },   // factor: 29538982852484766161
  { 18718039, 64, 789691442592ULL },   // factor: 29562950440806634177
  { 18732953, 64, 789895984368ULL },   // factor: 29594168700108957409
  { 18441233, 64, 802713372427ULL },   // factor: 29606048666284164983
  { 18177769, 64, 814957002299ULL },   // factor: 29628200265447381863
  { 18762473, 64, 791150256007ULL },   // factor: 29687870634548850623
  { 18066011, 64, 825396221509ULL },   // factor: 29823234434280061199
  { 18876521, 64, 796867003624ULL },   // factor: 30084153456231024209
  { 18066007, 64, 835565939697ULL },   // factor: 30190680231055159759
  { 18417013, 64, 820304156307ULL },   // factor: 30215104621320101983
  { 18359791, 64, 822965352740ULL },   // factor: 30218943753095354681
  { 18887591, 64, 802516512108ULL },   // factor: 30315207302884903657
  { 18486451, 64, 821557045241ULL },   // factor: 30375348121105059383
  { 18252719, 64, 832662061960ULL },   // factor: 30396693277832938481
  { 18667057, 64, 814537140252ULL },   // factor: 30410022451402156729
  { 18668491, 64, 815205244073ULL },   // factor: 30437303524259207687
  { 18596519, 64, 822636849169ULL },   // factor: 30596363591342885423
  { 18445909, 64, 829650821951ULL },   // factor: 30607327126966696919
  { 18706673, 64, 819872254267ULL },   // factor: 30674164324691247383
  { 18134147, 64, 850387258464ULL },   // factor: 30842095103826340417
  { 18261431, 64, 848001165864ULL },   // factor: 30971429556689982769
  { 18084967, 64, 856583959385ULL },   // factor: 30982585276414130591
  { 18188237, 64, 852033296875ULL },   // factor: 30993967070907718751
  { 18809941, 64, 824844947559ULL },   // factor: 31030569595465768039
  { 18051727, 64, 864495992228ULL },   // factor: 31211291288587955513
  { 18566029, 64, 840531801696ULL },   // factor: 31210675611420370369
  { 18039589, 64, 865466023211ULL },   // factor: 31225302704381800559
  { 18871537, 64, 831217077680ULL },   // factor: 31372687672939988321
  { 18525583, 64, 850205729436ULL },   // factor: 31501113615484322377
  { 18694517, 64, 843233414883ULL },   // factor: 31527682818996593023
  { 18534031, 64, 851779071836ULL },   // factor: 31573799445119301833
  { 18266477, 64, 866338396752ULL },   // factor: 31649900796974565409
  { 18477313, 64, 857302211028ULL },   // factor: 31681282577512815529
  { 18243733, 64, 868500406167ULL },   // factor: 31689379041004602823
  { 18411023, 64, 861258307828ULL },   // factor: 31713293028724776089
  { 18599723, 64, 852695996880ULL },   // factor: 31719818690353728481
  { 18713647, 64, 850711401057ULL },   // factor: 31839825716512249759
  { 18004171, 64, 888467198349ULL },   // factor: 31992230733932627359
  { 18540259, 64, 863425518989ULL },   // factor: 32016265498530956303
  { 18067589, 64, 887849090755ULL },   // factor: 32082584931570079391
  { 18516409, 64, 866381285559ULL },   // factor: 32084540466712475263
  { 18488867, 64, 867996773745ULL },   // factor: 32096553812400793831
  { 18805403, 64, 853953616905ULL },   // factor: 32117883818412275431
  { 18815737, 64, 853974249068ULL },   // factor: 32136309750471966233
  { 18263183, 64, 880564743192ULL },   // factor: 32163830096527000273
  { 18524551, 64, 868344831668ULL },   // factor: 32171396239640562137
  { 18320539, 64, 887163232560ULL },   // factor: 32506617202963099681
  { 18390101, 64, 888182116611ULL },   // factor: 32667517661740135423
  { 18399197, 64, 888250711719ULL },   // factor: 32686199660616179287
  { 18381871, 64, 890325374220ULL },   // factor: 32731692353877531241
  { 18533323, 64, 884792944728ULL },   // factor: 32796306865530342289
  { 18816379, 64, 873313456236ULL },   // factor: 32865193956672978889
  { 18741431, 64, 877134918069ULL },   // factor: 32877527089361633479
  { 18346021, 64, 900614342531ULL },   // factor: 33045379281949838303
  { 18660259, 64, 886543152501ULL },   // factor: 33086249680690315519
  { 18575959, 64, 891400625661ULL },   // factor: 33117242949706167799
  { 18112553, 64, 914998379487ULL },   // factor: 33145913286744800623
  { 18853013, 64, 879274427595ULL },   // factor: 33153944428032187471
  { 18518161, 64, 895709786079ULL },   // factor: 33173796055772961439
  { 18018739, 64, 922081089792ULL },   // factor: 33229476987595224577
  { 18461903, 64, 899943043720ULL },   // factor: 33229322357366798321
  { 18198319, 64, 913159983797ULL },   // factor: 33235953366345274487
  { 18295141, 64, 914242786655ULL },   // factor: 33452401380172286711
  { 18253273, 64, 916799101755ULL },   // factor: 33469168580977588231
  { 18489433, 64, 910208760555ULL },   // factor: 33658487788589430631
  { 18030241, 64, 933714909371ULL },   // factor: 33670209682504576823
  { 18631139, 64, 906234619684ULL },   // factor: 33768366331889480153
  { 18847177, 64, 895840144680ULL },   // factor: 33768115540979136721
  { 18603553, 64, 907656399632ULL },   // factor: 33771267872686184993
  { 18165269, 64, 931286771239ULL },   // factor: 33834149431395796583
  { 18471659, 64, 919465512672ULL },   // factor: 33968106824674725697
  { 18891779, 64, 899277360321ULL },   // factor: 33977898301775402119
  { 18766961, 64, 905556881031ULL },   // factor: 33989101339180833583
  { 18128549, 64, 939637040307ULL },   // factor: 34068512254840849087
  { 18880297, 64, 902854427780ULL },   // factor: 34092319488502901321
  { 18211313, 64, 938780035951ULL },   // factor: 34192834145709827327
  { 18561817, 64, 921448122179ULL },   // factor: 34207502837760478487
  { 18134503, 64, 943508368805ULL },   // factor: 34220110689238757831
  { 18371741, 64, 933504313539ULL },   // factor: 34300198941442602799
  { 18134009, 64, 953934102351ULL },   // factor: 34597299194879910319
  { 18842969, 64, 923141660419ULL },   // factor: 34789459379767488023
  { 18210259, 64, 955562342721ULL },   // factor: 34802075503192349479
  { 18566279, 64, 937933845576ULL },   // factor: 34827882921013863409
  { 18276109, 64, 953094228716ULL },   // factor: 34837708022569092089
  { 18084109, 64, 965411936040ULL },   // factor: 34917229362496776721
  { 18413657, 64, 948591348204ULL },   // factor: 34934071437992044057
  { 18657127, 64, 939330722777ULL },   // factor: 35050425179704563359
  { 18242551, 64, 963191321769ULL },   // factor: 35142133620256785439
  { 18643861, 64, 942761008728ULL },   // factor: 35153410405889237617
  { 18424177, 64, 957250214924ULL },   // factor: 35273094786095635097
  { 18285769, 64, 968429799651ULL },   // factor: 35416967218268933239
  { 18285779, 64, 969060417012ULL },   // factor: 35440049246258544697
  { 18542453, 64, 957682828576ULL },   // factor: 35515577675555073857
  { 18491513, 64, 961151765271ULL },   // factor: 35546300724963290047
  { 18386881, 64, 968218184216ULL },   // factor: 35605025070431340593
  { 18897173, 64, 950883562987ULL },   // factor: 35938022385243471503
  { 18706099, 64, 963932564240ULL },   // factor: 36062835951994599521
  { 18852931, 64, 957052480260ULL },   // factor: 36086488747441284121
  { 18664273, 64, 968081933508ULL },   // factor: 36137090986722319369
  { 18214733, 64, 993361133716ULL },   // factor: 36187615646428475657
  { 18506249, 64, 977877692412ULL },   // factor: 36193696134643765177
  { 18871927, 64, 962656644068ULL },   // factor: 36334371825832558073
  { 18730289, 64, 971634104980ULL },   // factor: 36397975177063478441
  { 18446249, 64, 987775781512ULL },   // factor: 36441516043879896977
  { 18219479, 64, 1000701948072ULL },   // factor: 36464536256313788977
  { 18302461, 64, 998070678459ULL },   // factor: 36534299335478775199
  { 18489227, 64, 990826512297ULL },   // factor: 36639232606955048839
  { 18566623, 64, 988157912136ULL },   // factor: 36693510838192473457
  { 18394213, 64, 998039687687ULL },   // factor: 36716309195536310663
  { 18003607, 64, 1019785319040ULL },   // factor: 36719628216731554561
  { 18879743, 64, 973498146321ULL },   // factor: 36758789627033751007
  { 18087869, 64, 1018683215179ULL },   // factor: 36851617097313127103
  { 18680237, 64, 986461506400ULL },   // factor: 36854669461858033601
  { 18898643, 65, 976874746945ULL },   // factor: 36923214196457791271
  { 18824167, 65, 982925038857ULL },   // factor: 37005490159851314239
  { 18173257, 65, 1020758776199ULL },   // factor: 37101023149739820287
  { 18622699, 65, 998224472277ULL },   // factor: 37179267763296831247
  { 18834611, 65, 987214623301ULL },   // factor: 37187606806771741823
  { 18019927, 65, 1035017923620ULL },   // factor: 37301894854647951481
  { 18591977, 65, 1004553297699ULL },   // factor: 37353263612187921847
  { 18459967, 65, 1013650249757ULL },   // factor: 37423900320111956039
  { 18237679, 65, 1027296997737ULL },   // factor: 37471025764782264847
  { 18459403, 65, 1014926569140ULL },   // factor: 37469877110325246841
  { 18225367, 65, 1033039042440ULL },   // factor: 37655031347595150961
  { 18445681, 65, 1020693861443ULL },   // factor: 37654786733671555367
  { 18051611, 65, 1047564289884ULL },   // factor: 37820446116954406249
  { 18281567, 65, 1034569435644ULL },   // factor: 37827100907755948297
  { 18391631, 65, 1030409337765ULL },   // factor: 37901816638256489431
  { 18560603, 65, 1022637735213ULL },   // factor: 37961546032215226879
  { 18000721, 65, 1055330156583ULL },   // factor: 37993407423073792687
  { 18454171, 65, 1031792164320ULL },   // factor: 38081738073642757441
  { 18435569, 65, 1036370129359ULL },   // factor: 38212146058673540543
  { 18076199, 65, 1060724717949ULL },   // factor: 38347742171729991703
  { 18185821, 65, 1060794087188ULL },   // factor: 38582822774918722697
  { 18336587, 65, 1056701761360ULL },   // factor: 38752607560461756641
  { 18538123, 65, 1045577821665ULL },   // factor: 38766100528195669591
  { 18324389, 65, 1061964775087ULL },   // factor: 38919711285983393687
  { 18118223, 65, 1075708276608ULL },   // factor: 38979844877058855169
  { 18366767, 65, 1061399125677ULL },   // factor: 38988940870626352519
  { 18000883, 65, 1083047778761ULL },   // factor: 38991632697773291927
  { 18724571, 65, 1043970820513ULL },   // factor: 39095811501247849847
  { 18452299, 65, 1059730512597ULL },   // factor: 39108928555726221007
  { 18141127, 65, 1078799046605ULL },   // factor: 39141261023880447671
  { 18707197, 65, 1048821064904ULL },   // factor: 39241004557817828177
  { 18739421, 65, 1062979883223ULL },   // factor: 39839255092493267767
  { 18003787, 65, 1110006460697ULL },   // factor: 39968639774025319079
  { 18141763, 65, 1102036497656ULL },   // factor: 39985769915650415057
  { 18778583, 65, 1080492609648ULL },   // factor: 40580240302323137569
  { 18092993, 65, 1123541020372ULL },   // factor: 40656439633606906793
  { 18161641, 65, 1124469210311ULL },   // factor: 40844412226443760703
  { 18571537, 65, 1101152617352ULL },   // factor: 40900193151599020049
  { 18064201, 65, 1133804373560ULL },   // factor: 40962540197333851121
  { 18890923, 65, 1089813663092ULL },   // factor: 41175171987637827833
  { 18420007, 65, 1122769045892ULL },   // factor: 41362827369427922489
  { 18191837, 65, 1137507928324ULL },   // factor: 41386717636555782377
  { 18138203, 65, 1146452993868ULL },   // factor: 41589194265471078409
  { 18802703, 65, 1106732336328ULL },   // factor: 41619118840942989169
  { 18080327, 65, 1151847975060ULL },   // factor: 41651576086745289241
  { 18661943, 65, 1116504163981ULL },   // factor: 41672274134952150167
  { 18066091, 65, 1156678249929ULL },   // factor: 41793309041876115079
  { 18383741, 65, 1140969574276ULL },   // factor: 41950578284740493033
  { 18100177, 65, 1159237461903ULL },   // factor: 41964806490950113663
  { 18865751, 65, 1112342698401ULL },   // factor: 41970360749402728303
  { 18728789, 65, 1122494177955ULL },   // factor: 42045913225295292991
  { 18738439, 65, 1122225358680ULL },   // factor: 42057502855756601041
  { 18822337, 65, 1117283771387ULL },   // factor: 42059783339354142839
  { 18306973, 65, 1159091129415ULL },   // factor: 42438900021479821591
  { 18797627, 65, 1130129116372ULL },   // factor: 42487491182800898489
  { 18609931, 65, 1143113079000ULL },   // factor: 42546511050775098001
  { 18104287, 65, 1176979755788ULL },   // factor: 42616758583951726313
  { 18096061, 65, 1183444092804ULL },   // factor: 42831352986941690089
  { 18571601, 65, 1154822183328ULL },   // factor: 42893793629432936257
  { 18490127, 65, 1163026601133ULL },   // factor: 43009019118655027783
  { 18877277, 65, 1141119330975ULL },   // factor: 43082451401739510151
  { 18766169, 65, 1151906743000ULL },   // factor: 43233753222755134001
  { 18880669, 65, 1146156040631ULL },   // factor: 43280385651008924279
  { 18067363, 65, 1198295631876ULL },   // factor: 43300084324836125977
  { 18817937, 65, 1151443365624ULL },   // factor: 43335577426760795377
  { 18717821, 65, 1159366174056ULL },   // factor: 43401617038870103953
  { 18106591, 65, 1201783783041ULL },   // factor: 43520414859912246463
  { 18551251, 65, 1176381240413ULL },   // factor: 43646687325185813327
  { 18013091, 65, 1212075425764ULL },   // factor: 43666449886301353049
  { 18243989, 65, 1199968510699ULL },   // factor: 43784424619077876623
  { 18268303, 65, 1204301420036ULL },   // factor: 44001086489095837817
  { 18754973, 65, 1175873039427ULL },   // factor: 44106934211762640943
  { 18757099, 65, 1175891250060ULL },   // factor: 44112617181218351881
  { 18382873, 65, 1203855558951ULL },   // factor: 44260647701080492447
  { 18420587, 65, 1205155809193ULL },   // factor: 44399354863590112583
  { 18093689, 65, 1228998197851ULL },   // factor: 44474222346952924679
  { 18508811, 65, 1203925341025ULL },   // factor: 44566453190284542551
  { 18051823, 65, 1238438529005ULL },   // factor: 44712146243957252231
  { 18601547, 65, 1203210393525ULL },   // factor: 44763149372087566351
  { 18858743, 65, 1187629374777ULL },   // factor: 44794394316340250623
  { 18428869, 65, 1218026950284ULL },   // factor: 44893718210506697593
  { 18201467, 65, 1237639163668ULL },   // factor: 45053696790821401913
  { 18564941, 65, 1214081467060ULL },   // factor: 45078701610324686921
  { 18333743, 65, 1230269790168ULL },   // factor: 45110900307208077649
  { 18206509, 65, 1242400123595ULL },   // factor: 45239538063666959711
  { 18626743, 65, 1214702432153ULL },   // factor: 45251900050377735359
  { 18685357, 65, 1211343092544ULL },   // factor: 45268756267337356417
  { 18324881, 65, 1235727661068ULL },   // factor: 45289124674958865817
  { 18804589, 65, 1207983191012ULL },   // factor: 45431254851778308137
  { 18713701, 65, 1214439773655ULL },   // factor: 45453325613374694311
  { 18806797, 65, 1216953306995ULL },   // factor: 45773987606267290031
  { 18477197, 65, 1239358877068ULL },   // factor: 45799756250568436793
  { 18633239, 65, 1229733544281ULL },   // factor: 45827838073809912319
  { 18093931, 65, 1268665817469ULL },   // factor: 45910303526685361279
  { 18034843, 65, 1274778880073ULL },   // factor: 45980873923664767079
  { 18660559, 65, 1237416882141ULL },   // factor: 46181781473576353639
  { 18695723, 65, 1237719167980ULL },   // factor: 46280109432689099081
  { 18464267, 65, 1254109832040ULL },   // factor: 46312437572223429361
  { 18120779, 65, 1277972417224ULL },   // factor: 46315711481223794993
  { 18141511, 65, 1280752915601ULL },   // factor: 46469586213315226223
  { 18574939, 65, 1251041449137ULL },   // factor: 46476037208382755287
  { 18645673, 65, 1248664961723ULL },   // factor: 46564397125689149159
  { 18273883, 65, 1276876236525ULL },   // factor: 46666973903476353151
  { 18533453, 65, 1261576841343ULL },   // factor: 46762750189837894759
  { 18258577, 65, 1286438053619ULL },   // factor: 46977056515465280327
  { 18025373, 65, 1303485803283ULL },   // factor: 46991635608761399119
  { 18123709, 65, 1302204093215ULL },   // factor: 47201536088075068871
  { 18311609, 65, 1293743544675ULL },   // factor: 47381051872725264151
  { 18408521, 65, 1293621909655ULL },   // factor: 47627332179888340511
  { 18041711, 65, 1320582163293ULL },   // factor: 47651123483774228647
  { 18277937, 65, 1305451679920ULL },   // factor: 47721927124243850081
  { 18688639, 65, 1279591186577ULL },   // factor: 47827635507038397407
  { 18264241, 65, 1312744386384ULL },   // factor: 47952559688628989089
  { 18295429, 65, 1321705204596ULL },   // factor: 48362327459233183369
  { 18766387, 65, 1292280278405ULL },   // factor: 48502863634031945471
  { 18268721, 65, 1328231240431ULL },   // factor: 48530171909835717503
  { 18060871, 65, 1345469167713ULL },   // factor: 48600690145083716047
  { 18327611, 65, 1328431671100ULL },   // factor: 48693957816001484201
  { 18824563, 65, 1297279528596ULL },   // factor: 48841440429331407097
  { 18044431, 65, 1354895948141ULL },   // factor: 48896652896819705543
  { 18589399, 65, 1315313474909ULL },   // factor: 48901773990319779383
  { 18123713, 65, 1352346017256ULL },   // factor: 49019062186881583057
  { 18246433, 65, 1345515721608ULL },   // factor: 49101724929534048529
  { 18788173, 65, 1306706367992ULL },   // factor: 49101250604070717233
  { 18473743, 65, 1329383188356ULL },   // factor: 49117366740418673017
  { 18540493, 65, 1329585819767ULL },   // factor: 49302353168578650263
  { 18292093, 65, 1347981642587ULL },   // factor: 49314811136988329183
  { 18050917, 65, 1371794938007ULL },   // factor: 49524313133969004839
  { 18233951, 65, 1361658826744ULL },   // factor: 49656840651135171089
  { 18525527, 65, 1343378219932ULL },   // factor: 49773578969124408329
  { 18628627, 65, 1338173965485ULL },   // factor: 49856687328261878191
  { 18349963, 65, 1363480139861ULL },   // factor: 50039620235368350287
  { 18530027, 65, 1354296681885ULL },   // factor: 50190308162678921791
  { 18034481, 65, 1397122487931ULL },   // factor: 50392757926528697623
  { 18662437, 65, 1350250749575ULL },   // factor: 50397939096292428551
  { 18594629, 65, 1355620842844ULL },   // factor: 50414533274702969753
  { 18480779, 65, 1364389024440ULL },   // factor: 50429944061402477521
  { 18409507, 65, 1373911223864ULL },   // factor: 50586056586205750097
  { 18351733, 65, 1378410993615ULL },   // factor: 50592461038174369591
  { 18021973, 65, 1410803371031ULL },   // factor: 50850920522059328327
  { 18495233, 65, 1375122830047ULL },   // factor: 50866434290677331903
  { 18609259, 65, 1367384550441ULL },   // factor: 50892026503510266439
  { 18693601, 65, 1362800608631ULL },   // factor: 50951301640610140463
  { 18418793, 65, 1390736281012ULL },   // factor: 51231367355099717033
  { 18173983, 65, 1411278256877ULL },   // factor: 51297094097504462183
  { 18566983, 65, 1381830264360ULL },   // factor: 51312838054515251761
  { 18399203, 65, 1394840634856ULL },   // factor: 51327911986728839537
  { 18270737, 65, 1407093869668ULL },   // factor: 51417284054032610633
  { 18177359, 65, 1422820713016ULL },   // factor: 51726245786255609489
  { 18493021, 65, 1401685566828ULL },   // factor: 51842801245494214777
  { 18748853, 65, 1383377944375ULL },   // factor: 51873499445058103751
  { 18487111, 65, 1410906041264ULL },   // factor: 52167153190836296609
  { 18459473, 65, 1417692876996ULL },   // factor: 52339726770399966217
  { 18259963, 65, 1436637090020ULL },   // factor: 52465880216385738521
  { 18030193, 65, 1455907312547ULL },   // factor: 52500579670667463143
  { 18308063, 65, 1433798273773ULL },   // factor: 52500138251054663399
  { 18639737, 65, 1412571005172ULL },   // factor: 52659904060463439529
  { 18233899, 65, 1445676866936ULL },   // factor: 52720651956694926929
  { 18089803, 65, 1458836254712ULL },   // factor: 52780120913995803473
  { 18205183, 65, 1451745384633ULL },   // factor: 52858580793298305679
  { 18614789, 65, 1421870210280ULL },   // factor: 52935627899495661841
  { 18813239, 65, 1409521797625ULL },   // factor: 53035340908857514751
  { 18039583, 65, 1477601841188ULL },   // factor: 53310642110127489209
  { 18831191, 65, 1416170694745ULL },   // factor: 53336361682691582591
  { 18583841, 65, 1440612976431ULL },   // factor: 53544244993060902943
  { 18248603, 65, 1467949243300ULL },   // factor: 53576045930264219801
  { 18039271, 65, 1491254652896ULL },   // factor: 53802293627203757633
  { 18248441, 65, 1481880874179ULL },   // factor: 54084031402967809879
  { 18573899, 65, 1456256274256ULL },   // factor: 54096713912294488289
  { 18288797, 65, 1483248041695ULL },   // factor: 54253644670414781831
  { 18749377, 65, 1450364096003ULL },   // factor: 54386846446448880263
  { 18575041, 65, 1466613527975ULL },   // factor: 54484812826580543951
  { 18730093, 65, 1455289806195ULL },   // factor: 54515426823968652271
  { 18713449, 65, 1467815017095ULL },   // factor: 54935762927682821311
  { 18353857, 65, 1499348430759ULL },   // factor: 55037653382650174927
  { 18117667, 65, 1520871133604ULL },   // factor: 55109273497099563737
  { 18272207, 65, 1509278880349ULL },   // factor: 55155712244930320487
  { 18050309, 65, 1527956044651ULL },   // factor: 55160157488736694319
  { 18354313, 65, 1508154641531ULL },   // factor: 55362284686125546407
  { 18110383, 65, 1532976341696ULL },   // factor: 55525577356106859137
  { 18808487, 65, 1494326534517ULL },   // factor: 56212042396436091559
  { 18611239, 65, 1510915973301ULL },   // factor: 56240036576045059879
  { 18784879, 65, 1496978975909ULL },   // factor: 56241137855988960023
  { 18475453, 65, 1523324227232ULL },   // factor: 56288210327972272193
  { 18529817, 65, 1520272146168ULL },   // factor: 56340729317380582513
  { 18431053, 65, 1529625388571ULL },   // factor: 56385213213795390527
  { 18641977, 65, 1513400564828ULL },   // factor: 56425557042621169913
  { 18644911, 65, 1513765493384ULL },   // factor: 56448045798031537649
  { 18751717, 65, 1509053401244ULL },   // factor: 56594684636029871897
  { 18151579, 65, 1568335552557ULL },   // factor: 56935533361494075007
  { 18400853, 65, 1552968889896ULL },   // factor: 57151904513098962577
  { 18383243, 65, 1557594326016ULL },   // factor: 57267269981146699777
  { 18175529, 65, 1584869876244ULL },   // factor: 57611696793798466153
  { 18565013, 65, 1552324681591ULL },   // factor: 57637855787915551367
  { 18143519, 65, 1593452032636ULL },   // factor: 57821654459439772169
  { 18490649, 65, 1570230259780ULL },   // factor: 58069153165541594441
  { 18088957, 65, 1610005498160ULL },   // factor: 58246640451959638241
  { 18442867, 65, 1580034642308ULL },   // factor: 58280737526958034073
  { 18217873, 65, 1601779659575ULL },   // factor: 58362036824241167951
  { 18198977, 65, 1604937077308ULL },   // factor: 58416425912751027833
  { 18578369, 65, 1572801675499ULL },   // factor: 58440179782477362263
  { 18329273, 65, 1595288486440ULL },   // factor: 58480956363431116241
  { 18256097, 65, 1603050309547ULL },   // factor: 58530883893940116119
  { 18576589, 65, 1575622678196ULL },   // factor: 58539389823852706889
  { 18309077, 65, 1598843585727ULL },   // factor: 58546700644063487959
  { 18897497, 65, 1549070995323ULL },   // factor: 58547128973806813063
  { 18773609, 65, 1561923988419ULL },   // factor: 58645900492597668343
  { 18816583, 65, 1563471518520ULL },   // factor: 58838383192735234321
  { 18221701, 65, 1616827936619ULL },   // factor: 58922710459036737839
  { 18028897, 65, 1637832288543ULL },   // factor: 59056619266832054143
  { 18163883, 65, 1625739590680ULL },   // factor: 59059487427158820881
  { 18019699, 65, 1655150389269ULL },   // factor: 59650623628720420063
  { 18325939, 65, 1628015647100ULL },   // factor: 59669830879600253801
  { 18473387, 65, 1625022337588ULL },   // factor: 60039333051815541113
  { 18746417, 65, 1603683914095ULL },   // factor: 60126654779634095231
  { 18558049, 65, 1623202481067ULL },   // factor: 60246942361125916567
  { 18604793, 65, 1627058721760ULL },   // factor: 60542181434378791361
  { 18568973, 65, 1632831580407ULL },   // factor: 60640011060249824023
  { 18733277, 65, 1623850964823ULL },   // factor: 60840099861493029943
  { 18035989, 65, 1687734940404ULL },   // factor: 60879937640084399113
  { 18022649, 65, 1692171845499ULL },   // factor: 60994838438221413703
  { 18362077, 65, 1665776906508ULL },   // factor: 61174247644243394233
  { 18859063, 65, 1622182282208ULL },   // factor: 61185675715288902209
  { 18255343, 65, 1676521713953ULL },   // factor: 61210957870319801759
  { 18118489, 65, 1703652440816ULL },   // factor: 61735216017495694049
  { 18050233, 65, 1713978495615ULL },   // factor: 61875422405680456591
  { 18761027, 65, 1650216037540ULL },   // factor: 61919495272241907161
  { 18788827, 65, 1648263322305ULL },   // factor: 61937868826467772471
  { 18763457, 65, 1650871483659ULL },   // factor: 61952112192323698327
  { 18207347, 65, 1701599858605ULL },   // factor: 61963238161544341871
  { 18324343, 65, 1692085305465ULL },   // factor: 62012703045200868991
  { 18878987, 65, 1650236775772ULL },   // factor: 62309597273443005929
  { 18874523, 65, 1653847289460ULL },   // factor: 62431157406800855161
  { 18823781, 65, 1659938398923ULL },   // factor: 62492633789634375727
  { 18728197, 65, 1678349675064ULL },   // factor: 62864926698969159217
  { 18682981, 65, 1682614368939ULL },   // factor: 62872504570428654319
  { 18405437, 65, 1709408027052ULL },   // factor: 62924803498399763449
  { 18537373, 65, 1716726154803ULL },   // factor: 63647186140877905039
  { 18219983, 65, 1747191010096ULL },   // factor: 63667581003403896737
  { 18433069, 65, 1728733419831ULL },   // factor: 63731724820701582679
  { 18287957, 65, 1752328337059ULL },   // factor: 64093010556032996927
  { 18346037, 65, 1748383136547ULL },   // factor: 64151803426534628479
  { 18788629, 65, 1708358314764ULL },   // factor: 64195421150332037113
  { 18208621, 65, 1770258438683ULL },   // factor: 64467929964060972287
  { 18237281, 65, 1767402850444ULL },   // factor: 64465244847496405529
  { 18561167, 65, 1739379210093ULL },   // factor: 64569815989728517063
  { 18659699, 65, 1731943704480ULL },   // factor: 64635096421083503041
  { 18738019, 65, 1724925007361ULL },   // factor: 64643355123011115719
  { 18755357, 65, 1724486306263ULL },   // factor: 64686712631147801783
  { 18285781, 65, 1769061291063ULL },   // factor: 64697334687910550407
  { 18039629, 65, 1795156868559ULL },   // factor: 64767927811212249223
  { 18814513, 65, 1722010892736ULL },   // factor: 64797592655046155137
  { 18878999, 65, 1716585400969ULL },   // factor: 64814828136616700063
  { 18737083, 65, 1730440987392ULL },   // factor: 64846832814731715073
  { 18632981, 65, 1740494120904ULL },   // factor: 64861187770831869649
  { 18533993, 65, 1753655234811ULL },   // factor: 65004467692800860647
  { 18239423, 65, 1786530307576ULL },   // factor: 65170563964397537297
  { 18250439, 65, 1790802166581ULL },   // factor: 65365851404508758119
  { 18453319, 65, 1771383214109ULL },   // factor: 65375799042397355543
  { 18306173, 65, 1794283276195ULL },   // factor: 65692920130064903471
  { 18306997, 65, 1797505067252ULL },   // factor: 65813839747334324489
  { 18592631, 65, 1771735254925ULL },   // factor: 65882439649022915351
  { 18082877, 65, 1833983053527ULL },   // factor: 66327379954026314359
  { 18664501, 65, 1777893743016ULL },   // factor: 66366999088831750033
  { 18111229, 65, 1833428621972ULL },   // factor: 66411291255378647177
  { 18774169, 65, 1774799195327ULL },   // factor: 66640760068266216527
  { 18183743, 65, 1835584265781ULL },   // factor: 66755585087610796567
  { 18411749, 65, 1812799582680ULL },   // factor: 66753621807217814641
  { 18700673, 65, 1787878785691ULL },   // factor: 66869073069688940087
  { 18224879, 65, 1841103924084ULL },   // factor: 67107792485712171673
  { 18196499, 65, 1847087314816ULL },   // factor: 67221044953924058369
  { 18206281, 65, 1848276560244ULL },   // factor: 67300484843031385129
  { 18271933, 65, 1850712398723ULL },   // factor: 67632185903471883119
  { 18382631, 65, 1841460436905ULL },   // factor: 67701775425446794111
  { 18086017, 65, 1880245189800ULL },   // factor: 68012292933782053201
  { 18064247, 65, 1883126462484ULL },   // factor: 68034523101094419097
  { 18142301, 65, 1879790186319ULL },   // factor: 68207438754090760039
  { 18239717, 65, 1877397427015ULL },   // factor: 68486395530563509511
  { 18744461, 65, 1830730940415ULL },   // factor: 68632129428204582631
  { 18857599, 65, 1820553275589ULL },   // factor: 68662527258387701623
  { 18668687, 65, 1846941047937ULL },   // factor: 68959928662775697439
  { 18393619, 65, 1879693133372ULL },   // factor: 69148718664321506537
  { 18341581, 65, 1888315702523ULL },   // factor: 69269390822795017727
  { 18351847, 65, 1898358425945ULL },   // factor: 69676766768206940831
  { 18051413, 65, 1932096058552ULL },   // factor: 69754127817188667953
  { 18781613, 65, 1861144115911ULL },   // factor: 69910577044535088887
  { 18048889, 65, 1938376798779ULL },   // factor: 69971095362675013063
  { 18408107, 65, 1908061477008ULL },   // factor: 70247599662682607713
  { 18555697, 65, 1904019492915ULL },   // factor: 70660817585248773511
  { 18512381, 65, 1908717034884ULL },   // factor: 70669793941925797609
  { 18603229, 65, 1900375560804ULL },   // factor: 70706243487280472233
  { 18180077, 65, 1949296244023ULL },   // factor: 70876711624297859543
  { 18078727, 65, 1960602440577ULL },   // factor: 70890392557450610959
  { 18548291, 65, 1917636694045ULL },   // factor: 71137766866849254191
  { 18008689, 65, 1981172753615ULL },   // factor: 71356647950252321471
  { 18689059, 65, 1919047028220ULL },   // factor: 71730366268356489961
  { 18205601, 65, 1975774593388ULL },   // factor: 71940327826318332377
  { 18317681, 65, 1967808878028ULL },   // factor: 72091390593369626137
  { 18652093, 65, 1937186557955ULL },   // factor: 72265167674653099631
  { 18771041, 65, 1927233413755ULL },   // factor: 72352354852330137911
  { 18261623, 65, 1983031878253ULL },   // factor: 72426761115276369239
  { 18056369, 65, 2013828144244ULL },   // factor: 72724848150109780073
  { 18501283, 65, 1965379819053ULL },   // factor: 72724096469576689999
  { 18176321, 65, 2002935341676ULL },   // factor: 72811991425095307993
  { 18203707, 65, 2014651084164ULL },   // factor: 73348236086707591897
  { 18624929, 65, 1972142701860ULL },   // factor: 73462035600021335881
  { 18585517, 65, 1980033398855ULL },   // factor: 73599888789974766071
  { 18400909, 66, 2026376827064ULL },   // factor: 74574351189026802353
  { 18028379, 66, 2073173855740ULL },   // factor: 74751928008344090921
  { 18212993, 66, 2052048938955ULL },   // factor: 74747905921689684631
  { 18082411, 66, 2071672467888ULL },   // factor: 74921666043470235937
  { 18751553, 66, 2007961334296ULL },   // factor: 75304786764004323377
  { 18713411, 66, 2023119450748ULL },   // factor: 75718931567883162857
  { 18631243, 66, 2035167150017ULL },   // factor: 75835387435168362263
  { 18520913, 66, 2064736257387ULL },   // factor: 76481601182020468663
  { 18210397, 66, 2106000901472ULL },   // factor: 76702224996326008769
  { 18469051, 66, 2083348711020ULL },   // factor: 76954947189225284041
  { 18403159, 66, 2111001849344ULL },   // factor: 77698205365543355393
  { 18465833, 66, 2105857527072ULL },   // factor: 77772826833409061953
  { 18117271, 66, 2149644583409ULL },   // factor: 77891386942605913679
  { 18140783, 66, 2159985674677ULL },   // factor: 78367662814848104183
  { 18374207, 66, 2142239809209ULL },   // factor: 78723915396093344527
  { 18169321, 66, 2176536436895ULL },   // factor: 79092378380282996591
  { 18051317, 66, 2203601138460ULL },   // factor: 79555805383804703641
  { 18532783, 66, 2171380652192ULL },   // factor: 80483452874945620673
  { 18756037, 66, 2151390946599ULL },   // factor: 80703136391751736327
  { 18112183, 66, 2229198569616ULL },   // factor: 80751304872446463457
  { 18179297, 66, 2229707347920ULL },   // factor: 81069024201840024481
  { 18448279, 66, 2209990013289ULL },   // factor: 81541024704738359263
  { 18737489, 66, 2183715083127ULL },   // factor: 81834674698452496207
  { 18797963, 66, 2193842880240ULL },   // factor: 82479554581129902241
  { 18208409, 66, 2268934748256ULL },   // factor: 82627383781114569409
  { 18784621, 66, 2208702717743ULL },   // factor: 82979286908944460807
  { 18652589, 66, 2250444068916ULL },   // factor: 83953216569955647049
  { 18236497, 66, 2308414546004ULL },   // factor: 84194789885916615977
  { 18161711, 66, 2320306476096ULL },   // factor: 84281471300567920513
  { 18615439, 66, 2285182265949ULL },   // factor: 85079342151310773223
  { 18279407, 66, 2334643553808ULL },   // factor: 85351799439965663713
  { 18661603, 66, 2304541362893ULL },   // factor: 86012872022776194959
  { 18881719, 66, 2286952411932ULL },   // factor: 86363185616944542217
  { 18431827, 66, 2369854665600ULL },   // factor: 87361502422964102401
  { 18126803, 66, 2463361743201ULL },   // factor: 89305746073482232807
  { 18263023, 66, 2487723359208ULL },   // factor: 90866697853705931569
  { 18288269, 66, 2499015117951ULL },   // factor: 91405321424309233639
  { 18669433, 66, 2467201116423ULL },   // factor: 92122491881168796319
  { 18467473, 66, 2511930955935ULL },   // factor: 92778034213187604511
  { 18108973, 66, 2612376715916ULL },   // factor: 94614918828703028537
  { 18386791, 66, 2575916555009ULL },   // factor: 94725678660780972239
  { 18573391, 66, 2564378019621ULL },   // factor: 95258391260453009623
  { 18143227, 66, 2631479633412ULL },   // factor: 95487064669741401049
  { 18463477, 66, 2591345854688ULL },   // factor: 95690509174154460353
  { 18810179, 66, 2548121785624ULL },   // factor: 95861253802774133393
  { 18608861, 66, 2577161027155ULL },   // factor: 95916062657889240911
  { 18493333, 66, 2644466450408ULL },   // factor: 97809997349446259729
  { 18670357, 66, 2626675432460ULL },   // factor: 98081936094315176441
  { 18041951, 66, 2806715822265ULL },   // factor: 101277258672459678031
  { 18001601, 66, 2828970031168ULL },   // factor: 101851979484087799937
  { 18481007, 66, 2757906282393ULL },   // factor: 101937770620498019503
  { 18149249, 66, 2816677667287ULL },   // factor: 102241168672661834927
  { 18152249, 66, 2845190200600ULL },   // factor: 103293201947302298801
  { 18499007, 66, 2818363692984ULL },   // factor: 104273859370113733777
  { 18387301, 66, 2841618510948ULL },   // factor: 104499389775945342697
  { 18131411, 66, 2892497337376ULL },   // factor: 104890116080739835073
  { 18857381, 66, 2784532534735ULL },   // factor: 105017981828787258071
  { 18509809, 66, 2837519500359ULL },   // factor: 105043887970841042863
  { 18425731, 66, 2873278006781ULL },   // factor: 105884495282325763823
  { 18222427, 66, 2910582236828ULL },   // factor: 106075744676189883113
  { 18793283, 66, 2839273238641ULL },   // factor: 106718530976213696807
  { 18545077, 66, 2906305263015ULL },   // factor: 107795309776236854311
  { 18508339, 66, 2922813951336ULL },   // factor: 108192862890512381809
  { 18715903, 66, 2914328280596ULL },   // factor: 109088570819583036377
  { 18620003, 66, 2940350514556ULL },   // factor: 109498670804168527337
  { 18862447, 66, 2925494964192ULL },   // factor: 110363987421676995649
  { 18535787, 66, 3060543836100ULL },   // factor: 113459177300225021401
  { 18077819, 66, 3176244188421ULL },   // factor: 114839135076153467599
  { 18750349, 66, 3098681072384ULL },   // factor: 116202703093788524033
  { 18190973, 66, 3215961453547ULL },   // factor: 117002935941028462463
  { 18507427, 66, 3191172114888ULL },   // factor: 118120769921450546353
  { 18579779, 66, 3181007125477ULL },   // factor: 118204818777575859167
  { 18067771, 66, 3308055120189ULL },   // factor: 119538364733904657439
  { 18094723, 66, 3336349850552ULL },   // factor: 120740652753659674193
  { 18043229, 66, 3387872803452ULL },   // factor: 122256329631112853017
  { 18748643, 66, 3296307160512ULL },   // factor: 123602572341566370433
  { 18098573, 66, 3435083253651ULL },   // factor: 124340210054560280047
  { 18477883, 66, 3402089638997ULL },   // factor: 125726828609797606703
  { 18874643, 66, 3350867171481ULL },   // factor: 126492843204247312567
  { 18626063, 66, 3433383491256ULL },   // factor: 127900834422588410257
  { 18862871, 66, 3409779989160ULL },   // factor: 128636480147812956721
  { 18349049, 66, 3551819988532ULL },   // factor: 130345038017506212137
  { 18009287, 66, 3654975335860ULL },   // factor: 131646999602848263641
  { 18244729, 66, 3724654052999ULL },   // factor: 135910607631436784543
  { 18346693, 66, 3737212697183ULL },   // factor: 137130988061836931639
  { 18615217, 66, 3700081777319ULL },   // factor: 137755650405077726447
  { 18479117, 66, 3773907031404ULL },   // factor: 139476939160874380537
  { 18411689, 66, 3811283808516ULL },   // factor: 140344344346264287049
  { 18804859, 66, 3767303902836ULL },   // factor: 141687237405961360249
  { 18611009, 66, 3821287027272ULL },   // factor: 142236014512284874897
  { 18142919, 66, 3943583195709ULL },   // factor: 143096220979019069143
  { 18845941, 66, 3901024076271ULL },   // factor: 147036939161965532023
  { 18626627, 67, 3988824284677ULL },   // factor: 148596684238440588959
  { 18162971, 67, 4098709599249ULL },   // factor: 148889487177162417559
  { 18685781, 67, 3994438246311ULL },   // factor: 149278396577182807783
  { 18146411, 67, 4116719235253ULL },   // factor: 149407358429013253967
  { 18709463, 67, 3997040874976ULL },   // factor: 149564976719702195777
  { 18720337, 67, 4062181125432ULL },   // factor: 152090799246252621169
  { 18299399, 67, 4176065983956ULL },   // factor: 152838995381476884889
  { 18898963, 67, 4093739685945ULL },   // factor: 154734869712612350071
  { 18297883, 67, 4250730284765ULL },   // factor: 155558730830373304991
  { 18226361, 67, 4269819439315ULL },   // factor: 155646541011545565431
  { 18454609, 67, 4279771360071ULL },   // factor: 157963014119017034479
  { 18568049, 67, 4340343243879ULL },   // factor: 161183412058328444143
  { 18613061, 67, 4339990369468ULL },   // factor: 161561010972640843097
  { 18194431, 67, 4443166595028ULL },   // factor: 161681776069483778137
  { 18115313, 67, 4470102996288ULL },   // factor: 161954629839989916289
  { 18810499, 67, 4339579369832ULL },   // factor: 163259306793290932337
  { 18174823, 67, 4507821598308ULL },   // factor: 163857719329649998969
  { 18896387, 67, 4343463430389ULL },   // factor: 164151531801956209087
  { 18804911, 67, 4424061398149ULL },   // factor: 166388161701455019479
  { 18483623, 67, 4526211398457ULL },   // factor: 167321570214763939423
  { 18596219, 67, 4536722830744ULL },   // factor: 168731782605630713873
  { 18463589, 67, 4573988996187ULL },   // factor: 168904505832238670287
  { 18669737, 67, 4536980744424ULL },   // factor: 169408474544920592977
  { 18816719, 67, 4544819913520ULL },   // factor: 171037198436620281761
  { 18287849, 67, 4688478939555ULL },   // factor: 171484389772523934391
  { 18233101, 67, 4702944289275ULL },   // factor: 171498516447448583551
  { 18862247, 67, 4726881458788ULL },   // factor: 178319211230759153273
  { 18620821, 67, 4806851737215ULL },   // factor: 179015051544439107031
  { 18140923, 67, 4935667179341ULL },   // factor: 179075116508104543487
  { 18035597, 67, 4981558305180ULL },   // factor: 179690756048458984921
  { 18754583, 67, 4829310695565ULL },   // factor: 181143416545523048791
  { 18362459, 67, 4939361126452ULL },   // factor: 181397632341337330937
  { 18103289, 67, 5044372660776ULL },   // factor: 182639472203453784529
  { 18517007, 67, 4933110870945ULL },   // factor: 182692897058129323231
  { 18545477, 67, 4940229688924ULL },   // factor: 183237832141314393497
  { 18038407, 67, 5172025744053ULL },   // factor: 186590210771411687143
  { 18779867, 67, 5000080365324ULL },   // factor: 187801688500192263817
  { 18098783, 67, 5269381825641ULL },   // factor: 190738796412840589807
  { 18665039, 67, 5174764587045ULL },   // factor: 193174365666027639511
  { 18686597, 67, 5296232400915ULL },   // factor: 197937120988482072511
  { 18620549, 67, 5320819378131ULL },   // factor: 198153155901275627839
  { 18378523, 67, 5404962985013ULL },   // factor: 198670473068420151599
  { 18267791, 67, 5454928788525ULL },   // factor: 199298998057315796551
  { 18535589, 67, 5410847294832ULL },   // factor: 200586483197535552097
  { 18524927, 67, 5445019911864ULL },   // factor: 201737192761654067857
  { 18806393, 67, 5380073141367ULL },   // factor: 202359539730584718463
  { 18215749, 67, 5607024161591ULL },   // factor: 204272289528954193319
  { 18458117, 67, 5539629556740ULL },   // factor: 204502260989930117161
  { 18001999, 67, 5686681365924ULL },   // factor: 204743264525364964153
  { 18510071, 67, 5569935718116ULL },   // factor: 206199811215526292473
  { 18759731, 67, 5627599523604ULL },   // factor: 211144506477078381049
  { 18252139, 67, 5811057927321ULL },   // factor: 212128474053029579239
  { 18121651, 67, 5873573667060ULL },   // factor: 212877704234503032121
  { 18141367, 67, 5879885451452ULL },   // factor: 213338319785502829769
  { 18410101, 67, 5829309971859ULL },   // factor: 214636370684462695519
  { 18010151, 67, 6016489134948ULL },   // factor: 216715755620545714297
  { 18352237, 67, 5991172913187ULL },   // factor: 219902850421576498639
  { 18407251, 67, 5985782308004ULL },   // factor: 220363594749577874009
  { 18439349, 67, 6016020952596ULL },   // factor: 221863019872460200009
  { 18704489, 67, 5953430736696ULL },   // factor: 222711759453584456689
  { 18494851, 67, 6066236604725ULL },   // factor: 224388284270269541951
  { 18674737, 67, 6130402429092ULL },   // factor: 228967306134908497609
  { 18557881, 67, 6192433778660ULL },   // factor: 229836898329505238921
  { 18136177, 67, 6435342657152ULL },   // factor: 233425026971517975809
  { 18213119, 67, 6440191378056ULL },   // factor: 234591943902615833329
  { 18614587, 67, 6427213966604ULL },   // factor: 239279867097930505097
  { 18385033, 67, 6548786589575ULL },   // factor: 240799315118587661951
  { 18568799, 67, 6521602498500ULL },   // factor: 242196651905088603001
  { 18745709, 67, 6471998898972ULL },   // factor: 242644416016899022297
  { 18706691, 67, 6581209657693ULL },   // factor: 246225310945357447727
  { 18499801, 67, 6685815631860ULL },   // factor: 247372517424198519721
  { 18133777, 67, 6966066399360ULL },   // factor: 252642189306374365441
  { 18382759, 67, 6883522914320ULL },   // factor: 253076285609844417761
  { 18120919, 67, 7015168484436ULL },   // factor: 254242599755635033369
  { 18401651, 67, 6911930575113ULL },   // factor: 254381868358917423127
  { 18259427, 67, 6982751936577ULL },   // factor: 255002098490072722759
  { 18397921, 67, 6991373127896ULL },   // factor: 257253460977107008433
  { 18000439, 67, 7150045117845ULL },   // factor: 257407901982033467911
  { 18295631, 67, 7037188628341ULL },   // factor: 257499612843046156343
  { 18562967, 67, 6943160387832ULL },   // factor: 257771314310065235089
  { 18203929, 67, 7192525221659ULL },   // factor: 261864436931579396423
  { 18487093, 67, 7086752460216ULL },   // factor: 262026903599983984177
  { 18088621, 67, 7292534910396ULL },   // factor: 263823800246844407833
  { 18003913, 67, 7387685296748ULL },   // factor: 266014486708060349849
  { 18684983, 67, 7196399409217ULL },   // factor: 268929201244859376623
  { 18605887, 67, 7328646878748ULL },   // factor: 272711951377775978953
  { 18149759, 67, 7570046786112ULL },   // factor: 274789049573314694017
  { 18210481, 67, 7613243049420ULL },   // factor: 277281635799689942041
  { 18793403, 67, 7382751729313ULL },   // factor: 277494056995852244279
  { 18086503, 67, 7692855573708ULL },   // factor: 278273710824872926249
  { 18677467, 67, 7458209745704ULL },   // factor: 278600932808929703537
  { 18197671, 67, 7672531892265ULL },   // factor: 279244422224891829631
  { 18799411, 67, 7740405784749ULL },   // factor: 291030139308547965679
  { 18751589, 67, 7761863767707ULL },   // factor: 291094558492066272847
  { 18683551, 67, 7831119621696ULL },   // factor: 292626245678115844993
  { 18118721, 67, 8134000151331ULL },   // factor: 294755358711848335303
  { 18281387, 67, 8069116526344ULL },   // factor: 295029283932380718257
  { 18407231, 68, 8060825096940ULL },   // factor: 296754939219943946281
  { 18567551, 68, 8045989575840ULL },   // factor: 298788643589755135681
  { 18081439, 68, 8341026140072ULL },   // factor: 301635510698234647217
  { 18403753, 68, 8205108574428ULL },   // factor: 302009583083910056569
  { 18129493, 68, 8365663030491ULL },   // factor: 303330458703290742127
  { 18718957, 68, 8112269121408ULL },   // factor: 303706433712128262913
  { 18522233, 68, 8212295301672ULL },   // factor: 304220094084748147153
  { 18430417, 68, 8315428188927ULL },   // factor: 306513618110958785119
  { 18744937, 68, 8337174497219ULL },   // factor: 312559621416753660407
  { 18218771, 68, 8648646968736ULL },   // factor: 315135437166490686913
  { 18352937, 68, 8589403365388ULL },   // factor: 315281557665107889113
  { 18369389, 68, 8582979889327ULL },   // factor: 315328192732449222407
  { 18035543, 68, 8947429416988ULL },   // factor: 322743495979104008969
  { 18419201, 68, 8827112355319ULL },   // factor: 325176713444408160239
  { 18750539, 68, 8755044283897ULL },   // factor: 328323598583875540967
  { 18171073, 68, 9133262360600ULL },   // factor: 331922354165229847601
  { 18484007, 68, 8983386038200ULL },   // factor: 332097940827582134801
  { 18472411, 68, 9102264032760ULL },   // factor: 336281524487320368721
  { 18649387, 68, 9058602666012ULL },   // factor: 337874773595379069289
  { 18194753, 68, 9425068117156ULL },   // factor: 342973572799656964937
  { 18473869, 68, 9345424616364ULL },   // factor: 345292300224167584633
  { 18720433, 68, 9376221215055ULL },   // factor: 351053842099231437631
  { 18435337, 68, 9642217599827ULL },   // factor: 355515061760283773399
  { 18007343, 68, 10025279766748ULL },   // factor: 361057302861582461129
  { 18666301, 68, 9903896831360ULL },   // factor: 369738238654223998721
  { 18677201, 68, 10150076802556ULL },   // factor: 379150049213551451513
  { 18557821, 68, 10228390386948ULL },   // factor: 379633275838203440617
  { 18113071, 68, 10506707978208ULL },   // factor: 380617495171095913537
  { 18033011, 68, 10591765254928ULL },   // factor: 382002838703068856417
  { 18598219, 68, 10405165423520ULL },   // factor: 387035090555705421761
  { 18456719, 68, 10582310706357ULL },   // factor: 390629470155845325367
  { 18585631, 68, 10553795649593ULL },   // factor: 392297903185481596367
  { 18183463, 68, 10832086103328ULL },   // factor: 393929673745357729729
  { 18168349, 68, 10841726731464ULL },   // factor: 393952550039734465873
  { 18344891, 68, 10799045904721ULL },   // factor: 396214640052206260823
  { 18584567, 68, 10755947814180ULL },   // factor: 399789265602263520121
  { 18181253, 68, 11106255044556ULL },   // factor: 403851265695197817337
  { 18383611, 68, 11101906920729ULL },   // factor: 408186276377779544839
  { 18706309, 68, 10935248575611ULL },   // factor: 409116277694378459599
  { 18815837, 68, 10984589983800ULL },   // factor: 413368509294026881201
  { 18867157, 68, 10992199072752ULL },   // factor: 414783091361732812129
  { 18117751, 68, 11470857187560ULL },   // factor: 415652268561544755121
  { 18703063, 68, 11343415841937ULL },   // factor: 424313242253891506063
  { 18461279, 68, 11575238992305ULL },   // factor: 427387433057242916191
  { 18049349, 68, 11843436317184ULL },   // factor: 427532630896257426433
  { 18048139, 68, 12015084817340ULL },   // factor: 433699841760283860521
  { 18063527, 68, 12019332851620ULL },   // factor: 434223086974449727481
  { 18422249, 68, 11846545456516ULL },   // factor: 436480020379512848969
  { 18065381, 68, 12125380747455ULL },   // factor: 438099245945678710711
  { 18157211, 68, 12311362843473ULL },   // factor: 447080025692998467607
  { 18148153, 68, 12346965094596ULL },   // factor: 448149223244775362377
  { 18134617, 68, 12389031926819ULL },   // factor: 449340697987269186647
  { 18108481, 68, 12610571217300ULL },   // factor: 456716578575247842601
  { 18838847, 68, 12197746893865ULL },   // factor: 459582974956495947311
  { 18456157, 68, 12453523727048ULL },   // factor: 459688378219246069073
  { 18687101, 68, 12333007468483ULL },   // factor: 460936312394592275567
  { 18715927, 68, 12432271856244ULL },   // factor: 465362985011234396377
  { 18231313, 68, 13257707670588ULL },   // factor: 483410836409981444089
  { 18721867, 68, 12935401214585ULL },   // factor: 484349722262197660391
  { 18672131, 68, 13122864642901ULL },   // factor: 490063695415031384063
  { 18745787, 68, 13279878804049ULL },   // factor: 497883558893034583127
  { 18406627, 68, 13740473592840ULL },   // factor: 505831544453511501361
  { 18252727, 68, 13990352220752ULL },   // factor: 510724159438459981409
  { 18763501, 68, 13782107482436ULL },   // factor: 517201175057590736873
  { 18488669, 68, 14191414686060ULL },   // factor: 524760737544604508281
  { 18295273, 68, 14373226231916ULL },   // factor: 525924195607329066137
  { 18416669, 68, 14417634807439ULL },   // factor: 531049616022965601383
  { 18866381, 68, 14079660864388ULL },   // factor: 531264492436666679657
  { 18889919, 68, 14083274378236ULL },   // factor: 532063824519306805769
  { 18372877, 68, 14569672884963ULL },   // factor: 535373615691320697103
  { 18810613, 68, 14277101462843ULL },   // factor: 537122060758547105519
  { 18608861, 68, 14441724934503ULL },   // factor: 537488103812800862167
  { 18033523, 68, 14978929743032ULL },   // factor: 540245748072703323473
  { 18332407, 68, 14854566389564ULL },   // factor: 544639913724015601097
  { 18043229, 68, 15409627713592ULL },   // factor: 556078883282173737137
  { 18201793, 68, 15459371268600ULL },   // factor: 562776551482409199601
  { 18820031, 68, 14961218192404ULL },   // factor: 563141180357614489049
  { 18446203, 68, 15346643360468ULL },   // factor: 566174597591589806009
  { 18002513, 68, 15900570796591ULL },   // factor: 572500464946099666367
  { 18430823, 68, 15595867029816ULL },   // factor: 574889329516148837137
  { 18049147, 68, 15939932011913ULL },   // factor: 575404352106046976423
  { 18602813, 68, 15528701030920ULL },   // factor: 577755042822223955921
  { 18139273, 69, 16383697058967ULL },   // factor: 594376707403799021983
  { 18201289, 69, 16366056458775ULL },   // factor: 595766646792960721951
  { 18486631, 69, 16135769358093ULL },   // factor: 596592028048344309367
  { 18600479, 69, 16214230069585ULL },   // factor: 603184891820968662431
  { 18765151, 69, 16138522061601ULL },   // factor: 605683606805548133503
  { 18216389, 69, 16690442312635ULL },   // factor: 608079179498037550031
  { 18113807, 69, 16809766025220ULL },   // factor: 608977714991984425081
  { 18219137, 69, 16896092350368ULL },   // factor: 615664442592013184833
  { 18282331, 69, 17015875896084ULL },   // factor: 622179750774258583609
  { 18031451, 69, 17321751200736ULL },   // factor: 624672616020524695873
  { 18260357, 69, 17297437000095ULL },   // factor: 631714749613487467831
  { 18435211, 69, 17912805840401ULL },   // factor: 660452710539649519223
  { 18746551, 69, 17978326683029ULL },   // factor: 674063236116127965959
  { 18207653, 69, 18630660732735ULL },   // factor: 678441211564729241911
  { 18838243, 69, 18071312923056ULL },   // factor: 680863568347138461217
  { 18893293, 69, 18156995386767ULL },   // factor: 686090867683674507463
  { 18483557, 69, 18666649799172ULL },   // factor: 690052171124068429609
  { 18147589, 69, 19622736841620ULL },   // factor: 712210726513755708361
  { 18293687, 69, 19606507188385ULL },   // factor: 717350611335130450991
  { 18130799, 69, 19978446649036ULL },   // factor: 724450401051790519529
  { 18470467, 69, 19708222298877ULL },   // factor: 728040139200143531119
  { 18633917, 69, 19536659626348ULL },   // factor: 728088987869239290233
  { 18127951, 69, 20234811766325ULL },   // factor: 733631352388326100151
  { 18826201, 69, 19533877369500ULL },   // factor: 735497403335116539001
  { 18260239, 69, 20289559493660ULL },   // factor: 740984411117901169481
  { 18613957, 69, 19957674762224ULL },   // factor: 742982599688045520737
  { 18545503, 69, 20588427470808ULL },   // factor: 763645486850304352849
  { 18141073, 69, 21149533109432ULL },   // factor: 767350448108245801073
  { 18143701, 69, 21601769850936ULL },   // factor: 783872106492394708273
  { 18092797, 69, 21852224575152ULL },   // factor: 790735726473272760289
  { 18437161, 69, 21800964453975ULL },   // factor: 803895783186428329951
  { 18131951, 69, 22399378733364ULL },   // factor: 812288875247596226329
  { 18783881, 69, 22125395353924ULL },   // factor: 831201586812122598089
  { 18194027, 69, 22885469346157ULL },   // factor: 832757694383305608479
  { 18863147, 69, 22477036664457ULL },   // factor: 847975293452084132359
  { 18782639, 69, 22709514646524ULL },   // factor: 853089230941745793673
  { 18467789, 69, 23707371691564ULL },   // factor: 875645476288754063993
  { 18658229, 69, 23488445542647ULL },   // factor: 876505591577473984327
  { 18550793, 69, 23751250029975ULL },   // factor: 881209045594620040351
  { 18509339, 69, 23927979435616ULL },   // factor: 885782165917690435649
  { 18773021, 69, 23818655371908ULL },   // factor: 894296234977183388137
  { 18408431, 69, 24665467573816ULL },   // factor: 908105115830658485393
  { 18890611, 69, 24186026489160ULL },   // factor: 913777636084834553521
  { 18875369, 69, 24462876427059ULL },   // factor: 923491638724280419543
  { 18131233, 69, 25816885934012ULL },   // factor: 936183948407988393593
  { 18603829, 69, 26017279873380ULL },   // factor: 968042051619006344041
  { 18151379, 69, 26998389744400ULL },   // factor: 980116009280635055201
  { 18495767, 69, 26497634888808ULL },   // factor: 980188161908927351473
  { 18006481, 69, 27625122223128ULL },   // factor: 994862476866864185137
  { 18865447, 69, 26572536972740ULL },   // factor: 1002605575829533829561
  { 18463559, 69, 27290701891245ULL },   // factor: 1007766969040827281911
  { 18677293, 69, 27219233544320ULL },   // factor: 1016763200285386251521
  { 18479677, 69, 27513761173680ULL },   // factor: 1016890839089494602721
  { 18250457, 69, 28228313087739ULL },   // factor: 1030359228380635693447
  { 18610639, 69, 27918913473641ULL },   // factor: 1039177639860337333199
  { 18607987, 69, 27969419404472ULL },   // factor: 1040909185351925435729
  { 18651949, 69, 28216326340271ULL },   // factor: 1052578959732182676359
  { 18134161, 69, 29101485919224ULL },   // factor: 1055462061996882022129
  { 18451799, 69, 28854928437309ULL },   // factor: 1064850679369219537783
  { 18304831, 69, 29152321046901ULL },   // factor: 1067256620042531757463
  { 18875239, 69, 28302547046660ULL },   // factor: 1068434679628903303481
  { 18302533, 69, 29850816786740ULL },   // factor: 1092691118632525624841
  { 18379927, 69, 30311260164024ULL },   // factor: 1114237498185538292497
  { 18338233, 69, 30535022081180ULL },   // factor: 1119916699169647509881
  { 18616627, 69, 30233877423777ULL },   // factor: 1125705637524354680359
  { 18686567, 69, 30316676350485ULL },   // factor: 1133029207681306869991
  { 18760351, 69, 30354111649988ULL },   // factor: 1138907577693928051577
  { 18285383, 69, 31460529713616ULL },   // factor: 1150535670392697749857
  { 18031451, 69, 32057478708249ULL },   // factor: 1156085713022670278599
  { 18637979, 69, 31670635330869ULL },   // factor: 1180553272426788947503
  { 18247909, 70, 33486652438296ULL },   // factor: 1222122772817307046129
  { 18721189, 70, 32698727786772ULL },   // factor: 1224318125911420623817
  { 18078169, 70, 34125019132227ULL },   // factor: 1233835726001266104727
  { 18130459, 70, 34738979460285ULL },   // factor: 1259667285613078641631
  { 18584887, 70, 33968502625389ULL },   // factor: 1262601565704115792087
  { 18726893, 70, 33911307756255ULL },   // factor: 1270106863682914931431
  { 18103831, 70, 36314927816361ULL },   // factor: 1314878631929197157983
  { 18416687, 70, 36074203093704ULL },   // factor: 1328734614302356477297
  { 18657763, 70, 35743857042296ULL },   // factor: 1333800826802079487697
  { 18565543, 70, 36773265124088ULL },   // factor: 1365431269823312199569
  { 18485869, 70, 37464505962816ULL },   // factor: 1385127898756670894209
  { 18429067, 70, 37764504916229ULL },   // factor: 1391929182646027256687
  { 18492361, 70, 37668226428075ULL },   // factor: 1393148882675406870151
  { 18466837, 70, 37983644334444ULL },   // factor: 1402875537180301667257
  { 18310427, 70, 38890272766092ULL },   // factor: 1424195000987231282569
  { 18111727, 70, 40190601488657ULL },   // factor: 1455842404256698361279
  { 18553879, 70, 39810847430501ULL },   // factor: 1477291292225952926759
  { 18735313, 70, 40889213893611ULL },   // factor: 1532144441241501570487
  { 18420791, 70, 41624521687485ULL },   // factor: 1533513228960257001271
  { 18707707, 70, 41163111211688ULL },   // factor: 1540134847513348158833
  { 18803527, 70, 41260309646400ULL },   // factor: 1551678692928885705601
  { 18027881, 70, 43121450747040ULL },   // factor: 1554776765229996444481
  { 18371077, 70, 42425923580880ULL },   // factor: 1558819817800924415521
  { 18011603, 70, 43306110726096ULL },   // factor: 1560024947744965783777
  { 18641369, 70, 42501664020231ULL },   // factor: 1584578404230299072479
  { 18556691, 70, 44376559164300ULL },   // factor: 1646964192110266662601
  { 18587299, 70, 44844622348596ULL },   // factor: 1667080808270872164409
  { 18682973, 70, 45775235511228ULL },   // factor: 1710434978249827841689
  { 18851869, 70, 45682130578671ULL },   // factor: 1722387082619999772199
  { 18352883, 70, 47190510370413ULL },   // factor: 1732163831076952901359
  { 18680033, 70, 46401655776256ULL },   // factor: 1733568922310205392897
  { 18709241, 70, 46393738142788ULL },   // factor: 1735983255608626207817
  { 18883537, 70, 46318649375208ULL },   // factor: 1749319858533534301393
  { 18267173, 70, 48727039199143ULL },   // factor: 1780210509657053265479
  { 18341599, 70, 48926032237700ULL },   // factor: 1794763327929932164601
  { 18484783, 70, 49262006914148ULL },   // factor: 1821195015905050819769
  { 18164141, 70, 50910721718844ULL },   // factor: 1849499055425689546009
  { 18863839, 70, 49643523803097ULL },   // factor: 1872934880828579018767
  { 18285359, 70, 51216616775464ULL },   // factor: 1873028449009563263153
  { 18715693, 70, 50878783552751ULL },   // factor: 1904463386373474042887
  { 18466867, 70, 52701548950784ULL },   // factor: 1946464990336235347457
  { 18375263, 70, 53119604432400ULL },   // factor: 1952173403802631442401
  { 18482987, 70, 53958405387052ULL },   // factor: 1994625010619224168649
  { 18600371, 70, 54507909079753ULL },   // factor: 2027734662635348776727
  { 18009463, 70, 57527467757396ULL },   // factor: 2072077604121032476697
  { 18132589, 70, 57378612456507ULL },   // factor: 2080845594128243613247
  { 18271417, 70, 58165339925252ULL },   // factor: 2125526361442056244169
  { 18189701, 70, 58488982304451ULL },   // factor: 2127794199824509318303
  { 18546571, 70, 59379422884208ULL },   // factor: 2202569364921976901537
  { 18684839, 70, 59880240850752ULL },   // factor: 2237705319155048297857
  { 18773009, 70, 59974022706052ULL },   // factor: 2251785736053837100937
  { 18586723, 70, 60820089404561ULL },   // factor: 2260892309195620487207
  { 18803767, 70, 61293890143133ULL },   // factor: 2305112057550139164023
  { 18286483, 70, 63606880620041ULL },   // factor: 2326292282282818411607
  { 18252761, 70, 63932409811200ULL },   // factor: 2333885992875777446401
  { 18613957, 71, 64295547456768ULL },   // factor: 2393589111303477821953
  { 18665033, 71, 66962982841600ULL },   // factor: 2499732569033795545601
  { 18575131, 71, 67828631739789ULL },   // factor: 2519851440234677174719
  { 18897311, 71, 66696623996800ULL },   // factor: 2520773692635185209601
  { 18187571, 71, 70067708168593ULL },   // factor: 2548722834247130315207
  { 18800447, 71, 68123390606388ULL },   // factor: 2561500389111390910873
  { 18526327, 71, 69369509656704ULL },   // factor: 2570324439459512092417
  { 18470069, 71, 69850051512619ULL },   // factor: 2580270542183254601423
  { 18253481, 71, 70759978251055ULL },   // factor: 2583231837132091344911
  { 18115627, 71, 73913122726593ULL },   // factor: 2677965123440363537623
  { 18000601, 71, 76523477361456ULL },   // factor: 2754937166232204470113
  { 18342803, 71, 75851259379656ULL },   // factor: 2782649416205864431537
  { 18648199, 71, 74943155591016ULL },   // factor: 2795109758298457960369
  { 18248653, 71, 78863710112795ULL },   // factor: 2878312960281973630271
  { 18129493, 71, 79597545974835ULL },   // factor: 2886126305135898617311
  { 18068147, 71, 81075653168664ULL },   // factor: 2929773639144873891217
  { 18881963, 71, 78187602482380ULL },   // factor: 2952670834262014623881
  { 18048133, 71, 82883990634312ULL },   // factor: 2991802573077634678993
  { 18608963, 71, 82224799663792ULL },   // factor: 3060236509251835535393
  { 18258059, 71, 83916507958992ULL },   // factor: 3064305106778491033057
  { 18791737, 71, 81888988307759ULL },   // factor: 3077672662950964374767
  { 18876787, 71, 81718144889528ULL },   // factor: 3085152030229517173073
  { 18107659, 71, 86848451523440ULL },   // factor: 3145244289728964053921
  { 18158447, 71, 86714902655605ULL },   // factor: 3149215927963925290871
  { 18874649, 71, 83477819568576ULL },   // factor: 3151229087284406859649
  { 18788911, 71, 85013472809160ULL },   // factor: 3194621148824454449521
  { 18666917, 71, 85722962060547ULL },   // factor: 3200366835556759647199
  { 18320831, 71, 90629407804321ULL },   // factor: 3320812128026092221503
  { 18426857, 71, 91717630784163ULL },   // factor: 3380135333677138931383
  { 18153929, 71, 94487136003999ULL },   // factor: 3430625516859883124143
  { 18284353, 71, 93859247378691ULL },   // factor: 3432311222772621843847
  { 18830507, 71, 92648436210313ULL },   // factor: 3489234053194704837383
  { 18036877, 71, 97699144332023ULL },   // factor: 3524374898643892024343
  { 18620761, 71, 95161937841188ULL },   // factor: 3543975401675235408137
  { 18488549, 71, 97285133871744ULL },   // factor: 3597321929118597318913
  { 18705787, 71, 96170160893060ULL },   // factor: 3597877090842620276441
  { 18453703, 71, 98054233588080ULL },   // factor: 3618927409054105320481
  { 18322357, 71, 99790643471607ULL },   // factor: 3656799589893005635399
  { 18319969, 71, 100261771659984ULL },   // factor: 3673585097391970840993
  { 18629521, 71, 99296782927200ULL },   // factor: 3699703005549427742401
  { 18357649, 71, 101643427811027ULL },   // factor: 3731868741823343991047
  { 18010829, 71, 103849883134564ULL },   // factor: 3740844973613232387113
  { 18898193, 71, 101527580801592ULL },   // factor: 3837375633623160646513
  { 18096671, 71, 106343219395005ULL },   // factor: 3848916508944449056711
  { 18507787, 71, 107037571556640ULL },   // factor: 3962057150735103111361
  { 18892817, 71, 104982834386712ULL },   // factor: 3966842956418914095409
  { 18855209, 71, 107596620550575ULL },   // factor: 4057513536349573390351
  { 18734041, 71, 111697000920020ULL },   // factor: 4185072389625384801641
  { 18103273, 71, 116230092261732ULL },   // factor: 4208290182058643697673
  { 18715087, 71, 114957652964009ULL },   // factor: 4302884953074472607567
  { 18834331, 71, 114287568820841ULL },   // factor: 4305059800713998184743
  { 18016637, 71, 119866591283760ULL },   // factor: 4319185727173735830241
  { 18094121, 71, 120696739806300ULL },   // factor: 4367802828721417524601
  { 18802517, 71, 118520838063364ULL },   // factor: 4456980145081297374377
  { 18349997, 71, 125036077655952ULL },   // factor: 4588823299756972464289
  { 18129121, 71, 127584578930255ULL },   // factor: 4625992538321286911711
  { 2398027, 62, 965360579780ULL },   // factor: 4629921470096188121
  { 2373583, 62, 984834546993ULL },   // factor: 4675173077110571839
  { 2346779, 62, 996396117576ULL },   // factor: 4676642968817775409
  { 2200657, 62, 1063387308152ULL },   // factor: 4680301446791711729
  { 2249557, 62, 1056812279643ULL },   // factor: 4754718922713736303
  { 2372371, 62, 1005217203764ULL },   // factor: 4769496285821608889
  { 2247523, 62, 1062803572292ULL },   // factor: 4777350946416865433
  { 2384047, 62, 1025702116164ULL },   // factor: 4890644105868871417
  { 2364487, 62, 1038095142237ULL },   // factor: 4909124937165074839
  { 2219999, 62, 1112998996672ULL },   // factor: 4941713319225686657
  { 2276513, 62, 1086342567703ULL },   // factor: 4946145955658519279
  { 2239001, 62, 1107392090284ULL },   // factor: 4958903995075932569
  { 2245739, 62, 1110843918789ULL },   // factor: 4989331022674580143
  { 2230721, 62, 1147630956675ULL },   // factor: 5120088950610025351
  { 2229683, 62, 1153249523392ULL },   // factor: 5142761714130489473
  { 2300689, 62, 1120924756199ULL },   // factor: 5157798512829442223
  { 2301023, 62, 1209840043596ULL },   // factor: 5567739533270797417
  { 2228113, 62, 1267862472312ULL },   // factor: 5649881713541014513
  { 2399011, 62, 1185204952821ULL },   // factor: 5686639438144120063
  { 2234261, 62, 1291405937260ULL },   // factor: 5770675841576929721
  { 2274521, 62, 1269735561160ULL },   // factor: 5776080396610408721
  { 2288687, 62, 1269567588408ULL },   // factor: 5811285670421480593
  { 2373403, 62, 1252917463248ULL },   // factor: 5947356132050385889
  { 2278189, 62, 1317645182219ULL },   // factor: 6003689520068642783
  { 2287409, 62, 1325030920171ULL },   // factor: 6061775304154853879
  { 2238947, 62, 1355942190484ULL },   // factor: 6071765399115160697
  { 2307047, 62, 1332009092629ULL },   // factor: 6146015162244913127
  { 2266337, 62, 1366036477924ULL },   // factor: 6191798026537688777
  { 2288471, 62, 1392828265804ULL },   // factor: 6374894188545491369
  { 2285359, 62, 1395169478580ULL },   // factor: 6376926248796220441
  { 2256827, 62, 1495183480540ULL },   // factor: 6748740897673293161
  { 2328971, 62, 1454807270848ULL },   // factor: 6776407888788274817
  { 2237629, 62, 1518884786072ULL },   // factor: 6797401289947006577
  { 2257579, 62, 1528808633820ULL },   // factor: 6902812533461443561
  { 2373821, 62, 1476773819779ULL },   // factor: 7011193411283211119
  { 2233723, 62, 1595920615092ULL },   // factor: 7129689168210295033
  { 2226911, 62, 1605328321624ULL },   // factor: 7149846596072046929
  { 2244769, 62, 1610151975575ULL },   // factor: 7228838480119034351
  { 2397529, 62, 1517591955275ULL },   // factor: 7276941445877030951
  { 2300297, 62, 1632638340024ULL },   // factor: 7511106151284374257
  { 2301269, 62, 1649067954559ULL },   // factor: 7589897925440070743
  { 2356021, 62, 1624607474240ULL },   // factor: 7655218652132798081
  { 2238989, 62, 1752883585204ULL },   // factor: 7849374131104637513
  { 2213347, 62, 1796694601005ULL },   // factor: 7953417210101227471
  { 2300317, 62, 1737208538055ULL },   // factor: 7992260665266126871
  { 2239009, 62, 1814596231467ULL },   // factor: 8125794587241392407
  { 2336629, 62, 1754726564379ULL },   // factor: 8200289954796676783
  { 2249197, 62, 1843260636204ULL },   // factor: 8291712586336256377
  { 2373221, 62, 1784918364220ULL },   // factor: 8472011490505105241
  { 2346217, 62, 1825693692299ULL },   // factor: 8566947155329365767
  { 2325317, 62, 1905134572528ULL },   // factor: 8860083617574182753
  { 2320421, 62, 1972500728511ULL },   // factor: 9154064225904446263
  { 2393177, 63, 1931718040032ULL },   // factor: 9245886367779323329
  { 2286377, 63, 2081357975847ULL },   // factor: 9517538009486272639
  { 2318293, 63, 2056962128187ULL },   // factor: 9537281806082049583
  { 2375773, 63, 2009626556795ULL },   // factor: 9548833027433055071
  { 2240431, 63, 2131800074156ULL },   // factor: 9552301943882802473
  { 2207321, 63, 2208638542908ULL },   // factor: 9750348474340458937
  { 2307973, 63, 2161126680603ULL },   // factor: 9975644056822695439
  { 2339287, 63, 2144822033969ULL },   // factor: 10034708602754480207
  { 2281529, 63, 2362572050040ULL },   // factor: 10780553293511422321
  { 2314667, 63, 2356986828393ULL },   // factor: 10911279262231880263
  { 2380487, 63, 2312632318489ULL },   // factor: 11010382339885848287
  { 2351159, 63, 2368050484036ULL },   // factor: 11135326415991195449
  { 2310311, 63, 2513312291725ULL },   // factor: 11613066068014952951
  { 2331187, 63, 2492900370660ULL },   // factor: 11622833872755546841
  { 2368273, 63, 2470571195711ULL },   // factor: 11701974114760154207
  { 2270179, 63, 2582305474952ULL },   // factor: 11724591321642112817
  { 2342419, 63, 2514128624100ULL },   // factor: 11778285315071395801
  { 2278361, 63, 2644383768724ULL },   // factor: 12049721695387562729
  { 2203141, 63, 2836614978099ULL },   // factor: 12498925518928017919
  { 2315843, 63, 2701400503177ULL },   // factor: 12512038890957866423
  { 2231093, 63, 2807715007836ULL },   // factor: 12528546599955689497
  { 2288747, 63, 2748720399012ULL },   // factor: 12582251134155035929
  { 2333887, 63, 2735095563608ULL },   // factor: 12766807959324768593
  { 2298977, 63, 2785442928039ULL },   // factor: 12807338452748632207
  { 2373823, 63, 2705029338897ULL },   // factor: 12842521720696986463
  { 2245871, 63, 3076989873676ULL },   // factor: 13821044649165183593
  { 2362271, 63, 2934220539580ULL },   // factor: 13862848176508372361
  { 2265581, 63, 3099340305015ULL },   // factor: 14043613015152377431
  { 2319943, 63, 3032829919457ULL },   // factor: 14071985083669661903
  { 2277617, 63, 3097188305944ULL },   // factor: 14108417475638510897
  { 2203631, 63, 3210913801080ULL },   // factor: 14151338380775442961
  { 2358463, 63, 3001219617033ULL },   // factor: 14156530843293000559
  { 2381179, 63, 3069628677524ULL },   // factor: 14618670689435841593
  { 2385619, 63, 3128130989669ULL },   // factor: 14925057446886340223
  { 2234329, 63, 3488304904211ULL },   // factor: 15588041616641718839
  { 2344117, 63, 3334880538708ULL },   // factor: 15634700327509161673
  { 2250397, 63, 3500266306884ULL },   // factor: 15753977592425665897
  { 2328341, 63, 3410242912419ULL },   // factor: 15880416785889133759
  { 2398559, 63, 3330773369941ULL },   // factor: 15978112886864630039
  { 2322443, 63, 3451995245221ULL },   // factor: 16034124386593589807
  { 2263931, 63, 3627883110984ULL },   // factor: 16426554078666236209
  { 2215669, 63, 3897858448832ULL },   // factor: 17272728262930297217
  { 2254451, 63, 3846185433045ULL },   // factor: 17342073191427466591
  { 2344141, 63, 3702877505828ULL },   // factor: 17360133958778307497
  { 2311531, 63, 3776560958505ULL },   // factor: 17459275457948042311
  { 2247851, 63, 3949755193084ULL },   // factor: 17756922321058124969
  { 2291911, 64, 4107050240408ULL },   // factor: 18825987247087479377
  { 2248691, 64, 4208374259440ULL },   // factor: 18926666643668786081
  { 2364623, 64, 4158680778736ULL },   // factor: 19667424438114113057
  { 2278963, 64, 4335815377908ULL },   // factor: 19762325642166698809
  { 2268631, 64, 4451052104721ULL },   // factor: 20195589574770613903
  { 2372317, 64, 4265833164039ULL },   // factor: 20239817068427016727
  { 2270309, 64, 4498144820260ULL },   // factor: 20424357337479320681
  { 2329807, 64, 4439031705312ULL },   // factor: 20684174280515669569
  { 2324521, 64, 4467559605711ULL },   // factor: 20769872244453878863
  { 2331691, 64, 4491976622525ULL },   // factor: 20947802925903879551
  { 2340581, 64, 4590240443671ULL },   // factor: 21487659135775825703
  { 2359993, 64, 4569512016483ULL },   // factor: 21568032744631529239
  { 2258279, 64, 4855553179116ULL },   // factor: 21930387555561802729
  { 2308573, 64, 4758045025868ULL },   // factor: 21968588559006332729
  { 2259391, 64, 4987162312529ULL },   // factor: 22535899288934419679
  { 2395157, 64, 4731333104080ULL },   // factor: 22664571207137881121
  { 2274739, 64, 5288579995625ULL },   // factor: 24060278341336033751
  { 2215013, 64, 5508175454236ULL },   // factor: 24401360474827290137
  { 2334901, 64, 5227188194931ULL },   // factor: 24409933887065173663
  { 2254097, 64, 5696029336480ULL },   // factor: 25678805278543117121
  { 2207833, 64, 5828990881340ULL },   // factor: 25738876849043072441
  { 2309113, 64, 5606634198507ULL },   // factor: 25892703828034188583
  { 2364001, 64, 5502438339324ULL },   // factor: 26015539473200550649
  { 2364647, 64, 5657033986080ULL },   // factor: 26753776888164227521
  { 2269807, 64, 5938160578653ULL },   // factor: 26956956897101259943
  { 2394499, 64, 5663507204540ULL },   // factor: 27122524675527650921
  { 2386469, 64, 5712491021256ULL },   // factor: 27265365470011570129
  { 2368159, 64, 5841310157805ULL },   // factor: 27666302443994661991
  { 2372563, 64, 5905168904492ULL },   // factor: 28020770503096505993
  { 2348693, 64, 6043560844176ULL },   // factor: 28388938099580523937
  { 2370241, 64, 6376054651179ULL },   // factor: 30225572304930328279
  { 2316521, 64, 6644935584204ULL },   // factor: 30786265648911668569
  { 2245619, 64, 6954995546616ULL },   // factor: 31236540288792550609
  { 2203169, 64, 7270091622127ULL },   // factor: 32034480978059840927
  { 2224741, 64, 7281311711360ULL },   // factor: 32398065396085515521
  { 2262269, 64, 7195794656784ULL },   // factor: 32557646364816165793
  { 2332787, 64, 7150550580652ULL },   // factor: 33361422874774874249
  { 2336333, 64, 7225922116203ULL },   // factor: 33764320591029807199
  { 2231731, 64, 8156032235648ULL },   // factor: 36404139954589893377
  { 2312711, 65, 8117238480256ULL },   // factor: 37545653445822668033
  { 2272183, 65, 8420395509060ULL },   // factor: 38265359057924955961
  { 2241199, 65, 8739788640204ULL },   // factor: 39175211121273129193
  { 2336251, 65, 8845552073093ULL },   // factor: 41330859752631188687
  { 2206627, 65, 9444956281668ULL },   // factor: 41682991089896427673
  { 2331929, 65, 9315062899384ULL },   // factor: 43444130623795263473
  { 2383411, 65, 9117532755701ULL },   // factor: 43461655725596152223
  { 2383219, 65, 9316571974512ULL },   // factor: 44406862689049028257
  { 2384051, 65, 9413121727441ULL },   // factor: 44882724534854886983
  { 2339039, 65, 9786161109576ULL },   // factor: 45780424991163074929
  { 2215091, 65, 10827131081109ULL },   // factor: 47966161227169631839
  { 2330491, 65, 10869290532269ULL },   // factor: 50661567523676228159
  { 2253047, 65, 11307149250720ULL },   // factor: 50951077395773887681
  { 2217277, 65, 11570307550443ULL },   // factor: 51309153629047207423
  { 2233877, 65, 11621509175467ULL },   // factor: 51922044104729391119
  { 2224681, 65, 11725325871896ULL },   // factor: 52170219372030930353
  { 2281687, 65, 11765898840264ULL },   // factor: 53692196854290890737
  { 2301217, 65, 11911792079760ULL },   // factor: 54823236868818135841
  { 2331751, 65, 12389365560221ULL },   // factor: 57777831068821753943
  { 2239793, 65, 14004042576631ULL },   // factor: 62732313069680154767
  { 2290493, 65, 13697160077955ULL },   // factor: 62746498556870763631
  { 2304727, 65, 13716585288992ULL },   // factor: 63225968926685330369
  { 2328539, 65, 14256072489277ULL },   // factor: 66391641556217152607
  { 2201371, 65, 15266188834976ULL },   // factor: 67213090763679904193
  { 2321603, 65, 15007089197016ULL },   // factor: 69681006602119873297
  { 2331871, 65, 15072257948781ULL },   // factor: 70293122430563798503
  { 2332933, 65, 15623668774911ULL },   // factor: 72897944932118887927
  { 2399821, 65, 15211921258488ULL },   // factor: 73011776172931861297
  { 2336557, 66, 16009748067999ULL },   // factor: 74815377833039078887
  { 2281151, 66, 16716578178564ULL },   // factor: 76266078057218894329
  { 2244331, 66, 17405085155396ULL },   // factor: 78125544343790120153
  { 2350429, 66, 16758701747516ULL },   // factor: 78780277179424568729
  { 2210477, 66, 18448096155843ULL },   // factor: 81558184492558734223
  { 2205547, 66, 18858579982164ULL },   // factor: 83186969007843727417
  { 2382217, 66, 17463103781364ULL },   // factor: 83201805401459207977
  { 2381909, 66, 17697307272096ULL },   // factor: 84306750934341822529
  { 2323907, 66, 18538352855949ULL },   // factor: 86162815940819745487
  { 2354467, 66, 18701192962884ULL },   // factor: 88062683383485205657
  { 2215463, 66, 19909284637908ULL },   // factor: 88216566943507142809
  { 2301841, 66, 19300930797444ULL },   // factor: 88855347695438588809
  { 2298707, 66, 19777400361477ULL },   // factor: 90924897305459420479
  { 2309927, 66, 21014294124880ULL },   // factor: 97082970770003367521
  { 2323787, 66, 20927395151352ULL },   // factor: 97261617593149620049
  { 2380387, 66, 20749418842337ULL },   // factor: 98783293739708088839
  { 2314079, 66, 21371872540465ULL },   // factor: 98912402873133413471
  { 2260889, 66, 21899953710327ULL },   // factor: 99026728888375001407
  { 2232059, 66, 22258393350076ULL },   // factor: 99364094405154572969
  { 2250779, 66, 22344592777341ULL },   // factor: 100585480373581597279
  { 2299571, 66, 22537663485688ULL },   // factor: 103653914718894079697
  { 2205067, 66, 23588118034080ULL },   // factor: 104026761338109366721
  { 2364767, 66, 22432565446824ULL },   // factor: 106095580987979300017
  { 2315683, 66, 23009140680933ULL },   // factor: 106563751838889944479
  { 2214493, 66, 25724597616495ULL },   // factor: 113933882699089724071
  { 2275813, 66, 25467352854336ULL },   // factor: 115917865402969950337
  { 2324533, 66, 25449438962388ULL },   // factor: 118316121399113329609
  { 2283887, 66, 26078044475869ULL },   // factor: 119118613527718045607
  { 2222509, 66, 26853895326504ULL },   // factor: 119366048096426157073
  { 2335693, 66, 25939484876412ULL },   // factor: 121173346498882747033
  { 2239201, 66, 27337628017875ULL },   // factor: 122428887990507435751
  { 2335547, 66, 26408933420020ULL },   // factor: 123358610444654901881
  { 2272993, 66, 27236248583487ULL },   // factor: 123815604753051733183
  { 2272631, 66, 27523518096721ULL },   // factor: 125101600911338285903
  { 2230079, 66, 28999260400992ULL },   // factor: 129341283271567676737
  { 2211019, 66, 29284902318540ULL },   // factor: 129498950878871984521
  { 2241607, 66, 28963896390464ULL },   // factor: 129851345792277671297
  { 2258987, 66, 28849877284780ULL },   // factor: 130342995475826635721
  { 2254079, 66, 29283415715929ULL },   // factor: 132014264827091048783
  { 2220203, 66, 31163342083300ULL },   // factor: 138377891166737819801
  { 2274289, 66, 30449676963780ULL },   // factor: 138502730744556504841
  { 2236603, 67, 33035134646132ULL },   // factor: 147772962509885539193
  { 2309497, 67, 32310311658300ULL },   // factor: 149241135687817750201
  { 2235553, 67, 35072730198156ULL },   // factor: 156813894425356480537
  { 2289901, 67, 36762501819659ULL },   // factor: 168364979358677927519
  { 2340827, 67, 36664115877417ULL },   // factor: 171648704753972807719
  { 2353723, 67, 36560066208576ULL },   // factor: 172104537433296256897
  { 2365079, 67, 37109045447452ULL },   // factor: 175531648195628657417
  { 2212487, 67, 40283236117089ULL },   // factor: 178252272453979780687
  { 2320649, 67, 40039131180091ULL },   // factor: 185833539467893998119
  { 2262467, 67, 41305615081245ULL },   // factor: 186905182072038262831
  { 2258903, 67, 41391748434001ULL },   // factor: 186999889425620321807
  { 2206601, 67, 42925340457424ULL },   // factor: 189438198357384511649
  { 2333399, 67, 40933042678429ULL },   // factor: 191026241705607100343
  { 2253161, 67, 42903471160975ULL },   // factor: 193336855969067183951
  { 2283571, 67, 42572210660573ULL },   // factor: 194433331340750692367
  { 2227369, 67, 45535202888555ULL },   // factor: 202847398645355723591
  { 2338871, 67, 44382512626713ULL },   // factor: 207609943379505722047
  { 2374213, 67, 44847764066843ULL },   // factor: 212956288936863039119
  { 2387269, 67, 45044595042939ULL },   // factor: 215067130727123887183
  { 2275349, 67, 48054619045075ULL },   // factor: 218682058779184712351
  { 2350979, 67, 46681690520452ULL },   // factor: 219495348196163445017
  { 2231857, 67, 49512632454087ULL },   // factor: 221010230662162499119
  { 2223161, 67, 50898452524108ULL },   // factor: 226310909223896930777
  { 2262971, 67, 50615152930528ULL },   // factor: 229081246484699757377
  { 2299901, 67, 49885577206335ULL },   // factor: 229463777804854145671
  { 2314643, 67, 50266941541245ULL },   // factor: 232700048739703901071
  { 2289433, 67, 52751957812256ULL },   // factor: 241544146059973381697
  { 2376851, 67, 51394646536441ULL },   // factor: 244314834029572654583
  { 2350993, 67, 52814222521775ULL },   // factor: 248331734898270745151
  { 2261099, 67, 55566324168952ULL },   // factor: 251281920024186396497
  { 2332783, 67, 54581947612821ULL },   // factor: 254655678996158821687
  { 2380043, 67, 54044839391088ULL },   // factor: 257258083357766513569
  { 2354927, 67, 56582114548828ULL },   // factor: 266493498536255751113
  { 2223101, 67, 60108647696295ULL },   // factor: 267255189604562221591
  { 2308451, 67, 63472233879136ULL },   // factor: 293045083541050756673
  { 2224987, 68, 66936533762148ULL },   // factor: 297865834891680784153
  { 2368361, 68, 67804178547420ULL },   // factor: 321169544217492357241
  { 2390797, 68, 67196787691700ULL },   // factor: 321307756845906569801
  { 2245147, 68, 71952781260909ULL },   // factor: 323089141979172117247
  { 2361043, 68, 71028102950321ULL },   // factor: 335400810548269489607
  { 2215561, 68, 75907207272396ULL },   // factor: 336354096103273908313
  { 2246999, 68, 81412276814364ULL },   // factor: 365866609179198187273
  { 2208683, 68, 84762515719008ULL },   // factor: 374427055011611492929
  { 2248927, 68, 84087458313312ULL },   // factor: 378213110724363632449
  { 2336149, 68, 86356962928484ULL },   // factor: 403485465176829936233
  { 2258203, 68, 93468297797460ULL },   // factor: 422140780982235128761
  { 2329549, 68, 96372534475419ULL },   // factor: 449009082629355712063
  { 2391881, 68, 101839463053840ULL },   // factor: 487175753457363746081
  { 2303219, 68, 107105422458609ULL },   // factor: 493374488019389924743
  { 2398171, 68, 103284797603648ULL },   // factor: 495389212707876255617
  { 2262521, 68, 109940345819811ULL },   // factor: 497484682329169207063
  { 2335667, 68, 108327602614557ULL },   // factor: 506034413231869009039
  { 2251687, 68, 120044558716005ULL },   // factor: 540605544563130300871
  { 2349679, 68, 119367690445464ULL },   // factor: 560951511036414812113
  { 2305753, 68, 127884315655272ULL },   // factor: 589739288950180759633
  { 2350291, 69, 126211974716733ULL },   // factor: 593269736537930238607
  { 2210651, 69, 140171775863941ULL },   // factor: 619741752970794071183
  { 2246591, 69, 142067833586901ULL },   // factor: 638336632651659008983
  { 2335871, 69, 155371371825664ULL },   // factor: 725854963355571186689
  { 2352569, 69, 168344608103091ULL },   // factor: 792084612680961381559
  { 2347549, 69, 173862098583759ULL },   // factor: 816299591336409713383
  { 2360291, 69, 173969260794684ULL },   // factor: 821236161060690986089
  { 2248759, 69, 183572151055640ULL },   // factor: 825619053671459901521
  { 2326963, 69, 179529125325873ULL },   // factor: 835515264111338827399
  { 2202703, 69, 196449538378637ULL },   // factor: 865439975070477711623
  { 2375299, 69, 192815676271341ULL },   // factor: 915989766063280011919
  { 2286199, 69, 203999826953081ULL },   // factor: 932768400760613658239
  { 2334091, 69, 222829690861785ULL },   // factor: 1040209551946549224871
  { 2333321, 69, 223140055713760ULL },   // factor: 1041314755876172393921
  { 2387839, 69, 223697072949141ULL },   // factor: 1068305189947607792599
  { 2277329, 69, 235152482864920ULL },   // factor: 1071039137300570797361
  { 2308699, 69, 232945962137685ULL },   // factor: 1075604219682622443631
  { 2356339, 69, 229638718982849ULL },   // factor: 1082213338898654859623
  { 2269769, 69, 239050791764499ULL },   // factor: 1085180153145030261463
  { 2350259, 69, 239490323124660ULL },   // factor: 1125728574673280573881
  { 2394823, 70, 257805977295420ULL },   // factor: 1234799367929099221321
  { 2304593, 70, 269356000999632ULL },   // factor: 1241511908823489819553
  { 2273497, 70, 278580993153855ULL },   // factor: 1266706104384619761871
  { 2319413, 70, 273919453272048ULL },   // factor: 1270664681744161335649
  { 2342611, 70, 276430541127720ULL },   // factor: 1295138452763498553841
  { 2338381, 70, 279972259658975ULL },   // factor: 1309363625027227238951
  { 2252311, 70, 312320486031209ULL },   // factor: 1406885732426876747999
  { 2388563, 70, 301764160825873ULL },   // factor: 1441565418549459380999
  { 2398247, 70, 338073203439328ULL },   // factor: 1621566091857516116033
  { 2320741, 70, 350058295635300ULL },   // factor: 1624789278141923514601
  { 2306119, 70, 377877107064525ULL },   // factor: 1742859152533070656951
  { 2258617, 70, 418387303249364ULL },   // factor: 1889953351406337539177
  { 2345659, 70, 410230180677056ULL },   // factor: 1924520230753524999809
  { 2270141, 70, 430049204169891ULL },   // factor: 1952544660806881049263
  { 2218609, 70, 452804385311480ULL },   // factor: 2009191768983034662641
  { 2284937, 70, 441862550096943ULL },   // factor: 2019256179261717295183
  { 2371627, 70, 427188817619517ULL },   // factor: 2026265067929044488319
  { 2295281, 70, 471373952581531ULL },   // factor: 2163871354510578110423
  { 2292967, 70, 477787545774693ULL },   // factor: 2191102150944720968263
  { 2369863, 70, 463586188892972ULL },   // factor: 2197271512736930605673
  { 2225057, 70, 498348476875120ULL },   // factor: 2217707533820647763681
  { 2239883, 70, 495447876036628ULL },   // factor: 2219490549841100869049
  { 2316697, 70, 498952072454987ULL },   // factor: 2311841538800502035879
  { 2272657, 70, 518430493020012ULL },   // factor: 2356429377950762823769
  { 2272079, 71, 551339728187725ULL },   // factor: 2505374836562076060551
  { 2215789, 71, 606623064621575ULL },   // factor: 2688297427469550095351
  { 2201393, 71, 634641204112696ULL },   // factor: 2794189408490520371057
  { 2200207, 71, 708888164046713ULL },   // factor: 3119401401505452539183
  { 2215159, 71, 705959051168529ULL },   // factor: 3127623091654855062223
  { 2211779, 71, 712233599718681ULL },   // factor: 3150606637904369086999
  { 2244883, 71, 702021874951680ULL },   // factor: 3151913945414304506881
  { 2383613, 71, 715974282203908ULL },   // factor: 3413211213453807519209
  { 2372053, 71, 766166714944560ULL },   // factor: 3634776109368776763361
  { 2301883, 71, 858472520358861ULL },   // factor: 3952206601162432070527
  { 2328047, 71, 871024953422097ULL },   // factor: 4055574059478905309119
  { 2318311, 71, 883409485258104ULL },   // factor: 4096035854356400684689
  { 2221741, 71, 934729858784451ULL },   // factor: 4153455302371249898383
  { 2279993, 71, 924455566814080ULL },   // factor: 4215504442294269402881
  { 2388277, 71, 883523615898020ULL },   // factor: 4220198261612151023081
  { 2373169, 71, 926152780682724ULL },   // factor: 4395834136760078864713
  { 2359397, 71, 941946999790107ULL },   // factor: 4444853850927558170959
  { 298637851, 62, 7735426164ULL },   // factor: 4620182092372267129
  { 297786889, 62, 7769536100ULL },   // factor: 4627331968384385801
  { 299975161, 62, 7713572384ULL },   // factor: 4627760235551107649
  { 298348651, 62, 7764356988ULL },   // factor: 4632970866504446377
  { 297128729, 62, 7806232072ULL },   // factor: 4638911627664792977
  { 298478029, 62, 7771106580ULL },   // factor: 4639009150294661641
  { 298452953, 62, 7774811580ULL },   // factor: 4640830950139191481
  { 298993423, 62, 7763649345ULL },   // factor: 4642560185266515871
  { 299892157, 62, 7751790639ULL },   // factor: 4649402430684236647
  { 298414601, 62, 7793984944ULL },   // factor: 4651677814527534689
  { 297192953, 62, 7834172592ULL },   // factor: 4656521773856288353
  { 298715749, 62, 7803084120ULL },   // factor: 4661808234831611761
  { 297791657, 62, 7831143952ULL },   // factor: 4664098667343216929
  { 297729889, 62, 7837668896ULL },   // factor: 4667016580849665089
  { 299191643, 62, 7800021168ULL },   // factor: 4667402297377398049
  { 298002767, 62, 7835535640ULL },   // factor: 4670022603294231761
  { 298955191, 62, 7814163156ULL },   // factor: 4672169277614285593
  { 298138261, 62, 7855879119ULL },   // factor: 4684276278329744119
  { 297037901, 62, 7888090839ULL },   // factor: 4686123891427777879
  { 297376213, 62, 7878874995ULL },   // factor: 4685980017426987871
  { 299621177, 62, 7825118319ULL },   // factor: 4689142321806082927
  { 299927897, 62, 7819907364ULL },   // factor: 4690816740838667017
  { 299983141, 62, 7825907004ULL },   // factor: 4695280328467639129
  { 299436091, 62, 7841134188ULL },   // factor: 4695837140522358217
  { 298249907, 62, 7875622708ULL },   // factor: 4697807480456176313
  { 297866293, 62, 7894115027ULL },   // factor: 4702781559216169823
  { 298545413, 62, 7882423255ULL },   // factor: 4706522612209558631
  { 299917589, 62, 7855749435ULL },   // factor: 4712154860666624431
  { 298289809, 62, 7899421367ULL },   // factor: 4712633781545897807
  { 298777177, 62, 7889610212ULL },   // factor: 4714470933543463049
  { 297743071, 62, 7918800924ULL },   // factor: 4715536211498795209
  { 298100281, 62, 7912879911ULL },   // factor: 4717663449976709983
  { 298356439, 62, 7917166040ULL },   // factor: 4724274933332263121
  { 299103641, 62, 7897560436ULL },   // factor: 4724378162850294953
  { 299010799, 62, 7900134749ULL },   // factor: 4724451207012308903
  { 299402947, 62, 7891709072ULL },   // factor: 4725601906046870369
  { 299804467, 62, 7884542444ULL },   // factor: 4727642089924594697
  { 298370659, 62, 7926487421ULL },   // factor: 4730062550717960879
  { 299958143, 62, 7887685617ULL },   // factor: 4731951060486258463
  { 299525053, 62, 7907639763ULL },   // factor: 4737072438234964879
  { 298648457, 62, 7939968747ULL },   // factor: 4742518829839546759
  { 298310807, 62, 7960945693ULL },   // factor: 4749672268324008503
  { 297385639, 62, 7987886316ULL },   // factor: 4750965352686031849
  { 299653531, 62, 7927309364ULL },   // factor: 4750892484503928569
  { 298421069, 62, 7978708719ULL },   // factor: 4762029570327201223
  { 299722559, 62, 7957548624ULL },   // factor: 4770113673904417633
  { 299101877, 62, 7977846928ULL },   // factor: 4772377981166967713
  { 297269827, 62, 8030219205ULL },   // factor: 4774283747684855071
  { 298671829, 62, 7993821912ULL },   // factor: 4775058822314634097
  { 297585763, 62, 8025104685ULL },   // factor: 4776313801681199311
  { 298471051, 62, 8002587833ULL },   // factor: 4777081602470644967
  { 297298747, 62, 8034789008ULL },   // factor: 4777465408975545953
  { 299985823, 62, 7966822596ULL },   // factor: 4779867666312113017
  { 297383129, 62, 8039968279ULL },   // factor: 4781901847739529983
  { 298322197, 62, 8014935167ULL },   // factor: 4782066135664003799
  { 297456109, 62, 8043472359ULL },   // factor: 4785159981514382263
  { 299442833, 62, 7997243640ULL },   // factor: 4789434583505664241
  { 299887433, 62, 7988020231ULL },   // factor: 4791013763653314047
  { 299291099, 62, 8015416789ULL },   // factor: 4797885799445722223
  { 297841493, 62, 8057375148ULL },   // factor: 4799641287482831929
  { 299935667, 62, 8008481289ULL },   // factor: 4804058354146469527
  { 297726683, 62, 8078721640ULL },   // factor: 4810501993515040241
  { 299780399, 62, 8025337200ULL },   // factor: 4811677575851085601
  { 297612533, 62, 8085348475ULL },   // factor: 4812602079664874351
  { 297250073, 62, 8101949287ULL },   // factor: 4816610034006095903
  { 297427967, 62, 8097194548ULL },   // factor: 4816664225630247833
  { 299520157, 62, 8044343960ULL },   // factor: 4818886331722403441
  { 298718113, 62, 8066829287ULL },   // factor: 4819416045011550863
  { 297395281, 62, 8106618683ULL },   // factor: 4821740282381269847
  { 297695617, 62, 8106532863ULL },   // factor: 4826558604763122943
  { 298438351, 62, 8090253204ULL },   // factor: 4828883650748453209
  { 299264509, 62, 8069182055ULL },   // factor: 4829639611442371991
  { 297392929, 62, 8123108547ULL },   // factor: 4831510086754528327
  { 297997801, 62, 8108290376ULL },   // factor: 4832505403834926353
  { 298635629, 62, 8102804895ULL },   // factor: 4839572472965207911
  { 297104917, 62, 8147004572ULL },   // factor: 4841030234325361049
  { 297512861, 62, 8160457159ULL },   // factor: 4855681912884043799
  { 298044067, 62, 8149099820ULL },   // factor: 4857581705483535881
  { 299774539, 62, 8102877776ULL },   // factor: 4858072899747490529
  { 299279077, 62, 8122395648ULL },   // factor: 4861726145124513793
  { 299735209, 62, 8117652212ULL },   // factor: 4866292364706264617
  { 298684189, 62, 8151418535ULL },   // factor: 4869399668652086231
  { 299181499, 62, 8137435961ULL },   // factor: 4869140577656971079
  { 297582167, 62, 8186384740ULL },   // factor: 4872244221649863161
  { 299249051, 62, 8146207461ULL },   // factor: 4875489703906739023
  { 299020219, 62, 8153416052ULL },   // factor: 4876072506934310777
  { 299687533, 62, 8136158343ULL },   // factor: 4876610443822075639
  { 297190603, 62, 8209497725ULL },   // factor: 4879571158439756351
  { 298923091, 62, 8162721941ULL },   // factor: 4880052147154479263
  { 297261791, 62, 8211616813ULL },   // factor: 4881999841676184167
  { 297434747, 62, 8211567909ULL },   // factor: 4884811246973468047
  { 298289611, 62, 8195920449ULL },   // factor: 4889515845038310679
  { 298923221, 62, 8189487676ULL },   // factor: 4896056068899448793
  { 298932419, 62, 8189147161ULL },   // factor: 4896003140769424919
  { 299258669, 62, 8187697864ULL },   // factor: 4900479129909566033
  { 299313829, 62, 8191298364ULL },   // factor: 4903537755620551513
  { 299524307, 62, 8185835053ULL },   // factor: 4903713142932266543
  { 297472829, 62, 8252101539ULL },   // factor: 4909551980003167663
  { 298793081, 62, 8218476528ULL },   // factor: 4911247845854605537
  { 299128859, 62, 8209154665ULL },   // factor: 4911190136591954471
  { 298205333, 62, 8237897860ULL },   // factor: 4913170149122574761
  { 297556981, 62, 8256990503ULL },   // factor: 4913850332436702887
  { 298204033, 62, 8243330100ULL },   // factor: 4916388562340586601
  { 299485723, 62, 8207749836ULL },   // factor: 4916207787675182857
  { 297779539, 62, 8260517777ULL },   // factor: 4919626351072729607
  { 297513313, 62, 8304224243ULL },   // factor: 4941234532859694119
  { 297638501, 62, 8316849655ULL },   // factor: 4950829328713134311
  { 297180503, 62, 8332877800ULL },   // factor: 4952737632083066801
  { 297983291, 62, 8313792364ULL },   // factor: 4954742418630779849
  { 299850823, 62, 8264037888ULL },   // factor: 4955957124039963649
  { 299809333, 62, 8265672975ULL },   // factor: 4956251802861751351
  { 297026831, 62, 8352598596ULL },   // factor: 4961891783169858553
  { 298236223, 62, 8324569137ULL },   // factor: 4965376115042499103
  { 298006967, 62, 8339604273ULL },   // factor: 4970520350753939983
  { 298372007, 62, 8332170405ULL },   // factor: 4972172812811705671
  { 298853341, 62, 8321927768ULL },   // factor: 4974071834054945777
  { 298895629, 62, 8333238272ULL },   // factor: 4981536989832626177
  { 299434117, 62, 8319693063ULL },   // factor: 4982399892060860743
  { 297293729, 62, 8383722936ULL },   // factor: 4984856509092536689
  { 297975451, 62, 8365628993ULL },   // factor: 4985504144175701687
  { 299561173, 62, 8326704383ULL },   // factor: 4988714664391442519
  { 299700019, 62, 8323079484ULL },   // factor: 4988854158986620393
  { 298449601, 62, 8370423240ULL },   // factor: 4996298952358254481
  { 299408827, 62, 8346372345ULL },   // factor: 4997955107043378631
  { 298905199, 62, 8364813752ULL },   // factor: 5000572638278993297
  { 297749983, 62, 8401079477ULL },   // factor: 5002842542916797783
  { 298434527, 62, 8395147593ULL },   // factor: 5010803802024287023
  { 299045273, 62, 8379453651ULL },   // factor: 5011672009308283447
  { 299688391, 62, 8361972420ULL },   // factor: 5011972120272352441
  { 299909437, 62, 8356071723ULL },   // factor: 5012129531953099903
  { 298702303, 62, 8389981136ULL },   // factor: 5012213374899512417
  { 299185967, 62, 8383152244ULL },   // factor: 5016243021258719897
  { 299314319, 62, 8380370361ULL },   // factor: 5016729695140998319
  { 299923717, 62, 8364399819ULL },   // factor: 5017363768377214447
  { 299068739, 62, 8391156624ULL },   // factor: 5019065260582354273
  { 297793477, 62, 8432616284ULL },   // factor: 5022356246838358937
  { 297259847, 62, 8453009728ULL },   // factor: 5025480756869583233
  { 299241301, 62, 8398888904ULL },   // factor: 5026588885174848209
  { 298632221, 62, 8421760000ULL },   // factor: 5030017787057920001
  { 297294401, 62, 8464038895ULL },   // factor: 5032622746659453791
  { 297908407, 62, 8450784033ULL },   // factor: 5035119218344130863
  { 299536067, 62, 8405278557ULL },   // factor: 5035368162006430639
  { 298758809, 62, 8433804787ULL },   // factor: 5039346947005237367
  { 297941731, 62, 8460952964ULL },   // factor: 5041741944007481369
  { 299435011, 62, 8422249604ULL },   // factor: 5043832805636971289
  { 299710441, 62, 8418645539ULL },   // factor: 5046311934232745399
  { 297583991, 62, 8486994561ULL },   // factor: 5051187426115345903
  { 297895579, 62, 8485489964ULL },   // factor: 5055579891848938313
  { 299410283, 62, 8452669608ULL },   // factor: 5061632398873558129
  { 299507729, 62, 8456581075ULL },   // factor: 5065622785755257351
  { 299662981, 62, 8453999519ULL },   // factor: 5066701394472212279
  { 297263881, 62, 8529119784ULL },   // factor: 5070798497011443409
  { 298131761, 62, 8504499556ULL },   // factor: 5070922858107996233
  { 298950871, 62, 8482268036ULL },   // factor: 5071562834835318713
  { 299504209, 62, 8467274247ULL },   // factor: 5071968551467611247
  { 299633717, 62, 8469210468ULL },   // factor: 5075322025164299113
  { 297507863, 62, 8530278280ULL },   // factor: 5075649723756231281
  { 298788739, 62, 8501295540ULL },   // factor: 5080182748525848121
  { 298913429, 62, 8501039764ULL },   // factor: 5082149891845181513
  { 299348551, 62, 8489025369ULL },   // factor: 5082354887224780639
  { 299112587, 62, 8498320429ULL },   // factor: 5083909217346279647
  { 299336197, 62, 8493748679ULL },   // factor: 5084972855691267527
  { 299285813, 62, 8497205352ULL },   // factor: 5086186024002542353
  { 299215949, 62, 8502490392ULL },   // factor: 5088161463011324017
  { 297761423, 62, 8546343901ULL },   // factor: 5089543042818262247
  { 297132481, 62, 8565720711ULL },   // factor: 5090307692825027983
  { 299902051, 62, 8489043921ULL },   // factor: 5091763365873963943
  { 297902291, 62, 8557589209ULL },   // factor: 5098650861595955639
  { 297685681, 62, 8566238120ULL },   // factor: 5100092856720719441
  { 298062847, 62, 8561334440ULL },   // factor: 5103631434611101361
  { 297080977, 62, 8608961399ULL },   // factor: 5115117326740413647
  { 297880711, 62, 8591198864ULL },   // factor: 5118304851901424609
  { 297002621, 62, 8628323131ULL },   // factor: 5125269169483852703
  { 299005073, 62, 8574244471ULL },   // factor: 5127485187942402767
  { 298018213, 62, 8604368931ULL },   // factor: 5128517305618680607
  { 298805257, 62, 8584480680ULL },   // factor: 5130175911597869521
  { 297662653, 62, 8621568356ULL },   // factor: 5132637819735616937
  { 298035251, 62, 8610679405ULL },   // factor: 5132571995499411311
  { 299192081, 62, 8579402695ULL },   // factor: 5133778692108116591
  { 299066489, 62, 8594151472ULL },   // factor: 5140445413330443617
  { 299627879, 62, 8583734149ULL },   // factor: 5143852113929479943
  { 299327011, 62, 8598492105ULL },   // factor: 5147521881793496311
  { 298451497, 62, 8634687503ULL },   // factor: 5154070822795083983
  { 298885949, 62, 8629100196ULL },   // factor: 5158233602195092009
  { 297768377, 62, 8668107792ULL },   // factor: 5162176777769787169
  { 298449787, 62, 8648541708ULL },   // factor: 5162310861226432393
  { 299498561, 62, 8618700264ULL },   // factor: 5162576653516640209
  { 299786231, 62, 8610225441ULL },   // factor: 5162454066035405743
  { 297783931, 62, 8677179561ULL },   // factor: 5167849279334868583
  { 297160021, 62, 8704352399ULL },   // factor: 5173171083356480759
  { 297492191, 62, 8704728720ULL },   // factor: 5179177637946851041
  { 299506919, 62, 8647342581ULL },   // factor: 5179877867945635879
  { 298576123, 62, 8687333565ULL },   // factor: 5187660750090936991
  { 297723373, 62, 8713057160ULL },   // factor: 5188161533634001361
  { 298616779, 62, 8686800860ULL },   // factor: 5188048985255259881
  { 298416197, 62, 8702224723ULL },   // factor: 5193769614554076863
  { 298825927, 62, 8695007048ULL },   // factor: 5196587082780266993
  { 299760079, 62, 8669730500ULL },   // factor: 5197678199177419001
  { 299101381, 62, 8693172128ULL },   // factor: 5200279577511017537
  { 299802091, 62, 8676970164ULL },   // factor: 5202747597423625849
  { 299472127, 62, 8688035313ULL },   // factor: 5203648829270441503
  { 297925163, 62, 8738274640ULL },   // factor: 5206703792921532641
  { 297321797, 62, 8758415872ULL },   // factor: 5208135891872723969
  { 299971879, 62, 8683195769ULL },   // factor: 5209429101103559903
  { 297240599, 62, 8764070229ULL },   // factor: 5210074969092054343
  { 299451079, 62, 8717274216ULL },   // factor: 5220794339840158129
  { 298690649, 62, 8746530304ULL },   // factor: 5225013625999854593
  { 298982263, 62, 8746114848ULL },   // factor: 5229866419425882049
  { 299347627, 62, 8739620552ULL },   // factor: 5232369346243260209
  { 298251563, 62, 8780266500ULL },   // factor: 5237456414363079001
  { 298772563, 62, 8765006733ULL },   // factor: 5237487052661333359
  { 297181627, 62, 8814009152ULL },   // factor: 5238723160368500609
  { 298388147, 62, 8778399420ULL },   // factor: 5238740673119349481
  { 297973727, 62, 8793454012ULL },   // factor: 5240436530317485449
  { 299356693, 62, 8759365275ULL },   // factor: 5244349243006071151
  { 299453417, 62, 8771067363ULL },   // factor: 5253052185175058743
  { 299434823, 62, 8779758733ULL },   // factor: 5257931004397118519
  { 298717921, 62, 8808290055ULL },   // factor: 5262388185589151311
  { 297243103, 62, 8854096841ULL },   // factor: 5263638438562675247
  { 297622081, 62, 8843520060ULL },   // factor: 5264053687244889721
  { 299953453, 62, 8775913848ULL },   // factor: 5264731323876234289
  { 299471797, 62, 8793667439ULL },   // factor: 5266910780355435767
  { 299041411, 62, 8808463400ULL },   // factor: 5268190647755714801
  { 298544747, 62, 8824563477ULL },   // factor: 5269054141252810639
  { 298008679, 62, 8841823749ULL },   // factor: 5269880430780635143
  { 299409053, 62, 8800319332ULL },   // factor: 5269790554583425193
  { 299977709, 62, 8784536767ULL },   // factor: 5270330427981853607
  { 298811959, 62, 8824549632ULL },   // factor: 5273761925661298177
  { 297197347, 62, 8889106152ULL },   // factor: 5283637531151557489
  { 298372673, 62, 8855192112ULL },   // factor: 5284294680771910753
  { 297776593, 62, 8875838772ULL },   // factor: 5286034059086927593
  { 299129143, 62, 8845721672ULL },   // factor: 5292026285923774193
  { 298037869, 62, 8879481596ULL },   // factor: 5292843545393117849
  { 297187717, 62, 8908828424ULL },   // factor: 5295188760946536017
  { 297778799, 62, 8891990917ULL },   // factor: 5295692751966337367
  { 299896567, 62, 8832488400ULL },   // factor: 5297665898454645601
  { 299916707, 62, 8836131228ULL },   // factor: 5300206761043252393
  { 299088221, 62, 8870066304ULL },   // factor: 5305864702030810369
  { 299078089, 62, 8876324144ULL },   // factor: 5309428124664161633
  { 299915867, 62, 8853614464ULL },   // factor: 5310678916108600577
  { 297291349, 62, 8937885740ULL },   // factor: 5314312217704926521
  { 297108127, 62, 8945742000ULL },   // factor: 5315705300490468001
  { 297482777, 62, 8938843779ULL },   // factor: 5318304141092188567
  { 299919107, 62, 8867637889ULL },   // factor: 5319148073736490247
  { 297722857, 62, 8936523807ULL },   // factor: 5321214798937113199
  { 298009753, 62, 8929142496ULL },   // factor: 5321943099469526977
  { 299488169, 62, 8888213695ULL },   // factor: 5323829690392548911
  { 298778351, 62, 8912307768ULL },   // factor: 5325609237055061137
  { 298441361, 62, 8926329204ULL },   // factor: 5327971672751613289
  { 297217489, 62, 8965071935ULL },   // factor: 5329152338450142431
  { 298538609, 62, 8926699695ULL },   // factor: 5329929019812048511
  { 297382933, 62, 8967611223ULL },   // factor: 5333629054998914119
  { 299018221, 62, 8921483136ULL },   // factor: 5335372032016442113
  { 297370807, 62, 8973528620ULL },   // factor: 5336930894733992681
  { 297042019, 62, 8993288421ULL },   // factor: 5342769100046323999
  { 298001201, 62, 8967716044ULL },   // factor: 5344780302677937689
  { 299510171, 62, 8927727420ULL },   // factor: 5347890332411177641
  { 297317071, 62, 8998627616ULL },   // factor: 5350891211617665473
  { 297258749, 62, 9002662284ULL },   // factor: 5352240256422645433
  { 298600507, 62, 8979000149ULL },   // factor: 5362267993688951087
  { 298733051, 62, 8979320985ULL },   // factor: 5364839907514750471
  { 299049689, 62, 8971386727ULL },   // factor: 5365780821216155807
  { 299529743, 62, 8962602952ULL },   // factor: 5369132317647202673
  { 299976091, 62, 8954706593ULL },   // factor: 5372395759640135927
  { 299993227, 62, 8954726565ULL },   // factor: 5372714638273950511
  { 299390251, 62, 8974902693ULL },   // factor: 5373996739915691887
  { 298380191, 62, 9007964193ULL },   // factor: 5375596152857001727
  { 299216639, 62, 8984551284ULL },   // factor: 5376654476243228953
  { 298103647, 62, 9034620633ULL },   // factor: 5386506719917497103
  { 298204589, 62, 9043846812ULL },   // factor: 5393833243102840537
  { 299723623, 62, 8999153181ULL },   // factor: 5394517590682589527
  { 299913197, 62, 9010774335ULL },   // factor: 5404900276510797991
  { 298458107, 62, 9059589132ULL },   // factor: 5407815645068986249
  { 297859207, 62, 9089096429ULL },   // factor: 5414542109376943607
  { 299575607, 62, 9036698520ULL },   // factor: 5414348888810003281
  { 297819979, 62, 9099808085ULL },   // factor: 5420209305557460431
  { 297312913, 62, 9116804288ULL },   // factor: 5421087280232341889
  { 299283791, 62, 9062275701ULL },   // factor: 5424384453764924983
  { 299463581, 62, 9058335580ULL },   // factor: 5425283221373023961
  { 299980517, 62, 9044895619ULL },   // factor: 5426584927997310047
  { 298969261, 62, 9090113039ULL },   // factor: 5435328755352588359
  { 298973249, 62, 9093362772ULL },   // factor: 5437344424560972457
  { 299604203, 62, 9076873977ULL },   // factor: 5438939187221050663
  { 298685311, 62, 9108981608ULL },   // factor: 5441438008957520177
  { 298741903, 62, 9110171148ULL },   // factor: 5443179730818429289
  { 299957813, 62, 9073792812ULL },   // factor: 5443510095005280313
  { 297458173, 62, 9167526935ULL },   // factor: 5453911626026779511
  { 299299591, 62, 9111290900ULL },   // factor: 5454011279704043801
  { 298157099, 62, 9155116980ULL },   // factor: 5459326239524882041
  { 298748431, 62, 9137217716ULL },   // factor: 5459458912720807193
  { 297741361, 62, 9179641851ULL },   // factor: 5466318116418598423
  { 297046949, 62, 9204738976ULL },   // factor: 5468479258324368449
  { 297505007, 62, 9190500837ULL },   // factor: 5468440031690381719
  { 298525421, 62, 9159146595ULL },   // factor: 5468476186546182991
  { 297272159, 62, 9198574069ULL },   // factor: 5468959946426089943
  { 297861497, 62, 9187906287ULL },   // factor: 5473447041883063279
  { 297091589, 62, 9217280880ULL },   // factor: 5476753245797036641
  { 298606937, 62, 9175985052ULL },   // factor: 5480025580671011449
  { 298755727, 62, 9171263493ULL },   // factor: 5479934984719548823
  { 297844409, 62, 9203165491ULL },   // factor: 5482222773192179639
  { 298362343, 62, 9188701545ULL },   // factor: 5483125044187839871
  { 298544959, 62, 9188714517ULL },   // factor: 5486488797480939607
  { 298730329, 62, 9193159716ULL },   // factor: 5492551253020453129
  { 298972511, 62, 9189229873ULL },   // factor: 5494654258574042207
  { 299300509, 62, 9179335244ULL },   // factor: 5494759421621678393
  { 297653897, 62, 9232587340ULL },   // factor: 5496231202287727961
  { 298373923, 62, 9221167281ULL },   // factor: 5502711712542426727
  { 299811671, 62, 9185051596ULL },   // factor: 5507571334435953833
  { 297939611, 62, 9243885565ULL },   // factor: 5508239338729230431
  { 299922583, 62, 9183310772ULL },   // factor: 5508564574459928153
  { 298138721, 62, 9239817820ULL },   // factor: 5509494934255616441
  { 297692719, 62, 9255758016ULL },   // factor: 5510743540378171009
  { 299724323, 62, 9193354137ULL },   // factor: 5510943689623148503
  { 299716159, 62, 9200675940ULL },   // factor: 5515182505881028921
  { 297443581, 62, 9273094560ULL },   // factor: 5516444905756038721
  { 299774971, 62, 9214646100ULL },   // factor: 5524640534805526201
  { 297233633, 62, 9294179755ULL },   // factor: 5525085628667399831
  { 298632079, 62, 9262521065ULL },   // factor: 5532171844844488271
  { 298743073, 62, 9264369092ULL },   // factor: 5535332183900599433
  { 298582327, 62, 9271023300ULL },   // factor: 5536327421170438201
  { 298900177, 62, 9273501407ULL },   // factor: 5543702423924098079
  { 297406657, 62, 9323003672ULL },   // factor: 5545446710576489009
  { 298222073, 62, 9301043692ULL },   // factor: 5547553061783627033
  { 299684387, 62, 9259527424ULL },   // factor: 5549871599942258177
  { 299487919, 62, 9268147184ULL },   // factor: 5551396226243740193
  { 297247121, 62, 9340019239ULL },   // factor: 5552587657754721839
  { 299501327, 62, 9295013280ULL },   // factor: 5567737623685245121
  { 297145129, 62, 9371595416ULL },   // factor: 5569447857646257329
  { 297901349, 62, 9350177424ULL },   // factor: 5570860935997889953
  { 298807571, 62, 9324490125ULL },   // factor: 5572456490129472751
  { 297525499, 62, 9367423157ULL },   // factor: 5574094498261160687
  { 297802103, 62, 9362833428ULL },   // factor: 5576542969794198169
  { 299678723, 62, 9306293661ULL },   // factor: 5577796400382949807
  { 299118829, 62, 9325580372ULL },   // factor: 5578913361236048777
  { 299628313, 62, 9314677848ULL },   // factor: 5581882419469420849
  { 297846013, 62, 9373583028ULL },   // factor: 5583768664828534729
  { 299255057, 62, 9345770983ULL },   // factor: 5593538456453222063
  { 299157203, 62, 9366249648ULL },   // factor: 5603962094590829089
  { 298714063, 62, 9383016372ULL },   // factor: 5605677887351278873
  { 298339099, 62, 9404236029ULL },   // factor: 5611302607350395743
  { 299476741, 62, 9368218940ULL },   // factor: 5611127354251349081
  { 299854021, 62, 9357926859ULL },   // factor: 5612023993790100079
  { 298947331, 62, 9400686429ULL },   // factor: 5620620235034941999
  { 298148953, 62, 9428151380ULL },   // factor: 5621986925345010281
  { 298195019, 62, 9428564229ULL },   // factor: 5623101778818750703
  { 298298383, 62, 9433518741ULL },   // factor: 5628006772880991607
  { 298747147, 62, 9420418553ULL },   // factor: 5628646332509236583
  { 299675347, 62, 9393896709ULL },   // factor: 5630238511903466047
  { 299389547, 62, 9421265692ULL },   // factor: 5641256935389043049
  { 298768501, 62, 9447314763ULL },   // factor: 5645120140433360527
  { 299448007, 62, 9451573328ULL },   // factor: 5660509592167914593
  { 297888013, 62, 9506738420ULL },   // factor: 5663886836089118921
  { 299967589, 62, 9443086016ULL },   // factor: 5665239489878270849
  { 299950031, 62, 9446180316ULL },   // factor: 5666764157231579593
  { 297428623, 62, 9528335520ULL },   // factor: 5667999426391177921
  { 298217251, 62, 9511857225ULL },   // factor: 5673199827087976951
  { 298103147, 62, 9517295872ULL },   // factor: 5674271700746618369
  { 299044951, 62, 9494159285ULL },   // factor: 5678360796338040071
  { 298658383, 62, 9516404477ULL },   // factor: 5684307946149561383
  { 297185621, 62, 9567696348ULL },   // factor: 5686763561439624217
  { 298931377, 62, 9525808100ULL },   // factor: 5695125864741507401
  { 298332721, 62, 9546290160ULL },   // factor: 5695941437776650721
  { 297135529, 62, 9586679819ULL },   // factor: 5697086358744378503
  { 297107887, 62, 9600443168ULL },   // factor: 5704734767816132033
  { 297197963, 62, 9598493421ULL },   // factor: 5705305385180202847
  { 297731869, 62, 9581261076ULL },   // factor: 5705293535068862089
  { 299390137, 62, 9530171115ULL },   // factor: 5706478471506585511
  { 299524349, 62, 9540648264ULL },   // factor: 5715312920625160273
  { 299228087, 62, 9550979985ULL },   // factor: 5715842939773677391
  { 297460211, 62, 9622964940ULL },   // factor: 5724898362996004681
  { 299083951, 62, 9581352305ULL },   // factor: 5731257406604714111
  { 297419543, 62, 9641598772ULL },   // factor: 5735199801115202393
  { 298691879, 62, 9603470889ULL },   // factor: 5736957529514420863
  { 299566063, 62, 9580442768ULL },   // factor: 5739951043613164769
  { 299736971, 62, 9577695868ULL },   // factor: 5741579097267071657
  { 298760911, 62, 9617219508ULL },   // factor: 5746498522994103577
  { 298564207, 62, 9627630084ULL },   // factor: 5748931482637606777
  { 298787497, 62, 9630332360ULL },   // factor: 5754845802245005841
  { 298098419, 62, 9655314721ULL },   // factor: 5756468106555052199
  { 299904887, 62, 9599256600ULL },   // factor: 5757727931814008401
  { 297634123, 62, 9678727613ULL },   // factor: 5761439209702276799
  { 297184627, 62, 9694331937ULL },   // factor: 5762012841423064999
  { 297905609, 62, 9675511084ULL },   // factor: 5764778043730540313
  { 299311471, 62, 9633640776ULL },   // factor: 5766918383500282993
  { 299053471, 62, 9642348648ULL },   // factor: 5767155663553114417
  { 297183281, 62, 9712112728ULL },   // factor: 5772555051897801137
  { 297343687, 62, 9711327693ULL },   // factor: 5775203963803648183
  { 299110363, 62, 9654036188ULL },   // factor: 5775244537215632489
  { 298893299, 62, 9661589941ULL },   // factor: 5775568982101410719
  { 297847279, 62, 9704205972ULL },   // factor: 5780742687231500377
  { 299073811, 62, 9665415360ULL },   // factor: 5781345213226273921
  { 297917233, 62, 9722570331ULL },   // factor: 5793042501318828247
  { 298826431, 62, 9699863265ULL },   // factor: 5797151041335914431
  { 297318271, 62, 9766651980ULL },   // factor: 5807608160304653161
  { 297918239, 62, 9752603520ULL },   // factor: 5810956932687202561
  { 297286961, 62, 9776023119ULL },   // factor: 5812568407426502719
  { 298321741, 62, 9750959783ULL },   // factor: 5817846597771084407
  { 299905343, 62, 9721922332ULL },   // factor: 5831312903195639753
  { 298039759, 62, 9783729981ULL },   // factor: 5831881051316629159
  { 299337793, 62, 9750644595ULL },   // factor: 5837472866789357671
  { 297684329, 62, 9808869279ULL },   // factor: 5839893339135657583
  { 298356841, 62, 9787437864ULL },   // factor: 5840298085173655249
  { 299398787, 62, 9758299905ULL },   // factor: 5843246309478430471
  { 297548431, 62, 9822871968ULL },   // factor: 5845560283984564417
  { 297151373, 62, 9851913163ULL },   // factor: 5855019046124445599
  { 298831817, 62, 9799970299ULL },   // factor: 5857085861992406567
  { 297054971, 62, 9865727500ULL },   // factor: 5861326792812805001
  { 297178169, 62, 9862330671ULL },   // factor: 5861738741760642799
  { 299120947, 62, 9802712457ULL },   // factor: 5864393266613073559
  { 298406579, 62, 9832141092ULL },   // factor: 5867951175018088537
  { 298007861, 62, 9849253783ULL },   // factor: 5870310104635976327
  { 299179679, 62, 9813209629ULL },   // factor: 5871825813527858183
  { 299543521, 62, 9829566671ULL },   // factor: 5888766021071177183
  { 297104791, 62, 9922031613ULL },   // factor: 5895766257351515767
  { 298238201, 62, 9896507719ULL },   // factor: 5903033316594347039
  { 298363237, 62, 9896215463ULL },   // factor: 5905333759180267463
  { 299736487, 62, 9851233277ULL },   // factor: 5905548110130955799
  { 299087881, 62, 9877186008ULL },   // factor: 5908293266751138097
  { 298495487, 62, 9899888428ULL },   // factor: 5910144035123048873
  { 299271743, 62, 9881924520ULL },   // factor: 5914761550589676721
  { 297351347, 62, 9957211209ULL },   // factor: 5921580330719297047
  { 299250649, 62, 9897981359ULL },   // factor: 5923954690941303983
  { 298090127, 62, 9938839189ULL },   // factor: 5925339672163174007
  { 298450729, 62, 9949815452ULL },   // factor: 5939059350129729017
  { 298756877, 62, 9950229780ULL },   // factor: 5945399149010394121
  { 299518097, 62, 9929866668ULL },   // factor: 5948349535726181593
  { 297872837, 62, 10000224444ULL },   // factor: 5957590451542055257
  { 297491533, 62, 10013889231ULL },   // factor: 5958094517244762247
  { 298433159, 62, 9988902205ULL },   // factor: 5962039279960431191
  { 299617733, 62, 9949664832ULL },   // factor: 5962192042147331713
  { 297080887, 62, 10035895289ULL },   // factor: 5962945348590482687
  { 298425859, 62, 9993737561ULL },   // factor: 5964779432523979799
  { 299076647, 62, 9981472008ULL },   // factor: 5970450360553994353
  { 298507357, 62, 10003368828ULL },   // factor: 5972158379884935193
  { 298352903, 62, 10022065476ULL },   // factor: 5980224657641353657
  { 298890707, 62, 10009053684ULL },   // factor: 5983226264023429177
  { 297007267, 62, 10072836372ULL },   // factor: 5983411203571830649
  { 297038897, 62, 10079700435ULL },   // factor: 5988126198605640391
  { 298374773, 62, 10040721828ULL },   // factor: 5991796192371290089
  { 298669933, 62, 10042448427ULL },   // factor: 5998754797696090783
  { 298644133, 62, 10044973848ULL },   // factor: 5999745011687267569
  { 299414701, 62, 10030565663ULL },   // factor: 6006597637696023527
  { 297980521, 62, 10092555959ULL },   // factor: 6014770165768949279
  { 299558953, 62, 10041973736ULL },   // factor: 6016326276819316817
  { 299133449, 62, 10065192667ULL },   // factor: 6021671594658436967
  { 298483613, 62, 10097878176ULL },   // factor: 6028102323212659777
  { 299156129, 62, 10080758931ULL },   // factor: 6031441638360276199
  { 299984599, 62, 10057505672ULL },   // factor: 6034193611910291057
  { 298225649, 62, 10117840191ULL },   // factor: 6034798914878517919
  { 299164771, 62, 10099814505ULL },   // factor: 6043017387061606711
  { 297433979, 62, 10175522041ULL },   // factor: 6053092018113662279
  { 297187871, 62, 10187446333ULL },   // factor: 6055170973262054087
  { 299967821, 62, 10100523079ULL },   // factor: 6059663797935681719
  { 297626377, 62, 10180533075ULL },   // factor: 6059990350081838551
  { 299225023, 62, 10132039797ULL },   // factor: 6063519682588480663
  { 298617481, 62, 10154796303ULL },   // factor: 6064799384139945487
  { 297608023, 62, 10197508520ULL },   // factor: 6069720700325711921
  { 298204919, 62, 10187311264ULL },   // factor: 6075812660617815233
  { 297729571, 62, 10212999453ULL },   // factor: 6081423891529849327
  { 299963231, 62, 10151472045ULL },   // factor: 6090136708048754791
  { 299819629, 62, 10174474460ULL },   // factor: 6101014315734350681
  { 298702489, 62, 10248664239ULL },   // factor: 6122603034229181743
  { 298385161, 62, 10271078723ULL },   // factor: 6129474956812058807
  { 298464043, 62, 10274273648ULL },   // factor: 6133002503740877729
  { 298856609, 62, 10270195807ULL },   // factor: 6138631785292076927
  { 299344049, 62, 10254143664ULL },   // factor: 6139033766818911073
  { 298165103, 62, 10298353912ULL },   // factor: 6141219509803865873
  { 297913489, 62, 10312907159ULL },   // factor: 6144708306941535503
  { 299846191, 62, 10251797028ULL },   // factor: 6147924579501840697
  { 297802031, 62, 10326856705ULL },   // factor: 6150717801189935711
  { 299834929, 62, 10257399347ULL },   // factor: 6151053209864782727
  { 297505877, 62, 10341833127ULL },   // factor: 6153512268471574759
  { 299065801, 62, 10295989595ULL },   // factor: 6158356750632681191
  { 299814629, 62, 10285021791ULL },   // factor: 6167199985051161079
  { 299285137, 62, 10311772563ULL },   // factor: 6172320528460592263
  { 297075071, 62, 10391705289ULL },   // factor: 6174233173081501039
  { 298599451, 62, 10342410336ULL },   // factor: 6176476096692651073
  { 297256307, 62, 10392317692ULL },   // factor: 6178363956589366889
  { 298876009, 62, 10336306940ULL },   // factor: 6178548332052404921
  { 299859673, 62, 10302399932ULL },   // factor: 6178548549449484473
  { 299909431, 62, 10303899209ULL },   // factor: 6180473097705080159
  { 298949137, 62, 10344026544ULL },   // factor: 6184675616867785057
  { 297813077, 62, 10389188827ULL },   // factor: 6188072584205781359
  { 297349391, 62, 10429592416ULL },   // factor: 6202465906551637313
  { 297776741, 62, 10420896264ULL },   // factor: 6206201055585991249
  { 297938353, 62, 10421500116ULL },   // factor: 6209929160700697897
  { 298274731, 62, 10410114536ULL },   // factor: 6210148225809179633
  { 299044913, 62, 10388930656ULL },   // factor: 6213513728373105857
  { 297220117, 62, 10463293383ULL },   // factor: 6219802567001171623
  { 297529313, 62, 10460113648ULL },   // factor: 6224380855182727649
  { 299708531, 62, 10389330361ULL },   // factor: 6227541881138019383
  { 297432007, 62, 10471766448ULL },   // factor: 6229277022927802273
  { 297224801, 62, 10504468435ULL },   // factor: 6244377080407312871
  { 299373089, 62, 10431866200ULL },   // factor: 6246040016657383601
  { 299073893, 62, 10448398452ULL },   // factor: 6249686401309627273
  { 299550607, 62, 10432905645ULL },   // factor: 6250366437466953031
  { 298905479, 62, 10456631137ULL },   // factor: 6251088677462599247
  { 299446151, 62, 10457216500ULL },   // factor: 6262746462197383001
  { 297070129, 62, 10549941044ULL },   // factor: 6268144693766949353
  { 298159223, 62, 10518563797ULL },   // factor: 6272413617578899463
  { 297824299, 62, 10531927809ULL },   // factor: 6273328033668061783
  { 297747011, 62, 10538293020ULL },   // factor: 6275490495494326441
  { 297888379, 62, 10534813404ULL },   // factor: 6276396975970064233
  { 298610993, 62, 10511892952ULL },   // factor: 6277933585412842673
  { 297154283, 62, 10575806788ULL },   // factor: 6285292566469346009
  { 298125161, 62, 10541179636ULL },   // factor: 6285181752224842793
  { 297539327, 62, 10573795092ULL },   // factor: 6292239751019166169
  { 298916047, 62, 10525274373ULL },   // factor: 6292346818335127063
  { 298946393, 62, 10534734535ULL },   // factor: 6298641780901564511
  { 299122279, 62, 10529809560ULL },   // factor: 6299401266046374481
  { 299592079, 62, 10528853820ULL },   // factor: 6308722410841783561
  { 299746457, 62, 10535307832ULL },   // factor: 6315842392092702449
  { 297081517, 62, 10642887720ULL },   // factor: 6323610458236542481
  { 297970511, 62, 10617451888ULL },   // factor: 6327375129170549537
  { 297669793, 62, 10641814848ULL },   // factor: 6335493645896972929
  { 297730141, 62, 10645158740ULL },   // factor: 6338769225255164681
  { 298724443, 62, 10613946992ULL },   // factor: 6341290806433450913
  { 298326521, 62, 10629014016ULL },   // factor: 6341833546107036673
  { 299428243, 62, 10596153021ULL },   // factor: 6345574963274344207
  { 298090063, 62, 10647023457ULL },   // factor: 6347543786119215583
  { 299568697, 62, 10600812747ULL },   // factor: 6351343323519561319
  { 297177577, 62, 10686807332ULL },   // factor: 6351759017579189129
  { 297924953, 62, 10666661880ULL },   // factor: 6355729478531783281
  { 298255907, 62, 10659603604ULL },   // factor: 6358579482342977657
  { 298870409, 62, 10640696532ULL },   // factor: 6360378649127443177
  { 297843493, 62, 10678983408ULL },   // factor: 6361331439855528289
  { 297718199, 62, 10699532509ULL },   // factor: 6370891097442862583
  { 297738781, 62, 10704440891ULL },   // factor: 6374254364345787743
  { 297892087, 62, 10701810173ULL },   // factor: 6375969134225602103
  { 299509421, 62, 10645184464ULL },   // factor: 6376666070501670689
  { 299409283, 62, 10650936000ULL },   // factor: 6377978222077776001
  { 297066727, 62, 10740494397ULL },   // factor: 6381287033757257239
  { 297697783, 62, 10726265705ULL },   // factor: 6386371040494864031
  { 299259133, 62, 10694191871ULL },   // factor: 6400669174902215687
  { 298849277, 62, 10712325844ULL },   // factor: 6402741666935629577
  { 297943589, 62, 10754508816ULL },   // factor: 6408473909142361249
  { 297527929, 62, 10772615544ULL },   // factor: 6410307985439056753
  { 298396591, 62, 10758698853ULL },   // factor: 6420718122661620247
  { 299746081, 62, 10726425164ULL },   // factor: 6430407812097564569
  { 298876979, 62, 10763178100ULL },   // factor: 6433732309933919801
  { 299951363, 62, 10726460788ULL },   // factor: 6434833067053308089
  { 298477709, 62, 10782524952ULL },   // factor: 6436686689816589937
  { 299687669, 62, 10755314164ULL },   // factor: 6446470062343687433
  { 299520751, 62, 10765286165ULL },   // factor: 6448853193741419831
  { 297486257, 62, 10841031664ULL },   // factor: 6450115863483683297
  { 298895923, 62, 10794700340ULL },   // factor: 6452983843265427641
  { 298875767, 62, 10796394168ULL },   // factor: 6453561175590653713
  { 297340873, 62, 10858360808ULL },   // factor: 6457268963999410769
  { 299584553, 62, 10786207155ULL },   // factor: 6462762098192153431
  { 298302947, 62, 10842500289ULL },   // factor: 6468699578114103367
  { 297249439, 62, 10888273824ULL },   // factor: 6473066571724769473
  { 297117943, 62, 10912305077ULL },   // factor: 6484483275733393223
  { 298618513, 62, 10863226820ULL },   // factor: 6487921278740237321
  { 297961541, 62, 10891136791ULL },   // factor: 6490279802976309863
  { 297879157, 62, 10902815160ULL },   // factor: 6495442777575240241
  { 298132129, 62, 10901076792ULL },   // factor: 6499922464782900337
  { 297863369, 62, 10924040736ULL },   // factor: 6507743153436399169
  { 297155311, 62, 10960469580ULL },   // factor: 6513923493501878761
  { 297749581, 62, 10951878219ULL },   // factor: 6521834301740552479
  { 298843073, 62, 10922146572ULL },   // factor: 6528015690665791513
  { 298491187, 62, 10951132080ULL },   // factor: 6537632827105957921
  { 298372201, 62, 10971154884ULL },   // factor: 6546975260501959369
  { 299409823, 62, 10955742117ULL },   // factor: 6560513616169230583
  { 299886661, 62, 10948581411ULL },   // factor: 6566667044062917343
  { 297516803, 62, 11049610120ULL },   // factor: 6574889354597692721
  { 298455611, 62, 11026079836ULL },   // factor: 6581590788776319593
  { 299733257, 62, 10979349003ULL },   // factor: 6581752072817785543
  { 297696757, 62, 11066673620ULL },   // factor: 6589025694902900681
  { 299914831, 62, 10988112729ULL },   // factor: 6590995944253967599
  { 297712999, 62, 11082957717ULL },   // factor: 6599081159436526567
  { 297412979, 62, 11096979241ULL },   // factor: 6600771307933937879
  { 297969197, 62, 11076264507ULL },   // factor: 6600771281820781759
  { 298130219, 62, 11076761784ULL },   // factor: 6604634832949501393
  { 299436131, 62, 11028770829ULL },   // factor: 6604824933442845199
  { 299845921, 62, 11016762963ULL },   // factor: 6606662874158847847
  { 297836743, 62, 11091897597ULL },   // factor: 6607149307960013143
  { 298604071, 62, 11073891204ULL },   // factor: 6613417990650982969
  { 299169823, 62, 11053999685ULL },   // factor: 6614046258407011511
  { 298293343, 62, 11095609197ULL },   // factor: 6619492719989351143
  { 298697521, 62, 11080465659ULL },   // factor: 6619415247737862679
  { 299542127, 62, 11048957545ULL },   // factor: 6619256488323996431
  { 299969837, 62, 11034596215ULL },   // factor: 6620092055948733911
  { 298035323, 62, 11109346597ULL },   // factor: 6621955402711691663
  { 297538433, 62, 11131374975ULL },   // factor: 6624023734393828351
  { 298739783, 62, 11087656608ULL },   // factor: 6624648258104872129
  { 299133997, 62, 11074819932ULL },   // factor: 6625710304628856409
  { 297851327, 62, 11125021224ULL },   // factor: 6627204668943128497
  { 298592237, 62, 11097983739ULL },   // factor: 6627543581635268287
  { 297231211, 62, 11155701408ULL },   // factor: 6631645278108490177
  { 299649631, 62, 11070990225ULL },   // factor: 6634836271451713951
  { 299268973, 62, 11091818223ULL },   // factor: 6638874096599789959
  { 297062351, 62, 11193519688ULL },   // factor: 6650346548964132977
  { 299693857, 62, 11103830232ULL },   // factor: 6655499419402569649
  { 298858727, 62, 11140407889ULL },   // factor: 6658816239934594607
  { 299229967, 62, 11137847688ULL },   // factor: 6665555592262532593
  { 299997679, 62, 11117214485ULL },   // factor: 6670277084890360631
  { 298595303, 62, 11202370936ULL },   // factor: 6689950687906627217
  { 299298607, 62, 11175876108ULL },   // factor: 6689848302257963113
  { 297423953, 62, 11250032163ULL },   // factor: 6692058074593200679
  { 297793801, 62, 11243275104ULL },   // factor: 6696355257817660609
  { 299222639, 62, 11199805945ULL },   // factor: 6702470982301577711
  { 297758533, 62, 11258267280ULL },   // factor: 6704490298829400481
  { 299893487, 62, 11188863393ULL },   // factor: 6710934516986842783
  { 297421147, 62, 11286133053ULL },   // factor: 6713469275635743583
  { 297048781, 62, 11311242128ULL },   // factor: 6719981371436491937
  { 298278713, 62, 11266391428ULL },   // factor: 6721049470596144329
  { 299395273, 62, 11228340783ULL },   // factor: 6723424308126637519
  { 298353449, 62, 11275995135ULL },   // factor: 6728464078868941231
  { 297399931, 62, 11321227505ULL },   // factor: 6733864557644604311
  { 299048363, 62, 11267774448ULL },   // factor: 6739219006655257249
  { 299823241, 62, 11242268171ULL },   // factor: 6741386558440724423
  { 299213251, 62, 11266093256ULL },   // factor: 6741928778393870513
  { 297399439, 62, 11362483584ULL },   // factor: 6758392487056618753
  { 297556163, 62, 11358561756ULL },   // factor: 6759620106627804457
  { 299314621, 62, 11295010368ULL },   // factor: 6761523494977981057
  { 298607707, 62, 11331492177ULL },   // factor: 6767341791724816279
  { 298232573, 62, 11346386475ULL },   // factor: 6767724065383300351
  { 298352689, 62, 11353842011ULL },   // factor: 6774898588926035159
  { 298891321, 62, 11350124379ULL },   // factor: 6784907338307229319
  { 298339949, 62, 11386197499ULL },   // factor: 6793915162311175103
  { 299400247, 62, 11351970609ULL },   // factor: 6797565608542680847
  { 297525307, 62, 11423986332ULL },   // factor: 6797850081184207849
  { 298373693, 62, 11399069136ULL },   // factor: 6802364709741278497
  { 299183371, 62, 11371351229ULL },   // factor: 6804238387034425919
  { 297884813, 62, 11426421616ULL },   // factor: 6807514932682635617
  { 299123911, 62, 11379588441ULL },   // factor: 6807814000084625503
  { 297983761, 62, 11427770303ULL },   // factor: 6810579949464099167
  { 299718151, 62, 11365037828ULL },   // factor: 6812616247706432057
  { 297817549, 62, 11443690356ULL },   // factor: 6816263626677714889
  { 297506917, 62, 11458060403ULL },   // factor: 6817704450592615103
  { 298314617, 62, 11429164432ULL },   // factor: 6818973620324205089
  { 297265453, 62, 11475096152ULL },   // factor: 6822299311685673713
  { 299015621, 62, 11412689035ULL },   // factor: 6825144598160831471
  { 298921873, 62, 11417124816ULL },   // factor: 6825656668547000737
  { 298135393, 62, 11447994956ULL },   // factor: 6826104950538155417
  { 297025103, 62, 11495139073ULL },   // factor: 6828689734314299039
  { 299991119, 62, 11393436969ULL },   // factor: 6835859811172556623
  { 298168093, 62, 11464386431ULL },   // factor: 6836628479092692167
  { 299887943, 62, 11398833501ULL },   // factor: 6836745462428756887
  { 299418803, 62, 11421921172ULL },   // factor: 6839875930561194233
  { 298210849, 62, 11476344215ULL },   // factor: 6844740703542777071
  { 297595171, 62, 11512292129ULL },   // factor: 6852005089463418119
  { 297308443, 62, 11524368588ULL },   // factor: 6852584162912776969
  { 299212561, 62, 11451432968ULL },   // factor: 6852825170950222097
  { 298403869, 62, 11482927647ULL },   // factor: 6853100074623732487
  { 299705243, 62, 11433365877ULL },   // factor: 6853279396948386223
  { 299912807, 62, 11427906829ULL },   // factor: 6854751230439718007
  { 299874031, 62, 11430483213ULL },   // factor: 6855410154720283207
  { 298293467, 62, 11492682852ULL },   // factor: 6856384426109055769
  { 299264629, 62, 11465068224ULL },   // factor: 6862178777030097793
  { 299873579, 62, 11442630345ULL },   // factor: 6862685029458309511
  { 299727521, 62, 11455032019ULL },   // factor: 6866776700060989799
  { 297401669, 62, 11546851635ULL },   // factor: 6868105895888757631
  { 298687547, 62, 11499206832ULL },   // factor: 6869339762191442209
  { 297680023, 62, 11563292577ULL },   // factor: 6884322400554178543
  { 299024221, 62, 11518386243ULL },   // factor: 6888552946980383407
  { 299484203, 62, 11500531992ULL },   // factor: 6888455315400244753
  { 298478507, 62, 11549597785ULL },   // factor: 6894613406634613991
  { 299368463, 62, 11521746340ULL },   // factor: 6898494985763350841
  { 299433353, 62, 11551173931ULL },   // factor: 6917613482491041287
  { 297728549, 62, 11629317439ULL },   // factor: 6924759613947732023
  { 298789121, 62, 11594404239ULL },   // factor: 6928563702178967839
  { 299053879, 62, 11585968181ULL },   // factor: 6929657452997248199
  { 297401311, 62, 11659861236ULL },   // factor: 6935316035328960793
  { 299004533, 62, 11612252715ULL },   // factor: 6944232400253114191
  { 299602031, 62, 11597149129ULL },   // factor: 6949058865716561999
  { 297525961, 62, 11685307844ULL },   // factor: 6953364891733876169
  { 297079723, 62, 11710630221ULL },   // factor: 6957981564420217567
  { 299332567, 62, 11625352440ULL },   // factor: 6959693176289826961
  { 299157497, 62, 11653186164ULL },   // factor: 6972276009794543017
  { 298309199, 62, 11694322996ULL },   // factor: 6977048251568080409
  { 299821513, 62, 11641619156ULL },   // factor: 6980815738243406057
  { 298299247, 62, 11705223669ULL },   // factor: 6983318812858554487
  { 297409837, 62, 11751511079ULL },   // factor: 6990029989018168247
  { 297482281, 62, 11760615948ULL },   // factor: 6997149716352034777
  { 297477437, 62, 11761588695ULL },   // factor: 6997614520073549431
  { 298854511, 62, 11707975713ULL },   // factor: 6997962713016982687
  { 298844311, 62, 11710095213ULL },   // factor: 6998990671346766487
  { 299534749, 62, 11697068079ULL },   // factor: 7007356702158354343
  { 298038877, 62, 11777706204ULL },   // factor: 7020428661352185817
  { 298694569, 62, 11756518695ULL },   // factor: 7023216569086934911
  { 299778977, 62, 11716083664ULL },   // factor: 7024471150480663457
  { 297942451, 62, 11788752825ULL },   // factor: 7024739821827348151
  { 299847329, 62, 11716622215ULL },   // factor: 7026395752139627471
  { 298563413, 62, 11786027308ULL },   // factor: 7037753077575364409
  { 298889777, 62, 11774244952ULL },   // factor: 7038402896093311409
  { 299193443, 62, 11764013368ULL },   // factor: 7039431326139892049
  { 299813417, 62, 11745185247ULL },   // factor: 7042728244402117999
  { 298790543, 62, 11787573196ULL },   // factor: 7044030791770170857
  { 299830273, 62, 11783824292ULL },   // factor: 7066294508908783433
  { 299498807, 62, 11818407133ULL },   // factor: 7079197673947580663
  { 298508299, 62, 11862724500ULL },   // factor: 7082243424001251001
  { 299340863, 62, 11830239208ULL },   // factor: 7082548028038313009
  { 297962057, 62, 11898927979ULL },   // factor: 7090858113435385607
  { 298445821, 62, 11880858924ULL },   // factor: 7091585391516713209
  { 298054819, 62, 11901258561ULL },   // factor: 7094454932542110919
  { 299480771, 62, 11849560288ULL },   // factor: 7097430902122444097
  { 298621867, 62, 11901050045ULL },   // factor: 7107827567396668031
  { 297856591, 62, 11939215236ULL },   // factor: 7112347898820440953
  { 299497867, 62, 11874723525ULL },   // factor: 7112908733904442351
  { 299954383, 62, 11868424136ULL },   // factor: 7119971677792376177
  { 298089541, 62, 11947599431ULL },   // factor: 7122908860877302343
  { 299845907, 62, 11882285544ULL },   // factor: 7125709372347336817
  { 298505113, 62, 11943409628ULL },   // factor: 7130337681222855929
  { 299489093, 62, 11908446180ULL },   // factor: 7132899490975029481
  { 299564261, 62, 11914710255ULL },   // factor: 7138442745136393111
  { 298129651, 62, 11975100485ULL },   // factor: 7140265056565961471
  { 299103577, 62, 11939754923ULL },   // factor: 7142446811945319143
  { 297990541, 62, 12006674399ULL },   // factor: 7155750799537719719
  { 299996341, 62, 11930297271ULL },   // factor: 7158091056684570823
  { 297482291, 62, 12039420885ULL },   // factor: 7163029014366095071
  { 299317471, 62, 11968495221ULL },   // factor: 7164759442450612183
  { 298938407, 62, 11985842365ULL },   // factor: 7166057246292425111
  { 299149231, 62, 11982281885ULL },   // factor: 7168980823045960871
  { 299726897, 62, 11960535799ULL },   // factor: 7169788562983371407
  { 297885353, 62, 12035928508ULL },   // factor: 7170653624576686649
  { 297955529, 62, 12032611932ULL },   // factor: 7170366506901544057
  { 299197721, 62, 11986502035ULL },   // factor: 7172668183267724471
  { 298623529, 62, 12017710371ULL },   // factor: 7177542162975838519
  { 299039017, 62, 12006927224ULL },   // factor: 7181079428510997617
  { 298048591, 62, 12050552084ULL },   // factor: 7183300138816627289
  { 299418307, 62, 12000552528ULL },   // factor: 7186370241996660193
  { 298036391, 62, 12059746996ULL },   // factor: 7188486942121862873
  { 298782971, 62, 12030739084ULL },   // factor: 7189159933686677129
  { 299484389, 62, 12010217847ULL },   // factor: 7193745507331380967
  { 298674179, 62, 12048913597ULL },   // factor: 7197398752851823727
  { 297752281, 62, 12094670411ULL },   // factor: 7202431405636914983
  { 299986823, 62, 12005413377ULL },   // factor: 7202931635535862543
  { 299605753, 62, 12024951923ULL },   // factor: 7205489551358426039
  { 297669373, 62, 12104959412ULL },   // factor: 7206551356720977353
  { 298694873, 62, 12069747195ULL },   // factor: 7210343211105262471
  { 299152279, 62, 12060987441ULL },   // factor: 7216143759931056079
  { 297444239, 62, 12157918192ULL },   // factor: 7232605448887391777
  { 298098431, 62, 12137859885ULL },   // factor: 7236553974832680871
  { 297537677, 62, 12162627003ULL },   // factor: 7237679569380184063
  { 298016699, 62, 12155034897ULL },   // factor: 7244806752467490007
  { 298650197, 62, 12139251048ULL },   // factor: 7250779433835312913
  { 299766217, 62, 12097225035ULL },   // factor: 7252678769879285191
  { 298761949, 62, 12157502940ULL },   // factor: 7264398546655260121
  { 297226939, 62, 12223335000ULL },   // factor: 7266208892843130001
  { 299688931, 62, 12130895900ULL },   // factor: 7270990448686565801
  { 297502657, 62, 12226768632ULL },   // factor: 7274992309088510449
  { 299569847, 62, 12143934649ULL },   // factor: 7275913289557857407
  { 297340529, 62, 12283793107ULL },   // factor: 7304939081123867207
  { 298191793, 62, 12260338052ULL },   // factor: 7311864373024014473
  { 299040661, 62, 12228130556ULL },   // factor: 7313416488521075033
  { 298420819, 62, 12256973192ULL },   // factor: 7315471956835368497
  { 297937181, 62, 12277893103ULL },   // factor: 7316081719454325287
  { 298921717, 62, 12241023060ULL },   // factor: 7318215261863588041
  { 297082469, 62, 12318944119ULL },   // factor: 7319484668691099623
  { 299200711, 62, 12238450116ULL },   // factor: 7323505952490464953
  { 299452453, 62, 12254629163ULL },   // factor: 7339357526931373679
  { 297077323, 62, 12356275356ULL },   // factor: 7341538410022703977
  { 298791583, 62, 12298511177ULL },   // factor: 7349383246238046383
  { 298026889, 62, 12347456204ULL },   // factor: 7359747919083738713
  { 298675469, 62, 12331923655ULL },   // factor: 7366486162658638391
  { 298304983, 62, 12352117388ULL },   // factor: 7369396334882688809
  { 299078863, 62, 12321944621ULL },   // factor: 7370466374395291847
  { 298694161, 62, 12362230136ULL },   // factor: 7385051917122871793
  { 298771687, 62, 12360452889ULL },   // factor: 7385906723461107487
  { 298956023, 62, 12359198077ULL },   // factor: 7389713409138335543
  { 298104731, 62, 12396525841ULL },   // factor: 7390926002331707543
  { 298646687, 62, 12387070120ULL },   // factor: 7398714905949384881
  { 297584647, 62, 12434711264ULL },   // factor: 7400758324088727617
  { 299131409, 62, 12371442291ULL },   // factor: 7401373927738036039
  { 298023409, 62, 12424977059ULL },   // factor: 7405868039739948263
  { 297249307, 62, 12473863757ULL },   // factor: 7415694714761332799
  { 298784501, 62, 12425356104ULL },   // factor: 7425007646561888209
  { 297550147, 62, 12488980329ULL },   // factor: 7432195865548116727
  { 299646499, 62, 12414709380ULL },   // factor: 7440048403638921241
  { 298679177, 62, 12457734612ULL },   // factor: 7441731842393148649
  { 299446283, 62, 12426056437ULL },   // factor: 7441872824815747343
  { 299689339, 62, 12417616377ULL },   // factor: 7442854487957409607
  { 298402183, 62, 12472452636ULL },   // factor: 7443614187893008777
  { 299799833, 62, 12416889027ULL },   // factor: 7445162513348264983
  { 297128957, 62, 12546558624ULL },   // factor: 7455891755776950337
  { 297205261, 62, 12549895899ULL },   // factor: 7459790172370249279
  { 298835011, 62, 12503927964ULL },   // factor: 7473222901330295209
  { 299387083, 62, 12484679300ULL },   // factor: 7475503435634963801
  { 299163589, 62, 12497970651ULL },   // factor: 7477875510339652879
  { 297946333, 62, 12565091951ULL },   // factor: 7487446141216531367
  { 299826173, 62, 12486392692ULL },   // factor: 7487494670835055433
  { 297932321, 62, 12579016483ULL },   // factor: 7495391153354894087
  { 297472223, 62, 12623973648ULL },   // factor: 7510563008327959009
  { 297414683, 62, 12627521580ULL },   // factor: 7511220655582718281
  { 299921527, 62, 12529501520ULL },   // factor: 7515734456854442081
  { 299167129, 62, 12564560471ULL },   // factor: 7517806966511915519
  { 298520129, 62, 12601630927ULL },   // factor: 7523680979876859167
  { 298680409, 62, 12597170799ULL },   // factor: 7525056252976353583
  { 299065027, 62, 12586862828ULL },   // factor: 7528580943002232713
  { 299362013, 62, 12575858248ULL },   // factor: 7529468480647866449
  { 297247463, 62, 12677442501ULL },   // factor: 7536675241501249927
  { 297632977, 62, 12667129539ULL },   // factor: 7540310949474415207
  { 299697371, 62, 12586556844ULL },   // factor: 7544315992177714249
  { 299107619, 62, 12638647321ULL },   // factor: 7560631415130077399
  { 298601657, 62, 12677167695ULL },   // factor: 7570846559587741231
  { 297926969, 62, 12723080931ULL },   // factor: 7581097876229056279
  { 297971533, 62, 12721347716ULL },   // factor: 7581198961525137257
  { 298150373, 62, 12743266687ULL },   // factor: 7598819431935048503
  { 298808579, 62, 12725512840ULL },   // factor: 7604984817533308721
  { 299560199, 62, 12694081737ULL },   // factor: 7605283302515971327
  { 298299047, 62, 12757199512ULL },   // factor: 7610920913636930129
  { 299308433, 62, 12715148316ULL },   // factor: 7611502235649097657
  { 297787241, 62, 12785510955ULL },   // factor: 7614724064129450311
  { 297610931, 62, 12802886373ULL },   // factor: 7620557865911486527
  { 299565887, 62, 12726119109ULL },   // factor: 7624622317910469367
  { 297327001, 62, 12838135368ULL },   // factor: 7634248574798942737
  { 298856123, 62, 12787674108ULL },   // factor: 7643349412208726569
  { 299229757, 62, 12803393499ULL },   // factor: 7662312650962299487
  { 297595667, 62, 12875341584ULL },   // factor: 7663291733086633057
  { 298034767, 62, 12859212213ULL },   // factor: 7664984631410018743
  { 298719203, 62, 12831632472ULL },   // factor: 7666110050449519633
  { 298905149, 62, 12837104452ULL },   // factor: 7674153237907246697
  { 297795899, 62, 12892793349ULL },   // factor: 7678841971973351503
  { 297757169, 62, 12897071124ULL },   // factor: 7680390772547775913
  { 299042899, 62, 12844069460ULL },   // factor: 7681855532551529081
  { 298453861, 62, 12875841411ULL },   // factor: 7685689165473275743
  { 297379441, 62, 12927111164ULL },   // factor: 7688514183390358649
  { 297868127, 62, 12907161328ULL },   // factor: 7689263939316385313
  { 298404361, 62, 12895776816ULL },   // factor: 7696312080754189153
  { 297271879, 62, 12956780172ULL },   // factor: 7703372775040766377
  { 297944293, 62, 12927806595ULL },   // factor: 7703532391976024671
  { 298714211, 62, 12897023580ULL },   // factor: 7705048445896190761
  { 297874721, 62, 12940249803ULL },   // factor: 7709146599477859927
  { 297536123, 62, 12964458348ULL },   // factor: 7714789347317809609
  { 299015963, 62, 12911452300ULL },   // factor: 7721460686426129801
  { 298883567, 62, 12921105517ULL },   // factor: 7723812213008678279
  { 299790443, 62, 12890076637ULL },   // factor: 7728643570620360383
  { 299746481, 62, 12914568700ULL },   // factor: 7742193042915489401
  { 299077049, 62, 12946076592ULL },   // factor: 7743748766526674017
  { 298232933, 62, 12996368496ULL },   // factor: 7751890189821757537
  { 298261087, 62, 12998508953ULL },   // factor: 7753898819402023823
  { 298987261, 62, 12975971784ULL },   // factor: 7759300525022887249
  { 299903423, 62, 12952153557ULL },   // factor: 7768790373931851223
  { 299031199, 62, 12990999257ULL },   // factor: 7769428168057638287
  { 298166809, 62, 13040840715ULL },   // factor: 7776691725337656871
  { 299777183, 62, 12974669905ULL },   // factor: 7779019988951555231
  { 297058649, 62, 13098222511ULL },   // factor: 7781880566838095279
  { 298794049, 62, 13046026212ULL },   // factor: 7796149990487224777
  { 298308553, 62, 13089405803ULL },   // factor: 7809363409445466119
  { 297397627, 62, 13138883832ULL },   // factor: 7814945746130933329
  { 299303399, 62, 13055637741ULL },   // factor: 7815193503987963319
  { 298430603, 62, 13096295173ULL },   // factor: 7816670531088758639
  { 299790817, 62, 13038854543ULL },   // factor: 7817857712380263263
  { 297926281, 62, 13126798688ULL },   // factor: 7821636629103038657
  { 299735021, 62, 13052275975ULL },   // factor: 7824448426928840951
  { 299936327, 62, 13070048944ULL },   // factor: 7840364947947177377
  { 299294641, 62, 13098455859ULL },   // factor: 7840595287947503239
  { 298428479, 62, 13155375361ULL },   // factor: 7851877319314611839
  { 298482469, 62, 13156536116ULL },   // factor: 7853990766782700809
  { 299979373, 62, 13098620052ULL },   // factor: 7858631660728374793
  { 297650141, 62, 13203852436ULL },   // factor: 7860257078637186953
  { 297860669, 62, 13247059615ULL },   // factor: 7891556078413564871
  { 297495463, 62, 13268769876ULL },   // factor: 7894797675402145177
  { 298873537, 62, 13207595727ULL },   // factor: 7894801700389152799
  { 297183611, 62, 13292590360ULL },   // factor: 7900680005457179921
  { 297176461, 62, 13302292844ULL },   // factor: 7906256621131090169
  { 297306943, 62, 13303573448ULL },   // factor: 7910489505601698929
  { 298500733, 62, 13254326847ULL },   // factor: 7912852558502157703
  { 298522429, 62, 13259142135ULL },   // factor: 7916302633192891831
  { 297382403, 62, 13313759892ULL },   // factor: 7918555819295960953
  { 297468103, 62, 13310132588ULL },   // factor: 7918679783261681129
  { 298034729, 62, 13286505400ULL },   // factor: 7919680072492073201
  { 299974019, 62, 13207749709ULL },   // factor: 7923963524309620943
  { 298307929, 62, 13286374395ULL },   // factor: 7926861659382155911
  { 298491203, 62, 13285833300ULL },   // factor: 7931408729148919801
  { 297633289, 62, 13342198800ULL },   // factor: 7942165022671706401
  { 299990969, 62, 13238106252ULL },   // factor: 7942624644524876377
  { 297475177, 62, 13350973580ULL },   // factor: 7943166457665647321
  { 299385767, 62, 13271416944ULL },   // factor: 7946546681912472097
  { 298884329, 62, 13309930860ULL },   // factor: 7956259508254985881
  { 297713719, 62, 13367683976ULL },   // factor: 7959485821823333489
  { 299778761, 62, 13289043208ULL },   // factor: 7967545815539410577
  { 299096797, 62, 13322990624ULL },   // factor: 7969727644198862657
  { 299211733, 62, 13338460887ULL },   // factor: 7982047995103974343
  { 299976499, 62, 13307519076ULL },   // factor: 7983885965588389849
  { 299474597, 62, 13341958308ULL },   // factor: 7991155174958203753
  { 299477683, 62, 13350307368ULL },   // factor: 7996238235812936689
  { 297145759, 62, 13459399101ULL },   // factor: 7998806723101125319
  { 298630237, 62, 13392472728ULL },   // factor: 7998794609557353073
  { 297586319, 62, 13458123205ULL },   // factor: 8009906690448864791
  { 299521903, 62, 13372149788ULL },   // factor: 8010503503405613129
  { 299834489, 62, 13366192531ULL },   // factor: 8015291014816003319
  { 298850521, 62, 13414199603ULL },   // factor: 8017681080309086327
  { 297594833, 62, 13472052291ULL },   // factor: 8018426303414824807
  { 299049929, 62, 13420855656ULL },   // factor: 8027011862092096849
  { 299454271, 62, 13407047396ULL },   // factor: 8029595208463256633
  { 298108189, 62, 13482259392ULL },   // factor: 8038343861954722177
  { 297265753, 62, 13523633615ULL },   // factor: 8040226259718174191
  { 299556143, 62, 13427066497ULL },   // factor: 8044320503291682143
  { 297286147, 62, 13533062508ULL },   // factor: 8046384020226953353
  { 297711203, 62, 13515047485ULL },   // factor: 8047162090722948911
  { 297220711, 62, 13538325969ULL },   // factor: 8047741740511887919
  { 298787471, 62, 13481288401ULL },   // factor: 8056080134312847743
  { 298387693, 62, 13500953367ULL },   // factor: 8057036656959424663
  { 297838907, 62, 13528675204ULL },   // factor: 8058731671834724057
  { 297807737, 62, 13535980800ULL },   // factor: 8062239620246899201
  { 298271377, 62, 13520695364ULL },   // factor: 8065672848435592457
  { 297779983, 62, 13554820508ULL },   // factor: 8072708440880582729
  { 299648023, 62, 13472043365ULL },   // factor: 8073742320185034791
  { 297940087, 62, 13556888933ULL },   // factor: 8078281336294714343
  { 298652971, 62, 13530314001ULL },   // factor: 8081736949923093943
  { 297719293, 62, 13576314900ULL },   // factor: 8083861747146731401
  { 299964151, 62, 13495330769ULL },   // factor: 8096230873174524239
  { 297509143, 62, 13609712585ULL },   // factor: 8098027855279329311
  { 297189553, 62, 13647952695ULL },   // factor: 8112057921584390671
  { 299880557, 62, 13535885667ULL },   // factor: 8118297866616553039
  { 298708601, 62, 13593450420ULL },   // factor: 8120961115442124841
  { 298787431, 62, 13596088568ULL },   // factor: 8124680749762377617
  { 299005139, 62, 13587936540ULL },   // factor: 8125725707731758121
  { 299336447, 62, 13579006992ULL },   // factor: 8129383413546874849
  { 298390679, 62, 13628649784ULL },   // factor: 8133324125801926673
  { 298191709, 62, 13640210264ULL },   // factor: 8134795219483002353
  { 299836931, 62, 13565253900ULL },   // factor: 8134728195223561801
  { 298356739, 62, 13638365180ULL },   // factor: 8138196320791896041
  { 298402441, 62, 13655571195ULL },   // factor: 8149711555674573991
  { 298699727, 62, 13651598688ULL },   // factor: 8155457602438316353
  { 297624601, 62, 13703297283ULL },   // factor: 8156876772474518167
  { 299484077, 62, 13620618664ULL },   // factor: 8158316817514026257
  { 299711669, 62, 13611048352ULL },   // factor: 8158780036835238977
  { 297839713, 62, 13727314652ULL },   // factor: 8177078912424749753
  { 297885307, 62, 13738223444ULL },   // factor: 8184829816501074617
  { 299471119, 62, 13678247660ULL },   // factor: 8192480265398663081
  { 297375937, 62, 13778586668ULL },   // factor: 8194840241864415833
  { 299222309, 62, 13714973715ULL },   // factor: 8207652205753215871
  { 298805281, 62, 13739843460ULL },   // factor: 8211075571922624521
  { 297208937, 62, 13817835580ULL },   // factor: 8213568448745156921
  { 299928511, 62, 13699668408ULL },   // factor: 8217842293610360977
  { 299761339, 62, 13723564377ULL },   // factor: 8227588067004441607
  { 298788533, 62, 13802198475ULL },   // factor: 8247877269040174351
  { 297782201, 62, 13864184431ULL },   // factor: 8257014709866225263
  { 297843163, 62, 13869380000ULL },   // factor: 8261800016097880001
  { 298294363, 62, 13857237053ULL },   // factor: 8267071399329264479
  { 299496929, 62, 13807335279ULL },   // factor: 8270509027467716383
  { 297294211, 62, 13915196685ULL },   // factor: 8273814838753781071
  { 299234647, 62, 13835760705ULL },   // factor: 8280277941074292271
  { 299936981, 62, 13807772671ULL },   // factor: 8282923298548092503
  { 298401841, 62, 13881886875ULL },   // factor: 8284761200107473751
  { 297278701, 62, 13943824611ULL },   // factor: 8290404134659820623
  { 299431669, 62, 13842909980ULL },   // factor: 8290011278256313241
  { 299864387, 62, 13849850353ULL },   // factor: 8306153772288157223
  { 299759791, 62, 13857331124ULL },   // factor: 8307741363096070169
  { 298313803, 62, 13935320997ULL },   // factor: 8314197205281643183
  { 298528037, 62, 13945032868ULL },   // factor: 8325966575969040233
  { 298362431, 62, 13963464325ULL },   // factor: 8332346322377548151
  { 299814421, 62, 13898046915ULL },   // factor: 8333669777703122431
  { 297958457, 62, 13986100764ULL },   // factor: 8334554006175922297
  { 297554423, 62, 14036429985ULL },   // factor: 8353203650333147311
  { 298844339, 62, 13981039764ULL },   // factor: 8356309173610591993
  { 297404047, 62, 14052449705ULL },   // factor: 8358510825061912271
  { 299021113, 62, 13982442888ULL },   // factor: 8362091269657388689
  { 297327487, 62, 14073772244ULL },   // factor: 8369038667837741657
  { 299585681, 62, 13970644699ULL },   // factor: 8370810212317910039
  { 299746093, 62, 13980037896ULL },   // factor: 8380923478635880657
  { 299400389, 62, 13998979380ULL },   // factor: 8382599743949957641
  { 298840697, 62, 14028578823ULL },   // factor: 8384620546769519263
  { 298577491, 62, 14042174036ULL },   // factor: 8385354183708447353
  { 298709557, 62, 14040865223ULL },   // factor: 8388281261318072423
  { 298511321, 62, 14063239635ULL },   // factor: 8396072481966815671
  { 298481647, 62, 14068051329ULL },   // factor: 8398110261520917727
  { 297766057, 62, 14104838820ULL },   // factor: 8399884480103865481
  { 299372897, 62, 14029462524ULL },   // factor: 8400081678325624057
  { 297870611, 62, 14111581005ULL },   // factor: 8406850512270688111
  { 299030077, 62, 14060467823ULL },   // factor: 8409005551535424743
  { 297380621, 62, 14143112584ULL },   // factor: 8411775206205669329
  { 299048329, 62, 14082769739ULL },   // factor: 8422857516279432263
  { 297532021, 62, 14155679864ULL },   // factor: 8423536077129850289
  { 299644913, 62, 14055148491ULL },   // factor: 8423107493575552567
  { 297353491, 62, 14166888608ULL },   // factor: 8425147568393861057
  { 299582057, 62, 14072624920ULL },   // factor: 8431811841846120881
  { 299645249, 62, 14075423587ULL },   // factor: 8435267611014176327
  { 297081683, 62, 14200130833ULL },   // factor: 8437197533375663879
  { 297017179, 62, 14218687616ULL },   // factor: 8446388969573110529
  { 299885969, 62, 14088316627ULL },   // factor: 8449776966533413127
  { 298378807, 62, 14163110460ULL },   // factor: 8451944004928042441
  { 297574787, 62, 14204937337ULL },   // factor: 8454062404812244439
  { 297018283, 62, 14245435212ULL },   // factor: 8462309414511961993
  { 299755243, 62, 14142028356ULL },   // factor: 8478294292731341017
  { 298611541, 62, 14212040180ULL },   // factor: 8487758437807434761
  { 299395307, 62, 14175779424ULL },   // factor: 8488323665225526337
  { 299560607, 62, 14173849437ULL },   // factor: 8491853881748656519
  { 298888043, 62, 14209502985ULL },   // factor: 8494101078378616711
  { 298006571, 62, 14277766708ULL },   // factor: 8509736596378076537
  { 298417793, 62, 14279022915ULL },   // factor: 8522229008981453191
  { 297806321, 62, 14312029443ULL },   // factor: 8524425668927018407
  { 299275703, 62, 14248388197ULL },   // factor: 8528392788548154983
  { 299944793, 62, 14225031727ULL },   // factor: 8533448393546895023
  { 299864101, 62, 14237628656ULL },   // factor: 8538707434606556513
  { 298930897, 62, 14307691515ULL },   // factor: 8554022117156477911
  { 298656089, 62, 14331562096ULL },   // factor: 8560416569704005089
  { 297992417, 62, 14372531443ULL },   // factor: 8565810766216135463
  { 299822293, 62, 14311460715ULL },   // factor: 8581789935501438991
  { 299204179, 62, 14348171417ULL },   // factor: 8586065697949503287
  { 298204061, 62, 14403910135ULL },   // factor: 8590608993072116471
  { 297786611, 62, 14432150884ULL },   // factor: 8595402602374028249
  { 299727353, 62, 14352605892ULL },   // factor: 8603737145322727753
  { 298388281, 62, 14433728019ULL },   // factor: 8613710584021890679
  { 297160939, 62, 14496276344ULL },   // factor: 8615454180773054033
  { 298584557, 62, 14430495327ULL },   // factor: 8617446109005730279
  { 297928661, 62, 14468714275ULL },   // factor: 8621289340684671551
  { 297775067, 62, 14487279064ULL },   // factor: 8627900987860594577
  { 299292523, 62, 14457846317ULL },   // factor: 8654250602722375583
  { 298401869, 62, 14507588055ULL },   // factor: 8658182780588149591
  { 299461727, 62, 14461826140ULL },   // factor: 8661526862916287561
  { 299250353, 62, 14515687555ULL },   // factor: 8687649249742913831
  { 297949213, 62, 14581768863ULL },   // factor: 8689253113757509639
  { 298598747, 62, 14557078864ULL },   // factor: 8693451017541166817
  { 299218981, 62, 14535361008ULL },   // factor: 8698511818561785697
  { 297143059, 62, 14641686320ULL },   // factor: 8701350924086505761
  { 297139181, 62, 14669440663ULL },   // factor: 8717731168663834007
  { 299905157, 62, 14535410440ULL },   // factor: 8718489100135278161
  { 299654647, 62, 14583895305ULL },   // factor: 8740263999009464671
  { 297364129, 62, 14699422979ULL },   // factor: 8742162221905840583
  { 299745889, 62, 14594521004ULL },   // factor: 8749295345746305113
  { 299371273, 62, 14630036088ULL },   // factor: 8759625055401000049
  { 299783101, 62, 14616719291ULL },   // factor: 8763690871005002783
  { 297958021, 62, 14718506720ULL },   // factor: 8770994268732802241
  { 298118959, 62, 14712961661ULL },   // factor: 8772425628368461799
  { 298148549, 62, 14734453471ULL },   // factor: 8786111845373327159
  { 298880437, 62, 14703988064ULL },   // factor: 8789468756422207937
  { 299602181, 62, 14680589260ULL },   // factor: 8796673121322352121
  { 299309027, 62, 14696503357ULL },   // factor: 8797592240171807279
  { 298543813, 62, 14739451656ULL },   // factor: 8800744197822808657
  { 299924683, 62, 14672208852ULL },   // factor: 8801115177691787833
  { 297127613, 62, 14812471240ULL },   // factor: 8802388444344700241
  { 297944219, 62, 14771884777ULL },   // factor: 8802395346082508327
  { 299543539, 62, 14709250025ULL },   // factor: 8812121617048676951
  { 298417261, 62, 14768972691ULL },   // factor: 8814632756464038703
  { 297214061, 62, 14840224711ULL },   // factor: 8821446905017722743
  { 298473083, 62, 14802079141ULL },   // factor: 8836044392048523407
  { 299730713, 62, 14744051511ULL },   // factor: 8838490143801514687
  { 297081263, 62, 14877403272ULL },   // factor: 8839595508412185073
  { 297296491, 62, 14868258864ULL },   // factor: 8840562375093692449
  { 298178149, 62, 14824226196ULL },   // factor: 8840520654961182409
  { 297106903, 62, 14879723181ULL },   // factor: 8841736943608436887
  { 298494589, 62, 14810431251ULL },   // factor: 8841667178360001679
  { 299894141, 62, 14746293556ULL },   // factor: 8844654077820910793
  { 297471833, 62, 14868635296ULL },   // factor: 8846000391419235137
  { 299778163, 62, 14782228572ULL },   // factor: 8862778652720546473
  { 298952867, 62, 14825508225ULL },   // factor: 8864256377191662151
  { 299481683, 62, 14813485692ULL },   // factor: 8872735252273159273
  { 299014699, 62, 14839291401ULL },   // factor: 8874332503286606599
  { 298053523, 62, 14898526121ULL },   // factor: 8881116395743148567
  { 298584151, 62, 14873301248ULL },   // factor: 8881864051402640897
  { 297034613, 62, 14958946755ULL },   // factor: 8886649920518061631
  { 297570121, 62, 14958412211ULL },   // factor: 8902353063190295063
  { 297393659, 62, 14995472245ULL },   // factor: 8919116718746988911
  { 297266323, 62, 15003381600ULL },   // factor: 8920000161595713601
  { 298593173, 62, 14937415176ULL },   // factor: 8920420387640386897
  { 297298879, 62, 15008891396ULL },   // factor: 8924253174127090169
  { 299109149, 62, 14922648871ULL },   // factor: 8927001609261241559
  { 299810191, 62, 14892433161ULL },   // factor: 8929806460908287503
  { 299649341, 62, 14913021136ULL },   // factor: 8937353911442942753
  { 297575689, 62, 15022850636ULL },   // factor: 8940870257503576409
  { 297904877, 62, 15015631635ULL },   // factor: 8946459790603967791
  { 298771777, 62, 14974252779ULL },   // factor: 8947768224058036567
  { 299399213, 62, 14952096600ULL },   // factor: 8953291909479951601
  { 299709001, 62, 14937829455ULL },   // factor: 8954003886132848911
  { 297623663, 62, 15051025173ULL },   // factor: 8959082487786937399
  { 297154321, 62, 15084777071ULL },   // factor: 8965013375938747583
  { 298501019, 62, 15036186921ULL },   // factor: 8976634235585944999
  { 297296683, 62, 15100121252ULL },   // factor: 8978431922234814233
  { 299430679, 62, 15012234005ULL },   // factor: 8990246842848078791
  { 298144433, 62, 15083614387ULL },   // factor: 8994191318005515143
  { 298369829, 62, 15089158116ULL },   // factor: 9004299053649764329
  { 299303663, 62, 15046198152ULL },   // factor: 9006764442234861553
  { 297250699, 62, 15152179772ULL },   // factor: 9007992057201321257
  { 297160751, 62, 15166382085ULL },   // factor: 9013706980663091671
  { 299981593, 62, 15026339535ULL },   // factor: 9015250541336358511
  { 299960047, 62, 15033568584ULL },   // factor: 9018939878068726897
  { 299555939, 62, 15055502901ULL },   // factor: 9019930617252558079
  { 298703477, 62, 15102117864ULL },   // factor: 9022110232081226257
  { 299363959, 62, 15079681725ULL },   // factor: 9028626443311898551
  { 297755369, 62, 15163142232ULL },   // factor: 9029814020977287217
  { 299438873, 62, 15079222143ULL },   // factor: 9030610568433129679
  { 297016219, 62, 15206757984ULL },   // factor: 9033307519311484993
  { 297183709, 62, 15198330560ULL },   // factor: 9033392492857694081
  { 299336707, 62, 15091950549ULL },   // factor: 9035149559089004287
  { 299549053, 62, 15085666487ULL },   // factor: 9037794220109373623
  { 297627541, 62, 15190962831ULL },   // factor: 9042497825625857143
  { 297661841, 62, 15188734924ULL },   // factor: 9042213599877670169
  { 299256721, 62, 15110697135ULL },   // factor: 9043955353288388671
  { 297980273, 62, 15189970915ULL },   // factor: 9052623360227519591
  { 298447483, 62, 15181701233ULL },   // factor: 9061881041293693079
  { 299912647, 62, 15113781984ULL },   // factor: 9065628722004703297
  { 297175121, 62, 15261026035ULL },   // factor: 9070394517070550471
  { 298140083, 62, 15214359981ULL },   // factor: 9072021095054436847
  { 297527627, 62, 15250334557ULL },   // factor: 9074791703400612479
  { 297670727, 62, 15243671700ULL },   // factor: 9075189674176651801
  { 298839883, 62, 15185151012ULL },   // factor: 9075857503526823193
  { 297010733, 62, 15280780915ULL },   // factor: 9077111880753121391
  { 299933003, 62, 15137585857ULL },   // factor: 9080523168520677143
  { 297385247, 62, 15279054472ULL },   // factor: 9087530776164349169
  { 297240337, 62, 15293690880ULL },   // factor: 9091803662290053121
  { 298816451, 62, 15215181880ULL },   // factor: 9093093301402215761
  { 298719023, 62, 15237972297ULL },   // factor: 9103744394121811663
  { 299407411, 62, 15218959440ULL },   // factor: 9113338488088819681
  { 298598753, 62, 15284781111ULL },   // factor: 9128033159245109167
  { 297747833, 62, 15342647995ULL },   // factor: 9136480385986089671
  { 298632041, 62, 15310101703ULL },   // factor: 9144173838968931647
  { 298647631, 62, 15312543780ULL },   // factor: 9146109848961570361
  { 299517871, 62, 15280276124ULL },   // factor: 9153431545905224009
  { 299953141, 62, 15261586448ULL },   // factor: 9155521583441266337
  { 297050627, 62, 15415283352ULL },   // factor: 9158239170188523409
  { 298170823, 62, 15358522241ULL },   // factor: 9158926433325548687
  { 298345181, 62, 15357030276ULL },   // factor: 9163391954631399913
  { 298021223, 62, 15378603453ULL },   // factor: 9166300418190166039
  { 298265687, 62, 15365825209ULL },   // factor: 9166196824568607167
  { 297486029, 62, 15428314267ULL },   // factor: 9179415890907751487
  { 297382339, 62, 15434848592ULL },   // factor: 9180102752799633377
  { 297476539, 62, 15433689660ULL },   // factor: 9182321168113773481
  { 299796239, 62, 15318763956ULL },   // factor: 9185015640275122969
  { 299829973, 62, 15327363152ULL },   // factor: 9191205760050709793
  { 299666351, 62, 15339709393ULL },   // factor: 9193589478401469887
  { 299641273, 62, 15345452240ULL },   // factor: 9196261687908603041
  { 299808727, 62, 15338305905ULL },   // factor: 9197115935429265871
  { 299945377, 62, 15331991480ULL },   // factor: 9197519929258775921
  { 299110507, 62, 15378678300ULL },   // factor: 9199848526605796201
  { 298958021, 62, 15396659380ULL },   // factor: 9205909636511773961
  { 297326423, 62, 15493252656ULL },   // factor: 9213106785687458977
  { 298383781, 62, 15453372620ULL },   // factor: 9222071503114952441
  { 297750913, 63, 15491054543ULL },   // factor: 9224951267022095519
  { 299653889, 63, 15392087595ULL },   // factor: 9224597815340813911
  { 299112523, 63, 15446604477ULL },   // factor: 9240545673797130943
  { 299606213, 63, 15437246535ULL },   // factor: 9250189946997443911
  { 299750179, 63, 15430354136ULL },   // factor: 9250502828598780689
  { 298616039, 63, 15492285472ULL },   // factor: 9252489845411770817
  { 298181623, 63, 15519036737ULL },   // factor: 9254983123270568303
  { 299374651, 63, 15461965260ULL },   // factor: 9257840906973248521
  { 299898607, 63, 15439135485ULL },   // factor: 9260350450471538791
  { 298844839, 63, 15495600969ULL },   // factor: 9261560753578097983
  { 298329463, 63, 15535928453ULL },   // factor: 9269650385179821479
  { 299120299, 63, 15500367269ULL },   // factor: 9272948984226186863
  { 299412331, 63, 15496900676ULL },   // factor: 9279926309353271513
  { 298996213, 63, 15528117507ULL },   // factor: 9285696659224001983
  { 299332877, 63, 15529634403ULL },   // factor: 9297060289216334863
  { 297178319, 63, 15663121120ULL },   // factor: 9309480009469994561
  { 299551591, 63, 15539595153ULL },   // factor: 9309820903154076847
  { 297319381, 63, 15660126623ULL },   // factor: 9312118307863960727
  { 299766161, 63, 15559780720ULL },   // factor: 9328591464872431841
  { 299387483, 63, 15587048965ULL },   // factor: 9333134714058210191
  { 299357321, 63, 15598944795ULL },   // factor: 9339316648516188391
  { 298466023, 63, 15647099916ULL },   // factor: 9340255366824308137
  { 298397087, 63, 15652981369ULL },   // factor: 9341608086749744207
  { 299111647, 63, 15618907304ULL },   // factor: 9343594176079539377
  { 299653451, 63, 15591770140ULL },   // factor: 9344255459299506281
  { 297555707, 63, 15704995668ULL },   // factor: 9346222178847354553
  { 298029007, 63, 15682606289ULL },   // factor: 9347743158965250047
  { 299428601, 63, 15611457903ULL },   // factor: 9349033998931367407
  { 297569843, 63, 15716551245ULL },   // factor: 9353543372952209071
  { 299960827, 63, 15598374953ULL },   // factor: 9357802901515932263
  { 297765989, 63, 15715593459ULL },   // factor: 9359138458082131903
  { 298789661, 63, 15666249976ULL },   // factor: 9361827038940596273
  { 298447987, 63, 15689359449ULL },   // factor: 9364915489746958327
  { 299495173, 63, 15639097212ULL },   // factor: 9367668250143515353
  { 297471599, 63, 15766751301ULL },   // factor: 9380321441087600599
  { 297250441, 63, 15779022816ULL },   // factor: 9380642981210123713
  { 297614351, 63, 15764944320ULL },   // factor: 9383747344695872641
  { 298261237, 63, 15732052560ULL },   // factor: 9384522914189233441
  { 298091639, 63, 15745127064ULL },   // factor: 9386981465542035793
  { 298348223, 63, 15742616973ULL },   // factor: 9393563598528377959
  { 298891027, 63, 15716878949ULL },   // factor: 9395268180602581247
  { 298131409, 63, 15761409135ULL },   // factor: 9397942226486042431
  { 298412333, 63, 15767148016ULL },   // factor: 9410222848421762657
  { 298284157, 63, 15793060160ULL },   // factor: 9421639272551770241
  { 299308127, 63, 15744737685ULL },   // factor: 9425055893207331991
  { 299635751, 63, 15727360644ULL },   // factor: 9424959035625567289
  { 299413117, 63, 15753590124ULL },   // factor: 9433663045934513017
  { 297244307, 63, 15875708337ULL },   // factor: 9437927845531374919
  { 297593641, 63, 15880732431ULL },   // factor: 9452009971776142543
  { 298439417, 63, 15839051044ULL },   // factor: 9453994318809202697
  { 299779637, 63, 15770263483ULL },   // factor: 9455207724656191343
  { 298135267, 63, 15858696317ULL },   // factor: 9456073321481423279
  { 299923363, 63, 15765606125ULL },   // factor: 9456947217486796751
  { 297015713, 63, 15950987803ULL },   // factor: 9475388030724697079
  { 299405461, 63, 15850352255ULL },   // factor: 9491364047841329111
  { 297699167, 63, 15962206440ULL },   // factor: 9503871121340070961
  { 298535323, 63, 15930956400ULL },   // factor: 9511906429145834401
  { 298764923, 63, 15925870848ULL },   // factor: 9516183155221329409
  { 299454049, 63, 15894535292ULL },   // factor: 9519365900325594617
  { 299234633, 63, 15907535395ULL },   // factor: 9520171031714670071
  { 297835361, 63, 15998091331ULL },   // factor: 9529594613758710983
  { 297792959, 63, 16006476189ULL },   // factor: 9533231814970706503
  { 299348407, 63, 15942183000ULL },   // factor: 9544534170304962001
  { 298205851, 63, 16025884848ULL },   // factor: 9558025258251691297
  { 298530941, 63, 16025391631ULL },   // factor: 9568150486991909543
  { 299238967, 63, 15988755492ULL },   // factor: 9568917354083313529
  { 298013411, 63, 16059355356ULL },   // factor: 9571806536205358633
  { 298966223, 63, 16016037705ULL },   // factor: 9576508600178876431
  { 299449897, 63, 16001682644ULL },   // factor: 9583404439144975337
  { 299571589, 63, 15997450760ULL },   // factor: 9584763488244915281
  { 299094247, 63, 16025192373ULL },   // factor: 9586085691665156263
  { 297381883, 63, 16120996725ULL },   // factor: 9588184723834666351
  { 297458461, 63, 16127841579ULL },   // factor: 9594725870682299839
  { 298433557, 63, 16080040559ULL },   // factor: 9597647401453276727
  { 299627453, 63, 16050056931ULL },   // factor: 9618075357481053487
  { 299945551, 63, 16033768473ULL },   // factor: 9618515038480827247
  { 299354813, 63, 16082893596ULL },   // factor: 9628983209858955097
  { 297117263, 63, 16219077525ULL },   // factor: 9637935845225628151
  { 297168457, 63, 16224194724ULL },   // factor: 9642637824397241737
  { 298311623, 63, 16168721752ULL },   // factor: 9646635255349046993
  { 298067197, 63, 16193354675ULL },   // factor: 9653415676008191951
  { 298683841, 63, 16167477804ULL },   // factor: 9657928739561930329
  { 299788091, 63, 16133643225ULL },   // factor: 9673348206595666951
  { 298815031, 63, 16192189548ULL },   // factor: 9676939243486991977
  { 297390617, 63, 16271740728ULL },   // factor: 9678126029527898353
  { 299525489, 63, 16157111364ULL },   // factor: 9678933364259113993
  { 298840051, 63, 16196506460ULL },   // factor: 9680329633056458921
  { 298474867, 63, 16224648329ULL },   // factor: 9685299504240094487
  { 299347099, 63, 16177515404ULL },   // factor: 9685384610430425993
  { 297164477, 63, 16319011843ULL },   // factor: 9698861238963802223
  { 299007017, 63, 16218264147ULL },   // factor: 9698749567025038999
  { 298362553, 63, 16269765983ULL },   // factor: 9708577830800869199
  { 298200883, 63, 16285824773ULL },   // factor: 9712894655383749119
  { 298069049, 63, 16303598139ULL },   // factor: 9719195985139799623
  { 298413503, 63, 16290582937ULL },   // factor: 9722659840284396623
  { 299369611, 63, 16247490644ULL },   // factor: 9728009907640838969
  { 299269667, 63, 16260574120ULL },   // factor: 9732593204242436081
  { 299101963, 63, 16271106536ULL },   // factor: 9733439810199460337
  { 297053051, 63, 16400962936ULL },   // factor: 9743912158953435473
  { 297056107, 63, 16403926089ULL },   // factor: 9745772847028151047
  { 298729759, 63, 16313933324ULL },   // factor: 9746914740441177833
  { 297569497, 63, 16383728172ULL },   // factor: 9750595502253538969
  { 297680683, 63, 16379153661ULL },   // factor: 9751515297536860927
  { 298271161, 63, 16358907164ULL },   // factor: 9758780464994994809
  { 297988487, 63, 16394956728ULL },   // factor: 9771016699614381073
  { 297720011, 63, 16427727784ULL },   // factor: 9781726593114971249
  { 297504821, 63, 16445245096ULL },   // factor: 9785079397173215633
  { 299523121, 63, 16345840176ULL },   // factor: 9791914129765418593
  { 297347419, 63, 16470309824ULL },   // factor: 9794808232593488513
  { 298543057, 63, 16444798559ULL },   // factor: 9818960867106109727
  { 299963369, 63, 16381773024ULL },   // factor: 9827863652944715713
  { 297707497, 63, 16525851255ULL },   // factor: 9839739625840717471
  { 298498027, 63, 16481678744ULL },   // factor: 9839497173463676177
  { 298246867, 63, 16527346569ULL },   // factor: 9858458668054898647
  { 298518799, 63, 16512424284ULL },   // factor: 9858538131676229833
  { 298099891, 63, 16540519449ULL },   // factor: 9861454089660560119
  { 299595277, 63, 16467710315ULL },   // factor: 9867296466756364511
  { 299012723, 63, 16507803288ULL },   // factor: 9872086423786466449
  { 299797319, 63, 16471004109ULL },   // factor: 9875925746232367543
  { 299433769, 63, 16525318655ULL },   // factor: 9896476897585321391
  { 299844673, 63, 16507511955ULL },   // factor: 9899379048381131431
  { 298324967, 63, 16618807860ULL },   // factor: 9915610612827681241
  { 299082397, 63, 16580035883ULL },   // factor: 9917593748467303103
  { 297408407, 63, 16675950049ULL },   // factor: 9919135478569323887
  { 297665341, 63, 16671250764ULL },   // factor: 9924907087125141049
  { 297906839, 63, 16664473177ULL },   // factor: 9928921055520715007
  { 299896661, 63, 16564711660ULL },   // factor: 9935403434523534521
  { 299169001, 63, 16616927276ULL },   // factor: 9942539065701142553
  { 299685679, 63, 16589285265ULL },   // factor: 9943142437532439871
  { 297191957, 63, 16729793067ULL },   // factor: 9943919883573524239
  { 297111247, 63, 16752405777ULL },   // factor: 9954656341308947839
  { 297711389, 63, 16718506636ULL },   // factor: 9954579665218554809
  { 299397971, 63, 16654070053ULL },   // factor: 9972389565520124927
  { 298568189, 63, 16712392224ULL },   // factor: 9979577360354724673
  { 299741851, 63, 16663049021ULL },   // factor: 9989226313716555743
  { 297531497, 63, 16795418860ULL },   // factor: 9994332232315666841
  { 297020197, 63, 16828345740ULL },   // factor: 9996717133757821561
  { 298313063, 63, 16760156961ULL },   // factor: 9999547518793363087
  { 299387201, 63, 16716874420ULL },   // factor: 10009636484144596841
  { 299924777, 63, 16693814907ULL },   // factor: 10013777426522501479
  { 299683543, 63, 16717105025ULL },   // factor: 10019682525190207151
  { 299806861, 63, 16715019584ULL },   // factor: 10022555106065131649
  { 299796769, 63, 16731230840ULL },   // factor: 10031937894450311921
  { 297304081, 63, 16885531784ULL },   // factor: 10040275018476821009
  { 297108481, 63, 16898594459ULL },   // factor: 10041431461497013559
  { 297366383, 63, 16892454837ULL },   // factor: 10046496389739089143
  { 299956091, 63, 16754617821ULL },   // factor: 10051299335572195423
  { 298694213, 63, 16826740272ULL },   // factor: 10052099885800891873
  { 299289149, 63, 16809863719ULL },   // factor: 10062019614530970263
  { 298781551, 63, 16848105609ULL },   // factor: 10067806250537639119
  { 297553981, 63, 16920118260ULL },   // factor: 10069297094507586121
  { 297131203, 63, 16946793072ULL },   // factor: 10070842024950851233
  { 299423711, 63, 16844875564ULL },   // factor: 10087510305412196009
  { 297827857, 63, 16959742727ULL },   // factor: 10102167663307492079
  { 298760281, 63, 16928914059ULL },   // factor: 10115374242583381159
  { 297009179, 63, 17084338120ULL },   // factor: 10148410477559206961
  { 299810057, 63, 16936717023ULL },   // factor: 10155596192117000623
  { 297179489, 63, 17088489516ULL },   // factor: 10156697164293474649
  { 299049931, 63, 16998426885ULL },   // factor: 10166756774135589871
  { 297116137, 63, 17142168552ULL },   // factor: 10186429799946247249
  { 298955581, 63, 17051040960ULL },   // factor: 10195007713703195521
  { 297898399, 63, 17141549709ULL },   // factor: 10212880429380031783
  { 298257539, 63, 17143260940ULL },   // factor: 10226213636798453321
  { 298715947, 63, 17118307265ULL },   // factor: 10227022731402909911
  { 298775329, 63, 17117974760ULL },   // factor: 10228857081465392081
  { 299493793, 63, 17080363907ULL },   // factor: 10230925944655458503
  { 299271919, 63, 17103785232ULL },   // factor: 10237365257089000417
  { 299518469, 63, 17089969396ULL },   // factor: 10237522937493549449
  { 297879311, 63, 17195901424ULL },   // factor: 10244606536410077729
  { 297415567, 63, 17238097212ULL },   // factor: 10253756912616198409
  { 297657587, 63, 17231437977ULL },   // factor: 10258136497547962999
  { 297262159, 63, 17279020149ULL },   // factor: 10272797669792483383
  { 299171849, 63, 17205890095ULL },   // factor: 10295035906823871311
  { 297774419, 63, 17307254332ULL },   // factor: 10307315206393066217
  { 297830317, 63, 17303453727ULL },   // factor: 10306986217414482919
  { 299222167, 63, 17232983673ULL },   // factor: 10312981437021358783
  { 298271299, 63, 17295073145ULL },   // factor: 10317247866518330711
  { 298210223, 63, 17328033085ULL },   // factor: 10334793220858455911
  { 298952117, 63, 17295312303ULL },   // factor: 10340940454315990903
  { 297293351, 63, 17413347456ULL },   // factor: 10353744834643130113
  { 297391747, 63, 17411851569ULL },   // factor: 10356281913219202087
  { 299897449, 63, 17273791532ULL },   // factor: 10360732030009203737
  { 298972379, 63, 17330417124ULL },   // factor: 10362632073249235993
  { 297818249, 63, 17412845500ULL },   // factor: 10371726313835059001
  { 298093171, 63, 17397097208ULL },   // factor: 10371911745855933137
  { 299257019, 63, 17329811664ULL },   // factor: 10372135556800139233
  { 297270179, 63, 17446213816ULL },   // factor: 10372478207909186129
  { 299802883, 63, 17308207401ULL },   // factor: 10378100956763474167
  { 298097353, 63, 17419052592ULL },   // factor: 10385146938885977953
  { 299339797, 63, 17379657968ULL },   // factor: 10404846576141104993
  { 298541629, 63, 17429421891ULL },   // factor: 10406816007734800879
  { 298345559, 63, 17442598476ULL },   // factor: 10407843585469536169
  { 299407873, 63, 17380442975ULL },   // factor: 10407682925885084351
  { 299541911, 63, 17375821489ULL },   // factor: 10409573548019850959
  { 299060837, 63, 17420820460ULL },   // factor: 10419770295988650041
  { 299037721, 63, 17428649240ULL },   // factor: 10423647097675964081
  { 299126969, 63, 17424861444ULL },   // factor: 10424491977977366473
  { 298099651, 63, 17492623605ULL },   // factor: 10429089983449723711
  { 298394827, 63, 17475922028ULL },   // factor: 10429449460421098313
  { 298030877, 63, 17509009404ULL },   // factor: 10436450856150734617
  { 297767467, 63, 17545295724ULL },   // factor: 10448836531002822217
  { 298134167, 63, 17561080384ULL },   // factor: 10471116143807760257
  { 299040349, 63, 17533197971ULL },   // factor: 10486267280667863759
  { 298684037, 63, 17564646499ULL },   // factor: 10492559049598472927
  { 297685327, 63, 17624792004ULL },   // factor: 10493283942035450617
  { 297794993, 63, 17629547320ULL },   // factor: 10499981841505137521
  { 297370433, 63, 17674025256ULL },   // factor: 10511465086459311697
  { 298245139, 63, 17631789276ULL },   // factor: 10517190886878658729
  { 299643647, 63, 17562014905ULL },   // factor: 10524692389605117071
  { 297708727, 63, 17696879097ULL },   // factor: 10537030695681559039
  { 297828623, 63, 17698013472ULL },   // factor: 10541949964402418113
  { 297818497, 63, 17704004507ULL },   // factor: 10545160026311931959
  { 299314153, 63, 17625230967ULL },   // factor: 10550962156633951903
  { 299494681, 63, 17619010404ULL },   // factor: 10553599800963322249
  { 297548099, 63, 17751280729ULL },   // factor: 10563719671458568343
  { 297039493, 63, 17821894931ULL },   // factor: 10587613269207019967
  { 298844549, 63, 17714896920ULL },   // factor: 10588000761277778161
  { 298771399, 63, 17724319077ULL },   // factor: 10591039213915357447
  { 297482761, 63, 17806773683ULL },   // factor: 10594416399441957527
  { 298482563, 63, 17754257032ULL },   // factor: 10598672286144266033
  { 298192133, 63, 17799573703ULL },   // factor: 10615385697976556999
  { 298751969, 63, 17769242280ULL },   // factor: 10617192237576098641
  { 299645503, 63, 17716244132ULL },   // factor: 10617185768407876793
  { 297460721, 63, 17888494075ULL },   // factor: 10642248690307456151
  { 299522243, 63, 17766880812ULL },   // factor: 10643151983847802633
  { 297418447, 63, 17894066484ULL },   // factor: 10644050928372060697
  { 299798507, 63, 17783248053ULL },   // factor: 10662782431800113743
  { 297127709, 63, 17949426439ULL },   // factor: 10666543911368196503
  { 297314623, 63, 17938345640ULL },   // factor: 10666664942400587441
  { 297416711, 63, 17939379396ULL },   // factor: 10670942434678973113
  { 298681081, 63, 17866785735ULL },   // factor: 10672941754650359071
  { 299532209, 63, 17819978419ULL },   // factor: 10675315000350795143
  { 299373377, 63, 17833846824ULL },   // factor: 10677957897203209297
  { 299903867, 63, 17808833413ULL },   // factor: 10681876014635016143
  { 299429833, 63, 17860995248ULL },   // factor: 10696229648644867169
  { 297578419, 63, 17979452436ULL },   // factor: 10700594060781157369
  { 297535339, 63, 17991796997ULL },   // factor: 10706390837443153967
  { 299170231, 63, 17907059021ULL },   // factor: 10714517967686407703
  { 299801759, 63, 17872062820ULL },   // factor: 10716151740789000761
  { 298799569, 63, 17935021335ULL },   // factor: 10717953289807609231
  { 299528953, 63, 17915933207ULL },   // factor: 10732681431021284543
  { 299974757, 63, 17924219947ULL },   // factor: 10753627046031755759
  { 298171817, 63, 18089895759ULL },   // factor: 10787794175603248207
  { 299509523, 63, 18014146125ULL },   // factor: 10790816626302096751
  { 297497789, 63, 18141913455ULL },   // factor: 10794358282183701991
  { 299417177, 63, 18027232080ULL },   // factor: 10795325877034876321
  { 299128717, 63, 18046775028ULL },   // factor: 10796617320226558153
  { 297760051, 63, 18153332048ULL },   // factor: 10810674152864828897
  { 299068351, 63, 18083490665ULL },   // factor: 10816399467010886831
  { 299708719, 63, 18046395597ULL },   // factor: 10817324213888220487
  { 297451607, 63, 18198791169ULL },   // factor: 10826519357352917167
  { 299304673, 63, 18087044163ULL },   // factor: 10827073677486547399
  { 298913513, 63, 18114652135ULL },   // factor: 10829428612891600511
  { 297089929, 63, 18228985959ULL },   // factor: 10831296288602613823
  { 299933443, 63, 18067406901ULL },   // factor: 10838039115797780287
  { 298814471, 63, 18150378265ULL },   // factor: 10847191359411745631
  { 299926819, 63, 18093661392ULL },   // factor: 10853548610731344097
  { 297715793, 63, 18237435072ULL },   // factor: 10859144889492984193
  { 297049969, 63, 18279927704ULL },   // factor: 10860103915590882353
  { 297781607, 63, 18247666108ULL },   // factor: 10867638675279351113
  { 297415997, 63, 18276623128ULL },   // factor: 10871520178814757233
  { 298201933, 63, 18234596268ULL },   // factor: 10875183709184372089
  { 297815209, 63, 18269318580ULL },   // factor: 10881761862380566441
  { 298115533, 63, 18252995096ULL },   // factor: 10883002723780852337
  { 298440061, 63, 18238077815ULL },   // factor: 10885946111262693431
  { 299930221, 63, 18162173124ULL },   // factor: 10894769197843160809
  { 297179479, 63, 18332936604ULL },   // factor: 10896345097033498633
  { 297291079, 63, 18325756152ULL },   // factor: 10896167639837936017
  { 298799869, 63, 18254245856ULL },   // factor: 10908732540933185729
  { 299481691, 63, 18211880804ULL },   // factor: 10908249718944719129
  { 297822907, 63, 18322230584ULL },   // factor: 10913559950502375377
  { 299565671, 63, 18217296085ULL },   // factor: 10914553051017396071
  { 298521827, 63, 18287829304ULL },   // factor: 10918632431388436817
  { 299983961, 63, 18210239076ULL },   // factor: 10925559297550920073
  { 298238081, 63, 18332955783ULL },   // factor: 10935171103559544847
  { 299994697, 63, 18246997748ULL },   // factor: 10948005121141884713
  { 299684137, 63, 18284527040ULL },   // factor: 10959165412871128961
  { 298582621, 63, 18357758111ULL },   // factor: 10962615064932777863
  { 299446333, 63, 18314851188ULL },   // factor: 10968630055374587209
  { 297671923, 63, 18432092892ULL },   // factor: 10973433072152542633
  { 297376109, 63, 18488074920ULL },   // factor: 10995823565220172561
  { 299229173, 63, 18378451852ULL },   // factor: 10998737897388556793
  { 299170387, 63, 18393677420ULL },   // factor: 11005687184189123081
  { 299403131, 63, 18390822073ULL },   // factor: 11012539420640221127
  { 298752733, 63, 18433531275ULL },   // factor: 11014135694494449151
  { 299594311, 63, 18401165169ULL },   // factor: 11025768800807507119
  { 298872227, 63, 18446293404ULL },   // factor: 11026169579097781417
  { 299805463, 63, 18394246820ULL },   // factor: 11029391368812755321
  { 299978423, 63, 18388718761ULL },   // factor: 11032437709830587807
  { 299900131, 63, 18414373584ULL },   // factor: 11044946100249079009
  { 299107621, 63, 18463545839ULL },   // factor: 11045174542255478039
  { 297893879, 63, 18550292289ULL },   // factor: 11052037053107998063
  { 298555171, 63, 18512804556ULL },   // factor: 11054187059812318153
  { 299420629, 63, 18472167099ULL },   // factor: 11061895783551370543
  { 298328663, 63, 18546657933ULL },   // factor: 11065999328540467159
  { 298656343, 63, 18537717672ULL },   // factor: 11072813934971986993
  { 297601901, 63, 18610727971ULL },   // factor: 11077176046326945743
  { 297958783, 63, 18587545112ULL },   // factor: 11076644641058237393
  { 299041471, 63, 18521906096ULL },   // factor: 11077636089343414433
  { 299062073, 63, 18522234391ULL },   // factor: 11078595627128705087
  { 297514313, 63, 18625398315ULL },   // factor: 11082645168077165191
  { 299472421, 63, 18503696531ULL },   // factor: 11082693595175743103
  { 297700133, 63, 18625784092ULL },   // factor: 11089796802835368473
  { 298997507, 63, 18554465473ULL },   // factor: 11095477840289151623
  { 298713677, 63, 18578683948ULL },   // factor: 11099413991855913593
  { 299329207, 63, 18553553385ULL },   // factor: 11107240843528431391
  { 299544601, 63, 18587329599ULL },   // factor: 11135468456775889999
  { 298530913, 63, 18662207336ULL },   // factor: 11142491589222755537
  { 299616913, 63, 18605246123ULL },   // factor: 11148892817956956599
  { 297714707, 63, 18775953357ULL },   // factor: 11179754904649842799
  { 298523627, 63, 18760605945ULL },   // factor: 11200968262838325031
  { 299483341, 63, 18705933375ULL },   // factor: 11204230847336811751
  { 299579873, 63, 18719378920ULL },   // factor: 11215898318984954321
  { 297262747, 63, 18870417948ULL },   // factor: 11218944552521166313
  { 297343637, 63, 18893534995ULL },   // factor: 11235744822400153631
  { 297682447, 63, 18879885444ULL },   // factor: 11240420996099202937
  { 299596621, 63, 18763034915ULL },   // factor: 11242683720478044431
  { 299133871, 63, 18796172880ULL },   // factor: 11245143907159236961
  { 298342903, 63, 18849696381ULL },   // factor: 11247346277952268087
  { 297590927, 63, 18898163125ULL },   // factor: 11247843765931933751
  { 298707067, 63, 18849769272ULL },   // factor: 11261118585731690449
  { 298869871, 63, 18857775420ULL },   // factor: 11272041814244741641
  { 297756287, 63, 18951086860ULL },   // factor: 11285610516096177641
  { 298487323, 63, 18936066308ULL },   // factor: 11304351480850826969
  { 298493677, 63, 18947953263ULL },   // factor: 11311688482194036103
  { 297824911, 63, 19011345608ULL },   // factor: 11324104627385681777
  { 298042009, 63, 18997976216ULL },   // factor: 11324389996701715889
  { 298459043, 63, 18974104417ULL },   // factor: 11325986092159785863
  { 299544529, 63, 18907149191ULL },   // factor: 11327066198301652079
  { 299465357, 63, 18914157648ULL },   // factor: 11328269944825200673
  { 299628167, 63, 18911709889ULL },   // factor: 11332961937753686927
  { 297645451, 63, 19048321596ULL },   // factor: 11339292544468919593
  { 297668131, 63, 19049208189ULL },   // factor: 11340684397299049519
  { 297048901, 63, 19117278063ULL },   // factor: 11357532877451117527
  { 297609523, 63, 19092117672ULL },   // factor: 11363992066847580913
  { 297623149, 63, 19109495075ULL },   // factor: 11374856200042982351
  { 298968167, 63, 19023219364ULL },   // factor: 11374674047387971577
  { 299839979, 63, 18986055109ULL },   // factor: 11385556730350805423
  { 299987509, 63, 19001740407ULL },   // factor: 11400569542721152327
  { 297999227, 63, 19141367665ULL },   // factor: 11408225535785589911
  { 299012657, 63, 19081733475ULL },   // factor: 11411359653051186151
  { 299982899, 63, 19026896220ULL },   // factor: 11415486974095483561
  { 299971403, 63, 19045188736ULL },   // factor: 11426023971075433217
  { 299717189, 63, 19062926460ULL },   // factor: 11426973465409841881
  { 298464073, 63, 19151203431ULL },   // factor: 11431892357735668927
  { 299065373, 63, 19112170572ULL },   // factor: 11431576841909606713
  { 297610057, 63, 19215976475ULL },   // factor: 11437735708070818151
  { 297415309, 63, 19260276056ULL },   // factor: 11456601909241082609
  { 298177237, 63, 19226683964ULL },   // factor: 11465919002115454937
  { 298629491, 63, 19200577489ULL },   // factor: 11467717364892256199
  { 297222559, 63, 19296724512ULL },   // factor: 11470843679549332417
  { 297292001, 63, 19300623723ULL },   // factor: 11475842094317479447
  { 298173089, 63, 19245030555ULL },   // factor: 11476700416967468791
  { 299695927, 63, 19178534873ULL },   // factor: 11495457574531124543
  { 299403043, 63, 19205991713ULL },   // factor: 11500664725409965319
  { 298463311, 63, 19268394029ULL },   // factor: 11501817359095940039
  { 298006097, 63, 19299726240ULL },   // factor: 11502872179901770561
  { 297586277, 63, 19330725760ULL },   // factor: 11505117421252791041
  { 299856631, 63, 19185559020ULL },   // factor: 11505834183177723241
  { 298260139, 63, 19295851037ULL },   // factor: 11510366424837828287
  { 298923167, 63, 19274513220ULL },   // factor: 11523197068211535481
  { 299310343, 63, 19269473741ULL },   // factor: 11535105589696406327
  { 297301307, 63, 19414633620ULL },   // factor: 11543991900304282681
  { 297578263, 63, 19409887481ULL },   // factor: 11551921203242851007
  { 297678791, 63, 19423828849ULL },   // factor: 11564123776722483119
  { 297388453, 63, 19482632991ULL },   // factor: 11587820171120505847
  { 299883317, 63, 19345326247ULL },   // factor: 11602681206795042599
  { 298997833, 63, 19450166583ULL },   // factor: 11631115319612029279
  { 297042293, 63, 19584374643ULL },   // factor: 11634775101855552799
  { 297615713, 63, 19553447280ULL },   // factor: 11638826307690221281
  { 297119021, 63, 19592311443ULL },   // factor: 11642496790142514607
  { 297817277, 63, 19555835895ULL },   // factor: 11648131591415515831
  { 299736977, 63, 19467636088ULL },   // factor: 11670340780706451953
  { 298509319, 63, 19551012485ULL },   // factor: 11672318845315695431
  { 299301449, 63, 19512595864ULL },   // factor: 11680296431693213873
  { 298025879, 63, 19602220809ULL },   // factor: 11683938173908632223
  { 299218013, 63, 19524222307ULL },   // factor: 11683998008141631983
  { 299938063, 63, 19478942757ULL },   // factor: 11684952719644919383
  { 298737721, 63, 19588887324ULL },   // factor: 11703879112195097209
  { 297562609, 63, 19695467820ULL },   // factor: 11721269579989484761
  { 297223343, 63, 19720350648ULL },   // factor: 11722697089461552529
  { 298884127, 63, 19611262352ULL },   // factor: 11722990054890973409
  { 298998569, 63, 19615497436ULL },   // factor: 11730011327174338169
  { 298924163, 63, 19620947457ULL },   // factor: 11730350591701406983
  { 298835983, 63, 19642517636ULL },   // factor: 11739782132697792377
  { 299222327, 63, 19621923957ULL },   // factor: 11742635493261175879
  { 299991919, 63, 19572121425ULL },   // factor: 11742956530373529151
  { 297076979, 63, 19780991041ULL },   // factor: 11752954120172690279
  { 297031337, 63, 19786135920ULL },   // factor: 11754204812762650081
  { 297254357, 63, 19794942663ULL },   // factor: 11768265906283865383
  { 299475871, 63, 19690419885ULL },   // factor: 11793611290832189671
  { 298130837, 63, 19779702103ULL },   // factor: 11793878287156100423
  { 297206279, 63, 19887001045ULL },   // factor: 11821083162107123111
  { 299439433, 63, 19744066676ULL },   // factor: 11824304261151269417
  { 297355831, 63, 19898727501ULL },   // factor: 11834005303804816663
  { 298466789, 63, 19839250411ULL },   // factor: 11842714732676200559
  { 297320677, 63, 19935446460ULL },   // factor: 11854440875568906841
  { 297543199, 63, 19930783800ULL },   // factor: 11860538340858752401
  { 298706531, 63, 19864061740ULL },   // factor: 11867049947850447881
  { 297890539, 63, 19940797901ULL },   // factor: 11880350069637917279
  { 298622729, 63, 19895347135ULL },   // factor: 11882405711712062831
  { 297638417, 63, 19988897104ULL },   // factor: 11898927383220888737
  { 299113673, 63, 19936427760ULL },   // factor: 11926516267585524961
  { 298733521, 63, 19964625036ULL },   // factor: 11928205464898063513
  { 298150667, 63, 20016247017ULL },   // factor: 11935714797910620679
  { 299412163, 63, 19947988641ULL },   // factor: 11945340853002480967
  { 298652267, 63, 20001644380ULL },   // factor: 11947072875629618921
  { 299944349, 63, 19922684800ULL },   // factor: 11951393445336390401
  { 299012509, 63, 20001195327ULL },   // factor: 11961215195450690887
  { 297926227, 63, 20083660305ULL },   // factor: 11966898278036638471
  { 297488309, 63, 20121989095ULL },   // factor: 11972113019175980711
  { 297931847, 63, 20115516085ULL },   // factor: 11986105721124517991
  { 297509699, 63, 20164736740ULL },   // factor: 11998409515863282521
  { 298963967, 63, 20071366032ULL },   // factor: 12001230424071537889
  { 298856473, 63, 20079239547ULL },   // factor: 12001621423077075463
  { 298582447, 63, 20111520713ULL },   // factor: 12009894134757449423
  { 298028839, 63, 20160646964ULL },   // factor: 12016908416339589593
  { 297163193, 63, 20252139708ULL },   // factor: 12036381001422735289
  { 297865411, 63, 20223503729ULL },   // factor: 12047764500197235239
  { 299239639, 63, 20134466301ULL },   // factor: 12050060854737810679
  { 298455307, 63, 20198945408ULL },   // factor: 12056964905641760513
  { 297551291, 63, 20272877944ULL },   // factor: 12064442009045251409
  { 298758437, 63, 20190623100ULL },   // factor: 12064237998824189401
  { 298001939, 63, 20283301869ULL },   // factor: 12088926572568647983
  { 299401117, 63, 20192470284ULL },   // factor: 12091296316037814457
  { 297367393, 63, 20347702040ULL },   // factor: 12101486218351163441
  { 298932979, 63, 20247489416ULL },   // factor: 12105284656791700529
  { 298397381, 63, 20289830136ULL },   // factor: 12108864347034547633
  { 297570307, 63, 20362468524ULL },   // factor: 12118532019929033737
  { 299782003, 63, 20217915081ULL },   // factor: 12121934158932174487
  { 299025577, 63, 20311303100ULL },   // factor: 12147198258198777401
  { 298359209, 63, 20369402607ULL },   // factor: 12154797699254115727
  { 299778517, 63, 20290489035ULL },   // factor: 12165305424234122191
  { 299267557, 63, 20337853244ULL },   // factor: 12172919309912809817
  { 298721561, 63, 20377710015ULL },   // factor: 12174522690572266831
  { 298465147, 63, 20430643452ULL },   // factor: 12195670002411534889
  { 299702413, 63, 20379300272ULL },   // factor: 12215450933539912673
  { 297421771, 63, 20567223593ULL },   // factor: 12234280131166086407
  { 298996669, 63, 20478902264ULL },   // factor: 12246247123425117233
  { 299802827, 63, 20426503149ULL },   // factor: 12247846779589204447
  { 299490239, 63, 20460699220ULL },   // factor: 12255559399009827161
  { 298123487, 63, 20580705349ULL },   // factor: 12271183287126863927
  { 298224373, 63, 20594172615ULL },   // factor: 12283368431124290791
  { 297305269, 63, 20697157739ULL },   // factor: 12306748098257653583
  { 298407607, 63, 20623234625ULL },   // factor: 12308260186091584751
  { 299393177, 63, 20564677815ULL },   // factor: 12313848450028536511
  { 297600461, 63, 20697600156ULL },   // factor: 12319230696038543833
  { 297968441, 63, 20692393855ULL },   // factor: 12331360675064660111
  { 298620941, 63, 20669810283ULL },   // factor: 12344876394001872607
  { 299546053, 63, 20618852807ULL },   // factor: 12352591951449641543
  { 298667147, 63, 20683295037ULL },   // factor: 12354841438520098879
  { 298030363, 63, 20732065148ULL },   // factor: 12357569803596177449
  { 299253463, 63, 20669484036ULL },   // factor: 12370829352392433337
  { 299323061, 63, 20672711980ULL },   // factor: 12375638858049941561
  { 299077417, 63, 20692593879ULL },   // factor: 12377375056722661087
  { 297500939, 63, 20812736425ULL },   // factor: 12383617259194006151
  { 299631473, 63, 20668968412ULL },   // factor: 12386146901356061753
  { 298273433, 63, 20775832572ULL },   // factor: 12393757809367319353
  { 297404209, 63, 20840857800ULL },   // factor: 12396317657780960401
  { 298978159, 63, 20755086720ULL },   // factor: 12410635234861896961
  { 298479871, 63, 20797163520ULL },   // factor: 12415069369231011841
  { 297359297, 63, 20899727728ULL },   // factor: 12429456689378974433
  { 298677557, 63, 20807249412ULL },   // factor: 12429316844531692969
  { 297758249, 63, 20882796399ULL },   // factor: 12436049779979490703
  { 298328071, 63, 20870120913ULL },   // factor: 12452285827024097647
  { 299664793, 63, 20802119651ULL },   // factor: 12467325758356294487
  { 298269487, 63, 20907331925ULL },   // factor: 12472038335616944951
  { 298360879, 63, 20901771000ULL },   // factor: 12472541536433418001
  { 297181949, 63, 21026120995ULL },   // factor: 12497167234407838511
  { 297466333, 63, 21019438443ULL },   // factor: 12505150550716879039
  { 298025153, 63, 20980520491ULL },   // factor: 12505445658699820247
  { 297756721, 63, 21000727704ULL },   // factor: 12506215639513797169
  { 297355649, 63, 21054797551ULL },   // factor: 12521525980682431199
  { 299654911, 63, 20894150753ULL },   // factor: 12522069768621595967
  { 298086037, 63, 21034260608ULL },   // factor: 12540038771727860993
  { 297463391, 63, 21080980228ULL },   // factor: 12541639728449666297
  { 297320899, 63, 21093109049ULL },   // factor: 12542844290307430103
  { 298915481, 63, 20986120783ULL },   // factor: 12546152776349083247
  { 298454209, 63, 21021919007ULL },   // factor: 12548160417792500927
  { 298371613, 63, 21029332647ULL },   // factor: 12549111804397899223
  { 297071639, 63, 21122224585ULL },   // factor: 12549627753584089631
  { 298319657, 63, 21045623752ULL },   // factor: 12556646518095386129
  { 298076269, 63, 21085154379ULL },   // factor: 12569968297162663903
  { 298210657, 63, 21113164484ULL },   // factor: 12592341304245411977
  { 297923783, 63, 21136685925ULL },   // factor: 12594242861717708551
  { 298289039, 63, 21117493741ULL },   // factor: 12598233828182809799
  { 299991053, 63, 21013424935ULL },   // factor: 12607678946774213111
  { 297651037, 63, 21181667820ULL },   // factor: 12609490784025058681
  { 298990297, 63, 21096114692ULL },   // factor: 12615067194614287049
  { 297141289, 63, 21234302019ULL },   // factor: 12619175745881924983
  { 298295089, 63, 21169430592ULL },   // factor: 12629474365039925377
  { 299855341, 63, 21071602611ULL },   // factor: 12636865172675790703
  { 299218033, 63, 21130532208ULL },   // factor: 12645272567041813729
  { 297955391, 63, 21235685245ULL },   // factor: 12654573800653811591
  { 298486931, 63, 21204809241ULL },   // factor: 12658716865573058743
  { 299885503, 63, 21134151140ULL },   // factor: 12675651090193846841
  { 297813079, 63, 21286781105ULL },   // factor: 12678963645758144591
  { 299613011, 63, 21162319585ULL },   // factor: 12681012581212240871
  { 297732367, 63, 21313545444ULL },   // factor: 12691464668408371897
  { 299635759, 63, 21189396300ULL },   // factor: 12698201686204583401
  { 297528631, 63, 21341564388ULL },   // factor: 12699452871519985657
  { 299600447, 63, 21211038112ULL },   // factor: 12709672999378472129
  { 298316393, 63, 21309789652ULL },   // factor: 12714119169146730473
  { 299530529, 63, 21231910059ULL },   // factor: 12719210503305382423
  { 299775257, 63, 21224876320ULL },   // factor: 12725385507242428481
  { 298728949, 63, 21342843335ULL },   // factor: 12751450316272409831
  { 299478013, 63, 21290887163ULL },   // factor: 12752305165164894239
  { 299782537, 63, 21325164104ULL },   // factor: 12785823594076903697
  { 298948987, 63, 21397184864ULL },   // factor: 12793333479489065537
  { 299160221, 63, 21384336376ULL },   // factor: 12794685592364998193
  { 299417491, 63, 21381272508ULL },   // factor: 12803853937465274857
  { 299260789, 63, 21411949631ULL },   // factor: 12815513881202637719
  { 299431819, 63, 21400565801ULL },   // factor: 12816020690845244039
  { 297226613, 63, 21578883856ULL },   // factor: 12827637121678519457
  { 299161271, 63, 21453750916ULL },   // factor: 12836262783495948473
  { 299789137, 63, 21409379103ULL },   // factor: 12836598569988408223
  { 297514709, 63, 21586643704ULL },   // factor: 12844688039764484273
  { 299239841, 63, 21471400156ULL },   // factor: 12850196737457630393
  { 297799399, 63, 21600033485ULL },   // factor: 12864953980425751031
  { 298513433, 63, 21552937960ULL },   // factor: 12867683003351233361
  { 299950351, 63, 21461442525ULL },   // factor: 12874734436680152551
  { 297430619, 63, 21645354996ULL },   // factor: 12875982669870045049
  { 299275121, 63, 21512018671ULL },   // factor: 12876023981435568383
  { 298775717, 63, 21550731688ULL },   // factor: 12877670623913640593
  { 297983893, 63, 21648833192ULL },   // factor: 12902007186919552913
  { 298513841, 63, 21631565515ULL },   // factor: 12914643417451586231
  { 298878739, 63, 21604051377ULL },   // factor: 12913983265697947207
  { 297857983, 63, 21705918177ULL },   // factor: 12930562014728513983
  { 298154639, 63, 21683993760ULL },   // factor: 12930366663182105281
  { 297816803, 63, 21746456308ULL },   // factor: 12952920188455486649
  { 297440027, 63, 21775378404ULL },   // factor: 12953738280841953817
  { 298843123, 63, 21672558716ULL },   // factor: 12953390260180620137
  { 299721511, 63, 21622838420ULL },   // factor: 12961659606702505241
  { 299103379, 63, 21673226400ULL },   // factor: 12965070500144011201
  { 299495143, 63, 21673524780ULL },   // factor: 12982230806600287081
  { 299435951, 63, 21684420613ULL },   // factor: 12986190216275315927
  { 299294573, 63, 21710465040ULL },   // factor: 12995648727556455841
  { 297413771, 63, 21850724889ULL },   // factor: 12997412976642092839
  { 298656949, 63, 21761937504ULL },   // factor: 12998707718546630593
  { 298306661, 63, 21793268491ULL },   // factor: 13002154311653437103
  { 299102341, 63, 21739952891ULL },   // factor: 13004941605855635663
  { 298548923, 63, 21788660772ULL },   // factor: 13009962414185897113
  { 297135611, 63, 21894825216ULL },   // factor: 13011464536588733953
  { 299081267, 63, 21759613332ULL },   // factor: 13015785449529303289
  { 298239841, 63, 21824010300ULL },   // factor: 13017578723708724601
  { 297349033, 63, 21897595448ULL },   // factor: 13022457662976003569
  { 298473667, 63, 21822001800ULL },   // factor: 13026585797053201201
  { 297580447, 63, 21897850100ULL },   // factor: 13032744042193989401
  { 297499673, 63, 21913483263ULL },   // factor: 13038508210066945999
  { 298604563, 63, 21845507517ULL },   // factor: 13046336451254000143
  { 298767589, 63, 21837178964ULL },   // factor: 13048482619271595593
  { 297106057, 63, 21960363012ULL },   // factor: 13049113729567927369
  { 297836339, 63, 21913105044ULL },   // factor: 13053037964854787833
  { 298399319, 63, 21871951977ULL },   // factor: 13053151150275007327
  { 297848051, 63, 21944083285ULL },   // factor: 13072004874837855071
  { 297735751, 63, 21956776301ULL },   // factor: 13074634563034474103
  { 299707249, 63, 21846530832ULL },   // factor: 13095127311704802337
  { 299019419, 63, 21906215001ULL },   // factor: 13100767364176208839
  { 298622743, 63, 21953283873ULL },   // factor: 13111499696025847279
  { 297407941, 63, 22053643079ULL },   // factor: 13117857159348580679
  { 299174329, 63, 21927715536ULL },   // factor: 13120419163971350689
  { 299070571, 63, 21949685921ULL },   // factor: 13129010203328261783
  { 297608149, 63, 22067681364ULL },   // factor: 13135043606923670473
  { 298528889, 63, 22002250807ULL },   // factor: 13136614977826126847
  { 297735077, 63, 22123220872ULL },   // factor: 13173717739625854289
  { 298841981, 63, 22046829288ULL },   // factor: 13177036278389479057
  { 299993657, 63, 21962896155ULL },   // factor: 13177459071699377671
  { 299426873, 63, 22023068340ULL },   // factor: 13188596973823001641
  { 299987131, 63, 22004293160ULL },   // factor: 13202009549502647921
  { 299302351, 63, 22092606845ULL },   // factor: 13224738336854385191
  { 298479971, 63, 22167976956ULL },   // factor: 13233394237911096553
  { 298084357, 63, 22201769067ULL },   // factor: 13236000113198369839
  { 297687569, 63, 22242648051ULL },   // factor: 13242719652849556039
  { 299135341, 63, 22141840680ULL },   // factor: 13246814124358943761
  { 299272327, 63, 22158594260ULL },   // factor: 13262908134478086041
  { 297696053, 63, 22302664435ULL },   // factor: 13278830347365950111
  { 298916707, 63, 22215583377ULL },   // factor: 13281218054273559079
  { 299438807, 63, 22189575340ULL },   // factor: 13288839935292438761
  { 298410391, 63, 22283055948ULL },   // factor: 13298990876235111337
  { 299254201, 63, 22237115903ULL },   // factor: 13309100704193317007
  { 297118721, 63, 22397618824ULL },   // factor: 13309503716864808209
  { 299937461, 63, 22206151164ULL },   // factor: 13320913197424709209
  { 298924711, 63, 22284023133ULL },   // factor: 13322490349898679127
  { 297340207, 63, 22405523873ULL },   // factor: 13324126212682523423
  { 299064889, 63, 22308528819ULL },   // factor: 13343395390015072183
  { 299580907, 63, 22279396349ULL },   // factor: 13348963531291817087
  { 298636703, 63, 22392136536ULL },   // factor: 13374227656473761617
  { 298594391, 63, 22409676468ULL },   // factor: 13382807394938981977
  { 298759291, 63, 22424782860ULL },   // factor: 13399224456165104521
  { 299471989, 63, 22386804140ULL },   // factor: 13408441526318468921
  { 298501757, 63, 22473180792ULL },   // factor: 13416567903581303089
  { 297746297, 63, 22558361772ULL },   // factor: 13433337367998716569
  { 297772817, 63, 22603202763ULL },   // factor: 13461238719921386743
  { 298221139, 63, 22577518152ULL },   // factor: 13466186358165230257
  { 299576093, 63, 22475427831ULL },   // factor: 13466201716228888567
  { 299440697, 63, 22490614384ULL },   // factor: 13469210494206371297
  { 299222953, 63, 22511886276ULL },   // factor: 13472146178209786057
  { 298717219, 63, 22555254585ULL },   // factor: 13475285846936398231
  { 298564229, 63, 22584968419ULL },   // factor: 13486127366016167903
  { 297514307, 63, 22666173028ULL },   // factor: 13487021521535023193
  { 299246669, 63, 22538127007ULL },   // factor: 13488918864687379367
  { 299965727, 63, 22486934160ULL },   // factor: 13490619106611068641
  { 298941553, 63, 22574165823ULL },   // factor: 13496712377614286239
  { 298877473, 63, 22582831287ULL },   // factor: 13498999096487795503
  { 297691951, 63, 22678791245ULL },   // factor: 13502587224091537991
  { 299027371, 63, 22591022540ULL },   // factor: 13510668156675884681
  { 298804981, 63, 22610341523ULL },   // factor: 13512165338367052127
  { 297871031, 63, 22720086036ULL },   // factor: 13535310903904046233
  { 298583773, 63, 22688521916ULL },   // factor: 13548848954944938137
  { 298633487, 63, 22708594189ULL },   // factor: 13563093335058014087
  { 298170101, 63, 22765840599ULL },   // factor: 13576185981507460999
  { 297222953, 63, 22871257920ULL },   // factor: 13595725635614075521
  { 297873679, 63, 22832425377ULL },   // factor: 13602357095079903967
  { 298763417, 63, 22781541784ULL },   // factor: 13612582535832231857
  { 299849327, 63, 22698967408ULL },   // factor: 13612540201767468833
  { 297746719, 63, 22869254492ULL },   // factor: 13618490981938023497
  { 297295751, 63, 22911705540ULL },   // factor: 13623105410410321081
  { 298832203, 63, 22806037232ULL },   // factor: 13630356695477164193
  { 297171047, 63, 22938516217ULL },   // factor: 13633325761664738399
  { 298312891, 63, 22854328361ULL },   // factor: 13635481530466403303
  { 298972007, 63, 22809887173ULL },   // factor: 13639035495110732423
  { 298444693, 63, 22852555308ULL },   // factor: 13640447706323160889
  { 299766367, 63, 22755147188ULL },   // factor: 13642455606194051993
  { 299800931, 63, 22760691601ULL },   // factor: 13647353064367361063
  { 299580077, 63, 22794097144ULL },   // factor: 13657314755090000177
  { 297864019, 63, 22926393780ULL },   // factor: 13657895584974803641
  { 297503491, 63, 22956836816ULL },   // factor: 13659478190154649313
  { 298175263, 63, 22941848196ULL },   // factor: 13681383239096751097
  { 297104761, 63, 23053219643ULL },   // factor: 13698442624628040647
  { 297290051, 63, 23044782673ULL },   // factor: 13701969232280172647
  { 297095797, 63, 23092328747ULL },   // factor: 13721267627351952719
  { 298941187, 63, 22951924733ULL },   // factor: 13722551247235356143
  { 298654001, 63, 22993421395ULL },   // factor: 13734154592591502791
  { 297066467, 63, 23158642293ULL },   // factor: 13759312092996577663
  { 297639457, 63, 23117737439ULL },   // factor: 13761501636825061247
  { 299873939, 63, 22958535724ULL },   // factor: 13769333082456193673
  { 299769193, 63, 22977643155ULL },   // factor: 13775979091232647831
  { 299069503, 63, 23041874360ULL },   // factor: 13782243826067286161
  { 298902269, 63, 23079111024ULL },   // factor: 13796797303153026913
  { 298241639, 63, 23133033165ULL },   // factor: 13798467452341914871
  { 298492133, 63, 23116274940ULL },   // factor: 13800052427710094041
  { 297139393, 63, 23228457707ULL },   // factor: 13804179646768303703
  { 299664551, 63, 23031531985ULL },   // factor: 13803467382254327471
  { 299501221, 63, 23057818055ULL },   // factor: 13811689322136690311
  { 297986573, 63, 23210898487ULL },   // factor: 13833072192784030103
  { 298338331, 63, 23186665856ULL },   // factor: 13834942385867452673
  { 298574071, 63, 23168826129ULL },   // factor: 13835221475253402319
  { 298127881, 63, 23254654319ULL },   // factor: 13865721631021936079
  { 297606853, 63, 23300283951ULL },   // factor: 13868648361327032407
  { 297794557, 63, 23287296147ULL },   // factor: 13869660079647343759
  { 297828841, 63, 23362262996ULL },   // factor: 13915911422471735273
  { 299104153, 63, 23269920356ULL },   // factor: 13920259636917676937
  { 299142133, 63, 23275008171ULL },   // factor: 13925071179730737487
  { 297930653, 63, 23379527367ULL },   // factor: 13930955710563361303
  { 298223477, 63, 23379197824ULL },   // factor: 13944451329088228097
  { 297986257, 63, 23419585415ULL },   // factor: 13957429196615283311
  { 298708127, 63, 23385213717ULL },   // factor: 13970706777799556119
  { 299471771, 63, 23332659784ULL },   // factor: 13974945895309914929
  { 299982427, 63, 23300721384ULL },   // factor: 13979613903246237937
  { 299531387, 63, 23345239465ULL },   // factor: 13985263913597175911
  { 297945437, 63, 23478124488ULL },   // factor: 13990400121035122513
  { 297016183, 63, 23557406081ULL },   // factor: 13993861671119217647
  { 299723591, 63, 23361755520ULL },   // factor: 14004138513036944641
  { 299050889, 63, 23424533359ULL },   // factor: 14010255050838212303
  { 298314857, 63, 23498378748ULL },   // factor: 14019830991882918073
  { 298508761, 63, 23502658511ULL },   // factor: 14031498944649429743
  { 298768417, 63, 23504416992ULL },   // factor: 14044754914415483329
  { 298969273, 63, 23508875900ULL },   // factor: 14056863073740441401
  { 298513283, 63, 23548263460ULL },   // factor: 14058938868787078361
  { 298992137, 63, 23524341288ULL },   // factor: 14067186146432904913
  { 298322221, 63, 23597569443ULL },   // factor: 14079358652874985807
  { 297072443, 63, 23723279437ULL },   // factor: 14095065156642509183
  { 297844441, 63, 23666639159ULL },   // factor: 14097953821322130239
  { 297001013, 63, 23742413652ULL },   // factor: 14103041811418058953
  { 297872207, 63, 23686662324ULL },   // factor: 14111196765827258137
  { 297970759, 63, 23694327369ULL },   // factor: 14120433420270806143
  { 297937417, 63, 23700483795ULL },   // factor: 14122521847065315031
  { 298730491, 63, 23654125616ULL },   // factor: 14132417118886714913
  { 298586677, 63, 23697096752ULL },   // factor: 14151274747454346209
  { 299215507, 63, 23657762729ULL },   // factor: 14157538938886877207
  { 297294707, 63, 23823460453ULL },   // factor: 14165177390201444543
  { 297715919, 63, 23790102817ULL },   // factor: 14165384646535287647
  { 297168803, 63, 23843919625ULL },   // factor: 14171338107578917751
  { 298060379, 63, 23823182172ULL },   // factor: 14201493414344726377
  { 298464679, 63, 23815935884ULL },   // factor: 14216431317405282473
  { 297352001, 63, 23927271711ULL },   // factor: 14229644243473087423
  { 298449887, 63, 23850129849ULL },   // factor: 14236137116738754127
  { 297070607, 63, 23969697124ULL },   // factor: 14241384948465668537
  { 299927437, 63, 23744471775ULL },   // factor: 14243237124789181351
  { 297130927, 63, 23980315124ULL },   // factor: 14250586525092479897
  { 298563781, 63, 23880245256ULL },   // factor: 14259552629677345873
  { 297655879, 63, 23972866181ULL },   // factor: 14271329110509856199
  { 298547471, 63, 23908185300ULL },   // factor: 14275456515028752601
  { 298182967, 63, 23957295152ULL },   // factor: 14287314699436151969
  { 298389803, 63, 23955920820ULL },   // factor: 14296404988326796921
  { 299424067, 63, 23883141605ULL },   // factor: 14302374784212015071
  { 297814091, 63, 24020641573ULL },   // factor: 14307371070599610287
  { 297857789, 63, 24021927256ULL },   // factor: 14310236279981993969
  { 299655977, 63, 23885997384ULL },   // factor: 14315163765443928337
  { 298768219, 63, 23978619725ULL },   // factor: 14328099018633039551
  { 298591457, 63, 23996038335ULL },   // factor: 14330024097351008191
  { 299313913, 63, 23963772828ULL },   // factor: 14345381230783511929
  { 299657647, 63, 23942867757ULL },   // factor: 14349326828989575559
  { 298939637, 63, 24015227863ULL },   // factor: 14358206999675011463
  { 298585633, 63, 24062504543ULL },   // factor: 14369436301074061439
  { 298852019, 63, 24051618700ULL },   // factor: 14375749617426310601
  { 299450629, 63, 24005138436ULL },   // factor: 14376707607784552489
  { 297248929, 63, 24191771199ULL },   // factor: 14381956159031591743
  { 299239301, 63, 24039434860ULL },   // factor: 14387087367882865721
  { 297186913, 63, 24216558300ULL },   // factor: 14393688409323055801
  { 297593017, 63, 24205649432ULL },   // factor: 14406864485826432689
  { 299950459, 63, 24026386560ULL },   // factor: 14413451353566862081
  { 298731113, 63, 24131137743ULL },   // factor: 14417443271845395919
  { 299632447, 63, 24060077717ULL },   // factor: 14418359922709766999
  { 299178569, 63, 24101954640ULL },   // factor: 14421576598596220321
  { 299014607, 63, 24131231364ULL },   // factor: 14431181325465067897
  { 299531671, 63, 24105335141ULL },   // factor: 14440622629597501223
  { 297517951, 63, 24286587413ULL },   // factor: 14451391447796301527
  { 297495683, 63, 24330381981ULL },   // factor: 14476367210176976047
  { 297459941, 63, 24363458616ULL },   // factor: 14494305924942603313
  { 298117597, 63, 24310518668ULL },   // factor: 14494786814255601593
  { 298290533, 63, 24298471635ULL },   // factor: 14496008110179062911
  { 298705607, 63, 24269569249ULL },   // factor: 14498912828302158287
  { 298076231, 63, 24335080656ULL },   // factor: 14507418246042975073
  { 299037971, 63, 24256462024ULL },   // factor: 14507206374591026609
  { 299087219, 63, 24257788965ULL },   // factor: 14510389281261476671
  { 299813537, 63, 24201527827ULL },   // factor: 14511891317233588199
  { 299683339, 63, 24230559552ULL },   // factor: 14522989984763408257
  { 299865301, 63, 24241263395ULL },   // factor: 14538227489123913791
  { 299943169, 63, 24260669280ULL },   // factor: 14553644051808296641
  { 299493679, 63, 24332834816ULL },   // factor: 14575060439086256129
  { 298585999, 63, 24423638672ULL },   // factor: 14585113104188306657
  { 298405483, 63, 24450571277ULL },   // factor: 14592369063078223583
  { 298406939, 63, 24496061497ULL },   // factor: 14619589457751055367
  { 298890671, 63, 24462910653ULL },   // factor: 14623471559376436327
  { 297339793, 63, 24591078287ULL },   // factor: 14623812255006749183
  { 299159989, 63, 24444331716ULL },   // factor: 14625532014541822249
  { 298735207, 63, 24484038065ULL },   // factor: 14628488359087308911
  { 299457913, 63, 24446925176ULL },   // factor: 14641650384944235377
  { 298609327, 63, 24519970757ULL },   // factor: 14643783931614901079
  { 297690749, 63, 24611854611ULL },   // factor: 14653442866855387279
  { 298019473, 63, 24584356880ULL },   // factor: 14653234162843048481
  { 298124249, 63, 24599479900ULL },   // factor: 14667402941956190201
  { 298603087, 63, 24561957728ULL },   // factor: 14668552800688612673
  { 299702077, 63, 24486341595ULL },   // factor: 14677214868305985631
  { 298206053, 63, 24629846367ULL },   // factor: 14689538542198918903
  { 298475381, 63, 24614241535ULL },   // factor: 14693490240370299671
  { 298497593, 63, 24628402311ULL },   // factor: 14703037618538274847
  { 299430137, 63, 24552145959ULL },   // factor: 14703304856294732767
  { 298846057, 63, 24634930080ULL },   // factor: 14724103437757389121
  { 299065577, 63, 24617365683ULL },   // factor: 14724413344412788183
  { 299407373, 63, 24598997368ULL },   // factor: 14730242360773588529
  { 298668659, 63, 24677303940ULL },   // factor: 14740674550990432921
  { 297697009, 63, 24788149044ULL },   // factor: 14758715658090018793
  { 299405201, 63, 24687817039ULL },   // factor: 14783321645626039679
  { 298688587, 63, 24777277305ULL },   // factor: 14801379895875236071
  { 299199211, 63, 24735204480ULL },   // factor: 14801507328679330561
  { 297768343, 63, 24858653001ULL },   // factor: 14804239826639494687
  { 298286047, 63, 24873635969ULL },   // factor: 14838917095420049087
  { 299371067, 63, 24786643153ULL },   // factor: 14840807616123708503
  { 297312403, 63, 24959738597ULL },   // factor: 14841679721051837183
  { 298344157, 63, 24879068348ULL },   // factor: 14845049346458885273
  { 299335801, 63, 24802157631ULL },   // factor: 14848347442007294863
  { 299455609, 63, 24830750355ULL },   // factor: 14871414938966982391
  { 297829849, 63, 25002828552ULL },   // factor: 14893177304430097297
  { 297296609, 63, 25062583144ULL },   // factor: 14902041962983517393
  { 297509987, 63, 25062875697ULL },   // factor: 14912911645594171879
  { 298901809, 63, 24967894067ULL },   // factor: 14925897407093334407
  { 299472727, 63, 24956471189ULL },   // factor: 14947564966533524807
  { 298187167, 63, 25066397697ULL },   // factor: 14948956232327508799
  { 297526351, 63, 25124213445ULL },   // factor: 14950231096071978391
  { 299522369, 63, 24985529407ULL },   // factor: 14967449917407610367
  { 297003019, 63, 25208594501ULL },   // factor: 14974057343087597039
  { 297140131, 63, 25227199856ULL },   // factor: 14992026939950042273
  { 297163831, 63, 25241488761ULL },   // factor: 15001715000724406783
  { 299582251, 63, 25093839189ULL },   // factor: 15035337660945268879
  { 297697769, 63, 25264729780ULL },   // factor: 15042507379787721641
  { 299264827, 63, 25143148253ULL },   // factor: 15048919824338794463
  { 297272323, 63, 25314177488ULL },   // factor: 15050408693384129249
  { 299275421, 63, 25148090644ULL },   // factor: 15052410829658522249
  { 298759171, 63, 25200001781ULL },   // factor: 15057463282580167103
  { 298247093, 63, 25302313167ULL },   // factor: 15092682696466747063
  { 298088381, 63, 25327083855ULL },   // factor: 15099418843576377511
  { 298773767, 63, 25277909352ULL },   // factor: 15104752397963137969
  { 298963859, 63, 25268174280ULL },   // factor: 15108541785266693041
  { 297918359, 63, 25362764565ULL },   // factor: 15112066397816297671
  { 298644107, 63, 25306567209ULL },   // factor: 15115314330734574727
  { 299126831, 63, 25264371333ULL },   // factor: 15114502668095071447
  { 297949391, 63, 25370703124ULL },   // factor: 15118371090075194969
  { 297962801, 63, 25370486899ULL },   // factor: 15118922678319688199
  { 298118159, 63, 25369458456ULL },   // factor: 15126192499459405009
  { 297235559, 63, 25478243089ULL },   // factor: 15146079653793603503
  { 297007817, 63, 25504717368ULL },   // factor: 15150200857343331313
  { 298991477, 63, 25375604592ULL },   // factor: 15174178993460124769
  { 298277339, 63, 25439068969ULL },   // factor: 15175795597421586983
  { 298324357, 63, 25444384847ULL },   // factor: 15181359497483636759
  { 298111267, 63, 25469642904ULL },   // factor: 15185575032297998737
  { 298024621, 63, 25477538115ULL },   // factor: 15185867281471858831
  { 299098777, 63, 25388215772ULL },   // factor: 15187168575234621689
  { 297927797, 63, 25497602628ULL },   // factor: 15192889159482901033
  { 297774413, 63, 25531908367ULL },   // factor: 15205498053506427143
  { 299537321, 63, 25389297235ULL },   // factor: 15210084151689214871
  { 298811143, 63, 25453138940ULL },   // factor: 15211363079198416841
  { 297217847, 63, 25625231053ULL },   // factor: 15232552004900405783
  { 299695243, 63, 25417343393ULL },   // factor: 15234913809159158999
  { 299730841, 63, 25423857279ULL },   // factor: 15240628247397283279
  { 297435109, 63, 25639459764ULL },   // factor: 15252151019212908553
  { 299223347, 63, 25488373425ULL },   // factor: 15253432811628706951
  { 297482671, 63, 25639495616ULL },   // factor: 15254611277880940673
  { 298355437, 63, 25590118668ULL },   // factor: 15269902076145995833
  { 297471007, 63, 25683849588ULL },   // factor: 15280401201157790233
  { 299148107, 63, 25540095244ULL },   // factor: 15280542289684606217
  { 297306673, 63, 25763788452ULL },   // factor: 15319492457079880393
  { 299906353, 63, 25539915156ULL },   // factor: 15319165620730772137
  { 297796727, 63, 25753313800ULL },   // factor: 15338505118087865201
  { 297077569, 63, 25819757444ULL },   // factor: 15340941547266347273
  { 299377931, 63, 25635056421ULL },   // factor: 15349140304774489903
  { 298015229, 63, 25812104092ULL },   // factor: 15384800223898434137
  { 298794109, 63, 25745086352ULL },   // factor: 15384960275347800737
  { 298409807, 63, 25799199400ULL },   // factor: 15397468227417031601
  { 298838201, 63, 25776787351ULL },   // factor: 15406177519064791103
  { 298929803, 63, 25778118916ULL },   // factor: 15411696018540907097
  { 299863163, 63, 25710182412ULL },   // factor: 15419073238738578313
  { 298372069, 63, 25843621335ULL },   // factor: 15422029536352984231
  { 299019277, 63, 25811281704ULL },   // factor: 15436141587146816017
  { 299465519, 63, 25789803244ULL },   // factor: 15446313626744687273
  { 299561189, 63, 25789611204ULL },   // factor: 15451133192235923113
  { 299058647, 63, 25844682793ULL },   // factor: 15458151736437522143
  { 298662803, 63, 25892206561ULL },   // factor: 15466077974726500967
  { 299077421, 63, 25859563084ULL },   // factor: 15468022870699052729
  { 299473171, 63, 25843747893ULL },   // factor: 15479018264082557407
  { 298664351, 63, 25961957856ULL },   // factor: 15507822587503182913
  { 298385917, 63, 26025952227ULL },   // factor: 15531555242103174319
  { 298148069, 63, 26048970235ULL },   // factor: 15532900350007452431
  { 297749227, 63, 26108531232ULL },   // factor: 15547589984866715329
  { 299458129, 63, 25964591400ULL },   // factor: 15550615921786981201
  { 298046429, 63, 26107032175ULL },   // factor: 15562215423093706151
  { 299157083, 63, 26069884896ULL },   // factor: 15597981439266236737
  { 299020303, 63, 26084605968ULL },   // factor: 15599653560373936609
  { 299920903, 63, 26026953572ULL },   // factor: 15612054835306631033
  { 298070821, 63, 26197039995ULL },   // factor: 15617146438158971791
  { 298652251, 63, 26155612785ULL },   // factor: 15622865269049258071
  { 297198991, 63, 26324024669ULL },   // factor: 15646947141371817959
  { 298292909, 63, 26260249300ULL },   // factor: 15666492309524427401
  { 299889823, 63, 26130405933ULL },   // factor: 15672485620331039719
  { 298108897, 63, 26328174608ULL },   // factor: 15697326184828574753
  { 298751291, 63, 26279773620ULL },   // factor: 15702232592325486841
  { 298743953, 63, 26312998932ULL },   // factor: 15721698632460916393
  { 299803853, 63, 26263574788ULL },   // factor: 15747841829992116329
  { 298195141, 63, 26410589156ULL },   // factor: 15751018714532981993
  { 299333761, 63, 26310239604ULL },   // factor: 15751085946952941289
  { 298921033, 63, 26351296616ULL },   // factor: 15753913610688248657
  { 297721657, 63, 26486183175ULL },   // factor: 15771020684933041951
  { 297430633, 63, 26524824143ULL },   // factor: 15778590470132345039
  { 297631897, 63, 26510168879ULL },   // factor: 15780543706494266927
  { 298343399, 63, 26451078616ULL },   // factor: 15783009403027311569
  { 298945693, 63, 26414183867ULL },   // factor: 15792813002299469663
  { 298009739, 63, 26502404824ULL },   // factor: 15795949488945161873
  { 298905223, 63, 26452644537ULL },   // factor: 15813667228543433503
  { 298250437, 63, 26517855980ULL },   // factor: 15817924268676126521
  { 299678969, 63, 26429428084ULL },   // factor: 15840687518945530793
  { 297207749, 63, 26658837696ULL },   // factor: 15846426285169012609
  { 298506227, 63, 26613799920ULL },   // factor: 15888770000504203681
  { 298728329, 63, 26600795131ULL },   // factor: 15892822159109932199
  { 297674467, 63, 26711782049ULL },   // factor: 15902830968112485767
  { 298935337, 63, 26623993319ULL },   // factor: 15917704830202027007
  { 297397799, 63, 26771303805ULL },   // factor: 15923453655934650391
  { 297770009, 63, 26737248292ULL },   // factor: 15923101329088149257
  { 299043023, 63, 26627220013ULL },   // factor: 15925368733547238599
  { 297384277, 63, 26778659604ULL },   // factor: 15927104650729292617
  { 297843109, 63, 26746498076ULL },   // factor: 15932520283636716569
  { 299548099, 63, 26595413681ULL },   // factor: 15933211220524284839
  { 299544523, 63, 26610010992ULL },   // factor: 15941766099246793633
  { 298928327, 63, 26688707137ULL },   // factor: 15956021148512739599
  { 297631601, 63, 26816620636ULL },   // factor: 15962947466604636473
  { 299061487, 63, 26749063748ULL },   // factor: 15999229560669346553
  { 299191873, 63, 26755501872ULL },   // factor: 16010057436277372513
  { 299473703, 63, 26741383893ULL },   // factor: 16016682515562531559
  { 297363457, 63, 26938781180ULL },   // factor: 16021218198102678521
  { 297782857, 63, 26900708940ULL },   // factor: 16021139926957283161
  { 298348277, 63, 26874451639ULL },   // factor: 16035892683630952007
  { 297466577, 63, 26981342640ULL },   // factor: 16052095275969886561
  { 299447389, 63, 26816453892ULL },   // factor: 16060234200396575977
  { 297347101, 63, 27010945164ULL },   // factor: 16063252479570739129
  { 297094123, 63, 27071246192ULL },   // factor: 16085416291858659233
  { 298773809, 63, 26920004667ULL },   // factor: 16085984665314733207
  { 299474107, 63, 26856086508ULL },   // factor: 16085405048996096713
  { 299479087, 63, 26858692964ULL },   // factor: 16087233693744087737
  { 299585827, 63, 26855808704ULL },   // factor: 16091239320683276417
  { 299070257, 63, 26907220255ULL },   // factor: 16094298553636911071
  { 299051821, 63, 26919194688ULL },   // factor: 16100468382599853697
  { 297860963, 63, 27057925593ULL },   // factor: 16118999547826652119
  { 298902679, 63, 26971140069ULL },   // factor: 16123492044616689703
  { 297903523, 63, 27064503872ULL },   // factor: 16125222103431882113
  { 297934297, 63, 27070036563ULL },   // factor: 16130184626323402423
  { 298622497, 63, 27015023204ULL },   // factor: 16134587371382840777
  { 299844109, 63, 26907099111ULL },   // factor: 16135870317424974199
  { 299205233, 63, 26973647295ULL },   // factor: 16141312847520589471
  { 298043477, 63, 27140968680ULL },   // factor: 16178377349070600721
  { 299150647, 63, 27053617949ULL },   // factor: 16186214626268326007
  { 299044721, 63, 27080832216ULL },   // factor: 16196759828963063473
  { 298414973, 63, 27143874040ULL },   // factor: 16200276877524001841
  { 299361899, 63, 27060204760ULL },   // factor: 16201588568564878481
  { 298864543, 63, 27139857437ULL },   // factor: 16222282179988312583
  { 297648149, 63, 27278933575ULL },   // factor: 16239048170585405351
  { 298508209, 63, 27209071980ULL },   // factor: 16244262690603767641
  { 299720821, 63, 27103916243ULL },   // factor: 16247216057334391007
  { 298305487, 63, 27253164317ULL },   // factor: 16259536907747414759
  { 299211463, 63, 27183494105ULL },   // factor: 16267226081217851231
  { 299342983, 63, 27178390760ULL },   // factor: 16271321126476074161
  { 299066869, 63, 27218542971ULL },   // factor: 16280328850157855599
  { 299584399, 63, 27175538832ULL },   // factor: 16282734936971763937
  { 298058821, 63, 27341400663ULL },   // factor: 16298691292204796647
  { 298650641, 63, 27286937155ULL },   // factor: 16298522544534932711
  { 299580599, 63, 27202075725ULL },   // factor: 16298428279477718551
  { 297535873, 63, 27400356896ULL },   // factor: 16305178219125860417
  { 298528309, 63, 27316091700ULL },   // factor: 16309253327379870601
  { 297015877, 63, 27466151295ULL },   // factor: 16315766029398221431
  { 298357487, 63, 27373541848ULL },   // factor: 16334202312117231953
  { 297442921, 63, 27479967240ULL },   // factor: 16347443449699816081
  { 298551257, 63, 27379995084ULL },   // factor: 16348663897964041177
  { 299360141, 63, 27341411344ULL },   // factor: 16369857510157679009
  { 299490209, 63, 27331851759ULL },   // factor: 16371243991319855263
  { 299515303, 63, 27336909032ULL },   // factor: 16375645183605833393
  { 297079583, 63, 27565449517ULL },   // factor: 16378264495435822823
  { 298266623, 63, 27461534545ULL },   // factor: 16381718342269983071
  { 298036633, 63, 27486508343ULL },   // factor: 16383972798948258239
  { 299518301, 63, 27378636144ULL },   // factor: 16400805163096142689
  { 299868637, 63, 27349162100ULL },   // factor: 16402311924038115401
  { 297491053, 63, 27577751168ULL },   // factor: 16408268468680599809
  { 298284563, 63, 27506119713ULL },   // factor: 16409301796835780839
  { 299890853, 63, 27358565520ULL },   // factor: 16409167101298377121
  { 299043089, 63, 27450315675ULL },   // factor: 16417654386954240151
  { 297133373, 63, 27630102952ULL },   // factor: 16419651372930034193
  { 299937271, 63, 27409524716ULL },   // factor: 16442276085448180073
  { 298606397, 63, 27570701043ULL },   // factor: 16465575402428744143
  { 297207641, 63, 27705744700ULL },   // factor: 16468718048870505401
  { 299525321, 63, 27495387115ULL },   // factor: 16471129303279277831
  { 297309577, 63, 27708238383ULL },   // factor: 16475849266129787983
  { 297978127, 63, 27677122845ULL },   // factor: 16494354452204022631
  { 299151113, 63, 27597703272ULL },   // factor: 16511767300125083473
  { 297401683, 63, 27784685060ULL },   // factor: 16526424196937911961
  { 298509227, 63, 27691478905ULL },   // factor: 16532323924836712871
  { 298096259, 63, 27746026252ULL },   // factor: 16541973255673982537
  { 297713389, 63, 27820829820ULL },   // factor: 16565267061008919961
  { 297743843, 63, 27851024172ULL },   // factor: 16584941936914345993
  { 297773369, 63, 27867587019ULL },   // factor: 16596450545096594023
  { 297680983, 63, 27881675340ULL },   // factor: 16599689045796118441
  { 299019937, 63, 27784364564ULL },   // factor: 16616157883024624937
  { 299464021, 63, 27754944620ULL },   // factor: 16623214637075034041
  { 299254321, 63, 27850957136ULL },   // factor: 16669038533867569313
  { 299362831, 63, 27844822685ULL },   // factor: 16671409895349242471
  { 297825767, 63, 28050146433ULL },   // factor: 16708112751741078223
  { 297790511, 63, 28061906289ULL },   // factor: 16713138826870847359
  { 299239357, 63, 27932990327ULL },   // factor: 16717300129077399479
  { 297979741, 63, 28075008348ULL },   // factor: 16731567432219755737
  { 299456669, 63, 27947614044ULL },   // factor: 16738198816227718873
  { 299228557, 63, 27973970375ULL },   // factor: 16741221577743997751
  { 298687043, 63, 28030256520ULL },   // factor: 16744548868980540721
  { 298441373, 63, 28070344312ULL },   // factor: 16754704194112040753
  { 298643533, 63, 28060500783ULL },   // factor: 16760174183168772679
  { 299467667, 63, 27996611112ULL },   // factor: 16768159627233831409
  { 299099413, 63, 28041612012ULL },   // factor: 16774459384725897913
  { 297886049, 63, 28184616076ULL },   // factor: 16791607850923047449
  { 299371889, 63, 28046864760ULL },   // factor: 16792885767457463281
  { 298054703, 63, 28185980341ULL },   // factor: 16801927998601187447
  { 299661233, 63, 28051149100ULL },   // factor: 16811683852745680601
  { 299858453, 63, 28033933836ULL },   // factor: 16812424063134631417
  { 297196903, 63, 28296277653ULL },   // factor: 16819132169799417319
  { 297932171, 63, 28242063220ULL },   // factor: 16828438417307701241
  { 298663193, 63, 28203374931ULL },   // factor: 16846620020537229367
  { 299375243, 63, 28166535280ULL },   // factor: 16864726687836146081
  { 297467047, 63, 28351735988ULL },   // factor: 16867414363347974873
  { 299709071, 63, 28143090276ULL },   // factor: 16869478883378187193
  { 297020797, 63, 28411942508ULL },   // factor: 16877875616088677753
  { 299914843, 63, 28156917797ULL },   // factor: 16889355160902321743
  { 298575727, 63, 28291423512ULL },   // factor: 16894264685920586449
  { 299351363, 63, 28257172048ULL },   // factor: 16917645934188602849
  { 298135687, 63, 28377734600ULL },   // factor: 16920830800949340401
  { 298181363, 63, 28404631840ULL },   // factor: 16939463675128795841
  { 298464323, 63, 28381619685ULL },   // factor: 16941801809853996511
  { 299716877, 63, 28263734803ULL },   // factor: 16942236655022740463
  { 299070791, 63, 28362796704ULL },   // factor: 16964968090474945729
  { 299631641, 63, 28312798903ULL },   // factor: 16966820793217779647
  { 298846837, 63, 28438605719ULL },   // factor: 16997574735626521607
  { 297473201, 63, 28595517000ULL },   // factor: 17012799952479834001
  { 297766289, 63, 28596839536ULL },   // factor: 17030349571526403809
  { 297654341, 63, 28607859388ULL },   // factor: 17030507067111606617
  { 297895883, 63, 28603487976ULL },   // factor: 17041722614980805617
  { 298848793, 63, 28523096472ULL },   // factor: 17048185906559516593
  { 297912113, 63, 28615240360ULL },   // factor: 17049653439300961361
  { 297964207, 63, 28611935313ULL },   // factor: 17050665232546683583
  { 298987067, 63, 28617559713ULL },   // factor: 17112560486574463543
  { 298893431, 63, 28645563784ULL },   // factor: 17123941684658205809
  { 299727583, 63, 28573547912ULL },   // factor: 17128560906796913393
  { 298986073, 63, 28655569592ULL },   // factor: 17135232443780584433
  { 298358251, 63, 28730659629ULL },   // factor: 17144058713969497759
  { 298785961, 63, 28693839195ULL },   // factor: 17146632637315082791
  { 297031507, 63, 28871852204ULL },   // factor: 17151699540070782857
  { 298406993, 63, 28783540288ULL },   // factor: 17178419410472867969
  { 297514417, 63, 28883748024ULL },   // factor: 17186662908270524017
  { 298817231, 63, 28759172461ULL },   // factor: 17187472561294950983
  { 299393099, 63, 28718726776ULL },   // factor: 17196377217601837649
  { 297992743, 63, 28860618380ULL },   // factor: 17200509671464832681
  { 297145423, 63, 28954010745ULL },   // factor: 17207103540739140271
  { 298204861, 63, 28856951100ULL },   // factor: 17210566183318594201
  { 297797363, 63, 28912608772ULL },   // factor: 17220197299504536473
  { 298462093, 63, 28849877643ULL },   // factor: 17221189728247373599
  { 298883383, 63, 28818024045ULL },   // factor: 17226457035889888471
  { 299373667, 63, 28780307748ULL },   // factor: 17232132535814543833
  { 298059109, 63, 28941616284ULL },   // factor: 17252624725257861913
  { 298972669, 63, 28858038975ULL },   // factor: 17255529868923548551
  { 299309081, 63, 28854177615ULL },   // factor: 17272634769912843631
  { 298089787, 63, 28975704668ULL },   // factor: 17274723265318051433
  { 298501097, 63, 28939280287ULL },   // factor: 17276813824119949679
  { 298612781, 63, 28939380103ULL },   // factor: 17283337545945792887
  { 299247691, 63, 28881293729ULL },   // factor: 17285320922992059479
  { 299033089, 63, 28907102316ULL },   // factor: 17288360199185068249
  { 298482869, 63, 28966483912ULL },   // factor: 17291998445792207057
  { 297696563, 63, 29054737840ULL },   // factor: 17298991187668087841
  { 299316313, 63, 28916386431ULL },   // factor: 17310292343620297807
  { 297061381, 63, 29174159156ULL },   // factor: 17333032016790308873
  { 297357257, 63, 29156096815ULL },   // factor: 17339553947469672911
  { 299811443, 63, 28917957121ULL },   // factor: 17339868906118271207
  { 298282249, 63, 29070447275ULL },   // factor: 17342396785245842951
  { 297301621, 63, 29186057916ULL },   // factor: 17354124658053363673
  { 297424847, 63, 29185348389ULL },   // factor: 17360895558480042967
  { 297859321, 63, 29160293060ULL },   // factor: 17371330182025224521
  { 298367813, 63, 29125172107ULL },   // factor: 17380027809628383983
  { 297416803, 63, 29223934596ULL },   // factor: 17383378397246833177
  { 297019561, 63, 29267834876ULL },   // factor: 17386238932580018873
  { 297977837, 63, 29181237747ULL },   // factor: 17390724209667626479
  { 298365757, 63, 29147939147ULL },   // factor: 17393493857169178559
  { 299331787, 63, 29081278553ULL },   // factor: 17409902155028528423
  { 299476973, 63, 29072232463ULL },   // factor: 17412928352743148999
  { 299204441, 63, 29109061983ULL },   // factor: 17419121237315733007
  { 298900711, 63, 29171575545ULL },   // factor: 17438809342781424991
  { 297014071, 63, 29360521989ULL },   // factor: 17440976325275814439
  { 299345071, 63, 29143832196ULL },   // factor: 17448125035847411833
  { 298236599, 63, 29274210717ULL },   // factor: 17461282085294862967
  { 299440787, 63, 29158323384ULL },   // factor: 17462382603410926417
  { 299920169, 63, 29119831332ULL },   // factor: 17467249468689870217
  { 298710073, 63, 29284555923ULL },   // factor: 17495183675063824759
  { 297046621, 63, 29464501311ULL },   // factor: 17504661107765240263
  { 298862639, 63, 29291590240ULL },   // factor: 17508323919266086721
  { 298634473, 63, 29321169251ULL },   // factor: 17512623854032379447
  { 297889883, 63, 29426951268ULL },   // factor: 17531982140542443289
  { 299570879, 63, 29289267045ULL },   // factor: 17548422947872765111
  { 299609731, 63, 29331786941ULL },   // factor: 17576177590284645743
  { 298005661, 63, 29499029519ULL },   // factor: 17581755581336214119
  { 299940617, 63, 29310867808ULL },   // factor: 17583039550273915073
  { 297860081, 63, 29517239004ULL },   // factor: 17584014401255598649
  { 298125199, 63, 29522389005ULL },   // factor: 17602736194142073991
  { 299648731, 63, 29403632925ULL },   // factor: 17621522585532136351
  { 297301087, 63, 29638055492ULL },   // factor: 17622852228675839609
  { 297907073, 63, 29605485955ULL },   // factor: 17639367331193319431
  { 297203801, 63, 29680032123ULL },   // factor: 17642036721515399047
  { 299517697, 63, 29448773004ULL },   // factor: 17640857339267703577
  { 297979691, 63, 29610946341ULL },   // factor: 17646921281817521263
  { 299018047, 63, 29540913480ULL },   // factor: 17666532510771147121
  { 297284341, 63, 29721779288ULL },   // factor: 17671639137961058417
  { 297680917, 63, 29714250503ULL },   // factor: 17690730675401502503
  { 298055171, 63, 29696456068ULL },   // factor: 17702364582883455257
  { 299230111, 63, 29596522581ULL },   // factor: 17712341474253272983
  { 297025403, 63, 29880457192ULL },   // factor: 17750509678556096753
  { 297835093, 63, 29800186428ULL },   // factor: 17751082592401435609
  { 297071329, 63, 29905436492ULL },   // factor: 17768095526007075737
  { 299578831, 63, 29666543553ULL },   // factor: 17774936874836653087
  { 297067171, 63, 29930365376ULL },   // factor: 17782657938489342593
  { 299479553, 63, 29739205992ULL },   // factor: 17812568234118163153
  { 297124379, 63, 30004437085ULL },   // factor: 17830099472250390431
  { 297025451, 63, 30019299781ULL },   // factor: 17832992112311452463
  { 297321571, 63, 30005669904ULL },   // factor: 17842665829529398369
  { 297241151, 63, 30043929984ULL },   // factor: 17860584658015143169
  { 297888439, 63, 29983596416ULL },   // factor: 17863533463936469249
  { 299972149, 63, 29789282895ULL },   // factor: 17871910414364182711
  { 297572663, 63, 30030844708ULL },   // factor: 17872716863798034809
  { 298748341, 63, 29915042483ULL },   // factor: 17874138625481541407
  { 298417517, 63, 29972660695ULL },   // factor: 17888733964970788631
  { 298445549, 63, 29997067384ULL },   // factor: 17904982487615747633
  { 299581729, 63, 29909831840ULL },   // factor: 17920878273452902721
  { 298541479, 63, 30015752945ULL },   // factor: 17921894554997811311
  { 298352707, 63, 30057038132ULL },   // factor: 17935197382168846649
  { 299881409, 63, 29916089259ULL },   // factor: 17942557997517371863
  { 298755713, 63, 30031523167ULL },   // factor: 17944178232466206143
  { 299217547, 63, 29983150800ULL },   // factor: 17942969667414175201
  { 298315027, 63, 30118109805ULL },   // factor: 17969369479335079471
  { 297577211, 63, 30195107760ULL },   // factor: 17970751906130514721
  { 299114539, 63, 30049490280ULL },   // factor: 17976478864574361841
  { 298066823, 63, 30158807613ULL },   // factor: 17978679941350246999
  { 297068843, 63, 30263359561ULL },   // factor: 17980602420158515847
  { 299056811, 63, 30066487453ULL },   // factor: 17983175711331384767
  { 299295419, 63, 30092133885ULL },   // factor: 18012875639430345631
  { 297286999, 63, 30311302665ULL },   // factor: 18022312410117104671
  { 297463711, 63, 30315927945ULL },   // factor: 18035776857856607791
  { 298947587, 63, 30168356320ULL },   // factor: 18037514651240399681
  { 297724717, 63, 30335169843ULL },   // factor: 18063059713308218863
  { 298934327, 63, 30221008693ULL },   // factor: 18068193789806209223
  { 297756647, 63, 30360132732ULL },   // factor: 18079862649510539209
  { 299840231, 63, 30165800848ULL },   // factor: 18089841389128631777
  { 297295601, 63, 30426171144ULL },   // factor: 18091133672768675089
  { 297722057, 63, 30425279124ULL },   // factor: 18116553371192876137
  { 297640159, 63, 30435592409ULL },   // factor: 18117709127747906063
  { 299035687, 63, 30301490640ULL },   // factor: 18122454141312939361
  { 297359509, 63, 30474350424ULL },   // factor: 18123675758349163633
  { 299568209, 63, 30275544511ULL },   // factor: 18139181291320101599
  { 297680893, 63, 30476156012ULL },   // factor: 18144338673718957433
  { 297630299, 63, 30519917409ULL },   // factor: 18167304287791950583
  { 297591751, 63, 30529277508ULL },   // factor: 18170522300741273017
  { 298991171, 63, 30389668729ULL },   // factor: 18172485279171583319
  { 299115307, 63, 30381269028ULL },   // factor: 18175005224719623193
  { 298901209, 63, 30408092660ULL },   // factor: 18178031318916051881
  { 297783817, 63, 30554917935ULL },   // factor: 18197520181612115791
  { 298212029, 63, 30515923335ULL },   // factor: 18200430829077593431
  { 298065389, 63, 30542879191ULL },   // factor: 18207550334490840599
  { 297539251, 63, 30630544760ULL },   // factor: 18227578691224749521
  { 298605163, 63, 30521503925ULL },   // factor: 18227757309059529551
  { 299821867, 63, 30411690264ULL },   // factor: 18236179507156405777
  { 298582597, 63, 30548478392ULL },   // factor: 18242488025363488049
  { 298156307, 63, 30626405860ULL },   // factor: 18262912135801518041
  { 297791453, 63, 30677069163ULL },   // factor: 18270737999662527679
  { 297276953, 63, 30748377492ULL },   // factor: 18281567941031083753
  { 297610631, 63, 30736949116ULL },   // factor: 18295285642855304393
  { 299461711, 63, 30557855340ULL },   // factor: 18301815289213773481
  { 298585009, 63, 30695339784ULL },   // factor: 18330336611327396113
  { 297172501, 63, 30875345736ULL },   // factor: 18350607423213611473
  { 298842373, 63, 30708067343ULL },   // factor: 18353743430051849879
  { 298910687, 63, 30726868093ULL },   // factor: 18369178502074019783
  { 297522509, 63, 30877903476ULL },   // factor: 18373742629678682569
  { 297537521, 63, 30879391180ULL },   // factor: 18375555003372929561
  { 299522791, 63, 30685601433ULL },   // factor: 18382073969451519007
  { 298002161, 63, 30915226240ULL },   // factor: 18425608454647809281
  { 299387989, 63, 30777955191ULL },   // factor: 18429100220331201799
  { 299040809, 63, 30816753859ULL },   // factor: 18430934009498463863
  { 299370073, 63, 30783845063ULL },   // factor: 18431523887461999199
  { 298897901, 63, 30842882715ULL },   // factor: 18437745808605362431
  { 297595153, 64, 31033030356ULL },   // factor: 18470558833694928937
  { 297756761, 64, 31040312800ULL },   // factor: 18484925999509681601
  { 297159323, 64, 31122224437ULL },   // factor: 18496518287905952303
  { 298020403, 64, 31033838973ULL },   // factor: 18497434394741132239
  { 299005279, 64, 30976050080ULL },   // factor: 18524004992976744641
  { 297859147, 64, 31103762340ULL },   // factor: 18529080238166247961
  { 298065767, 64, 31084459528ULL },   // factor: 18530426541987555953
  { 299717273, 64, 30912016551ULL },   // factor: 18529730607193170847
  { 297022903, 64, 31216910721ULL },   // factor: 18544274890086486127
  { 299597063, 64, 30982347505ULL },   // factor: 18564440634686755631
  { 298696927, 64, 31081508000ULL },   // factor: 18567901852251832001
  { 297526429, 64, 31215364080ULL },   // factor: 18574791609314540641
  { 299457671, 64, 31032512388ULL },   // factor: 18585847769978256697
  { 297049741, 64, 31315897880ULL },   // factor: 18604758708872898161
  { 298546819, 64, 31173940136ULL },   // factor: 18613761326598454769
  { 299958017, 64, 31117390107ULL },   // factor: 18667821261422275639
  { 298770859, 64, 31320022397ULL },   // factor: 18715019990901858047
  { 297064529, 64, 31504163736ULL },   // factor: 18717539123547440689
  { 297096031, 64, 31506199844ULL },   // factor: 18720733851090438329
  { 297377299, 64, 31511350185ULL },   // factor: 18741520411716900631
  { 297838921, 64, 31470466416ULL },   // factor: 18746259521416354273
  { 297405733, 64, 31526295380ULL },   // factor: 18752201972526827081
  { 297603253, 64, 31525274991ULL },   // factor: 18764048778082291447
  { 299065999, 64, 31391280881ULL },   // factor: 18776129553131730239
  { 298495369, 64, 31473082319ULL },   // factor: 18789138640754561423
  { 299249539, 64, 31419801452ULL },   // factor: 18804722199965061257
  { 299783123, 64, 31390079401ULL },   // factor: 18820432068099498647
  { 299665253, 64, 31426415095ULL },   // factor: 18834809260652388071
  { 297702467, 64, 31642473609ULL },   // factor: 18840084910763386807
  { 297295543, 64, 31687078632ULL },   // factor: 18840854495968274353
  { 298818007, 64, 31535934548ULL },   // factor: 18847010221031611673
  { 297868199, 64, 31639798881ULL },   // factor: 18848979818811370639
  { 298124341, 64, 31626974660ULL },   // factor: 18857541956672398121
  { 297089357, 64, 31741611819ULL },   // factor: 18860190090900620767
  { 298637051, 64, 31591458940ULL },   // factor: 18868760269258371881
  { 298258267, 64, 31638632973ULL },   // factor: 18872967681552075583
  { 299149363, 64, 31546657437ULL },   // factor: 18874324954115525263
  { 297534467, 64, 31731543945ULL },   // factor: 18882456029525304631
  { 297474169, 64, 31757697351ULL },   // factor: 18894189257684452639
  { 298946099, 64, 31644370452ULL },   // factor: 18919922203872533497
  { 299301061, 64, 31620550799ULL },   // factor: 18928128807090195479
  { 298894781, 64, 31708585948ULL },   // factor: 18955061705494274777
  { 297757513, 64, 31833430455ULL },   // factor: 18957286165078516831
  { 299504903, 64, 31665237801ULL },   // factor: 18967787952120876607
  { 298643333, 64, 31801108447ULL },   // factor: 18994378039413067703
  { 298787011, 64, 31799207436ULL },   // factor: 19002380283942827593
  { 297169783, 64, 32040164696ULL },   // factor: 19042737579989161937
  { 297577369, 64, 32036053299ULL },   // factor: 19066408907720380663
  { 298518137, 64, 31941981432ULL },   // factor: 19070521578338464369
  { 299504797, 64, 31839431307ULL },   // factor: 19072124820396959359
  { 297847441, 64, 32019629564ULL },   // factor: 19073929454810691449
  { 299233783, 64, 31877649740ULL },   // factor: 19077739449698332841
  { 297260773, 64, 32097702756ULL },   // factor: 19082775865545580777
  { 299637787, 64, 31865574593ULL },   // factor: 19096260505059891383
  { 299334179, 64, 31901002080ULL },   // factor: 19098120533788184641
  { 297950453, 64, 32062751172ULL },   // factor: 19106222472247361833
  { 298446833, 64, 32067351751ULL },   // factor: 19140799145565909167
  { 299003183, 64, 32035325356ULL },   // factor: 19157328499769216297
  { 299926043, 64, 31959328941ULL },   // factor: 19170870132419020927
  { 297086761, 64, 32275084539ULL },   // factor: 19177000653385376359
  { 298378081, 64, 32157504563ULL },   // factor: 19190189002513367207
  { 299646407, 64, 32032604532ULL },   // factor: 19196909709731433049
  { 299397781, 64, 32065272720ULL },   // factor: 19200542999055668641
  { 298566251, 64, 32161594501ULL },   // factor: 19204733392691571503
  { 297506129, 64, 32318780476ULL },   // factor: 19230070546831074809
  { 299489089, 64, 32116758207ULL },   // factor: 19237237314095406847
  { 299610209, 64, 32137814016ULL },   // factor: 19257634348273778689
  { 297647083, 64, 32358874437ULL },   // factor: 19263049170672634543
  { 297130543, 64, 32423422832ULL },   // factor: 19267978463981515553
  { 299012237, 64, 32228877219ULL },   // factor: 19273657346503057807
  { 298009577, 64, 32380914912ULL },   // factor: 19299645511596224449
  { 297171793, 64, 32502651867ULL },   // factor: 19317742665142375063
  { 297311737, 64, 32489862380ULL },   // factor: 19319234838177508121
  { 297509791, 64, 32495994600ULL },   // factor: 19335753123566257201
  { 299838961, 64, 32242895691ULL },   // factor: 19335352687241634103
  { 298777781, 64, 32377155235ULL },   // factor: 19347149192411667071
  { 297102383, 64, 32575438716ULL },   // factor: 19356480939588120457
  { 297625651, 64, 32540604560ULL },   // factor: 19369837232207137121
  { 299792957, 64, 32324928555ULL },   // factor: 19381571832634374271
  { 297153707, 64, 32707307169ULL },   // factor: 19438195142512050967
  { 297640793, 64, 32655620232ULL },   // factor: 19439289403518647953
  { 298519157, 64, 32591300920ULL },   // factor: 19458255352343448881
  { 299462623, 64, 32491416396ULL },   // factor: 19459929557862733417
  { 299233777, 64, 32543297192ULL },   // factor: 19476107469591308369
  { 297795709, 64, 32736040860ULL },   // factor: 19497304995513339481
  { 297984289, 64, 32752275420ULL },   // factor: 19519327008321752761
  { 297641051, 64, 32814898905ULL },   // factor: 19534121997085898311
  { 297756803, 64, 32949759165ULL },   // factor: 19622029897180698991
  { 298249229, 64, 32926991256ULL },   // factor: 19640899510783483249
  { 297070421, 64, 33097273780ULL },   // factor: 19664442111553722761
  { 298121249, 64, 32982713784ULL },   // factor: 19665695657391192433
  { 299393777, 64, 32843473927ULL },   // factor: 19666263417611104559
  { 297622771, 64, 33066746765ULL },   // factor: 19682833600309171631
  { 298088191, 64, 33046761149ULL },   // factor: 19701698498628982919
  { 297389297, 64, 33138893655ULL },   // factor: 19710304574836421071
  { 297390581, 64, 33166462428ULL },   // factor: 19726787062355181337
  { 298463873, 64, 33049420123ULL },   // factor: 19728115860629432759
  { 298330477, 64, 33067316595ULL },   // factor: 19729976665792731631
  { 298835419, 64, 33016737192ULL },   // factor: 19733140985568406897
  { 298715621, 64, 33055017211ULL },   // factor: 19748099986699106063
  { 299295509, 64, 33007057972ULL },   // factor: 19757728432644495497
  { 298981547, 64, 33057895369ULL },   // factor: 19767401395975511687
  { 298540829, 64, 33129609007ULL },   // factor: 19781081874791293607
  { 298785947, 64, 33111905904ULL },   // factor: 19786744325003062177
  { 298139791, 64, 33208070673ULL },   // factor: 19801294499922898687
  { 297268513, 64, 33337595976ULL },   // factor: 19820435165560607377
  { 298324837, 64, 33218956475ULL },   // factor: 19820079551428939151
  { 299369039, 64, 33103276680ULL },   // factor: 19820192254885421041
  { 299269441, 64, 33144454548ULL },   // factor: 19838244769659735337
  { 299798113, 64, 33134244912ULL },   // factor: 19867168200594902113
  { 297960863, 64, 33350731116ULL },   // factor: 19874425250008626217
  { 299682973, 64, 33172589603ULL },   // factor: 19882520548671859439
  { 298218043, 64, 33340348113ULL },   // factor: 19885386734395205719
  { 299782963, 64, 33196925741ULL },   // factor: 19903745522255901167
  { 297293951, 64, 33520614585ULL },   // factor: 19930951899845750671
  { 299919857, 64, 33268399795ULL },   // factor: 19955707418270458631
  { 299913511, 64, 33341971473ULL },   // factor: 19999415456258543407
  { 297887621, 64, 33652673619ULL },   // factor: 20049429769306740799
  { 298898141, 64, 33557625216ULL },   // factor: 20060623586874246913
  { 297595267, 64, 33714387617ULL },   // factor: 20066484369245217479
  { 298993397, 64, 33557620995ULL },   // factor: 20067014193067140031
  { 298849723, 64, 33581387145ULL },   // factor: 20071576492478021671
  { 298137803, 64, 33668410356ULL },   // factor: 20075651788080575737
  { 299988289, 64, 33480951960ULL },   // factor: 20087786985143192881
  { 297429493, 64, 33772668296ULL },   // factor: 20089975217072907857
  { 299446673, 64, 33577781083ULL },   // factor: 20109509664053373719
  { 298733957, 64, 33670696875ULL },   // factor: 20117161024832568751
  { 297166789, 64, 33874176704ULL },   // factor: 20132560642292566913
  { 298999777, 64, 33696493299ULL },   // factor: 20150487964165988647
  { 297120113, 64, 33938048875ULL },   // factor: 20167353833479045751
  { 298805791, 64, 33760512101ULL },   // factor: 20175673045808753783
  { 298653661, 64, 33788829855ULL },   // factor: 20182315474203698311
  { 297139207, 64, 33988325657ULL },   // factor: 20198528265957467999
  { 298345067, 64, 33853721397ULL },   // factor: 20200181556774597199
  { 299937683, 64, 33677792953ULL },   // factor: 20202478373753095799
  { 299386621, 64, 33750483888ULL },   // factor: 20208886656686524897
  { 299442701, 64, 33756230679ULL },   // factor: 20216113780197647959
  { 299729063, 64, 33727153392ULL },   // factor: 20218016167682863393
  { 297916529, 64, 33969869880ULL },   // factor: 20240371450462493041
  { 297105059, 64, 34082029849ULL },   // factor: 20251886978253812183
  { 298073179, 64, 33983759081ULL },   // factor: 20259294207287576999
  { 297418741, 64, 34089459960ULL },   // factor: 20277688525346220721
  { 297950593, 64, 34033361115ULL },   // factor: 20280520251994782391
  { 299480729, 64, 33858473247ULL },   // factor: 20279920501677114127
  { 298125463, 64, 34014857276ULL },   // factor: 20281390148572837577
  { 297632749, 64, 34092743400ULL },   // factor: 20294233878187213201
  { 299897623, 64, 33934623417ULL },   // factor: 20353825800316875583
  { 298841513, 64, 34062773416ULL },   // factor: 20358741489227236817
  { 297616289, 64, 34270743744ULL },   // factor: 20399063148718492033
  { 298526887, 64, 34165065705ULL },   // factor: 20398381418128220671
  { 299532007, 64, 34102854720ULL },   // factor: 20429793037422046081
  { 297157937, 64, 34394351103ULL },   // factor: 20441108836442309023
  { 299789363, 64, 34117440601ULL },   // factor: 20456091569928254327
  { 297556871, 64, 34393896136ULL },   // factor: 20468280231454300913
  { 298797721, 64, 34258623783ULL },   // factor: 20472797421913597087
  { 297132499, 64, 34470055269ULL },   // factor: 20484347325492174463
  { 298427543, 64, 34323079953ULL },   // factor: 20485904837132690959
  { 297799529, 64, 34434849352ULL },   // factor: 20509363836423110417
  { 297775337, 64, 34474865008ULL },   // factor: 20531529091573415393
  { 297133541, 64, 34564574428ULL },   // factor: 20540588785899379097
  { 297147937, 64, 34563616667ULL },   // factor: 20541014775715731959
  { 297489301, 64, 34558778175ULL },   // factor: 20561733525389611351
  { 298351709, 64, 34470296155ULL },   // factor: 20568543535160757791
  { 298181087, 64, 34496653584ULL },   // factor: 20572499327079131617
  { 299591723, 64, 34352532693ULL },   // factor: 20583468917819400079
  { 298343687, 64, 34511880625ULL },   // factor: 20592803421932728751
  { 298583657, 64, 34547744463ULL },   // factor: 20630783765728082383
  { 297981263, 64, 34676664700ULL },   // factor: 20665992687867032201
  { 299490923, 64, 34510376176ULL },   // factor: 20671088828054900897
  { 298092413, 64, 34733147776ULL },   // factor: 20707375663266846977
  { 299922647, 64, 34530299848ULL },   // factor: 20712837864231715313
  { 298646479, 64, 34704005057ULL },   // factor: 20728457834942488607
  { 298871189, 64, 34693283772ULL },   // factor: 20737645942504089817
  { 298875799, 64, 34695653532ULL },   // factor: 20739382342407344137
  { 299328083, 64, 34654171557ULL },   // factor: 20745933480219870463
  { 299648633, 64, 34652652640ULL },   // factor: 20767239986799682241
  { 297133063, 64, 34947192648ULL },   // factor: 20767932789502641649
  { 297623929, 64, 34895615255ULL },   // factor: 20771540234130873791
  { 297351017, 64, 34993210423ULL },   // factor: 20810533414748100383
  { 298918897, 64, 34830295880ULL },   // factor: 20822867253266488721
  { 297944039, 64, 34968848572ULL },   // factor: 20837519965442124617
  { 297938717, 64, 34979055960ULL },   // factor: 20843230109187206641
  { 299159309, 64, 34881371736ULL },   // factor: 20870174131027780849
  { 299792417, 64, 34845617347ULL },   // factor: 20892903692628515399
  { 299922743, 64, 34841183685ULL },   // factor: 20899326760344095911
  { 299724713, 64, 34930109047ULL },   // factor: 20938833818341557023
  { 299789597, 64, 34933888987ULL },   // factor: 20945633002110936479
  { 297785357, 64, 35173136427ULL },   // factor: 20948089975447798879
  { 299757223, 64, 34958386040ULL },   // factor: 20958057439824733841
  { 297498233, 64, 35240703808ULL },   // factor: 20968094225112742529
  { 299450927, 64, 35041436524ULL },   // factor: 20986381301046915497
  { 299030167, 64, 35138223824ULL },   // factor: 21014777876348197217
  { 298227031, 64, 35285078456ULL },   // factor: 21045928373069888273
  { 299288599, 64, 35161305020ULL },   // factor: 21046755436894933961
  { 298399463, 64, 35301099616ULL },   // factor: 21067658337447812417
  { 297313319, 64, 35442760072ULL },   // factor: 21075209263053997937
  { 299385673, 64, 35227192656ULL },   // factor: 21093033562434434977
  { 299649737, 64, 35246287288ULL },   // factor: 21123081432151286513
  { 299676031, 64, 35244468404ULL },   // factor: 21123844812031249049
  { 297285893, 64, 35538644883ULL },   // factor: 21130275560105071039
  { 299990839, 64, 35222216684ULL },   // factor: 21132684668945915753
  { 297394367, 64, 35539830580ULL },   // factor: 21138690837252685721
  { 299195341, 64, 35337737883ULL },   // factor: 21145773072145606207
  { 297389023, 64, 35592445632ULL },   // factor: 21169605265362195073
  { 298685693, 64, 35437493508ULL },   // factor: 21169344613239962089
  { 299491789, 64, 35364533112ULL },   // factor: 21182774577725234737
  { 299805643, 64, 35345733788ULL },   // factor: 21193700891236331369
  { 297007273, 64, 35691446607ULL },   // factor: 21201238452340345423
  { 298939721, 64, 35594366323ULL },   // factor: 21281139875538831767
  { 297771701, 64, 35746156663ULL },   // factor: 21288387747507987527
  { 298032019, 64, 35793996404ULL },   // factor: 21335514032725719353
  { 298457569, 64, 35776213496ULL },   // factor: 21355363416082302449
  { 297170941, 64, 35944747944ULL },   // factor: 21363469141052590609
  { 299626351, 64, 35656418424ULL },   // factor: 21367205084224581649
  { 298099273, 64, 35871851675ULL },   // factor: 21386745810962664551
  { 299032781, 64, 35788298920ULL },   // factor: 21403749106613793041
  { 299627719, 64, 35718796296ULL },   // factor: 21404682919192257649
  { 299559823, 64, 35740467101ULL },   // factor: 21412815997425766247
  { 299862701, 64, 35712854383ULL },   // factor: 21417905951412136967
  { 299196661, 64, 35797552823ULL },   // factor: 21421016553225448007
  { 298260377, 64, 35915451379ULL },   // factor: 21424312136851419767
  { 299989073, 64, 35717028852ULL },   // factor: 21429436751251468393
  { 298907083, 64, 35865316041ULL },   // factor: 21440793997376836807
  { 299614543, 64, 35854450380ULL },   // factor: 21485029530239752681
  { 299661071, 64, 35945543176ULL },   // factor: 21542959931593802993
  { 299404283, 64, 35987539392ULL },   // factor: 21549646857192031873
  { 297664937, 64, 36230413044ULL },   // factor: 21569047232452476457
  { 299121359, 64, 36055978900ULL },   // factor: 21570226817286650201
  { 299044813, 64, 36071328347ULL },   // factor: 21573887280380428223
  { 299935813, 64, 36018538712ULL },   // factor: 21606499383311385713
  { 297544529, 64, 36339377647ULL },   // factor: 21625166012259486527
  { 297216613, 64, 36407245316ULL },   // factor: 21641676282963269417
  { 299914961, 64, 36082850571ULL },   // factor: 21643573443540585463
  { 299741527, 64, 36115576545ULL },   // factor: 21650676124167368431
  { 299231293, 64, 36184390532ULL },   // factor: 21655003930614635753
  { 299157241, 64, 36216086136ULL },   // factor: 21668608816528221553
  { 297488383, 64, 36452654768ULL },   // factor: 21688482645979120289
  { 298851001, 64, 36302183915ULL },   // factor: 21697888002967697831
  { 299220239, 64, 36266570212ULL },   // factor: 21703383613089841337
  { 297055393, 64, 36540772035ULL },   // factor: 21709266794760669511
  { 298394333, 64, 36384712752ULL },   // factor: 21713984186059268833
  { 297564713, 64, 36507289507ULL },   // factor: 21726562249116732983
  { 299083727, 64, 36345431349ULL },   // factor: 21740654134563115447
  { 297659473, 64, 36531097956ULL },   // factor: 21747654731388674377
  { 297617783, 64, 36571850193ULL },   // factor: 21768865949297564239
  { 299915159, 64, 36334396384ULL },   // factor: 21794472537352770113
  { 299705503, 64, 36383826300ULL },   // factor: 21808865924612257801
  { 297364009, 64, 36699133476ULL },   // factor: 21826002914498930569
  { 298297141, 64, 36584983136ULL },   // factor: 21826391746004028353
  { 298442017, 64, 36617665643ULL },   // factor: 21856499984657043863
  { 297190819, 64, 36774124004ULL },   // factor: 21857864061512638553
  { 298261619, 64, 36643717341ULL },   // factor: 21858828920610070159
  { 297889957, 64, 36703316039ULL },   // factor: 21867098473230240647
  { 297702253, 64, 36748238828ULL },   // factor: 21880066985755358969
  { 299397221, 64, 36543624736ULL },   // factor: 21882119382450517313
  { 297801107, 64, 36771214417ULL },   // factor: 21901016718233919239
  { 299197111, 64, 36626826189ULL },   // factor: 21917281161695879959
  { 297907381, 64, 36819184563ULL },   // factor: 21937413687437919007
  { 298342073, 64, 36763660252ULL },   // factor: 21936293221298764793
  { 299774809, 64, 36614914239ULL },   // factor: 21952457845095210703
  { 298759801, 64, 36742405628ULL },   // factor: 21954307587365120057
  { 297389503, 64, 37007281100ULL },   // factor: 22011153867420586601
  { 298325513, 64, 36931185615ULL },   // factor: 22035029788586190991
  { 297963013, 64, 37049424116ULL },   // factor: 22078716079036443017
  { 299884531, 64, 36876601241ULL },   // factor: 22117444536062605943
  { 298109281, 64, 37144919415ULL },   // factor: 22146490439217181231
  { 297848867, 64, 37191731485ULL },   // factor: 22155030169150954991
  { 299090767, 64, 37037613653ULL },   // factor: 22155216550650883703
  { 297301633, 64, 37286308208ULL },   // factor: 22170560637559407329
  { 297403927, 64, 37291517792ULL },   // factor: 22181287670262338369
  { 298674743, 64, 37135806928ULL },   // factor: 22183055180636039009
  { 299881727, 64, 37018200673ULL },   // factor: 22202163896503604543
  { 297633887, 64, 37302289585ULL },   // factor: 22204850886366333791
  { 297373133, 64, 37357823791ULL },   // factor: 22218426205583214407
  { 299786701, 64, 37115179928ULL },   // factor: 22253274695273075057
  { 299151199, 64, 37231641552ULL },   // factor: 22275780422038041697
  { 298551899, 64, 37322773684ULL },   // factor: 22285569918610851833
  { 299026121, 64, 37287484119ULL },   // factor: 22299863475907344799
  { 299651249, 64, 37217997727ULL },   // factor: 22304839008349422047
  { 298643747, 64, 37354016745ULL },   // factor: 22311087052455087031
  { 297601589, 64, 37495270692ULL },   // factor: 22317304275848659177
  { 297200269, 64, 37550646287ULL },   // factor: 22320124355240502407
  { 298009391, 64, 37468472776ULL },   // factor: 22331913507351678833
  { 297207871, 64, 37630429509ULL },   // factor: 22368119678370930679
  { 297384011, 64, 37620074916ULL },   // factor: 22375217545281136153
  { 299970563, 64, 37371808717ULL },   // factor: 22420885002333595343
  { 298228729, 64, 37664982735ULL },   // factor: 22465559857731987631
  { 298892899, 64, 37615865429ULL },   // factor: 22486230132935377343
  { 298729091, 64, 37641729313ULL },   // factor: 22489359162681088967
  { 297377153, 64, 37843993096ULL },   // factor: 22507877850080271377
  { 298438759, 64, 37759623396ULL },   // factor: 22537870293219211129
  { 299791711, 64, 37609305021ULL },   // factor: 22549915803532961863
  { 297596093, 64, 37940993232ULL },   // factor: 22582182700765285153
  { 298567237, 64, 37817930315ULL },   // factor: 22582389926416179311
  { 299877889, 64, 37650841427ULL },   // factor: 22581309692405015207
  { 298934491, 64, 37787157296ULL },   // factor: 22591769265233392673
  { 297474679, 64, 37979064656ULL },   // factor: 22595620134527690849
  { 299874859, 64, 37695401937ULL },   // factor: 22607806681612403767
  { 297154801, 64, 38053780008ULL },   // factor: 22615726851150036817
  { 299287489, 64, 37818591204ULL },   // factor: 22637262397925293513
  { 298275377, 64, 37993742620ULL },   // factor: 22665195807242935481
  { 299112139, 64, 37962897612ULL },   // factor: 22710327014726624137
  { 298971287, 64, 37984943169ULL },   // factor: 22712814691715577007
  { 299398423, 64, 37971018948ULL },   // factor: 22736926385468638009
  { 298868569, 64, 38067993440ULL },   // factor: 22754653448228374721
  { 298561867, 64, 38121345920ULL },   // factor: 22763160420856065281
  { 299622553, 64, 37987364772ULL },   // factor: 22763742429457805833
  { 298067807, 64, 38190196297ULL },   // factor: 22766536118292621359
  { 299620303, 64, 38039767997ULL },   // factor: 22794973626621686183
  { 298808767, 64, 38166960773ULL },   // factor: 22809244977434993783
  { 297910759, 64, 38291527941ULL },   // factor: 22814916304346034439
  { 299370389, 64, 38139776359ULL },   // factor: 22835839369933667303
  { 297164089, 64, 38446673552ULL },   // factor: 22849941442320948257
  { 297698081, 64, 38402147451ULL },   // factor: 22864491204883483063
  { 297661207, 64, 38480674068ULL },   // factor: 22908407778508960153
  { 297021419, 64, 38578553941ULL },   // factor: 22917313669047724559
  { 297706579, 64, 38512587924ULL },   // factor: 22930901598581503993
  { 298535387, 64, 38416081008ULL },   // factor: 22937119221493260193
  { 299998267, 64, 38285530737ULL },   // factor: 22971185744550465559
  { 297929887, 64, 38579488517ULL },   // factor: 22987965308775215159
  { 298486579, 64, 38510770776ULL },   // factor: 22989896447162830609
  { 297749267, 64, 38610804220ULL },   // factor: 22992677309571013481
  { 298770809, 64, 38496636739ULL },   // factor: 23003342604580303703
  { 298450463, 64, 38583257725ULL },   // factor: 23030382264149153351
  { 298899379, 64, 38532728916ULL },   // factor: 23034817488335486329
  { 298222153, 64, 38640932760ULL },   // factor: 23047164323230864561
  { 299398301, 64, 38493139896ULL },   // factor: 23049561370035433393
  { 299940371, 64, 38443668933ULL },   // factor: 23061616644730388287
  { 297849611, 64, 38715663373ULL },   // factor: 23062890550509995807
  { 297781139, 64, 38767053592ULL },   // factor: 23088194748599602577
  { 297535471, 64, 38809275648ULL },   // factor: 23094272218193020417
  { 298461029, 64, 38748100872ULL },   // factor: 23129596116105834577
  { 298925377, 64, 38697340380ULL },   // factor: 23135234123977646521
  { 299272691, 64, 38674522461ULL },   // factor: 23148456820086825103
  { 297531551, 64, 38905798273ULL },   // factor: 23151405006117622847
  { 298836103, 64, 38751289376ULL },   // factor: 23160568606698283457
  { 297240887, 64, 38977982329ULL },   // factor: 23171700081884571647
  { 297134581, 64, 39000640503ULL },   // factor: 23176877949181068487
  { 297162053, 64, 39037488415ULL },   // factor: 23200920402730231991
  { 298325351, 64, 38900847076ULL },   // factor: 23210217716290047353
  { 299220049, 64, 38784502152ULL },   // factor: 23210201268724090897
  { 297053021, 64, 39108715939ULL },   // factor: 23234724434221603439
  { 297524473, 64, 39061548692ULL },   // factor: 23243533378302278633
  { 299390879, 64, 38830398861ULL },   // factor: 23250934493830777639
  { 299756101, 64, 38826077291ULL },   // factor: 23276707091749604783
  { 298170331, 64, 39048806465ULL },   // factor: 23286391097647979831
  { 297850429, 64, 39129756255ULL },   // factor: 23309629374434366791
  { 297036667, 64, 39266004492ULL },   // factor: 23326886201421416329
  { 299011067, 64, 39081841425ULL },   // factor: 23371806209628100951
  { 298866223, 64, 39136395456ULL },   // factor: 23393093383538165377
  { 298604351, 64, 39192773401ULL },   // factor: 23406265330591335503
  { 299934493, 64, 39027066576ULL },   // factor: 23411126853499611937
  { 297676399, 64, 39416301336ULL },   // factor: 23466605287198738129
  { 299452631, 64, 39220661013ULL },   // factor: 23489460259803950407
  { 298151351, 64, 39396641116ULL },   // factor: 23492323547195095433
  { 299490869, 64, 39227541439ULL },   // factor: 23496580948599240983
  { 299093689, 64, 39289779627ULL },   // factor: 23502650257272948007
  { 299232757, 64, 39281414912ULL },   // factor: 23508572165957344769
  { 298146491, 64, 39431307460ULL },   // factor: 23512611909482245721
  { 297438497, 64, 39529676704ULL },   // factor: 23515295251467347777
  { 299656417, 64, 39256509684ULL },   // factor: 23526930071666484457
  { 297403889, 64, 39575961379ULL },   // factor: 23540089650056805863
  { 299718121, 64, 39295044488ULL },   // factor: 23554873797109534097
  { 299686787, 64, 39307312753ULL },   // factor: 23559764529101389223
  { 297193607, 64, 39687271597ULL },   // factor: 23589606795802160759
  { 297858107, 64, 39643782864ULL },   // factor: 23616444236380156897
  { 297548143, 64, 39724615341ULL },   // factor: 23639971052207723527
  { 297303709, 64, 39807693216ULL },   // factor: 23669949679701876289
  { 298092631, 64, 39715343384ULL },   // factor: 23677702400810006609
  { 298421839, 64, 39690473969ULL },   // factor: 23689008465221217983
  { 297307771, 64, 39849715421ULL },   // factor: 23695260133603673183
  { 299061757, 64, 39615125339ULL },   // factor: 23694737975313121247
  { 299755627, 64, 39568484529ULL },   // factor: 23721751778860389367
  { 297179293, 64, 39919535256ULL },   // factor: 23726518528533308017
  { 299748649, 64, 39589759431ULL },   // factor: 23733953807354517439
  { 299190061, 64, 39717146960ULL },   // factor: 23765951243416729121
  { 297444617, 64, 39956729820ULL },   // factor: 23769828395764757881
  { 297886877, 64, 39943486687ULL },   // factor: 23797281011363012999
  { 298219013, 64, 39931296616ULL },   // factor: 23816543729267520017
  { 297013751, 64, 40129896513ULL },   // factor: 23838262181135900527
  { 299160941, 64, 39843641800ULL },   // factor: 23839322747509867601
  { 297177011, 64, 40137748680ULL },   // factor: 23856032361983190961
  { 298849561, 64, 39964699403ULL },   // factor: 23886865744167024167
  { 298511287, 64, 40053176360ULL },   // factor: 23912650447323150641
  { 299696323, 64, 39909406317ULL },   // factor: 23921404652635744783
  { 297516781, 64, 40204155879ULL },   // factor: 23922822079884610999
  { 297876199, 64, 40164425109ULL },   // factor: 23928052572978161383
  { 299934781, 64, 39908233479ULL },   // factor: 23939734537241466199
  { 298160843, 64, 40247065105ULL },   // factor: 24000197719965367031
  { 299442457, 64, 40104739884ULL },   // factor: 24018123696421709977
  { 298530163, 64, 40282159041ULL },   // factor: 24050879009003307367
  { 297011009, 64, 40516892359ULL },   // factor: 24067926162181960463
  { 299902591, 64, 40126659881ULL },   // factor: 24068178532975303343
  { 299863481, 64, 40196225680ULL },   // factor: 24106760310932784161
  { 298974523, 64, 40331209373ULL },   // factor: 24116008168611608159
  { 297020177, 64, 40631644335ULL },   // factor: 24136836384365494591
  { 298480219, 64, 40456693361ULL },   // factor: 24151045388814252119
  { 299849129, 64, 40277671695ULL },   // factor: 24154449551787407311
  { 298765553, 64, 40436184196ULL },   // factor: 24161877865055600777
  { 297673729, 64, 40638321180ULL },   // factor: 24193921211900560441
  { 298877779, 64, 40496564021ULL },   // factor: 24207046223455578719
  { 299624573, 64, 40402849483ULL },   // factor: 24211373048654291519
  { 297141331, 64, 40745826380ULL },   // factor: 24214538166496223561
  { 299654783, 64, 40445092813ULL },   // factor: 24239131020588749159
  { 298339663, 64, 40643195400ULL },   // factor: 24250954437758300401
  { 298902193, 64, 40646353815ULL },   // factor: 24298568585514832591
  { 299547461, 64, 40605537135ULL },   // factor: 24326571102660928471
  { 299957773, 64, 40572207167ULL },   // factor: 24339897815015918183
  { 298059019, 64, 40833478112ULL },   // factor: 24341572856841384257
  { 299427809, 64, 40657220772ULL },   // factor: 24347805071578497097
  { 299653933, 64, 40677772112ULL },   // factor: 24378508798077032993
  { 299710181, 64, 40685607904ULL },   // factor: 24387781818005741249
  { 298399967, 64, 40872290548ULL },   // factor: 24392580301475223833
  { 297485347, 64, 41002643148ULL },   // factor: 24395371049599904713
  { 297141179, 64, 41065967160ULL },   // factor: 24404779797395363281
  { 297701189, 64, 41014853295ULL },   // factor: 24420341185164135511
  { 299229059, 64, 40814449545ULL },   // factor: 24425738661906656311
  { 297690103, 64, 41051773428ULL },   // factor: 24441413320227966169
  { 298668511, 64, 40933283748ULL },   // factor: 24450965814711318457
  { 297721631, 64, 41078756244ULL },   // factor: 24460068616830227929
  { 298981931, 64, 40908410461ULL },   // factor: 24461751107540760383
  { 297425417, 64, 41149496548ULL },   // factor: 24477812340257921033
  { 298199701, 64, 41076081083ULL },   // factor: 24497750194404712367
  { 297184273, 64, 41241660468ULL },   // factor: 24512745766990839529
  { 298745453, 64, 41069264232ULL },   // factor: 24538511894731074193
  { 297604471, 64, 41244108521ULL },   // factor: 24548862196517594783
  { 297314651, 64, 41327547889ULL },   // factor: 24574570954607643479
  { 299834237, 64, 41017578819ULL },   // factor: 24596948897564452207
  { 299998807, 64, 40996901169ULL },   // factor: 24598042882793810767
  { 299128603, 64, 41141249445ULL },   // factor: 24613048944314750671
  { 299256367, 64, 41135501645ULL },   // factor: 24620121554010447431
  { 297164683, 64, 41452494825ULL },   // factor: 24636434968460530951
  { 297308147, 64, 41432328184ULL },   // factor: 24636337436561830097
  { 298526507, 64, 41271281857ULL },   // factor: 24641143224365366999
  { 299037301, 64, 41212513820ULL },   // factor: 24648157800315999641
  { 298026493, 64, 41354514632ULL },   // factor: 24649481930984291153
  { 297213781, 64, 41509415283ULL },   // factor: 24674340526719230047
  { 298351373, 64, 41358781575ULL },   // factor: 24678898537016704951
  { 299578277, 64, 41213080515ULL },   // factor: 24693087301091945311
  { 298689409, 64, 41338479180ULL },   // factor: 24694731830466009241
  { 299240089, 64, 41289409947ULL },   // factor: 24710893414595530567
  { 297957887, 64, 41478091317ULL },   // factor: 24717448891212734359
  { 298635437, 64, 41389916148ULL },   // factor: 24720991392502673353
  { 298974149, 64, 41402199055ULL },   // factor: 24756374458394458391
  { 297950309, 64, 41563075119ULL },   // factor: 24767462149392523543
  { 299674813, 64, 41346259020ULL },   // factor: 24780864880136126521
  { 298804819, 64, 41486516364ULL },   // factor: 24792742026171116233
  { 298521959, 64, 41546128129ULL },   // factor: 24804863115868169423
  { 298822429, 64, 41562281019ULL },   // factor: 24839483537756350303
  { 299622937, 64, 41460984068ULL },   // factor: 24845323634728735433
  { 298475963, 64, 41685898953ULL },   // factor: 24884477667034733479
  { 299145551, 64, 41600405536ULL },   // factor: 24889152471780340673
  { 299375143, 64, 41570635697ULL },   // factor: 24890430012780559343
  { 297873481, 64, 41807037879ULL },   // factor: 24906415806633173599
  { 298118549, 64, 41787889492ULL },   // factor: 24915489962254774217
  { 299984063, 64, 41531751885ULL },   // factor: 24917727347940417511
  { 297172751, 64, 41964044088ULL },   // factor: 24941140849432492177
  { 297925679, 64, 41960063572ULL },   // factor: 25001960861142530777
  { 298786511, 64, 41853985245ULL },   // factor: 25010812445598060391
  { 297576767, 64, 42026177220ULL },   // factor: 25012027892993295481
  { 298898669, 64, 41867285671ULL },   // factor: 25028151923409343799
  { 298170241, 64, 41982728819ULL },   // factor: 25036000739597750759
  { 299524663, 64, 41803872021ULL },   // factor: 25042581358370307847
  { 299142881, 64, 41875774215ULL },   // factor: 25053679485561226831
  { 298499401, 64, 41987999643ULL },   // factor: 25066785485247427687
  { 299598097, 64, 41864092535ULL },   // factor: 25084804912235811791
  { 299709901, 64, 41866646436ULL },   // factor: 25095696917071125673
  { 298539467, 64, 42035057185ULL },   // factor: 25098247134648840791
  { 299925827, 64, 41862667368ULL },   // factor: 25111390261546626673
  { 297320671, 64, 42241426088ULL },   // factor: 25118498296962130097
  { 298793657, 64, 42087778788ULL },   // factor: 25151122678147095433
  { 297757909, 64, 42239196132ULL },   // factor: 25154109436210415977
  { 299061941, 64, 42093469815ULL },   // factor: 25177109572597621831
  { 299383789, 64, 42057610544ULL },   // factor: 25182733601898142433
  { 297764237, 64, 42365532859ULL },   // factor: 25229881133717127167
  { 299485951, 64, 42175510281ULL },   // factor: 25261945610831124463
  { 298879351, 64, 42262604993ULL },   // factor: 25262839903754399087
  { 297178159, 64, 42558304932ULL },   // factor: 25294797419704760377
  { 299908327, 64, 42170834405ULL },   // factor: 25294768789195180871
  { 298001359, 64, 42521421465ULL },   // factor: 25342882766363541871
  { 297772141, 64, 42562609644ULL },   // factor: 25347918800482255609
  { 297402653, 64, 42648147816ULL },   // factor: 25367344612029111697
  { 299896213, 64, 42341033708ULL },   // factor: 25395831327069095609
  { 297249133, 64, 42739187751ULL },   // factor: 25408373008217939767
  { 297496373, 64, 42709586515ULL },   // factor: 25411894161084420191
  { 299698823, 64, 42397310365ULL },   // factor: 25412848029512400791
  { 299200819, 64, 42480326541ULL },   // factor: 25420296984909274159
  { 299838593, 64, 42389414547ULL },   // factor: 25419964831732424743
  { 298365943, 64, 42603319068ULL },   // factor: 25422758937307402249
  { 298309657, 64, 42620797748ULL },   // factor: 25428391114544504873
  { 298007497, 64, 42681703740ULL },   // factor: 25438935398505877561
  { 298457209, 64, 42626871932ULL },   // factor: 25444594450450315577
  { 297478609, 64, 42778027376ULL },   // factor: 25451096159152799969
  { 298175663, 64, 42697518012ULL },   // factor: 25462721483365083913
  { 297872753, 64, 42768087472ULL },   // factor: 25478895911658900833
  { 298631239, 64, 42678350912ULL },   // factor: 25490177622654679937
  { 297266531, 64, 42909403473ULL },   // factor: 25511059035396124327
  { 298937407, 64, 42690589889ULL },   // factor: 25523628489436155647
  { 298465499, 64, 42830515105ULL },   // factor: 25566862126481724791
  { 297680711, 64, 42980965288ULL },   // factor: 25589208612796319537
  { 299799349, 64, 42731583171ULL },   // factor: 25621801632810311359
  { 298479193, 64, 42970718427ULL },   // factor: 25651730717442378823
  { 297383419, 64, 43296783969ULL },   // factor: 25751491296811220023
  { 297322657, 64, 43325859063ULL },   // factor: 25763519066837380783
  { 299555917, 64, 43028600379ULL },   // factor: 25778943687515785087
  { 299341901, 64, 43062210751ULL },   // factor: 25780648054933955303
  { 297602881, 64, 43329489336ULL },   // factor: 25789961717304754033
  { 299428903, 64, 43149229253ULL },   // factor: 25840252761042598919
  { 299379337, 64, 43196832764ULL },   // factor: 25864478306772394937
  { 297851291, 64, 43469332441ULL },   // factor: 25894793572920062663
  { 297753553, 64, 43514025683ULL },   // factor: 25912911504893003399
  { 297105709, 64, 43809924675ULL },   // factor: 26032357463604939151
  { 298141321, 64, 43670538023ULL },   // factor: 26039983789915896767
  { 298515989, 64, 43658701020ULL },   // factor: 26065640626881217561
  { 299498869, 64, 43525639739ULL },   // factor: 26071759748663910383
  { 299370229, 64, 43546802967ULL },   // factor: 26073232752897338887
  { 297183017, 64, 43900230804ULL },   // factor: 26092806074658111337
  { 297316471, 64, 43902623465ULL },   // factor: 26105946152511184031
  { 297625901, 64, 43891795555ULL },   // factor: 26126670397129340111
  { 298615861, 64, 43770233363ULL },   // factor: 26140971843726341087
  { 299941273, 64, 43591479528ULL },   // factor: 26149767723163518289
  { 299932091, 64, 43607725401ULL },   // factor: 26158712526551486983
  { 299795477, 64, 43657122648ULL },   // factor: 26176415817409326193
  { 297924863, 64, 43933689645ULL },   // factor: 26177876937142287271
  { 297542339, 64, 44014512324ULL },   // factor: 26192361893654571673
  { 297736619, 64, 44000098192ULL },   // factor: 26200880942708185697
  { 299974813, 64, 43677921560ULL },   // factor: 26204552704379336561
  { 298607203, 64, 43886185685ULL },   // factor: 26209462315472978111
  { 297710653, 64, 44020447635ULL },   // factor: 26210712421536311311
  { 299976631, 64, 43698133085ULL },   // factor: 26216837487655873271
  { 297323603, 64, 44183527308ULL },   // factor: 26273611064926901449
  { 298193267, 64, 44066110653ULL },   // factor: 26280434999203146703
  { 297546299, 64, 44174261220ULL },   // factor: 26287775874140449561
  { 298875053, 64, 43978470871ULL },   // factor: 26288135624858162327
  { 298001467, 64, 44118492072ULL },   // factor: 26294750718567739249
  { 297349181, 64, 44221406380ULL },   // factor: 26298397939522349561
  { 297142871, 64, 44257406476ULL },   // factor: 26301545646585265193
  { 299303453, 64, 43999924900ULL },   // factor: 26338658908621359401
  { 298025633, 64, 44249275900ULL },   // factor: 26374836919778289401
  { 298611037, 64, 44218610195ULL },   // factor: 26408330090055444431
  { 297989477, 64, 44316922743ULL },   // factor: 26411953260871950823
  { 298845083, 64, 44209709337ULL },   // factor: 26423708512443279943
  { 298418179, 64, 44280566916ULL },   // factor: 26428252288320731929
  { 299388283, 64, 44138674853ULL },   // factor: 26429204156269894799
  { 297926017, 64, 44373606588ULL },   // factor: 26440103741375599993
  { 298841359, 64, 44242425077ULL },   // factor: 26442932870932719287
  { 298552591, 64, 44320507928ULL },   // factor: 26464004952680882897
  { 298739047, 64, 44364219549ULL },   // factor: 26506649337934059607
  { 299371063, 64, 44299093481ULL },   // factor: 26523733410686680607
  { 298520273, 64, 44430813528ULL },   // factor: 26526997167981306289
  { 299338777, 64, 44324068932ULL },   // factor: 26535825171537152329
  { 298660507, 64, 44455691217ULL },   // factor: 26554318555809334039
  { 298997161, 64, 44410145724ULL },   // factor: 26557014982144579129
  { 297451393, 64, 44655042567ULL },   // factor: 26565409232056891663
  { 299993189, 64, 44292094336ULL },   // factor: 26574653254690955009
  { 297119629, 64, 44772513135ULL },   // factor: 26605584984137653831
  { 298403191, 64, 44588894708ULL },   // factor: 26610936928060426457
  { 299360267, 64, 44475037372ULL },   // factor: 26628118125033796649
  { 298446191, 64, 44631265405ULL },   // factor: 26640062319264644711
  { 297825053, 64, 44736963880ULL },   // factor: 26647577277240171281
  { 298289281, 64, 44702684444ULL },   // factor: 26668663203141289529
  { 298913113, 64, 44640460271ULL },   // factor: 26687237890714867247
  { 298615019, 64, 44692797820ULL },   // factor: 26691881340364917161
  { 298420721, 64, 44747379468ULL },   // factor: 26707090487402312857
  { 299910601, 64, 44539410636ULL },   // factor: 26715682824057104473
  { 299594731, 64, 44613516860ULL },   // factor: 26731949165271329321
  { 297130087, 64, 45030693452ULL },   // factor: 26759947726126180649
  { 297955937, 64, 44928124083ULL },   // factor: 26773202617605061543
  { 297890851, 64, 45044576004ULL },   // factor: 26836734157531478809
  { 299320829, 64, 44849899996ULL },   // factor: 26849018494739633369
  { 298875809, 64, 44987324584ULL },   // factor: 26891246059577176913
  { 297682849, 64, 45188475635ULL },   // factor: 26903668337987768231
  { 298956991, 64, 45010163973ULL },   // factor: 26912206371569370487
  { 299125753, 64, 45053483835ULL },   // factor: 26953314554835405511
  { 297807347, 64, 45274044220ULL },   // factor: 26965885994237768681
  { 299787107, 64, 45027211129ULL },   // factor: 26997154721282227607
  { 297975127, 64, 45321275729ULL },   // factor: 27009225782301585167
  { 299488177, 64, 45125767323ULL },   // factor: 27029267582582880343
  { 298877077, 64, 45232887483ULL },   // factor: 27038146390377854383
  { 298892323, 64, 45243706013ULL },   // factor: 27045992782709276399
  { 299119039, 64, 45240595805ULL },   // factor: 27064647081958062791
  { 297885083, 64, 45459114765ULL },   // factor: 27083184349757100991
  { 298591159, 64, 45376053752ULL },   // factor: 27097776961311957137
  { 299196137, 64, 45367443544ULL },   // factor: 27147527707860779057
  { 298439209, 64, 45554116811ULL },   // factor: 27190269175536884999
  { 299257633, 64, 45444904175ULL },   // factor: 27199468910644635551
  { 298525573, 64, 45578844083ULL },   // factor: 27212901093110469119
  { 297091369, 64, 45806490920ULL },   // factor: 27217426193017738961
  { 299610527, 64, 45449571204ULL },   // factor: 27234339960708929017
  { 298100221, 64, 45685007160ULL },   // factor: 27237421461565164721
  { 297694759, 64, 45774374561ULL },   // factor: 27253582806625251599
  { 299824193, 64, 45458210040ULL },   // factor: 27258942280934995441
  { 299215177, 64, 45571747904ULL },   // factor: 27271517230589478017
  { 297962531, 64, 45824273925ULL },   // factor: 27307833279860608351
  { 298105663, 64, 45980982260ULL },   // factor: 27414382404017076761
  { 299406637, 64, 45789951624ULL },   // factor: 27419630848269056977
  { 297689527, 64, 46072295453ULL },   // factor: 27430479682415641463
  { 297191527, 64, 46166751180ULL },   // factor: 27440734559626503721
  { 299792447, 64, 45812944660ULL },   // factor: 27468749567793966041
  { 299400691, 64, 45887312153ULL },   // factor: 27477385933481795447
  { 297313649, 64, 46235119471ULL },   // factor: 27492664163747919359
  { 297047833, 64, 46286830731ULL },   // factor: 27498805530162711847
  { 299230843, 64, 45965895261ULL },   // factor: 27508827176397470047
  { 297037837, 64, 46329895487ULL },   // factor: 27523463887789083239
  { 297360247, 64, 46302068064ULL },   // factor: 27536788792243703617
  { 299168453, 64, 46039159731ULL },   // factor: 27546928388286332287
  { 299776381, 64, 45998503904ULL },   // factor: 27578530063510982849
  { 299993647, 64, 45964821413ULL },   // factor: 27578308818779126423
  { 298955729, 64, 46133409067ULL },   // factor: 27583693877760389687
  { 298851103, 64, 46232742252ULL },   // factor: 27633412033449807913
  { 299131309, 64, 46186897007ULL },   // factor: 27631893920704184327
  { 297273727, 64, 46499763288ULL },   // factor: 27646315874483068753
  { 297674987, 64, 46461640617ULL },   // factor: 27660936533328293959
  { 299485181, 64, 46182183588ULL },   // factor: 27661759221654818857
  { 298773931, 64, 46322151593ULL },   // factor: 27679702647637044167
  { 297788087, 64, 46487057304ULL },   // factor: 27686583729635074897
  { 297423769, 64, 46590777584ULL },   // factor: 27714409339347988193
  { 298369459, 64, 46471527864ULL },   // factor: 27731369255370211153
  { 299100103, 64, 46424428820ULL },   // factor: 27771102883556336921
  { 298457213, 64, 46594710148ULL },   // factor: 27813054662629795049
  { 298982317, 64, 46600383299ULL },   // factor: 27865381143646247567
  { 299559527, 64, 46550123317ULL },   // factor: 27889065845264382119
  { 298752889, 64, 46710076364ULL },   // factor: 27909540518311231193
  { 298599239, 64, 46794654996ULL },   // factor: 27945696742146296089
  { 297782813, 64, 46935065743ULL },   // factor: 27952911810580950119
  { 298416497, 64, 46842541855ULL },   // factor: 27957174501889963871
  { 298647563, 64, 46828003920ULL },   // factor: 27970138501724893921
  { 299687623, 64, 46713668561ULL },   // factor: 27999016585311841007
  { 299025719, 64, 46921305549ULL },   // factor: 28061354256416829463
  { 299971933, 64, 46789880487ULL },   // factor: 28071301789048742743
  { 297587581, 64, 47188320636ULL },   // factor: 28085316379039243033
  { 299872777, 64, 46860660123ULL },   // factor: 28104472566274343143
  { 297980453, 64, 47171879148ULL },   // factor: 28112595834764588089
  { 297709901, 64, 47259703071ULL },   // factor: 28139363045113611943
  { 299995349, 64, 46912566615ULL },   // factor: 28147103588305347271
  { 298755917, 64, 47125128204ULL },   // factor: 28157821780657166137
  { 299000333, 64, 47158895640ULL },   // factor: 28201051000544496241
  { 298926151, 64, 47178462081ULL },   // factor: 28205752159945560463
  { 298276799, 64, 47296521672ULL },   // factor: 28214910176316575857
  { 298378777, 64, 47311757243ULL },   // factor: 28233648527774463623
  { 298971241, 64, 47253662648ULL },   // factor: 28254972327335812337
  { 299918741, 64, 47132464260ULL },   // factor: 28271818682173393321
  { 297700451, 64, 47528158140ULL },   // factor: 28298308226954642281
  { 298012307, 64, 47484010245ULL },   // factor: 28301638877448170431
  { 297551543, 64, 47561687781ULL },   // factor: 28304107173841592167
  { 298062829, 64, 47502220179ULL },   // factor: 28317292260667252783
  { 299389637, 64, 47308370335ULL },   // factor: 28327271643314436791
  { 298340711, 64, 47515195765ULL },   // factor: 28351434575668577831
  { 297045013, 64, 47744563415ULL },   // factor: 28364568920575998791
  { 299795803, 64, 47305865433ULL },   // factor: 28364199828192355399
  { 297753007, 64, 47632295313ULL },   // factor: 28365318319515512383
  { 298217533, 64, 47574480327ULL },   // factor: 28375088313749946583
  { 298482259, 64, 47552851620ULL },   // factor: 28387365146858819161
  { 298156907, 64, 47620818904ULL },   // factor: 28396952146447539857
  { 298889711, 64, 47513062408ULL },   // factor: 28402330983704168177
  { 299131981, 64, 47483932568ULL },   // factor: 28407925629472514417
  { 299770997, 64, 47383738960ULL },   // factor: 28408541339253886241
  { 298475767, 64, 47600772788ULL },   // factor: 28415354335382056793
  { 298677887, 64, 47572473037ULL },   // factor: 28417691452111265639
  { 299856847, 64, 47391006848ULL },   // factor: 28421035779193376513
  { 299365739, 64, 47495214256ULL },   // factor: 28436879829421550369
  { 299338849, 64, 47503059071ULL },   // factor: 28439022052584298559
  { 299623579, 64, 47518772181ULL },   // factor: 28475489181113711599
  { 297514933, 64, 47864687727ULL },   // factor: 28480918724328654583
  { 298553341, 64, 47700771455ULL },   // factor: 28482449372335362311
  { 298585853, 64, 47714705247ULL },   // factor: 28493871933638141383
  { 298670311, 64, 47763376833ULL },   // factor: 28531005226244610127
  { 298020199, 64, 47917381805ULL },   // factor: 28560695322170158391
  { 297726167, 64, 47987292864ULL },   // factor: 28574145538210344577
  { 299850841, 64, 47667469031ULL },   // factor: 28586261354573610143
  { 297965021, 64, 47979149235ULL },   // factor: 28592216418737817871
  { 299308481, 64, 47792130195ULL },   // factor: 28609179784839367591
  { 297158831, 64, 48165168633ULL },   // factor: 28625410411800296047
  { 299425453, 64, 47818216380ULL },   // factor: 28635982202467040281
  { 298466153, 64, 47994215548ULL },   // factor: 28649297761728693689
  { 299671997, 64, 47804260363ULL },   // factor: 28651196336176309823
  { 298727983, 64, 48034737213ULL },   // factor: 28698640323149062759
  { 299840971, 64, 47880961973ULL },   // factor: 28713348260796791567
  { 298350251, 64, 48123436996ULL },   // factor: 28715279013478571993
  { 299018273, 64, 48054750780ULL },   // factor: 28738497175362005881
  { 298299523, 64, 48215164457ULL },   // factor: 28765121117779308023
  { 298796593, 64, 48144095816ULL },   // factor: 28770583605772709777
  { 297610249, 64, 48454933739ULL },   // factor: 28841369790684582023
  { 299209411, 64, 48206676581ULL },   // factor: 28847782612137007583
  { 298650823, 64, 48398978288ULL },   // factor: 28908789396140662049
  { 298913981, 64, 48485044224ULL },   // factor: 28985715175913791489
  { 298870609, 64, 48506424312ULL },   // factor: 28994289149079692017
  { 298069391, 64, 48705233964ULL },   // factor: 29035078852323991849
  { 297272611, 64, 48854768664ULL },   // factor: 29046369281096523409
  { 297265939, 64, 48863411861ULL },   // factor: 29050856019207804959
  { 299608559, 64, 48498659377ULL },   // factor: 29061226898749615487
  { 297651749, 64, 48837217807ULL },   // factor: 29072966593094988887
  { 297245489, 64, 48912525784ULL },   // factor: 29078055289780376753
  { 299509571, 64, 48590137320ULL },   // factor: 29106422367088579441
  { 299448143, 64, 48630130537ULL },   // factor: 29124404566304485583
  { 298869457, 64, 48728119587ULL },   // factor: 29126693283195508519
  { 298381793, 64, 48832236651ULL },   // factor: 29141300656251390487
  { 298299569, 64, 48901937295ULL },   // factor: 29174853636727051711
  { 297066173, 64, 49120361871ULL },   // factor: 29183995834786179367
  { 297490153, 64, 49095700175ULL },   // factor: 29210974713405753551
  { 299762231, 64, 48796896105ULL },   // factor: 29254932884620020511
  { 298860377, 64, 48960239164ULL },   // factor: 29264551069126409657
  { 298184023, 64, 49079867460ULL },   // factor: 29269664655059183161
  { 298417739, 64, 49134813784ULL },   // factor: 29325400071214628753
  { 298699433, 64, 49125787228ULL },   // factor: 29347689581364483449
  { 297012523, 64, 49461215681ULL },   // factor: 29381200920121946327
  { 297687463, 64, 49350586896ULL },   // factor: 29382102021262569697
  { 298672729, 64, 49239493304ULL },   // factor: 29412987679365813233
  { 297389899, 64, 49456154825ULL },   // factor: 29415521776670225351
  { 299198791, 64, 49183939581ULL },   // factor: 29431550518504493143
  { 297577433, 64, 49481986092ULL },   // factor: 29449444801998123673
  { 297937231, 64, 49433895381ULL },   // factor: 29456395814717660023
  { 299652797, 64, 49174374624ULL },   // factor: 29470477793614846657
  { 299366401, 64, 49250578320ULL },   // factor: 29487936757654052641
  { 297099767, 64, 49629789072ULL },   // factor: 29489997539100692449
  { 298036183, 64, 49483912592ULL },   // factor: 29495992857650632673
  { 298342549, 64, 49465545159ULL },   // factor: 29515353660821340583
  { 299136049, 64, 49334479400ULL },   // factor: 29515442494375781201
  { 299955127, 64, 49205580308ULL },   // factor: 29518932180789678233
  { 298522087, 64, 49445395964ULL },   // factor: 29521085591429313737
  { 297878423, 64, 49585410492ULL },   // factor: 29540847762329228233
  { 297384037, 64, 49731785948ULL },   // factor: 29578878544872224153
  { 299577361, 64, 49378995843ULL },   // factor: 29585658526951820647
  { 297328693, 64, 49856747448ULL },   // factor: 29647683111889850929
  { 299849323, 64, 49509341837ULL },   // factor: 29690685264000052703
  { 298927693, 64, 49781345360ULL },   // factor: 29762045445802108961
  { 299413007, 64, 49728801312ULL },   // factor: 29778899870662930369
  { 298251887, 64, 49969600273ULL },   // factor: 29807055148115930303
  { 297322577, 64, 50128840435ULL },   // factor: 29808872040312001991
  { 298632839, 64, 49960700949ULL },   // factor: 29839811925659728423
  { 299915051, 64, 49792542013ULL },   // factor: 29867065554497075327
  { 299480387, 64, 49893079105ULL },   // factor: 29883997277974027271
  { 299153867, 64, 49986667828ULL },   // factor: 29907409958381381753
  { 299880719, 64, 49893761784ULL },   // factor: 29924354314801285393
  { 299454553, 64, 50018227988ULL },   // factor: 29956372207997258729
  { 299377291, 64, 50036162364ULL },   // factor: 29959381481140951849
  { 297565453, 64, 50360729640ULL },   // factor: 29971226657474253841
  { 297420059, 64, 50389358152ULL },   // factor: 29973611749079941937
  { 299677531, 64, 50057095668ULL },   // factor: 30001973677634071417
  { 299167523, 64, 50164812940ULL },   // factor: 30015365658036295241
  { 297120301, 64, 50536501200ULL },   // factor: 30030840896061722401
  { 299882053, 64, 50145883347ULL },   // factor: 30075700895193742783
  { 297898577, 64, 50513226408ULL },   // factor: 30095636533244042833
  { 299876293, 64, 50205774743ULL },   // factor: 30111043234247735399
  { 299448283, 64, 50307626868ULL },   // factor: 30129064974854535289
  { 299642039, 64, 50307751684ULL },   // factor: 30148634584198887353
  { 297589373, 64, 50715231567ULL },   // factor: 30184627927146674983
  { 297160433, 64, 50826849727ULL },   // factor: 30207457345802503583
  { 297097159, 64, 50917103421ULL },   // factor: 30254653541776561879
  { 298168699, 64, 50737911605ULL },   // factor: 30256914186479703791
  { 299761963, 64, 50505809888ULL },   // factor: 30279441429863380289
  { 298539679, 64, 50751892892ULL },   // factor: 30302907625240123337
  { 298116383, 64, 50858531385ULL },   // factor: 30323522842376360911
  { 299952467, 64, 50555388153ULL },   // factor: 30328426793269846903
  { 297355181, 64, 51013674660ULL },   // factor: 30338360923998826921
  { 298196551, 64, 50882885780ULL },   // factor: 30346202089045889561
  { 299325463, 64, 50688681773ULL },   // factor: 30344826281125771799
  { 298410683, 64, 50876618877ULL },   // factor: 30364253175632525983
  { 298345867, 64, 50909432180ULL },   // factor: 30377237364439600121
  { 298463797, 64, 50895857012ULL },   // factor: 30381141470741189129
  { 297090553, 64, 51161679140ULL },   // factor: 30399303096222328841
  { 299699663, 64, 50721370152ULL },   // factor: 30402355082905317553
  { 299747447, 64, 50717231392ULL },   // factor: 30404721257320512449
  { 298162747, 64, 50998231277ULL },   // factor: 30411545459383275839
  { 298351337, 64, 50971097163ULL },   // factor: 30414589973875913863
  { 299220143, 64, 50865632961ULL },   // factor: 30440043936751866847
  { 298761691, 64, 51028941525ULL },   // factor: 30490985719898237551
  { 297284363, 64, 51366874933ULL },   // factor: 30541137387515145359
  { 297196643, 64, 51410550688ULL },   // factor: 30558086158509880769
  { 297500573, 64, 51361333651ULL },   // factor: 30560052382433364047
  { 298569707, 64, 51239544157ULL },   // factor: 30597151371538103999
  { 297502913, 64, 51430396848ULL },   // factor: 30601385758052036449
  { 297633481, 64, 51437732235ULL },   // factor: 30619182599697920071
  { 297525169, 64, 51476987180ULL },   // factor: 30631398620680666841
  { 299311967, 64, 51199023048ULL },   // factor: 30648960593950430833
  { 298418203, 64, 51418855236ULL },   // factor: 30688644759688521817
  { 297871177, 64, 51517892799ULL },   // factor: 30691390729195908847
  { 299142737, 64, 51306933895ULL },   // factor: 30696193264856741231
  { 298279301, 64, 51471427860ULL },   // factor: 30705723047105451721
  { 298065013, 64, 51522085980ULL },   // factor: 30713862454831635481
  { 298523503, 64, 51460918148ULL },   // factor: 30724587106274464889
  { 298513889, 64, 51465256180ULL },   // factor: 30726187541346168041
  { 297770797, 64, 51609994452ULL },   // factor: 30735898362275236489
  { 297445051, 64, 51670266684ULL },   // factor: 30738130218011961769
  { 298087709, 64, 51562171119ULL },   // factor: 30740098919857352743
  { 298409467, 64, 51576921144ULL },   // factor: 30782083096164140497
  { 299072881, 64, 51469292363ULL },   // factor: 30786139100067415607
  { 298046611, 64, 51701416188ULL },   // factor: 30818863757467877737
  { 297368441, 64, 51850060123ULL },   // factor: 30837143089065556487
  { 298365169, 64, 51684525092ULL },   // factor: 30841724127518641097
  { 298983907, 64, 51611506817ULL },   // factor: 30862019908607588039
  { 297306283, 64, 51965151300ULL },   // factor: 30899131957071235801
  { 298597951, 64, 51747108944ULL },   // factor: 30903161401704347489
  { 297794843, 64, 51894598501ULL },   // factor: 30907887626306660687
  { 297944767, 64, 51903976500ULL },   // factor: 30929036369331951001
  { 297315827, 64, 52029256948ULL },   // factor: 30938243115380231993
  { 297472033, 64, 52041790563ULL },   // factor: 30961954479471649159
  { 299634143, 64, 51729732897ULL },   // factor: 30999988368423004543
  { 297055471, 64, 52195567796ULL },   // factor: 31009957951506423833
  { 298019023, 64, 52039187940ULL },   // factor: 31017335895184365241
  { 299290463, 64, 51844148821ULL },   // factor: 31032918608955988247
  { 298802351, 64, 51990416764ULL },   // factor: 31069717517106024329
  { 298609147, 64, 52047321657ULL },   // factor: 31083612647262793159
  { 298786667, 64, 52024486984ULL },   // factor: 31088446136668484657
  { 298369339, 64, 52206134357ULL },   // factor: 31153419599686560047
  { 299918497, 64, 51972119288ULL },   // factor: 31174799805523340273
  { 299696321, 64, 52023886971ULL },   // factor: 31182735058657067383
  { 297732629, 64, 52371126696ULL },   // factor: 31185186469784327569
  { 298147721, 64, 52304517084ULL },   // factor: 31188945133200331129
  { 298851559, 64, 52192876349ULL },   // factor: 31195844931185756183
  { 298212359, 64, 52340419885ULL },   // factor: 31217120169912717431
  { 297762953, 64, 52562863660ULL },   // factor: 31302547003075975961
  { 298744967, 64, 52433490673ULL },   // factor: 31328482881600385583
  { 298787239, 64, 52424698824ULL },   // factor: 31327662034059013873
  { 297004007, 64, 52764386097ULL },   // factor: 31342468195408181359
  { 297724787, 64, 52688196588ULL },   // factor: 31373164213152853513
  { 297360359, 64, 52782406737ULL },   // factor: 31390790832396677167
  { 297390547, 64, 52807094409ULL },   // factor: 31408661383546303447
  { 298123597, 64, 52722729392ULL },   // factor: 31435779460001326049
  { 299794889, 64, 52438843860ULL },   // factor: 31441794748594063081
  { 299162761, 64, 52573731891ULL },   // factor: 31456205577170622103
  { 299737241, 64, 52539500124ULL },   // factor: 31496089621373835769
  { 298122347, 64, 52860241869ULL },   // factor: 31517638737947893087
  { 297361843, 64, 53023518993ULL },   // factor: 31534342660207968199
  { 297671177, 64, 53034413467ULL },   // factor: 31573632556453081319
  { 298580627, 64, 52885770940ULL },   // factor: 31581333293287158761
  { 298719679, 64, 52868200997ULL },   // factor: 31585544062262639927
  { 299726809, 64, 52694953971ULL },   // factor: 31588180808259417079
  { 299529973, 64, 52774713251ULL },   // factor: 31615216870309544447
  { 299501089, 64, 52850833632ULL },   // factor: 31657764454683650497
  { 298582157, 64, 53104262919ULL },   // factor: 31711970736500272567
  { 299260651, 64, 53015106981ULL },   // factor: 31730670855937409263
  { 297899471, 64, 53287842588ULL },   // factor: 31748840235392941897
  { 297149449, 64, 53612655492ULL },   // factor: 31861942077749247817
  { 297316763, 64, 53688827388ULL },   // factor: 31925176736531810089
  { 298309547, 64, 53544959413ULL },   // factor: 31945945173250831823
  { 298947547, 64, 53453563025ULL },   // factor: 31959623089467299351
  { 297947257, 64, 53646505043ULL },   // factor: 31967658050397034103
  { 298462949, 64, 53569771632ULL },   // factor: 31977184037086525537
  { 298128641, 64, 53689545699ULL },   // factor: 32012782590300530119
  { 298589953, 64, 53635242255ULL },   // factor: 32029888928128128031
  { 298053577, 64, 53748676175ULL },   // factor: 32039970385946855951
  { 299099509, 64, 53576058692ULL },   // factor: 32049145697864764457
  { 297700093, 64, 53879755952ULL },   // factor: 32080016715455407073
  { 299912293, 64, 53525186400ULL },   // factor: 32105722772952830401
  { 297785179, 64, 53940361284ULL },   // factor: 32125280280561219673
  { 297988351, 64, 53925042216ULL },   // factor: 32138068815102451633
  { 299240593, 64, 53771614391ULL },   // factor: 32181299553860347727
  { 297613639, 64, 54084746540ULL },   // factor: 32192716464324118121
  { 299197109, 64, 53823450640ULL },   // factor: 32207641655784399521
  { 299817913, 64, 53738026772ULL },   // factor: 32223246071038333673
  { 298415969, 64, 54035149987ULL },   // factor: 32249903286861884807
  { 298326881, 64, 54052735051ULL },   // factor: 32250767714568411863
  { 297252737, 64, 54251210283ULL },   // factor: 32252641484368589143
  { 299022653, 64, 53990377827ULL },   // factor: 32288692028603830063
  { 299293327, 64, 53982646929ULL },   // factor: 32313291999293485567
  { 298674949, 64, 54105669675ULL },   // factor: 32320016261582943151
  { 297769231, 64, 54324082836ULL },   // factor: 32352080741712038233
  { 298266511, 64, 54236979956ULL },   // factor: 32354149557306107033
  { 298580267, 64, 54195734025ULL },   // factor: 32363553470890969351
  { 297467461, 64, 54405922776ULL },   // factor: 32367983423077583473
  { 297021997, 64, 54564041360ULL },   // factor: 32413441058275591841
  { 298075681, 64, 54396114768ULL },   // factor: 32428317906451514017
  { 298962299, 64, 54241401049ULL },   // factor: 32432267917180103303
  { 298347289, 64, 54358704939ULL },   // factor: 32435544504203120743
  { 298541513, 64, 54356970375ULL },   // factor: 32455624355697354751
  { 299317519, 64, 54222019905ULL },   // factor: 32459200946266431391
  { 298272719, 64, 54429534684ULL },   // factor: 32469690608202971593
  { 297388439, 64, 54592421229ULL },   // factor: 32470309861045543063
  { 297179863, 64, 54635806752ULL },   // factor: 32473323130907669953
  { 297669511, 64, 54566455509ULL },   // factor: 32485540256734572199
  { 299232581, 64, 54350283523ULL },   // factor: 32526751233338125727
  { 298648769, 64, 54505008796ULL },   // factor: 32555707562519144249
  { 298370399, 64, 54567191112ULL },   // factor: 32562469168793387377
  { 298328951, 64, 54610540885ULL },   // factor: 32583810751529323271
  { 297917063, 64, 54696847708ULL },   // factor: 32590248449051283209
  { 298172059, 64, 54731413257ULL },   // factor: 32638756365639172327
  { 297915271, 64, 54845833881ULL },   // factor: 32678822927758193503
  { 297356819, 64, 54960003277ULL },   // factor: 32685463493356591727
  { 299676149, 64, 54535357824ULL },   // factor: 32685892034066679553
  { 299773729, 64, 54530941575ULL },   // factor: 32693887403637766351
  { 298557673, 64, 54826877715ULL },   // factor: 32737970056891914391
  { 298153967, 64, 54933044293ULL },   // factor: 32757010150689320663
  { 297649951, 64, 55098143544ULL },   // factor: 32799919452125132689
  { 299453017, 64, 54823931252ULL },   // factor: 32834383234423974569
  { 299747627, 64, 54895941192ULL },   // factor: 32909856208467102769
  { 298772741, 64, 55174687036ULL },   // factor: 32969384959125771353
  { 297611879, 64, 55415939745ULL },   // factor: 32984883908120461711
  { 299096341, 64, 55154075943ULL },   // factor: 32992764611574849127
  { 299972369, 64, 54994848420ULL },   // factor: 32993869926686613961
  { 297237313, 64, 55507905452ULL },   // factor: 32998041333621060953
  { 299814379, 64, 55072785461ULL },   // factor: 33023225945579887439
  { 298294391, 64, 55385534764ULL },   // factor: 33042388725273417449
  { 297031859, 64, 55676607445ULL },   // factor: 33075452424403180511
  { 299406013, 64, 55354427483ULL },   // factor: 33146896869165310559
  { 297562631, 64, 55711564365ULL },   // factor: 33155359339150488631
  { 298984463, 64, 55446833637ULL },   // factor: 33155483560017563863
  { 297090083, 64, 55819587240ULL },   // factor: 33166891612314681841
  { 299578421, 64, 55396021503ULL },   // factor: 33190905303101573527
  { 299904641, 64, 55333166431ULL },   // factor: 33189346827764612543
  { 299469997, 64, 55450708443ULL },   // factor: 33211646982146169343
  { 297821959, 64, 55806750512ULL },   // factor: 33240951525816186017
  { 298013713, 64, 55774584372ULL },   // factor: 33243181959462986473
  { 297966121, 64, 55856898059ULL },   // factor: 33286926491465318279
  { 298452389, 64, 55797128979ULL },   // factor: 33305572886247361663
  { 297105349, 64, 56054934687ULL },   // factor: 33308441866706681527
  { 297073043, 64, 56107863253ULL },   // factor: 33336267345593177759
  { 299812417, 64, 55596170160ULL },   // factor: 33336844303225753441
  { 297951721, 64, 56028225303ULL },   // factor: 33387412307209192927
  { 297297211, 64, 56182378968ULL },   // factor: 33405729149062916497
  { 297300551, 64, 56248493800ULL },   // factor: 33445416399320167601
  { 297680303, 64, 56195262112ULL },   // factor: 33456445305329159873
  { 298410977, 64, 56059179619ULL },   // factor: 33457349119848555527
  { 297384623, 64, 56306244768ULL },   // factor: 33489222745754804929
  { 297403607, 64, 56388704025ULL },   // factor: 33540407942180836351
  { 298144291, 64, 56288939196ULL },   // factor: 33564451735467060073
  { 298010407, 64, 56342752253ULL },   // factor: 33581453060833393943
  { 299182733, 64, 56170491960ULL },   // factor: 33610482597094653361
  { 297222361, 64, 56633891496ULL },   // factor: 33665717886117884113
  { 297120829, 64, 56704157895ULL },   // factor: 33695972803018589911
  { 299116591, 64, 56370346061ULL },   // factor: 33722611494513196103
  { 299985457, 64, 56255946279ULL },   // factor: 33751931506946529007
  { 297072463, 64, 56834604668ULL },   // factor: 33767991984708114569
  { 298562947, 64, 56553667985ULL },   // factor: 33769659554522303591
  { 299772223, 64, 56344091388ULL },   // factor: 33780787056591831049
  { 298810111, 64, 56634350448ULL },   // factor: 33845833087559559457
  { 297343663, 64, 56926080681ULL },   // factor: 33853218699844149007
  { 297683597, 64, 57031579540ULL },   // factor: 33954731480117610761
  { 299159569, 64, 56749019775ULL },   // factor: 33954024594122953951
  { 299017253, 64, 56785527603ULL },   // factor: 33959704948009469119
  { 299579671, 64, 56682266549ULL },   // factor: 33961709528567450759
  { 297413747, 64, 57096223680ULL },   // factor: 33962403648437857921
  { 299827667, 64, 56657867832ULL },   // factor: 33975192658525815889
  { 297496267, 64, 57193428389ULL },   // factor: 34029662885318647727
  { 299195437, 64, 56869655280ULL },   // factor: 34030282727077914721
  { 298854181, 64, 57093271499ULL },   // factor: 34125125788888574639
  { 299488529, 64, 56991730776ULL },   // factor: 34136739230536537009
  { 297353543, 64, 57426258121ULL },   // factor: 34151802627023745407
  { 299075977, 64, 57101287868ULL },   // factor: 34155246914160694073
  { 298756721, 64, 57178133995ULL },   // factor: 34164703650489660791
  { 297663307, 64, 57604128012ULL },   // factor: 34293270481806511369
  { 297030889, 64, 57745404387ULL },   // factor: 34304337601470220087
  { 299882503, 64, 57203221140ULL },   // factor: 34308490270251426841
  { 298437917, 64, 57496361995ULL },   // factor: 34318189017731528831
  { 299781127, 64, 57270271029ULL },   // factor: 34337092785338139367
  { 297029333, 64, 57883911520ULL },   // factor: 34386439260433232321
  { 299934413, 64, 57380709511ULL },   // factor: 34420898849410604087
  { 299662681, 64, 57727914828ULL },   // factor: 34597803451796267737
  { 297206617, 64, 58268878919ULL },   // factor: 34635792759797214047
  { 298309073, 64, 58059938356ULL },   // factor: 34639612778831007977
  { 298672607, 64, 58049840985ULL },   // factor: 34675794685850795791
  { 297094117, 64, 58372993523ULL },   // factor: 34684545934724808383
  { 298665041, 64, 58076758471ULL },   // factor: 34690994899776624623
  { 297904969, 64, 58232706896ULL },   // factor: 34695625485277932449
  { 298143557, 64, 58214964424ULL },   // factor: 34712833127999632337
  { 298650029, 64, 58116947719ULL },   // factor: 34713256243341667703
  { 297502277, 64, 58429446847ULL },   // factor: 34765786961665941239
  { 299089691, 64, 58159592533ULL },   // factor: 34789869118761754607
  { 297513961, 64, 58480965944ULL },   // factor: 34797807642211088369
  { 297925189, 64, 58475475792ULL },   // factor: 34842634354393049377
  { 297043181, 64, 58669263340ULL },   // factor: 34854609218880569081
  { 297180287, 64, 58647178309ULL },   // factor: 34857570563217589367
  { 299438131, 64, 58244996264ULL },   // factor: 34881545642788285169
  { 299305267, 64, 58356599132ULL },   // factor: 34932874968830456489
  { 297958547, 64, 58658466717ULL },   // factor: 34955583024490360399
  { 297944497, 64, 58693438032ULL },   // factor: 34974773743289819809
  { 298193059, 64, 58646938221ULL },   // factor: 34976219818208016079
  { 298548683, 64, 58651991496ULL },   // factor: 35020949632915999537
  { 298944131, 64, 58591230565ULL },   // factor: 35031009010949128031
  { 299012641, 64, 58669521620ULL },   // factor: 35085857211605596841
  { 299864239, 64, 58620907025ULL },   // factor: 35156627349082757951
  { 298473863, 64, 58912456528ULL },   // factor: 35167656957463455329
  { 299732969, 64, 58667233959ULL },   // factor: 35169008435097388543
  { 297110599, 64, 59208850305ULL },   // factor: 35183153960439765391
  { 297401033, 64, 59249417107ULL },   // factor: 35241675704539343063
  { 298417487, 64, 59075653212ULL },   // factor: 35258415948817036489
  { 298943731, 64, 58997908949ULL },   // factor: 35274110044824697439
  { 297136187, 64, 59385048325ULL },   // factor: 35290893648202473551
  { 299524517, 64, 58935392260ULL },   // factor: 35305189801764076841
  { 299152897, 64, 59056805228ULL },   // factor: 35334028743041891033
  { 298693049, 64, 59195228820ULL },   // factor: 35362406764996944361
  { 297071939, 64, 59532592129ULL },   // factor: 35370925154916336263
  { 298607731, 64, 59260542608ULL },   // factor: 35391312332007404897
  { 298522823, 64, 59282144712ULL },   // factor: 35394146385841523953
  { 299164387, 64, 59181263732ULL },   // factor: 35409852972538224569
  { 299199539, 64, 59227813932ULL },   // factor: 35441869248864354697
  { 298751437, 64, 59383381872ULL },   // factor: 35481741336359500129
  { 299978947, 64, 59147785332ULL },   // factor: 35486180722550810809
  { 298771423, 64, 59399967401ULL },   // factor: 35494025573100763247
  { 297151333, 64, 59803991492ULL },   // factor: 35541671581136917673
  { 298380871, 64, 59577420356ULL },   // factor: 35553525155512820153
  { 297723809, 64, 59712206652ULL },   // factor: 35555491216457154937
  { 298596659, 64, 59557019461ULL },   // factor: 35567054062105161599
  { 298744651, 64, 59537672904ULL },   // factor: 35573122626115273009
  { 297682901, 64, 59782700083ULL },   // factor: 35592575180640761567
  { 298202689, 64, 59757772559ULL },   // factor: 35639856931488422303
  { 298955933, 64, 59644012395ULL },   // factor: 35661862746821579071
  { 299926637, 64, 59448755440ULL },   // factor: 35660530585909310561
  { 298819817, 64, 59784455907ULL },   // factor: 35729560347148618039
  { 298732201, 64, 59832504476ULL },   // factor: 35747791506915663353
  { 299312621, 64, 59745233140ULL },   // factor: 35765004646778919881
  { 299074729, 64, 59807260187ULL },   // factor: 35773680265319028647
  { 297161987, 64, 60281530488ULL },   // factor: 35826758758430319313
  { 298833281, 64, 59962130556ULL },   // factor: 35837360419599668473
  { 297942871, 64, 60205738425ULL },   // factor: 35875741114039036351
  { 299197069, 64, 59976618972ULL },   // factor: 35889657209904386137
  { 298166419, 64, 60203783549ULL },   // factor: 35901493102112882063
  { 297102397, 64, 60428708159ULL },   // factor: 35907028083304714247
  { 298375501, 64, 60181695999ULL },   // factor: 35913487389462640999
  { 299299313, 64, 60096784795ULL },   // factor: 35973852805304691671
  { 297170611, 64, 60538133504ULL },   // factor: 35980308244366501889
  { 297683179, 64, 60532461141ULL },   // factor: 36038990930293694479
  { 299088553, 64, 60261159900ULL },   // factor: 36046846233185249401
  { 297817603, 64, 60560429520ULL },   // factor: 36071923912593681121
  { 299690873, 64, 60181440868ULL },   // factor: 36071657104257595529
  { 298831343, 64, 60427156228ULL },   // factor: 36115056498568108409
  { 298987001, 64, 60411502879ULL },   // factor: 36124508143390151759
  { 297587893, 64, 60732538487ULL },   // factor: 36146536329775475783
  { 298002049, 64, 60793144436ULL },   // factor: 36232963214161898729
  { 298406873, 64, 60715545300ULL },   // factor: 36235872030925693801
  { 298269739, 64, 60855474180ULL },   // factor: 36302692800779678041
  { 297391117, 64, 61072954100ULL },   // factor: 36325108076577459401
  { 297766921, 64, 61003154424ULL },   // factor: 36329442928244017009
  { 299385277, 64, 60694652199ULL },   // factor: 36342170522032548247
  { 297282163, 64, 61180736133ULL },   // factor: 36375883143100991359
  { 298110829, 64, 61181986956ULL },   // factor: 36478025702640693049
  { 297204329, 64, 61391052039ULL },   // factor: 36491372855710153663
  { 297795929, 64, 61271737284ULL },   // factor: 36492947851865433673
  { 298736419, 64, 61152810324ULL },   // factor: 36537143135955979513
  { 297645109, 64, 61425651596ULL },   // factor: 36566089529374887929
  { 298047683, 64, 61471136472ULL },   // factor: 36642659593712788753
  { 297528367, 64, 61584090437ULL },   // factor: 36646027721801852759
  { 299937707, 64, 61130363733ULL },   // factor: 36670602252303960463
  { 297738263, 64, 61588908697ULL },   // factor: 36674749391020746623
  { 297413617, 64, 61723377080ULL },   // factor: 36714745661635396721
  { 299597303, 64, 61279092820ULL },   // factor: 36718101878317328921
  { 298247821, 64, 61561146075ULL },   // factor: 36720955350262905151
  { 298283119, 64, 61582580577ULL },   // factor: 36738088421152759327
  { 297002819, 64, 61852216200ULL },   // factor: 36740565145594935601
  { 298988491, 64, 61446218760ULL },   // factor: 36743424449416582321
  { 298613989, 64, 61528182359ULL },   // factor: 36746351940280840103
  { 299305159, 64, 61385154501ULL },   // factor: 36745786856322741319
  { 297274951, 64, 61823015400ULL },   // factor: 36756867747414490801
  { 298765651, 64, 61527562821ULL },   // factor: 36764644721318922943
  { 298008713, 64, 61736521431ULL },   // factor: 36796042593498456607
  { 298746647, 64, 61587860280ULL },   // factor: 36798333509108962321
  { 298711321, 64, 61638793635ULL },   // factor: 36824410943114483671
  { 298577897, 64, 61690940623ULL },   // factor: 36839102630334419663
  { 298967479, 64, 61614367932ULL },   // factor: 36841384501616966857
  { 298392239, 64, 61743485461ULL },   // factor: 36847553740743474359
  { 298245901, 64, 61832466623ULL },   // factor: 36882559438058124647
  { 297567331, 65, 63347928645ULL },   // factor: 37700548102542192991
  { 298241213, 65, 63358990347ULL },   // factor: 37792524271089141823
  { 297593117, 65, 63547010680ULL },   // factor: 37822305968586979121
  { 297594421, 65, 63642561224ULL },   // factor: 37879342316826662609
  { 297963979, 65, 64239671832ULL },   // factor: 38282216457433879057
  { 299007073, 65, 64220946795ULL },   // factor: 38405034652923362071
  { 298111127, 65, 64607751613ULL },   // factor: 38520579292574995703
  { 299007539, 65, 67553945784ULL },   // factor: 40398278157226531153
  { 298233751, 65, 69186615744ULL },   // factor: 41267567864657551489
  { 299002537, 65, 84095346584ULL },   // factor: 50289443957020567217
  { 299004191, 65, 84835398321ULL },   // factor: 50732279286266726623
  { 299000839, 65, 93055750541ULL },   // factor: 55647494971067407799
  { 299004319, 65, 99085453941ULL },   // factor: 59253957356869142359
  { 299007419, 66, 141370023937ULL },   // factor: 84541371962741177207
  { 299000341, 66, 141449834624ULL },   // factor: 84587097573939213569
  { 298999999, 69, 1132855029572ULL },   // factor: 677447305418345940857
  { 300183497, 62, 7692284527ULL },   // factor: 4618193738467701839
  { 301444987, 62, 7665812777ULL },   // factor: 4621641665814397799
  { 301948873, 62, 7657025912ULL },   // factor: 4624060689320394353
  { 300187759, 62, 7708012160ULL },   // factor: 4627701793310298881
  { 300001399, 62, 7727860160ULL },   // factor: 4636737718552727681
  { 301742293, 62, 7686885752ULL },   // factor: 4638917065675018673
  { 300326837, 62, 7755531660ULL },   // factor: 4658388585402318841
  { 300354959, 62, 7755352509ULL },   // factor: 4658717169742484263
  { 300382013, 62, 7759311471ULL },   // factor: 4661515198305942247
  { 301117093, 62, 7757925591ULL },   // factor: 4672088003344453927
  { 300417529, 62, 7778706132ULL },   // factor: 4673719349985175657
  { 301235357, 62, 7764914464ULL },   // factor: 4678133561275007297
  { 301992953, 62, 7745411596ULL },   // factor: 4678119440152965977
  { 301118863, 62, 7769660117ULL },   // factor: 4679182440654973943
  { 301293007, 62, 7767301817ULL },   // factor: 4680467441440987439
  { 301920743, 62, 7755824097ULL },   // factor: 4683288347887088143
  { 301792669, 62, 7761351020ULL },   // factor: 4684637678743344761
  { 300337523, 62, 7801424425ULL },   // factor: 4686120975352398551
  { 301462561, 62, 7781309240ULL },   // factor: 4691546822846727281
  { 301777351, 62, 7779429168ULL },   // factor: 4695311053222347937
  { 301983457, 62, 7783198655ULL },   // factor: 4700794472709300671
  { 301795229, 62, 7794759279ULL },   // factor: 4704842323211359783
  { 301402139, 62, 7813972432ULL },   // factor: 4710296010183664097
  { 300262531, 62, 7881008436ULL },   // factor: 4732743079651423033
  { 301036783, 62, 7868317601ULL },   // factor: 4737306036454635167
  { 301704509, 62, 7865373984ULL },   // factor: 4746037591888187713
  { 301571939, 62, 7882607589ULL },   // factor: 4754346509981690143
  { 301344977, 62, 7893671607ULL },   // factor: 4757436577713936079
  { 301700461, 62, 7886758500ULL },   // factor: 4758877350491337001
  { 301763509, 62, 7890534176ULL },   // factor: 4762150561668367169
  { 301718971, 62, 7906725201ULL },   // factor: 4771217983250976343
  { 301456357, 62, 7917422267ULL },   // factor: 4773514546881002639
  { 301726031, 62, 7923951061ULL },   // factor: 4781724606947537783
  { 301568507, 62, 7933576300ULL },   // factor: 4785033519923168201
  { 300965477, 62, 7951701772ULL },   // factor: 4786375433543450489
  { 301891309, 62, 7937815107ULL },   // factor: 4792714786504410127
  { 300181177, 62, 7987361000ULL },   // factor: 4795310852207794001
  { 300846461, 62, 7969603564ULL },   // factor: 4795254055604774009
  { 301621417, 62, 7960816572ULL },   // factor: 4802305549847445049
  { 300349037, 62, 8003448088ULL },   // factor: 4807655851820582513
  { 301838993, 62, 7988747692ULL },   // factor: 4822631117368708313
  { 301482737, 62, 8018773419ULL },   // factor: 4835043515485935607
  { 301064993, 62, 8035585456ULL },   // factor: 4838466958123083617
  { 301507001, 62, 8023827384ULL },   // factor: 4838480262183030769
  { 300937591, 62, 8050927541ULL },   // factor: 4845653479008187463
  { 301756909, 62, 8030351519ULL },   // factor: 4846428105113789543
  { 300329971, 62, 8069914604ULL },   // factor: 4847274437983592969
  { 300189727, 62, 8075518748ULL },   // factor: 4848375536691003593
  { 301988807, 62, 8031872064ULL },   // factor: 4851070925167975297
  { 301597039, 62, 8046180849ULL },   // factor: 4853408638633812223
  { 301139431, 62, 8069515040ULL },   // factor: 4860098335183084481
  { 301091911, 62, 8075632985ULL },   // factor: 4863015535976568671
  { 301089463, 62, 8095748036ULL },   // factor: 4875088857485089337
  { 300779881, 62, 8112147095ULL },   // factor: 4879941275777191391
  { 300095459, 62, 8140033540ULL },   // factor: 4885574202923389721
  { 300660469, 62, 8137265831ULL },   // factor: 4893108322252269479
  { 300922273, 62, 8136710276ULL },   // factor: 4897034701992754697
  { 300226483, 62, 8174800065ULL },   // factor: 4908582945486242791
  { 300352363, 62, 8173869176ULL },   // factor: 4910081843728925777
  { 301526317, 62, 8145463944ULL },   // factor: 4912143486581228497
  { 300816629, 62, 8171549019ULL },   // factor: 4916275659207673903
  { 300908213, 62, 8176955692ULL },   // factor: 4921026250119796793
  { 301765171, 62, 8154164793ULL },   // factor: 4921285866243649207
  { 300832057, 62, 8197782203ULL },   // factor: 4932311365932963143
  { 300701579, 62, 8203360681ULL },   // factor: 4933527019766430599
  { 301825357, 62, 8175004824ULL },   // factor: 4934847498961044337
  { 300041201, 62, 8225371680ULL },   // factor: 4935900795077175361
  { 300795643, 62, 8221102112ULL },   // factor: 4945743391895396033
  { 301144871, 62, 8217220609ULL },   // factor: 4949147680551692879
  { 301285847, 62, 8215447057ULL },   // factor: 4950395850103804559
  { 300590029, 62, 8236164779ULL },   // factor: 4951418019536777183
  { 300633889, 62, 8240072547ULL },   // factor: 4954490110893490567
  { 300362767, 62, 8252538993ULL },   // factor: 4957510893425747263
  { 301695659, 62, 8230114644ULL },   // factor: 4965979722334260793
  { 301278823, 62, 8250576897ULL },   // factor: 4971448193198304463
  { 300066827, 62, 8287611904ULL },   // factor: 4973674814881417217
  { 301548763, 62, 8248488417ULL },   // factor: 4974642957532356343
  { 300358301, 62, 8282566555ULL },   // factor: 4975475236758446111
  { 301131547, 62, 8265441345ULL },   // factor: 4977970277715221431
  { 301617683, 62, 8254974993ULL },   // factor: 4979692861223202439
  { 300921493, 62, 8285049848ULL },   // factor: 4986299139679166129
  { 301498139, 62, 8281833360ULL },   // factor: 4993914691096234081
  { 301579433, 62, 8280528180ULL },   // factor: 4994473986929843881
  { 300463909, 62, 8321554260ULL },   // factor: 5000653443830404681
  { 301395893, 62, 8332481896ULL },   // factor: 5022751643902506257
  { 301394747, 62, 8342860620ULL },   // factor: 5028988731642326281
  { 301624597, 62, 8338659228ULL },   // factor: 5030289458331662233
  { 300789119, 62, 8369769960ULL },   // factor: 5035071465002130481
  { 301744189, 62, 8386919631ULL },   // factor: 5061408524528548519
  { 301337389, 62, 8398860495ULL },   // factor: 5061781384277095111
  { 300831511, 62, 8418668724ULL },   // factor: 5065201665698723929
  { 301868141, 62, 8395716103ULL },   // factor: 5068798424752749047
  { 301144891, 62, 8440511001ULL },   // factor: 5083633530760891783
  { 301252621, 62, 8441529731ULL },   // factor: 5086065913426349903
  { 300758587, 62, 8457704724ULL },   // factor: 5087454644106929977
  { 301420633, 62, 8444006751ULL },   // factor: 5090395719885386767
  { 301332469, 62, 8457925476ULL },   // factor: 5097295132602160489
  { 301898411, 62, 8449170364ULL },   // factor: 5101582214319783209
  { 300019183, 62, 8507909120ULL },   // factor: 5105071886441297921
  { 300109801, 62, 8504834079ULL },   // factor: 5104768125973416559
  { 300307729, 62, 8507803155ULL },   // factor: 5109918088514169991
  { 300346909, 62, 8508930927ULL },   // factor: 5111262205637909287
  { 301718441, 62, 8473774648ULL },   // factor: 5113388152359767537
  { 300600829, 62, 8506729311ULL },   // factor: 5114259765930397639
  { 300607709, 62, 8510001852ULL },   // factor: 5116344320630954137
  { 300195113, 62, 8539067388ULL },   // factor: 5126772598910549689
  { 301481413, 62, 8516141063ULL },   // factor: 5134916481961124039
  { 300150451, 62, 8561685365ULL },   // factor: 5139587447249699231
  { 300865381, 62, 8546810964ULL },   // factor: 5142879074037674569
  { 300605429, 62, 8569559496ULL },   // factor: 5152112217272207569
  { 300013957, 62, 8606702468ULL },   // factor: 5164261728292691753
  { 301410233, 62, 8573178232ULL },   // factor: 5168087296915296113
  { 301739539, 62, 8564191757ULL },   // factor: 5168310545329560047
  { 300561671, 62, 8609809633ULL },   // factor: 5175557540572753487
  { 301429981, 62, 8599874891ULL },   // factor: 5184520249993014143
  { 300189973, 62, 8648857596ULL },   // factor: 5192600656448169817
  { 301430113, 62, 8620956620ULL },   // factor: 5197231856269396121
  { 300992941, 62, 8639268923ULL },   // factor: 5200717922447345087
  { 301323619, 62, 8632678692ULL },   // factor: 5202459970275252697
  { 301990187, 62, 8619048880ULL },   // factor: 5205736366066681121
  { 300132947, 62, 8674613353ULL },   // factor: 5207074539442882583
  { 300580153, 62, 8662183752ULL },   // factor: 5207361034980548113
  { 300910531, 62, 8655314580ULL },   // factor: 5208950612479683961
  { 301363037, 62, 8663558032ULL },   // factor: 5221752319498526369
  { 300913231, 62, 8693314340ULL },   // factor: 5231866612296065081
  { 300526063, 62, 8704651352ULL },   // factor: 5231949201208374353
  { 300313121, 62, 8722538683ULL },   // factor: 5238985629869919287
  { 300005483, 62, 8754022428ULL },   // factor: 5252509453409945449
  { 301599973, 62, 8709996243ULL },   // factor: 5253869263437802879
  { 300673973, 62, 8756862840ULL },   // factor: 5265921482237726641
  { 301219531, 62, 8747383061ULL },   // factor: 5269765246223528783
  { 300968419, 62, 8758444932ULL },   // factor: 5272030648165205017
  { 300713327, 62, 8768650108ULL },   // factor: 5273699894551178633
  { 301189003, 62, 8755899456ULL },   // factor: 5274361255041764737
  { 300544807, 62, 8806087544ULL },   // factor: 5293247762673168017
  { 301968103, 62, 8774508033ULL },   // factor: 5299243090966542799
  { 300825529, 62, 8808971064ULL },   // factor: 5299926760546985713
  { 300708901, 62, 8821913456ULL },   // factor: 5305655800141743713
  { 301353343, 62, 8804439665ULL },   // factor: 5306494652579100191
  { 301979303, 62, 8792097972ULL },   // factor: 5310063234984547033
  { 300009473, 62, 8860506556ULL },   // factor: 5316471804757209977
  { 300072691, 62, 8860609221ULL },   // factor: 5317653705689767423
  { 301237043, 62, 8829970941ULL },   // factor: 5319828672085534927
  { 301845367, 62, 8817432489ULL },   // factor: 5323002291279856927
  { 301443481, 62, 8837604299ULL },   // factor: 5328076407182249639
  { 301438121, 62, 8847926364ULL },   // factor: 5334204595821044089
  { 300859919, 62, 8866885636ULL },   // factor: 5335380988458446969
  { 300543811, 62, 8882808956ULL },   // factor: 5339346512042342633
  { 300941299, 62, 8875236600ULL },   // factor: 5341850462672686801
  { 301048973, 62, 8899929760ULL },   // factor: 5358629428040272961
  { 300718027, 62, 8924770892ULL },   // factor: 5367678988138540169
  { 301046147, 62, 8915140780ULL },   // factor: 5367737563563149321
  { 300343213, 62, 8936444927ULL },   // factor: 5368001164345460903
  { 301047613, 62, 8921987843ULL },   // factor: 5371886286700337519
  { 300609217, 62, 8945869715ULL },   // factor: 5378421780820326311
  { 300783881, 62, 8958707044ULL },   // factor: 5389269346872715529
  { 301952969, 62, 8929247512ULL },   // factor: 5392425594368526257
  { 301416439, 62, 8957467536ULL },   // factor: 5399855934318448609
  { 301529203, 62, 8953833860ULL },   // factor: 5399684775200427161
  { 301416683, 62, 9002748301ULL },   // factor: 5427157061542611167
  { 301115987, 62, 9028333729ULL },   // factor: 5437151243546451047
  { 301805503, 62, 9009879837ULL },   // factor: 5438462632350686023
  { 301037927, 62, 9045355857ULL },   // factor: 5445990352337176879
  { 300291391, 62, 9107313800ULL },   // factor: 5469695858550991601
  { 300209843, 62, 9121344781ULL },   // factor: 5476634969305758767
  { 300616439, 62, 9109843857ULL },   // factor: 5477137640274730447
  { 301212007, 62, 9091525113ULL },   // factor: 5476953051955263583
  { 301781549, 62, 9077921755ULL },   // factor: 5479098577849396991
  { 300280289, 62, 9123781416ULL },   // factor: 5479383440738618449
  { 300485243, 62, 9126461136ULL },   // factor: 5484733784362032097
  { 300049247, 62, 9155061600ULL },   // factor: 5493938678637230401
  { 300381889, 62, 9160819035ULL },   // factor: 5503488253040914231
  { 301471447, 62, 9131817572ULL },   // factor: 5505964514341733369
  { 300408961, 62, 9172252644ULL },   // factor: 5510853773627085769
  { 301596301, 62, 9138277616ULL },   // factor: 5512141452993396833
  { 300628261, 62, 9173481011ULL },   // factor: 5515615287306903743
  { 300170023, 62, 9191618061ULL },   // factor: 5518096409555170807
  { 300919961, 62, 9169651183ULL },   // factor: 5518662152743927727
  { 300050761, 62, 9199756475ULL },   // factor: 5520787862676854951
  { 301505741, 62, 9162672543ULL },   // factor: 5525196749235138727
  { 300081289, 62, 9219112172ULL },   // factor: 5532966128018699417
  { 300508877, 62, 9226409043ULL },   // factor: 5545235640509149423
  { 300119591, 62, 9245528589ULL },   // factor: 5549528517418974199
  { 301009789, 62, 9220931727ULL },   // factor: 5551181427055351207
  { 301180403, 62, 9216115440ULL },   // factor: 5551426724627444641
  { 301969669, 62, 9193274784ULL },   // factor: 5552180287101052993
  { 300288577, 62, 9247751967ULL },   // factor: 5553988557238761919
  { 300369533, 62, 9247766587ULL },   // factor: 5555494662060387743
  { 301959139, 62, 9204680409ULL },   // factor: 5558874742143615703
  { 301677331, 62, 9214104929ULL },   // factor: 5559373165069328999
  { 300897461, 62, 9267488764ULL },   // factor: 5577127677867256409
  { 300245983, 62, 9293562048ULL },   // factor: 5580709345346506369
  { 300375443, 62, 9301191993ULL },   // factor: 5587699330650855799
  { 301702787, 62, 9263073688ULL },   // factor: 5589390295711936913
  { 301800119, 62, 9264212517ULL },   // factor: 5591880880143779047
  { 300248537, 62, 9313453800ULL },   // factor: 5592701755734181201
  { 301430911, 62, 9282836676ULL },   // factor: 5596267831821783673
  { 301140211, 62, 9308650740ULL },   // factor: 5606418095937812281
  { 300003323, 62, 9344764696ULL },   // factor: 5606920922906169617
  { 300721831, 62, 9330045641ULL },   // factor: 5611496816950177343
  { 301719611, 62, 9301260045ULL },   // factor: 5612745125174484991
  { 300019691, 62, 9359690380ULL },   // factor: 5616182831326545161
  { 300395791, 62, 9357605696ULL },   // factor: 5621970729832051073
  { 300347207, 62, 9376857993ULL },   // factor: 5632626217266351103
  { 300802687, 62, 9396338832ULL },   // factor: 5652887937256083169
  { 300358867, 62, 9411932412ULL },   // factor: 5653914711097794409
  { 300829691, 62, 9401187096ULL },   // factor: 5656312418245734673
  { 301264081, 62, 9399914519ULL },   // factor: 5663713218090184079
  { 300950989, 62, 9412814955ULL },   // factor: 5665591939962480991
  { 300616373, 62, 9459177900ULL },   // factor: 5687167503719513401
  { 300257743, 62, 9479565488ULL },   // factor: 5692625876095147169
  { 300716963, 62, 9466165633ULL },   // factor: 5693273160821465159
  { 301963997, 62, 9438444024ULL },   // factor: 5700140565895607857
  { 300861811, 62, 9474801836ULL },   // factor: 5701212078490169993
  { 300913603, 62, 9491237516ULL },   // factor: 5712084955736660297
  { 301904627, 62, 9463926945ULL },   // factor: 5714406668570949031
  { 300401417, 62, 9514938300ULL },   // factor: 5716601895975142201
  { 300491557, 62, 9519027848ULL },   // factor: 5720774998343758673
  { 301196767, 62, 9519416912ULL },   // factor: 5734435195239047009
  { 301855271, 62, 9509209084ULL },   // factor: 5740809770092963529
  { 300597497, 62, 9560340912ULL },   // factor: 5747629097227794529
  { 300914851, 62, 9558226893ULL },   // factor: 5752424842662575887
  { 300260771, 62, 9581278864ULL },   // factor: 5753764357741288289
  { 301485419, 62, 9542700249ULL },   // factor: 5753969965922338663
  { 300488873, 62, 9580853575ULL },   // factor: 5757879786259541951
  { 301444307, 62, 9550684273ULL },   // factor: 5757998804100567623
  { 300036463, 62, 9596356737ULL },   // factor: 5758513866111402463
  { 300168719, 62, 9600781597ULL },   // factor: 5763708626740528487
  { 301058801, 62, 9578356663ULL },   // factor: 5767297145026282127
  { 300012751, 62, 9618080225ULL },   // factor: 5771093415281897951
  { 301807903, 62, 9562662876ULL },   // factor: 5772174459403018057
  { 300657299, 62, 9623179237ULL },   // factor: 5786558154378601727
  { 301186609, 62, 9606265220ULL },   // factor: 5786556893532877961
  { 300975889, 62, 9617317059ULL },   // factor: 5789161103254780903
  { 301196977, 62, 9615110955ULL },   // factor: 5792084706331166071
  { 300681853, 62, 9642391932ULL },   // factor: 5798584546932019993
  { 300176213, 62, 9662413227ULL },   // factor: 5800853221843938703
  { 300951779, 62, 9673601772ULL },   // factor: 5822575325241904777
  { 300041869, 62, 9712588739ULL },   // factor: 5828366556155826383
  { 300254237, 62, 9713573415ULL },   // factor: 5833083148528618711
  { 300636097, 62, 9701453435ULL },   // factor: 5833214191851286391
  { 301736537, 62, 9669941859ULL },   // factor: 5835549539052004567
  { 300404509, 62, 9738721104ULL },   // factor: 5851111463070115873
  { 300153307, 62, 9747597300ULL },   // factor: 5851547129798542201
  { 300020081, 62, 9752979720ULL },   // factor: 5852179531171514641
  { 301332953, 62, 9713166672ULL },   // factor: 5853794392509884833
  { 301648049, 62, 9712372575ULL },   // factor: 5859436476819712351
  { 300085537, 62, 9763983939ULL },   // factor: 5860060727188380487
  { 301416043, 62, 9728684580ULL },   // factor: 5864763219397433881
  { 301894907, 62, 9716449312ULL },   // factor: 5866693122832907969
  { 301952887, 62, 9741424697ULL },   // factor: 5882902621504500479
  { 301341631, 62, 9766128549ULL },   // factor: 5885882211022646839
  { 301194809, 62, 9772114864ULL },   // factor: 5886620539977081953
  { 301126183, 62, 9807609476ULL },   // factor: 5906656011725020217
  { 300862621, 62, 9824816076ULL },   // factor: 5911839830936590393
  { 300756791, 62, 9843560676ULL },   // factor: 5921035441855101433
  { 300098681, 62, 9880677676ULL },   // factor: 5930356675907490713
  { 301270979, 62, 9842317792ULL },   // factor: 5930409433649916737
  { 300394957, 62, 9890068752ULL },   // factor: 5941853554968167329
  { 300264317, 62, 9903347188ULL },   // factor: 5947243558837381193
  { 300728543, 62, 9897370840ULL },   // factor: 5952843824487772241
  { 300004141, 62, 9923925419ULL },   // factor: 5954437441350320159
  { 301589251, 62, 9871980096ULL },   // factor: 5954566166079096193
  { 300277589, 62, 9924196480ULL },   // factor: 5960027583553373441
  { 301725323, 62, 9887648232ULL },   // factor: 5966707713021157873
  { 301922353, 62, 9885121032ULL },   // factor: 5969078003342456593
  { 301545731, 62, 9909251076ULL },   // factor: 5976184718749913113
  { 301668551, 62, 9909764193ULL },   // factor: 5978928409707988687
  { 301420919, 62, 9937095184ULL },   // factor: 5990496725103508193
  { 301043863, 62, 9955810653ULL },   // factor: 5994271396551345079
  { 300635449, 62, 9976951392ULL },   // factor: 5998850522770190017
  { 301003891, 62, 9975934680ULL },   // factor: 6005590310083679761
  { 300684691, 62, 9987473168ULL },   // factor: 6006160566781742177
  { 301438369, 62, 9964052271ULL },   // factor: 6007095330401971999
  { 300530497, 62, 9997409892ULL },   // factor: 6009053127110952649
  { 300245191, 62, 10009474733ULL },   // factor: 6010593306038518007
  { 301550251, 62, 9967446573ULL },   // factor: 6011372031834479647
  { 300580327, 62, 10007135405ULL },   // factor: 6015896064736354871
  { 301520957, 62, 9988677279ULL },   // factor: 6023591064656472007
  { 300293401, 62, 10032439460ULL },   // factor: 6025350731540006921
  { 300738401, 62, 10033407388ULL },   // factor: 6034861788897413177
  { 300620939, 62, 10038123685ULL },   // factor: 6035340335965680431
  { 301389397, 62, 10029676320ULL },   // factor: 6045676196379958081
  { 301118899, 62, 10063698977ULL },   // factor: 6060739911643332647
  { 301478381, 62, 10104947160ULL },   // factor: 6092846219774695921
  { 301482151, 62, 10118084220ULL },   // factor: 6100843589289514441
  { 301545331, 62, 10125435620ULL },   // factor: 6106555671104180441
  { 300644153, 62, 10159733731ULL },   // factor: 6108929084524049687
  { 301769681, 62, 10124883559ULL },   // factor: 6110765763523149359
  { 301705093, 62, 10132148496ULL },   // factor: 6113841608550980257
  { 300020467, 62, 10203248172ULL },   // factor: 6122366562960672649
  { 300484453, 62, 10191362828ULL },   // factor: 6124692169392226169
  { 300109673, 62, 10249013196ULL },   // factor: 6151655997648489817
  { 300594661, 62, 10240487919ULL },   // factor: 6156471988972800919
  { 301239979, 62, 10220912105ULL },   // factor: 6157894695742091591
  { 301013311, 62, 10229846468ULL },   // factor: 6158639912708671097
  { 301985713, 62, 10227450347ULL },   // factor: 6177087770421784823
  { 301513939, 62, 10245198140ULL },   // factor: 6178140094053746921
  { 300117079, 62, 10323416109ULL },   // factor: 6196466975869251223
  { 300586007, 62, 10317567213ULL },   // factor: 6202632661019576983
  { 301565939, 62, 10290938604ULL },   // factor: 6206793126613218313
  { 300187427, 62, 10385595600ULL },   // factor: 6235250442053042401
  { 301944707, 62, 10345059117ULL },   // factor: 6247271687960487439
  { 301529303, 62, 10361284197ULL },   // factor: 6248461604212649383
  { 301495307, 62, 10369875853ULL },   // factor: 6252937807704243743
  { 300286093, 62, 10413619128ULL },   // factor: 6254130003874373809
  { 300870733, 62, 10399588875ULL },   // factor: 6257863855439790751
  { 301896527, 62, 10370348412ULL },   // factor: 6261544338725530249
  { 301582493, 62, 10382574663ULL },   // factor: 6262405501252349719
  { 301092521, 62, 10402994736ULL },   // factor: 6264527822023938913
  { 300881627, 62, 10430476624ULL },   // factor: 6276677554029174497
  { 300746861, 62, 10443008500ULL },   // factor: 6281404051542637001
  { 300240953, 62, 10461123775ULL },   // factor: 6281715543313915151
  { 301597837, 62, 10420715924ULL },   // factor: 6285730765339712777
  { 301339853, 62, 10441025235ULL },   // factor: 6292594018968380911
  { 300556349, 62, 10471318747ULL },   // factor: 6294442663627149407
  { 300148843, 62, 10490852181ULL },   // factor: 6297634288422353167
  { 301099759, 62, 10465421612ULL },   // factor: 6302271850413183017
  { 301980011, 62, 10443613540ULL },   // factor: 6307525063377897881
  { 300751667, 62, 10500004768ULL },   // factor: 6315787874967896513
  { 300136019, 62, 10533846916ULL },   // factor: 6323173756247334809
  { 301378853, 62, 10497145431ULL },   // factor: 6327235299537941287
  { 301835099, 62, 10491821640ULL },   // factor: 6333600046799484721
  { 300351743, 62, 10550407321ULL },   // factor: 6337666456444621007
  { 300284057, 62, 10571738275ULL },   // factor: 6349048917518363351
  { 301937827, 62, 10528990868ULL },   // factor: 6358201246373527673
  { 300736913, 62, 10576677787ULL },   // factor: 6361594854916103063
  { 301670101, 62, 10547144543ULL },   // factor: 6363516319096817687
  { 300402419, 62, 10599045121ULL },   // factor: 6367957586877095399
  { 300791143, 62, 10588123688ULL },   // factor: 6369627652677790769
  { 300026009, 62, 10631587171ULL },   // factor: 6379505336501461079
  { 301104053, 62, 10596739651ULL },   // factor: 6381442515003811007
  { 301332749, 62, 10598423047ULL },   // factor: 6387303903634932407
  { 301870747, 62, 10589234325ULL },   // factor: 6393160151691581551
  { 300066589, 62, 10658415891ULL },   // factor: 6396469001111531599
  { 300490639, 62, 10645756800ULL },   // factor: 6397900526941190401
  { 301633127, 62, 10621908340ULL },   // factor: 6407838854603158361
  { 301182503, 62, 10653945645ULL },   // factor: 6417564032374098871
  { 300075161, 62, 10697665875ULL },   // factor: 6420207619529661751
  { 301424273, 62, 10653537432ULL },   // factor: 6422469550637773873
  { 301542853, 62, 10677441960ULL },   // factor: 6439412622720623761
  { 300986333, 62, 10708333996ULL },   // factor: 6446124363990553337
  { 300483371, 62, 10730100396ULL },   // factor: 6448433476317029833
  { 300213607, 62, 10759736408ULL },   // factor: 6460438554829807313
  { 300016777, 62, 10770281835ULL },   // factor: 6462530487036691591
  { 300809857, 62, 10762643960ULL },   // factor: 6475018781099027441
  { 300561223, 62, 10779488052ULL },   // factor: 6479792224446015193
  { 301528159, 62, 10758123281ULL },   // factor: 6487754214429939359
  { 301120147, 62, 10774671657ULL },   // factor: 6488941426465147159
  { 301113271, 62, 10785613365ULL },   // factor: 6495382640152933831
  { 301662983, 62, 10766046096ULL },   // factor: 6495435160869728737
  { 300286633, 62, 10824399035ULL },   // factor: 6500844680937198311
  { 301484893, 62, 10798612376ULL },   // factor: 6511236993453671537
  { 300432827, 62, 10839424053ULL },   // factor: 6513037622589175663
  { 300928939, 62, 10827132236ULL },   // factor: 6516394832384355209
  { 301842503, 62, 10816506885ULL },   // factor: 6529763023770266311
  { 301099369, 62, 10882800755ULL },   // factor: 6553608880566447191
  { 301422559, 62, 10880916201ULL },   // factor: 6559507211139956719
  { 300555239, 62, 10912818601ULL },   // factor: 6559809605574401279
  { 301558877, 62, 10889074339ULL },   // factor: 6567394058476714607
  { 300006359, 62, 10953775620ULL },   // factor: 6572404682118335161
  { 301439183, 62, 10926409140ULL },   // factor: 6587295688570665241
  { 301754741, 62, 10919967480ULL },   // factor: 6590303917311645361
  { 300333641, 62, 10973557468ULL },   // factor: 6591456938174361977
  { 300972031, 62, 10953254088ULL },   // factor: 6593246257848825457
  { 301476323, 62, 10934653413ULL },   // factor: 6593078208461280799
  { 301433203, 62, 10939496201ULL },   // factor: 6595054758147523607
  { 301051253, 62, 10955836015ULL },   // factor: 6596536319956553591
  { 300899717, 62, 10970523268ULL },   // factor: 6602054693366230313
  { 300808733, 62, 10999440687ULL },   // factor: 6617455633530239143
  { 301882799, 62, 10978057384ULL },   // factor: 6628173381329075633
  { 300544859, 62, 11037998677ULL },   // factor: 6634827512042303087
  { 301903271, 62, 10991677921ULL },   // factor: 6636847036256759183
  { 301854479, 62, 11057793537ULL },   // factor: 6675689014001404447
  { 300956479, 62, 11106860825ULL },   // factor: 6685363453270070351
  { 301134161, 62, 11104775284ULL },   // factor: 6688054376481753449
  { 300432689, 62, 11154666916ULL },   // factor: 6702453152946434249
  { 300514943, 62, 11183095413ULL },   // factor: 6721374561202512919
  { 300761953, 62, 11176128615ULL },   // factor: 6722708538453170191
  { 301634143, 62, 11168961480ULL },   // factor: 6737880248439623281
  { 300040529, 62, 11235014587ULL },   // factor: 6741919440012393047
  { 300700493, 62, 11218194547ULL },   // factor: 6746633261705623343
  { 300774983, 62, 11218758676ULL },   // factor: 6748643900110005017
  { 300043333, 62, 11249409503ULL },   // factor: 6750620643123986999
  { 301937963, 62, 11211206805ULL },   // factor: 6770177890946876431
  { 300441859, 62, 11286003101ULL },   // factor: 6781575504688409519
  { 301276021, 62, 11257030871ULL },   // factor: 6782946938178088583
  { 300383173, 62, 11350198532ULL },   // factor: 6818817298444204073
  { 300728677, 62, 11371897719ULL },   // factor: 6839711512028375527
  { 300196469, 62, 11394081820ULL },   // factor: 6840926259722187161
  { 300957961, 62, 11374427999ULL },   // factor: 6846449316240700079
  { 300945397, 62, 11375936687ULL },   // factor: 6847071565032159479
  { 300981221, 62, 11386824108ULL },   // factor: 6854440446676151737
  { 301566401, 62, 11368723968ULL },   // factor: 6856850341984398337
  { 300027853, 62, 11442463728ULL },   // factor: 6866115650684431969
  { 301896103, 62, 11373865188ULL },   // factor: 6867451152609124729
  { 300374923, 62, 11432929385ULL },   // factor: 6868330567367624711
  { 300229493, 62, 11439722280ULL },   // factor: 6869084040370408081
  { 301325029, 62, 11405037756ULL },   // factor: 6873246665145589849
  { 300301891, 62, 11456642208ULL },   // factor: 6880902639145630657
  { 301564013, 62, 11408634220ULL },   // factor: 6880867036464649721
  { 301557929, 62, 11411951607ULL },   // factor: 6882728984910283807
  { 301491287, 62, 11436045045ULL },   // factor: 6895735877614045831
  { 301895863, 62, 11457077837ULL },   // factor: 6917688802118576663
  { 300124997, 62, 11527726500ULL },   // factor: 6919517762458641001
  { 301577797, 62, 11481493767ULL },   // factor: 6925127193042182599
  { 300683351, 62, 11522255245ULL },   // factor: 6929100636287851991
  { 300873577, 62, 11523765999ULL },   // factor: 6934393393260216847
  { 301256731, 62, 11510922036ULL },   // factor: 6935485486722448633
  { 300709559, 62, 11538469581ULL },   // factor: 6939456198474849559
  { 300808153, 62, 11573830115ULL },   // factor: 6963004920057855191
  { 300820367, 62, 11574476964ULL },   // factor: 6963676816287051577
  { 300082609, 62, 11610197696ULL },   // factor: 6968036831242937729
  { 301961579, 62, 11540312332ULL },   // factor: 6969461867847784457
  { 301942621, 62, 11549053224ULL },   // factor: 6974302801046120209
  { 301383161, 62, 11588017431ULL },   // factor: 6984866646155758783
  { 300156019, 62, 11642504264ULL },   // factor: 6989135462145530033
  { 300770497, 62, 11624370707ULL },   // factor: 6992535509713262759
  { 300905953, 62, 11622233963ULL },   // factor: 6994398773250963479
  { 301210499, 62, 11611307604ULL },   // factor: 6994895514886668793
  { 301877887, 62, 11594441145ULL },   // factor: 7000210787596921231
  { 300201389, 62, 11674748712ULL },   // factor: 7009551559136721937
  { 300952081, 62, 11648920856ULL },   // factor: 7011533946035002673
  { 301580491, 62, 11631636144ULL },   // factor: 7015749078881733409
  { 301419467, 62, 11657748469ULL },   // factor: 7027744659892092047
  { 300204353, 62, 11710691031ULL },   // factor: 7031200848288515887
  { 301537069, 62, 11680686491ULL },   // factor: 7044319936808069759
  { 301924201, 62, 11667927779ULL },   // factor: 7045659544000559159
  { 301010263, 62, 11716378121ULL },   // factor: 7053500119219311647
  { 300381247, 62, 11742819977ULL },   // factor: 7054645815975542639
  { 301373557, 62, 11748744555ULL },   // factor: 7081521873649464271
  { 300558053, 62, 11784466912ULL },   // factor: 7083832861427284673
  { 301288927, 62, 11759262000ULL },   // factor: 7085870860583748001
  { 301828613, 62, 11741262963ULL },   // factor: 7087698229981120639
  { 300071257, 62, 11811530400ULL },   // factor: 7088601548443425601
  { 301851919, 62, 11751797700ULL },   // factor: 7094605374889572601
  { 300390007, 62, 11819473908ULL },   // factor: 7100903699920874713
  { 301218779, 62, 11807377596ULL },   // factor: 7113207725318150569
  { 300363377, 62, 11844494844ULL },   // factor: 7115304940405856377
  { 300034391, 62, 11864871880ULL },   // factor: 7119739217617650161
  { 301153219, 62, 11855003580ULL },   // factor: 7140344978747048041
  { 301298651, 62, 11855756421ULL },   // factor: 7144246832463776143
  { 301638877, 62, 11869419588ULL },   // factor: 7160556790332245353
  { 301988569, 62, 11862320964ULL },   // factor: 7164570665874121033
  { 300665653, 62, 11918344068ULL },   // factor: 7166873403767792809
  { 300785917, 62, 11918372339ULL },   // factor: 7169757106267099727
  { 300152023, 62, 11955473277ULL },   // factor: 7176918980027978743
  { 301901923, 62, 11887425941ULL },   // factor: 7177673502215969087
  { 301348283, 62, 11910148521ULL },   // factor: 7178205614156678887
  { 300874837, 62, 11935021820ULL },   // factor: 7181895489367886681
  { 300971087, 62, 11962648597ULL },   // factor: 7200822703276229879
  { 301606693, 62, 11949331895ULL },   // factor: 7207996952820746471
  { 301806331, 62, 11941290333ULL },   // factor: 7207914045616996447
  { 300691067, 62, 12012876664ULL },   // factor: 7224329403675120977
  { 300204431, 62, 12049459948ULL },   // factor: 7234602535093259177
  { 301954547, 62, 11981869044ULL },   // factor: 7235959678788686137
  { 300860699, 62, 12034482969ULL },   // factor: 7241405916313870663
  { 301949987, 62, 11995776820ULL },   // factor: 7244249309707802681
  { 300520621, 62, 12076381908ULL },   // factor: 7258403580850649737
  { 300438643, 62, 12087425673ULL },   // factor: 7263059533118963479
  { 300462139, 62, 12090336525ULL },   // factor: 7265376747062653951
  { 300670837, 62, 12082477208ULL },   // factor: 7265697070325566193
  { 301589053, 62, 12045812520ULL },   // factor: 7265770381044687121
  { 300022643, 62, 12112372972ULL },   // factor: 7267972304122409993
  { 300918623, 62, 12081488928ULL },   // factor: 7271090024007012289
  { 300151963, 62, 12123396116ULL },   // factor: 7277722284887951417
  { 300835511, 62, 12096512148ULL },   // factor: 7278120826722575257
  { 301348279, 62, 12078468921ULL },   // factor: 7279651644596673919
  { 300656159, 62, 12170141649ULL },   // factor: 7318056085348532383
  { 301887217, 62, 12130188395ULL },   // factor: 7323897632504493431
  { 301400513, 62, 12160885536ULL },   // factor: 7330594278169359937
  { 301550969, 62, 12163750464ULL },   // factor: 7335981478186799233
  { 300513047, 62, 12207330877ULL },   // factor: 7336924395168904439
  { 300714317, 62, 12208155727ULL },   // factor: 7342334422548886919
  { 301803823, 62, 12168519288ULL },   // factor: 7345011282735276049
  { 300158321, 62, 12236027608ULL },   // factor: 7345491005053852337
  { 301392631, 62, 12187209525ULL },   // factor: 7346270286576020551
  { 301580359, 62, 12208400925ULL },   // factor: 7363627867554864151
  { 301739413, 62, 12228734735ULL },   // factor: 7379782481343221111
  { 301636667, 62, 12235896825ULL },   // factor: 7381590272097764551
  { 301187603, 62, 12258854841ULL },   // factor: 7384430210171472247
  { 301690033, 62, 12247280915ULL },   // factor: 7389765166813240391
  { 301072237, 62, 12292986179ULL },   // factor: 7402153696643224847
  { 301686263, 62, 12271218772ULL },   // factor: 7404116267560258073
  { 301904917, 62, 12278035167ULL },   // factor: 7413598376032432279
  { 301722539, 62, 12352333464ULL },   // factor: 7453954830665490193
  { 301181921, 62, 12378934588ULL },   // factor: 7456622598294367097
  { 301690349, 62, 12387133660ULL },   // factor: 7474157353990094681
  { 300784249, 62, 12427268319ULL },   // factor: 7475853136903814863
  { 301193293, 62, 12415374363ULL },   // factor: 7478854976439494719
  { 300727283, 62, 12441919677ULL },   // factor: 7483249399536895183
  { 301534817, 62, 12487852387ULL },   // factor: 7531044568474116359
  { 301777859, 62, 12477841957ULL },   // factor: 7531072861447660127
  { 301949443, 62, 12483999612ULL },   // factor: 7539073458511232233
  { 300198137, 62, 12561376783ULL },   // factor: 7541803816823306543
  { 301720651, 62, 12503646108ULL },   // factor: 7545216487158752617
  { 300453697, 62, 12581349080ULL },   // factor: 7560225688667097521
  { 300207577, 62, 12619069548ULL },   // factor: 7576680585999130393
  { 301881299, 62, 12551663932ULL },   // factor: 7578225224807215337
  { 300904801, 62, 12609896324ULL },   // factor: 7588756688007703049
  { 300392203, 62, 12638286873ULL },   // factor: 7592885671852902439
  { 301252243, 62, 12610296756ULL },   // factor: 7597760365281247417
  { 300947551, 62, 12625216460ULL },   // factor: 7599055948963778921
  { 300340483, 62, 12653205788ULL },   // factor: 7600539875732631209
  { 301429529, 62, 12630012871ULL },   // factor: 7614117661938935519
  { 301510931, 62, 12637933288ULL },   // factor: 7620950063161542257
  { 301468787, 62, 12649847953ULL },   // factor: 7627068636250686023
  { 301059401, 62, 12678220980ULL },   // factor: 7633795227968865961
  { 301965077, 62, 12641684652ULL },   // factor: 7634694558701796409
  { 301458037, 62, 12668890040ULL },   // factor: 7638277444854502961
  { 300907469, 62, 12708913452ULL },   // factor: 7648413961162745977
  { 301942757, 62, 12678113463ULL },   // factor: 7656129065154074983
  { 301998911, 62, 12683337816ULL },   // factor: 7660708416554236753
  { 301248377, 62, 12718132392ULL },   // factor: 7662633483122255569
  { 301403393, 62, 12711749052ULL },   // factor: 7662728590474666873
  { 300317539, 62, 12775846889ULL },   // factor: 7673621792690572343
  { 301559183, 62, 12740977036ULL },   // factor: 7684317251195843177
  { 300549499, 62, 12787883360ULL },   // factor: 7686783874236873281
  { 300200477, 62, 12811471948ULL },   // factor: 7692019979723438393
  { 301355809, 62, 12779982692ULL },   // factor: 7702644046307315657
  { 300856687, 62, 12843768545ULL },   // factor: 7728267306087020831
  { 300877189, 62, 12888214664ULL },   // factor: 7755539598665798993
  { 300445781, 62, 12910046931ULL },   // factor: 7757538265861896223
  { 300771949, 62, 12937394939ULL },   // factor: 7782410981571532223
  { 300055109, 62, 12971860440ULL },   // factor: 7784545996513975921
  { 300916703, 62, 12943555336ULL },   // factor: 7789863993614354417
  { 300809227, 62, 12951633513ULL },   // factor: 7791941730865648903
  { 301470313, 62, 12941596932ULL },   // factor: 7803014555619759433
  { 301980377, 62, 12924733344ULL },   // factor: 7806031695691181377
  { 300329033, 62, 13017759207ULL },   // factor: 7819222068930313663
  { 301585303, 62, 12965406233ULL },   // factor: 7820351934594787199
  { 301135273, 62, 12989129895ULL },   // factor: 7822970353926572671
  { 301702309, 62, 12969154812ULL },   // factor: 7825647905117721817
  { 300717979, 62, 13035577685ULL },   // factor: 7840065153061397231
  { 300446359, 62, 13064724269ULL },   // factor: 7850497675919973143
  { 301949161, 62, 13000057256ULL },   // factor: 7850712762802324433
  { 300218423, 62, 13085381857ULL },   // factor: 7856945410922703023
  { 300653797, 62, 13072674879ULL },   // factor: 7860698678635731127
  { 301658597, 62, 13044613047ULL },   // factor: 7870039340331830119
  { 301663429, 62, 13044236391ULL },   // factor: 7869938156791289479
  { 301133401, 62, 13073263800ULL },   // factor: 7873592780528367601
  { 301300619, 62, 13091618617ULL },   // factor: 7889025586028047847
  { 301317791, 62, 13093047561ULL },   // factor: 7890336337076915503
  { 300134161, 62, 13162785311ULL },   // factor: 7901203051480218143
  { 300160733, 62, 13161868380ULL },   // factor: 7901352121180645081
  { 301856483, 62, 13100957248ULL },   // factor: 7909217757629277569
  { 301218871, 62, 13130561696ULL },   // factor: 7910345939329930433
  { 300594449, 62, 13183693060ULL },   // factor: 7925889902311647881
  { 301317701, 62, 13163952520ULL },   // factor: 7933063818799113041
  { 300081547, 62, 13231561752ULL },   // factor: 7941095039532380689
  { 301951787, 62, 13154473572ULL },   // factor: 7944033604219346329
  { 301228463, 62, 13188679672ULL },   // factor: 7945611413191808273
  { 300260869, 62, 13248506475ULL },   // factor: 7956016134271253551
  { 300928633, 62, 13254505568ULL },   // factor: 7977320483338257089
  { 301685107, 62, 13234197168ULL },   // factor: 7985120377374353953
  { 301376143, 62, 13255656060ULL },   // factor: 7989876992594753161
  { 301023649, 62, 13272839711ULL },   // factor: 7990877284794650879
  { 301606489, 62, 13249784124ULL },   // factor: 7992441739295161273
  { 301945481, 62, 13236930036ULL },   // factor: 7993662413366734633
  { 300987173, 62, 13300682572ULL },   // factor: 8006669692633297913
  { 300612397, 62, 13352473563ULL },   // factor: 8027838167305121023
  { 300555701, 62, 13363946040ULL },   // factor: 8033220340356748081
  { 301377919, 62, 13346661432ULL },   // factor: 8044778095947440017
  { 301586093, 62, 13339488547ULL },   // factor: 8046008467015953743
  { 301405669, 62, 13372818059ULL },   // factor: 8061286346976352943
  { 301395121, 62, 13384227075ULL },   // factor: 8067881477522202151
  { 300274829, 62, 13451567820ULL },   // factor: 8078334453864805561
  { 300915353, 62, 13428624991ULL },   // factor: 8081758858942773647
  { 301172111, 62, 13431234321ULL },   // factor: 8090226387582443263
  { 300764801, 62, 13451685868ULL },   // factor: 8091587246407064537
  { 301239817, 62, 13433898168ULL },   // factor: 8093650051449910513
  { 301249733, 62, 13438102360ULL },   // factor: 8096449495953339761
  { 301653337, 62, 13426622639ULL },   // factor: 8100371047388192687
  { 300630277, 62, 13488061572ULL },   // factor: 8109839373166830889
  { 300518411, 62, 13505922321ULL },   // factor: 8117556629992703863
  { 301260937, 62, 13477054952ULL },   // factor: 8120220405680020049
  { 301128323, 62, 13489711921ULL },   // factor: 8124268657047676967
  { 301780673, 62, 13460539687ULL },   // factor: 8124261451372138703
  { 300547133, 62, 13542730731ULL },   // factor: 8140457788386088447
  { 301678931, 62, 13514103456ULL },   // factor: 8153840568058971073
  { 300389057, 62, 13574240383ULL },   // factor: 8155106536281377663
  { 300276047, 62, 13593371460ULL },   // factor: 8163527694822837241
  { 301790653, 62, 13532518916ULL },   // factor: 8167975440788984297
  { 301651697, 62, 13544340552ULL },   // factor: 8171346624513433489
  { 301453307, 62, 13563328440ULL },   // factor: 8177420424330302161
  { 300604949, 62, 13615327875ULL },   // factor: 8185669882965306751
  { 301797017, 62, 13562851027ULL },   // factor: 8186455963927972919
  { 300890609, 62, 13605706927ULL },   // factor: 8187658886281097087
  { 301920197, 62, 13562267488ULL },   // factor: 8189444943487310273
  { 301670959, 62, 13583762349ULL },   // factor: 8195653229301845383
  { 301767379, 62, 13604610045ULL },   // factor: 8210855031193444111
  { 300887903, 62, 13649782221ULL },   // factor: 8214108697766745127
  { 301631537, 62, 13616455228ULL },   // factor: 8214304637826650873
  { 300524207, 62, 13680505633ULL },   // factor: 8222646213432716063
  { 301266253, 62, 13650443240ULL },   // factor: 8224835773407959441
  { 301178699, 62, 13660808677ULL },   // factor: 8228689169253542447
  { 301846973, 62, 13653730452ULL },   // factor: 8242674414188243593
  { 301075847, 62, 13734255340ULL },   // factor: 8270105118809545961
  { 301330333, 62, 13768615803ULL },   // factor: 8297803169734104799
  { 300016487, 62, 13839084445ULL },   // factor: 8303906996970489431
  { 300172091, 62, 13833448588ULL },   // factor: 8304830376801915017
  { 301571761, 62, 13782687899ULL },   // factor: 8312938922029640279
  { 300692533, 62, 13845398028ULL },   // factor: 8326415606865049849
  { 301823663, 62, 13808362401ULL },   // factor: 8335381039802589727
  { 300176983, 62, 13889096465ULL },   // factor: 8338374146919330191
  { 300686513, 62, 13871299260ULL },   // factor: 8341825210537760761
  { 300217669, 62, 13934934356ULL },   // factor: 8367027020052672329
  { 300680287, 62, 13928903888ULL },   // factor: 8376293637278511713
  { 301284173, 62, 13910407992ULL },   // factor: 8381971535924621233
  { 300202789, 62, 13961809679ULL },   // factor: 8382748410245989463
  { 301580029, 62, 13901880371ULL },   // factor: 8385058970881421519
  { 301692733, 62, 13921877136ULL },   // factor: 8400258323300105377
  { 301995653, 62, 13909617483ULL },   // factor: 8401288029517602799
  { 301719631, 62, 13924784409ULL },   // factor: 8402761627276066159
  { 300963011, 62, 13963484928ULL },   // factor: 8404984935967996417
  { 301772137, 62, 13958843604ULL },   // factor: 8424780128855723497
  { 300498641, 62, 14024027376ULL },   // factor: 8428402335669592033
  { 301753321, 62, 13976774088ULL },   // factor: 8435075995841492497
  { 301416179, 62, 13996756360ULL },   // factor: 8437697640850296881
  { 301453447, 62, 14006991033ULL },   // factor: 8444911457991881503
  { 300485089, 62, 14053987920ULL },   // factor: 8446027621892249761
  { 300953701, 62, 14036287971ULL },   // factor: 8448545626348461343
  { 301743037, 62, 14004320588ULL },   // factor: 8451412450689491513
  { 300060373, 62, 14089749851ULL },   // factor: 8455551191535508847
  { 301922209, 62, 14026252307ULL },   // factor: 8469674161041572327
  { 301339393, 62, 14054096847ULL },   // factor: 8470106026076387743
  { 300130163, 62, 14113897777ULL },   // factor: 8472012880752695303
  { 300778057, 62, 14103564720ULL },   // factor: 8484085586510698081
  { 301429013, 62, 14097328327ULL },   // factor: 8498687527089102503
  { 301929869, 62, 14084917836ULL },   // factor: 8505314794198486969
  { 301260763, 62, 14122365120ULL },   // factor: 8509028982831573121
  { 301261111, 62, 14133527936ULL },   // factor: 8515764656697793793
  { 301618633, 62, 14141715792ULL },   // factor: 8530809970915104673
  { 301518821, 62, 14178040236ULL },   // factor: 8549891952098563513
  { 300898937, 62, 14210377747ULL },   // factor: 8551775116881509879
  { 300622177, 62, 14226567800ULL },   // factor: 8553643566548201201
  { 300150931, 62, 14255732976ULL },   // factor: 8557743049667601313
  { 300959123, 62, 14222418192ULL },   // factor: 8560733012007131233
  { 301367581, 62, 14220912696ULL },   // factor: 8571444117611416753
  { 300158167, 62, 14286679772ULL },   // factor: 8576527225758995849
  { 301481161, 62, 14235667275ULL },   // factor: 8583570995353412551
  { 301444639, 62, 14240088701ULL },   // factor: 8585196795601847879
  { 300182929, 62, 14310393056ULL },   // factor: 8591471405382682049
  { 301350067, 62, 14275193220ULL },   // factor: 8603660866569891481
  { 300109783, 62, 14354413268ULL },   // factor: 8615799701903601689
  { 301067801, 62, 14323174384ULL },   // factor: 8624493230260819169
  { 300316703, 62, 14372337328ULL },   // factor: 8632505921497579169
  { 300631027, 62, 14387725865ULL },   // factor: 8650793605978826711
  { 300074323, 62, 14432100437ULL },   // factor: 8661405536201558303
  { 300159127, 62, 14431281617ULL },   // factor: 8663361783299736719
  { 300072893, 62, 14440348960ULL },   // factor: 8666314576713482561
  { 301859329, 62, 14375050295ULL },   // factor: 8678486072779904111
  { 300504143, 62, 14450853948ULL },   // factor: 8685082962523813129
  { 301227613, 62, 14444215800ULL },   // factor: 8701993294181770801
  { 301261621, 62, 14458274756ULL },   // factor: 8711446579711878953
  { 301326217, 62, 14457376559ULL },   // factor: 8712773172535894607
  { 301277507, 62, 14467413592ULL },   // factor: 8717412599471350289
  { 301809913, 62, 14446377843ULL },   // factor: 8720120079921915319
  { 300210817, 62, 14531339348ULL },   // factor: 8724930515534654633
  { 301123441, 62, 14492401919ULL },   // factor: 8728003868408566559
  { 301141847, 62, 14492037208ULL },   // factor: 8728317703219686353
  { 300081377, 62, 14614712407ULL },   // factor: 8771206047103088879
  { 300687371, 62, 14600476621ULL },   // factor: 8780357861030906783
  { 301299023, 62, 14575489488ULL },   // factor: 8783161484962340449
  { 300901313, 62, 14596178352ULL },   // factor: 8784018461797952353
  { 301076827, 62, 14635757552ULL },   // factor: 8812974888994895009
  { 301933519, 62, 14597441481ULL },   // factor: 8814913749509803279
  { 301018243, 62, 14647548720ULL },   // factor: 8818358759902597921
  { 300493733, 62, 14687758831ULL },   // factor: 8827158961061812247
  { 301797523, 62, 14625561305ULL },   // factor: 8827916348667295031
  { 300307321, 62, 14710600859ULL },   // factor: 8835402268533177479
  { 301213663, 62, 14682710228ULL },   // factor: 8845265861086890329
  { 300070217, 62, 14752004232ULL },   // factor: 8853274222162316689
  { 300019019, 62, 14848040032ULL },   // factor: 8909388808946737217
  { 300268681, 62, 14879954711ULL },   // factor: 8935968748823412383
  { 301868551, 62, 14803346505ULL },   // factor: 8937329518830528511
  { 300949927, 62, 14854254089ULL },   // factor: 8940773367448003007
  { 300565789, 62, 14917737255ULL },   // factor: 8967522936287538391
  { 300956347, 62, 14926211193ULL },   // factor: 8984275990391583943
  { 300361057, 62, 14980822035ULL },   // factor: 8999311082322981991
  { 301143839, 62, 14948123640ULL },   // factor: 9003070677592507921
  { 300755327, 62, 15011717553ULL },   // factor: 9029708042968309663
  { 300907417, 62, 15048122700ULL },   // factor: 9056183464712131801
  { 301791577, 62, 15006078660ULL },   // factor: 9057416286774893641
  { 300403067, 62, 15090699592ULL },   // factor: 9066584881224897329
  { 301088803, 62, 15065006256ULL },   // factor: 9071809401613103137
  { 301002059, 62, 15074387584ULL },   // factor: 9074843401896070913
  { 300855349, 62, 15104632280ULL },   // factor: 9088618832232131441
  { 300063997, 62, 15147549228ULL },   // factor: 9090468332215888633
  { 300850259, 62, 15112105297ULL },   // factor: 9092961585275443847
  { 300878687, 62, 15127643604ULL },   // factor: 9103171089950935897
  { 300249967, 62, 15161664893ULL },   // factor: 9104578767576617063
  { 301104403, 62, 15130097001ULL },   // factor: 9111477649636390807
  { 300877517, 62, 15148605472ULL },   // factor: 9115749600855946049
  { 300054493, 62, 15198361908ULL },   // factor: 9120673553470905289
  { 301947211, 62, 15122221980ULL },   // factor: 9132225501967795561
  { 301265749, 62, 15170709887ULL },   // factor: 9140830553937520727
  { 300749489, 62, 15217282540ULL },   // factor: 9153179895747244121
  { 300206827, 62, 15248837532ULL },   // factor: 9155610261840461929
  { 300417437, 62, 15241666707ULL },   // factor: 9157724895450339919
  { 301905493, 62, 15192490247ULL },   // factor: 9173392515836453543
  { 300307003, 62, 15288199565ULL },   // factor: 9182306785262107391
  { 300772061, 62, 15270485884ULL },   // factor: 9185871023604173849
  { 301113091, 62, 15268952049ULL },   // factor: 9195362695610346919
  { 300336329, 62, 15310591207ULL },   // factor: 9196653515860118207
  { 300460933, 62, 15313784100ULL },   // factor: 9202387716893130601
  { 300593539, 62, 15335834036ULL },   // factor: 9219705252795786809
  { 301151959, 63, 15313590557ULL },   // factor: 9223435591128902327
  { 300261461, 63, 15362841951ULL },   // factor: 9225738738638700823
  { 301719919, 63, 15294182229ULL },   // factor: 9229118846610238903
  { 301859581, 63, 15300730700ULL },   // factor: 9237344316191673401
  { 300255401, 63, 15390389515ULL },   // factor: 9242095150745041031
  { 300310301, 63, 15400734699ULL },   // factor: 9249998546155668799
  { 301593463, 63, 15371108625ULL },   // factor: 9271651760725836751
  { 300907687, 63, 15409828628ULL },   // factor: 9273871779035726873
  { 301380241, 63, 15394691396ULL },   // factor: 9279311606094212873
  { 300479477, 63, 15447324324ULL },   // factor: 9283207867849797097
  { 301910569, 63, 15391740699ULL },   // factor: 9293858384671095463
  { 300585767, 63, 15460355077ULL },   // factor: 9294325377824778119
  { 301705669, 63, 15408388547ULL },   // factor: 9297596349569145887
  { 300133297, 63, 15518150228ULL },   // factor: 9315027182541883433
  { 301807003, 63, 15434471681ULL },   // factor: 9316463281861964087
  { 301352903, 63, 15473978617ULL },   // factor: 9326256754385750303
  { 300937187, 63, 15504994888ULL },   // factor: 9332059092088200113
  { 301178597, 63, 15497270755ULL },   // factor: 9334892526640061471
  { 300749299, 63, 15521099577ULL },   // factor: 9335919634983893047
  { 300828947, 63, 15555289629ULL },   // factor: 9358962798744181327
  { 300355441, 63, 15587379504ULL },   // factor: 9363508489916562529
  { 300048643, 63, 15614543220ULL },   // factor: 9370245008451700921
  { 300938551, 63, 15573073629ULL },   // factor: 9373076425055143159
  { 300522361, 63, 15600502935ULL },   // factor: 9376599949627259071
  { 301839269, 63, 15545521275ULL },   // factor: 9384497555739895951
  { 301866113, 63, 15555874911ULL },   // factor: 9391582987395581887
  { 301555567, 63, 15577029705ULL },   // factor: 9394680049734235471
  { 301429087, 63, 15594228185ULL },   // factor: 9401107928548434191
  { 301474211, 63, 15610744800ULL },   // factor: 9412473943404705601
  { 301305661, 63, 15633487904ULL },   // factor: 9420916813300449089
  { 300859721, 63, 15659126895ULL },   // factor: 9422401097466592591
  { 301079587, 63, 15654690849ULL },   // factor: 9426615710859198727
  { 300673739, 63, 15701519761ULL },   // factor: 9442069309044512759
  { 301733083, 63, 15681610812ULL },   // factor: 9463321553421786793
  { 300896203, 63, 15738540641ULL },   // factor: 9471334239276172247
  { 300919519, 63, 15739582740ULL },   // factor: 9472695334763004121
  { 300741127, 63, 15754638372ULL },   // factor: 9476135398945450489
  { 301045051, 63, 15739981344ULL },   // factor: 9476886972887057089
  { 301911611, 63, 15704555616ULL },   // factor: 9482775372131314753
  { 301960019, 63, 15701490292ULL },   // factor: 9482444613801271097
  { 301398551, 63, 15740077993ULL },   // factor: 9488073399434376287
  { 301672373, 63, 15728527728ULL },   // factor: 9489724567004117089
  { 301175477, 63, 15757363804ULL },   // factor: 9491463119864469017
  { 301637177, 63, 15749158363ULL },   // factor: 9501063337482522503
  { 300598073, 63, 15811984996ULL },   // factor: 9506104440205025417
  { 301914901, 63, 15754033496ULL },   // factor: 9512754926591047793
  { 301052827, 63, 15808510572ULL },   // factor: 9518393596719974089
  { 300485377, 63, 15860040723ULL },   // factor: 9531420631772015143
  { 300138721, 63, 15891210348ULL },   // factor: 9539135097981369817
  { 301159213, 63, 15863331288ULL },   // factor: 9554776732504712689
  { 301520201, 63, 15849431223ULL },   // factor: 9557847376189271647
  { 301183621, 63, 15891232623ULL },   // factor: 9572357967096935767
  { 301233269, 63, 15894231427ULL },   // factor: 9575742581995489727
  { 300606331, 63, 15938564120ULL },   // factor: 9582466563042887441
  { 301369261, 63, 15910650536ULL },   // factor: 9589961988127147793
  { 301823623, 63, 15900514296ULL },   // factor: 9598301664764028817
  { 300104153, 63, 15993042915ULL },   // factor: 9599157195797451991
  { 300777121, 63, 15991031571ULL },   // factor: 9619472875490974183
  { 300928681, 63, 15983831048ULL },   // factor: 9619986389202975377
  { 301528219, 63, 15956870600ULL },   // factor: 9622893545662922801
  { 301066453, 63, 15983551863ULL },   // factor: 9624222531469903879
  { 300988507, 63, 16003442517ULL },   // factor: 9633704540104304239
  { 301087651, 63, 15999305081ULL },   // factor: 9634386368941309463
  { 300631181, 63, 16049029216ULL },   // factor: 9649677214219168193
  { 301563523, 63, 16012045496ULL },   // factor: 9657297700420084817
  { 301563121, 63, 16015425623ULL },   // factor: 9659323470030498767
  { 301117007, 63, 16083386497ULL },   // factor: 9685962408801708959
  { 300430061, 63, 16136157891ULL },   // factor: 9695573798997522703
  { 300535507, 63, 16138316948ULL },   // factor: 9700274532187745273
  { 301405829, 63, 16095381796ULL },   // factor: 9702483786589777769
  { 301718477, 63, 16111803640ULL },   // factor: 9722457711967712561
  { 301880851, 63, 16118763404ULL },   // factor: 9731892026934353609
  { 301985609, 63, 16113233719ULL },   // factor: 9731929395183099743
  { 301017923, 63, 16169472001ULL },   // factor: 9734601755495347847
  { 301674869, 63, 16137379387ULL },   // factor: 9736483625153050607
  { 300985873, 63, 16188199316ULL },   // factor: 9744838606848525737
  { 300111913, 63, 16249063488ULL },   // factor: 9753075055684265089
  { 300097937, 63, 16256187912ULL },   // factor: 9756896911751075089
  { 300751387, 63, 16220114625ULL },   // factor: 9756443941535469751
  { 300352861, 63, 16243454159ULL },   // factor: 9757535858355997799
  { 301919939, 63, 16180912284ULL },   // factor: 9770680099499261353
  { 301265821, 63, 16217408483ULL },   // factor: 9771501762246719087
  { 301269247, 63, 16221295617ULL },   // factor: 9773955031795980799
  { 300660053, 63, 16259661831ULL },   // factor: 9777261575741074087
  { 301538243, 63, 16253627221ULL },   // factor: 9802180389194625407
  { 300502141, 63, 16313358191ULL },   // factor: 9804398126590773863
  { 300200287, 63, 16340063048ULL },   // factor: 9810583233215389553
  { 300664561, 63, 16346599763ULL },   // factor: 9829686483170198087
  { 300902087, 63, 16352587564ULL },   // factor: 9841055451715692137
  { 300963931, 63, 16349025144ULL },   // factor: 9840933750712162129
  { 301441249, 63, 16356265115ULL },   // factor: 9860905970481457271
  { 300670163, 63, 16405774356ULL },   // factor: 9865453699519480057
  { 300814763, 63, 16406099953ULL },   // factor: 9870394138232012279
  { 301981067, 63, 16358541888ULL },   // factor: 9879939867804868993
  { 301062613, 63, 16416322700ULL },   // factor: 9884682015826430201
  { 301809187, 63, 16377726849ULL },   // factor: 9885896850409523527
  { 300936511, 63, 16441763085ULL },   // factor: 9895853634976992871
  { 301465949, 63, 16413398967ULL },   // factor: 9896161791804549367
  { 301522021, 63, 16430756195ULL },   // factor: 9908469628949340191
  { 300105317, 63, 16520681763ULL },   // factor: 9915888875082467743
  { 301761301, 63, 16446410948ULL },   // factor: 9925780728898246697
  { 300848281, 63, 16510472163ULL },   // factor: 9934294337473803607
  { 301434109, 63, 16517265191ULL },   // factor: 9957734231931599639
  { 300078673, 63, 16631813963ULL },   // factor: 9981705327199822199
  { 301665653, 63, 16565080567ULL },   // factor: 9994231692483330503
  { 300606169, 63, 16633583115ULL },   // factor: 10000315393886472871
  { 301264001, 63, 16601812764ULL },   // factor: 10003057074271017529
  { 300766793, 63, 16678468260ULL },   // factor: 10032658821424980361
  { 301363423, 63, 16648583285ULL },   // factor: 10034548093736369111
  { 301804469, 63, 16633328020ULL },   // factor: 10040025461557842761
  { 301575853, 63, 16668023771ULL },   // factor: 10053346973127203327
  { 301307003, 63, 16700958988ULL },   // factor: 10064231799800385929
  { 301636943, 63, 16688648256ULL },   // factor: 10067825685484242817
  { 300430217, 63, 16772647800ULL },   // factor: 10078020436437145201
  { 300886189, 63, 16802313404ULL },   // factor: 10111168093026354713
  { 301827629, 63, 16791431020ULL },   // factor: 10136235624567303161
  { 300542159, 63, 16867961536ULL },   // factor: 10139067155916792449
  { 300320719, 63, 16884569841ULL },   // factor: 10141572309309671359
  { 300830051, 63, 16886541121ULL },   // factor: 10159958053288054343
  { 301026611, 63, 16882292940ULL },   // factor: 10164038859274852681
  { 300963433, 63, 16907639112ULL },   // factor: 10177162222145182993
  { 300897593, 63, 16919906020ULL },   // factor: 10182317990408419721
  { 300038551, 63, 16969110204ULL },   // factor: 10182774474734948809
  { 300258383, 63, 16975046845ULL },   // factor: 10193800234057903271
  { 300569587, 63, 16996330193ULL },   // factor: 10217159893251280583
  { 300911629, 63, 17002495016ULL },   // factor: 10232496944657882129
  { 300484729, 63, 17028391151ULL },   // factor: 10233543000628466159
  { 301721267, 63, 16995706312ULL },   // factor: 10255932084033074609
  { 301845407, 63, 17004573820ULL },   // factor: 10265505011118889481
  { 300628333, 63, 17129033592ULL },   // factor: 10298945629327924273
  { 300873119, 63, 17115556140ULL },   // factor: 10299221518522801321
  { 301222387, 63, 17112026345ULL },   // factor: 10309050844095571031
  { 301868191, 63, 17085323028ULL },   // factor: 10315031110226004697
  { 300457627, 63, 17179838213ULL },   // factor: 10323626843443801103
  { 301109909, 63, 17168050692ULL },   // factor: 10338940363151014057
  { 301381261, 63, 17151861723ULL },   // factor: 10338499429150745407
  { 300181447, 63, 17240833580ULL },   // factor: 10350756743061180521
  { 300055597, 63, 17272214688ULL },   // factor: 10365249379440017473
  { 301880317, 63, 17194297163ULL },   // factor: 10381239756317281343
  { 300996503, 63, 17245725633ULL },   // factor: 10381806214460922799
  { 301856627, 63, 17202039712ULL },   // factor: 10385099369968742849
  { 300619129, 63, 17284260876ULL },   // factor: 10391958899903794009
  { 301672919, 63, 17230076044ULL },   // factor: 10395694669570904873
  { 301323889, 63, 17254393296ULL },   // factor: 10398321780572496289
  { 301987859, 63, 17223183885ULL },   // factor: 10402384853188904431
  { 300400733, 63, 17340371683ULL },   // factor: 10418120728131287279
  { 300146597, 63, 17370324643ULL },   // factor: 10427287660763379743
  { 300521791, 63, 17352039044ULL },   // factor: 10429331702009615609
  { 300797501, 63, 17336464119ULL },   // factor: 10429530166342733239
  { 301105447, 63, 17421251697ULL },   // factor: 10491267559049387119
  { 301939063, 63, 17376904193ULL },   // factor: 10493532339750382319
  { 301542877, 63, 17401161315ULL },   // factor: 10494392492132406511
  { 301655671, 63, 17428579553ULL },   // factor: 10514859719274190127
  { 300692257, 63, 17488031999ULL },   // factor: 10517031624535063487
  { 301258249, 63, 17462231024ULL },   // factor: 10521282283847433953
  { 300507833, 63, 17510360371ULL },   // factor: 10524000900276572087
  { 300940517, 63, 17500477563ULL },   // factor: 10533205531112240143
  { 300921989, 63, 17520248211ULL },   // factor: 10544455878855623359
  { 301281289, 63, 17500542080ULL },   // factor: 10545171752122282241
  { 300254957, 63, 17566364764ULL },   // factor: 10548776193722270297
  { 300455381, 63, 17560441164ULL },   // factor: 10552258080915406969
  { 301451797, 63, 17508164667ULL },   // factor: 10555735402078113199
  { 301705951, 63, 17498330361ULL },   // factor: 10558700804955356623
  { 301175659, 63, 17531907965ULL },   // factor: 10560367869772447871
  { 301246879, 63, 17550289589ULL },   // factor: 10573939928464885463
  { 300292723, 63, 17621829857ULL },   // factor: 10583414544002461223
  { 301738859, 63, 17546992369ULL },   // factor: 10589218912607533943
  { 300903049, 63, 17603968212ULL },   // factor: 10594175418979756777
  { 301483723, 63, 17598835121ULL },   // factor: 10611524665484470967
  { 301780111, 63, 17585741813ULL },   // factor: 10614054232688962487
  { 300874027, 63, 17650372545ULL },   // factor: 10621077331328777431
  { 300012313, 63, 17738548872ULL },   // factor: 10643566152704521873
  { 300070633, 63, 17735035536ULL },   // factor: 10643526679130028577
  { 300433631, 63, 17721004161ULL },   // factor: 10647971250110677183
  { 300887329, 63, 17696484831ULL },   // factor: 10649296106977212799
  { 301931393, 63, 17642208532ULL },   // factor: 10653473195326490153
  { 301804039, 63, 17656922645ULL },   // factor: 10657861141143126311
  { 301321711, 63, 17687147045ULL },   // factor: 10659042820615987991
  { 300344441, 63, 17796860368ULL },   // factor: 10690376157564028577
  { 301324789, 63, 17741257340ULL },   // factor: 10691761249140402521
  { 301118299, 63, 17787115472ULL },   // factor: 10712051910090444257
  { 301019399, 63, 17815268101ULL },   // factor: 10725482593573782599
  { 301589773, 63, 17794851692ULL },   // factor: 10733490564717891833
  { 300434087, 63, 17866322092ULL },   // factor: 10735304331515900009
  { 300035201, 63, 17890865724ULL },   // factor: 10735778987128701049
  { 300246343, 63, 17878253681ULL },   // factor: 10735760573893077167
  { 300152497, 63, 17884981799ULL },   // factor: 10736443891538804207
  { 301751627, 63, 17800248025ULL },   // factor: 10742507605094573351
  { 300024187, 63, 17919986264ULL },   // factor: 10752858619815534737
  { 300741733, 63, 17887823748ULL },   // factor: 10759230227144150569
  { 301963867, 63, 17822542772ULL },   // factor: 10763527870412038649
  { 301376129, 63, 17908099431ULL },   // factor: 10794147368523765199
  { 301097777, 63, 17966866344ULL },   // factor: 10819567031669034577
  { 301655197, 63, 18041872124ULL },   // factor: 10884848979628056857
  { 300985759, 63, 18104650497ULL },   // factor: 10898483942538544447
  { 301376557, 63, 18089826392ULL },   // factor: 10903699189497384689
  { 301223123, 63, 18116143660ULL },   // factor: 10914002739963700361
  { 300651047, 63, 18164534685ULL },   // factor: 10922372742626130391
  { 301179623, 63, 18142647556ULL },   // factor: 10928391502275902777
  { 300051991, 63, 18220700549ULL },   // factor: 10934314954284486119
  { 301562953, 63, 18193997855ULL },   // factor: 10973271440058931631
  { 300509579, 63, 18314711989ULL },   // factor: 11007492778641285263
  { 300225829, 63, 18334458659ULL },   // factor: 11008956100329006623
  { 301764629, 63, 18259864536ULL },   // factor: 11020362494592594289
  { 301623319, 63, 18289022892ULL },   // factor: 11032791571904037097
  { 300674083, 63, 18348835785ULL },   // factor: 11034038747544920311
  { 301290413, 63, 18325833535ULL },   // factor: 11042795908658799911
  { 301060381, 63, 18351346688ULL },   // factor: 11049726851504736257
  { 301100237, 63, 18404706528ULL },   // factor: 11083322994992494273
  { 300009109, 63, 18478665735ULL },   // factor: 11087536085332360231
  { 300194771, 63, 18492345193ULL },   // factor: 11102610660931171607
  { 301793357, 63, 18432287688ULL },   // factor: 11125483957102577233
  { 301083283, 63, 18497892908ULL },   // factor: 11138812650646113929
  { 301494227, 63, 18493232305ULL },   // factor: 11151205557054806471
  { 300451373, 63, 18576407652ULL },   // factor: 11162614368902212393
  { 301847551, 63, 18517168424ULL },   // factor: 11178723880477859249
  { 300233707, 63, 18621968625ULL },   // factor: 11181885343842885751
  { 301846409, 63, 18524020536ULL },   // factor: 11182818158067710449
  { 300001543, 63, 18640378061ULL },   // factor: 11184284360806696247
  { 301806413, 63, 18539287443ULL },   // factor: 11190551685495543919
  { 300187471, 63, 18661956968ULL },   // factor: 11204171332269495857
  { 300793943, 63, 18624368545ULL },   // factor: 11204194501071445871
  { 300678907, 63, 18645725504ULL },   // factor: 11212752729529488257
  { 300685457, 63, 18648543259ULL },   // factor: 11214691504433368727
  { 300250109, 63, 18676879884ULL },   // factor: 11215470441901814713
  { 301619693, 63, 18591951231ULL },   // factor: 11215397245130384167
  { 300077699, 63, 18698610676ULL },   // factor: 11222072132301829049
  { 301749377, 63, 18613949112ULL },   // factor: 11233495096111406449
  { 301549187, 63, 18639969229ULL },   // factor: 11241735133419933647
  { 301361867, 63, 18681589857ULL },   // factor: 11259837595667566039
  { 301939663, 63, 18681130200ULL },   // factor: 11281148314094245201
  { 300845599, 63, 18753257856ULL },   // factor: 11283670185779551489
  { 300783361, 63, 18764781759ULL },   // factor: 11288268251807023999
  { 301869389, 63, 18733366195ULL },   // factor: 11310059614395809711
  { 300026219, 63, 18875296545ULL },   // factor: 11326167709800226711
  { 301592693, 63, 18821914608ULL },   // factor: 11353103828085518689
  { 300566537, 63, 18896273572ULL },   // factor: 11359175019481320329
  { 301520311, 63, 18847523960ULL },   // factor: 11365822571998303121
  { 300783143, 63, 18906771121ULL },   // factor: 11373676083512026607
  { 301034441, 63, 18902556300ULL },   // factor: 11380640938483056601
  { 301097729, 63, 18916915695ULL },   // factor: 11391680710897913311
  { 300223753, 63, 19005138167ULL },   // factor: 11411587813560561503
  { 300675547, 63, 19015511880ULL },   // factor: 11434998872007996721
  { 300975413, 63, 19001301103ULL },   // factor: 11437848894025561079
  { 300680741, 63, 19027962919ULL },   // factor: 11442683980410885959
  { 301810349, 63, 18966954012ULL },   // factor: 11448846019657340377
  { 300850943, 63, 19041599185ULL },   // factor: 11457366142070562911
  { 301000067, 63, 19034073528ULL },   // factor: 11458514814421852753
  { 301359631, 63, 19050171489ULL },   // factor: 11481905300823521119
  { 300686279, 63, 19106991832ULL },   // factor: 11490420553694946257
  { 300972767, 63, 19108382640ULL },   // factor: 11502205592111129761
  { 301982777, 63, 19073869995ULL },   // factor: 11519960458454152231
  { 301169699, 63, 19132547040ULL },   // factor: 11524286866280281921
  { 301027919, 63, 19148319580ULL },   // factor: 11528357591028708041
  { 301181627, 63, 19228663488ULL },   // factor: 11582640308702669953
  { 301733689, 63, 19310647860ULL },   // factor: 11653346031555511081
  { 301906169, 63, 19325813487ULL },   // factor: 11669164625337402607
  { 300170041, 63, 19442284431ULL },   // factor: 11671982629573863343
  { 301196153, 63, 19379126880ULL },   // factor: 11673836929509785281
  { 300661969, 63, 19435937991ULL },   // factor: 11687294771471928559
  { 301179937, 63, 19429026612ULL },   // factor: 11703266021946966889
  { 301387693, 63, 19438696707ULL },   // factor: 11717167910898853903
  { 300352523, 63, 19567070692ULL },   // factor: 11754038100123111833
  { 300203507, 63, 19579115632ULL },   // factor: 11755438353369842849
  { 300877051, 63, 19544745488ULL },   // factor: 11761130769949991777
  { 300716947, 63, 19563054848ULL },   // factor: 11765884255768218113
  { 300792307, 63, 19591528784ULL },   // factor: 11785962281192529377
  { 300858913, 63, 19610113956ULL },   // factor: 11799755137216579657
  { 301758881, 63, 19609851244ULL },   // factor: 11834893535931795929
  { 300547349, 63, 19693887120ULL },   // factor: 11837891130842489761
  { 301327709, 63, 19667595124ULL },   // factor: 11852782760508981833
  { 300927299, 63, 19701460716ULL },   // factor: 11857414719240972169
  { 300163657, 63, 19756784760ULL },   // factor: 11860537528246934641
  { 300818839, 63, 19733645640ULL },   // factor: 11872504741324423921
  { 301997261, 63, 19656938848ULL },   // factor: 11872683383480990657
  { 301688599, 63, 19685893229ULL },   // factor: 11878019096641192343
  { 300150769, 63, 19797026055ULL },   // factor: 11884185188642572591
  { 301761113, 63, 19696281772ULL },   // factor: 11887143818960664473
  { 300172801, 63, 19824080144ULL },   // factor: 11901299328145926689
  { 300831211, 63, 19782329753ULL },   // factor: 11902284431992641767
  { 301196107, 63, 19761701985ULL },   // factor: 11904295411152344791
  { 301729963, 63, 19747649261ULL },   // factor: 11916914961717014687
  { 301600993, 63, 19762447796ULL },   // factor: 11920747758768522857
  { 300559367, 63, 19922003848ULL },   // factor: 11975489731852888433
  { 300525829, 63, 19936277967ULL },   // factor: 11982732926414219287
  { 300400049, 63, 19973916471ULL },   // factor: 12000330973220614159
  { 301308989, 63, 19947952432ULL },   // factor: 12020994759812022497
  { 300194941, 63, 20042481515ULL },   // factor: 12033303111778031231
  { 300205369, 63, 20058565604ULL },   // factor: 12043378177519055753
  { 301197907, 63, 19993627485ULL },   // factor: 12044077503639347791
  { 300944297, 63, 20021810767ULL },   // factor: 12050899531883691599
  { 300109913, 63, 20080220872ULL },   // factor: 12052546677833408273
  { 300443569, 63, 20114921511ULL },   // factor: 12086797617839425519
  { 300273761, 63, 20144456671ULL },   // factor: 12097703535805419263
  { 301251343, 63, 20103943757ULL },   // factor: 12112680112785431303
  { 301538249, 63, 20090649312ULL },   // factor: 12116198429627069377
  { 300564541, 63, 20165224488ULL },   // factor: 12121902884795360017
  { 300114901, 63, 20229854024ULL },   // factor: 12142561275314423249
  { 301122407, 63, 20168261772ULL },   // factor: 12146231059581450409
  { 300917213, 63, 20191346476ULL },   // factor: 12151847416550582777
  { 301164091, 63, 20218537433ULL },   // factor: 12178194894717836807
  { 301864921, 63, 20173317063ULL },   // factor: 12179233523060894047
  { 300280553, 63, 20316083992ULL },   // factor: 12201049871824415153
  { 300532763, 63, 20309939305ULL },   // factor: 12207604351387899431
  { 301316413, 63, 20266531043ULL },   // factor: 12213276875659817519
  { 301897081, 63, 20312505623ULL },   // factor: 12264572310759572927
  { 300200753, 63, 20437031887ULL },   // factor: 12270424723124821823
  { 300819941, 63, 20408027284ULL },   // factor: 12278283126998540489
  { 300703993, 63, 20449503648ULL },   // factor: 12298494803643332929
  { 301370963, 63, 20407924456ULL },   // factor: 12300711692271942257
  { 301659103, 63, 20438750813ULL },   // factor: 12331070473380201479
  { 301973207, 63, 20444829604ULL },   // factor: 12347581524176840057
  { 301522601, 63, 20532565248ULL },   // factor: 12382064957558340097
  { 301532291, 63, 20547443673ULL },   // factor: 12391435529826289687
  { 300248057, 63, 20637328579ULL },   // factor: 12392635615030642007
  { 300907681, 63, 20625511400ULL },   // factor: 12412749609626126801
  { 301918541, 63, 20565950584ULL },   // factor: 12418483589198755889
  { 300317683, 63, 20694801128ULL },   // factor: 12430029449813492849
  { 301447171, 63, 20621947776ULL },   // factor: 12432855635169883393
  { 300505819, 63, 20703976941ULL },   // factor: 12443331094424639359
  { 301972579, 63, 20616408764ULL },   // factor: 12451180248366564713
  { 301515733, 63, 20678764547ULL },   // factor: 12469945699846235903
  { 301676861, 63, 20671774224ULL },   // factor: 12472391918394061729
  { 300374773, 63, 20766342263ULL },   // factor: 12475370686577862599
  { 301666837, 63, 20686296060ULL },   // factor: 12480739003331524441
  { 300684619, 63, 20769879272ULL },   // factor: 12490366471154634737
  { 301107413, 63, 20785903020ULL },   // factor: 12517578970442174521
  { 301564579, 63, 20761705844ULL },   // factor: 12521990164335399353
  { 300078197, 63, 20869082839ULL },   // factor: 12524713502741522567
  { 300339671, 63, 20868741520ULL },   // factor: 12535421924601679841
  { 300618743, 63, 20870804952ULL },   // factor: 12548310300136830673
  { 300804883, 63, 20884758480ULL },   // factor: 12564474662119315681
  { 301167169, 63, 20867421527ULL },   // factor: 12569164531232494127
  { 301624861, 63, 20838718355ULL },   // factor: 12570951054490047311
  { 301574563, 63, 20877308297ULL },   // factor: 12592130252568098423
  { 300530323, 63, 20959455692ULL },   // factor: 12597903978041897033
  { 301439821, 63, 20936231115ULL },   // factor: 12622027519440460831
  { 301244371, 63, 20958640205ULL },   // factor: 12627344771141072111
  { 301065071, 63, 21028196920ULL },   // factor: 12661711197443562641
  { 301954823, 63, 20970637965ULL },   // factor: 12664370549837310391
  { 300569593, 63, 21094270800ULL },   // factor: 12680592777975568801
  { 300520309, 63, 21102970416ULL },   // factor: 12683742380468357089
  { 300774623, 63, 21127129828ULL },   // factor: 12709009018177509689
  { 300496073, 63, 21190137888ULL },   // factor: 12735106443345027649
  { 301449961, 63, 21154794336ULL },   // factor: 12754223855100441793
  { 301729733, 63, 21151362648ULL },   // factor: 12763990008734425969
  { 301451141, 63, 21190222660ULL },   // factor: 12775633597802110121
  { 301867859, 63, 21186485724ULL },   // factor: 12791038170475889833
  { 300447013, 63, 21308000847ULL },   // factor: 12803850414965240023
  { 301866337, 63, 21254454855ULL },   // factor: 12832008864021432271
  { 301266233, 63, 21299970792ULL },   // factor: 12833923927031733073
  { 301152097, 63, 21356449500ULL },   // factor: 12863079102799203001
  { 300226631, 63, 21456066625ULL },   // factor: 12883365194670580751
  { 300749677, 63, 21426948755ULL },   // factor: 12888295834323604271
  { 301164103, 63, 21428183100ULL },   // factor: 12906799084462518601
  { 301426291, 63, 21433666880ULL },   // factor: 12921341420335884161
  { 301170593, 63, 21461438280ULL },   // factor: 12927108186841000081
  { 300109793, 63, 21545986843ULL },   // factor: 12932323302866906999
  { 300398957, 63, 21537394360ULL },   // factor: 12939621604483365041
  { 301380479, 63, 21498627117ULL },   // factor: 12958533076727698087
  { 301730939, 63, 21480928701ULL },   // factor: 12962921575089560479
  { 301676057, 63, 21498364764ULL },   // factor: 12971083827902511097
  { 301004323, 63, 21593988500ULL },   // factor: 12999767778624571001
  { 301502083, 63, 21579628056ULL },   // factor: 13012605618498481297
  { 301486847, 63, 21619936845ULL },   // factor: 13036253183476355431
  { 300598303, 63, 21702138512ULL },   // factor: 13047252016356290273
  { 300775459, 63, 21792806789ULL },   // factor: 13109482929719582303
  { 300817133, 63, 21789903015ULL },   // factor: 13109552306640711991
  { 301568413, 63, 21738787476ULL },   // factor: 13111463279363191177
  { 301634269, 63, 21757741740ULL },   // factor: 13125761049671376121
  { 301010387, 63, 21816526873ULL },   // factor: 13134002394075259703
  { 301576369, 63, 21800420999ULL },   // factor: 13148983615099545263
  { 301815713, 63, 21787482468ULL },   // factor: 13151609111108839369
  { 301316203, 63, 21854338373ULL },   // factor: 13170132515259115439
  { 301985171, 63, 21805422388ULL },   // factor: 13169828417134816697
  { 301223831, 63, 21896833465ULL },   // factor: 13191696126192608831
  { 300254173, 63, 21996723615ULL },   // factor: 13209216115462790791
  { 301205573, 63, 21929703852ULL },   // factor: 13210698028923934393
  { 301106401, 63, 21941459219ULL },   // factor: 13213427636242721639
  { 300795959, 63, 21993412356ULL },   // factor: 13231059122610938809
  { 300235757, 63, 22047134755ULL },   // factor: 13238676385696869071
  { 301372571, 63, 21977970901ULL },   // factor: 13247115191595112943
  { 301025993, 63, 22030887655ULL },   // factor: 13263739666035632831
  { 300373057, 63, 22096912115ULL },   // factor: 13274634084485771111
  { 301309121, 63, 22028102500ULL },   // factor: 13274536403145805001
  { 300069487, 63, 22121103264ULL },   // factor: 13275736216605011137
  { 301385347, 63, 22034861873ULL },   // factor: 13281968983382349863
  { 300153019, 63, 22135153821ULL },   // factor: 13287866490805071199
  { 301998029, 63, 22003188924ULL },   // factor: 13289839373525261593
  { 300751271, 63, 22159247065ULL },   // factor: 13328843438403539231
  { 301728041, 63, 22098084843ULL },   // factor: 13335223699060365127
  { 300442561, 63, 22236168744ULL },   // factor: 13361382968551026769
  { 301491611, 63, 22159836645ULL },   // factor: 13362009699195770191
  { 300663247, 63, 22222548368ULL },   // factor: 13363007097874861793
  { 301737047, 63, 22147901533ULL },   // factor: 13365684811628386103
  { 301225139, 63, 22192509045ULL },   // factor: 13369883243677764511
  { 300177221, 63, 22277240028ULL },   // factor: 13374240006310004377
  { 300323203, 63, 22300447980ULL },   // factor: 13394683931376959881
  { 301769707, 63, 22206536133ULL },   // factor: 13402519804680646063
  { 301564927, 63, 22229962469ULL },   // factor: 13407554018353449527
  { 301448039, 63, 22301026500ULL },   // factor: 13445201412224067001
  { 300764339, 63, 22364134900ULL },   // factor: 13452668501010662201
  { 300372353, 63, 22397532423ULL },   // factor: 13455199030580602639
  { 300354851, 63, 22405029913ULL },   // factor: 13458918842339315927
  { 301142497, 63, 22361125472ULL },   // factor: 13467770320736767169
  { 300043111, 63, 22483833468ULL },   // factor: 13492238681889277897
  { 300903013, 63, 22429521696ULL },   // factor: 13498221316950540097
  { 300612223, 63, 22471271165ULL },   // factor: 13510277557092899591
  { 300281351, 63, 22528472676ULL },   // factor: 13529760422231730553
  { 301776281, 63, 22425926911ULL },   // factor: 13535225642358795983
  { 300913369, 63, 22500039087ULL },   // factor: 13541125128601708207
  { 300599333, 63, 22529964408ULL },   // factor: 13544984547117079729
  { 301582627, 63, 22460846877ULL },   // factor: 13547602411620811759
  { 300787457, 63, 22542162679ULL },   // factor: 13560799574993434607
  { 300485909, 63, 22583117616ULL },   // factor: 13571817249795345889
  { 301884301, 63, 22521656603ULL },   // factor: 13597869121917379007
  { 300143681, 63, 22661822391ULL },   // factor: 13603605581205922543
  { 300758599, 63, 22642301232ULL },   // factor: 13619733593344587937
  { 301844681, 63, 22581619743ULL },   // factor: 13632283615578273967
  { 300524803, 63, 22763758148ULL },   // factor: 13682147865934689689
  { 300871639, 63, 22748749176ULL },   // factor: 13688906899566038929
  { 300510521, 63, 22797339996ULL },   // factor: 13701681039224195833
  { 300567697, 63, 22803078639ULL },   // factor: 13707737662068248767
  { 301233887, 63, 22753870540ULL },   // factor: 13708473734117977961
  { 301081117, 63, 22844333303ULL },   // factor: 13755994775975078903
  { 301983589, 63, 22812185352ULL },   // factor: 13777811211060376657
  { 300652427, 63, 22934247448ULL },   // factor: 13790474313319512593
  { 301320281, 63, 22883399748ULL },   // factor: 13790464884605378377
  { 300644873, 63, 22967570140ULL },   // factor: 13810164415717784441
  { 301928287, 63, 22876834664ULL },   // factor: 13814327004167481137
  { 301010569, 63, 22947487755ULL },   // factor: 13814872692506165191
  { 301594169, 63, 22904973595ULL },   // factor: 13816012954701935111
  { 300896951, 63, 22973865445ULL },   // factor: 13825532130169516391
  { 301116209, 63, 22962630820ULL },   // factor: 13828840682369922761
  { 301705181, 63, 23060838523ULL },   // factor: 13915148921186975327
  { 300954949, 63, 23135509767ULL },   // factor: 13925492324032973767
  { 300032023, 63, 23249476101ULL },   // factor: 13951174696546364647
  { 301261453, 63, 23180957988ULL },   // factor: 13967058170793673129
  { 300143161, 63, 23276554424ULL },   // factor: 13972597244015788529
  { 301687847, 63, 23161661185ULL },   // factor: 13975183391692237391
  { 300614141, 63, 23272921876ULL },   // factor: 13992338836627697033
  { 301761217, 63, 23218926212ULL },   // factor: 14013142862332640009
  { 300017917, 63, 23384714015ULL },   // factor: 14031666376842013511
  { 301458827, 63, 23273423524ULL },   // factor: 14031957911638492697
  { 301522439, 63, 23277369897ULL },   // factor: 14037298689697237567
  { 301774981, 63, 23274226623ULL },   // factor: 14047158593891038327
  { 300040619, 63, 23461417284ULL },   // factor: 14078756329017317593
  { 300299071, 63, 23456123253ULL },   // factor: 14087704044274795927
  { 301352851, 63, 23387456709ULL },   // factor: 14095753513792454719
  { 300748387, 63, 23446361504ULL },   // factor: 14102910806693788097
  { 301969813, 63, 23384872955ULL },   // factor: 14123051426500214831
  { 300339019, 63, 23548256589ULL },   // factor: 14144920566201092383
  { 301157137, 63, 23520424163ULL },   // factor: 14166687203909402663
  { 301792093, 63, 23470874327ULL },   // factor: 14166648575370592823
  { 300543739, 63, 23570597681ULL },   // factor: 14167991115024938519
  { 300455963, 63, 23598339012ULL },   // factor: 14180523346101857113
  { 300246269, 63, 23671968067ULL },   // factor: 14214840184007784047
  { 301254479, 63, 23620519305ULL },   // factor: 14231574473874434191
  { 300167783, 63, 23739244521ULL },   // factor: 14251512795926933887
  { 300017953, 63, 23798075031ULL },   // factor: 14279699512282063087
  { 300096169, 63, 23797912011ULL },   // factor: 14283324449400371719
  { 300422893, 63, 23788773551ULL },   // factor: 14293384342226606087
  { 300178079, 63, 23816241016ULL },   // factor: 14298226954367776529
  { 300722473, 63, 23800624896ULL },   // factor: 14314765555340975617
  { 300070007, 63, 23906593948ULL },   // factor: 14347303626645035273
  { 301590787, 63, 23787263180ULL },   // factor: 14348038846064645321
  { 300924233, 63, 23852899303ULL },   // factor: 14355830855163019199
  { 300739693, 63, 23875666152ULL },   // factor: 14360721017445942673
  { 301176761, 63, 23850757896ULL },   // factor: 14366588021024909713
  { 300822503, 63, 23894727121ULL },   // factor: 14376143242082407727
  { 301251317, 63, 23880198319ULL },   // factor: 14387882387639872247
  { 301513169, 63, 23937397479ULL },   // factor: 14434881143011801903
  { 300429553, 63, 24078979563ULL },   // factor: 14468074133616450679
  { 300701497, 63, 24059614580ULL },   // factor: 14469524242898052521
  { 300252697, 63, 24098320484ULL },   // factor: 14471171436982690697
  { 301551191, 63, 24002610028ULL },   // factor: 14476031282103886697
  { 300369593, 63, 24128855232ULL },   // factor: 14495148851183521153
  { 300079601, 63, 24272640928ULL },   // factor: 14567448809781019457
  { 300650351, 63, 24226996408ULL },   // factor: 14567709947481878417
  { 301622693, 63, 24151746511ULL },   // factor: 14569429646602348247
  { 301539097, 63, 24184739355ULL },   // factor: 14585288932574124871
  { 300291031, 63, 24303493785ULL },   // factor: 14596242411199484671
  { 300641839, 63, 24289701321ULL },   // factor: 14605000947812338639
  { 301156741, 63, 24257736323ULL },   // factor: 14610761630144006687
  { 301046491, 63, 24316879580ULL },   // factor: 14641022539257107561
  { 301463977, 63, 24285855347ULL },   // factor: 14642621075506670039
  { 300539381, 63, 24441521568ULL },   // factor: 14691279525489738817
  { 300133703, 63, 24488881188ULL },   // factor: 14699877186562958329
  { 301178809, 63, 24410502167ULL },   // factor: 14703851939497958207
  { 301348147, 63, 24410029049ULL },   // factor: 14711834044264644407
  { 300289567, 63, 24497983748ULL },   // factor: 14712977864119914233
  { 300978911, 63, 24473752629ULL },   // factor: 14732166828719614039
  { 301073653, 63, 24484831943ULL },   // factor: 14743475592340195559
  { 300157439, 63, 24602315284ULL },   // factor: 14769135898231995353
  { 300159943, 63, 24624113460ULL },   // factor: 14782344985158265561
  { 301300247, 63, 24536930212ULL },   // factor: 14785966266994724729
  { 301399193, 63, 24536301760ULL },   // factor: 14790443099336959361
  { 300042019, 63, 24711031481ULL },   // factor: 14828695554263600279
  { 300879679, 63, 24646131176ULL },   // factor: 14831040073653545009
  { 300378439, 63, 24718497417ULL },   // factor: 14849807337087984127
  { 301999463, 63, 24620902780ULL },   // factor: 14870998836270414281
  { 300428773, 63, 24768949692ULL },   // factor: 14882610328932575833
  { 301373113, 63, 24700823516ULL },   // factor: 14888328153361050617
  { 300752747, 63, 24754119924ULL },   // factor: 14889739133420862457
  { 300168751, 63, 24814984989ULL },   // factor: 14897366100463757479
  { 301145161, 63, 24795955263ULL },   // factor: 14934363879649864687
  { 301430821, 63, 24783776376ULL },   // factor: 14941188120996169393
  { 300737929, 63, 24842008592ULL },   // factor: 14941868432316571937
  { 301708751, 63, 24763619776ULL },   // factor: 14942801585711719553
  { 301713053, 63, 24781098807ULL },   // factor: 14953561955509255543
  { 301079879, 63, 24867191076ULL },   // factor: 14974021760463919609
  { 301753189, 63, 24875624760ULL },   // factor: 15012598199394719281
  { 301952587, 63, 24864393933ULL },   // factor: 15015736144512909343
  { 300789809, 63, 24985812127ULL },   // factor: 15030955314780427487
  { 300838543, 63, 25022056557ULL },   // factor: 15055198074942952903
  { 300419003, 63, 25088314617ULL },   // factor: 15074012928378933703
  { 300907969, 63, 25047533864ULL },   // factor: 15074005086949924433
  { 301855943, 63, 24998062953ULL },   // factor: 15091627731702359359
  { 300508127, 63, 25127779644ULL },   // factor: 15102203992974333577
  { 301102033, 63, 25174520832ULL },   // factor: 15160198804632102913
  { 301379431, 63, 25154705985ULL },   // factor: 15162221953463189071
  { 300311813, 63, 25258760616ULL },   // factor: 15171008389447913617
  { 301212739, 63, 25184904396ULL },   // factor: 15172028069144601289
  { 301707883, 63, 25193953280ULL },   // factor: 15202428617019412481
  { 301889923, 63, 25189428833ULL },   // factor: 15208869461616699719
  { 300156799, 63, 25391584676ULL },   // factor: 15242913555771224249
  { 301323247, 63, 25304729372ULL },   // factor: 15249806437654621769
  { 301836103, 63, 25300151885ULL },   // factor: 15272998500553008311
  { 300433759, 63, 25424863497ULL },   // factor: 15276974624931190447
  { 301672337, 63, 25347545995ULL },   // factor: 15293306875053280631
  { 300733987, 63, 25469288045ULL },   // factor: 15318961079648570831
  { 300261967, 63, 25537316804ULL },   // factor: 15335769950942386937
  { 301887647, 63, 25408274889ULL },   // factor: 15340888641138792367
  { 300868973, 63, 25527959595ULL },   // factor: 15361141972266291871
  { 301878179, 63, 25445972325ULL },   // factor: 15363167576710792351
  { 301004069, 63, 25522722931ULL },   // factor: 15364886908381212479
  { 300102269, 63, 25610398455ULL },   // factor: 15371477372679188791
  { 301246717, 63, 25513689728ULL },   // factor: 15371830538233245953
  { 301426883, 63, 25525340073ULL },   // factor: 15388047391438764919
  { 300505861, 63, 25665836295ULL },   // factor: 15425468468228049991
  { 301654751, 63, 25591648561ULL },   // factor: 15439684748695926623
  { 301950197, 63, 25585866207ULL },   // factor: 15451314683238585559
  { 300608947, 63, 25864472057ULL },   // factor: 15550183419531387959
  { 301075837, 63, 25834506512ULL },   // factor: 15556291343164701089
  { 300303629, 63, 25937565724ULL },   // factor: 15578290228686424793
  { 300840283, 63, 25915442832ULL },   // factor: 15592818311298402913
  { 300261097, 63, 26003208644ULL },   // factor: 15615503905934644937
  { 300048443, 63, 26033454441ULL },   // factor: 15622594941866970727
  { 300574997, 63, 25992586059ULL },   // factor: 15625442953412333647
  { 300658321, 63, 25995672596ULL },   // factor: 15631630551958142633
  { 301687543, 63, 25925393205ULL },   // factor: 15642736354650690631
  { 300013717, 63, 26077439003ULL },   // factor: 15647178810261608303
  { 300182119, 63, 26080592576ULL },   // factor: 15657855088478697089
  { 300993643, 63, 26050419720ULL },   // factor: 15682021466403679921
  { 300077131, 63, 26146234773ULL },   // factor: 15691774234268552527
  { 300231401, 63, 26201606683ULL },   // factor: 15733090165776105767
  { 300990133, 63, 26144600463ULL },   // factor: 15738533541180463159
  { 301801481, 63, 26080984096ULL },   // factor: 15742559252220492353
  { 301990573, 63, 26065281923ULL },   // factor: 15742938846666623759
  { 300735527, 63, 26189789392ULL },   // factor: 15752400229644259169
  { 300851389, 63, 26271602415ULL },   // factor: 15807696155617008871
  { 301764241, 63, 26198353400ULL },   // factor: 15811452458401538801
  { 301986913, 63, 26190845235ULL },   // factor: 15818585002756819111
  { 301451377, 63, 26241124559ULL },   // factor: 15820846264678135487
  { 300606569, 63, 26327321179ULL },   // factor: 15828331381160449703
  { 300905807, 63, 26305442380ULL },   // factor: 15830920735691801321
  { 300187709, 63, 26403151960ULL },   // factor: 15851803394502519281
  { 300712441, 63, 26357846228ULL },   // factor: 15852264557449045097
  { 300488483, 63, 26379080172ULL },   // factor: 15853219567639318153
  { 301406797, 63, 26374941584ULL },   // factor: 15899173327791092897
  { 300776141, 63, 26462156364ULL },   // factor: 15918370547405022649
  { 300769333, 63, 26530139480ULL },   // factor: 15958904711593133681
  { 300561979, 63, 26550882957ULL },   // factor: 15960371851506583807
  { 301305827, 63, 26495447988ULL },   // factor: 15966465735519652153
  { 300000383, 63, 26664438237ULL },   // factor: 15998683367159689543
  { 301122103, 63, 26568147768ULL },   // factor: 16000513057429832209
  { 301498481, 63, 26598738363ULL },   // factor: 16038958425921853207
  { 301212013, 63, 26626951488ULL },   // factor: 16040715315507650689
  { 300822553, 63, 26695237020ULL },   // factor: 16061058706593024121
  { 301779103, 63, 26629092537ULL },   // factor: 16072207319039708623
  { 300214153, 63, 26789542388ULL },   // factor: 16085199554542034729
  { 301930813, 63, 26661092571ULL },   // factor: 16099610710860580447
  { 300588991, 63, 26788859033ULL },   // factor: 16104872213541411407
  { 300996107, 63, 26752290508ULL },   // factor: 16104670592482104713
  { 300018893, 63, 26873536632ULL },   // factor: 16125137422655176753
  { 300240067, 63, 26854806852ULL },   // factor: 16125778017033078169
  { 301088899, 63, 26790121952ULL },   // factor: 16132416645206821697
  { 301577321, 63, 26757632884ULL },   // factor: 16138990482916447529
  { 300010313, 63, 26959740451ULL },   // factor: 16176400342206542327
  { 300504199, 63, 26929705965ULL },   // factor: 16184979440635694071
  { 301909087, 63, 26852948040ULL },   // factor: 16214298052029678961
  { 301524407, 63, 26898080500ULL },   // factor: 16220855544401527001
  { 301018229, 63, 26964026791ULL },   // factor: 16233327182670746279
  { 300631759, 63, 27017188389ULL },   // factor: 16244449737238892503
  { 300910549, 63, 27000059631ULL },   // factor: 16249205533193894839
  { 301498597, 63, 26949009123ULL },   // factor: 16250176882249400863
  { 300085351, 63, 27104741109ULL },   // factor: 16267471498916788519
  { 300936479, 63, 27029394292ULL },   // factor: 16268261495474355737
  { 300003779, 63, 27152921041ULL },   // factor: 16291957846377227879
  { 300992297, 63, 27063285687ULL },   // factor: 16291681046594706079
  { 301186801, 63, 27093098495ULL },   // factor: 16320167329773928991
  { 301197727, 63, 27117528369ULL },   // factor: 16335475813201634527
  { 300450013, 63, 27271765848ULL },   // factor: 16387604807129112049
  { 300847489, 63, 27243731691ULL },   // factor: 16392416540454147799
  { 301175431, 63, 27231610488ULL },   // factor: 16402984051095040657
  { 301733921, 63, 27219577939ULL },   // factor: 16426139958999137639
  { 300298487, 63, 27379533064ULL },   // factor: 16444064707771348337
  { 300307621, 63, 27436955151ULL },   // factor: 16479053457761011543
  { 301231121, 63, 27363725508ULL },   // factor: 16485611419022268937
  { 300560149, 63, 27435734324ULL },   // factor: 16492176792691708553
  { 300843457, 63, 27433453760ULL },   // factor: 16506350133216096641
  { 301507441, 63, 27398833964ULL },   // factor: 16521904629739052249
  { 300506951, 63, 27496320121ULL },   // factor: 16525670646563322143
  { 301399289, 63, 27445490299ULL },   // factor: 16544102524749994823
  { 300092879, 63, 27580805769ULL },   // factor: 16553606816718037903
  { 301480121, 63, 27465594751ULL },   // factor: 16560661657736889743
  { 300847787, 63, 27527655093ULL },   // factor: 16563268232056658383
  { 301076551, 63, 27508678545ULL },   // factor: 16564436117792596591
  { 301418713, 63, 27494711403ULL },   // factor: 16574841050797368679
  { 300320093, 63, 27630621676ULL },   // factor: 16596061742768271737
  { 300792487, 63, 27625868993ULL },   // factor: 16619307679881311183
  { 301570553, 63, 27566775696ULL },   // factor: 16626655582139359777
  { 301972637, 63, 27556228848ULL },   // factor: 16642454182012064353
  { 300764873, 63, 27745292791ULL },   // factor: 16689618925265861087
  { 301849579, 63, 27651122720ULL },   // factor: 16692959503818669761
  { 300541127, 63, 27782251780ULL },   // factor: 16699418521117912121
  { 300766591, 63, 27776717589ULL },   // factor: 16708617316826538199
  { 301470209, 63, 27729229960ULL },   // factor: 16719073502900523281
  { 301951789, 63, 27684208512ULL },   // factor: 16718592574494855937
  { 300403013, 63, 27875737972ULL },   // factor: 16747911352774619273
  { 301620691, 63, 27774325280ULL },   // factor: 16754622366024736961
  { 300459503, 63, 27962957733ULL },   // factor: 16803472765734373399
  { 301949377, 63, 27858783320ULL },   // factor: 16823884534903983281
  { 301508569, 63, 27900590319ULL },   // factor: 16824534122673887023
  { 301112863, 63, 27940369916ULL },   // factor: 16826409557371659017
  { 300504901, 63, 28010437143ULL },   // factor: 16834547281247875687
  { 300897151, 63, 27990117249ULL },   // factor: 16844293072760115199
  { 300556829, 63, 28071693456ULL },   // factor: 16874278339590822049
  { 301201081, 63, 28020639600ULL },   // factor: 16879693875662815201
  { 300849259, 63, 28065468281ULL },   // factor: 16886950671653707559
  { 301841899, 63, 27971570801ULL },   // factor: 16885984097173582199
  { 301358567, 63, 28117480264ULL },   // factor: 16946887120019643377
  { 301668811, 63, 28162588268ULL },   // factor: 16991549034980218697
  { 301001821, 63, 28343193311ULL },   // factor: 17062705599132038663
  { 300861991, 63, 28386865400ULL },   // factor: 17081057684986022801
  { 301060153, 63, 28418833956ULL },   // factor: 17111556997749910537
  { 301643899, 63, 28363331132ULL },   // factor: 17111251582569127337
  { 300609107, 63, 28473442269ULL },   // factor: 17118752107400287567
  { 301501267, 63, 28427361977ULL },   // factor: 17141771307066249719
  { 300662611, 63, 28537136120ULL },   // factor: 17160099712603218641
  { 300385493, 63, 28565012731ULL },   // factor: 17161030863505422767
  { 301805687, 63, 28455577177ULL },   // factor: 17176110037772011199
  { 301190609, 63, 28516115691ULL },   // factor: 17177572502573491639
  { 301111273, 63, 28538884928ULL },   // factor: 17186759941341186689
  { 301122881, 63, 28589757051ULL },   // factor: 17218060020574367863
  { 301631063, 63, 28567465645ULL },   // factor: 17233670059434661271
  { 300886669, 63, 28653991176ULL },   // factor: 17243207917004065489
  { 301372361, 63, 28614880423ULL },   // factor: 17247468145624377407
  { 300481627, 63, 28705561652ULL },   // factor: 17250987738283535609
  { 300884557, 63, 28762072595ULL },   // factor: 17308126942296830831
  { 301499977, 63, 28713010160ULL },   // factor: 17313943805681532641
  { 301213399, 63, 28774437825ULL },   // factor: 17334492443164834351
  { 301700899, 63, 28734023097ULL },   // factor: 17338161200503328407
  { 301520371, 63, 28794821304ULL },   // factor: 17364450404921567569
  { 301938421, 63, 28756018496ULL },   // factor: 17365093637858069633
  { 301749919, 63, 28800348356ULL },   // factor: 17381005567189566329
  { 300490847, 63, 28931727609ULL },   // factor: 17387438668803389647
  { 301967933, 63, 28818065715ULL },   // factor: 17404263474033434191
  { 301942939, 63, 28910939852ULL },   // factor: 17458908296330210057
  { 301969483, 63, 28924978961ULL },   // factor: 17468921885278094327
  { 300475723, 63, 29129882637ULL },   // factor: 17505645092515443103
  { 300134249, 63, 29181686355ULL },   // factor: 17516847037422944791
  { 300657047, 63, 29132991724ULL },   // factor: 17518078524026558057
  { 301618609, 63, 29040119267ULL },   // factor: 17518080757013279207
  { 300883397, 63, 29166822444ULL },   // factor: 17551625233293124537
  { 300400097, 63, 29221839628ULL },   // factor: 17556486917539287833
  { 301633459, 63, 29103379412ULL },   // factor: 17557106001261892217
  { 300785887, 63, 29243176028ULL },   // factor: 17591869280558233673
  { 301942493, 63, 29161821411ULL },   // factor: 17610386114516235247
  { 300463313, 63, 29311719255ULL },   // factor: 17614192554166383631
  { 301504207, 63, 29272613592ULL },   // factor: 17651632295746763089
  { 301915829, 63, 29419019067ULL },   // factor: 17764135059960223087
  { 300604399, 63, 29564861565ULL },   // factor: 17774654884530048871
  { 300535441, 63, 29596373079ULL },   // factor: 17789518070595585679
  { 300034633, 63, 29662547600ULL },   // factor: 17799583166022061601
  { 301200437, 63, 29576267152ULL },   // factor: 17816769182022290849
  { 300551263, 63, 29656093932ULL },   // factor: 17826352973818472233
  { 300845357, 63, 29664037128ULL },   // factor: 17848575679668829393
  { 300489559, 63, 29730172185ULL },   // factor: 17867212657729432831
  { 301624363, 63, 29627677637ULL },   // factor: 17872858788858940463
  { 300501793, 63, 29809188248ULL },   // factor: 17915429032797057329
  { 300868679, 63, 29829451329ULL },   // factor: 17949495233302048783
  { 300325141, 63, 29934109448ULL },   // factor: 17979931281360064337
  { 300431917, 63, 29928984407ULL },   // factor: 17983244318516236439
  { 301790689, 63, 29820562544ULL },   // factor: 17999136233042705633
  { 300742003, 63, 29934182277ULL },   // factor: 18004931872304161663
  { 301035391, 63, 29912430749ULL },   // factor: 18009400572571275719
  { 301542151, 63, 29893253661ULL },   // factor: 18028152018653129623
  { 301690723, 63, 29894638632ULL },   // factor: 18037870285423621873
  { 301993781, 63, 29881689411ULL },   // factor: 18048168735791105983
  { 301519693, 63, 29936204208ULL },   // factor: 18052710204762936289
  { 300951787, 63, 30080550909ULL },   // factor: 18105591100016048767
  { 300404017, 63, 30169678592ULL },   // factor: 18126185281271408129
  { 300071677, 63, 30243248999ULL },   // factor: 18150284890117002647
  { 301801393, 63, 30070815492ULL },   // factor: 18150828008263160713
  { 301320367, 63, 30166609052ULL },   // factor: 18179627421388324169
  { 301479889, 63, 30177194180ULL },   // factor: 18195634303435692041
  { 301143299, 63, 30257422321ULL },   // factor: 18223639953964353959
  { 300713333, 63, 30386444235ULL },   // factor: 18275217847850970511
  { 301958821, 63, 30328219599ULL },   // factor: 18315746866286265559
  { 301186871, 63, 30451236720ULL },   // factor: 18343025411554206241
  { 301516823, 63, 30419107117ULL },   // factor: 18343745072829058583
  { 301028341, 63, 30471954939ULL },   // factor: 18345844084627852399
  { 301421993, 63, 30511984203ULL },   // factor: 18393966177705553159
  { 300524597, 63, 30611066115ULL },   // factor: 18398756615901461311
  { 301400761, 63, 30534598383ULL },   // factor: 18406302378931138927
  { 300607829, 64, 30711601315ULL },   // factor: 18464295592831390271
  { 301828169, 64, 30602819551ULL },   // factor: 18473585982631464239
  { 300370307, 64, 30771152460ULL },   // factor: 18485481022308010441
  { 300425711, 64, 30780249885ULL },   // factor: 18494356912917586471
  { 301160369, 64, 30719163775ULL },   // factor: 18502789395700865951
  { 301988473, 64, 30647998223ULL },   // factor: 18510684367740966959
  { 301414961, 64, 30733258536ULL },   // factor: 18526927846062714193
  { 300318323, 64, 30873006033ULL },   // factor: 18543458795598885319
  { 301107617, 64, 30802563220ULL },   // factor: 18549772817332093481
  { 301147657, 64, 30836478072ULL },   // factor: 18572666243029354609
  { 300554687, 64, 30921169224ULL },   // factor: 18587004675586705777
  { 301090579, 64, 30864734969ULL },   // factor: 18586161844995514103
  { 300158227, 64, 31025939168ULL },   // factor: 18625381783353470273
  { 300232337, 64, 31096957344ULL },   // factor: 18672624353956865857
  { 300818113, 64, 31037506983ULL },   // factor: 18673288565700766159
  { 300968611, 64, 31093472748ULL },   // factor: 18716318608263826057
  { 300473071, 64, 31149611996ULL },   // factor: 18719239153793119433
  { 300847559, 64, 31136281440ULL },   // factor: 18734548535122009921
  { 301310069, 64, 31149600552ULL },   // factor: 18771376583291116177
  { 301727677, 64, 31211096012ULL },   // factor: 18834502992649448249
  { 301292587, 64, 31297640229ULL },   // factor: 18859493983181364847
  { 300221813, 64, 31417787851ULL },   // factor: 18864610458153187727
  { 301825219, 64, 31285240560ULL },   // factor: 18885349166979365281
  { 301702103, 64, 31321543561ULL },   // factor: 18899551123119617567
  { 300225301, 64, 31507182755ULL },   // factor: 18918506852563768511
  { 301932769, 64, 31350168707ULL },   // factor: 18931286492643319367
  { 301049663, 64, 31553849125ULL },   // factor: 18998551290868189751
  { 300470587, 64, 31628477420ULL },   // factor: 19006854352607291081
  { 301379857, 64, 31551056979ULL },   // factor: 19017706081059744007
  { 300317749, 64, 31682483624ULL },   // factor: 19029624329378084753
  { 300291701, 64, 31773683619ULL },   // factor: 19082747001970691839
  { 301788187, 64, 31658028549ULL },   // factor: 19108038079593901327
  { 301654117, 64, 31698185288ULL },   // factor: 19123776187108061393
  { 301987529, 64, 31701697336ULL },   // factor: 19147034487209045489
  { 300627827, 64, 31919309233ULL },   // factor: 19191665148115653383
  { 300862829, 64, 31949926120ULL },   // factor: 19225090317608386961
  { 300930913, 64, 31952817123ULL },   // factor: 19231180859492846599
  { 300576977, 64, 32062490739ULL },   // factor: 19274493082838232007
  { 301142899, 64, 32116445261ULL },   // factor: 19343278862944703279
  { 301856197, 64, 32042346239ULL },   // factor: 19344361557323586167
  { 300884279, 64, 32161019356ULL },   // factor: 19353490241670208649
  { 300071341, 64, 32253796796ULL },   // factor: 19356880113834446873
  { 301817557, 64, 32086203432ULL },   // factor: 19368359066502511249
  { 301643789, 64, 32137921320ULL },   // factor: 19388408715097362961
  { 301188631, 64, 32207468588ULL },   // factor: 19401046743990446057
  { 301123439, 64, 32300262352ULL },   // factor: 19452732160072937057
  { 300189919, 64, 32418233757ULL },   // factor: 19463253931273791367
  { 300319919, 64, 32418182541ULL },   // factor: 19471651909680668359
  { 300341183, 64, 32428582132ULL },   // factor: 19479277441075084313
  { 301152001, 64, 32358732395ULL },   // factor: 19489794021155544791
  { 300271427, 64, 32458150632ULL },   // factor: 19492510416103183729
  { 301767451, 64, 32313980181ULL },   // factor: 19502614861769777263
  { 301312483, 64, 32421256488ULL },   // factor: 19537858588758279409
  { 300696859, 64, 32498479041ULL },   // factor: 19544381139812064439
  { 300306187, 64, 32595044408ULL },   // factor: 19576987002524304593
  { 300119257, 64, 32637027684ULL },   // factor: 19590000998421021577
  { 300276271, 64, 32633132448ULL },   // factor: 19597910645069082817
  { 301929829, 64, 32456291039ULL },   // factor: 19599044806759004663
  { 301019863, 64, 32591376653ULL },   // factor: 19621303470134917079
  { 300251279, 64, 32730945945ULL },   // factor: 19655016765732227311
  { 301379149, 64, 32641860960ULL },   // factor: 19675152555802246081
  { 301648283, 64, 32676291556ULL },   // factor: 19713494485349596697
  { 300810487, 64, 32768174985ULL },   // factor: 19714021350678135391
  { 300378203, 64, 32853398041ULL },   // factor: 19736889331998600647
  { 300975229, 64, 32789345771ULL },   // factor: 19737561704373813119
  { 301801303, 64, 32702500377ULL },   // factor: 19739314450273182463
  { 300636761, 64, 32882413236ULL },   // factor: 19771324418269137193
  { 300618107, 64, 33028194204ULL },   // factor: 19857746438469703657
  { 301740529, 64, 32954450760ULL },   // factor: 19887386810453704081
  { 301736849, 64, 32960395320ULL },   // factor: 19890731651302293361
  { 301418951, 64, 33004914168ULL },   // factor: 19896613212727195537
  { 301505279, 64, 33077505084ULL },   // factor: 19946084797950676873
  { 300938719, 64, 33155860029ULL },   // factor: 19955764088941125703
  { 300217111, 64, 33261522768ULL },   // factor: 19971356545739366497
  { 300840499, 64, 33257170496ULL },   // factor: 20010207534689435009
  { 300075289, 64, 33349642916ULL },   // factor: 20014807472131005449
  { 300255083, 64, 33393539361ULL },   // factor: 20053159865001643927
  { 301332461, 64, 33290521548ULL },   // factor: 20063029572064739257
  { 301621171, 64, 33275162981ULL },   // factor: 20072987247090141503
  { 300371639, 64, 33492861945ULL },   // factor: 20120611674440755711
  { 301511831, 64, 33403982293ULL },   // factor: 20143391727708016967
  { 301537813, 64, 33406871127ULL },   // factor: 20146869717616850503
  { 301084073, 64, 33484870723ULL },   // factor: 20163522522318589559
  { 300989027, 64, 33498258013ULL },   // factor: 20165216171055646703
  { 300918883, 64, 33530127048ULL },   // factor: 20179696756264494769
  { 300505837, 64, 33589648848ULL },   // factor: 20187771083208651553
  { 301128403, 64, 33532949813ULL },   // factor: 20195447250135677279
  { 300020459, 64, 33662663392ULL },   // factor: 20198975444060673857
  { 301234231, 64, 33634826244ULL },   // factor: 20263922036859916729
  { 300667333, 64, 33726321620ULL },   // factor: 20280806346771278921
  { 301859729, 64, 33664983060ULL },   // factor: 20324205326562381481
  { 300111379, 64, 33885955752ULL },   // factor: 20339121818931404017
  { 301119109, 64, 33799172864ULL },   // factor: 20355153635489316353
  { 300159109, 64, 33912051936ULL },   // factor: 20358022586942970049
  { 300099187, 64, 33926115017ULL },   // factor: 20362399069340382359
  { 301001431, 64, 33833361176ULL },   // factor: 20367780259031685713
  { 301160011, 64, 33883798653ULL },   // factor: 20408890350118530367
  { 301927891, 64, 33816930836ULL },   // factor: 20420549214812693753
  { 301615619, 64, 33881474224ULL },   // factor: 20438363641408609313
  { 301696903, 64, 33923772353ULL },   // factor: 20469394113954245519
  { 300025939, 64, 34149998901ULL },   // factor: 20491770974242986079
  { 301511729, 64, 33982660075ULL },   // factor: 20492341190465039351
  { 301111453, 64, 34057044632ULL },   // factor: 20509932388054740593
  { 301738667, 64, 34013081980ULL },   // factor: 20526124034413841321
  { 300116251, 64, 34213473476ULL },   // factor: 20536038786610116953
  { 300227821, 64, 34211268603ULL },   // factor: 20542349252648808127
  { 301853689, 64, 34057085675ULL },   // factor: 20560513895175610151
  { 301126031, 64, 34142128549ULL },   // factor: 20562167319704318039
  { 300100259, 64, 34299392992ULL },   // factor: 20586513440883969857
  { 300531251, 64, 34350804496ULL },   // factor: 20646980496078608993
  { 300572281, 64, 34371761223ULL },   // factor: 20662397345568919327
  { 300705011, 64, 34357768600ULL },   // factor: 20663106369596909201
  { 300296713, 64, 34444146680ULL },   // factor: 20686928060187725681
  { 301547759, 64, 34376482564ULL },   // factor: 20732302558953548153
  { 301588103, 64, 34406766301ULL },   // factor: 20753342758165834007
  { 301814911, 64, 34395833433ULL },   // factor: 20762350812703438927
  { 301145389, 64, 34477536911ULL },   // factor: 20765502529649906759
  { 301073413, 64, 34503651548ULL },   // factor: 20776264265038186649
  { 301737341, 64, 34430688880ULL },   // factor: 20778049022898936161
  { 300368137, 64, 34618928627ULL },   // factor: 20796846193255915799
  { 300099673, 64, 34671409800ULL },   // factor: 20809757486857990801
  { 301804999, 64, 34504267472ULL },   // factor: 20827120819765385057
  { 300553177, 64, 34690113192ULL },   // factor: 20852447460690421969
  { 300155623, 64, 34743552732ULL },   // factor: 20856945431013624073
  { 300906329, 64, 34666976172ULL },   // factor: 20863025074893985177
  { 301681537, 64, 34596762720ULL },   // factor: 20874409105187801281
  { 300532877, 64, 34750224339ULL },   // factor: 20887169793990186607
  { 300816823, 64, 34723206768ULL },   // factor: 20890649488643716129
  { 301900559, 64, 34622292165ULL },   // factor: 20904978716949640471
  { 301280999, 64, 34769839041ULL },   // factor: 20950983682683363919
  { 300814279, 64, 34847051976ULL },   // factor: 20964981630871930609
  { 301649083, 64, 34843730097ULL },   // factor: 21021158464119102103
  { 300043351, 64, 35046572540ULL },   // factor: 21030982131932363081
  { 300701129, 64, 34976522712ULL },   // factor: 21034959735985083697
  { 301962917, 64, 34885324815ULL },   // factor: 21068148883259770711
  { 300898601, 64, 35041260600ULL },   // factor: 21087732583632841201
  { 300600359, 64, 35080978749ULL },   // factor: 21090709612041541783
  { 301708159, 64, 34955573909ULL },   // factor: 21092763701745647063
  { 301454371, 64, 34991317461ULL },   // factor: 21096571191334144063
  { 301589089, 64, 34983220496ULL },   // factor: 21101115199349536289
  { 301689671, 64, 34989587829ULL },   // factor: 21111994481113228519
  { 301509911, 64, 35033963449ULL },   // factor: 21126174402970486079
  { 300195653, 64, 35200800075ULL },   // factor: 21134254329274147951
  { 300323407, 64, 35234128209ULL },   // factor: 21163266852803376127
  { 300892253, 64, 35179413232ULL },   // factor: 21170425813188983393
  { 301634257, 64, 35283135060ULL },   // factor: 21285204456907500841
  { 300140177, 64, 35472682027ULL },   // factor: 21293554124496997559
  { 301443809, 64, 35328984919ULL },   // factor: 21299407564173832943
  { 301377317, 64, 35344756704ULL },   // factor: 21304215890938566337
  { 300454577, 64, 35571943080ULL },   // factor: 21375506222338954321
  { 300464147, 64, 35593945612ULL },   // factor: 21389409013347945929
  { 301538047, 64, 35548295585ULL },   // factor: 21438327249759244991
  { 301030043, 64, 35707942180ULL },   // factor: 21498326739773827481
  { 301120121, 64, 35718122283ULL },   // factor: 21510890607499512487
  { 300375721, 64, 35869893203ULL },   // factor: 21548890066088248727
  { 300531061, 64, 35864792883ULL },   // factor: 21556968515346477727
  { 301221647, 64, 35789203233ULL },   // factor: 21560965485323969503
  { 300854641, 64, 35857578260ULL },   // factor: 21575837669083409321
  { 301841951, 64, 35771844304ULL },   // factor: 21594886551175194209
  { 301572811, 64, 35822149353ULL },   // factor: 21605972552892082567
  { 301553209, 64, 35832705644ULL },   // factor: 21610934748201223193
  { 300221263, 64, 36008212541ULL },   // factor: 21620862094862918567
  { 300507799, 64, 36078216137ULL },   // factor: 21683570646352304927
  { 301705109, 64, 35942956756ULL },   // factor: 21688347371702532809
  { 300453017, 64, 36097602712ULL },   // factor: 21691267282575564209
  { 301956043, 64, 35957674940ULL },   // factor: 21715274480725324841
  { 301333247, 64, 36050825952ULL },   // factor: 21726624882296052289
  { 300928813, 64, 36144792047ULL },   // factor: 21754018733671100423
  { 300801583, 64, 36197368005ULL },   // factor: 21776451192675103831
  { 301592311, 64, 36129352068ULL },   // factor: 21792669570241498297
  { 301771429, 64, 36132072816ULL },   // factor: 21807254492832748129
  { 301449149, 64, 36184323475ULL },   // factor: 21815467037358945551
  { 300834631, 64, 36267682808ULL },   // factor: 21821149949539447697
  { 300081217, 64, 36395197199ULL },   // factor: 21843030136861822367
  { 301826911, 64, 36185259801ULL },   // factor: 21843370378936609423
  { 300127301, 64, 36418384495ULL },   // factor: 21860302890529195991
  { 301585721, 64, 36254206579ULL },   // factor: 21867502060821316919
  { 300330253, 64, 36454701603ULL },   // factor: 21896899510936991119
  { 300813379, 64, 36397902617ULL },   // factor: 21897952149465425687
  { 300909047, 64, 36479324617ULL },   // factor: 21953917611410219999
  { 300994949, 64, 36500091936ULL },   // factor: 21972686621543262529
  { 300151777, 64, 36612748823ULL },   // factor: 21978763240156216943
  { 301952951, 64, 36392423269ULL },   // factor: 21977599200231233639
  { 301938017, 64, 36434401432ULL },   // factor: 22001861837920080689
  { 300902383, 64, 36587703708ULL },   // factor: 22018654468470272329
  { 301100509, 64, 36636060659ULL },   // factor: 22062273024359550863
  { 300319169, 64, 36848960007ULL },   // factor: 22132898095632948367
  { 301931653, 64, 36672124148ULL },   // factor: 22144950126053713289
  { 301901161, 64, 36702313623ULL },   // factor: 22160942188339632607
  { 301525729, 64, 36799095015ULL },   // factor: 22191747901876281871
  { 300504487, 64, 36928661237ULL },   // factor: 22194456801242940839
  { 300246143, 64, 36998429053ULL },   // factor: 22217271240444785159
  { 301768007, 64, 36838551229ULL },   // factor: 22233392370285461207
  { 301875503, 64, 36831941625ULL },   // factor: 22237321809027024751
  { 300338399, 64, 37076286397ULL },   // factor: 22270864994680916807
  { 300263981, 64, 37110639984ULL },   // factor: 22285976998107232609
  { 301259779, 64, 37047276104ULL },   // factor: 22321708423286042033
  { 300778927, 64, 37109624673ULL },   // factor: 22323586181035331743
  { 301123763, 64, 37101935821ULL },   // factor: 22344549058008028847
  { 301177213, 64, 37095428628ULL },   // factor: 22344595618442907529
  { 300239573, 64, 37257387232ULL },   // factor: 22372284067262663873
  { 301621843, 64, 37107200192ULL },   // factor: 22384684220961987713
  { 300855053, 64, 37231440016ULL },   // factor: 22402533718560001697
  { 300175787, 64, 37347155532ULL },   // factor: 22421423608059007369
  { 300142861, 64, 37460885856ULL },   // factor: 22487234912828548033
  { 301826003, 64, 37253396301ULL },   // factor: 22488087407411629807
  { 300417281, 64, 37451560204ULL },   // factor: 22502191771386970649
  { 301479797, 64, 37321880487ULL },   // factor: 22503585905758042279
  { 301214191, 64, 37405468541ULL },   // factor: 22534115891106530663
  { 301327303, 64, 37399212653ULL },   // factor: 22538807766103929719
  { 300544817, 64, 37523875380ULL },   // factor: 22555212518425810921
  { 301335071, 64, 37441252389ULL },   // factor: 22564724893936469239
  { 301188763, 64, 37474050128ULL },   // factor: 22573525605304623329
  { 301580897, 64, 37433743687ULL },   // factor: 22578603998387094479
  { 301865059, 64, 37427660885ULL },   // factor: 22596206122565034431
  { 301877123, 64, 37544107401ULL },   // factor: 22667414255633774647
  { 301961251, 64, 37586036729ULL },   // factor: 22699053341641575959
  { 301339931, 64, 37679680440ULL },   // factor: 22708784607783299281
  { 300691409, 64, 37779532324ULL },   // factor: 22719961611729209033
  { 301270919, 64, 37709218152ULL },   // factor: 22721381614849043377
  { 301926557, 64, 37659364359ULL },   // factor: 22740724439442763927
  { 300593413, 64, 37836733263ULL },   // factor: 22746945576591593239
  { 300945793, 64, 37812227612ULL },   // factor: 22758861647579672633
  { 301978139, 64, 37708523112ULL },   // factor: 22774299267600497137
  { 300943127, 64, 37962808425ULL },   // factor: 22849292554242889951
  { 301485641, 64, 37926720139ULL },   // factor: 22868723064268048199
  { 301019723, 64, 38061173293ULL },   // factor: 22914327683427715679
  { 300312373, 64, 38167209747ULL },   // factor: 22924170659820599263
  { 300918509, 64, 38124559744ULL },   // factor: 22944771348891803393
  { 301767859, 64, 38033138460ULL },   // factor: 22954357528249514281
  { 301097267, 64, 38135368288ULL },   // factor: 22964910335110537793
  { 300910241, 64, 38221967340ULL },   // factor: 23002762807547057881
  { 300967663, 64, 38307297905ULL },   // factor: 23058515852625292031
  { 300978661, 64, 38415386124ULL },   // factor: 23124422954798999929
  { 301538093, 64, 38343349011ULL },   // factor: 23123960680020752047
  { 300654293, 64, 38493278392ULL },   // factor: 23146338800397873713
  { 300970559, 64, 38515862649ULL },   // factor: 23184281423673501583
  { 300018757, 64, 38641839059ULL },   // factor: 23186553045350459327
  { 301259173, 64, 38496477071ULL },   // factor: 23194833691645844567
  